' GPS Plotter V0.5
' By The Sasquatch www.TheBackShed.com
' For PicoMiteVGA or PicoMite with LCD minimum 320X240
' and probably other 'Mites with little or no modificaton

' Expects GPS NMEA messages on COM1: GP1,GP0
' PPS signal on Pin GP2 (Pin 4)
' Press "Q" to quit
' Press "U" key to sync time
' Press "R" to Refresh (Clear) Plot and recenter
' Press "S" to Save as .BMP
' Set PPSPin to 0 if not available but timing will be less precise

Parameters:
  PPSPin = 4     'Pin Number for PPS strobe.  Set 0 for No PPS
  UTCOffset = -6 'Local Offset from GMT
  UseFeet = 0    'Set to 1 for feet and MPH, 0 for meters and KPH

Setup:
  If MM.Device$ = "PicoMiteVGA" Then MODE 1 'Mode 1 or 2 on PicoMiteVGA
  Update = 0
  Reset = 1
  XMid = MM.HRes/2
  YMid = MM.VRes/2
  X = XMid
  Y = UMid
  White = RGB(255,255,255)

Start:
  CLS

  SetPin GP1,GP0,COM1
  Open "com1:9600" As GPS, UTCOffset

  Pause 1000

  If PPSPin Then
    SetPin PPSPin,INTH,PPS
  Else
    SetTick 1000,PPS
  EndIf

  'Make a cursor sprite
  'Sprite Transparency not working in mode 1
  'Line 10,0,10,20
  'Line 0,10,20,10
  'Circle 10,10,5
  'Sprite Read #1,0,0,20,20
  CLS

  Do

    K$ = Inkey$
    If K$ = "u" Or K$ = "U" Then Update = 1  'If U key pressed update time
    If K$ = "r" Or K$ = "R" Then Reset = 1 'If R key pressed Refresh screen
    If K$ = "s" Or K$ = "S" Then Save Image "GPSPlot.BMP"
  Loop While (K$ <> "Q") And (K$ <> "q")

  If PPSPin Then SetPin PPSPin,OFF

  End


  'The PPS pulse is at the start of the new second BEFORE -
  '  the time is transmited in the NMEA messages -
  '  we need to add one second to the last time parsed by the -
  '  GPS functions
Sub PPS()
  If PPSPin Then
    Julian = Epoch(GPS(Date)+" "+GPS(Time))
    GPSTime$ = DateTime$(Julian + 1)
  Else
    GPSTime$ = GPS(Date)+" "+GPS(Time)
  EndIf

  GPSLat = GPS(Latitude)
  GPSLon = GPS(Longitude)

  'Clear the Plot and Recenter on current location
  If Reset Then
    Lat = GPSLat
    Lon = GPSLon
    CLS
    Circle XMid,YMid,100
    Circle XMid,YMid,10
    Print @(0,MM.VRes-12)"U)pdate Clocks  R)eset Plot  S)ave.BMP  Q)uit";
    'Sprite Show #1,XMid-10,YMid-10,1
    Cursor(X,Y)
    Reset = 0
  EndIf

  'Syncornize Date$,Time$ and RTC if available
  If Update Then
    Date$ = Left$(GPSTime$,10)
    Time$ = Right$(GPSTime$,8)
    On Error Skip 1
      RTC SetTime GPSTime$
    Update = 0
  EndIf

  'Print the current parameters
  Print @(0,0);
  Print "Time =  ";GPSTime$;"    RTC = ";Time$
  Print "Sats = ";GPS(Satellites);"  "
  Print "LAT  = ";GPSLat
  Print "LON  = ";GPSLon
  If UseFeet Then
    Print "ALT  = ";Str$(GPS(Altitude)*3.2808,0,2);"ft  "
    Print "Speed= ";Str$(GPS(Speed)*1.1508,2,2);"MPH   "
  Else
    Print "ALT  = ";Str$(GPS(Altitude),0,2);"m  "
    Print "Speed= ";Str$(GPS(Speed)*1.852,2,2);"KPH   "
    'Print "Speed= ";Str$(GPS(Speed),2,2);"Knots   "
  EndIf


  'Plot the new position
  Cursor(X,Y)
  X = (GPSLon-Lon)*Cos(Rad(GPSLat))*365228.16+XMid
  Y = (GPSLat-Lat)*364173.228+YMid
  'Sprite Hide #1
  Pixel X,Y
  'Sprite Show #1,X-10,Y-10,1
  Cursor(X,Y)
End Sub

'XOR the cursor on/off screen
Sub Cursor(X,Y)
  For i = -5 To 5
    Pixel X+i,Y,White Xor Pixel(X+i,Y)
    Pixel X,Y+i,White Xor Pixel(X,Y+i)
  Next i
End Sub
