option explicit

' global const values
const SHOWFPS = 0
const PORTEMPTY = 0
const PORTNUNCHUK = 1
const PORTCLASSIC = 2
const DUP = 35
const DDOWN = 36
const DLEFT = 38
const DRIGHT = 40
const DFIRE = 32
const UFOSPEED = 6
const TANKSPEED = 2
const SHOTSPEED = 4
const BOMBSPEED = 2
const DELAYBETWEENSHOTS = 40
const MAXSHOTS = 10
const MAXUFOS = 10
const MAXBOMBS = 30
const MAXHISCORE = 20

' HiScores
dim ATHSName(MAXHISCORE) as string   ' All Time HiScore Name
dim ATHSScore(MAXHISCORE) as integer ' All Time HiScore Score
dim HSName(MAXHISCORE) as string     ' Daily HiScore Name
dim HSScore(MAXHISCORE) as integer   ' Daily HiScore Score
dim ATEntry as integer               ' actual all time HiScore entry
dim HSEntry as integer               ' actual daily HiScore entry

' global variables
dim CPort(3) as integer     ' Flags: Controllertype in port #1, 2, 3
dim Ende as integer         ' Flag : End program? 
dim GoLeft as integer       ' Flag : Move tank right?
dim GoRight as integer      ' Flag : Move tank left?
dim Fire as integer         ' Flag : Fire canon?
dim DoPause as integer      ' Flag : Pause requested by player?
dim CanPause as integer     ' Flag : Pause enabled?
dim MoveDelay as integer    ' Counter to slow down movement
dim Lives as integer        ' remaining tanks
dim Score as integer        ' actual score
dim fh as integer           ' Font height in pixel
dim fw as integer           ' Font width in pixel  
dim fc as integer           ' Frame Counter
dim isHit as integer        ' Flag: Tank hit by bomb
dim SSFlag as integer       ' Flag to indicate ScreenShot must be taken
 
' Tank
dim tx as integer           ' Tank x position
dim ty as integer           ' Tank y position

dim grTank(2) as string = ("", "|ooo|", "/ \")         ' Tank "graphics"
dim grTankEmpty(2) as string = ("", "     ", "   ")    ' "Graphics" to clear tank

' UFO
dim grUfo as string = "<=>"       ' UFO "graphics"
dim grUfoEmpty as string = "   "  ' "Graphics" to clear UFO
dim ux(MAXUFOS) as integer        ' UFO x position
dim uy(MAXUFOS) as integer        ' UFO y position
dim uc(MAXUFOS) as integer        ' UFO colour
dim udeltax(MAXUFOS) as integer   ' UFO direction
dim uf(MAXUFOS) as integer        ' Flag : UFO active?
dim ufodelay as integer           ' delay between UFOs

' Shot
dim sf(MAXSHOTS) as integer       ' Tank bullet flag : shot active?
dim sx(MAXSHOTS) as integer       ' Tank bullet x
dim sy(MAXSHOTS) as integer       ' Tank bullet y
'dim sdelay(MAXSHOTS) as integer   ' delay to slow down shot
dim shootdelay as integer         ' delay between two shots

' Bomb
dim bf(MAXBOMBS) as integer       ' UFO bomb flag : bomb active?
dim bx(MAXBOMBS) as integer       ' UFO bomb x
dim by(MAXBOMBS) as integer       ' UFO bomb y
dim bombchance as integer         ' chance to drop a bomb, 1:bombchance

' 640x400, 256 colours
mode 2,8

fh = mm.info(fontheight)
fw = mm.info(fontwidth)

' print to hidden page
page write 1

' initialization 
InitHiScores
InitDigitalJoystick
InitController
ATEntry = 0
HSEntry = 0
Ende = 0

timer = 0
fc = 0

' clear all pending inputs
ClearInput
ClearFire

do
   ' show hiscores and wait for fire or ESC
   ScoreLoop

   ' game loop
   GameLoop   

loop until Ende=1

CloseController

page write 0
end

'
' Main game loop
sub GameLoop
   ' game loop
   if Ende=0 then
      cls

      MoveDelay = 0
      Lives = 3
      Score = 0
      InitRound
      bombchance = 250
      CanPause = 1       

      do
         cls
         colour rgb(cyan)
         text mm.hres / 2, 0, "Tank vs. UFO", "C"
         colour rgb(white) 
         line 0, fh, mm.hres-1, fh


         line 0,mm.vres - fh*4, mm.hres-1, mm.vres - fh*4

         colour rgb(gray)
         text mm.hres/2, mm.vres - fh*2, "Move tank with cursor keys or controller or digital joystick", "C"
         text mm.hres/2, mm.vres - fh, "fire with space or button, ESC to pause/quit", "C"
         colour rgb(white)

         ' get user input
         GetInput

         ' process input
         HandleInput

         ' show tank
         DrawTank

         ' move and test shot
         HandleShots

         ' move and test bomb
         HandleBombs

         ' move or restart UFO
         HandleUFOs

         ' Update status
         ShowStats

         inc fc
         if SHOWFPS then
            colour rgb(brown)
            text mm.hres-1, mm.vres-fh, " FPS : "+str$(int(fc*1000/timer+0.5)), "R"
            colour rgb(white)
         endif

         ' show page
         page copy 1 to 0, B 

         if SSFlag then
            SSFlag = 0
            save image "tvu_screenshot.bmp"
         endif
      loop until Lives = 0 or Ende = 1
   endif

   ' wait until fire button is released
   ClearFire

end sub

'
' Wait until fire buttons released
sub ClearFire
   do
      GetInput
   loop until Fire = 0
end sub

'
' Wait until no keys are pressed
sub ClearInput
   do
   loop until inkey$=""
end sub

'
' Show Scores, enter name for HiScore
sub ScoreLoop
   local Info as string
   local Name as string = ""
   local Key as string
   local EnterName as integer
   local BlinkDelay as integer
   local BlinkOn as integer = 0
   local CInfo as string
   local p as integer

   for p=1 to 3
      select case CPort(p)
         case PORTNUNCHUK
            CInfo = CInfo + "  port #"+str$(p)+" = Nunchuk  "
         case PORTCLASSIC
            CInfo = CInfo + "  port #"+str$(p)+" = Classic  "
      end select
   next
   
   CanPause = 0

   ' check if we have a new Hiscore
   EnterName = Check4HiScore()
   if EnterName then
      ATHSName(ATEntry) = ""
      ATHSScore(ATEntry) = Score
      HSName(HSEntry) = ""
      HSScore(HSEntry) = Score
      BlinkDelay = 25
      BlinkOn = 1
   endif

   ' wait until no keys are pressed
   ClearInput
   
   ' intro loop
   do
      cls
      text mm.hres / 2, 0, "Tank vs. UFO", "C"
      line 0, fh, mm.hres-1, fh

      colour rgb(255, 64, 64)
      text mm.hres / 2, fh*2, "GAME OVER", "C"
     
      if ATEntry>0 or HSEntry>0 then
         if ATEntry>0 then
            colour rgb(green)
         else
            colour rgb(yellow)
         endif
         Info = "Hiscore: "
      else
         colour rgb(160, 160, 160)
         Info = "Last score: "
      endif

      Info = Info + str$(Score)
      text mm.hres / 2, fh*4, Info, "C"

      colour rgb(white)

      line 0,mm.vres - fh*4, mm.hres-1, mm.vres - fh*4

      colour rgb(64, 64, 255)
      if EnterName then
         text mm.hres/2, mm.vres - fh*3, "Enter your name, finish with RETURN key", "C"
      else
         text mm.hres/2, mm.vres - fh*3.5, "Start game with fire or leave game with ESC key", "C"
         text mm.hres/2, mm.vres - fh*2.5, "fire with space or button", "C"
      endif

      colour rgb(64, 255, 64)
      text mm.hres/2, mm.vres - fh, CInfo, "C"
      colour rgb(gray)
      text mm.hres/2, mm.vres - fh*5-fh/2, "(Hint: Higher and faster UFOs give more points!)", "C"
      colour rgb(white)


      ShowHiScores fh*5.5, BlinkOn

      ' enter name for Hiscore
      if EnterName then
         BlinkDelay = BlinkDelay -1 
         if BlinkDelay <=0 then
            BlinkOn = 1-BlinkOn
            BlinkDelay = 25
         endif
         Key=Inkey$
         if key<>"" then
            if key=chr$(145) then
               ' F1
               Name="ASTreas"
            else if key=chr$(149) then
               ' F5
               Name="Schlowski"
            else if Key=chr$(13) then
               ' Input finished
               EnterName = 0
            else if Key=chr$(8) then
               if Name<>"" then
                  Name = Left$(Name, len(Name)-1)
               endif
            else if asc(Key)>=32 and asc(Key)<128 then
               if len(Name)<10 then
                  Name = Name + Key
               endif
            endif
            ATHSName(ATEntry) = Name
            HSName(HSEntry) = Name
            
            ' finished and an AllTime Hiscore? 
            if not EnterName then
               BlinkOn = 0
               if ATEntry>0 then
                  ' yes, save to disk
                  SaveATHiScores
               endif
            endif
         endif
      else
         ' check for Fire or ESC
         GetInput
      endif

      inc fc
      if SHOWFPS then
         colour rgb(brown)
         text mm.hres-1, mm.vres-fh, " FPS : "+str$(int(fc*1000/timer+0.5)), "R"
         colour rgb(white)
      endif

      ' show page
      page copy 1 to 0, B 

      if SSFlag then
         SSFlag = 0
         save image "tvu_screenshot.bmp"
      endif

   loop until Fire=1 or Ende=1


   ' wait until fire button is released
   ClearFire

end sub

'
' Pause loop
sub PauseLoop
   local Key as string

   ' wait until no keys are pressed
   ClearInput
   
   ' intro loop
   do
      cls
      text mm.hres / 2, 0, "Tank vs. UFO", "C"
      line 0, fh, mm.hres-1, fh

      colour rgb(yellow)
      text mm.hres / 2, fh*2, "PAUSE", "C"
      colour rgb(white)
      text mm.hres/2, mm.vres - fh*2, "ESC to quit game, any other key to continue", "C"
      
      Key=inkey$
      if Key<>"" then
         DoPause = 0 
         if Key=chr$(27) then
            Ende = 1
         endif
      endif

      ' show page
      page copy 1 to 0, B 

      inc fc
      text mm.hres-1, mm.vres-fh, " "+str$(int(fc*1000/timer)), "R"

   loop until DoPause = 0
   
end sub

'
' Initialize HiSore Tables
sub InitHiScores
   local i as integer

   for i=1 to MAXHISCORE
      ATHSName(i) = "----------"
      ATHSScore(i) = 0
      HSName(i) = "----------"
      HSScore(i) = 0
   next
   LoadATHiScores
'   for i=1 to MAXHISCORE
'      ATHSName(i) = "(empty)"
'      ATHSScore(i) = 2100-i*100
'   next
'   SaveATHiScores
end sub

'
' Save AllTime-HiScores to file
sub SaveATHiScores
   local i as integer
   local s as string

   open "TvU.hsc" for output as #1
   for i=1 to MAXHISCORE
      print #1, ATHSName(i)
      print #1, ATHSScore(i) 
   next
   close #1
end sub

'
' Show Hi-Scores
sub ShowHiScores y as integer, BlinkOn as integer
   local i as integer
   local x1 as integer = (320-24*fw)/2
   local x2 as integer = x1+320

   colour rgb(green)
   text (320-17*fw)/2, y, "All time HiScores"
   colour rgb(yellow)
   text 320+(320-15*fw)/2, y, "Todays HiScores"
   colour rgb(255,255,255)

   y=y+fh/2

   for i=1 TO MAXHISCORE
      ' all time hiscores
      if i=ATEntry then
         colour rgb(green)
      else
         colour rgb(white)
      endif
      text x1-fw*4, y+i*fh, right$("  "+str$(i)+".", 3)
      text x1, y+i*fh, ATHSName(i)+choice(BlinkOn and (ATEntry=i), "_", " ")
      text x1+fw*12, y+i*fh, right$("............"+str$(ATHSScore(i)), 12)

      ' daily hiscores
      if i=HSEntry then
         colour rgb(yellow)
      else
         colour rgb(white)
      endif
      text x2-fw*4, y+i*fh, right$("  "+str$(i)+".", 3)
      text x2, y+i*fh, HSName(i)+choice(BlinkOn and (HSEntry=i), "_", " ")
      text x2+fw*12, y+i*fh, right$("............"+str$(HSScore(i)), 12)
   next

end sub

'
' Load AllTime-HiScores from file
sub LoadATHIScores
   local i as integer
   local s as string

   on error skip
   open "TvU.hsc" for input as #1

   ' file not found?
   if mm.errno<>0 then
      exit sub
   endif

   for i=1 to MAXHISCORE
      line input #1, ATHSName(i)
      line input #1, s
      ATHSScore(i) = val(s)
   next

   close #1
   
end sub

'
' Check for HiScore - AllTime and Daily
function Check4HiScore() as integer 
   local i as integer
   ATEntry = 0
   HSEntry = 0
   for i=1 to MAXHISCORE
      if ATEntry=0 then
         if ATHSScore(i)<Score then
            ATEntry = i
         endif  
      endif
      if HSEntry=0 then
         if HSScore(i)<Score then
            HSEntry = i
         endif  
      endif
   next

   if (ATEntry>0) and (ATEntry<MAXHISCORE) then
      for i=MAXHISCORE to ATEntry+1 STEP -1
         ATHSName(i) = ATHSName(i-1)
         ATHSSCore(i) = ATHSSCore(i-1)
      next       
   endif

   if (HSEntry>0) and (HSEntry<MAXHISCORE) then
      for i=MAXHISCORE to HSEntry+1 STEP -1
         HSName(i) = HSName(i-1)
         HSSCore(i) = HSSCore(i-1)
      next       
   endif

   Check4HiScore = (ATEntry>0) or (HSEntry>0)
end function

'
' Initialize UFO, shot and bomb flags
sub InitRound
   local i as integer
   for i=1 to MAXBOMBS
      bf(i) = 0
   next
   for i=1 to MAXSHOTS
      sf(i) = 0
   next
   for i=1 to MAXUFOS
      uf(i) = 0
   next
   shootdelay=0

   ' tank starting position
   tx = mm.hres/2
   ty = mm.vres - fh*5

   isHit = 0

   DrawTank

end sub

'
' show status values 
sub ShowStats
   if Lives=3 then
      colour rgb(green)
   else if lives = 2 then
      colour rgb(yellow)
   else
      colour rgb(red)
   endif
   text 0, 0, "Tanks "+str$(Lives)+" ", "L"
   if Score>ATHSScore(MAXHISCORE) then
      colour rgb(green)
   else if Score>HSScore(MAXHISCORE) then
      colour rgb(yellow)
   else
      colour rgb(white)
   endif
   text mm.hres-1, 0, "Score "+str$(Score), "R"
   colour rgb(white)
end sub

'
' handle Player input
sub HandleInput
   local i as integer

   if DoPause then
      PauseLoop
   endif

   if isHit then
      exit sub
   endif

   ' move tank left?
   if GoLeft=1 then
      MoveTank -TANKSPEED
      GoLeft = 0
   endif

   ' move tank right?
   if GoRight=1 then
      MoveTank TANKSPEED
      GoRight = 0
   endif

   ' fire a bullet? 
   if shootdelay>0 then
      shootdelay = shootdelay-1
   else
      if Fire then
         for i=1 to MAXSHOTS
            if sf(i) = 0 then
               sx(i) = tx
               sy(i) = ty - fh
               sf(i) = 1
               shootdelay = DELAYBETWEENSHOTS
               exit for
            endif
         next
         Fire = 0
      endif
   endif
end sub

'
' handle tank shots
sub HandleShots
   local s as integer
   local u as integer

   colour rgb(yellow)
   for s=1 to MAXSHOTS
      if sf(s) = 1 then

         sy(s) = sy(s) - SHOTSPEED

         ' check against UFO
         for u=1 to MAXUFOS
            if CheckShotAgainstUfo (s, u) then
               exit for
            endif
         next
  
         if sy(s) <= fh*2 then
            sf(s) = 0
         endif
            
         if sf(s)=1 then
            text sx(s), sy(s), "^", "C"
         endif

      endif
   next
colour rgb(white)
end sub

'
' clear all shots
sub ClearShots
   local s as integer
   for s=1 to MAXSHOTS
      if sf(s) then
         sf(s) = 0
      endif
   next
end sub

'
' Check if shot #s hits ufo #u
function CheckShotAgainstUfo (s as integer, u as integer) as integer
   local result as integer =  0 

   if uf(u) then
      if CheckCollision(sx(s), sy(s), sx(s)+fw, sy(s)+fh, ux(u)-1.5*fw, uy(u), ux(u)+1.5*fw, uy(u)+fh) then
         ' shot meets UFO :-)
         sf(s) = 0
         uf(u) = 0

         ' calculate score depending on height and speed of UFO 
         Score = Score + ((ty-uy(u))\10) * abs(udeltax(u))

         result = 1
      endif
   endif
   CheckShotAgainstUfo = result
end function

'
' check rectangle overlapping
function CheckCollision (sx1 as integer, sy1 as integer, ex1 as integer, ey1 as integer, sx2 as integer, sy2 as integer, ex2 as integer, ey2 as integer) as integer
   local result as integer = 0

   if ex1 >= sx2 then
      if sx1 <= ex2 then
         if ey1 >= sy2 then
            if sy1 <= ey2 then
               ' collision
               result = 1 
            endif
         endif
      endif        
   endif        
   CheckCollision = result      
end function

'
' handle UFO bombs
sub HandleBombs
   local b as integer
   local r as integer

   for b=1 to MAXBOMBS
      if bf(b) = 1 then
         by(b) = by(b) + BOMBSPEED

         ' check against Tank
         if not isHit then
            if CheckCollision(bx(b)-fw/2, by(b), bx(b)+fw/2, by(b)+fh, tx-2.5*fw, ty, tx+2.5*fw, ty+2*fh) then
               bf(b) = 0
               Lives = Lives - 1
               isHit = 1
            endif
         endif  
         if by(b) >= mm.vres - fh*5 then
            bf(b) = 0
         endif
            
         if bf(b)=1 and not isHit then 
            r = (by(b)/400)*255
            colour rgb(255, 255-r, 255-r)
            text bx(b), by(b), "o", "C"
         endif

      endif
   next
   colour rgb(white)

end sub

'
' handle all UFOs
sub HandleUFOs
   local u as integer
   local cnt as integer = 0

   for u=1 to MAXUFOS
      HandleUFO u
      if uf(u) then
         cnt = cnt + 1
      endif
   next

   ' all UFOs left screen, let tank reappear
   if isHit and cnt=0 then
      ClearShots
      isHit = 0
      if Lives>0 then
         InitRound
      else
         GameOver = 1
      endif
   endif
end sub

'
' handle UFO
sub HandleUFO u as integer
   local i as integer
   if uf(u) = 1 then
      if isHit then
         if udeltax(u)<0 then
            udeltax(u)=udeltax(u)-1
         else
            udeltax(u)=udeltax(u)+1
         endif 
      endif
      ux(u) = ux(u) + udeltax(u)
      if ux(u)>-12 and ux(u)<(mm.hres+12) then
         DrawUFO u
         if isHit = 0 and int(rnd()*BOMBCHANCE) = 0 then
            for i=1 to MAXBOMBS
               if bf(i) = 0 then
                  bf(i) = 1
                  bx(i) = ux(u)
                  by(i) = uy(u)+fh
                  exit for
               endif
            next
         endif
      else
         uf(u) = 0
         if isHit = 0 and bombchance > 10 then
            bombchance = bombchance - 1
         endif
      endif
   else
      if isHit = 0 and ufodelay=0 then
         uf(u) = 1
         uy(u) = fh*2 + rnd()*(mm.vres-fh*10)
         uc(u) = rgb(64+rnd()*191, 64+rnd()*191, 64+rnd()*191)
         udeltax(u) = rnd()*UFOSPEED-(UFOSPEED/2)
         if udeltax(u)=0 then
            udeltax(u)=1
         endif
         if udeltax(u)>0 then
            ux(u)=-12
         else
            ux(u)=mm.hres+12
         endif
         ufodelay = 40
      else
         if ufodelay>0 then
            ufodelay=ufodelay-1
         endif
      endif
   endif
end sub

'
' draw UFO
sub DrawUFO u as integer
   colour uc(u)
   text ux(u), uy(u), grUfo, "C"
   colour rgb(white) 
end sub

' move tank to left or right
'
sub MoveTank DeltaX as integer
   ' check if new position is in bounds
   if tx+DeltaX<24 then
      exit sub 
   endif
   if tx+DeltaX>mm.hres-24 then
      exit sub 
   endif

   tx = tx + DeltaX
end sub


' draw tank to screen
'
sub DrawTank
   if not isHit then
      text tx, ty, grTank(1), "C"
      text tx, ty-fh, grTank(2), "C"
      if shootdelay=0 then
         text tx, ty-fh, "^", "C"
      else
         text tx, ty-fh, " ", "C"
      endif
   endif
end sub


' check for user input
'
sub GetInput
   local i as integer
   local jx as integer
 
   ' reset all flags
   GoLeft = 0
   GoRight = 0
   Fire = 0

   ' decrease movement delay 
   if MoveDelay > 0 then
      MoveDelay = MoveDelay - 1
   endif

   ' check all pressed keys
   local KeyCount as integer = keydown(0)
   if keycount>0 then
      for i=1 to KeyCount
         select case KeyDown(i)
            case 157
               SSFlag = 1
            case 130
               if MoveDelay = 0 then
                  GoLeft = 1
               end if
            case 131
               if MoveDelay = 0 then
                  GoRight = 1
               endif
            case 32
               Fire = 1
            case 27
               if CanPause then
                  DoPause = 1
               else
                  Ende = 1
               endif
         end select
      next
   endif  

   ' check digital joystick
   ' active pins read as value 0!
   if MoveDelay = 0 then
      if pin(DLEFT) = 0 then
         GoLeft = 1
      end if
      if pin(DRIGHT) = 0 then
         GoRight = 1
      end if
   endif
   if pin(DFIRE) = 0 then 
      Fire = 1
   endif

   ' check controllers and nunchuks
   for i=1 to 3
      if CPort(i) = PORTCLASSIC then
         if MoveDelay = 0 then
            jx = classic(lx, i)
            if jx < 64 then
               GoLeft = 1
            endif
            if jx > 192 then
               GoRight = 1
            endif
            jx = classic(rx, i)
            if jx < 64 then
               GoLeft = 1
            endif
            if jx > 192 then
               GoRight = 1
            endif
         endif
         ' Button and digital joystick test
         jx = classic(B, i)
         if jx <> 0 then
            if MoveDelay = 0 then
               if jx and 64 then
                  GoRight = 1
               endif
               if jx and 256 then
                  GoLeft = 1
               endif
            endif
            if jx and &b0011111000011111 then
               Fire = 1
            endif 
         endif
      else if CPort(i) = PORTNUNCHUK then 
         if MoveDelay = 0 then
            jx = nunchuk(jx, i)
            if jx < 64 then
               GoLeft = 1
            endif
            if jx > 192 then
               GoRight = 1
            endif
         endif
         if nunchuk(Z, i) then
            Fire = 1
         endif
      endif  
   next

   ' Set delay for next movement if a move is initiated right mow
   if GoLeft=1 or GoRight=1 then
      MoveDelay = 0
   endif 

end sub

'
' Initialize Atari-style joystick
sub InitDigitalJoystick
   setpin DUP, din, pullup
   setpin DDOWN, din, pullup
   setpin DLEFT, din, pullup
   setpin DRIGHT, din, pullup
   setpin DFIRE, din, pullup
end sub

sub InitController
   local p as integer
   for p=1 to 3
      CPort(p) = PORTEMPTY
      ' first check for nunchuk - this works for classic controller, too! 
      on error skip
      controller nunchuk open p
      if mm.errno = 0 then
         ' now check if we really have a nunchuk
         ' if both center values are 255 it's not a Nunchuk but a classic controller
         if NUNCHUK(JXC, p)=255 and NUNCHUK(JYC, p)=255 then
            controller nunchuk close p
            on error skip
            controller classic open p
            if mm.errno = 0 then
               CPort(p)=PORTCLASSIC     
            endif
         else       
            CPort(p)=PORTNUNCHUK    
         endif     
      endif  
   next  
end sub

sub CloseController
   local p as integer
   for p=1 to 3
      select case CPort(p)
         case PORTNUNCHUK
            controller nunchuk close p
         case PORTCLASSIC
            controller classic close p
      end select
   next   
end sub

