'MMEDIT!!! Basic Version = Micromite_MK2_V5.2
'MMEDIT!!! Port = 10.1.1.74:3001:10,300
'MMEDIT!!! Device = Micromite_Plus_V5.3
'MMEDIT!!! Config = 100111101121010110020000100001
  ' RTVmonitor
  ' Feb 2017
  OPTION EXPLICIT
  OPTION CLOCKTRIM -3
  'option break 0 ' turn off break key so we can talk to other devices on the bus.
  DIM myName$ = "$9"
  DIM thisTime$, readTime$, thisTS, oldTS, TScount, readAV
  DIM PVampsRaw, LoadampsRaw, BatVoltsRaw, PVamps, Loadamps, Mainsamps, BatVolts, readNow
  DIM PVZero, LoadZero, RefZero, BatVscale, BatCharge, BatEff, PVmax, PVmaxA, BatTemp
  DIM k$, cmd$, opt$, RefZeroRaw, Charger = -1, ChargeTime = 7200000, Nap = -1, NapTime = 300000
  oldTS = 99
  PVZero = -0.0025
  LoadZero = 0.00242
  BatVscale = 5.366 '(12+2.7)/2.7
  readAv = 100
  BatCharge = 100
  BatEff = 0.99
  DIM records(99,7)
  DIM yesterday(99,7)
  DIM daily(8,7)
  DIM solar(readAv+1)
  DIM INTEGER xmitpin  = 18 ' the pin connected to the 433mhz module data pin
  DIM FLOAT lengths(68)
  
  PIN(xmitpin)=0                ' set the data pin low
  SETPIN xmitpin, DOUT          ' set it as an output
  SETPIN 23, AIN ' reference zero and AC amps
  SETPIN 24, AIN ' BatVolts
  SETPIN 25, AIN ' LoadAmps
  SETPIN 26, AIN ' PVamps
  
  SETTICK 10000, readTimeX ' read every 10 seconds
  
  records(99,4) = PIN(24) * BatVscale ' set some initial values
  daily(8,4) = records(99,4)
  daily(8,5) = daily(8,4)
  doread
  doReadOut
  DO
    IF readNow = 1 THEN doread
    IF Nap = -1 THEN
      k$=INKEY$
      IF k$<>"" THEN doKey
    ELSE
      k$ = INPUT$(255,#0) ' flush input buffer
      IF (TIMER - Nap) > NapTime THEN ' time to wake up again
        Nap = -1
      ENDIF
    ENDIF
  LOOP
END
  
SUB doKey
  cmd$ = ""
  DO
    PAUSE 50
    cmd$ = cmd$+k$
    k$=INKEY$
  LOOP UNTIL k$="" OR k$ = CHR$(13) OR LEN(cmd$)>=255
  DoCMD
END SUB
  
SUB DoCMD
  LOCAL cm$, newDate$, newTime$, sendNowTime$, n, sendNow, toSend, startSend
  PRINT cmd$
  IF LEFT$(cmd$,2)=myName$ OR LEFT$(cmd$,2)= "$0" THEN
    cm$ = UCASE$(MID$(cmd$,3,2))
    opt$= MID$(cmd$,5)
    SELECT CASE cm$
      CASE "Z5"
        ' nap for a while
        Nap = TIMER
      CASE "P1"
        sendit(1)
        Charger = TIMER
        PRINT"Charger on"
      CASE "P0"
        sendit(0)
        Charger = -1
        PRINT "Charger off"
      CASE "ST"
        ' set time
        newDate$= LEFT$(opt$,10) ' should really do some error checking here
        newTime$= MID$(opt$,12)
        PRINT opt$
        DATE$= newDate$
        TIME$= newTime$
      CASE "MM"
        PRINT "Report"
        MEMORY
        PRINT "EOT"
      CASE "LL"
        ' send last x readings
        toSend = VAL(opt$)
        IF toSend = 0 THEN toSend = 96
        PRINT "sending "+STR$(toSend,3,0)+" lines"
        startSend = (thisTS - toSend + 96) MOD 96
        FOR n = 1 TO toSend
          sendNow = (startSend + n) MOD 96
          sendNowTime$=STR$(INT(sendNow/4),2,0,"0")+":"+STR$((sendNow/4 - INT(sendNow/4))*60,2,0,"0")
          PRINT sendNowTime$+","+STR$(records(sendNow,1),3,2," ")+","+STR$(records(sendNow,2),3,2," ");
          PRINT ","+STR$(records(sendNow,3),3,2," ")","+STR$(records(sendNow,4),3,2," ");
          PRINT ","+STR$(records(sendNow,5),4,2," ")+","+STR$(records(sendNow,6),3,2," ");
          print ","+STR$(records(sendNow,7),3,2," ")
          pause 50
        next n
        print "EOT"
      case "LY"
        ' send last x readings from previous day
        toSend = val(opt$)
        if toSend = 0 then toSend = 96
        print "sending "+str$(toSend,3,0)+" lines"
        startSend = (thisTS - toSend + 96) mod 96
        for n = 1 to toSend
          sendNow = (startSend + n) mod 96
          sendNowTime$=str$(int(sendNow/4),2,0,"0")+":"+str$((sendNow/4 - int(sendNow/4))*60,2,0,"0")
          print sendNowTime$+","+str$(yesterday(sendNow,1),3,2," ")+","+str$(yesterday(sendNow,2),3,2," ");
          print ","+str$(yesterday(sendNow,3),3,2," ")+","+str$(yesterday(sendNow,4),3,2," ");
          print ","+str$(yesterday(sendNow,5),4,2," ")+","+str$(yesterday(sendNow,6),3,2," ");
          print ","+str$(yesterday(sendNow,7),3,2," ")
          pause 50
        next n
        print "EOT"
      case "LW"
        'toSend = val(opt$)
        toSend = 8
        print "sending   8 lines"
        for n = 1 to toSend
          print str$(daily(n,1),3,2," ")+","+str$(daily(n,2),3,2," ");
          print ","+str$(daily(n,3),3,2," ")+","+str$(daily(n,4),3,2," ");
          print ","+str$(daily(n,5),3,2," ")+","+str$(daily(n,6),3,2," ")
          'pause 50
        next n
        print "EOT"
      case "PV"
        ' send recent set of PV amps readings before averaging
        print "sending "+str$(readAv)+" lines"
        for n = 1 to readAv
          print str$((RefZero + PVZero - solar(n))*1000/66,4,2," ")
          'pause 50
        next n
        print "EOT"
      case "BC"
        ' set battery charge level
        n = val(opt$)
        if n < 105 and n > 50 then
          BatCharge = n
          print "Battery charge set to "+str$(n)
        endif
      case else
        doReadOut
    end select
  endif
end sub
  
SUB Doread
  local n, k
  BatTemp = tempr(14)
  readNow = 0
  PVampsRaw = 0
  LoadampsRaw = 0
  BatVoltsRaw = 0
  RefZeroRaw = 0
  for n = 1 to readAv
    solar(n) = pin(26)
    PVampsRaw = solar(n) + PVampsRaw
    LoadampsRaw = pin(25) + LoadampsRaw
    BatVoltsRaw = pin(24) + BatVoltsRaw
    RefZeroRaw = pin(23) + RefZeroRaw
    if PVmax > solar(n) or n = 1 then PVmax = solar(n)
    pause 5
  next n
  RefZeroRaw = RefZeroRaw / readAv
  PVampsRaw = PVampsRaw / readAv
  LoadampsRaw = LoadampsRaw / readAv
  BatVoltsRaw = BatVoltsRaw /readAv
  if RefZero = 0 then RefZero = RefZeroRaw ' this is the first reading
  PVamps = (RefZero + PVZero - PVampsRaw)*1000/66
  PVmaxA = (RefZero + PVZero - PVmax)*1000/66
  Loadamps = (LoadampsRaw - RefZero - LoadZero)*1000/66
  Mainsamps = (RefZero - RefZeroRaw)*1000/66
  BatVolts = BatVoltsRaw * BatVscale
  if (PVamps + LoadAmps) > 0 then ' charging
    BatCharge = BatCharge + (PVamps + LoadAmps)*BatEff/360
  else
    BatCharge = BatCharge + (PVamps + LoadAmps)/360
  endif
  if BatCharge > 105 then BatCharge = 105
  
  thisTime$= time$
  ThisTS = int(val(left$(thisTime$,2))*4+val(mid$(thisTime$,4,2))/15)
  if thisTS <> oldTS then
    ' new time slot
    if thisTS = 0 then ' new day
      for n = 1 to 7
        for k = 1 to 6
          daily(n,k) = daily(n+1,k)
        next k
      next n
      daily(8,1) = records(oldTS,1)/4
      daily(8,2)= records(oldTS,2)/4
      daily(8,3)= records(oldTS,3)/4
      daily(8,4) = records(oldTS,4)
      daily(8,5) = records(oldTS,4)
      daily(8,6) = 0
    else
      daily(8,1) = daily(8,1) + records(oldTS,1)/4
      daily(8,2) = daily(8,2) + records(oldTS,2)/4
      daily(8,3) = daily(8,3) + records(oldTS,3)/4
      if daily(8,4) > records(oldTS,4) then daily(8,4) = records(oldTS,4)
      if daily(8,5) < records(oldTS,4) then daily(8,5) = records(oldTS,4)
      if daily(8,6) < records(oldTS,6) then daily(8,6) = records(oldTS,6)
    endif
    oldTS = thisTS
    TScount = 1
    yesterday(thisTS,1)=records(thisTS,1)
    yesterday(thisTS,2)=records(thisTS,2)
    yesterday(thisTS,3)=records(thisTS,3)
    yesterday(thisTS,4)=records(thisTS,4)
    yesterday(thisTS,5)=records(thisTS,5)
    yesterday(thisTS,6)=records(thisTS,6)
    yesterday(thisTS,7)=records(thisTS,7)
    '
    records(thisTS,1)=PVamps
    records(thisTS,2)=Loadamps
    records(thisTS,3)=Mainsamps
    records(thisTS,4)=BatVolts
    records(thisTS,5)=BatCharge
    records(thisTS,6)=PVmaxA
    records(thisTS,7)=BatTemp
  else
    records(thisTS,1)=(records(thisTS,1)*TScount +PVamps)/(TScount+1)
    records(thisTS,2)=(records(thisTS,2)*TScount +Loadamps)/(TScount+1)
    records(thisTS,3)=(records(thisTS,3)*TScount +Mainsamps)/(TScount+1)
    records(thisTS,4)=(records(thisTS,4)*TScount +BatVolts)/(TScount+1)
    records(thisTS,5)=(records(thisTS,5)*TScount +BatCharge)/(TScount+1)
    records(thisTS,6)=(records(thisTS,6)*TScount +PVmaxA)/(TScount+1)
    records(thisTS,7)=(records(thisTS,7)*TScount +BatTemp)/(TScount+1)
    TScount = TScount + 1
  endif
  readTime$=time$
  if Charger = -1 then ' not charging from mains
    if BatVolts < 12 then
      sendit(1)
      Charger = timer
    endif
    if Mainsamps > 1 then ' charger didn't turn off
      sendit(0)
      else ' it is safe to use the Mainsamps reading as zero.
      RefZero = RefZeroRaw
    endif
  else ' we are charging from the mains
    if (timer - Charger) > ChargeTime then
      ' turn charge off after preset time
      sendit(0)
      Charger = -1
    endif
    if Mainsamps < 0.5 then ' we are not charging
      sendit(1)
    endif
  endif
END SUB
  
sub doReadOut
  ' send latest readings
  PRINT readTime$+","STR$(thisTS,3,0," ")+","+STR$(RefZeroRaw,3,4," ")+","+STR$(PVampsRaw,3,4," ");
  print ","+STR$(LoadampsRaw,3,4," ")+","+STR$(BatVoltsRaw,3,4," ")+","+STR$(PVamps,3,2," ");
  PRINT ","+STR$(Loadamps,3,2," ")+","+STR$(Mainsamps,3,2," ")+","+STR$(BatVolts,3,2," ");
  print ","+STR$(BatCharge,3,2," ")+","+STR$(PVmaxA,3,2," ")+","+STR$(BatTemp,3,2," ")
END SUB
  
sub readTimeX
  readNow = 1
end sub
  
  ' ARLEC code by disco4now
  ' Bitbanger CSUB by matherp
  
sub sendit(code as integer)
  local integer numberofbitsincode=32            'number of bits in the code.
  local integer pulsecount=numberofbitsincode*2  'number of inversions in the code ie. 1 down + 1 up per bit in the code
  local float pulselength=270                    'the number of microseconds for the basic short pulse length A long is 3 times this
  local integer repeat=15                        'number of times to repeat the transmission
  local integer senddata%
  
  if code >= 0 and code <10 then
    select case code
      case 0
        senddata% = &B01000011000010000000111001000010    ' A off  ARLEC RC210
      case 1
        senddata% = &B01000011000010000000111101000011    ' A on
      case 2
        senddata% = &B01000011000010000000110001000000    ' B off  ARLEC RC210
      case 3
        senddata% = &B01000011000010000000110101000001    ' B on
      case 4
        senddata% = &B01000011000010000000101001000100    ' C off  ARLEC RC210
      case 5
        senddata% = &B01000011000010000000101101000101    ' C on
      case 6
        senddata% = &B01000011000010000000011001001100    ' D off  ARLEC RC210
      case 7
        senddata% = &B01000011000010000000011101001101    ' D on
      case 8
        senddata% = &B01000011000010000000100001000111    ' ALL off  for 10 secs to reset
      case 9
        senddata% = &B01000011000010000000010001001111    ' ALL on
    end select
    SEND433MHZ(pulsecount,pulselength,repeat,xmitpin,senddata%)
  endif
end sub
  
SUB SEND433MHZ(pulsecount as integer,pulselength as float,repeat as integer ,thexmitpin as integer,senddata% as integer)
  local integer savedata%=senddata%
  local integer long,short
  local integer repeatpause,j,i
  'long=pulselength*3-.15 'fudge for Mx170 at 48 MHz
  short=pulselength
  long=pulselength*3
  repeatpause=long*10/1000   'is millseconds so divide by 1000
  for j=0 to repeat-1
    senddata%=savedata%
    for i=0 to pulsecount-1 step 2
      if senddata% and &H80000000 then
        'One
        lengths(i)=long
        lengths(i+1)=short
      ELSE
        'Zero
        lengths(i)=short
        lengths(i+1)=long
      END if
      senddata%=senddata%<<1
    next i
    ' send the stop bits
    lengths(pulsecount)=short
    lengths(pulsecount+1)=long
    ' Call the CFunction
    bitbanger(thexmitpin,66,lengths())
    pause repeatpause    ' pause between repetitions
  next j
END SUB
  
CSub bitbanger integer,integer,float  'pin number, number of bits, floating point array of bit lengths in usec
  00000000
  27BDFFC0 AFBF003C AFBE0038 AFB70034 AFB60030 AFB5002C AFB30024 AFB20020
  AFB1001C AFB00018 AFB40028 3C109D00 8E030000 00808821 8E020080 8C640000
  00A09021 00002821 00C0B021 0040F809 8E140064 00409821 8E02009C 3C0449F4
  0040F809 24842400 00402821 0280F809 02602021 0040B821 8E240000 8E020024
  24050007 0040F809 241E0001 AFA20010 8E020028 0040F809 8E240000 8E520000
  8E030040 005EF004 0060F809 00122080 AFA20014 12400013 0040A821 0000A021
  00008821 3C139D00 0014A080 02D41821 8C640000 8E620058 8E70007C 0040F809
  02E02821 26310001 0200F809 00402021 02B4A021 0232182B AE820000 1460FFF2
  0220A021 8FA30014 3C040008 8C620000 2442FFFD AC620000 3C03BF88 AC641064
  3C03BF88 00001021 AC601068 40824800 8FA50014 8FA30010 2652FFFF AC7E0000
  8CA40000 00442021 40024800 0044182B 1460FFFD 00000000 1640FFF6 24A50004
  8FBF003C 3C020008 3C03BF88 AC621064 3C03BF88 8FBE0038 8FB70034 8FB60030
  8FB5002C 8FB40028 8FB30024 8FB20020 8FB1001C 8FB00018 AC621068 03E00008
  27BD0040
END CSub
  
