'MMEDIT!!! Basic Version = Micromite_MK2_V5.2
'MMEDIT!!! Port = COM14:38400:10,300
'MMEDIT!!! Device = Micromite_MK2_V5.2
'MMEDIT!!! Config = 100111101121010110020000110001
  ' exp64 decoder
  DIM INTEGER tick, tock, period, pulsetime = 50, synctime = pulsetime * 10
  DIM code$
  DIM pulses(500) '  store all timing intervals for later processing
  DIM inSync ' used to signal when sync pulse has been received
  DIM pulsecount
  DIM firstRun, syncs
  DIM validAlarms$(20)
  CONST ticker = 49 ' connect PWM output (pin 48) to here
  CONST rxPin = 46  ' pin that the receiver output connects to
  validAlarms$(1) = "011101010001110000000010"
  validAlarms$(2) = "011101010001110000100010"
  validAlarms$(3) = "011101010001110001100010"
  validAlarms$(4) = "011101010001110000000001"
  validAlarms$(5) = "011101010101110000000010"
  validAlarms$(6) = "011101011101110110100010"
  validAlarms$(7) = "011101011001110001100010"
  validAlarms$(8) = "011101011001110000000010"
  validAlarms$(9) = "011101011111110000000010"
  validAlarms$(10) = "011101000001110000100010"
  validAlarms$(11) = "011101100001110001100010"
  validAlarms$(12) = "011101010001110001000001"
  validAlarms$(13) = "010101010001110000000010"
  validAlarms$(14) = "011001010001110000100010"
  validAlarms$(15) = "011011010001110001100010"
  validAlarms$(16) = "011101010001110100000001"
  validAlarms$(17) = "011101010001111100000010"
  validAlarms$(18) = "011101010001101000100010"
  validAlarms$(19) = "011101010001000001100010"
  validAlarms$(20) = "011101010000110000000001"
  
  PWM 1, 100000, 50 ' this is out high resolution timer whch gets connected to ticker pin
  SETPIN ticker, CIN
  SETPIN rxPin, INTB, blip ' triggers on a high or low transition
  tock = PIN(ticker)
  SETTICK 3000, checkit
  
  DO
    '    IF INKEY$<>"" THEN
    '      decode
    '    ENDIF
  LOOP
  
END
  
SUB blip
  tick = PIN(ticker)
  IF inSync = 0 THEN
    IF (tick - tock) > synctime AND PIN(rxPin) = 1 THEN' long enough to have been sync pulse
      inSync = 1
      pulsecount = 0
      pulses(pulsecount) = tick - tock
    ENDIF
  ELSE
    pulsecount = pulsecount + 1
    pulses(pulsecount) = tick - tock
    IF pulsecount > 400 THEN
      inSync = 0
      pulsecount = 0
      'print "overflow"
    ENDIF
  ENDIF
  tock = tick
END SUB
  
SUB checkit
  LOCAL n, t
  t = TIMER
  decode
  FOR n = 1 TO 20
    IF validAlarms$(n)<>"" THEN
      IF INSTR(code$,"s"+validAlarms$(n))>0 THEN ' we have lift off!!
        PRINT "!!!! ",n, " needs help!"
      ENDIF
    ENDIF
  NEXT n
  PRINT "Checkit time ",TIMER - t
END SUB
  
SUB decode
  LOCAL n, pulsetimes
  code$ = ""
  ' check every second timing
  PRINT pulses(0)                                          'DEBUG
  pulsetimes = 0                                           'DEBUG
  FOR n = 1 TO 400 STEP 2
    pulsetimes = pulsetimes + pulses(n)+pulses(n+1)        'DEBUG
    PRINT pulses(n), pulses(n+1), pulsetimes               'DEBUG
    IF pulses(n) > synctime OR pulses(n+1) > synctime THEN ' a sync pulse
      code$ = code$ + "s"
    ELSEIF (pulses(n) + pulses(n+1)) = 0 THEN              ' all done
      EXIT FOR
    ELSEIF pulses(n+1) = 0 AND pulses(n) < pulsetime THEN  ' final transition
      code$ = code$ + "0"
    ELSEIF pulses(n) > pulses(n+1) THEN
      code$ = code$ + "1"
    ELSE
      code$ = code$ + "0"
    ENDIF
  NEXT n
  PRINT code$                                               'DEBUG
  inSync = 0
  syncs = 0
  pulsecount = 0
  FOR n = 1 TO 400
    pulses(n) = 0
  NEXT n
END SUB

