'MMEDIT!!! Basic Version = Micromite_MK2_V5.2
'MMEDIT!!! Port = COM5:38400:10,300
'MMEDIT!!! Device = Micromite_MK2_V5.2
'MMEDIT!!! Config = 100111101121010110020000110001
Option explicit
Option default NONE

Dim integer xmitpin  = 16 ' the pin connected to the 433mhz module data pin
Dim float lengths(68)
Dim float noise(255)

Dim string testkey
Dim integer testVal
Dim integer n
For n = 0 To 255
noise(n) = Rnd()*500+20     ' fill noise array
Next n
Pin(xmitpin)=0                ' set the data pin low
SetPin xmitpin, DOUT          ' set it as an output

'*************** Main Loop ***************
Do
testkey = Inkey$
If testkey <>"" Then
testval = Val(testkey)
Print testval
sendit(testval)
End If
Loop
End
' *********** END ***************************
Sub sendit(code As integer)
Local float pulselength=295      ' us for the short pulse length Long is 3 times this
Local integer repeat=3           'number of times to repeat the transmission
Local string senddata$           'string containg the binary data

If code >= 0 And code <10 Then
Select Case code
Case 0
senddata$ = "011101010001110000000010"
Case 1
senddata$ = "011101010001110000000010"
Case 2
senddata$ = "011101010001110000100010"
Case 3
senddata$ = "011101010001110001100010"
Case 4
senddata$ = "011101010001110000000001"
Case 5
senddata$ = "011101010101110000000010"
Case 6
senddata$ = "011101011101110110100010"
Case 7
senddata$ = "011101011001110001100010"
Case 8
senddata$ = "011101011001110000000010"
Case 9
senddata$ = "N011101010001110000000010"
End Select
' pulsecount = len(senddata$)*2
SEND433MHZ(pulselength,repeat,xmitpin,senddata$)
EndIf
End Sub

Sub SEND433MHZ(pulselength As float,repeat As integer ,thexmitpin As integer,senddata$ As string)
Local integer long,short
Local integer j,i,n

short=pulselength
long=pulselength*3
If Left$(senddata$,1) = "N" Then
n = 1
senddata$ = Mid$(senddata$,2)
'print "Noise"
EndIf

lengths(0)=short
lengths(1)=short*31  'sync pulse
For i=1 To Len(senddata$)
If Mid$(senddata$,i,1) = "1" Then
'One
lengths(i*2)=long
lengths(i*2+1)=short
Else
'Zero
lengths(i*2)=short
lengths(i*2+1)=long
End If

Next i

' Call the CFunction
If n = 1 Then bitbanger(thexmitpin,254,noise())
For j=0 To repeat-1
bitbanger(thexmitpin,Len(senddata$)*2+2,lengths())
Next j
End Sub

CSub bitbanger integer,integer,float  'pin number, number of bits, floating point array of bit lengths in usec
00000000
27BDFFC0 AFBF003C AFBE0038 AFB70034 AFB60030 AFB5002C AFB30024 AFB20020
AFB1001C AFB00018 AFB40028 3C109D00 8E030000 00808821 8E020080 8C640000
00A09021 00002821 00C0B021 0040F809 8E140064 00409821 8E02009C 3C0449F4
0040F809 24842400 00402821 0280F809 02602021 0040B821 8E240000 8E020024
24050007 0040F809 241E0001 AFA20010 8E020028 0040F809 8E240000 8E520000
8E030040 005EF004 0060F809 00122080 AFA20014 12400013 0040A821 0000A021
00008821 3C139D00 0014A080 02D41821 8C640000 8E620058 8E70007C 0040F809
02E02821 26310001 0200F809 00402021 02B4A021 0232182B AE820000 1460FFF2
0220A021 8FA30014 3C040008 8C620000 2442FFFD AC620000 3C03BF88 AC641064
3C03BF88 00001021 AC601068 40824800 8FA50014 8FA30010 2652FFFF AC7E0000
8CA40000 00442021 40024800 0044182B 1460FFFD 00000000 1640FFF6 24A50004
8FBF003C 3C020008 3C03BF88 AC621064 3C03BF88 8FBE0038 8FB70034 8FB60030
8FB5002C 8FB40028 8FB30024 8FB20020 8FB1001C 8FB00018 AC621068 03E00008
27BD0040
End CSub
