  option explicit
  option default integer
  
  Dim buff%(512)
  const qt$ = chr$(34)
  Const maxargs=20
  const html_def$ = "fm.html" ' default landing page
  dim hit_count               ' used for stats - optional
  
  dim filename$(90)

  Dim mystring$="PicoMite Web Test"
  dim float mytemp, myhumid, oldtemp, oldhumid
  dim mytime$
  dim integer allrdg, badrdg
  setpin gp16 , dout ' request in action LED
  setpin gp15 , dout ' doread  in action LED

  watchdog 10000
  timer = 3000
  'date$ = "01-04-2000"
  'on error skip
  WEB ntp 11
  'if date$ = "01-04-2000" then print "OOPS!"
  print "Ready   ";date$;"  ";time$

  WEB tcp interrupt gotrequest
  
  Do
    if timer > 3000 then doread ' background processing to gather data
  Loop
  '
Sub gotrequest
  Local p%, t%, a%, s$, i, nparams, page$, page_ext$, cons$, newfolder$
  Local arg$(1,maxargs-1)
  timer = 0 ' prevent doread sub from running while servicing request
  ' cons$ = connection status used for stats - optional
  For a%=1 To MM.Info(max connections)
    If Not MM.Info(TCP request a%) Then cons$= cons$ + "-" :Continue For
    LongString clear buff%()
    pin(gp16) = 1             ' optional turn LED on
    WEB tcp read a%,buff%()
    
    inc hit_count             ' used for stats - optional
    If LLen(buff%()) Then
      cons$=cons$+"*"
      page$=parsehtmldata$(nparams,buff%(), arg$())
      if page$ = "" then page$ = html_def$
      ' don't print connections to indoor temp monitor - too many!
      if page$ <>"indoors.html" then print str$(hit_count,7,0)+"   "+time$+"   "+page$
      if page$ = "fm" then page$ = "fm.html" ' allow shorthand for fm but not all
      if instr(page$,".") then
        page_ext$ = lcase$(field$(page$,2,"."))
      else
        page_ext$ = ""
      endif
      ' process arguments before returning page with updated results
      if page$ = "fm.html" then
        For i=0 To nparams%             ' printout used for debug
          Print arg$(0,i),"=",arg$(1,i) ' debug 
          if arg$(0,i)="T1" then newfolder$=arg$(1,i) 
          if arg$(0,i)="B1" and arg$(1,i) = "CHDIR" and newfolder$ <>"" then chdir newfolder$
        next i
        makelist ' refresh the file listing
      endif
      if MM.INFO$(FILESIZE page$) > 0 then ' file does exist.
        select case page_ext$
          case "html", "htm"
            WEB transmit page a%,page$
          case "ico"
            WEB Transmit FILE a%,page$,"image/vnd.microsoft.icon"
          case "jpg"
            WEB Transmit FILE a%,page$,"image/jpeg"
          case "png"
            WEB Transmit FILE a%,page$,"image/png"
          case "gif"
            WEB Transmit FILE a%,page$,"image/gif"
          case "bmp"
            WEB Transmit FILE a%,page$,"image/bmp"
          case "js"
            WEB transmit file a%,page$,"script/javascript"
          case "txt", "csv", "bas"
            WEB transmit file a%,page$,"text/plain"
          case "cgi"
            WEB transmit file a%,page$,"application/x-httpd-cgi"
          case ""
            WEB transmit file a%,page$,"text/plain"
          case else
            s$=LGetStr$(buff%(),1,Min(255,LLen(buff%())))
            Print s$
            WEB transmit page a%,"notfound.html"
            WEB transmit code a%, 404
        end select
      else
        WEB transmit page a%,"notfound.html"
        print "404 "+page$
        WEB transmit code a%, 404
      endif
    else
      cons$ = cons$+"0"
    endif
    pin(gp16) = 0
  Next a%
  if page$ <>"indoors.html" then print "status = "+cons$
  ' - = no conection, * = conection with data, 0 = connection but no data
End Sub
  
Function parsehtmldata$(paramcount As integer, inbuf() As integer, arg$())
  Const starttext$="HTTP"
  Local a$,b$, post
  Local integer buf(Bound(inbuf()))
  Local integer inpos,startparam,processargs
  paramcount=0
  inpos=LInStr(inbuf(),"GET /",1)
  If inpos=0 Then inpos=LInStr(inbuf(),"POST /",1): post = 1
  If inpos=0 Then
    parsehtmldata$=""
  Else
    LongString MId buf(),inbuf(),inpos+5+post
    inpos=LInStr(buf(),starttext$,1)
    If inpos>2 Then 'page request found
      inpos=inpos-2
      a$=LGetStr$(buf(),1,inPos)
     ' print a$
      inpos=Instr(a$,"?")
      If inpos<>0 Then 'parameters found
        processargs=1
        parsehtmldata$=Left$(a$,inpos-1)
        a$=Mid$(a$,inpos+1)
        Do
          arg$(0,paramcount)=""
          arg$(1,paramcount)=""
          inpos=Instr(a$,"=")
          startparam=1
          arg$(0,paramcount)=Mid$(a$,startparam,inpos-startparam)
          startparam=inpos+1
          inpos=Instr(a$,"&")
          If inpos<>0 Then
            arg$(1,paramcount)=Mid$(a$,startparam,inpos-startparam)
            a$=Mid$(a$,inpos+1)
            paramcount=paramcount+1
          Else
            arg$(1,paramcount)=Mid$(a$,startparam)
            paramcount=paramcount+1
            processargs=0
          EndIf
        Loop While processargs
      Else
        parsehtmldata$=a$
      EndIf
    Else ' no page requested
      parsehtmldata$= html_def$ 
    EndIf
  EndIf
End Function
  
sub makelist
  local f$, n, k

  for n = 0 to 90
  filename$(n) = "" 
  next n
  
  n = 0
  f$ = DIR$("*",DIR)
  DO WHILE f$ <> ""
  inc n
    filename$(n) =" <a href="+qt$+"fm.html?T1="+f$+"&B1=CHDIR"+qt$+">[ "+f$+" ]</a>"
    ' space character added to start of DIR filenames to force sorting with DIRs first.
    f$ = DIR$()
  LOOP
  f$ = DIR$("*",FILE)
  DO WHILE f$ <> ""
  inc n
    filename$(n) ="<a href="+qt$+f$+qt$+">"+f$+"</a>"
    f$ = DIR$()
  LOOP
  sort filename$(),,2,1,n
  
end sub

sub doread
watchdog 10000
pin(gp15) = 1 ' turn LED on
if pin(gp16) then print "clash!"  ' this shouldn't happen when using TIMER.
                                  ' using timed interrupt will get clashes.
  bitbang humid GP17, mytemp, myhumid
  if mytemp > 999 then
    mytemp = oldtemp
    myhumid = oldhumid
    badrdg = badrdg + 1
  else
    oldtemp = mytemp
    oldhumid = myhumid
  endif
  allrdg = allrdg + 1
  mytime$ = time$+"  "+date$+"   "+str$(badrdg)+"/"+str$(allrdg)
  timer = 0 ' reset timer for next reading
  pin(gp15) = 0 ' turn LED off
end sub
