  ' RTV monitor kw\WEBmite
  OPTION EXPLICIT
  OPTION DEFAULT integer
  option autorun on
  Dim Buff%(512)
  const qt$ = chr$(34)
  Const Maxargs=20
  const html_def$ = "notfound.html"
  
  const fan = 21
  const txs = 22
  const tor = 24
  const squelsh = 25
  const ptt = 26
  const ptt_inhibit = 27
  const heatsink = 29
  const rssi = 31
  const st$ = "_+_-**++++"
  
  dim Fanstate, txtState, torState, squState, pttState, tx_temp
  dim tickTime, ptt_ok, lockout, quiteTime, txTime, oldDate$, timeCheck, loopCount
  dim minFan$, minTx$, minTor$, minSq$, minPtt$, readTime$, lock$, minuteData$, hrData$
  dim startTime$, transmitTime, quietTime, oldtxState, CPUtemp, checkNTP, Quit
  dim fileName$, timeSlot$, lastTime$, timeNow$, thistime$, k$
  dim sqCount, torCount, pttCount
  dim qsoThreshold = 15, idThreshold = 4, wififail
  
  minFan$ = space$(60)
  minTx$  = space$(60)
  minTor$ = space$(60)
  minSq$  = space$(60)
  minPtt$ = space$(60)
  minuteData$ = space$(60)
  hrData$ = space$(60)
  
  setpin fan, din', pullup
  setpin txs, din', pullup
  setpin tor, din', pullup
  setpin squelsh, din', pullup
  setpin ptt, din', pullup
  setpin rssi, ain
  ptt_ok =1
  setpin ptt_inhibit, dout
  pin(ptt_inhibit) = ptt_ok
  on error skip
  drive "b:"
  settick 1000, tick
  oldDate$ = date$
  watchdog 12000
  on error skip 2
  web ntp 10+ dst(), "10.1.1.52"
  WEB tcp interrupt gotrequest
  
  if oldDate$ <> date$ then
    on error skip
    web ntp 10+ dst(), "10.1.1.52"
  endif
  if date$ = "01-01-2000" then
    syslog "Retry"
    cpu restart
  else
    syslog "Started"
  endif
  startTime$ = time$+" "+date$
  lastTime$ = time$
  print chr$(27)+"[2J"
  tx_temp = tempr(heatsink) : CPUtemp = pin(temp)
  tick
  do
    if tickTime then dotick
    k$ = inkey$
    if k$ <>"" then
      select case k$
        case "L","l"
          ptt_ok = 1-ptt_ok
          pin(ptt_inhibit) = ptt_ok
        case "X","x"
          option autorun off
          syslog "Quit"
          Quit = 1
      end select
    endif
    inc loopCount
    if loopCount > 10000 and loopCount < 10005 then thistime$ = time$
    if loopCount > 15000 THEN
      if thistime$ = time$ then syslog "Clock stopped"
      syslog " Loop failed - RESTARTING"
      cpu restart
    endif
    
  loop until Quit
  
sub tick
  tickTime = 1
end sub
  
sub dotick
  'static tock
  local logstate, minLog$, hr$
  tickTime = 0
  timeNow$ = time$
  watchdog 12000
  'inc tock
  'if tock mod 60 = 1 then tempr start heatsink
  'if tock mod 60 = 2 then
  'tx_temp = tempr(heatsink)
  'CPUtemp = pin(temp)
  'endif
  'if right$(time$,2) = "00" then savelog
  Fanstate = not pin(fan)
  txtState = not pin(txs)
  torState = not pin(tor)
  squState = not pin(squelsh)
  pttState = not pin(ptt)
  lockout = pin(ptt_inhibit)
  'print chr$(27)+"[2J" ' CLS
  logstate = (squState+torState*2+pttState*4)and &h07
  select case logstate
    case 0
      minLog$ = "_"
    case 1
      minLog$ = "-"
      inc sqCount
    case 2,3
      minLog$ = "*"
      inc torCount
    case 4,5,6,7
      minLog$ = "+"
      inc pttCount
  end Select
  
  'minuteData$ = left$(hex$(logstate,1)+minuteData$,60) ' minute of data for log
  minuteData$ = minLog$+left$(minuteData$,59)
  minFan$ = mid$(st$,Fanstate+1,1)+left$(minFan$,59)
  minTx$  = mid$(st$,txtState+1,1)+left$(minTx$,59)
  minPtt$ = mid$(st$,pttState+1,1)+left$(minPtt$,59)
  minTor$ = mid$(st$,torState+1,1)+left$(minTor$,59)
  minSq$  = mid$(st$,squState+1,1)+left$(minSq$,59)
  if txtState then
    if oldtxState then
      inc transmitTime
    else
      transmitTime = 1
    endif
    quietTime = 0
  else
    inc quietTime
    'transmitTime = 0
  endif
  oldtxState = txtState
  if lockout = 1 then lock$ = "No" else lock$ = "Yes"
  if right$(timeNow$,2) = "58" then tx_temp = tempr(heatsink) : CPUtemp = pin(temp)
  if right$(timeNow$,2) = "59" then
    logdata minuteData$
    if (pttCount + torCount) > qsoThreshold then
      if pttCount > torCount then
        hr$ = "+"
      else
        hr$ = "*"
      endif
    elseif (pttCount + torCount) > idThreshold then
      hr$ = "|"
    elseif pttCount > 0 or torCount > 0 then
      hr$ = ":"
    elseif sqCount > 1 then
      hr$ = "-"
    else
      hr$ = "_"
    endif
    hrData$ = hr$+left$(hrData$,59)
    pttCount = 0 : torCount = 0 : sqCount = 0
  endif
  readTime$ = timeNow$+" &nbsp;&nbsp;&nbsp;&nbsp; "+date$ ' variable for web page
  print chr$(27)+"["+str$(0)+";"+str$(0)+"H"
  print time$;"  ";date$; "  Started at  ";startTime$
  print
  print "fan = ";minFan$'Fanstate
  print "txs = ";minTx$ 'txtState
  print "ptt = ";minPtt$'pttState
  print "tor = ";minTor$'torState
  print "Squ = ";minSq$ 'squState
  Print
  print "lock= ";lockout
  print "Temp= ";tx_temp;"    ";CPUtemp
  print
  print "Log = ";minuteData$
  Print
  print "hr  = ";hrData$
  Print
  print "Loop = ";str$(loopCount,6,0)
  print "txt Time = ";formattime$(transmitTime);"    Quiet Time = ";formattime$(quietTime)
  
  if left$(timeNow$,7) = "01:59:0" Then checkNTP = 1
  if left$(timeNow$,7) = "02:00:1" and checkNTP Then
    oldDate$ = time$
    on error skip
    web ntp 10+ dst(), "10.1.1.52"
    checkNTP = 0
    syslog "NTP update from "+oldDate$+" to "+time$
    
  endif
  if MM.INFO(WIFI STATUS) <= 0 then
    syslog "WiFi error: "+str$(MM.INFO(WIFI STATUS))
    inc wififail
    if wififail > 20 then cpu restart
  endif
  loopCount = 0
end sub
  
sub logdata datatxt$
  local ts, logtime$
  logtime$ = time$+" "+date$
  ts = val(mid$(logtime$,1,2))*60+val(mid$(logtime$ ,4,2))
  fileName$ = right$(logtime$ ,2)+mid$(logtime$ ,13,2)+mid$(logtime$ ,10,2)+"rtv.txt"
  timeSlot$ = logtime$+ " "+str$(ts,3,0)+" "+datatxt$+" "+str$(CPUtemp)
  savelog
end sub
  
sub savelog
  open fileName$ for append as #2
  print #2, timeSlot$
  close #2
end sub
  
sub gotrequest
  Local p%, t%, a%, s$, i, nparams, page$, page_ext$, cons$, newfolder$
  Local arg$(1,maxargs-1), endtime
  For a%=1 To MM.Info(max connections)
    If Not MM.Info(TCP request a%) Then Continue For
    LongString clear Buff%()
    
    WEB tcp read a%,Buff%()
    
    If LLen(Buff%()) Then
      page$=parsehtmldata$(nparams,Buff%(), arg$())
      ' if page$ = "" then page$ = html_def$
      if instr(page$,".") then
        page_ext$ = lcase$(field$(page$,2,"."))
      else
        page_ext$ = ""
      endif
      if MM.INFO$(FILESIZE page$) > 0 then ' file does exist.
        syslog page$
        select case page_ext$
          case "html", "htm"
            WEB transmit page a%,page$
          case "ico"
            WEB Transmit FILE a%,page$,"image/vnd.microsoft.icon"
          case "jpg"
            WEB Transmit FILE a%,page$,"image/jpeg"
          case "png"
            WEB Transmit FILE a%,page$,"image/png"
          case "gif"
            WEB Transmit FILE a%,page$,"image/gif"
          case "bmp"
            WEB Transmit FILE a%,page$,"image/bmp"
          case "js"
            WEB transmit file a%,page$,"script/javascript"
          case "txt", "csv", "bas", "py"
            WEB transmit file a%,page$,"text/plain"
          case "cgi"
            WEB transmit file a%,page$,"application/x-httpd-cgi"
          case ""
            WEB transmit file a%,page$,"text/plain"
          case else
            WEB transmit page a%,"notfound.html"
            WEB transmit code a%, 404
        end select
      else
        WEB transmit page a%,"notfound.html"
        syslog "404 "+page$
        WEB transmit code a%, 404
      endif
    else
      syslog "no data"
    endif
    
  Next a%
  
end sub
  
Function parsehtmldata$(paramcount As integer, inbuf() As integer, arg$())
  Const starttext$="HTTP"
  Local a$,b$, post
  Local integer buf(Bound(inbuf()))
  Local integer inpos,startparam,processargs
  paramcount=0
  inpos=LInStr(inbuf(),"GET /",1)
  If inpos=0 Then inpos=LInStr(inbuf(),"POST /",1): post = 1
  If inpos=0 Then
    parsehtmldata$=""
    syslog "html without GET or POST"
  Else
    LongString MId buf(),inbuf(),inpos+5+post
    inpos=LInStr(buf(),starttext$,1)
    If inpos>2 Then 'page request found
      inpos=inpos-2
      a$=LGetStr$(buf(),1,inpos)
      ' print a$
      inpos=Instr(a$,"?")
      If inpos<>0 Then 'parameters found
        processargs=1
        parsehtmldata$=Left$(a$,inpos-1)
        a$=Mid$(a$,inpos+1)
        Do
          arg$(0,paramcount)=""
          arg$(1,paramcount)=""
          inpos=Instr(a$,"=")
          startparam=1
          arg$(0,paramcount)=Mid$(a$,startparam,inpos-startparam)
          startparam=inpos+1
          inpos=Instr(a$,"&")
          If inpos<>0 Then
            arg$(1,paramcount)=Mid$(a$,startparam,inpos-startparam)
            a$=Mid$(a$,inpos+1)
            paramcount=paramcount+1
          Else
            arg$(1,paramcount)=Mid$(a$,startparam)
            paramcount=paramcount+1
            processargs=0
          EndIf
        Loop While processargs
      Else
        parsehtmldata$=a$
      EndIf
    Else ' no page requested
      parsehtmldata$= html_def$
    EndIf
  EndIf
End Function
  
sub syslog txt$
  open "syslog.txt" for append as #1
  print #1, date$+" "+time$+" "+txt$
  close #1
end sub
  
function dst()
  local aprstart, octstart, dst1, dst2, dateNow$, daynumnow
  dateNow$ = date$
  daynumnow = epoch(dateNow$+" 00:00:00")/86400
  aprstart = epoch("01-04-"+mid$(dateNow$,7,4)+" 00:00:00")/86400
  dst1 = 3-(aprstart mod 7)
  dst1 = aprstart+dst1 ' first sunday in april in current year
  
  octstart = epoch("01-10-"+mid$(dateNow$,7,4)+" 00:00:00")/86400
  dst2 = 3-(octstart mod 7)
  dst2 = octstart+ dst2 ' first sunday in october in current year
  
  'print datetime$(dst1*86400) ' for debug
  'print datetime$(dst2*86400)
  if daynumnow < dst1 or daynumnow >= dst2 then ' swap for northern hemisphere
    dst = 1
  else
    dst = 0
  endif
end function
  
function formattime$(seconds as integer)
  'local hr, mn,sec
  'hr = seconds\3600
  'mn = (seconds mod 3600)\60
  'sec = seconds mod 60
  formattime$= right$(datetime$(seconds),8) 'str$(hr,2,0,"0")+":"+str$(mn,2,0,"0")+":"+str$(sec,2,0,"0")
end function
