  ' ported by TassyJim from a post on PureBasic forum  by Jeff88
  ' his comments follow
  '
  ';Many years ago when I used Quickbasic, I came across a program to calc pi.  Of course this has no practical
  ';purpose, but just to fight winter boredom I modified the program (see comments included below) to run
  ';under Purebasic,  now can use 10 digits per word instead of 4. Also added a bit of assembly to avoid calculating
  ';the remainder, this only makes a slight difference since most of time is taken by dividing.
  ';Using threads sped up by a factor of 3.  Note calc atan(1/5) takes about twice as long as atan(1/239).
  ';Programmed by Jeff Wyatt, Highlands Ranch, Colorado (1/2019).
  '
  ';On my Athelon II X4 635  the program can calculate 100,000 digits in about 8 secs with debugging off.
  '
  ';   >>>>>>>>>>>>>>>>>>>>>>>COMPILE With THREAD SAFE BOX CHECKED<<<<<<<<<<<<<<<<<<<<<<<<<<<<
  '
  ';Based upon Machin's (1706) formula: pi/4=arctan(1)=4*arctan(1/5)-arctan(1/239), he did 100 digits by hand
  ';which would take about 8 usec with this program.  Time is prop. to digits^2 so need to use another method
  ';for very large number of digits. Good way to test your computer's integer arithmatic.
  ';See https://www.angio.net/pi/ for further info and searchable listing of pi.
  ';I used it to check that my program worked correctly for the first 2,000,000 digits.
  '
  ';Previous comments from authors 20 years ago
  '
  ';Program To calculate pi, version 4.8
  ';A major rewrite of version 4.2, this uses only two arrays instead of
  ';three, and includes a host of speedups based on a similar C program.
  ';A sampler: all the carries are reserved until the end, the divide and
  ';add routines are combined, two terms are added at a time, and the number
  ';of function calls is minimized. It's a big change for a small gain, since
  ';the compiled version requires 28.6 seconds for 5000 digits on my 486 66 MHz
  ';computer, a 10 gain over version 4.2; like before, it's capable of about
  ';150,000 digits of pi.
  ';
  ';This program has come a long way from version 1.0; thanks are due to
  ';Larry Shultis, Randall Williams, Bob Farrington and Adrian Umpleby.
  ';One final note for speed freaks: this program will run about 6 times faster
  ';if written in C using an optimizing compiler. Likewise, if you can figure
  ';out a way to do integer division and use both the quotient and remainder,
  ';this program can easily be sped up by 25.      -jasonp@isr.umd.edu
  OPTION EXPLICIT
  DIM INTEGER words, big, Digits, DigitsperWord, x, i, quotient
  DIM INTEGER ctime, stime
  
  DigitsperWord=10
  big=1
  FOR i=1 TO DigitsperWord  '1 followed by 10 zeros, note if you use 14 digits/word
    big=big*10              'arctan(1/5) will overflow about digit 64,760
  NEXT                      'when 1.4*digits*big~denom*big >9e18
  
  INPUT "how many digits? ",Digits
  words = Digits / DigitsperWord+2
  DIM INTEGER sum(words + 2),sum1(words+2),sum2(words+2)
  stime = TIMER
  print "Started at "+time$
  '---------------  -4*atan(1/239)
  x = atan239()
  '------------   16*atan(1/5)
  PRINT STR$(TIMER - stime)+"mS so far"
  x = atan51()
  PRINT STR$(TIMER - stime)+"mS so far"
  x = atan52()
  PRINT STR$(TIMER - stime)+"mS so far"
  sum1(2)=sum1(2)-big/5
  FOR x=2 TO words
    sum(x)=sum(x)+sum1(x)+sum2(x)
  NEXT
  
  FOR x = words TO 2 STEP -1                        'finish up
    IF sum(x) < 0   THEN                                'release borrows
      quotient = sum(x) \ big
      sum(x) = sum(x) - (quotient - 1) * big
      sum(x - 1) = sum(x - 1) + quotient - 1
    ENDIF
    IF sum(x) >= big  THEN                              'and carries
      quotient = sum(x) \ big
      sum(x) = sum(x) - quotient * big
      sum(x - 1) = sum(x - 1) + quotient
    ENDIF
  NEXT
  ctime = TIMER - stime
  x = PrintOut()
  
END
  
FUNCTION atan239()                    'arctan(x) = x-x^3/3+x^5/5-x^7 ....
  LOCAL INTEGER m, m1, m2, d, denom, temp, fw, x
  LOCAL INTEGER term(words +2), lastword
  m=4
  FOR x = 2 TO words
    d = m * big              'crunch out 1st term
    term(x) = d \ 239
    m = d - term(x) * 239
    sum2(x) = sum2(x) - term(x)             'subtract as we want -atan(1/239)
  NEXT x
  
  denom=3:fw=2
  DO                                   'do two more terms, add first, subtract second
    m1=0
    m=0
    FOR x = fw TO words
      temp = term(x)
      d= m1 * big + temp
      temp = d\ 57121
      m1 = d - temp * 57121
      term(x) = temp
      d = m2 * big + temp
      temp = d \ denom
      m2 = d - temp * denom
      sum2(x) = sum2(x) + temp
    NEXT
    
    IF term(fw) = 0 THEN
      fw = fw + 1
    ENDIF
    denom = denom + 2
    m1 = 0: m2 = 0
    
    FOR x = fw TO words
      temp = term(x)
      d = m1 * big + temp
      temp = d \ 57121
      m1 = d - temp * 57121
      term(x) = temp
      
      d= m2 * big + temp
      temp = d \ denom
      m2 = d - temp * denom
      sum2(x) = sum2(x) - temp
    NEXT x
    
    IF term(fw) = 0 THEN
      fw = fw + 1
    ENDIF
    denom = denom + 2
  LOOP UNTIL fw >=words
END FUNCTION
  '-------------------------------------------------------------------
FUNCTION atan51()                      ' atan(1/5)  one half of calc terms 1/5, 1/9, 1/13 ......
  LOCAL INTEGER mainder, mainder1, mainder2, dividend, denom, temp, firstword, x
  LOCAL INTEGER term(words +2), lastword
  denom = 5: firstword = 1: lastword =3
  sum(1) = 3: term(1) = 3: sum(2) = big/5: term(2) = sum(2)
  DO
    
    mainder1=0
    mainder2=0
    FOR x = firstword TO lastword + 1
      temp = term(x)
      dividend = mainder1 * big + temp
      temp = dividend \ 625                 ' 625 = 5^4
      mainder1 = dividend - temp * 625
      term(x) = temp
      
      dividend = mainder2 * big + temp
      temp = dividend \ denom
      mainder2 = dividend - temp * denom
      sum(x) = sum(x) + temp
    NEXT
    
    FOR x = lastword + 2 TO words
      dividend = mainder2 * big
      temp = dividend \ denom
      mainder2 = dividend - temp * denom
      sum(x) = sum(x) + temp
    NEXT
    IF term(lastword + 1) > 0 AND lastword < words THEN
      lastword = lastword + 1
    ENDIF
    IF term(firstword) = 0 THEN
      firstword = firstword + 1
    ENDIF
    
    denom = denom + 4
  LOOP UNTIL firstword >= words
  
END FUNCTION
  
FUNCTION atan52()             ' atan(1/5)  other half of calc terms 1/3, 1/7, 1/11 ....
  LOCAL INTEGER mainder, mainder1, mainder2, dividend, denom, temp, firstword, x
  LOCAL INTEGER term(words +2), lastword
  denom = 3: firstword = 1: lastword =3
  sum1(1) = 3: term(1) = 3: sum1(2) = big/5: term(2) = sum1(2)
  print "starting atan52()" 'DEBUG
  mainder1=0
  mainder2=0
  FOR x = firstword TO lastword + 1   'term 1/3
    temp = term(x)
    dividend = mainder1 * big + temp
    temp = dividend \ 25
    mainder1 = dividend - temp * 25
    term(x) = temp
    
    dividend = mainder2 * big + temp
    temp = dividend \ denom
    mainder2 = dividend - temp * denom
    sum1(x) = sum1(x) - temp
  NEXT
  print "atan52() step 2" 'DEBUG
  FOR x = lastword + 2 TO words
    dividend = mainder2 * big
    temp = dividend \ denom
    mainder2 = dividend - temp * denom
    sum1(x) = sum1(x) - temp
  NEXT
  IF term(lastword + 1) > 0 AND lastword < words THEN
    lastword = lastword + 1
  ENDIF
  IF term(firstword) = 0 THEN
    firstword = firstword + 1
  ENDIF
  denom = denom + 4
  print "atan52() step 3" 'DEBUG
  DO                                'do the rest
  if firstword mod 100 = 0 then print firstword 'DEBUG
    mainder1 = 0: mainder2 = 0
    FOR x = firstword TO lastword + 1
      temp = term(x)
      dividend = mainder1 * big + temp
      temp = dividend \ 625
      mainder1 = dividend - temp * 625
      term(x) = temp
      
      dividend = mainder2 * big + temp     'eventually this will overflow >9e18
      temp = dividend \ denom
      mainder2 = dividend - temp * denom
      sum1(x) = sum1(x) - temp
    NEXT x
    
    FOR x = lastword + 2 TO words
      dividend = mainder2 * big
      temp = dividend \ denom
      mainder2 = dividend - temp * denom
      sum1(x) = sum1(x) -temp
    NEXT x
    
    IF term(lastword + 1) > 0 AND lastword < words THEN
      lastword = lastword + 1
    ENDIF
    IF term(firstword) = 0 THEN
      firstword = firstword + 1
    ENDIF
    denom = denom + 4
  LOOP UNTIL firstword >= words
END FUNCTION
  
FUNCTION PrintOut()
  LOCAL p$, i AS INTEGER, j AS INTEGER, ptime AS INTEGER
  PRINT ""
  p$="pi = 3."
  i=2
  DO
    FOR j=i TO i+4
      IF j>words THEN
        p$=p$+SPACE$(11)
      ELSE
        p$=p$+STR$(sum(j),10,0,"0")+" "
      ENDIF
    NEXT
    p$=p$+STR$(10*i+30,7)
    PRINT p$
    p$="       "
    i=i+5
  LOOP UNTIL i>=words
  ptime = TIMER - stime - ctime
  PRINT ""
  
  PRINT " Total computation time:   "+STR$(ctime)+" mS"
  PRINT " Time to format and print: "+STR$(ptime)+" mS at "+time$
END FUNCTION
