  ' FS_controller
  Option Explicit
  Option Default Integer
  Option Base 0
  'OPTION WEB MESSAGES OFF
  
  const doDebug = 1
  
  Const password$ = "1234" ' they are all 1234 unless you change it
  Const address$ = "10.10.10.10" ' not the real address
  Const CRLF$ = Chr$(13)+Chr$(10)
  Const qt$ = Chr$(34)
  Const tY1 = 70 ' display vertical positioning
  Const tY2 = 140
  Const tY3 = 190
  const scrollRate = 100 ' mS betweel text scroll
  const scrollStep = 2  ' pixel to scroll
  const songRefresh = 20000 ' mS between song name check
  const mid_press = 2000 ' mS to diferentiate between short and long press
  const long_press = 5000 ' mS to differentiate very long pres (Sleep)
  const fav_dwell = 3000 ' mS of no change before automatic selection
  const vol_dwell = 10000 ' mS of no volume change before resetting to main mode 1
  
  Dim modes$(7) length 32
  Dim presets$(19) length 32
  dim preset_name$(29) length 15
  dim integer preset_num(29,2)
  dim sys_mode_txt$(4) length 32
  sys_mode_txt$(0) = "  Setup  "
  sys_mode_txt$(1) = " Preset* "
  sys_mode_txt$(2) = " Preset  "
  sys_mode_txt$(3) = " Volume  "
  
  Dim status$, sessionID$, currentStn$, currentSong$
  Dim songArtist$, songTitle$, lastArtist$, lastTitle$, lastSong$
  Dim Integer Req_status, currentmode, noconnection, scrollTime
  dim integer  preset_count, vol
  Dim integer sys_mode, enc_time, retry_presets, vol_end_time, fav_end_time
  Dim buff%(1024)
  
  Dim Integer n, k, songTime, modeList, fav_num, old_fav_num, quit, panic
  Dim junk$, lastTime$, thisTime$
  for n = 0 to 29
    read preset_name$(n),preset_num(n,0),preset_num(n,1)
    if preset_name$(n) = "END" then
      preset_name$(n)=""
      preset_count = n-1
      exit for
    endif
  next n
  
  ' rotary encoder
  SETPIN gp19, DIN, PULLUP' setup RB as an input
  SETPIN gp20, INTl, RInt, PULLUP' setup an interrupt when RA goes low
  SETPIN gp21, INTl, bint', PULLUP' setup an interrupt when button pressed
  dim enc_inc, enc_pos, enc_enter, uptime, downtime
  
  'var restore
  On error skip 1
  WEB ntp 10+ dst(), "10.1.1.52"
  Option Autorun On
  Cls
  Rbox 40,60,240,120,50,Rgb(Yellow),Rgb(Yellow)
  Text Mm.hres/2,Mm.vres/2,"Welcome",cm,5,1,Rgb(Black),Rgb(Yellow)
  Pause 15000 ' allow time for radio to startup
  On error skip 1
  WEB ntp 10+ dst(), "10.1.1.52"
  Watchdog hw 8300
  setup
  
  Do
    Watchdog hw 8300
    if noconnection then errorMessage
    if panic then
      snooze
    else
      If songTime Then
        refreshSong
        if retry_presets then
          retry_presets = 0
          n = getPresets()
        endif
      endif
      if scrollTime then scrollNow
    endif
    if enc_inc then domenu
    if enc_enter then do_select_menu
    Watchdog hw 8300
    thistime$ = left$(time$,5)
    if thisTime$ <> lastTime$ then lastTime$ = thisTime$ : header
    if sys_mode = 3 and vol_end_time > 0 and vol_end_time < timer then
      vol_end_time = 0
      sys_mode = 1
      cls
      header
      refreshSong
      if doDebug then print "Timeout and back to sys_mode 1"
    endif
    if sys_mode = 2 and fav_end_time > 0 and fav_end_time < timer then
      fav_end_time = 0
      select_fav
    endif
  Loop until inkey$ = "x"
  watchdog hw off
end
  
Function dst() ' dst in southern hemisphere and Aust days
  Local aprstart, octstart, dst1, dst2, dateNow$, daynumnow
  dateNow$ = Date$
  daynumnow = Epoch(dateNow$+" 00:00:00")/86400
  aprstart = Epoch("01-04-"+Mid$(dateNow$,7,4)+" 00:00:00")/86400
  dst1 = 3-(aprstart Mod 7)
  dst1 = aprstart+dst1 ' first sunday in april in current year
  
  octstart = Epoch("01-10-"+Mid$(dateNow$,7,4)+" 00:00:00")/86400
  dst2 = 3-(octstart Mod 7)
  dst2 = octstart+ dst2 ' first sunday in october in current year
  If daynumnow < dst1 Or daynumnow >= dst2 Then ' swap for northern hemisphere
    dst = 1
  Else
    dst = 0
  EndIf
End Function
  
SUB RInt ' Interrupt to decode the encoder output
  IF PIN(gp19) = 1 THEN
    if uptime < timer then
      uptime = timer + 1000
      enc_inc = 1 ' clockwise rotation
    endif
  ELSE
    if downtime < timer then
      downtime = timer + 1000
      enc_inc = -1 ' anti clockwise rotation
    endif
  ENDIF
END SUB
  
sub bint ' interrupt for button press
  enc_enter = 1
  enc_time = timer
end sub
  
  ' actions to do with rotation
sub domenu
  local n
  enc_pos = enc_pos + enc_inc
  if doDebug then print enc_pos, sys_mode
  select case sys_mode
    case 0
      ' setup
    case 1,2 ' change stations
      sys_mode = 2
      fav_num = fav_num + enc_inc'/click_per_step
      if fav_num < 0 then fav_num = preset_count
      if fav_num > preset_count then fav_num = 0
      chooseFav
      fav_end_time = timer + 3000
    case 3 ' volume
      vol = vol + enc_inc
      if vol < 0 then vol = 0
      if vol > 32 then vol = 32
      chooseVolume vol
      vol_end_time  = timer + 10000
      if doDebug then print "Vol end time = ";vol_end_time
  end select
  enc_inc = 0
  header
end sub
  
  ' actions to do with encoder button press
sub do_select_menu
  local n, fsec
  fsec = enc_time+long_press
  pause 10 ' debounce time
  enc_enter = 0
  if pin(gp21) = 0 then ' button really is pressed
    do
    loop until pin(gp21) = 1 or timer > fsec' button is up
    enc_time = timer - enc_time
    if doDebug then print "Click = ";enc_time, sys_mode
    if enc_time >= long_press then
      n = setPowerState(0) ' send radio into standby
      snooze
    elseif enc_time < mid_press then
      select case sys_mode
        case 0 ' startup or panic
          setup
        case 1 ' default
          if doDebug then print "changing to sys_mode 3"
          sys_mode = 3
          vol_end_time  = timer + 10000
          chooseVolume vol
          'change to select volume
        case 2 ' select favorite
          select_fav
          ' change to default mode after selection
        case 3
          if doDebug then print "changing to sys_mode 1"
          sys_mode = 1
      end select
    else ' long press 2 to 5 seconds
      select case sys_mode
        case 0 ' startup or panic
          '
        case 1 ' default
          'chooseRecent
        case 2 ' set favorite
          sys_mode = 3
          vol_end_time  = timer + 10000
          chooseVolume vol
        case 3
          ' no action
      end select
    endif
    header
  endif
end sub
  
sub chooseFav
  local n, stnName$,stnNameA$,stnNameB$, k
  
  stnName$ = preset_name$(fav_num)
  k = instr(stnName$," ")
  if k then
    stnNameA$ = left$(stnName$,k-1)
    stnNameB$ = mid$(stnName$,k+1)
  else
    stnNameA$ = "   "+stnName$+"   "
    stnNameB$ = "         "
  endif
  cls
  text 160,80,stnNameA$,cm,3,2,rgb(yellow),rgb(black)
  text 160,160,stnNameB$,cm,3,2,rgb(yellow),rgb(black)
  text 160,230,str$(preset_num(fav_num,0))+"  "+str$(preset_num(fav_num,1)),cm,1,2
  if doDebug then print "fav = ";fav_num;"  preset = ";preset_num( fav_num,0);"  ";preset_num( fav_num,1)
end sub
  
sub select_fav
  local n
  sys_mode = 1
  if getcurrentmode() <> preset_num(fav_num,0) then
    n = setMode(preset_num(fav_num,0))
  endif
  if doDebug then print "Mode = ";preset_num(fav_num,0)
  cls
  lastSong$ = "~"
  n = selectPreset(preset_num(fav_num,1))
  if doDebug then Print "Fav = ";preset_num(fav_num,1)
  If n Then
    n = setNavState(1)
  Endif
  n = getPresets()
  if n = 0 then retry_presets = 1
  songTime = 1
end sub
  
sub chooseVolume vol
  local n,v
  n = setVolume(vol)
  for v = 0 to vol
    box v*9,50,9,160-v*5,1,rgb(black),rgb(black)
    box v*9,210-v*5,9,v*5,1,rgb(yellow),rgb(yellow)
  next v
  if vol < 32 then
    for v = vol+1 to 32
      box v*9,50,9,160-v*5,1,rgb(black),rgb(black)
      box v*9,210-v*5,9,v*5,1,rgb(0,255,255),rgb(0,163,163)
    next v
  endif
end sub
  
sub setup
  local n, k
  Rbox 20,60,280,120,50,Rgb(yellow),Rgb(Yellow)
  text 160,120,"Connecting",cm,5,1,rgb(black),Rgb(Yellow)
  Watchdog hw 8300
  sessionID$ = CREATESESSION$()
  junk$ = GETVERSION$()
  if doDebug then print "Version = ";junk$
  if not noconnection then
    n = getPowerState()
    if doDebug then print "POWER = "; n
    if n =  0 then
      n = setPowerState(1)
      currentmode = getcurrentmode()
      Watchdog hw 8300
      pause 5000
    endif
    if doDebug then print "current mode = "; currentmode
    if currentmode = -1 then
      noconnection = 1
    else
      Watchdog hw 8300
      vol = getVolume()
      currentStn$ = getName$()
      if doDebug then print "Station: ";currentStn$
      n = getModes()
      for n = 0 to 7
        if doDebug then print modes$(n)
      next n
      n = getPresets()
      
      for n = 0 to 9
        if presets$(n) = currentStn$ then
          k=n
          exit for
        endif
      next n
      for n = 0 to preset_count
        if preset_num(n,0) = currentmode and preset_num(n,1) = k then
          fav_num = n
          old_fav_num = fav_num
          exit for
        endif
      next n
      if doDebug then print "fav = ";fav_num;" preset = ";preset_num( fav_num,0),preset_num( fav_num,1)
      cls
      Settick songRefresh, refreshSongNow,1
      Settick scrollRate,scrollTick,2
      songTime = 1
      lastSong$ = "~"
    endif
  endif
  n = endSession()
  sys_mode = 1
  vol_end_time = 0
end sub
  
sub errorMessage em as integer
  noconnection = 0
  Settick Pause, scrollTick,2
  Settick Pause, refreshSongNow,1
  cls
  Rbox 20,60,280,120,50,Rgb(red),Rgb(red)
  Rbox 25,65,270,110,45,Rgb(red),Rgb(Yellow)
  if em then
    text 160,120,"ERROR "+str$(em),cm,5,1,rgb(black),Rgb(Yellow)
    if doDebug then print "ERROR "+str$(em)
  else
    text 160,120,"ERROR! ",cm,5,1,rgb(black),Rgb(Yellow)
  endif
  panic = 1
end sub
  
  ' put everything to sleep and wait for click
sub snooze
  Settick 0,0,2
  Settick 0,0,1
  watchdog off
  sys_mode = 0
  panic = 0
  cls
  Rbox 20,60,280,120,50,Rgb(red),Rgb(red)
  Rbox 25,65,270,110,45,Rgb(red),Rgb(Yellow)
  text 160,106,"Click",cm,5,1,rgb(black),Rgb(Yellow)
  text 160,134,"to restart",cm,5,1,rgb(black),Rgb(Yellow)
end sub
  
sub scrollTick
  scrollTime = 1
end sub
  
Sub refreshSongNow
  songTime = 1
  Watchdog hw 8300
End Sub
  
  ' refresh song title and artist then let scroll tick timer do the display
Sub refreshSong
  songTime = 0
  If sys_mode = 1 Then
    currentmode = getcurrentmode()
    currentStn$ = getName$()
    Watchdog hw 8300
    if currentmode <> 3  then
      currentSong$ = getText$()
      currentSong$ = TRIMIT$(currentSong$)
      if currentSong$ = "<End>" then currentSong$ = ""
      If currentSong$ <> lastSong$ Then
        lastSong$ = currentSong$
        
        n = Instr(currentSong$,"-")
        if doDebug then Print time$;"   ";currentSong$ ',n
        If n Then
          songArtist$ = trimit$(Left$(currentSong$,n-1))
          songTitle$ = trimit$(Mid$(currentSong$,n+1))
        Else
          songArtist$ = "                "
          songTitle$ = "                " 'currentSong$
        Endif
      endif
    else
      songArtist$ = "                "
      songTitle$ = "                "
      Text 160,tY2,"                    ",cm,3,2,Rgb(White),Rgb(Black)
      Text 160,tY3,"                    ",cm,3,2,Rgb(White),Rgb(Black)
    Endif
    ' Cls
    header
    Text 160,tY1,"      "+currentStn$+"      ",cm,3,2,Rgb(Cyan),Rgb(Black)
  Endif
End Sub
  
sub header
  local headertxt$
  headertxt$ = str$(fav_num,2,0)+sys_mode_txt$(sys_mode)+thistime$ 'str$(vol,2,0)
  Text 0,1,headertxt$,lt,4,2,Rgb(Blue),Rgb(white)
  Text 0,1,left$(headertxt$,vol\2),lt,4,2,Rgb(Blue),Rgb(yellow)
end sub
  
  ' trim and replace html codes
Function Trimit$(txtA$)
  Local Integer n, k
  Local txt$
  txt$ = txtA$+" "
  For n = 1 To Len(txt$)
    If Mid$(txt$,n,1)<>" " And Mid$(txt$,n,1)<>Chr$(9) Then Exit For
  Next n
  For k = Len(txt$) To n Step -1
    If Mid$(txt$,k,1)<>" " And Mid$(txt$,k,1)<>Chr$(9) Then Exit For
  Next k
  If k > n Then
    txt$ = Mid$(txt$,n,k-n+1)
  Else
    txt$ = ""
  Endif
  txt$ = replace$(txt$,"&amp;","&")
  txt$ = replace$(txt$,"&apos;","'")
  txt$ = replace$(txt$,"[+]","&")
  Trimit$ = txt$
End Function
  
function replace$(string1$,string2$,string3$)
  local txt$, k
  txt$ = string1$
  do
    k = Instr(txt$,string2$)
    If k Then txt$ = Left$(txt$,k-1)+string3$+Mid$(txt$,k+len(string2$))
  loop until k = 0
  replace$ = txt$
end function
  
Sub scrollNow
  scrollTime = 0
  If sys_mode = 1 Then
    scrollArtist
    scrollSong
  Endif
End Sub
  
Sub scrollArtist
  Local Integer pixels
  Static x0, x1, x2
  If songArtist$ <> lastArtist$ Then
    lastArtist$ = songArtist$
    pixels = Len(songArtist$) * 32
    x1 = 72+pixels/2
    x2 = Mm.hres-pixels/2-72
    x0 = x1
    Text 160,tY2,"                    ",cm,3,2,Rgb(White),Rgb(Black)
  Endif
  If (Len(songArtist$) * 32) =< Mm.hres Then
    Text 160,tY2,"         "+songArtist$+"         ",cm,3,2,Rgb(White),Rgb(Black)
  Endif
  
  If (Len(songArtist$) * 32) > Mm.hres Then 'x0 = mm.hres/2
    If x0 >= x1 Then Text Mm.hres/2,tY2,"                   ",cm,3,2,Rgb(White),Rgb(Black)
    Text x0,tY2,"         "+songArtist$+"         ",cm,3,2,Rgb(White),Rgb(Black)
    x0 = x0 - scrollStep
    If x0 =< x2 Then x0 = x1
  Endif
End Sub
  
Sub scrollSong
  Local Integer pixels
  Static s0, s1, s2
  If songTitle$ <> lastTitle$ Then
    lastTitle$ = songTitle$
    pixels = Len(songTitle$) * 32
    s1 = 72+pixels/2
    s2 = Mm.hres-pixels/2-72
    s0 = s1
    Text Mm.hres/2,tY3,"                  ",cm,3,2,Rgb(White),Rgb(Black)
  Endif
  If (Len(songTitle$) * 32) =< Mm.hres Then
    Text 160,tY3,"         "+songTitle$+"         ",cm,3,2,Rgb(Yellow),Rgb(Black)
  Endif
  
  If (Len(songTitle$) * 32) > Mm.hres Then 's0 = mm.hres/2
    If s0 >= s1 Then Text Mm.hres/2,tY3,"                   ",cm,5,1,Rgb(White),Rgb(Black)
    Text s0,tY3,"         "+songTitle$+"         ",cm,3,2,Rgb(Yellow),Rgb(Black)
    s0 = s0 - scrollStep
    If s0 =< s2 Then s0 = s1
  Endif
End Sub
  
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' functions to Send query and process returned data
  ' there is no reason why ESP8266 or ESP32 etc can not be used instead of WEBmite
  
  ' send query, return xml data in buff%()
  ' this is the only sub that uses TCPIP.
Sub getquery query$
  Watchdog hw 8300
  ' these lines are needed to stop the radio complaining about HTTP version.
  query$ = query$ +Crlf$ + "Cache-Control: no-cache"+CRLF$
  query$ = query$ + "Host: "+address$+CRLF$
  query$ = query$ + "Connection: Keep-Alive"+CRLF$+CRLF$
  On Error Skip
  Web Open Tcp Client address$, 80
  If Mm.errno Then
    if doDebug then Print "Error1",Mm.errno, Mm.errmsg$
    noconnection = 1
  Else
    On Error Skip
    Web Tcp Client Request query$, buff%(), 7000
    'pause 200
    If Mm.errno Then
      if doDebug then Print "Error2",Mm.errno, Mm.errmsg$
      noconnection = 1
    Else
      Web Close Tcp Client
      noconnection = 0
    endif
  Endif
End Sub
  
function iscomplete()
  iscomplete = linstr(buff(), "</fsapiResponse>")
end function
  
  ' scan xml data extracting data
Function findNextField$(fieldName$, fromStart As Integer)
  Local pos1, value$
  Static pos2
  If fromStart Then
    pos2 = 1
  Endif
  'longstring print buff%()
  pos1 = Linstr(buff%(), fieldName$,pos2)
  If pos1 Then
    pos1 = pos1 + Len(fieldName$)
    if pos1 < llen(buff%()) then
      pos2 = Linstr(buff%(), "<", pos1)
      'print pos1,pos2
      If pos2> pos1 Then
        value$ = Lgetstr$(buff%(), pos1, pos2 - pos1)
      Else
        value$ = "<End>"
      Endif
    else
      value$ = "<End>"
    endif
  Else
    value$ = "<End>"
  Endif
  findNextField$ = value$
End Function
  
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' wrappers for some of the FSAPI functions
  
  ' not usually needed
Function createSession$()
  getquery "GET /fsapi/CREATE_SESSION?pin="+password$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  sessionID$ = "&sid="+findNextField$("<sessionId>")
  'print status$,sessionID$
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  createsession$ = sessionID$
End Function
  
  ' 1 = on, 0 = standby
Function getPowerState()
  Local value$
  getquery "GET /fsapi/GET/netRemote.sys.power?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><u8>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    getPowerState = Val(value$)
  Else
    getPowerState= -1
  Endif
End Function
  
Function setPowerState(x)
  Local value$
  getquery "GET /fsapi/SET/netRemote.sys.power?value="+Str$(x)+"&pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  '  longstring print buff%()
  setPowerState = Req_status
End Function
  
  ' station name
Function getName$()
  Local value$
  getquery "GET /fsapi/GET/netRemote.play.info.name?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><c8_array>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    getName$ = value$
  Else
    getName$ = status$
  Endif
End Function
  
  ' artist and song title
Function getText$()
  Local value$
  getquery "GET /fsapi/GET/netRemote.play.info.text?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><c8_array>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    getText$ = value$
  Else
    getText$ = status$
  Endif
End Function
  
  ' fill modes$() array and returns number of modes
  ' [] indicates not selectable
Function getModes()
  Local value$, selectable$, id$, n, k
  getquery "GET /fsapi/LIST_GET_NEXT/netRemote.sys.caps.validModes/-1?pin="+password$+"&maxItems=10"+sessionID$+" HTTP/1.1"
  ' longstring print buff%()
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    For n = 0 To 7
      modes$(n) = ""
    Next n
    n = 0
    Do
      id$ = findNextField$(qt$+"id"+qt$+"><c8_array>")
      If id$ = "<End>" Then Exit Do
      selectable$ = findNextField$(qt$+"selectable"+qt$+"><u8>")
      value$ = findNextField$( qt$+"label"+qt$+"><c8_array>")
      'print id$,selectable$,value$
      If value$ = "<End>" Then Exit Do
      If selectable$ = "1" Then
        modes$(n) = value$
      Else
        modes$(n) = "["+value$+"]" ' or blank?
      Endif
      n =  n + 1
    Loop Until n >= 8
  Else
    n = -1
  Endif
  getModes = n
End Function
  
  ' supply mode number, return 1 = success, 0 = fail
Function setMode(m)
  getquery "GET /fsapi/SET/netRemote.sys.mode?value="+Str$(m)+"&pin="+password$+sessionID$+" HTTP/1.1"
  ' longstring print buff%()
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  setMode = Req_status
End Function
  
  ' returns mode number , -1 = error
Function getcurrentmode()
  Local value$
  getquery "GET /fsapi/GET/netRemote.sys.mode?pin="+password$+sessionID$+" HTTP/1.1"
  'longstring print buff%()
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><u32>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" and value$ <>"4294967295" then
    getcurrentmode = Val(value$)
  Else
    getcurrentmode = -1
  Endif
End Function
  
  ' fills presets$() array and returns number of stations in array, -1 = error
Function getPresets()
  Local value$, n, update_needed
  currentmode = getcurrentmode()
  if currentmode >= 0 then
    n = getNavState()
    If n = 0 Then
      n = setNavState(1)
    Endif
    update_needed = 0
    
    getquery "GET /fsapi/LIST_GET_NEXT/netRemote.nav.presets/-1?pin="+password$+"&maxItems=20"+sessionID$+" HTTP/1.1"
    'longstring print buff%()
    status$ = findNextField$("<status>",1)
    Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
    If status$ = "FS_OK" Then
      'For n = 0 To 9
      'presets$(n+ currentmode) = ""
      'Next n
      n = 0
      Do
        value$ = findNextField$( qt$+"name"+qt$+"><c8_array>")
        If value$ = "<End>" Then Exit Do
        ' if presets$(n+currentmode*10) <> value$ then update_needed = 1
        presets$(n) = value$
        n = n + 1
      Loop Until n >= 10
    Else
      n = -1
    Endif
    'if update_needed then var save presets$()
    for n = 0 to 9
      print n, presets$(n)
    next n
    getPresets = n
  else
    getPresets = -1
  endif
End Function
  
  ' supply preset number, return 1 = success, 0 = fail
Function selectPreset(preset)
  Local currentName$
  currentName$ = getName$()
  If currentName$ = presets$(preset) Then
    'print "Already there"
  Else
    getquery "GET /fsapi/SET/netRemote.nav.action.selectPreset?value="+Str$(preset)+"&pin="+password$+sessionID$+" HTTP/1.1"
    status$ = findNextField$("<status>",1)
    Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
    selectPreset = Req_status
  Endif
End Function
  
function getpreset()
  local value$
  getquery "GET /fsapi/GET/netRemote.nav.action.selectPreset?"+"&pin="+password$+sessionID$+" HTTP/1.1"
  'longstring print buff%()
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><u32>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" and value$ <>"4294967295" then
    getpreset = Val(value$)
  Else
    getpreset = -1
  Endif
end function
  
function setPreset(preset)
  Local currentName$
  currentName$ = getName$()
  ' GETQUERY "GET /fsapi/SET/netRemote.nav.action.selectPreset?value="+Str$(preset)+"&pin="+password$+" HTTP/1.1"
  getquery "GET /fsapi/SET/netRemote.play.addPreset?value="+Str$(preset mod 10)+"&pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  presets$(preset) = currentName$
  setPreset = Req_status
end function
  
Function dabScan$()
  Local value$
  getquery "GET /fsapi/GET/netRemote.nav.action.dabScan?pin="+password$+sessionID$+" HTTP/1.1"
  'longstring print buff%()
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><u8>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    dabscan$ = value$
  Else
    dabScan$ = status$
  Endif
End Function
  
  ' returns 1 = success, 0 = fail
Function endSession()
  getquery "GET /fsapi/DELETE_SESSION?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  sessionID$ = ""
  endSession = Req_status
End Function
  
  ' you may have to turn on nav.state
Function getNavState()
  Local value$
  getquery "GET /fsapi/GET/netRemote.nav.state?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><u8>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    getNavState = Val(value$)
  Else
    getNavState = -1
  Endif
End Function
  
Function setNavState(x)
  getquery "GET /fsapi/SET/netRemote.nav.state?value=1&pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  setNavState = Req_status
End Function
  
function getMute()
  local value$
  getquery "GET /fsapi/GET/netRemote.sys.audio.mute?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><u8>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    getMute = Val(value$)
  Else
    getMute = -1
  Endif
end function
  
function setMute(x)
  getquery "GET /fsapi/SET/netRemote.sys.audio.mute?value="str$(x)+"&pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
end function
  
function getVolume()
  local value$
  getquery "GET /fsapi/GET/netRemote.sys.audio.volume?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><u8>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    getVolume = Val(value$)
  Else
    getVolume = -1
  Endif
End Function
  
function setVolume(x)
  getquery "GET /fsapi/SET/netRemote.sys.audio.volume?value="+str$(x)+"&pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  setVolume = Req_status
End Function
  
function getversion$()
  local value$
  getquery "GET /fsapi/GET/netRemote.sys.info.version?pin="+password$+sessionID$+" HTTP/1.1"
  status$ = findNextField$("<status>",1)
  value$ = findNextField$("<value><c8_array>")
  Req_status = (status$ = "FS_OK") '1 = OK, 0 = bad
  If status$ = "FS_OK" Then
    getversion$ = value$
  Else
    getversion$= "-1"
  Endif
End Function
  
mystations:
  data "7PNN",3,0
  data "ABC Classic",3,1
  data "ABC RN",3,2
  data "ABC Hobart",0,0
  data "ABC Local",3,5
  data "3GG",0,8
  data "7BU",3,8
  data "Sea FM",3,3
  data "7AD",3,4
  data "7LA",3,7
  data "Coast FM",3, 6
  data "WS FM",0,1
  data "Pulse NZ",0,2
  data "Double J",0,3
  data "Tripple J",0,4
  data "Tripple M",0,5
  data "2CA",0,6
  data "3GG",0,8
  data "END",0,0
  
  
  '
  '7pnn abc 90.5
  '102.5
  'sea 95.3 101.7
  '7bu 107.3 100.9
  '7ad 98.9
  '7la 89.3
  'abcfm 93.3
  '7rn 94.1
  '7dbs 106.1
