' File Explorer 
' written to test many of the file formats encountered on the CMM2.
' TassyJim May 2020
' adapted for the picomite September 2024
  
  OPTION EXPLICIT
  OPTION DEFAULT NONE
  
  DIM INTEGER cWth = MM.info(FONTWIDTH), cHt = MM.info(FONTHEIGHT)
  dim integer cpl = mm.hres/cWth, lpp = mm.vres/cHt
  DIM INTEGER columnStart(2) = (1*cWth,mm.hres/3,mm.hres/3*2)
  DIM INTEGER infoLine = mm.vres-60, helpLine = mm.vres-20
  DIM INTEGER maxFiles = 512, useColour = 1, fs = 1
  DIM fList$(maxFiles) LENGTH 128
  DIM INTEGER fCol(maxFiles)
  DIM INTEGER pageStart(50) ' number of pages we can 'page up' to in text view
  DIM k$, info$, Type$, showTime$, MP3Specs$ ' INKEY
  DIM INTEGER mf, md, mfs, cpp = 3, rpp = infoLine/cHt-1 ' max files , max fileName, colums, rows/pg
  DIM INTEGER perPg = cpp * rpp ' files per page
  DIM INTEGER fn, oldFn ' file number, old file number
  DIM INTEGER showing, refreshDue = 1
  DIM INTEGER iHt, iWdth, iBits, onDisk ' image stats
  DIM INTEGER mp3Hdr(13), MP3sections
  dim float MP3duration ' MP3 file information
  'dim integer mouse_port, mlb, mrb, mwb
  'dim integer inhibit_mouse
  dim statusline$ = "h-help, v-view, t-text, x-HEX, i-info, r-rename, n-new dir, s-Xmodem, k-kill, q-quit"
  if instr(mm.device$,"VGA") or instr(mm.device$,"HDMI") then
  MODE 3
  font fs
  else
  font fs
  endif

  DO
    IF refreshDue = 1 THEN refreshFiles
    IF refreshDue = 2 THEN refreshDisplay
    IF TIME$ <> showTime$ AND showing = 0 THEN doTime
    k$ = INKEY$
    IF k$ <> "" THEN doKey
    'checkMouse
  LOOP
  
SUB refreshFiles
  LOCAL f$
  LOCAL INTEGER z
  DO : LOOP UNTIL INKEY$ = ""
  refreshDue = 0
  mf = 2
  mfs = 0
  fList$(0)= " . <dir>"
  fList$(1)= " .. <dir>"
  f$ = dir$("*", dir)
  DO WHILE f$ <> ""
    fList$(mf)= " "+f$+" <dir>"
    IF LEN(fList$(mf)) > mfs THEN mfs = LEN(fList$(mf))
    mf = mf + 1
    f$ = dir$()
  LOOP
  md = mf-2
  f$ = dir$("*", FILE)
  DO WHILE f$ <> ""
    fList$(mf)= f$
    IF LEN(fList$(mf)) > mfs THEN mfs = LEN(fList$(mf))
    mf = mf + 1
    f$ = dir$()
  LOOP
  
  IF mfs > cpl/2-2 THEN
    cpp = 1
  ELSEIF mfs > cpl/3-2 THEN
    cpp = 2
    columnStart(1) = mm.hres/2
  ELSE
    cpp = 3
    columnStart(1) = mm.hres/3
    columnStart(2) = mm.hres/3*2
  ENDIF
  perPg = cpp * rpp
  
  FOR z = mf TO maxFiles ' clear out any previous file names
    fList$(z)= ""
  NEXT z
  
  SORT fList$() ' after we sort, the blank cells need to be moved
  FOR z = 0 TO mf-1
    fList$(z)= fList$(z+maxFiles+1-mf)
    fCol(z) = dispCol(fList$(z))
  NEXT z
  FOR z = mf TO maxFiles
    fList$(z)= ""
  NEXT z
  refreshDisplay
END SUB
  
SUB refreshDisplay
  LOCAL f$
  LOCAL INTEGER ffp, fnx, row, col, z
  refreshDue = 0
  'inhibit_mouse = timer
  CLS
  COLOUR RGB(WHITE), RGB(BLACK)
  RESTORE helpTxt
  READ f$
  text 10,1,f$
  if useColour then
  text mm.hres/2,1,CWD$+"  "+str$(md)+" directories and "+str$(mf-md-2)+" files",CT,fs,1,rgb(cyan)
  else 
  text mm.hres/2,1,CWD$+"  "+str$(md)+" directories and "+str$(mf-md-2)+" files",CT,fs,1,rgb(white)
  endif
 ' text 750,1,"QUIT",LT,1,1,rgb(white),rgb(red)
  ffp = fn - (fn MOD perPg)  ' first fn on this page
  FOR fnx = ffp TO mf
    IF fnx > ffp + perPg - 1 THEN EXIT FOR
    col = columnStart(fnx MOD cpp)
    row = INT(((fnx MOD perPg)/cpp+2)*cHt)
    text col,row,fList$(fnx),LT,fs,1,fCol(fnx)
  NEXT fnx
  oldFn = fn
  highLight fn
  text 1, helpLine, statusline$,LT,fs,1,rgb(black),rgb(white)
END SUB
  
SUB highLight fn AS INTEGER
  LOCAL INTEGER row, col
  col = columnStart(oldFn MOD cpp)
  row = INT(((oldFn MOD perPg)/cpp+2)*cHt)
  text col, row,fList$(oldFn),LT,fs,1,fCol(oldFn),rgb(black)
  IF fn > (mf-1) THEN fn = mf-1
  oldFn = fn
  col = columnStart(fn MOD cpp)
  row = INT(((fn MOD perPg) /cpp+2)*cHt)
  text col, row, fList$(fn),LT,fs,1,rgb(black),fCol(fn)
' doDialog ' uncomment to clear info panel when selected file changes
END SUB
  
'> Main decisions here
SUB doKey
  LOCAL f$, cl$
  DO : LOOP UNTIL INKEY$ = ""
  IF showing = 99 THEN
    showing = 0
    refreshDue = 1
  ENDIF
  SELECT CASE k$
    CASE CHR$(128) ' Up
      IF showing <> 1 THEN
        fn = fn - cpp
        IF fn < 0 THEN fn = 0
        changeChosen fn
      ENDIF
    CASE CHR$(129) ' Down
      IF showing <> 1 THEN
        fn = fn + cpp
        IF fn > (mf-1) THEN fn = mf-1
        changeChosen fn
      ENDIF
    CASE CHR$(130) ' Left
      IF showing <> 1 THEN
        fn = fn - 1
        IF fn < 0 THEN fn = 0
        changeChosen fn
      ENDIF
    CASE CHR$(131) ' Right
      IF showing <> 1 THEN
        fn = fn + 1
        IF fn > (mf-1) THEN fn = mf-1
        changeChosen fn
      ENDIF
    CASE CHR$(136) ' page Up
      fn = fn - perPg
      IF fn < 0 THEN fn = 0
      refreshDue = 2
    CASE CHR$(137) ' page Down
      fn = fn + perPg
      IF fn > (mf-1) THEN fn = mf-1
      refreshDue = 2
    CASE CHR$(134) ' home
      IF showing <> 1 THEN
        CHDIR "\" ' root folder
        refreshFiles
        fn = md + 2
        IF fn > (mf-1) THEN fn = mf-1
        changeChosen fn
      ENDIF
    CASE CHR$(135) ' end
      IF showing <> 1 THEN
        fn = mf-1
        changeChosen fn
      ENDIF
    CASE CHR$(13),CHR$(10)
      f$ = fList$(fn)
      
      IF fileType$(f$) = "BAS" THEN
        CLS
        cl$ = cwd$
        IF RIGHT$(cl$,1)="/" THEN
          cl$ = cl$+f$
'RUN cwd$+f$
        ELSE
          cl$ = cl$+"/"+f$
'RUN cwd$+"/"+f$
        ENDIF
        'cl$ = "RUN "+CHR$(34)+cl$+CHR$(34)
        RUN cl$
        'doCl cl$
      ELSE
        showit f$
      ENDIF
    CASE "v", "v" '  view the file
      showit fList$(fn)
    CASE CHR$(27), CHR$(26) 'esc or ^z to exit viewing
      SELECT CASE showing
        CASE 1 ' image
          showing = 0
          refreshDue = 2
        CASE 2 ' text
          showing = 0
          refreshDue = 2
        CASE 3 ' audio
          PLAY STOP
          showing = 0
          refreshDue = 2
        CASE 4 ' GIF image
          LOAD GIF
          showing = 0
          refreshDue = 2
        CASE ELSE
          PLAY STOP
      END SELECT
      
    CASE "?", "I","i" ' i for info
      getDetails fList$(fn)
    CASE "C", "c" ' copy file
      fileCopy fList$(fn)
    CASE "H", "h" ' display help
      showHelp
    CASE "X","x" ' display file in HEX
      showHEX fList$(fn)
    CASE CHR$(127), "k", "k" ' delete file
      delFile fList$(fn)
    CASE "R","r"  ' rename
      fileName fList$(fn)
    CASE "N","n" ' new directory
      newDir
    CASE "S","s" ' send using xmodem
      sendX fList$(fn)
    CASE "T","t" ' show as text
      showTxtIf fList$(fn)
    CASE "M", "m" ' accept (receive) by xmodem
      receiveX
      case "A","a"
      drive "A:"
      refreshDue = 1
      case "B","b"
      drive "B:"
      refreshDue = 1
    case "F","f"' toggle font
      fs = 8-fs
      font fs
      cWth = MM.info(FONTWIDTH)
       cHt = MM.info(FONTHEIGHT)
  cpl = mm.hres/cWth
   lpp = mm.vres/cHt
      refreshDue = 1
      case "U","u" ' useColour
      useColour = 1- useColour
      refreshDue = 1
    CASE "P", "p" ' print screen
      SAVE IMAGE "PS"+MID$(DATE$,9,2)+MID$(DATE$,4,2)+MID$(DATE$,1,2)+MID$(TIME$,1,2)+MID$(TIME$,4,2)+".bmp"
    CASE "Q","q" ' quit
      SELECT CASE showing
        CASE 1 ' image
          showing = 0
          refreshDue = 2
        CASE 2 ' text
          showing = 0
          refreshDue = 2
        CASE 3 ' audio
          PLAY STOP
        CASE ELSE
          PLAY STOP
          CLS
          doEND
      END SELECT
    CASE ELSE
'PRINT @(1, 455, 0) ASC(k$)
  END SELECT
  k$ = ""
  
END SUB
  
SUB doEND
  'if mouse_port > -1 then
    'CONTROLLER MOUSE CLOSE mouse_port
    'GUI CURSOR OFF
  'endif
  CHDIR "\"
  'MODE 1,8
  CLS
END
END SUB
  
SUB doTime
  LOCAL INTEGER col, row
  showTime$ = left$(TIME$,5)
  text mm.hres-40, 1, showTime$
' put cursor back at the selected file
  col = columnStart(fn MOD cpp)
  row = INT(((fn MOD perPg) /cpp+2)*cHt)
'  COLOUR fCol(fn)
'  PRINT @(col, row, 2) "";
'  COLOUR(RGB(WHITE))
END SUB
  
SUB changeChosen fn AS INTEGER ' check to see if we need to page up or down
  IF INT(oldFn/perPg)<>INT(fn/perPg) THEN
    refreshDisplay
  ELSE
    highLight fn
  ENDIF
END SUB
  
SUB showit f$
  LOCAL tp$
  LOCAL INTEGER xOffset, yOffset
  tp$ = fileType$(f$)
'print "File ";f$
  SELECT CASE tp$
    CASE "<dir>"
      f$ = MID$(f$,2,LEN(f$)-7)
      CHDIR f$
      refreshDue = 1
    CASE "BAS", "INC", "TXT", "CSV"
      showing = 2
      showTxt f$
    CASE "fnt"
      showing = 1
      showFont f$
    CASE "MOD"
      PLAY STOP
      showing = 3
      PLAY MODFILE f$, playEnded
    CASE "MP3"
      PLAY STOP
      showing = 3
      PLAY MP3 f$, playEnded
    CASE "WAV"
      PLAY STOP
      showing = 3
      PLAY WAV f$, playEnded
    CASE "FLAC"
      PLAY STOP
      showing = 3
      PLAY FLAC f$, playEnded
    CASE "BMP"
      bmpInfo f$, onDisk, iWdth, iHt, info$
      CLS
      xOffset = INT((mm.hres-iWdth)/2) ' centre image on screen
      yOffset = INT((mm.vres-iHt)/2)
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt
      text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)
      showing = 1
      LOAD image f$, xOffset, yOffset
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt
      text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)
    CASE "JPG"
      jpgInfo f$, onDisk, iWdth, iHt, info$
      CLS
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt;"  ";info$
      text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)+"  "+info$
      showing = 1
      IF INSTR(info$, "Progressive") THEN
        doDialog 1, " Unable to view 'progressive scan' images"
        showing = 99
      ELSEIF isBig(iWdth,iHt) THEN
        doDialog 1, STR$(iWdth)+" x "+STR$(iHt)+" is too Big for the display!!!"
        showing = 99
      ELSE
        xOffset = INT((800-iWdth)/2) ' centre image on screen
        yOffset = INT((600-iHt)/2)
        LOAD JPG f$ , xOffset, yOffset
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt;"  ";info$
        text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)+"  "+info$
      ENDIF
    CASE "PNG"
      pngInfo f$, onDisk, iWdth, iHt, info$
      CLS
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt;"  ";info$
      text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)+"  "+info$
      showing = 1
      IF isBig(iWdth,iHt) THEN
        doDialog 1, STR$(iWdth)+" x "+STR$(iHt)+" is too Big for the display!!!"
        showing = 99
      ELSE
        IF INSTR(info$, "Palettised") > 0 THEN
          doDialog 1, " Unable to view palettised images"
        ELSE
          xOffset = INT((800-iWdth)/2) ' centre image on screen
          yOffset = INT((600-iHt)/2)
'PAUSE 1000
          LOAD PNG f$, xOffset, yOffset
        ENDIF
      ENDIF
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt;"  ";info$
      text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)+"  "+info$
    CASE "GIF"
      gifInfo f$, onDisk, iWdth, iHt, info$
      CLS
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt;"  ";info$
      text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)+"  "+info$
'if iBits < 0 then print " ctrl-c to stop animation"
      showing = 4
      IF isBig(iWdth,iHt) THEN
        doDialog 1, STR$(iWdth)+" x "+STR$(iHt)+" is too Big for the display!!!"
        showing = 99
      ELSE
        xOffset = INT((800-iWdth)/2) ' centre image on screen
        yOffset = INT((600-iHt)/2)
        LOAD GIF f$, xOffset, yOffset
'PRINT @(8, 13, 0)f$;"  "; iWdth;" x ";iHt;"  ";info$
        text 8, cHt, f$+"  "+str$(iWdth)+" x "+str$(iHt)+"  "+info$
      ENDIF
    CASE ELSE
      IF isText(f$) = 1 THEN
        showing = 2
        showTxt f$
      ELSEIF isText(f$) = -1 THEN
        doDialog 1,  " Lines too long to display."
        showing = 99
      ELSE
        doDialog 1, " Doesn't look like a text file - use HEX viewer"
        showing = 99
      ENDIF
  END SELECT
END SUB
    
SUB getDetails f$
  LOCAL tp$
  tp$ = fileType$(f$)
  doDialog
  SELECT CASE tp$
    CASE "BAS", "TXT", "CSV", "INC"
      doDialog 1, " "+f$
      doDialog 2, " Date modified: "+MM.info(modified f$)
      doDialog 3, " Size on disk: "+STR$(MM.info(fileSize f$))+" bytes, "+STR$(txtInfo(f$))+" lines"
    CASE "JPG"
      jpgInfo f$, onDisk, iWdth, iHt, info$
      doDialog 1, " "+f$
      doDialog 2, " Date modified: "+MM.info(modified f$)
      doDialog 3, " Size on disk: "+STR$(onDisk,7,0)+" bytes, "+str$(iWdth)+" wide, "+str$(iHt)+" high, "+info$
      IF isBig(iWdth,iHt) THEN doDialog 4, str$(iWdth)+" x "+str$(iHt)+" is too Big for the display!!!"
      if iBits = -1 then doDialog 5, " Unable to view 'progressive scan' files."
    case "PNG"
      pngInfo f$, onDisk, iWdth, iHt, info$
      doDialog 1, " "+f$
      doDialog 2, " Date modified: "+MM.info(modified f$)
      if instr(info$, "Palettised") > 0 then
        doDialog 3, " Size on disk: "+STR$(onDisk,7,0)+" bytes, "+str$(iWdth)+" wide, "+str$(iHt)+" high, "+info$
        doDialog 4, " Unable to view palettised images."
      else
        doDialog 3, " Size on disk: "+STR$(onDisk,7,0)+" bytes, "+str$(iWdth)+" wide, "+str$(iHt)+" high, "+info$
        IF isBig(iWdth,iHt) THEN doDialog 4, str$(iWdth)+" x "+str$(iHt)+" is too Big for the display!!!"
      endif
    case "BMP"
      bmpInfo f$, onDisk, iWdth, iHt, info$
      doDialog 1, " "+f$
      doDialog 2, " Date modified: "+MM.info(modified f$)
      doDialog 3, " Size on disk: "+STR$(onDisk,7,0)+" bytes, "+str$(iWdth)+" wide, "+str$(iHt)+" high, "+info$
      IF isBig(iWdth,iHt) THEN doDialog 4, str$(iWdth)+" x "+str$(iHt)+" is too Big for the display!!!"
    case "GIF"
      gifInfo f$, onDisk, iWdth, iHt, info$
      doDialog 1, " "+f$
      doDialog 2, " Date modified: "+MM.info(modified f$)
      doDialog 3, " Size on disk: "+STR$(onDisk,7,0)+" bytes, "+str$(iWdth)+" wide, "+str$(iHt)+" high, "+info$
      
      IF isBig(iWdth,iHt) THEN doDialog 4, str$(iWdth)+" x "+str$(iHt)+" is too Big for the display!!!"
      
    CASE "MP3"
      mp3Info f$
    CASE "WAV"
      wavInfo f$
    CASE "FLAC"
      flacInfo f$
    CASE "<dir>"
      doDialog 1, " "+f$+" - Directory"
    case "fnt"
      fontInfo f$
    CASE ELSE
      doDialog 1, " "+f$
      doDialog 2, " Date modified: "+MM.info(modified f$)
      doDialog 3, " Size on disk: "+str$(MM.info(fileSize f$))+" bytes"
  END SELECT
END SUB
  
SUB playEnded
  if MM.info$(SOUND) <> "OFF" then
    PLAY STOP
  endif
  showing = 0
  refreshDue = 2
END SUB
  
FUNCTION fileType$(f$) ' returns file extension
  LOCAL INTEGER p
  IF RIGHT$(f$,5)="<dir>" THEN
    fileType$ = "<dir>"
  ELSE
    p = INSTR(f$,".")
    if p > 0 then
      for p = len(f$) to 1 step -1
        if mid$(f$,p,1)="." then exit for
      next p
    endif
    IF p > 0 AND p < (LEN(f$)-1) THEN fileType$ = UCASE$(MID$(f$,p+1))
  ENDIF
END FUNCTION
  
FUNCTION dispCol(f$) AS INTEGER ' display colour for various file types
  LOCAL t$
  t$ = fileType$(f$)
  if useColour then
  SELECT CASE t$
    CASE "BAS", "INC"
      dispCol =  RGB(RED)
    CASE "<dir>"
      dispCol =  RGB(127,127,255)
    CASE "TXT","CSV","LOG"
      dispCol =  RGB(GREEN)
    CASE "BMP","JPG","PNG","GIF"
      dispCol =  RGB(CYAN)
    CASE "MOD", "WAV", "FLAC", "MP3"
      dispCol =  RGB(YELLOW)
    case "FNT"
      dispCol =  RGB(magenta)
    CASE ELSE
      dispCol = RGB(WHITE)
  END SELECT
  else
      dispCol = RGB(WHITE)
  
  endif
END FUNCTION
  
function isBig(iWdth AS INTEGER, iHt AS INTEGER) as integer
  IF iWdth > mm.hres OR iHt > mm.vres THEN
    isBig = 1
  ELSE
    isBig = 0
  ENDIF
end function
  
sub jpgInfo f$, onDisk AS INTEGER, iWdth AS INTEGER, iHt AS INTEGER, info$
  LOCAL INTEGER block, bs, n
  LOCAL x$
  onDisk = MM.info(filesize f$)
  info$ = ""
  OPEN f$ FOR INPUT AS #2
  DO
    block = ASC(INPUT$(1,#2)) ' flag for start of block
    IF block = 255 THEN
      block = ASC(INPUT$(1,#2)) ' block Type
      IF block = &hC0 THEN
        x$ = INPUT$(3,#2)
        iHt = ASC(INPUT$(1,#2))*256 + ASC(INPUT$(1,#2))
        iWdth = ASC(INPUT$(1,#2))*256 + ASC(INPUT$(1,#2))
        EXIT DO
      elseif block = &hC2 THEN
        info$ = "Progressive"
        x$ = INPUT$(3,#2)
        iHt = ASC(INPUT$(1,#2))*256 + ASC(INPUT$(1,#2))
        iWdth = ASC(INPUT$(1,#2))*256 + ASC(INPUT$(1,#2))
        exit do
      elseif block >= &hD0 and block <= &hD9 then
' do nothing
      else
        bs = ASC(INPUT$(1,#2))*256 + ASC(INPUT$(1,#2))
'print hex$(block), "  ",bs
        if bs > 4 then
          for n = 1 to bs-4
            x$ = INPUT$(1,#2)
          next n
        endif
      ENDIF
    ENDIF
  LOOP
  CLOSE #2
END SUB
  
sub bmpInfo f$, onDisk AS INTEGER, iWdth AS INTEGER, iHt AS INTEGER, info$
  LOCAL x$
  'print f$
  f$ = lcase$(f$)
  onDisk = MM.info(filesize f$)
  OPEN f$ FOR INPUT AS #2
  x$ = INPUT$(18,#2) ' skip this
  iWdth = ASC(INPUT$(1,#2))+ASC(INPUT$(1,#2))*256
  iWdth = iWdth +ASC(INPUT$(1,#2))*2^16+ASC(INPUT$(1,#2))*2^24
  iHt = ASC(INPUT$(1,#2))+ASC(INPUT$(1,#2))*256
  iHt = iHt +ASC(INPUT$(1,#2))*2^16+ASC(INPUT$(1,#2))*2^24
  x$ = INPUT$(2,#2) ' colour planes - not used
  info$ = str$(ASC(INPUT$(1,#2))+ASC(INPUT$(1,#2))*256)+" bit"
  CLOSE #2
END SUB
  
sub gifInfo f$, onDisk AS INTEGER, iWdth AS INTEGER, iHt AS INTEGER, info$
  LOCAL x$, iBits as integer
  onDisk = MM.info(filesize f$)
  OPEN f$ FOR INPUT AS #2
  x$ = INPUT$(6,#2) ' skip this GIF89a
  iWdth = ASC(INPUT$(1,#2))+ASC(INPUT$(1,#2))*256
  iHt = ASC(INPUT$(1,#2))+ASC(INPUT$(1,#2))*256
  x$ = INPUT$(1,#2) ' colour table start and bits
  iBits = (asc(x$) and &b00000111) + 1
'if (asc(x$) and &b10000000) then iBits = 0 - iBits ' indicate animated image
  CLOSE #2
  info$ = str$(iBits)+" bit"
END SUB
  
sub pngInfo f$, onDisk AS INTEGER, iWdth AS INTEGER, iHt AS INTEGER, info$
' data from https://en.wikipedia.org/wiki/Portable_Network_Graphics
  LOCAL x$, iBits as integer
  onDisk = MM.info(filesize f$)
  OPEN f$ FOR INPUT AS #2
  x$ = INPUT$(12,#2)
  x$ = INPUT$(4,#2) ' should be IHDR
  iWdth = ASC(INPUT$(1,#2))*2^24 + ASC(INPUT$(1,#2))*2^16
  iWdth = iWdth +ASC(INPUT$(1,#2))*256 + ASC(INPUT$(1,#2))
  iHt = ASC(INPUT$(1,#2))*2^24 + ASC(INPUT$(1,#2))*2^16
  iHt = iHt +ASC(INPUT$(1,#2))*256 + ASC(INPUT$(1,#2))
  iBits = ASC(INPUT$(1,#2)) ' colour bits/pixel
  select case ASC(INPUT$(1,#2)) ' colour Type
    case 0
      info$ = str$(iBits)+" bit Grayscale"
    case 2
      info$ = str$(iBits*3)+" bit Truecolour"
    case 3
      info$ = str$(iBits)+" bit Palettised"
    case 4
      info$ = str$(iBits*2)+" bit Grayscale+Alpha"
    case 6
      info$ = str$(iBits*4)+" bit RGBA"
    case else
      info$ = str$(iBits)+" bit/pixel"
  end select
  
  CLOSE #2
END SUB
  
sub fontInfo f$
  LOCAL INTEGER onDisk, cc, cw, ch, cs, fnt
  LOCAL txt$
  onDisk = MM.info(filesize f$)
  OPEN f$ FOR INPUT AS #2
  DO WHILE NOT EOF(#2)
    LINE INPUT #2, txt$
    txt$ = ucase$(LTrim$(txt$))
    if fnt = 1 then
      cc = val("&h"+mid$(txt$,1,2)) ' character count
      cs = val("&h"+mid$(txt$,3,2)) ' character start
      ch = val("&h"+mid$(txt$,5,2)) ' character height
      cw = val("&h"+mid$(txt$,7,2)) ' character width
      exit do
    endif
    if left$(txt$,10) = "DEFINEFONT" then fnt = 1
  LOOP
  CLOSE #2
  doDialog 1, " "+f$
  doDialog 2," Date modified: "+MM.info(modified f$)
  if fnt = 1 then
    doDialog 3," "+str$(onDisk)+" bytes, "+str$(cc)+ " char(s) starting at chr$("+str$(cs)+"), "+str$(cw)+" wide x "+str$(ch)+" high"
    if cs < 32 then doDialog 4, "Characters below chr$(32) are not allowed."
  else
    doDialog 3," "+str$(onDisk)+" bytes, Not a valid Font file."
  endif
end sub
  
SUB flacInfo f$
' data from https://xiph.org/flac/format.html#def_STREAMINFO
  LOCAL INTEGER onDisk, bs, sf, ch
  LOCAL hdr$, st$
  onDisk = MM.info(filesize f$)
  OPEN f$ FOR INPUT AS #2
  hdr$ = INPUT$(4,#2)  ' should be "fLaC"
  hdr$ = INPUT$(4,#2)  ' skip this
  hdr$ = INPUT$(10,#2) ' skip this
  hdr$ = INPUT$(4,#2)
  hdr$ = BIN$(STR2BIN(UINT32, hdr$, big),32)
  sf = VAL("&B"+MID$(hdr$,1,20))     ' sample rate
  ch = VAL("&B"+MID$(hdr$,21,3)) + 1 ' channels
  bs = VAL("&B"+MID$(hdr$,24,5)) + 1 ' bits/sample
  IF ch = 1 THEN
    st$ = "Mono"
  ELSEIF ch = 2 THEN
    st$ = "Stereo"
  ELSE
    st$ = STR$(ch)+" channels"
  ENDIF
  CLOSE #2
  doDialog 1, " "+f$
  doDialog 2," Date modified: "+MM.info(modified f$)
  doDialog 3, " "+STR$(onDisk,8,0)+" bytes, "+str$(bs)+" bits/sample, "+str$(sf)+" Hz, "+st$
END SUB
  
SUB wavInfo f$
' data from http://www.topherlee.com/software/pcm-tut-wavformat.html
  LOCAL INTEGER onDisk, bs, sf, ch
  LOCAL hdr$, st$
  onDisk = MM.info(filesize f$)
  OPEN f$ FOR INPUT AS #2
  hdr$ = INPUT$(20,#2) ' skip this
  hdr$ = INPUT$(2,#2)  ' Type of format
  hdr$ = INPUT$(2,#2)  ' no of channels
  ch = STR2BIN(UINT16, hdr$)
  IF ch = 2 THEN
    st$ = "Stereo"
  ELSE
    st$ = "Mono"
  ENDIF
  hdr$ = INPUT$(4,#2) ' sample rate
  sf = STR2BIN(UINT32, hdr$)
  hdr$ = INPUT$(4,#2) ' sample rate * b/s * ch / 8
  hdr$ = INPUT$(2,#2) ' b/s * ch / 8
  hdr$ = INPUT$(2,#2) ' bits / sample
  bs = STR2BIN(UINT16, hdr$)
  CLOSE #2
  doDialog 1, " "+f$
  doDialog 2," Date modified: "+MM.info(modified f$)
  doDialog 3," "+STR$(onDisk,8,0)+" bytes, "+str$(bs)+" bits/sample, "+str$(sf)+" Hz, "+st$
END SUB
  
SUB mp3Info f$
' data from http://mpgedit.org/mpgedit/mpeg_format/mpeghdr.htm
  LOCAL INTEGER onDisk, vl, br, sf, ss, n
  LOCAL FLOAT v
  LOCAL hdr$, st$, dur$
  MP3sections = 0
  MP3duration = 0
  onDisk = MM.info(filesize f$)
  if onDisk > 1000000 then doDialog 1, " This will take some time..."
  OPEN f$ FOR INPUT AS #2
  ss = 1
  do
    seek #2,ss
    hdr$ = INPUT$(10,#2)
    for n = 0 to 3
      mp3Hdr(n) = asc(mid$(hdr$,n+1,1))
    next n
    if mp3Hdr(0) = &hff And (mp3Hdr(1) and &he0) = &he0 then
      ss = ss + parseHeader()
    elseif mp3Hdr(0) = &h54 and mp3Hdr(1) = &h41 and mp3Hdr(2) = &h47 then ' TAG
      ss = ss + 128
    elseif mp3Hdr(0) = &h49 and mp3Hdr(1) = &h44 and mp3Hdr(2) = &h33 then 'ID3
      for n = 4 to 9
        mp3Hdr(n) = asc(mid$(hdr$,n+1,1))
      next n
      ss = ss + skipID3()
    else
      exit do
    endif
  loop until ss >=onDisk
  close #2
  dur$ = mid$(DATETIME$(int(MP3duration)),12)
  
  doDialog 1, " "+f$ '+ " "+str$(ss)+" "+bin$(mp3Hdr(0),8)+" "+bin$(mp3Hdr(1),8)
  doDialog 2, " Date modified: "+MM.info(modified f$)+" "+STR$(onDisk,8,0)+" Bytes, "
  doDialog 3, " "+MP3Specs$+ ", Duration: "+dur$
  
END SUB
  
function skipID3() as integer
  local integer footersize, tagsize, z0, z1, z2, z3
  
  if (mp3Hdr(5) and &h10) = 0 then
    footersize = 0
  else
    footersize = 10
  endif
  z0 = mp3Hdr(6)
  z1 = mp3Hdr(7)
  z2 = mp3Hdr(8)
  z3 = mp3Hdr(9)
  if (z0 and &h80) +(z1 and &h80)+(z2 and &h80)+(z3 and &h80) = 0 then
    tagsize = (z0 and &h7f) * 2097152 + (z1 and &h7f) * 16384 + (z2 and &h7f) * 128 + (z3 and &h7f)
  EndIf
  skipID3 = 10 + footersize + tagsize
end function
  
function parseHeader() as integer
  local integer b1, b2, b3, versionBits, layerBits, bitrateIdx, bitRate, samplerateIdx, sampleRate
  local integer sample, paddingBit, frameSize, chMode, L
  local string chm$, version$, layer$, fullVersion$
  b1 = mp3Hdr(1)
  b2 = mp3Hdr(2)
  b3 = mp3Hdr(3)
  MP3sections = MP3sections + 1
  versionBits = (b1 and &h18) >> 3
  version$ = Field$("2.5,x,2,1",versionBits+1,",")
  layerBits = (b1 and &h06) >> 1
  layer$ = Field$("x,3,2,1",layerBits+1,",")
  
  fullVersion$ = "v" + version$ + "L" + layer$
  bitrateIdx = (b2 and &hf0) >> 4
  
  select case fullVersion$
    Case "V1L3"
      bitRate = Val(Field$("0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320",bitrateIdx+1,","))
    Case "V1L1"
      bitRate = Val(Field$("0,32,64,96,128,160,192,224,256,288,320,352,384,416,448",bitrateIdx+1,","))
    Case "V1L2"
      bitRate = Val(Field$("0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384",bitrateIdx+1,","))
    Case "V2L1","V2.5L1"
      bitRate = Val(Field$("0,32,48,56, 64, 80, 96,112,128,144,160,176,192,224,256",bitrateIdx+1,","))
    Case "V2L2","V2L3","V2.5L2","V2.5L3"
      bitRate = Val(Field$("0, 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160",bitrateIdx+1,","))
    case else
      bitRate = 0
  End Select
  samplerateIdx = (b2 and &h0C) >> 2
  L = Val(layer$)
  Select case version$
    Case "1"
      sampleRate = Val(Field$("44100, 48000, 32000",samplerateIdx+1,","))
      sample = Val(Field$("384, 1152, 1152",L,","))
    Case "2"
      sampleRate = Val(Field$("22050, 24000, 16000",samplerateIdx+1,","))
      sample = Val(Field$("384, 1152, 576",L,","))
    Case "2.5"
      sampleRate = Val(Field$("11025, 12000,  8000",samplerateIdx+1,","))
      sample = Val(Field$("384, 1152, 576",L,","))
    case else
      sampleRate = 0
      sample = 0
  End Select
  paddingBit = (b2 and &h02) >> 1
  chMode = (b3 and &hC0) >> 6
  If chMode = 3 then
    chm$ = "Mono"
  Else
    chm$ = "Stereo"
  EndIf
  If layer$ = "1" then
    frameSize = int((sample * bitRate * 125 / sampleRate) + paddingBit * 4)
  Else ' layer 2, 3
    frameSize = int((sample * bitRate * 125 / sampleRate) + paddingBit)
  EndIf
  
  if MP3sections = 1 then
    MP3Specs$ = fullVersion$+"  "+str$(bitRate) +"kbps, " +str$(sampleRate)+"Hz, "+chm$
  endif
  if sampleRate > 0 then
    MP3duration = MP3duration + sample/sampleRate
  endif
  parseHeader = frameSize
end function
  
SUB delFile f$
  LOCAL k$
  doDialog 1, "Do you want to delete "+f$+"? y/n "
  DO
    k$ = INKEY$
  LOOP UNTIL k$ <>""
  IF k$ = "y" OR k$ = "y" THEN
    IF fileType$(f$) = "<dir>" THEN
      IF isEmpty(f$) THEN
        KILL f$
      ELSE
        doDialog 2, " Directory not empty!!!"
        PAUSE 2000
      ENDIF
    ELSE
      KILL f$
    ENDIF
    refreshDue = 1
  ENDIF
END SUB
  
FUNCTION isEmpty(f$) AS INTEGER ' check to see if a directory is empty
  LOCAL k$
  IF fileType$(f$) = "<dir>" THEN
    f$ = MID$(f$,2,LEN(f$)-7)
    CHDIR f$
    k$ = dir$("*", dir)+dir$("*", FILE)
    CHDIR ".."
    IF k$ = "" THEN
      isEmpty = 1
    ENDIF
  ENDIF
END FUNCTION
  
FUNCTION isText(f$) AS INTEGER ' returns 1 - text , -1 no LineEnd, 0 - not text
  LOCAL txt$
  LOCAL INTEGER n, c
  isText = 1
  OPEN f$ FOR INPUT AS #2
  txt$ = INPUT$(255,#2)
  FOR n = 1 TO LEN(txt$)
    c = ASC(MID$(txt$,n,1))
    IF  c > 127 OR (c  > 0 AND c < 8) OR (c > 13 AND c < 32 AND c <> 27 and c <> 26) THEN
      isText = 0
      EXIT FOR
    ENDIF
  NEXT n
  CLOSE #2
  n = instr(txt$,chr$(10))
  if n = 0 then n = instr(txt$,chr$(13))
  if n = 0 then isText = 0 - isText
END FUNCTION
  
SUB fileName f$
  LOCAL fNew$, k$, ff$
'doDialog
  doDialog 1, "Enter new name for "+f$+" or blank for no change"
  doDialog 2," "
  print
  IF fileType$(f$) = "<dir>" THEN
    ff$ = MID$(f$,2,LEN(f$)-7)
  ELSE
    ff$ = f$
  ENDIF
  INPUT fNew$
  IF fNew$ <> "" THEN
    k$ = dir$(fNew$)
    IF k$ = "" THEN
      RENAME ff$ AS fNew$
      refreshDue = 1
    ELSE
      doDialog 1,  fNew$+" already exists!"
    ENDIF
  ELSE
    doDialog
  ENDIF
END SUB
  
SUB fileCopy f$
  LOCAL fNew$, k$, ff$
  doDialog
  doDialog 1, "Enter new name for "+f$+" copy or blank to cancel"
  doDialog 2," "
  print
  IF fileType$(f$) = "<dir>" THEN
    ff$ = MID$(f$,2,LEN(f$)-7)
  ELSE
    ff$ = f$
  ENDIF
  INPUT fNew$
  IF fNew$ <> "" THEN
    k$ = dir$(fNew$)
    IF k$ = "" THEN
      COPY ff$ TO fNew$
      DO : LOOP UNTIL INKEY$ = ""
      refreshDue = 1
    ELSE
      doDialog 1,  fNew$+" already exists!"
    ENDIF
  ELSE
    doDialog
  ENDIF
END SUB
  
SUB newDir
  LOCAL fNew$, k$
  doDialog
  doDialog 1, "Enter new directory or blank for no change"
  doDialog 2," "
  print
  INPUT fNew$
  IF fNew$ <> "" THEN
    k$ = dir$(fNew$)
    IF k$ = "" THEN
      MKDIR fNew$
      refreshDue = 1
    ELSE
      doDialog 1,  fNew$+" already exists!"
    ENDIF
  ELSE
    doDialog
  ENDIF
END SUB
  
SUB sendX f$
'doDialog
  doDialog 1,  "Sending ";f$
  on error skip 1
  XMODEM SEND f$
  doDialog 2,  "Sent!"
END SUB
  
sub receiveX
  LOCAL fNew$, k$, ff$
  doDialog 1, "Enter file name or blank to abort"
  print " ";
  INPUT fNew$
  k$ = dir$(fNew$)
  doDialog
  IF fNew$ <> "" THEN
'PRINT SPACE$(90)
    IF k$ = "" THEN
      doDialog 1,  "Receiving "+fNew$
      XMODEM receive fNew$
      doDialog 2, "Receive finished!"
      pause 500
      refreshFiles
      fn = fileIndex(fNew$)
      highLight fn
    ELSE
      doDialog 1, fNew$+" already exists!"
    ENDIF
  ENDIF
end sub
  
'SUB setCurrent f$ ' doesn't work from within a program
'  PRINT @(1, infoLine, 0) SPACE$(80)
'  IF fileType$(f$) = "BAS" THEN
'    OPTION CURRENT f$
'    PRINT @(1, infoLine, 0)  "'Current' file now: ";f$
'  ELSE
'    PRINT @(1, infoLine, 0)  f$; " is not a BAS file."
'  ENDIF
'END SUB
  
sub showFont f$
  LOCAL INTEGER onDisk, cc, cw, ch, cs, fnt, rows, c,x,y
  local float cpr
  LOCAL txt$
  onDisk = MM.info(filesize f$)
  OPEN f$ FOR INPUT AS #2
  DO WHILE NOT EOF(#2)
    LINE INPUT #2, txt$
    txt$ = ucase$(LTrim$(txt$))
    if fnt = 1 then
      cc = val("&h"+mid$(txt$,1,2)) ' character count
      cs = val("&h"+mid$(txt$,3,2)) ' character start
      ch = val("&h"+mid$(txt$,5,2)) ' character height
      cw = val("&h"+mid$(txt$,7,2)) ' character width
      exit do
    endif
    if left$(txt$,10) = "DEFINEFONT" then fnt = 1
  LOOP
  close #2
  cls
  print f$;"   ";cc; " char(s) starting at chr$(";cs;"), ";cw;" wide x ";ch;" high"
  if cs < 32 then
    print " Characters below chr$(32) are not allowed."
  else
    cpr = int((sqr(cc)*1.5+3)/4)*4  'characters per line
    if cpr > cc then cpr = cc
    rows = cc/cpr+1
    x = (mm.hres-cpr*cw)/2 ' center font on screen
    y = (mm.vres-rows*ch)/2
    load font f$
    font 9
    print @(x,y);
    for c = 0 to cc-1
      if (c mod cpr) = 0 then
        print @(x,y);
        y = y +ch
      endif
      print chr$(c+cs);
    next c
    font fs
  endif
end sub
  
sub showTxtIf f$ ' check text file before showing
  local integer ist
  ist = isText(f$)
  if  ist = 1 then
    showing = 2
    showTxt f$
  elseif ist = -1 then
    doDialog 1, " Lines too long to display."
    showing = 99
  else
    doDialog 1, " Doesn't look like a text file - use HEX viewer"
    showing = 99
  endif
end sub
  
SUB showTxt f$
  LOCAL INTEGER row, fSize, fpos, p
  LOCAL txt$
  CLS
'  zeroWheel
  FOR p = 0 TO 50
    pageStart(p) = 0
  NEXT p
  row = 2
  OPEN f$ FOR INPUT AS #2
  fSize = LOF(#2)
  PRINT @(8, cHt, 2) f$ ;"     ";STR$(fSize,8,0);" bytes"
  txt$ = INPUT$(255,#2) ' check for line feed
  if instr(txt$,chr$(10)) = 0 then
    print " Line feed not detected - use HEX viewer"
  else
    seek #2, 1
    DO WHILE NOT EOF(#2)
      LINE INPUT #2, txt$
      PRINT @(8, row*cHt, 0) LEFT$(txt$,98)
      row = row + 1
      fpos = fpos + LEN(txt$)+1
      IF LEN(txt$) > 98 THEN
        PRINT @(8, row*cHt, 0) MID$(txt$,99,98)
        row = row + 1
        IF LEN(txt$) > 196 THEN
          PRINT @(8, row*cHt, 0) MID$(txt$,197)
          row = row + 1
        ENDIF
      ENDIF
      
      IF row > (lpp-6) OR EOF(#2) THEN
        p = (p+1) MOD 50
        pageStart(p) = fpos
        PRINT @(8, helpLine, 0) " Press any key to continue, PGup to go back or esc to quit...";
        PRINT @(8, cHt, 2) f$ ;"     ";STR$(fpos,8,0);"/";STR$(fSize,8,0);" bytes"
        DO
          k$ = INKEY$
'          if k$ = "" then k$ = checkMB$()
        LOOP UNTIL k$<>""
        IF k$ = CHR$(27) THEN
          showing = 0
          refreshDue = 2
          EXIT DO
        ELSEIF k$ = CHR$(136) or k$ = CHR$(128) THEN ' page up
          p = (p+48) MOD 50
          fpos = pageStart(p)  'to the start of 2 pages back
          IF fpos < 0 THEN fpos = 0
          SEEK #2, fpos
          CLS
          row = 2
        ELSEIF EOF(#2) THEN
          p = (p+49) MOD 50
          fpos = pageStart(p)  'to the start of last page
          IF fpos < 0 THEN 
          fpos = 0
          SEEK #2, fpos+1
          else
          SEEK #2, fpos
          endif
          CLS
          row = 2
        ELSE
          CLS
          row = 2
        ENDIF
      ENDIF
    LOOP
  endif
  CLOSE #2
END SUB
  
SUB showHEX f$
  LOCAL INTEGER row, fSize, fpos, n
  LOCAL txt$, hx$
  CLS
'  zeroWheel
  showing = 2
  row = 2
  OPEN f$ FOR INPUT AS #2
  fSize = LOF(#2)
  PRINT @(8, cHt, 2) f$ ;"     ";STR$(fSize,8,0);" bytes"
  DO WHILE NOT EOF(#2)
    txt$ = INPUT$(16, #2)
    hx$=HEX$(fpos,8)+"  "
    FOR n = 1 TO LEN(txt$)
      hx$=hx$+HEX$(ASC(MID$(txt$,n,1)),2)+" "
    NEXT n
    IF LEN(hx$) < 62 THEN hx$=hx$+SPACE$(62-LEN(hx$))
    FOR n = 1 TO LEN(txt$)
      IF ASC(MID$(txt$,n,1))>32 AND ASC(MID$(txt$,n,1)) < 127 THEN
        hx$=hx$+MID$(txt$,n,1)
      ELSE
        hx$=hx$+"."
      ENDIF
      
    NEXT n
    PRINT @(8, row*cHt, 0) hx$
    row = row + 1
    fpos = fpos + 16
    IF row > (lpp-6) OR EOF(#2) THEN
      PRINT @(8, helpLine, 0) " Press any key to continue, PGup to go back  or esc to quit...";
      PRINT @(8, cHt, 2) f$ ;"     ";STR$(fpos,8,0);"/";STR$(fSize,8,0);" bytes"
      DO
        k$ = INKEY$
'        if k$ = "" then k$ = checkMB$()
      LOOP UNTIL k$<>""
      IF k$ = CHR$(27) THEN
        showing = 0
        refreshDue = 2
        EXIT DO
      ELSEIF k$ = CHR$(136) or k$ = CHR$(128) THEN ' page up
        fpos = fpos - row*16*2  'to the start of 2 pages back
        IF fpos < 0 THEN 
          fpos = 0
          SEEK #2, fpos+1
          else
          SEEK #2, fpos
          endif
        CLS
        row = 2
      ELSE
        CLS
        row = 2
      ENDIF
    ENDIF
  LOOP
  CLOSE #2
END SUB
  
FUNCTION txtInfo(f$) AS INTEGER ' count the number of lines in a text file
  LOCAL txt$
  OPEN f$ FOR INPUT AS #2
  DO WHILE NOT EOF(#2)
    LINE INPUT #2, txt$
    txtInfo = txtInfo + 1
  LOOP
  CLOSE #2
END FUNCTION
  
SUB showHelp
  LOCAL INTEGER row
  local float ds, df, du
  LOCAL txt$
  ds = MM.info(disk size)/1000000 ' 1048576 used 1000000 to agree with Windows
  df = MM.info(free SPACE)/1000000
  du = ds - df
  
  showing = 2
  CLS
  row = 2
  RESTORE helpTxt
  DO
    READ txt$
    PRINT @(8, row*cHt, 0) txt$
    row = row + 1
  LOOP UNTIL txt$ = ""
  PRINT " MMBasic v";MM.info(version);"       Disk used ";STR$(du,6,1);" MB with ";STR$(df,6,1);" MB free"
  PRINT ""
  MEMORY
  option list
END SUB
  
helpTxt:
  DATA " FE v1.4"
  DATA " Use arrow keys to move between files, PgUp/PgDown to change pages"
  data " Home- Change to first file in root folder"
  data " End - select last file in current folder"
  DATA " Enter View Image and text files, PLAY audio files,"
  DATA "       load and RUN BAS files change folder"
  data " a/b - change drive"
  Data " f   - toggle font size"
  data " u   - toggle colour"
  DATA " v   - view file (including BAS files)"
  data " t   - view as text"
  DATA " x   - view as HEX"
  DATA " esc - quit viewing or playing."
  DATA " i   - display info about the file"
  DATA " s   - send file to PC using XMODEM"
  DATA " m   - accept file from PC using XMODEM"
  DATA " del - permanently delete file."
  DATA " k   - permanently delete file."
  DATA " r   - rename file"
  DATA " c   - copy file"
  DATA " n   - make new directory"
  DATA " h   - display this help"
  DATA " q   - Quit"
  DATA ""
  
sub doDialog iLine as integer, message$ ' iLine = 0 to clear all lines
  static integer cleared
  message$ = left$(message$,90)
  if iLine = 0 then
    if cleared = 0 then
      BOX 1, infoLine, mm.hres-1, 7*cHt,1,rgb(black),rgb(black)
      cleared = 1
    endif
  elseif iLine = 1 then
    BOX 1, infoLine, mm.hres-1, 7*cHt,1,rgb(gray),rgb(black)
    text 2, infoLine+iLine*cHt, message$+space$(90-len(message$))
    cleared = 0
  else
    text 2, infoLine+iLine*cHt, message$+space$(90-len(message$))
    cleared = 0
  endif
  DO : LOOP UNTIL INKEY$ = ""
end sub
  
FUNCTION LTrim$(a$)
  LOCAL integer n
  if len(a$)=0 then
    LTrim$ = ""
  else
    FOR n= 1 TO LEN(a$)
      IF MID$(a$,n,1)<>" " and MID$(a$,n,1)<>CHR$(9) THEN exit for
    NEXT n
    LTrim$=mid$(a$,n)
  endif
END FUNCTION
  
function fileIndex(f$) as integer
  local integer n
  for n = 2 to mf
    if ucase$(f$) = fList$(n) then fileIndex = n
  next n
end function
