'Micromite remote temperature and humidity sensor
'Uses DHT22 and nRF24L01+
' unknown author cira Jan 2015
SUB NRF.INIT
  NRF_CONFIG_RG=0
  NRF_ENAA_RG=1
  NRF_ENRXADDR_RG=2
  NRF_SETUPAW_RG=3
  NRF_SETUPRETR_RG=4
  NRF_RFCH_RG=5
  NRF_RFSETUP_RG=6
  NRF_STATUS_RG=7
  NRF_OBSERVETX_RG=8
  NRF_CD_RG=9
  NRF_RXADDRP0_RG=10
  NRF_RXADDRP1_RG=11
  NRF_RXADDRP2_RG=12
  NRF_RXADDRP3_RG=13
  NRF_RXADDRP4_RG=14
  NRF_RXADDRP5_RG=15
  NRF_TXADDR_RG=16
  NRF_RXPWP0_RG=17
  NRF_RXPWP1_RG=18
  NRF_RXPWP2_RG=19
  NRF_RXPWP3_RG=20
  NRF_RXPWP4_RG=21
  NRF_RXPWP5_RG=22
  NRF_FIFOSTATUS_RG=23
  NRF_CS=5
  NRF_CE=6
  NRF_IRQ=4
  NRF_ADDRESS_WIDTH=5
  NRF_PAYLOAD_WIDTH=4
  DIM NRF_ADDRESS(NRF_ADDRESS_WIDTH)
  DIM NRF_RX(NRF_PAYLOAD_WIDTH)
  DIM NRF_TX(NRF_PAYLOAD_WIDTH)
  PIN(NRF_CS)=1:SETPIN NRF_CS,8
  PIN(NRF_CE)=0:SETPIN NRF_CE,8
END SUB
  
FUNCTION NRF.BITTWIDDLE(num,place,value)
  LOCAL junk$,temp$,x$
  x$=STR$(value)
  junk$=BIN$(num,8)
  FOR I=1 TO 8
    IF I=(8-(place-1)) THEN
      temp$=temp$+x$
    ELSE
      temp$=temp$+MID$(junk$,I,1)
    ENDIF
  NEXT I
  NRF.BITTWIDDLE=VAL("&b"+temp$)
END FUNCTION
  
SUB NRF.POWERDOWN
  LOCAL junk
  junk=NRF.READREG(NRF_CONFIG_RG)
  junk=NRF.BITTWIDDLE(junk,2,0)
  NRF.WRITEREG(NRF_CONFIG_RG,junk)
END SUB
  
SUB NRF.POWERUP
  LOCAL junk
  junk=NRF.READREG(NRF_CONFIG_RG)
  junk=NRF.BITTWIDDLE(junk,2,1)
  NRF.WRITEREG(NRF_CONFIG_RG,junk)
END SUB
  
SUB NRF.SETTXADDR
  LOCAL junk
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(NRF_TX_ADDR_RG+32)
  FOR I = 1 TO NRF_ADDRESS_WIDTH
    junk=SPI(NRF_ADDRESS(I))
  NEXT I
  PIN(NRF_CS)=1
  SPI CLOSE
END SUB
  
SUB NRF.SETRXADDR(P)
  LOCAL pipe, junk
  pipe=&H0A+P
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(pipe+32)
  FOR I = 1 TO NRF_ADDRESS_WIDTH
    junk=SPI(NRF_ADDRESS(I))
  NEXT I
  PIN(NRF_CS)=1
  SPI CLOSE
END SUB
  
FUNCTION NRF.STATUS()
  LOCAL temp, x$,
  temp=NRF.READREG(NRF_STATUS_RG)
  NRF.STATUS=temp
  x$=BIN$(temp)
  DO
    x$="0"+x$
  LOOP UNTIL LEN(x$)=8
  NRF_TX_FULL=VAL(RIGHT$(x$,1))
  NRF_RX_P_NO=VAL("&B"+"mid$(x$,5,3)) "
  NRF_MAX_RT=VAL(MID$(x$,4,1))
  NRF_TX_DS=VAL(MID$(x$,3,1))
  NRF_RX_DR=VAL(MID$(x$,2,1))
  temp=NRF.READREG(NRF_FIFO_STATUS_REG)
  x$=BIN$(temp)
  DO
    x$="0"+x$
  LOOP UNTIL LEN(x$)=8
  NRF_TX_FULL=VAL(MID$(x$,3,1))
  NRF_TX_EMPTY=VAL(MID$(x$,4,1))
  NRF_RX_FULL=VAL(MID$(x$,7,1))
  NRF_RX_EMPTY=VAL(MID$(x$,8,1))
END FUNCTION
  
SUB NRF.READPAYLOAD
  LOCAL junk
  SPI OPEN 100000,0,8
  NRF_TXMODE
  DO
    PIN(NRF_CS)=0
    junk=SPI(&h61)
    FOR I=1 TO NRF_PAYLOAD_WIDTH
      NRF_RX(I)=SPI(&h0)
    NEXT I
    PIN(NRF_CS)=1
  LOOP UNTIL NRF.READREG(23)=17
  SPI CLOSE
  NRF.RXMODE
  PAUSE 200
END SUB
  
SUB NRF.SENDPAYLOAD
  LOCAL junk
  'NRF.RXMODE
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(&hA0)
  FOR I= 1 TO NRF_PAYLOAD_WIDTH
    junk=SPI(NRF_TX(I))
  NEXT I
  PIN(NRF_CS)=1
  NRF.RXMODE
  PAUSE 10
  NRF.TXMODE
  SPI CLOSE
END SUB
  
SUB NRF.CLEARRXDR
  NRF.WRITEREG(NRF_STATUS_RG,64)
END SUB
  
FUNCTION NRF.READREG(reg)
  LOCAL junk, mybyte
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(reg)
  mybyte=SPI(&H0)
  PIN(NRF_CS)=1
  SPI CLOSE
  NRF.READREG=mybyte
END FUNCTION
  
SUB NRF.FLUSHRX
  LOCAL junk
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(&hE2)
  PIN(NRF_CS)=1
  SPI CLOSE
END SUB
  
SUB NRF.FLUSHTX
  LOCAL junk
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(&HE1)
  PIN(NRF_CS)=1
  SPI CLOSE
END SUB
  
SUB NRF.WRITEREG(reg, mybyte)
  LOCAL junk
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(reg+32)
  junk=SPI(mybyte)
  PIN(NRF_CS)=1
  SPI CLOSE
END SUB
  
SUB NRF.RXMODE
  PIN(NRF_CE)=1
END SUB
  
SUB NRF.TXMODE
  PIN(NRF_CE)=0
END SUB
  
FUNCTION NRF.RX.AVAIL()
  NRF.RX.AVAIL=0
  x= NRF.READREG(NRF_FIFOSTATUS_RG)
  IF x=16 OR x=18 THEN NRF.RX.AVAIL=1
END FUNCTION

SUB TXSETUP
  SPI OPEN 1000000,0,8
  PIN(NRF_CE)=0
  NRF.WRITEREG(NRF_ENAA_RG,0)
  NRF.WRITEREG(NRF_ENRXADDR_RG,1)
  NRF.WRITEREG(NRF_RFCH_RG,2)
  NRF.WRITEREG(NRF_RXPWP0_RG,4)
  NRF.WRITEREG(NRF_RFSETUP_RG,38) '38 is high power low speed setting
  NRF.WRITEREG(NRF_CONFIG_RG,&B00001010)
  PIN(NRF_CE)=1
  SPI CLOSE
END SUB
  
SUB showRXaddress(x)
  LOCAL temprg, junk, mybyte
  temprg=&H0A+x
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(NRF_RXADDRP0_RG+x)
  FOR i=1 TO 5
    mybyte=SPI(&H0)
    PRINT mybyte;
  NEXT i
  PRINT ""
  PIN(NRF_CS)=1
  'NRF.READREG=byte1
  SPI CLOSE
END SUB
  
SUB showTXaddress
  LOCAL junk, mybyte
  SPI OPEN 1000000,0,8
  PIN(NRF_CS)=0
  junk=SPI(NRF_TXADDR_RG)
  FOR i=1 TO 5
    mybyte=SPI(&H0)
    PRINT mybyte;
  NEXT i
  PRINT ""
  PIN(NRF_CS)=1
  'NRF.READREG=byte1
  SPI CLOSE
END SUB
  
SUB showregs
  LOCAL junk,mybyte
  SPI OPEN 1000000,0,8
  FOR I=0 TO 23
    PIN(NRF_CS)=0
    junk=SPI(I)
    mybyte=SPI(&h0)
    PIN(NRF_CS)=1
    PRINT "REG #"+STR$(I)+" = "+STR$(mybyte)
    PAUSE 100
  NEXT I
  SPI CLOSE
END SUB
  
SUB preppayload
  LOCAL temp, humid
  DHT22 2, temp, humid
  temp=temp*10
  humid=humid*10
  NRF_TX(1)=temp>>8
  NRF_TX(2)=temp-(NRF_TX(1)*256)
  NRF_TX(3)=humid>>8
  NRF_TX(4)=humid-(NRF_TX(3)*256)
  FOR I =1 TO 4
    PRINT NRF_TX(I)
  NEXT I
END SUB
  
  'start
  NRF.INIT
  NRF.CLEARRXDR
  NRF.FLUSHRX
  TXSETUP
  PAUSE 10000
  DO
    NRF.POWERUP
    preppayload
    NRF.SENDPAYLOAD
    NRF.POWERDOWN
    PAUSE 1000
    CPU SLEEP 600
  LOOP
