  '
  OPTION EXPLICIT
  OPTION DEFAULT integer
  option base 0
  
  const I2C_ch = 2
  Const i2caddr=&h29
  const true = 1
  const false = 0
  
  Setpin Gp6,Gp7,I2c2
  I2c2 Open 400,1000
  setpin gp18, dout
  setpin gp5, dout
  setpin gp3, dout
  
  
sub L1X_initA(dev)
  local integer n, d
  for n = &h002D to &h0087
    read d
    L1X_write(dev, n,d)
  next n
end sub

'dim  L1X_ERROR
'
'#define VL53L1X_I2C_SLAVE__DEVICE_ADDRESS					&h0001
'#define VL53L1X_VHV_CONFIG__TIMEOUT_MACROP_LOOP_BOUND        &h0008
'#define ALGO__CROSSTALK_COMPENSATION_PLANE_OFFSET_KCPS 		&h0016
'#define ALGO__CROSSTALK_COMPENSATION_X_PLANE_GRADIENT_KCPS 	&h0018
'#define ALGO__CROSSTALK_COMPENSATION_Y_PLANE_GRADIENT_KCPS 	&h001A
'#define ALGO__PART_TO_PART_RANGE_OFFSET_MM					&h001E
'#define MM_CONFIG__INNER_OFFSET_MM							&h0020
'#define MM_CONFIG__OUTER_OFFSET_MM 							&h0022
'#define GPIO_HV_MUX__CTRL									&h0030
'#define GPIO__TIO_HV_STATUS       							&h0031
'#define SYSTEM__INTERRUPT_CONFIG_GPIO 						&h0046
'#define PHASECAL_CONFIG__TIMEOUT_MACROP     				&h004B
'#define RANGE_CONFIG__TIMEOUT_MACROP_A_HI   				&h005E
'#define RANGE_CONFIG__VCSEL_PERIOD_A        				&h0060
'#define RANGE_CONFIG__VCSEL_PERIOD_B						&h0063
'#define RANGE_CONFIG__TIMEOUT_MACROP_B_HI  					&h0061
'#define RANGE_CONFIG__TIMEOUT_MACROP_B_LO  					&h0062
'#define RANGE_CONFIG__SIGMA_THRESH 							&h0064
'#define RANGE_CONFIG__MIN_COUNT_RATE_RTN_LIMIT_MCPS			&h0066
'#define RANGE_CONFIG__VALID_PHASE_HIGH      				&h0069
'#define VL53L1X_SYSTEM__INTERMEASUREMENT_PERIOD				&h006C
'#define SYSTEM__THRESH_HIGH 								&h0072
'#define SYSTEM__THRESH_LOW 									&h0074
'#define SD_CONFIG__WOI_SD0                  				&h0078
'#define SD_CONFIG__INITIAL_PHASE_SD0        				&h007A
'#define ROI_CONFIG__USER_ROI_CENTRE_SPAD					&h007F
'#define ROI_CONFIG__USER_ROI_REQUESTED_GLOBAL_XY_SIZE		&h0080
'#define SYSTEM__SEQUENCE_CONFIG								&h0081
'#define VL53L1X_SYSTEM__GROUPED_PARAMETER_HOLD 				&h0082
'#define SYSTEM__INTERRUPT_CLEAR       						&h0086
'#define SYSTEM__MODE_START                 					&h0087
'#define VL53L1X_RESULT__RANGE_STATUS							&h0089
'#define VL53L1X_RESULT__DSS_ACTUAL_EFFECTIVE_SPADS_SD0		&h008C
'#define RESULT__AMBIENT_COUNT_RATE_MCPS_SD					&h0090
'#define VL53L1X_RESULT__FINAL_CROSSTALK_CORRECTED_RANGE_MM_SD0				&h0096
'#define VL53L1X_RESULT__PEAK_SIGNAL_COUNT_RATE_CROSSTALK_CORRECTED_MCPS_SD0 	&h0098
'#define VL53L1X_RESULT__OSC_CALIBRATE_VAL					&h00DE
'#define VL53L1X_FIRMWARE__SYSTEM_STATUS                      &h00E5
'#define VL53L1X_IDENTIFICATION__MODEL_ID                     &h010F
'#define VL53L1X_ROI_CONFIG__MODE_ROI_CENTRE_SPAD				&h013E
'#define ALGO__PART_TO_PART_RANGE_OFFSET_MM	&h001E
'#define MM_CONFIG__INNER_OFFSET_MM			&h0020
'
   '  turns on the sensor */
Sub L1X_On(dev as integer)
if dev then
pin(gp5) = true
else
pin(gp3) = true
endif
pause 10
 End Sub '    }

   '  turns off the sensor */
Sub L1X_Off(dev as integer)
if dev then
pin(gp5) = false
else
pin(gp3) = false
endif
pause 10
 End Sub

'  Initialize the sensor with default values
Function InitSensor(dev as integer)
   local stus , sensorState
      L1X_Off(dev) 
      L1X_On(dev) 
     ' stus = VL53L1X_SetI2CAddress(address) 

'#ifdef DEBUG_MODE
      'uint8_t byteData 
      'uint16_t wordData 
      'status = VL53L1X_RdByte(Device, &h010F, andbyteData) 
      'Serial.println("VL53L1X Model_ID: " + String(byteData)) 
      'status = VL53L1X_RdByte(Device, &h0110, andbyteData) 
      'Serial.println("VL53L1X Module_Type: " + String(byteData)) 
      'status = VL53L1X_RdWord(Device, &h010F, andwordData) 
      'Serial.println("VL53L1X: " + String(wordData)) 
'#endif


      do while sensorState = 0 
         sensorState = L1X_BootState(dev) 
         pause 2
      loop

         stus = L1X_SensorInit() 
      InitSensor = stus 
End Function '    }



   ' *
'     *
'     * @brief One time device initialization
'     * @param void
'     * @return     0 on success,  @a #CALIBRATION_WARNING if failed
' '     */
   'virtual int Init()
   '{
      'return L1X_SensorInit(dev) 
   '}
'
'
'
   ''  Read function of the ID device */
   'virtual int ReadID()
   '{
      'uint16_t sensorId 
      'L1X_GetSensorId(dev) 
      'if (sensorId == &hEEAC)
         'return 0 
      'return -1 
   '}



   ' *
'     * @brief Get ranging result and only that
'     * @param pRange_mm  Pointer to range distance
'     * @return           0 on success
' '     */
   'int GetDistance(uint32_t *piData)
   '{
      'int status 
      'uint16_t distance 
      'status = L1X_GetDistance(anddistance) 
      '*piData = (uint32_t) distance 
      'return status 
   '}



Function L1X_SensorInit(dev as integer)as integer
   local stus = 0 ,Addr, tmp 
  read tmp
   for Addr = &h2D  to &h87 
         stus = L1X_WrByte(dev, Addr, tmp) 
   next Addr
   stus = L1X_StartRanging() 
   do
      tmp = L1X_CheckForDataReady(dev) 
   loop until tmp <> 0
 
   stus = L1X_ClearInterrupt(dev) 
   stus = L1X_StopRanging(dev) 
   stus = L1X_WrByte(dev,&h08 , &h09)  '  two bounds VHV */
   stus = L1X_WrByte(dev, &h0B, 0)  '  start VHV from the previous temperature */
   L1X_SensorInit = stus 
End Function 

Function L1X_ClearInterrupt(dev as integer)as integer
local stus 

   status = L1X_WrByte(dev,&h86 , &h01) 
   L1X_ClearInterrupt = stus
End Function

Function L1X_SetInterruptPolarity(dev as integer,NewPolarity as integer)
local tmp , stus
   L1X_ERROR status = 0 

   tmp L1X_RdByte(dev, &h30) 
   tmp = tmp and &hEF 
   stus = L1X_WrByte(dev, &h30, tmp or ((not(NewPolarity and 1)) << 4)) 
   L1X_SetInterruptPolarity = stus 
End Function 

Function L1X_GetInterruptPolarity(dev as integer *pInterruptPolarity)
  local tmp, stus
tmp = L1X_RdByte(Device, &h30) 
   tmp = tmp and &h10 
   L1X_GetInterruptPolarity = not(tmp>>4) 
End Function 

Function L1X_StartRanging(dev as integer)
local stus
   stus = L1X_WrByte(dev,&h0087 , &h40) 
   L1X_StartRanging = stus
End Function 

Function L1X_StopRanging(dev as integer)
local stus
   stus =  L1X_WrByte(dev,&h0087 , &h00) 
   L1X_StopRanging = stus
End Function 

Function L1X_CheckForDataReady(dev as integer) as integer
local tmp,IntPol , dataReady

   IntPol = L1X_GetInterruptPolarity(dev) 
   tmp = L1X_RdByte(dev,&h0031) 
   '  Read in the register to check if a new value is available */
   if status = 0 then
   
      if (tmp and 1) = IntPol then
         dataReady = 1 
      else
         dataReady = 0 
   endif
endif
   L1X_CheckForDataReady = dataReady 
End Function 


sub L1X_SetTimingBudgetInMs(dev as integer, TimingBudgetInMs as integer)
local integer DM , stus

   DM = L1X_GetDistanceMode(dev as integer) 
   if DM = 0 then
     stus = 1 
   elseif DM = 1 then  	'  Short DistanceMode */
      select case TimingBudgetInMs
      case 15 '  only available in short distance mode */
         L1X_WrWord(dev, &h005E,&h001D) 
         L1X_WrWord(dev, &h0061,&h0027) 
         case 20
         L1X_WrWord(dev, &h005E,&h0051) 
         L1X_WrWord(dev, &h0061,&h006E) 
         case 33
         L1X_WrWord(dev, &h005E,&h00D6) 
         L1X_WrWord(dev, &h0061,&h006E) 
      case 50
         L1X_WrWord(dev, &h005E,&h01AE) 
         L1X_WrWord(dev, &h0061,&h01E8) 
      case 100
         L1X_WrWord(dev, &h005E,&h02E1) 
         L1X_WrWord(dev, &h0061,&h0388) 
      case 200
         L1X_WrWord(dev, &h005E,&h03E1) 
         L1X_WrWord(dev, &h0061,&h0496) 
      case 500
         L1X_WrWord(dev, &h005E,&h0591) 
         L1X_WrWord(dev, &h0061,&h05C1) 
      case else
         stus = 1 
      end select
   else
      select case TimingBudgetInMs
      case 20
         L1X_WrWord(dev, &h005E,&h001E) 
         L1X_WrWord(dev, &h0061,&h0022) 
      case 33
         L1X_WrWord(dev, &h005E,&h0060) 
         L1X_WrWord(dev, &h0061,&h006E) 
      case 50
         L1X_WrWord(dev, &h005E,&h00AD) 
         L1X_WrWord(dev, &h0061,&h00C6) 
      case 100
         L1X_WrWord(dev, &h005E,&h01CC) 
         L1X_WrWord(dev, &h0061,&h01EA) 
      case 200
         L1X_WrWord(dev, &h005E,&h02D9) 
         L1X_WrWord(dev, &h0061,&h02F8) 
      case 500
         L1X_WrWord(dev, &h005E,&h048F) 
         L1X_WrWord(dev, &h0061,&h04A4) 
      case else
         stus = 1 
      end select
   endif

End sub

Function L1X_GetTimingBudgetInMs(dev as integer)
local integer tmp , TimingBudget

   tmp = L1X_RdWord(dev, &h005E) 
   select case tmp
   case &h001D 
      TimingBudget = 15 
   case &h0051 ,&h001E 
      TimingBudget = 20 
   case &h00D6 , &h0060 
      TimingBudget = 33  
   case &h1AE , &h00AD 
      TimingBudget = 50 
   case &h02E1 , &h01CC 
      TimingBudget = 100 
   case &h03E1 , &h02D9 
      TimingBudget = 200 
   case &h0591 , &h048F 
      TimingBudget = 500 
   case else
      TimingBudget = 0 
   end select
   L1X_GetTimingBudgetInMs = TimingBudget 
End Function 

sub L1X_SetDistanceMode(dev as integer, DM as integer)
local integer TB 

   TB = L1X_GetTimingBudgetInMs(dev) 
   select case DM
   case 1
      L1X_WrByte(dev, &h004B, &h14) 
      L1X_WrByte(dev, &h0060, &h07) 
      L1X_WrByte(dev, &h0063, &h05) 
      L1X_WrByte(dev, &h0069, &h38) 
      L1X_WrWord(dev, &h0078, &h0705) 
      L1X_WrWord(dev, &h007A, &h0606) 
   case 2
      L1X_WrByte(Device, &h004B, &h0A) 
      L1X_WrByte(Device, &h0060, &h0F) 
      L1X_WrByte(Device, &h0063, &h0D) 
      L1X_WrByte(Device, &h0069, &hB8) 
      L1X_WrWord(Device, &h0078, &h0F0D) 
      L1X_WrWord(Device, &h007A, &h0E0E) 
   case else

end select
   L1X_SetTimingBudgetInMs(TB) 
End sub

Function L1X_GetDistanceMode(dev as integer)
local integer TempDM
   TempDM =  L1X_RdByte(dev,&h004B) 
   if TempDM = &h14 then DM=1 
   if TempDM = &h0A then DM=2 
   L1X_GetDistanceMode = DM
End Function

sub L1X_SetInterMeasurementInMs(dev as integer,InterMeasMs as integer)
local integer ClockPLL 
   ClockPLL = L1X_RdWord(dev, &h00DE) 
   ClockPLL = ClockPLL and &h3FF 
   L1X_WrDWord(dev, &h006C,(ClockPLL * InterMeasMs * 1.075)) 
End sub


Function L1X_GetInterMeasurementInMs(dev as integer)
local integer ClockPLL ,IM
   IM = L1X_RdDWord(dev,&h006C) 
      ClockPLL = L1X_RdWord(dev, &h00DE) 
   ClockPLL = ClockPLL and &h3FF 
   IM=IM/(ClockPLL*1.065) 
   L1X_GetInterMeasurementInMs = IM
End Function

Function L1X_BootState(dev as integer)
local integer tmp 
   tmp = L1X_RdByte(dev,&h00E5) 
   L1X_BootState = tmp
End Function

Function L1X_GetSensorId(dev as integer)
   L1X_GetSensorId = L1X_RdWord(dev, &h010F) 
End Function ' }

Function L1X_GetDistance(dev as integer)
   L1X_GetDistance = L1X_RdWord(dev, &h0096) 
End Function

Function L1X_GetSignalPerSpad(dev as integer)
local integer SpNb=1, signal 
   signal = L1X_RdWord(dev,&h0098) 
   SpNb = L1X_RdWord(dev,&h008C) 
   L1X_GetSignalPerSpad = 2000.0*signal/SpNb 
End Function

Function L1X_GetAmbientPerSpad(dev as integer)
local integer AmbientRate, SpNb=1 
   AmbientRate = L1X_RdWord(dev, &h0090) 
   SpNb = L1X_RdWord(dev, &h008C) 
   L1X_GetAmbientPerSpad =2000.0 * AmbientRate / SpNb 
End Function

Function L1X_GetSignalRate(dev as integer)
local integer tmp 
   tmp = L1X_RdWord(dev,&h0098) 
   L1X_GetSignalRate = tmp*8 
End Function 

Function L1X_GetSpadNb(dev as integer)
local integer tmp 
   tmp = L1X_RdWord(dev,&h008C) 
   L1X_GetSpadNb = tmp >> 8 
End Function 

Function L1X_GetAmbientRate(dev as integer)
local integer tmp 
   tmp = L1X_RdWord(dev, &h0090) 
   tmp = tmp*8 
   L1X_GetAmbientRate = tmp
End Function 

Function L1X_GetRangeStatus(dev as integer)
local integer RgSt 
   RgSt = L1X_RdByte(dev, &h0089) 
   RgSt = RgSt and &h1F 
   select case RgSt
   case 9
      RgSt = 0  
   case 6
      RgSt = 1 
   case 4
      RgSt = 2 
   case 8
      RgSt = 3 
   case 5
      RgSt = 4  
   case 3
      RgSt = 5  
   case 19
      RgSt = 6  
   case 7
      RgSt = 7  
   case 12
      RgSt = 9 
   case 18
      RgSt = 10 
   case 22
      RgSt = 11  
   case 23
      RgSt = 12 
   case 13
      RgSt = 13  
   case else
      RgSt = 255  
  end select
  L1X_GetRangeStatus = RgSt
End Function 

sub L1X_SetOffset(dev as integer,OffsetValue as integer)
local tmp
   tmp = OffsetValue*4 
   L1X_WrWord(dev, &h001E,tmp) 
   L1X_WrWord(dev, &h0020, &h0) 
   L1X_WrWord(dev, &h0022, &h0) 
End sub

Function L1X_GetOffset(dev as integer)
local integer tmp 
   tmp = L1X_RdWord(dev,&h001E) 
   tmp = tmp << 3 
   L1X_GetOffset = tmp / 32 
End Function 

sub L1X_SetXtalk(dev as integer, XtalkValue as integer)
   '  XTalkValue in count per second to avoid float type */
   L1X_WrWord(Device,&h0018,&h0000) 
   L1X_WrWord(Device, &h001A,&h0000) 
   L1X_WrWord(Device, &h0016,(XtalkValue<<9)/1000)  
'  * << 9 (7.9 format) and /1000 to convert cps to kpcs */
End sub

Function L1X_GetXtalk(dev as integer)
local integer tmp
   tmp = L1X_RdWord(dev,&h0016) 
   L1X_GetXtalk = (tmp*1000)>>9  
'  * 1000 to convert kcps to cps and >> 9 (7.9 format) */
End Function

sub L1X_SetDistanceThreshold(dev as integer,ThreshLow,ThreshHigh,Wndow,IntOnNoTarget)
local integer tmp
   tmp = L1X_RdByte(dev, &h0046) 
   tmp = tmp and &h47 
   if IntOnNoTarget = 0 then
   L1X_WrByte(dev, &h0046,tmp or (Wndow and &h07)) 
   else
      L1X_WrByte(dev, &h0046,(tmp or (Wndow and &h07)) or &h40) 
   endif
 L1X_WrWord(dev, &h0072, ThreshHigh) 
  L1X_WrWord(dev, &h0074, ThreshLow) 
end sub

Function L1X_GetDistThresholdWin(dev as integer)
local integer tmp 
   tmp = L1X_RdByte(dev,&h0046) 
   L1X_GetDistThresholdWin = tmp and &h7 
End Function 


Function L1X_GetDistThresholdL(dev as integer)
   L1X_GetDistThresholdL = L1X_RdWord(dev,&h0074) 
End Function 

Function L1X_GetDistThresholdH(dev as integer)
   L1X_GetDistThresholdH = L1X_RdWord(dev,&h0072) 
End Function

sub L1X_SetROI(dev as integer, X as integer,Y as integer)
local integer OpticalCenter 
   OpticalCenter = L1X_RdByte(dev, &h013E) 
   if X > 16 then X = 16 
   if Y > 16 then Y = 16 
   if (X > 10) or (Y > 10) then OpticalCenter = 199 
   L1X_WrByte(dev, &h007F, OpticalCenter) 
   L1X_WrByte(dev, &h0080,((Y - 1) << 4) or (X - 1)) 
End sub

Function L1X_GetROI_XY(dev as integer,X as integer)
local integer tmp, ROI_X, ROI_Y
  tmp = L1X_RdByte(dev,&h0080) 
   ROI_X = (tmp and &h0F) + 1 
   ROI_Y = ((tmp and &hF0) >> 4) + 1 
if X then
L1X_GetROI_XY = ROI_X
else
L1X_GetROI_XY = ROI_Y
endif
End Function

sub L1X_SetROICenter(dev as integer,ROICenter as integer)
   L1X_WrByte(dev,&h007F,ROICenter) 
End sub

Function L1X_GetROICenter(dev as integer)
local integer tmp 
   tmp = L1X_RdByte(dev,&h007F) 
   L1X_GetROICenter = tmp 
End Function 

sub L1X_SetSignalThreshold(dev as integer,signal as integer)
   L1X_WrWord(dev,&h0066,signal >> 3) 
End sub

Function L1X_GetSignalThreshold(dev as integer)
local integer tmp 
tmp = L1X_RdWord(dev,&h0066) 
   L1X_GetSignalThreshold = tmp << 3 
End Function

Sub L1X_SetSigmaThreshold(dev as integer,Sigma as integer)
   if Sigma > (&hFFFF>>2) then
   ;
else 
   '  16 bits register 14.2 format */
   L1X_WrWord(dev,&h0064, Sigma << 2) 
endif
 End Sub 

Function L1X_GetSigmaThreshold(dev as integer)
local integer tmp 
   tmp = L1X_RdWord(dev,&h0064) 
   L1X_GetSigmaThreshold = tmp >> 2 
End Function 

Sub L1X_StartTemperatureUpdate(dev as integer)
local integer tmp=0 
    L1X_WrByte(dev,&h0008,&h81)  '  full VHV */
   L1X_WrByte(dev,&h0B,&h92) 
   L1X_StartRanging(dev) 
   do while tmp = 0
      tmp = L1X_CheckForDataReady(dev) 
   loop
   tmp  = 0 
   L1X_ClearInterrupt(dev) 
   L1X_StopRanging(dev) 
   L1X_WrByte(dev, &h0008, &h09)  '  two bounds VHV */
   L1X_WrByte(dev, &h0B, 0)  '  start VHV from the previous temperature */
 End Sub 

'  VL53L1X_calibration.h functions */
function L1X_CalibrateOffset(dev as integer,TargetDistInMm, int16_t *offset)
local integer tmp, AverageDistance, dist,i, offset
L1X_WrWord(dev, &h001E, &h0) 
   L1X_WrWord(dev, &h0020, &h0) 
   L1X_WrWord(dev, &h0022, &h0) 
   L1X_StartRanging(dev) 	'  Enable VL53L1X sensor */
   for i = 0  to 49
   
      do while tmp = 0
      
         tmp = L1X_CheckForDataReady(dev) 
      loop
      tmp = 0 
      dist = L1X_GetDistance(dev) 
      L1X_ClearInterrupt(dev) 
      AverageDistance = AverageDistance + dist
   next i
   L1X_StopRanging(dev) 
   AverageDistance = AverageDistance / 50 
   offset = TargetDistInMm - AverageDistance 
   L1X_WrWord(dev, &h001E, offset * 4) 
   L1X_CalibrateOffset = offset
 End function

Function L1X_CalibrateXtalk(dev as integer,TargetDistInMm)
local float AverageSignalRate, AverageDistance,AverageSpadNb 
local integer dist, spadNum, sr, xtalk , i
L1X_WrWord(dev, &h0016,0) 
   L1X_StartRanging(dev) 
   for i = 0  to 49
   do while tmp = 0
         tmp = L1X_CheckForDataReady(dev) 
     loop
      tmp=0 
      sr= L1X_GetSignalRate(dev) 
      dist = L1X_GetDistance(dev) 
      L1X_ClearInterrupt(dev) 
      AverageDistance = AverageDistance + dist 
      spadNum = L1X_GetSpadNb(dev) 
      AverageSpadNb = AverageSpadNb + spadNum 
      AverageSignalRate = AverageSignalRate + sr 
   next i
   L1X_StopRanging(dev) 
   AverageDistance = AverageDistance / 50 
   AverageSpadNb = AverageSpadNb / 50 
   AverageSignalRate = AverageSignalRate / 50 
   '  Calculate Xtalk value */
   xtalk = (512*(AverageSignalRate*(1-(AverageDistance/TargetDistInMm)))/AverageSpadNb) 
    L1X_WrWord(dev, &h0016, xtalk) 
   L1X_CalibrateXtalk = xtalk 
End Function

'  Write and read functions from I2C */
  ' Write an 8-bit register
sub L1X_WrByte(dev as integer, reg as integer, value as integer)
  if I2C_ch = 2 then
    I2c2 Write i2caddr+dev,0,3,reg >> 8,reg,value
  else
    I2c Write i2caddr+dev,0,3,reg >> 8,reg,value
  endif
end sub
    
  ' Write a 16-bit register
sub L1X_WrWord(dev as integer, reg as integer, value as integer)
  if I2C_ch = 2 then
    I2c2 Write i2caddr+dev,0,4,reg >> 8,reg,value >> 8, value
  else
    I2c Write i2caddr+dev,0,4,reg >> 8,reg,value >> 8, value
  endif
end sub
  
  ' Write a 32-bit register
sub L1X_WrDWord(dev as integer, reg as integer, value as integer)
  if I2C_ch = 2 then
    I2c2 Write i2caddr+dev,0,6,reg >> 8,reg,value >> 24, value >> 16,value >> 8, value
  else
    I2c Write i2caddr+dev,0,6,reg >> 8,reg,value >> 24, value >> 16,value >> 8, value
  endif
end sub
  
  ' Read an 8-bit register
function L1X_RdByte(dev as integer, reg as integer) as integer
  local integer value
  if I2C_ch = 2 then
    I2c2 Write i2caddr+dev,0,2,reg >> 8,reg
    I2c2 Read i2caddr+dev,0,1,value
  else
    I2c Write i2caddr+dev,1,2,reg >> 8,reg
    I2c Read i2caddr+dev,0,1,value
  endif
  L1X_RdByte = value
end function
  
  ' Read a 16-bit register
function L1X_RdWord(dev as integer,reg as integer) as integer
  if I2C_ch = 2 then
    I2c2 Write i2caddr+dev,0,2,reg >> 8,reg and &hFF
    I2c2 Read i2caddr+dev,0,2,scratch()
  else
    I2c Write i2caddr+dev,1,2,reg >> 8,reg and &hFF
    I2c Read i2caddr+dev,0,2,scratch()
  endif
  L1X_RdWord = (scratch(0)<<8) + scratch(1)
end function
  
  ' Read a 32-bit register
function L1X_RdDWord(reg as integer) as integer
  'local integer valueA, valueB, valueC,valueD
  if I2C_ch = 2 then
    I2c2 Write i2caddr+dev,0,2,reg >> 8,reg
    I2c2 Read i2caddr+dev,0,4,scratch()
  else
    I2c Write i2caddr+dev,1,2,reg >> 8,reg
    I2c Read i2caddr+dev,0,4,scratch()
  endif
  L1X_RdDWord = (scratch(0)<<24) + (scratch(1)<<16) + (scratch(2)<<8) + scratch(3)
end function

Function L1X_WriteMulti(dev as integer,  index,  *pdata,  cnt)
{
   int  status 

   status = L1X_I2CWrite(dev->I2cDevAddr, index, pdata, (uint16_t)cnt) 
   return status 
End Function ' }

'VL53L1X_ERROR VL53L1X::VL53L1X_ReadMulti(VL53L1X_DEV Dev, uint16_t index, uint8_t *pdata, uint32_t count)
'{
   'int status 
'
   'status = VL53L1X_I2CRead(Dev->I2cDevAddr, index, pdata, (uint16_t)count) 
'
   'return status 
'}
'

Sub L1X_UpdateByte(dev, reg, AndData,OrData)
local integer tmp
   tmp = L1X_RdByte(dev, reg,tmp) 
      tmp = (tmp and AndData) or OrData 
      L1X_WrByte(dev,reg, tmp) 
 End Sub 

'VL53L1X_ERROR VL53L1X::VL53L1X_GetTickCount(
   'uint32_t *ptick_count_ms)
'{
'
   ''  Returns current tick count in [ms] */
'
   'VL53L1X_ERROR status  = VL53L1X_ERROR_NONE 
'
   '/' ptick_count_ms = timeGetTime() 
''    *ptick_count_ms = 0 
'' 
''    return status 
'' }
'' 
'' 
'' 
'' VL53L1X_ERROR VL53L1X::VL53L1X_WaitUs(VL53L1X_Dev_t *pdev, int32_t wait_us)
'' {
''    (void)pdev 
''    delay(wait_us/1000) 
''    return VL53L1X_ERROR_NONE 
'' }
'' 
'' 
'' VL53L1X_ERROR VL53L1X::VL53L1X_WaitMs(VL53L1X_Dev_t *pdev, int32_t wait_ms)
'' {
''    (void)pdev 
''    delay(wait_ms) 
''    return VL53L1X_ERROR_NONE 
'' }
'' 
'' 
'' VL53L1X_ERROR VL53L1X::VL53L1X_WaitValueMaskEx(
''    VL53L1X_Dev_t *pdev,
''    uint32_t      timeout_ms,
''    uint16_t      index,
''    uint8_t       value,
''    uint8_t       mask,
''    uint32_t      poll_delay_ms)
'' {
'' 
''    /*
''     * Platform implementation of WaitValueMaskEx V2WReg script command
''     *
''     * WaitValueMaskEx(
''     *          duration_ms,
''     *          index,
''     *          value,
''     *          mask,
''     *          poll_delay_ms) 
'' '     */
'
   'VL53L1X_Error status         = VL53L1X_ERROR_NONE 
   'uint32_t     start_time_ms = 0 
   'uint32_t     current_time_ms = 0 
   'uint32_t     polling_time_ms = 0 
   'uint8_t      byte_value      = 0 
   'uint8_t      found           = 0 
'
'
'
   ''  calculate time limit in absolute time */
'
   'VL53L1X_GetTickCount(&start_time_ms) 
'
   ''  remember current trace functions and temporarily disable
''     * function logging
'' '     */
'
'
   ''  wait until value is found, timeout reached on error occurred */
'
   'while ((status == VL53L1X_ERROR_NONE) and
          '(polling_time_ms < timeout_ms) and
          '(found == 0))
   '{
'
      'if (status == VL53L1X_ERROR_NONE)
         'status = VL53L1X_RdByte(
                     'pdev,
                     'index,
                     '&byte_value) 
'
      'if ((byte_value and mask) == value)
         'found = 1 
'
      'if (status == VL53L1X_ERROR_NONE  and
            'found == 0 and
            'poll_delay_ms > 0)
         'status = VL53L1X_WaitMs(
                     'pdev,
                     'poll_delay_ms) 
'
      ''  Update polling time (Compare difference rather than absolute to
'' '       negate 32bit wrap around issue) */
      'VL53L1X_GetTickCount(&current_time_ms) 
      'polling_time_ms = current_time_ms - start_time_ms 
'
   '}
'
'
   'if (found == 0 and status == VL53L1X_ERROR_NONE)
      'status = VL53L1X_ERROR_TIME_OUT 
'
   'return status 
'}

initdata:
  data &h00  '  &h2d : set bit 2 and 5 to 1 for fast plus mode (1MHz I2C), else don't touch */
  data &h00  '  &h2e : bit 0 if I2C pulled up at 1.8V, else set bit 0 to 1 (pull up at AVDD) */
  data &h00  '  &h2f : bit 0 if GPIO pulled up at 1.8V, else set bit 0 to 1 (pull up at AVDD) */
  data &h01  '  &h30 : set bit 4 to 0 for active high interrupt and 1 for active low 
'(bits 3:0 must be &h1), use SetInterruptPolarity() */
  data &h02  '  &h31 : bit 1 = interrupt depending on the polarity, use CheckForDataReady() */
  data &h00  '  &h32 : not user-modifiable */
  data &h02  '  &h33 : not user-modifiable */
  data &h08  '  &h34 : not user-modifiable */
  data &h00  '  &h35 : not user-modifiable */
  data &h08  '  &h36 : not user-modifiable */
  data &h10  '  &h37 : not user-modifiable */
  data &h01  '  &h38 : not user-modifiable */
  data &h01  '  &h39 : not user-modifiable */
  data &h00  '  &h3a : not user-modifiable */
  data &h00  '  &h3b : not user-modifiable */
  data &h00  '  &h3c : not user-modifiable */
  data &h00  '  &h3d : not user-modifiable */
  data &hff  '  &h3e : not user-modifiable */
  data &h00  '  &h3f : not user-modifiable */
  data &h0F  '  &h40 : not user-modifiable */
  data &h00  '  &h41 : not user-modifiable */
  data &h00  '  &h42 : not user-modifiable */
  data &h00  '  &h43 : not user-modifiable */
  data &h00  '  &h44 : not user-modifiable */
  data &h00  '  &h45 : not user-modifiable */
  data &h20  '  &h46 : interrupt configuration 0->level low detection, 1-> level high, 
'2-> Out of window, 3->In window, &h20-> New sample ready , TBC */
  data &h0b  '  &h47 : not user-modifiable */
  data &h00  '  &h48 : not user-modifiable */
  data &h00  '  &h49 : not user-modifiable */
  data &h02  '  &h4a : not user-modifiable */
  data &h0a  '  &h4b : not user-modifiable */
  data &h21  '  &h4c : not user-modifiable */
  data &h00  '  &h4d : not user-modifiable */
  data &h00  '  &h4e : not user-modifiable */
  data &h05  '  &h4f : not user-modifiable */
  data &h00  '  &h50 : not user-modifiable */
  data &h00  '  &h51 : not user-modifiable */
  data &h00  '  &h52 : not user-modifiable */
  data &h00  '  &h53 : not user-modifiable */
  data &hc8  '  &h54 : not user-modifiable */
  data &h00  '  &h55 : not user-modifiable */
  data &h00  '  &h56 : not user-modifiable */
  data &h38  '  &h57 : not user-modifiable */
  data &hff  '  &h58 : not user-modifiable */
  data &h01  '  &h59 : not user-modifiable */
  data &h00  '  &h5a : not user-modifiable */
  data &h08  '  &h5b : not user-modifiable */
  data &h00  '  &h5c : not user-modifiable */
  data &h00  '  &h5d : not user-modifiable */
  data &h01  '  &h5e : not user-modifiable */
  data &hcc  '  &h5f : not user-modifiable */
  data &h0f  '  &h60 : not user-modifiable */
  data &h01  '  &h61 : not user-modifiable */
  data &hf1  '  &h62 : not user-modifiable */
  data &h0d  '  &h63 : not user-modifiable */
  data &h01  '  &h64 : Sigma threshold MSB (mm in 14.2 format for MSB+LSB), use 
'SetSigmaThreshold(), default value 90 mm  */
  data &h68  '  &h65 : Sigma threshold LSB */
  data &h00  '  &h66 : Min count Rate MSB (MCPS in 9.7 format for MSB+LSB), use 
'SetSignalThreshold() */
  data &h80  '  &h67 : Min count Rate LSB */
  data &h08  '  &h68 : not user-modifiable */
  data &hb8  '  &h69 : not user-modifiable */
  data &h00  '  &h6a : not user-modifiable */
  data &h00  '  &h6b : not user-modifiable */
  data &h00  '  &h6c : Intermeasurement period MSB, 32 bits register, use 
'SetIntermeasurementInMs() */
  data &h00  '  &h6d : Intermeasurement period */
  data &h0f  '  &h6e : Intermeasurement period */
  data &h89  '  &h6f : Intermeasurement period LSB */
  data &h00  '  &h70 : not user-modifiable */
  data &h00  '  &h71 : not user-modifiable */
  data &h00  '  &h72 : distance threshold high MSB (in mm, MSB+LSB), use 
'SetD:tanceThreshold() */
  data &h00  '  &h73 : distance threshold high LSB */
  data &h00  '  &h74 : distance threshold low MSB ( in mm, MSB+LSB), use 
'SetD:tanceThreshold() */
  data &h00  '  &h75 : distance threshold low LSB */
  data &h00  '  &h76 : not user-modifiable */
  data &h01  '  &h77 : not user-modifiable */
  data &h0f  '  &h78 : not user-modifiable */
  data &h0d  '  &h79 : not user-modifiable */
  data &h0e  '  &h7a : not user-modifiable */
  data &h0e  '  &h7b : not user-modifiable */
  data &h00  '  &h7c : not user-modifiable */
  data &h00  '  &h7d : not user-modifiable */
  data &h02  '  &h7e : not user-modifiable */
  data &hc7  '  &h7f : ROI center, use SetROI() */
  data &hff  '  &h80 : XY ROI (X=Width, Y=Height), use SetROI() */
  data &h9B  '  &h81 : not user-modifiable */
  data &h00  '  &h82 : not user-modifiable */
  data &h00  '  &h83 : not user-modifiable */
  data &h00  '  &h84 : not user-modifiable */
  data &h01  '  &h85 : not user-modifiable */
  data &h00  '  &h86 : clear interrupt, use ClearInterrupt() */
  data &h00  '  &h87 : start ranging, use StartRanging() or StopRanging(), 
'If you want an automatic start after VL53L1X_init() call, put &h40 in location &h87 */
