  ' QB PLAY string command
  '
  option explicit
  
  dim nnn$, nNote$
  dim as integer nOctave, nn, nNum
  dim as float nTone
  dim playdone
  dim source$(11) ' array for the source tune
  dim dl$(150) ' array to store the converted data lines
  dim newName$
  dim thisNote$, thisLine$, n
  restore jinglebells
  dim d=4, o=5, b=120, pl = 7/8 ' normal note length
  'input "Default length, octave, beats (4,5,120): ";d,o,b
  print
  
  do
    n = n+ 1
    read source$(n)
    if source$(n) = "" then exit do
  loop
  playNokia
  
  printOutput
end
  
sub playNokia
  ' play a nokia string
  LOCAL ch$, item$, shift$= " "
  LOCAL as integer nNum, tempo, quarter, note, value, n, k, m, p, lastone
  LOCAL as float pauseTime, dur, ext, freq, nTone
  LOCAL octave
  k = instr(source$(1),":") ' look for file header
  if k>0 then ' get name and settings
    newName$ = left$(source$(1),k-1)
    k = instr(source$(1),"d=") ' default note duration
    if k then
      n = instr(k,source$(1),",")-k-2
      d = val(mid$(source$(1), k+2,n))
    endif
    k = instr(source$(1),"o=") ' default octave
    if k then
      n = instr(k,source$(1),",")-k-2
      o = val(mid$(source$(1), k+2,n))
    endif
    k = instr(source$(1),"b=") ' default tempo
    if k then
      n = instr(k,source$(1),":")-k-2
      b = val(mid$(source$(1), k+2,n))
    endif
    source$(1) = mid$(source$(1),k+n+3) ' strip off header
    '    print newName$, d, o, b 'DEBUG
    '    print source$(1) 'DEBUG
  endif
  dl$(0) = newName$+":" ' label for DATA
  tempo = b
  octave = o
  quarter = 60000 / tempo  ' length of quarter note in mS
  dur = quarter * 4 / d
  'pl = 7/8 ' normal note length
  m = 0 ' output data counter
  for k = 1 to 11
    if LEN(source$(k)) = 0 then
      source$(k) = "," 'add final comma
      lastone = 1 'and set flag
    endif
    FOR n = 1 TO LEN(source$(k))
      ch$ = ucase$(MID$(source$(k),n,1))
      SELECT CASE ch$
        CASE "0","1","2","3","4","5","6","7","8","9"
          value = value * 10 + VAL(ch$)
        CASE "A","B","C","D","E","F","G","P"
          item$ = ch$
          if value = 0 then
            dur = quarter * 4 / d
          else
            dur = quarter * 4 / value
          endif
          value = 0
          
        CASE "#","+"
          shift$ = "#"
        CASE "-"
          shift$ = "-"
        CASE "."
          IF ext = 0 THEN
            ext = dur/2
          ELSE
            ext = dur*3/4
          ENDIF
        case " "
          ' skip
        case ","
          if value = 0 then
            octave = o
          else
            octave = value
          endif
          playdone=0
          p = int(m/4)+1 ' pointer to current output array line number
          if m mod 4 = 0 then ' start new line of output
            if m > 1 then dl$(p-1) = left$(dl$(p-1),len(dl$(p-1))-1) ' strip trailing ,
            print dl$(p-1)
            dl$(p) = "  DATA "
          endif
          if item$ = "P" then ' rest
            PLAY TONE 0, 0, (dur + ext), playint
            dl$(p)=dl$(p)+str$(0,4,1)+","+str$((dur + ext),5,1)+","
            m = m+1
          else
            nNum = Note2nNum(item$+shift$, octave-1)
            nTone = nNum2Tone(nNum)
            PLAY TONE nTone, nTone, (dur + ext) * pl, playint
            dl$(p)=dl$(p)+str$(nTone,4,1)+","+str$((dur + ext)* pl,5,1)+","
            m = m+1
            if pl < 1 then
              if m mod 4 = 0 then ' start new line of output
                if m > 1 then dl$(p-1) = left$(dl$(p-1),len(dl$(p-1))-1) ' strip trailing ,
               ' print dl$(p-1)
                dl$(p) = "  DATA "
              endif
              do while playdone=0 ' wait for current tone to finish
              loop
              PLAY TONE 0, 0, (dur + ext) * (1 - pl), playint
              dl$(p)=dl$(p)+str$(0,4,1)+","+str$((dur + ext)* (1 - pl),5,1)+","
              m = m+1
            endif
          endif
          do while playdone=0 ' wait for current tone to finish
              loop
          value = 0
          shift$ = " "
          ext = 0
          
      END SELECT
    NEXT n
    if lastone = 1 then exit for ' all done!
  next k
  dl$(p) = left$(dl$(p),len(dl$(p))-1)+", 0,0"
  dl$(p+1) = "' End of "+newName$
  dl$(p+2) = ""
 ' print dl$(p)
  'print dl$(p+1)
  
END SUB
  
  sub printOutput
  local p
  do
  print dl$(p)
  p = p + 1
  loop until dl$(p) = ""
  end sub
  
  PLAYQB "T180 o2 P2 P8 L8 GGG L2 E-"+"P24 P8 L8 FFF L2 D"
  melodyEnd
  PAUSE 500
  PLAYQB "T120MLO2L1Eeeee"
  melodyEnd
  PAUSE 500
  PLAYQB "t120o1l16b9n0baan0bn0bn0baaan0b9n0baan0b"
  melodyEnd
  PAUSE 500
  PLAYQB  "o2l16e-9n0e-d-d-n0e-n0e-n0e-d-d-d-n0e-9n0e-d-d-n0e-"
  melodyEnd
  PAUSE 500
  PLAYQB  "o2l16g-9n0g-een0g-n0g-n0g-eeen0g-9n0g-een0g-"
  melodyEnd
  PAUSE 500
  PLAYQB "o2l16b9n0baan0g-n0g-n0g-eeen0o1b9n0baan0b"
  melodyEnd
  print
  '  print melodyCounter
  '  for nn = 1 to melodyCounter
  '  print "DATA ";melody(nn,1);", "melody(nn,2)
  '  next nn
  
  DO
    INPUT "Enter note or note number: ";nnn$
    ' enter piano note number or note name eg G#4, a-3 b4
    nnn$= UCASE$(nnn$)
    IF INSTR("ABCDEFG",MID$(nnn$,1,1)) > 0 THEN ' is a note
      IF INSTR("#- ",MID$(nnn$,2,1)) = 0 THEN ' no modifier character
        nnn$= LEFT$(nnn$,1)+" "+MID$(nnn$,2) ' so add a null modifier
      ENDIF
      IF INSTR("0123456789",MID$(nnn$,3,1)) > 0 THEN ' looking for octave number
        nOctave = VAL(MID$(nnn$,3,1))
      ELSE
        nOctave = 4 ' set a default octave if none given
      ENDIF
      nnn$ = LEFT$(nnn$,2)
      nn = Note2nNum(nnn$, nOctave)
    ELSE
      nn = VAL(nnn$)
    ENDIF
    nTone = nNum2Tone(nn)
    nOctave = nNum2Octave(nn)
    nNote$ = nNum2Note(nn)
    nNum = Note2nNum(nNote$, nOctave)
    '    print nn,, str$(nTone,4,3),, nNote$, nOctave, nNum 'DEBUG
    PLAY TONE nTone, nTone, 500
  LOOP
  
  
SUB playQB notation$
  ' play a quickbasic string
  LOCAL ch$, item$, shift$= " "
  LOCAL as integer nNum, tempo, quarter, note, value, n
  LOCAL as float playLen, pauseTime, duration, extend, freq, nTone
  LOCAL octave = 2
  notation$ = notation$ + " "
  tempo = 120
  quarter = 500  ' length of quarter note in mS
  duration = quarter
  playLen = 7/8 ' normal note length
  FOR n = 1 TO LEN(notation$)
    ch$ = MID$(notation$,n,1)
    SELECT CASE ch$
      CASE "0","1","2","3","4","5","6","7","8","9"
        value = value * 10 + VAL(ch$)
      CASE ">"
        IF octave < 6 THEN octave = octave + 1
      CASE "<"
        IF octave > 0 THEN octave = octave - 1
      CASE "#","+"
        shift$ = "#"
      CASE "-"
        shift$ = "-"
      CASE "."
        IF extend = 0 THEN
          extend = duration/2
        ELSE
          extend = duration*3/4
        ENDIF
      CASE "X"
        ' ignore
        
      CASE ELSE
        '      print "Value =  ";value 'DEBUG
        SELECT CASE item$
            
          CASE "A","B","C","D","E","F","G"
            nNum = Note2nNum(item$+shift$, octave+2)
            '            print item$+shift$,, octave+2 'DEBUG
            nTone = nNum2Tone(nNum)
            '            print nNum,,nTone,,(duration + extend) * playLen 'DEBUG
            
            PLAY TONE nTone, nTone, (duration + extend) * playLen, playint
            '            melodyCounter = melodyCounter + 1
            '            melody(melodyCounter,1) = nTone
            '            melody(melodyCounter,2) = (duration + extend) * playLen
            print "DATA ";str$(nTone,4,1);", ";str$((duration + extend) * playLen,5,1)
            if playLen < 1 then
              '            melodyCounter = melodyCounter + 1
              '            melody(melodyCounter,1) = 0
              '            melody(melodyCounter,2) = (duration + extend)*(1 - playLen)
              print "DATA ";str$(0,4,1);", ";str$((duration + extend) * (1 - playLen),5,1)
            endif
            playdone=0
            do while playdone=0
            loop
            PAUSE (duration + extend)*(1 - playLen)
            extend = 0
            item$ = UCASE$(ch$)
            value = 0
          CASE "T"
            tempo = value
            quarter = 60000 / tempo
            item$ = UCASE$(ch$)
            value = 0
            '            print "quarter = ";quarter 'DEBUG
          CASE "L"
            duration = quarter * 4 / value
            item$ = UCASE$(ch$)
            value = 0
            '            print "duration = ";duration 'DEBUG
          CASE "O"
            octave = value
            item$ = UCASE$(ch$)
            value = 0
          CASE "P"
            pauseTime = quarter * 4 / value
            '            print "pauseTime = ";pausetime 'DEBUG
            print "DATA ";str$(0,4,1);", ";str$(pausetime,5,1)
            PAUSE pauseTime
            item$ = UCASE$(ch$)
            value = 0
            ' value = 0
          CASE "T"
            tempo = value
            quarter = 60000/tempo
            item$ = UCASE$(ch$)
            value = 0
          CASE "M"
            IF UCASE$(ch$) = "N" THEN playLen = 7/8
            IF UCASE$(ch$) = "L" THEN playLen = 1
            IF UCASE$(ch$) = "S" THEN playLen = 3/4
            'if ucase$(ch$) = "F" then ' foreground
            ' if ucase$(ch$) = "B" then ' background
          CASE "N"
            IF value = 0 THEN
              'PAUSE duration
              print "DATA ";str$(0,4,1);", ";str$((duration + extend),5,1)
            ELSE
              nTone = nNum2Tone(value+24)
              PLAY TONE nTone, nTone, (duration + extend) * playLen, playint
              '              melodyCounter = melodyCounter + 1
              '            melody(melodyCounter,1) = nTone
              '            melody(melodyCounter,2) = (duration + extend) * playLen
              print "DATA ";str$(nTone,4,1);", ";str$((duration + extend) * playLen,5,1)
              if playLen < 1 then
                '            melodyCounter = melodyCounter + 1
                '            melody(melodyCounter,1) = 0
                '            melody(melodyCounter,2) = (duration + extend)*(1 - playLen)
                print "DATA ";str$(0,4,1);", ";str$((duration + extend) * (1 - playLen),5,1)
              endif
              playdone=0
              do while playdone=0
              loop
              PAUSE (duration + extend)*(1 - playLen)
              extend = 0
            ENDIF
            item$ = UCASE$(ch$)
            value = 0
          CASE ELSE
            item$ = UCASE$(ch$)
            value = 0
        END SELECT
        shift$ = " "
    END SELECT
  NEXT n
  
END SUB
  
sub playint 'end of tone interrupt
  playdone=1
end sub
  
sub melodyEnd
  'melodyCounter = melodyCounter + 1
  '  melody(melodyCounter,1) = 0 : melody(melodyCounter,2) = 0
  print "DATA 0, 00"
  print
end sub
  
  
FUNCTION Note2nNum(Note$, octave as integer) AS INTEGER
  ' given music note and octave, return piano key number
  LOCAL allNotes$ = "C C#D D#E F F#G G#A A#B "
  local altNotes$ = "C D-D E-E F G-G A-A B-B "
  LOCAL flat
  IF INSTR(Note$,"-") > 0 THEN
    flat = 1
    Note$ = MID$(Note$,1,1)
  ENDIF
  IF LEN(Note$) < 2 THEN Note$ = Note$+" "
  IF Note$ = "E#" THEN Note$ = "F " ' correct for 2 undefined sharps
  IF Note$ = "B#" THEN Note$ = "C " : octave = octave + 1
  IF Note$ = "F-" THEN Note$ = "E " ' correct for 2 undefined flats
  IF Note$ = "C-" THEN Note$ = "B " : octave = octave - 1
  if instr(Note$,"-")>0 then
    Note2nNum = INSTR(altNotes$,Note$)/2 +octave*12 - 9 - flat
  else
    Note2nNum = INSTR(allNotes$,Note$)/2 +octave*12 - 9 - flat
  endif
  IF Note2nNum < 1 THEN Note2nNum = Note2nNum + 1 ' correct for negative numbers
END FUNCTION
  
FUNCTION nNum2Tone(noteN AS INTEGER) AS FLOAT
  ' given piano key number return note frequency
  nNum2Tone = 440 * 2^((noteN-49)/12)
END FUNCTION
  
FUNCTION nNum2Octave(noteN AS INTEGER) AS INTEGER
  ' given piano key number, return octave number
  ' if noteN <98 and noteN > 88 then noteN = noteN - 97
    IF     noteN > 87 THEN : nNum2Octave = 8
    ELSEIF noteN > 75 THEN : nNum2Octave = 7
    ELSEIF noteN > 63	THEN : nNum2Octave = 6
    ELSEIF noteN > 51	THEN : nNum2Octave = 5
    ELSEIF noteN > 39	THEN : nNum2Octave = 4
    ELSEIF noteN > 27	THEN : nNum2Octave = 3
    ELSEIF noteN > 15	THEN : nNum2Octave = 2
    ELSEIF noteN > 3	THEN : nNum2Octave = 1
    ELSE                   : nNum2Octave = 0
  ENDIF
END FUNCTION
  
FUNCTION nNum2Note(noteN AS INTEGER) AS STRING
  ' given piano key number, return music note
  LOCAL allnotes$ = "G#A A#B C C#D D#E F F#G G#A "
  noteN = noteN + 12
  IF noteN > 0 THEN
    nNum2Note = MID$(allnotes$,(noteN MOD 12) * 2 +1,2)
  ENDIF
  
END FUNCTION

JingleBells:
  'd=4,o=5,b=125
  data "JingleBells:d=4,o=5,b=125:8g,8e6,8d6,8c6,2g,8g,8e6,8d6,8c6,2a,8a,8f6,8e6"
  data "8d6,8b,8g,8b,8d6,8g.6,16g6,8f6,8d6,2e6,8g,8e6,8d6,8c6,2g,16f#,8g,8e6"
  data "8d6,8c6,2a,8a,8f6,8e6,8d6,8g6,16g6,16f#6,16g6,16f#6,16g6,16g#6,8a.6"
  data "16g6,8e6,8d6,c6,g6,8e6,8e6,8e.6,16d#6,8e6,8e6,8e.6,16d#6,8e6,8g6,8c.6"
  data "16d6,2e6,8f6,8f6,8f.6,16f6,8f6,8e6,8e6,16e6,16e6,8e6,8d6,8d6,8e6,2d6"
  data ""
  
testtune:
  data "g,c7,g,e,g,c.7,8c7,c7,e7,d7,c7,b,c7,2d.7,g,c7,g,e,c,g.,8g,g,e7,d7,c7,b"
  data "a,2g,p,g,a.,8b,c7,a,2g,8e,e,g,a,c7,f7,e7,2d7"
  data ""
  
  data "g,g,a,f#.,8g,a,b,b,c6,b.,8a,g,a,g,f#,g.,8a,8b,8c6,d6,d6,d6,d.6,8c6,b,c6"
  data "c6,c6,c.6,8b,a,b,8c6,8b,8a,8g,b.,8c6,d6,8e6,8c6,b,a,g."
  data ""
  
  data "8c#,8d,e,c#,d,b4,c#,a4,b4,p,16c#6,16p,16d6,16p,8e6,8p,8c#6,8p,8d6,8p"
  data "8b,8p,8c#6,8p,8a,8p,b,p,a4,a4,b4,c#,a4,c#,b4,p,8a,8p,8a,8p,8b,8p,8c#6"
  data "8p,8a,8p,8c#6,8p,8b"
  data ""
  
