#define _SUPPRESS_PLIB_WARNING
#include <plib.h>
#include "cfunctions.h"
#define DDMMaxClks 32
long long TxToDDM4 (unsigned long long *, unsigned long long *);
long long TxToDDM4 (unsigned long long *Hours, unsigned long long *Mins)
{
long long PackDigits (unsigned long long *, unsigned long long *);
long long Transmit (unsigned long long *);
unsigned long long Temp;
unsigned long long TensUnits = 0;

  DDPCONbits.JTAGEN = 0;
  ANSELBCLR = 0x0C80;       // RB7, 10 & 11 = Digital I/O
  TRISBCLR = 0x0C80;        // RB7, 10 & 11 = Output
  ODCBCLR  = 0x0C80;        // RB7, 10 & 11 = Not Open Collector
  CNPUBCLR = 0x0C80;        // RB7, 10 & 11 = No Pull UP
  CNPDBCLR = 0x0C80;        // RB7, 10 & 11 = No Pull Down

  Temp = *Hours/10;
  PackDigits(&TensUnits, &Temp);
  Temp = *Hours % 10;
  PackDigits(&TensUnits, &Temp);
  Temp = *Mins/10;
  PackDigits(&TensUnits, &Temp);
  Temp = *Mins % 10;
  PackDigits(&TensUnits, &Temp);
  Transmit(&TensUnits);
  
  return (0);
}

long long PackDigits (unsigned long long *TensUnits, unsigned long long *Temp)
{  
  *TensUnits = *TensUnits << 8;
  // Replaces code using SWITCH
  if (*Temp == 0)
    *Temp = 0b01111110;                // Decode for 0,0x7E
  else if (*Temp == 1) 
    *Temp = 0b00011000;                // Decode for 1,0x18
  else if (*Temp == 2)
    *Temp = 0b10110110;                // Decode for 2,0xB6
  else if (*Temp == 3)
    *Temp = 0b10111100;                // Decode for 3, 0xBC
  else if (*Temp == 4)
    *Temp = 0b11011000;                // Decode for 4, 0xD8
  else if (*Temp == 5)
    *Temp = 0b11101100;                // Decode for 5, 0xEC
  else if (*Temp == 6)
    *Temp = 0b11101110;                // Decode for 6, 0xEE
  else if (*Temp == 7)
    *Temp = 0b00111000;                // Decode for 7, 0x38
  else if (*Temp == 8)
    *Temp = 0b11111110;                // Decode for 8, 0xFE
  else if (*Temp == 9)
    *Temp = 0b11111100;                // Decode for 9, 0xFC

  *TensUnits = *TensUnits | *Temp;
  return (0);
}

long long Transmit (unsigned long long *TensUnits)
{
int Count = DDMMaxClks;
int i;
  do
    {
      if (*TensUnits && 1 == 1)
        PORTBSET = 0x0400;             // DATA = Hi
      else
        PORTBCLR = 0x0400;             // DATA = Lo

      PORTBSET = 0x0800;               // CLOCK Pulse Hi
      for (i = 0; i < 1000; i++)
        __asm__ volatile ("nop");
      PORTBCLR = 0x0800;               // CLOCK Pulse Lo
    } while ((Count = Count - 1) != 0);

  PORTBSET = 0x0080;               // LOAD Pulse Hi
  __asm__ volatile ("nop");
  __asm__ volatile ("nop");
  __asm__ volatile ("nop");
  PORTBCLR = 0x0080;               // LOAD Pulse Lo
  
  return (0);
}
void main()
{
}


