'disconnect ARM from GP0/1/2
  setpin gp0,pio1         'clock
  setpin gp1,pio1         'load
  setpin gp2,pio1         'data in
  
'configure pio1
  p=Pio(pinctrl 2,2,,gp2,gp0,gp0,)          'GP0,GP1 out (set and side set), GP2 IN
  f=1e5                                     '100kHz
  s=PIO(shiftctrl 0,0,0,0,0,0)              'shift in from LSB for IN (and OUT)
  e=PIO(execctrl gp0,1,5)                   'wrap=5, wrap target=1, MMBasic V50706RC1 and later
  'e=PIO(execctrl 0,1,5)                     'wrap=5, wrap target=1. MMBasic V50706RC8 and prior
  
'line   code    mnemonics                   comment
'  0    E083    SET pindirs 00011,side(00)  set GP0+GP1 output, side set GP0,GP1 low
'.wrap target
'  1    5060    IN NULL, 32,side(10)        set ISR to 0 by shifting 32 NULL bits into it, GP1 (load) high
'  2    E027    SET X=7,side(00)            set counter to 7, GP1 (load) low
'  3    4001    IN 1 bit,side(00)           shift in 1 bit from GP2, clock and load low
'  4    0843    JMP X-- 3,side(01)          decrement X and jump to 3 when X<>0, clock = high
'  5    8700    PUSH dly=7,side(00)         push the ISR value into FIFO, clock and load low, delay=7
'.wrap
  
'program pio1
  pio program line 1,0,&hE083
  pio program line 1,1,&h5060
  pio program line 1,2,&hE027
  pio program line 1,3,&h4001
  pio program line 1,4,&h0843
  pio program line 1,5,&h8700
  
  
'write the configuration
  PIO init machine 1,0,f,p,e,s,0
  
  
'start the pio1 code
  PIO start 1,0
  
'Check the the read data in MMBasic
  dim d%
  
  do
    pio read 1,0,1,d%
    print bin$(d%)
    pause 200
  loop
  
END
