'logic analyzer framework research program
'samples GP0...GP15 with triggering on GP22
'uses PIO and  ring buffer under DMA.
'requires V50707b7 or newer (function names changed)



' Test signal: Three phase motor drive - picomite V50706+
' runs autonomously on GP0...GP5 50Hz

SetPin gp0,pwm  'CH 0a
SetPin gp1,pwm  'CH 0b
SetPin gp2,pwm  'CH 1a
SetPin gp3,pwm  'CH 1b
SetPin gp4,pwm  'CH 2a
SetPin gp5,pwm  'CH 2b

PWM 0, 50, 33.33, -66.66, 1, 1
PWM 1, 50, 33.33, -66.66, 1, 1
PWM 2, 50, 33.33, -66.66, 1, 1

PWM sync 0, 100/3, 200/3
Pause 20


'----------------------------------- LA code PIO --------------------------

'PIO code to sample GP0..GP15 for logic analyzer
PIO clear 1

'in this program the PIO reads GP0..GP5 brute force
'and pushes data into FIFO. The clock speed determines the
'sampling rate. There are 3 instructions per cycle
'taking 10000/3 / 50 = 66 samples per cycle.

'the PIO program
'address    code    mnemonics         comment
'.wrap target
'  0        80A0    pull block        'pull data from FIFO into OSR when available
'  1        A027    mov(x,osr)        'load gate time (in clock pulses) from osr

'  2        4010    IN pins 16        'read 16 pins
'  3        8000    PUSH noblock      'and push to FIFO
'  4        00C2    JMP (GP22) 2      'while no trigger (GP22=1) loop to 2

'  5        4010    IN pins 16        'read 16 pins
'  6        8000    PUSH noblock      'and push to FIFO
'  7        0045    JMP (X<>0) 5 X--  'while X<>0 decrement X and jump to 5
'.wrap

'program pio1
PIO program line 1,0,&h80A0
PIO program line 1,1,&hA027
PIO program line 1,2,&h4010
PIO program line 1,3,&h8000
PIO program line 1,4,&h00C2
PIO program line 1,5,&h4010
PIO program line 1,6,&h8000
PIO program line 1,7,&h0045


'configuration
f=1e4                             'PIO run at 10kHz
p=Pio(pinctrl 0,0,0,gp0,,,)       'IN base = GP0
e=Pio(execctrl gp22,0,7)          'wrap 7 to 0, gp22 is conditional JMP pin
s=Pio(shiftctrl 0,0,0,0,0,0)      'shift in through LSB, out is not used

'write the configuration, running 10kHz
PIO init machine 1,0,f,p,e,s,0     'start address = 0

'---------------------------- LA code MMBasic ----------------------------------
'prepare trigger signal set to idle (above PIO code needs falling edge trigger)
SetPin gp22,dout
Pin(gp22)=1

'do not start PIO, the DMA will do that.

'reserve data buffers
'The logic analyzer captures 2*length% (32 bit max) samples.
'These are stored in array "data%()" using 2*length% integers (64 bit variables)
'The DMA buffer has 64bit width, is packed with 32bit FIFO (2 per cell) = length%
'The size of the ring buffer is specified in bytes, so size is 8*length%

samples% = 512										 'must be multiple of 2, larger than 256
posttrigger% = samples% / 2			 'set trigger in centre of circular buffer data
length% = samples% / 2					 	 'packed buffer = 64bit, data buffer staores 32 bit (in 64 bit vars)

Dim data%(samples%-1)             'array to put the 32 bit samples (in option base 0)
Dim packed%                       'name of the array to be formed as circular array 64 bit wide
'PIO MAKE RING BUFFER creates array called "packed%()" specified in bytes (64 bits = 8*)
PIO MAKE RING BUFFER packed%,8*length%

'dim display characters
Dim a$(1)=("_","-")


'---------------------------------------- MAIN -----------------------------------------
'adapt screen to required resolution
Option display 40,132

'mode of operation (single shot)
single=0

'the user interface
Do
  If single=1 Then
    Print "press <SPACE> to arm LA"
    Do : Loop Until Inkey$=" "
  EndIf

  'The DMA should take 2*length samples (= loopback value)
  'It should never trigger the ReadyInt interrupt (ringbuffer) hence we make the number of
  'samples near infinite (&hFFFFFFFF). When we force stop the DMA then ReadyInt will trigger.
  'the number of samples.
  PIO DMA RX 1,0,&h7FFFFFFF,packed%(),ReadyInt,32,samples%      'start DMA with ring buffer

  'write to PIO the number of post trigger samples, this starts the logging of pre-trigger data
  PIO WRITE 1,0,1,posttrigger%

  Pause 200

  Print "press 't' to trigger LA"
  Do : Loop Until Inkey$="t"

  'the trigger pulse, must be wider that 3 / f(pio) in seconds.
  'for 10kHz, that is 0.3ms
  Pulse gp22,1      'pulse 1ms (1->0->1)

  'from here the PIO should autocomplete and wait for another post trigger length% written
  Print "sampling post-trigger data"

  'wait a bit (can calculate from post trigger length and sampling speed), default for now
  Pause 200

  'stop DMA, this will call ReadyInt that stops the PIO and re-init it.
  PIO DMA RX OFF

  'process the data from the ring buffer
  Memory unpack packed%(),data%(),samples%,32

  'calculate position of the trigger point in the ring buffer, convert to rtigger in data buffer
  endpoint%=Pio(DMA RX POINTER)-Peek(VARADDR packed%())       'value in bytes
  endpoint%=endpoint% / 4                                     'convert to 32 bit values
  trigger%=(endpoint% - length%)                              'recalculate trigger from end capture
  If trigger% < 0 Then trigger% = trigger% + samples%         'compensate wrap around data buffer

  'calculate starting point based on screen size (width=128 chars)
  'to add: check wrap around in data%() within display array
  start% = trigger% - 64
  stop% = trigger% + 63
  Print start%,trigger%,stop%

  'output to serial port screen
  For j=0 To 15
    mask%=2^j
    If j=15 Then
      Print " T ";
    Else
      Print Right$("0"+Str$(j),2)+" ";
    EndIf
    If start%<0 Then
      For i=start%+2*length% To 2*length%-1
        Print a$(((data%(i) And mask%)=mask%));
      Next i
      For i=0 To stop%
        Print a$(((data%(i) And mask%)=mask%));
      Next i
    ElseIf stop%>2*length%-1 Then
      For i=start% To 2*length%-1
        Print a$(((data%(i) And mask%)=mask%));
      Next i
      For i=0 To stop%-2*length%
        Print a$(((data%(i) And mask%)=mask%));
      Next i
    Else
      For i=start% To stop%
        Print a$(((data%(i) And mask%)=mask%));
      Next i
    EndIf
    Print
  Next j
  Math set 0,packed%()

Loop

End

'-----------------------------------SUBS MMBasic --------------------------------
Sub ReadyInt
  PIO STOP 1,0
  PIO init machine 1,0,f,p,e,s,0     'start address = 0
  Print "done"
End Sub
> 
