' FRAME-TILES

'petscii testbed picomite VGA V50708RC1
'load individual tiles, and paste them in framebuffer
'then save the framebuffer as BMP file.

  MODE 2
  Option base 1
  FRAMEBUFFER create


'tiles/sprites definition
  numspr=37
  Dim tile_attrib%(numspr)


'attributes
' bit5=push,b4=seethr,b3=destr,b2=move,b1=hover,b0=walk
  b_pus=32: b_see=16: b_dmg=8: b_mov=4: b_hov=2: b_wlk=1


'load sprites
  j=0
  Sprite load "water.spr",1
  Inc j,1:tile_attrib%(j)=&b00010011

  Sprite load "tarmac.spr",2
  Inc j,1:tile_attrib%(j)=&b00010011

  Sprite load "grass.spr",3
  Inc j,1:tile_attrib%(j)=&b00010011

  Sprite load "bridge_s.spr",4
  Inc j,1:tile_attrib%(j)=&b00011011

  Sprite load "wall_v.spr",5
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "wall_h.spr",6
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "corner_rb.spr",7
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "corner_rt.spr",8
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "corner_lb.spr",9
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "corner_lt.spr",10
  Inc j,1:tile_attrib%(j)=&b00000000


  frame_tile(0,0,10)


  Sprite load "post_h.spr",1
  Inc j,1:tile_attrib%(j)=&b00100000

  Sprite load "pl1.spr",2
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "pl2.spr",3
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "chair_l.spr",4
  Inc j,1:tile_attrib%(j)=&b00010010

  Sprite load "chair_r.spr",5
  Inc j,1:tile_attrib%(j)=&b00010010

  Sprite load "table_n.spr",6
  Inc j,1:tile_attrib%(j)=&b00010010

  Sprite load "table_s.spr",7
  Inc j,1:tile_attrib%(j)=&b00010010

  Sprite load "box_open.spr",8
  Inc j,1:tile_attrib%(j)=&b00010000

  Sprite load "box_close.spr",9
  Inc j,1:tile_attrib%(j)=&b00010000

  Sprite load "carpet1.spr",10
  Inc j,1:tile_attrib%(j)=&b00010011


  frame_tile(1,0,10)


  Sprite load "plant1.spr",1
  Inc j,1:tile_attrib%(j)=&b00011000

  Sprite load "lunar_lt.spr",2
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "lunar_lb.spr",3
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "post_v.spr",4
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "pistol.spr",5
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "plasma.spr",6
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "emp.spr",7
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "bomb.spr",8
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "hoverbot.spr",9
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "rollerbot.spr",10
  Inc j,1:tile_attrib%(j)=&b00000000


  frame_tile(2,0,10)


  Sprite load "evilbot.spr",1
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "lunar_rt.spr",2
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "lunar_rb.spr",3
  Inc j,1:tile_attrib%(j)=&b00000000

  Sprite load "canister.spr",4
  Inc j,1:tile_attrib%(j)=&b00001100

  Sprite load "blown.spr",5
  Inc j,1:tile_attrib%(j)=&b00000011

  Sprite load "window_h.spr",6
  Inc j,1:tile_attrib%(j)=&b00010000

  Sprite load "window_v.spr",7
  Inc j,1:tile_attrib%(j)=&b00010000

  frame_tile(3,0,7)


'create framebuffer from sprites, then save as bmp
'  fill_f
  show_f
  Save image "tiles.bmp"


'store attributes in filesystem
  Open "tile_attrib.bin" For output As #1
  Print #1,Chr$(numspr);
  For i=1 To numspr
    Print #1,Chr$(tile_attrib%(i));
  Next
  Close #1

  End


'add n<=10 tiles to framebuffer (1 column)
Sub frame_tile(x,y,n)
    FRAMEBUFFER write f
    For i=1 To n
      Sprite write i,x*24,(i-1)*24,0
    Next
End Sub

'debug, show result on screen
Sub show_f
    FRAMEBUFFER write n
    FRAMEBUFFER copy f,n
End Sub
