'petscii testbed picomite VGA V50708b16

  MODE 2
  Option base 1

'add framebuffer
  FRAMEBUFFER layer
  FRAMEBUFFER create


'startup defines
  action=1      '1=shoot, 2=search, 3=move
  weapon=1      '1=pistol, 2=plasma, 3=EMP, 4=time bomb
  Dim arms$(4)=("pistol","plasma"," EMP  "," bomb ")


'load tiles from file
  FRAMEBUFFER write f
  Load image "tiles.bmp"


'attributes
  'bit5=push,b4=seethr,b3=destr,b2=move,b1=hover,b0=walk
  b_pus=32: b_see=16: b_dmg=8: b_mov=4: b_hov=2: b_wlk=1


'load tile attributes
  Open "tile_attrib.bin" For input As #1
  numspr=Asc(Input$(1,#1)) 'get number of sprites
  Dim tile_attrib%(numspr)
  For i=1 To numspr
    tile_attrib%(i)=Asc(Input$(1,#1)) 'get all attibutes
  Next i
  Close #1


'mini world map 20x10
  hsize=30:vsize=12
  Dim a$(vsize) length hsize
  a$(1)="A66666666666666666666666666668"
  a$(2)="533333333331323333333333333335"
  a$(3)="53MW3333333132A666666666683335"
  a$(4)="53NX33333331325KKKKKKJKKK\3L35"
  a$(5)="533333333331325KEGFKKKKIK53335"
  a$(6)="533333333311325KEHFKKKKKK53335"
  a$(7)="533333333311325KKKKKKKKKY53335"
  a$(8)="5333333333133296[66BK966673335"
  a$(9)="522222222444222222222222222225"
  a$(10)="533333333313333233333333333335"
  a$(11)="533333333313333233L3L3L3L33335"
  a$(12)="966666666666666666666666666667"

'start positions player in map
  xp=20:yp=5

'view window on map # of tiles E-W and N-S
  xsm=5:ysm=3

'window centre with 24*24 tile reference
  xs=5*24:ys=4*24


'write initial world
  writeworld_f


'write frame
  FRAMEBUFFER write L
  Load image "layer.bmp"
  show_weapon


'initial player (player sprites are 12 and 13)
  playersp=12
  writeplayer_f


'main loop
  Do
    Do :k$=Inkey$:Loop While k$=""
    key=Asc(k$)

    'player control
    v=(key=129)-(key=128)
    h=(key=131)-(key=130)
    If h+v<>0 Then  'when move key pressed
      x2=Min(Max(xp+h,1),hsize)
      y2=Min(Max(yp+v,1),vsize)
      'check if we can walk, then walk
      If (get_ta(x2,y2) And b_wlk) Then
        xp=xp+h:yp=yp+v
        xp=Min(Max(xp,1),hsize)
        yp=Min(Max(yp,1),vsize)
        writeworld_f    'scroll world
        writeplayer_f   'update player tile
      EndIf
    EndIf


'development support
    If key=27 Then 'esc
      FRAMEBUFFER write n
      Save image "pet.bmp"
    EndIf


    'player controlled AI
    FRAMEBUFFER write l

    'change action mode
    Select Case k$
      Case "z"
        If action<>2 Then
          action=2
          Text 0,0,"search"
        Else
          action=1
          Text 0,0,"combat"
        EndIf

      Case "m"
        If action<>3 Then
          action=3
          Text 0,0," move "
        Else
          action=1
          Text 0,0,"combat"
        EndIf

      'action keys
      'know error: at edge of world, shooting causes error
      'in real map this is not possible since outer rim is blocked by tile definitions
      Case "a"
        If action=1 Then
          'shoot left
          If weapon < 3 Then
            If weapon = 1 Then
              cl=RGB(green):lw=1
            Else
              cl=RGB(cyan):lw=3
            EndIf
            'check how far target is
            tg=xp
            Do
              Inc tg,-1
              ta=get_ta(tg,yp)
            Loop Until (xp-tg=xsm) Or ((ta And b_see)=0) Or (ta And b_dmg) Or t=1
            'show bullet trajectory
            Line (xsm+tg-xp+0.5)*24,106,120,106,lw,cl
            Pause 100
            Line (xsm+tg-xp+0.5)*24,106,120,106,lw,0
            'process damage
            If (ta And b_dmg) Then
              damage(tg,yp,weapon)'explode
            EndIf
          EndIf
        EndIf
      Case "d"
        If action=1 Then
          'shoot right
          If weapon < 3 Then
            If weapon = 1 Then
              cl=RGB(yellow):lw=1
            Else
              cl=RGB(cyan):lw=3
            EndIf
            'check how far target is
            tg=xp
            Do
              Inc tg,1
              ta=get_ta(tg,yp)
            Loop Until (tg-xp=xsm) Or ((ta And b_see)=0) Or (ta And b_dmg) Or tg=hsize
            'show bullet trajectory
            Line (xsm+tg-xp+0.5)*24,106,144,106,lw,cl
            Pause 100
            Line (xsm+tg-xp+0.5)*24,106,144,106,lw,0
            'process damage
            If (ta And b_dmg) Then
              damage(tg,yp,weapon) 'explode
            EndIf
          EndIf
        Case "w"
          If action=1 Then
            'shoot up
            If weapon < 3 Then
              If weapon = 1 Then
                cl=RGB(yellow):lw=1
              Else
                cl=RGB(cyan):lw=3
              EndIf
              'check how far away target is
              tg=yp
              Do
                Inc tg,-1
                ta=get_ta(xp,tg)
              Loop Until (yp-tg=ysm) Or ((ta And b_see)=0) Or (ta And b_dmg) Or tg=1
              'show bullet traject
              Line 132,(tg-yp+ysm+1.5)*24,132,96,lw,cl
              Pause 100
              Line 132,(tg-yp+ysm+1.5)*24,132,96,lw,0
              'process damage
              If (ta And b_dmg) Then
                damage(xp,tg,weapon)'explode
              EndIf
            EndIf
          EndIf
        Case "s"
          If action=1 Then
            'shoot down
            If weapon < 3 Then
              If weapon = 1 Then
                cl=RGB(yellow):lw=1
              Else
                cl=RGB(cyan):lw=3
              EndIf
              'check how far target is
              tg=yp
              Do
                Inc tg,1
                ta=get_ta(xp,tg)
              Loop Until (tg-yp=ysm) Or ((ta And b_see)=0) Or (ta And b_dmg) Or tg=vsize
              'show bullet traject
              Line 132,(tg-yp+ysm+1.5)*24,132,120,lw,cl
              Pause 100
              Line 132,(tg-yp+ysm+1.5)*24,132,120,lw,0
              'process damage
              If (ta And b_dmg) Then
                damage(xp,tg,weapon)'explode
              EndIf
            EndIf
          EndIf

        'change weapon
        Case "]"
          weapon=weapon+1
          If weapon=5 Then weapon = 1
          show_weapon
        Case "["
          weapon=weapon-1
          If weapon=0 Then weapon = 4
          show_weapon

        Case Else
          'nop

      End Select


      'machine controlled AI
      'i.e. robots

      'Pause 100
    Loop Until k$="q"

    Memory
  End


'write player from framebuffer
Sub writeplayer_f
    FRAMEBUFFER write l
    Box xs,ys,24,24,1,0,0
    playersp=23-playersp        'toggle between 2 sprites 12 and 13
    tilex=Int(playersp/10)
    tiley=playersp - tilex*10
    Sprite framebuffer f,n,tilex*24,tiley*24,xs,ys,24,24
End Sub


'create world in layer N using layer F
Sub writeworld_f
    FRAMEBUFFER write n
    For xn=-xsm To xsm
      For yn=-ysm To ysm
        x=xs+xn*24
        y=ys+yn*24
        If yp+yn<1 Or yp+yn>vsize Or xp+xn<1 Or xp+xn>hsize Then
          'outside world map, obsolete with final map
          Box x,y,24,24,1,0,0
        Else
          'load tile from world map
          spn=Asc(Mid$(a$(yp+yn),xp+xn,1))-49
          If spn>8 Then spn=spn-7
          tilex=Int(spn/10)
          tiley=spn - tilex*10
          Sprite framebuffer f,n,tilex*24,tiley*24,x,y,24,24
        EndIf
      Next
    Next
End Sub


'get tile attribute for this tile
Function get_ta(x,y)
    Local til
    til=Asc(Mid$(a$(y),x,1))-48
    If til>9 Then til=til-7
    get_ta = tile_attrib%(til)
End Function


'temporary replace damaged object with sprite
Sub damage(x,y,arm)
    MID$(a$(y),x,1)=Chr$(35+48+7) 'blown
    writeworld_f
    writeplayer_f 'why needed?
    'print @(0,0) x,y,weapon
End Sub


'show weapon sprite in UI
Sub show_weapon
  'framebuffer write l
  spn=weapon+23
  tilex=Int(spn/10)
  tiley=spn-tilex*10
  Sprite framebuffer f,l,tilex*24,tiley*24,272,40,24,24
  Text 272,32,arms$(weapon),,,,RGB(green),RGB(myrtle)
  Text 302,56,"000",,,,RGB(green),RGB(myrtle) ' ammo ?
End Sub
