'4-10-2022
'some changes to show stack/heap levels, and lower stack use: Volhout
'changes from Kevin (Bleep) to make it run on pico

' TSCP Chess
' Tom Kerrigan's Simple Chess Program
' (TSCP) version 1.81c, 2/3/19
' Copyright 2019 Tom Kerrigan
' MMBasic conversion by ceptimus
' Print Hex$(MM.Info(stack)),MM.Info(heap)

Option explicit:Option default integer:Option base 0
MODE 2:Colour RGB(white),RGB(black):CLS :Font 8

'changes to monitor STACK usage (require picomite 5.07.05RC5 or newer)
SetTick 200,showstack

Dim min_stack%=10000
Dim auto_play%=0
Dim bar$=Space$(8)
Dim i:For i=1 To 9:bar$=bar$+Chr$(127):Next

Sub showstack
Local a%,b%
a%=MM.Info(stack)
a%=a%-&h2003f800  'stack info from matherp
a%=a%/1000 'value 9...2'
If a% < 4 Then
b%=RGB(red)
Else
b%=RGB(greeN)
EndIf
Text 280,220,Mid$(bar$,a%,9),,,,b%
'min_stack%=min(a%,min_stack%)
'text 240,220,"stack min  "+str$(min_stack%)
'text 240,212,"stack free "+str$(a%)
'b%=mm.info(heap)
'text 240,202,"heap free  "+str$(b%)
End Sub
'end of stack monitor changes ----------------------------------------

' BOARD
Sub init_board
Local i
Restore data_init_hue:For i=0 To 63:Read hue(i):Next 'i
Restore data_init_piece:For i=0 To 63:Read piece(i):Next 'i
side=LIGHT
xside=DARK
castle=15
ep=-1
fifty=0
ply=0
hply=0
set_hash ' init_hash() must be called before this function.
first_move(0)=0
End Sub

Sub init_hash
Local i,j,k
For i=0 To 1
For j=0 To 5
For k=0 To 63
hash_piece(i,j,k)=hash_rand()
Next 'k
Next 'j
Next 'i
hash_side=hash_rand()
For i=0 To 63
hash_ep(i)=hash_rand()
Next 'i
End Sub

'could this be changed to a simple RND() ?
Function hash_rand()
Local i,r=0
For i=0 To 31:r=r Xor ((2^16)*Rnd())*(2^i):Next 'i
hash_rand=r
End Function

Sub set_hash
Local i
hash=0 'hash is global
For i=0 To 63
If hue(i)<>EMPTY Then hash=hash Xor hash_piece(hue(i),piece(i),i)
Next
If side=DARK Then hash=hash Xor hash_side
If ep<>-1 Then hash=hash Xor hash_ep(ep)
End Sub

Function in_check(s)
Local i
in_check=1 ' in case king not found (shouldn't happen)
For i=0 To 63
If (piece(i)=KING)And(hue(i)=s) Then
in_check=attack(i, s Xor 1)
i=63
EndIf
Next 'i
End Function

Function attack(sq,s)
Local i,j,n,x
attack=0 ' default to false
For i=0 To 63
If hue(i)=s Then
If piece(i)=PAWN Then
If s=LIGHT Then
If ((i And 7)<>0)And(i-9=sq) Then
attack=1:Exit For
EndIf
If ((i And 7)<>7)And(i-7=sq) Then
attack=1:Exit For
EndIf
Else
If ((i And 7)<>0)And(i+7=sq) Then
attack=1:Exit For
EndIf
If ((i And 7)<>7)And(i+9=sq) Then
attack=1:Exit For
EndIf
EndIf
Else
For j=0 To offsets(piece(i))-1
n=i
Do
x=mailbox64(n)
x=x+offset(piece(i),j)
n=mailbox(x)
If n=-1 Then Exit
If n=sq Then
attack=1
j=offsets(piece(i))-1
i=63:Exit
EndIf
If hue(n)<>EMPTY Then Exit
If slide(piece(i))=0 Then Exit
Loop
Next 'j
EndIf
EndIf
Next 'i
End Function

Sub gen
Local i,j,n,x
first_move(ply+1)=first_move(ply)

For i=0 To 63
If hue(i)=side Then
If piece(i)=PAWN Then
If side=LIGHT Then
If (i And 7)<>0 Then
x=i-9
If hue(x)=DARK Then gen_push(i,x,17)
EndIf
If (i And 7)<>7 Then
x=i-7
If hue(x)=DARK Then gen_push(i,x,17)
EndIf
If hue(i-8)=EMPTY Then
gen_push(i,i-8,16)
If i>=48 Then
x=i-16
If hue(x)=EMPTY Then gen_push(i,x,24)
EndIf
EndIf
Else
If (i And 7)<>0 Then
x=i+7
If hue(x)=LIGHT Then gen_push(i,x,17)
EndIf
If (i And 7)<>7 Then
x=i+9
If hue(x)=LIGHT Then gen_push(i,x,17)
EndIf
If hue(i+8)=EMPTY Then
gen_push(i,i+8,16)
If i<=15 Then
x=i+16
If hue(x)=EMPTY Then gen_push(i,x,24)
EndIf
EndIf
EndIf
Else
For j=0 To offsets(piece(i))-1
n=i
Do
x=mailbox64(n)
x=x+offset(piece(i),j)
n=mailbox(x)
If n=-1 Then Exit
If hue(n)<>EMPTY Then
If hue(n)=xside Then gen_push(i,n,1)
Exit
EndIf
gen_push(i,n,0)
If slide(piece(i))=0 Then Exit
Loop
Next 'j
EndIf
EndIf
Next 'i

If side=LIGHT Then
If (castle And 1)<>0 Then gen_push(E1,G1,2)
If (castle And 2)<>0 Then gen_push(E1,C1,2)
Else
If (castle And 4)<>0 Then gen_push(E8,G8,2)
If (castle And 8)<>0 Then gen_push(E8,C8,2)
EndIf

If ep<>-1 Then
If side=LIGHT Then
x=ep+7
If ((ep And 7)<>0)And(hue(x)=LIGHT)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
x=ep+9
If ((ep And 7)<>7)And(hue(x)=LIGHT)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
Else
x=ep-9
If ((ep And 7)<>0)And(hue(x)=DARK)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
x=ep-7
If ((ep And 7)<>7)And(hue(x)=DARK)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
EndIf
EndIf
End Sub

Sub gen_caps
Local i,j,n,x
first_move(ply+1)=first_move(ply)
For i=0 To 63
If hue(i)=side Then
If piece(i)=PAWN Then
If side=LIGHT Then
If (i And 7)<>0 Then
x=i-9
If hue(x)=DARK Then gen_push(i,x,17)
EndIf
If (i And 7)<>7 Then
x=i-7
If hue(x)=DARK Then gen_push(i,x,17)
EndIf
If i<=15 Then
x=i-8
If hue(x)=EMPTY Then gen_push(i,x,16)
EndIf
EndIf
If side=DARK Then
If (i And 7)<>0 Then
x=i+7
If hue(x)=LIGHT Then gen_push(i,x,17)
EndIf
If (i And 7)<>7 Then
x=i+9
If hue(x)=LIGHT Then gen_push(i,x,17)
EndIf
If i>=48 Then
x=i+8
If hue(x)=EMPTY Then gen_push(i,x,16)
EndIf
EndIf
Else
For j=0 To offsets(piece(i))-1
n=i
Do
x=mailbox64(n)
x=x+offset(piece(i),j)
n=mailbox(x)
If n=-1 Then Exit
If hue(n)<>EMPTY Then
If hue(n)=xside Then gen_push(i,n,1)
Exit
EndIf
If slide(piece(i))=0 Then Exit
Loop
Next 'j
EndIf
EndIf
Next 'i
If ep<>-1 Then
If side=LIGHT Then
x=ep+7
If ((ep And 7)<>0)And(hue(x)=LIGHT)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
x=ep+9
If ((ep And 7)<>7)And(hue(x)=LIGHT)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
Else
x=ep-9
If ((ep And 7)<>0)And(hue(x)=DARK)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
x=ep-7
If ((ep And 7)<>7)And(hue(x)=DARK)And(piece(x)=PAWN) Then
gen_push(x,ep,21)
EndIf
EndIf
EndIf
End Sub

Sub gen_push(from,too,bits)
Local g,p
If (bits And 16)<>0 Then
If side=LIGHT) Then
If too<=H8 Then gen_promote(from,too,bits):Exit Sub
Else
If too>=A1 Then gen_promote(from,too,bits):Exit Sub
EndIf
EndIf
g=first_move(ply+1)
Inc first_move(ply+1),1
Poke var p,0,from
Poke var p,1,too
Poke var p,2,0 'promote default
Poke var p,3,bits
gen_dat(g,0)=p
If hue(too)<>EMPTY Then
gen_dat(g,1)=1000000+piece(too)*10-piece(from)
Else
gen_dat(g,1)=history(from,too)
EndIf
End Sub

Sub gen_promote(from,too,bits)
Local i,g,p
For i=KNIGHT To QUEEN
g=first_move(ply+1)
Inc first_move(ply+1),1
Poke var p,0,from
Poke var p,1,too
Poke var p,2,i
Poke var p,3,bits Or 32
gen_dat(g,0)=p
gen_dat(g,1)=1000000+i*10
Next 'i
End Sub

Function makemove(m)
Local from,too
Local m_from=Peek(var m,0)
Local m_too=Peek(var m,1)
Local m_promote=Peek(var m,2)
Local m_bits=Peek(var m,3)
Local break=0
Local a,b,x 'Volhout
makemove=0

If (m_bits And 2)<>0 Then
If in_check(side)<>0 Then Exit Function
Select Case m_too
Case 62
a=attack(F1,xside)
b=attack(G1,xside)
If (hue(F1)<>EMPTY)Or(hue(G1)<>EMPTY) Then
break=1
ElseIf (a<>0)Or(b<>0) Then
break=1
EndIf
from=H1
too=F1
Case 58
a=attack(C1,xside)
b=attack(D1,xside)
If (hue(B1)<>EMPTY)Or(hue(C1)<>EMPTY)Or(hue(D1)<>EMPTY) Then
break=1
ElseIf (a<>0)Or(b<>0) Then
break=1
EndIf
from=A1
too=D1
Case 6
a=attack(F8,xside)
b=attack(G8,xside)
If (hue(F8)<>EMPTY)Or(hue(G8)<>EMPTY) Then
break=1
ElseIf (a<>0)Or(b<>0) Then
break=1
EndIf
from=H8
too=F8
Case 2
a=attack(C8,xside)
b=attack(D8,xside)
If (hue(B8)<>EMPTY)Or(hue(C8)<>EMPTY)Or(hue(D8)<>EMPTY) Then
break=1
ElseIf (a<>0)Or(b<>0) Then
break=1
EndIf
from=A8
too=D8
Case Else  ' shouldn't get here
from=-1
too=-1
End Select
If break<>0 Then Exit Function
hue(too)=hue(from)
piece(too)=piece(from)
hue(from)=EMPTY
piece(from)=EMPTY
EndIf

hist_dat(hply,0)=m
hist_dat(hply,1)=piece(m_too)
hist_dat(hply,2)=castle
hist_dat(hply,3)=ep
hist_dat(hply,4)=fifty
hist_dat(hply,5)=hash
Inc ply,1
Inc hply,1

castle=castle And (castle_mask(m_from) And castle_mask(m_too))
If (m_bits And 8)<>0 Then
If side=LIGHT Then
ep=m_too+8
Else
ep=m_too-8
EndIf
Else
ep=-1
EndIf

If (m_bits And 17)<>0 Then
fifty=0
Else
Inc fifty,1
EndIf

hue(m_too)=side
If (m_bits And 32)<>0 Then
piece(m_too)=m_promote
Else
piece(m_too)=piece(m_from)
EndIf
hue(m_from)=EMPTY
piece(m_from)=EMPTY

If (m_bits And 4)<>0 Then
If side=LIGHT Then
hue(m_too+8)=EMPTY
piece(m_too+8)=EMPTY
Else
hue(m_too-8)=EMPTY
piece(m_too-8)=EMPTY
EndIf
EndIf

side=side Xor 1
xside=xside Xor 1
x=in_check(xside)
If x<>0 Then takeback:Exit Function
set_hash
makemove=1
End Function

Sub takeback
Local m,m_from,m_too,m_bits,from,too

side=side Xor 1
xside=xside Xor 1
Inc ply,-1
Inc hply,-1
m=hist_dat(hply,0)
m_from=Peek(var m,0)
m_too=Peek(var m,1)
m_bits=Peek(var m,3)
castle=hist_dat(hply,2)
ep=hist_dat(hply,3)
fifty=hist_dat(hply,4)
hash=hist_dat(hply,5)
hue(m_from)=side
If (m_bits And 32)<>0 Then
piece(m_from)=PAWN
Else
piece(m_from)=piece(m_too)
EndIf
If hist_dat(hply,1)=EMPTY Then
hue(m_too)=EMPTY
piece(m_too)=EMPTY
Else
hue(m_too)=xside
piece(m_too)=hist_dat(hply,1)
EndIf
If (m_bits And 2)<>0 Then
Select Case m_too
Case 62
from=F1
too=H1
Case 58
from=D1
too=A1
Case 6
from=F8
too=H8
Case 2
from=D8
too=A8
Case Else ' shouldn't get here
from=-1
too=-1
End Select
hue(too)=side
piece(too)=ROOK
hue(from)=EMPTY
piece(from)=EMPTY
EndIf

If (m_bits And 4)<>0 Then
If side=LIGHT Then
hue(m_too+8)=xside
piece(m_too+8)=PAWN
Else
hue(m_too-8)=xside
piece(m_too-8)=PAWN
EndIf
EndIf
End Sub

' BOOK
Dim book_file=0 'set to 1 if opening book is present

Sub open_book
Local d$=MM.Device$

On Error Skip
Open "book.txt" For input As#1
If MM.Errno<>0 Then
oPrintR "Opening book missing."
Else
Close #1
book_file=1
EndIf
End Sub

Sub close_book
book_file=0
End Sub

Function book_move()
Local L$,book_line$,x$
Local i,j,m,found,y
Local move(50)  'the possible book moves
Local count(50) 'the number of occurrences of each move
Local moves,total_count

moves=0
total_count=0
book_move=-1 'default to "no book move"

If book_file=0 Or hply>25 Then Exit Function

L$=""

For i=0 To hply-1
L$=L$+move_str$(hist_dat(i,0))+" "
Next 'i

Open "book.txt" For input As#1
Do While Not Eof(#1)
Input #1, book_line$
y=book_match(L$, book_line$)
If y<>0 Then
x$=Mid$(book_line$, Len(L$)+1)
m=parse_move(x$)
If m<>-1 Then
m=gen_dat(m, 0)
found=0
For j=0 To moves-1
If move(j)=m Then Inc count(j),1:found=1:j=moves
Next 'j
If found=0 Then
move(moves)=m
count(moves)=1
Inc moves,1
EndIf
Inc total_count,1
EndIf
EndIf
Loop
Close #1
If moves=0 Then Exit Function

j=Int(Rnd()*total_count)
For i=0 To moves-1
j=j-count(i)
If j<0 Then book_move=move(i):i=moves
Next 'i
End Function

Function book_match(s1$, s2$)
book_match=0
If Left$(s2$, Len(s1$))=s1$ Then book_match=1
End Function

' DATA
Sub init_arrays
Local i,j

Dim hue(63)
Dim piece(63)
Dim side
Dim xside
Dim castle
Dim ep
Dim fifty
Dim hash
Dim ply
Dim hply
Dim gen_dat(GEN_STACK,1)
Dim first_move(MAX_PLY)
Dim history(63,63)
Dim hist_dat(HIST_STACK, 5)
Dim max_time,max_depth
Dim start_time,stop_time
Dim nodes
Dim pv(MAX_PLY, MAX_PLY)
Dim pv_length(MAX_PLY)
Dim follow_pv
Dim hash_piece(1,5,63)
Dim hash_side
Dim hash_ep(63)
Dim mailbox(119)

data_mailbox:
Data -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
Data -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
Data -1,  0,  1,  2,  3,  4,  5,  6,  7, -1
Data -1,  8,  9, 10, 11, 12, 13, 14, 15, -1
Data -1, 16, 17, 18, 19, 20, 21, 22, 23, -1
Data -1, 24, 25, 26, 27, 28, 29, 30, 31, -1
Data -1, 32, 33, 34, 35, 36, 37, 38, 39, -1
Data -1, 40, 41, 42, 43, 44, 45, 46, 47, -1
Data -1, 48, 49, 50, 51, 52, 53, 54, 55, -1
Data -1, 56, 57, 58, 59, 60, 61, 62, 63, -1
Data -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
Data -1, -1, -1, -1, -1, -1, -1, -1, -1, -1

Dim mailbox64(63)
data_mailbox64:
Data 21, 22, 23, 24, 25, 26, 27, 28
Data 31, 32, 33, 34, 35, 36, 37, 38
Data 41, 42, 43, 44, 45, 46, 47, 48
Data 51, 52, 53, 54, 55, 56, 57, 58
Data 61, 62, 63, 64, 65, 66, 67, 68
Data 71, 72, 73, 74, 75, 76, 77, 78
Data 81, 82, 83, 84, 85, 86, 87, 88
Data 91, 92, 93, 94, 95, 96, 97, 98

Dim slide(5)=(0,0,1,1,1,0)
Dim offsets(5)=(0,8,4,4,8,8)

Dim offset(5,7)
data_offset:
Data   0,   0,   0,   0,   0,   0,   0,   0
Data -21, -19, -12,  -8,   8,  12,  19,  21
Data -11,  -9,   9,  11,   0,   0,   0,   0
Data -10,  -1,   1,  10,   0,   0,   0,   0
Data -11, -10,  -9,  -1,   1,   9,  10,  11
Data -11, -10,  -9,  -1,   1,   9,  10,  11

Dim castle_mask(63)
data_castle_mask:
Data  7, 15, 15, 15,  3, 15, 15, 11
Data 15, 15, 15, 15, 15, 15, 15, 15
Data 15, 15, 15, 15, 15, 15, 15, 15
Data 15, 15, 15, 15, 15, 15, 15, 15
Data 15, 15, 15, 15, 15, 15, 15, 15
Data 15, 15, 15, 15, 15, 15, 15, 15
Data 15, 15, 15, 15, 15, 15, 15, 15
Data 13, 15, 15, 15, 12, 15, 15, 14

Dim piece_char$="PNBRQKpnbrqk"

data_init_hue:
Data 1, 1, 1, 1, 1, 1, 1, 1
Data 1, 1, 1, 1, 1, 1, 1, 1
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 0, 0, 0, 0, 0, 0, 0, 0
Data 0, 0, 0, 0, 0, 0, 0, 0

data_init_piece:
Data 3, 1, 2, 4, 5, 2, 1, 3
Data 0, 0, 0, 0, 0, 0, 0, 0
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 6, 6, 6, 6, 6, 6, 6, 6
Data 0, 0, 0, 0, 0, 0, 0, 0
Data 3, 1, 2, 4, 5, 2, 1, 3

Dim stop_search=0
Dim flipped=0

Restore data_mailbox:For i=0 To 119:Read mailbox(i):Next 'i
Restore data_mailbox64:For i=0 To 63:Read mailbox64(i):Next 'i
Restore data_offset

For i=0 To 5
For j=0 To 7
Read offset(i,j)
Next 'j
Next 'i

Restore data_castle_mask:For i=0 To 63:Read castle_mask(i):Next 'i
Restore data_pawn_pcsq:For i=0 To 63:Read pawn_pcsq(i):Next 'i
Restore data_knight_pcsq:For i=0 To 63:Read knight_pcsq(i):Next 'i
Restore data_bishop_pcsq:For i=0 To 63:Read bishop_pcsq(i):Next 'i
Restore data_king_pcsq:For i=0 To 63:Read king_pcsq(i):Next 'i
Restore data_king_endgame_pcsq
For i=0 To 63:Read king_endgame_pcsq(i):Next 'i
Restore data_flip:For i=0 To 63:Read flip(i):Next 'i
End Sub

' DEFS
Const GEN_STACK  = 200' 400 '600 '1120 '208
Const MAX_PLY    = 4 '6'32
Const HIST_STACK = 100 '400
Const LIGHT      = 0
Const DARK       = 1
Const PAWN       = 0
Const KNIGHT     = 1
Const BISHOP     = 2
Const ROOK       = 3
Const QUEEN      = 4
Const KING       = 5
Const EMPTY      = 6
Const A1 =56
Const B1 =57
Const C1 =58
Const D1 =59
Const E1 =60
Const F1 =61
Const G1 =62
Const H1 =63
Const A8 = 0
Const B8 = 1
Const C8 = 2
Const D8 = 3
Const E8 = 4
Const F8 = 5
Const G8 = 6
Const H8 = 7

' EVAL

Const DOUBLED_PAWN_PENALTY      = 10
Const ISOLATED_PAWN_PENALTY     = 20
Const BACKWARDS_PAWN_PENALTY    =  8
Const PASSED_PAWN_BONUS         = 20
Const ROOK_SEMI_OPEN_FILE_BONUS = 10
Const ROOK_OPEN_FILE_BONUS      = 15
Const ROOK_ON_SEVENTH_BONUS     = 20

Dim piece_value(5)=(100,300,300,500,900,0)

Dim pawn_pcsq(63)
data_pawn_pcsq:
Data  0,   0,   0,   0,   0,   0,   0,   0
Data  5,  10,  15,  20,  20,  15,  10,   5
Data  4,   8,  12,  16,  16,  12,   8,   4
Data  3,   6,   9,  12,  12,   9,   6,   3
Data  2,   4,   6,   8,   8,   6,   4,   2
Data  1,   2,   3, -10, -10,   3,   2,   1
Data  0,   0,   0, -40, -40,   0,   0,   0
Data  0,   0,   0,   0,   0,   0,   0,   0

Dim knight_pcsq(63)
data_knight_pcsq:
Data -10, -10, -10, -10, -10, -10, -10, -10
Data -10,   0,   0,   0,   0,   0,   0, -10
Data -10,   0,   5,   5,   5,   5,   0, -10
Data -10,   0,   5,  10,  10,   5,   0, -10
Data -10,   0,   5,  10,  10,   5,   0, -10
Data -10,   0,   5,   5,   5,   5,   0, -10
Data -10,   0,   0,   0,   0,   0,   0, -10
Data -10, -30, -10, -10, -10, -10, -30, -10

Dim bishop_pcsq(63)
data_bishop_pcsq:
Data -10, -10, -10, -10, -10, -10, -10, -10
Data -10,   0,   0,   0,   0,   0,   0, -10
Data -10,   0,   5,   5,   5,   5,   0, -10
Data -10,   0,   5,  10,  10,   5,   0, -10
Data -10,   0,   5,  10,  10,   5,   0, -10
Data -10,   0,   5,   5,   5,   5,   0, -10
Data -10,   0,   0,   0,   0,   0,   0, -10
Data -10, -10, -20, -10, -10, -20, -10, -10

Dim king_pcsq(63)
data_king_pcsq:
Data -40, -40, -40, -40, -40, -40, -40, -40
Data -40, -40, -40, -40, -40, -40, -40, -40
Data -40, -40, -40, -40, -40, -40, -40, -40
Data -40, -40, -40, -40, -40, -40, -40, -40
Data -40, -40, -40, -40, -40, -40, -40, -40
Data -40, -40, -40, -40, -40, -40, -40, -40
Data -20, -20, -20, -20, -20, -20, -20, -20
Data   0,  20,  40, -20,   0, -20,  40,  20

Dim king_endgame_pcsq(63)
data_king_endgame_pcsq:
Data  0,  10,  20,  30,  30,  20,  10,   0
Data 10,  20,  30,  40,  40,  30,  20,  10
Data 20,  30,  40,  50,  50,  40,  30,  20
Data 30,  40,  50,  60,  60,  50,  40,  30
Data 30,  40,  50,  60,  60,  50,  40,  30
Data 20,  30,  40,  50,  50,  40,  30,  20
Data 10,  20,  30,  40,  40,  30,  20,  10
Data  0,  10,  20,  30,  30,  20,  10,   0

Dim flip(63)
data_flip:
Data 56,  57,  58,  59,  60,  61,  62,  63
Data 48,  49,  50,  51,  52,  53,  54,  55
Data 40,  41,  42,  43,  44,  45,  46,  47
Data 32,  33,  34,  35,  36,  37,  38,  39
Data 24,  25,  26,  27,  28,  29,  30,  31
Data 16,  17,  18,  19,  20,  21,  22,  23
Data  8,   9,  10,  11,  12,  13,  14,  15
Data  0,   1,   2,   3,   4,   5,   6,   7

Dim pawn_rank(1,9)
Dim piece_mat(1)
Dim pawn_mat(1)

Function eval_()
Local i,f,score(1),x

For i=0 To 9
pawn_rank(LIGHT,i)=0
pawn_rank(DARK,i)=7
Next 'i
piece_mat(LIGHT)=0
piece_mat(DARK)=0
pawn_mat(LIGHT)=0
pawn_mat(DARK)=0
For i=0 To 63
If hue(i)<>EMPTY Then
If piece(i)=PAWN Then
pawn_mat(hue(i))=pawn_mat(hue(i))+piece_value(PAWN)
f=(i And 7)+1 ' add 1 because of the extra file in the array
If hue(i)=LIGHT Then
If pawn_rank(LIGHT,f)<i\8 Then pawn_rank(LIGHT,f)=i\8
Else
If pawn_rank(DARK,f)>i\8 Then pawn_rank(DARK,f)=i\8
EndIf
Else
piece_mat(hue(i))=piece_mat(hue(i))+piece_value(piece(i))
EndIf
EndIf
Next 'i

score(LIGHT)=piece_mat(LIGHT)+pawn_mat(LIGHT)
score(DARK)=piece_mat(DARK)+pawn_mat(DARK)
For i=0 To 63
Do
If hue(i)<>EMPTY Then Exit
Inc i,1:If i>63 Then Exit
Loop :If i>63 Then Exit For
If hue(i)=LIGHT Then
Select Case piece(i)
Case PAWN
x=eval_light_pawn(i)
score(LIGHT)=score(LIGHT)+x
Case KNIGHT
score(LIGHT)=score(LIGHT)+knight_pcsq(i)
Case BISHOP
score(LIGHT)=score(LIGHT)+bishop_pcsq(i)
Case ROOK
If pawn_rank(LIGHT,(i And 7)+1)=0 Then
If pawn_rank(DARK,(i And 7)+1)=7 Then
score(LIGHT)=score(LIGHT)+ROOK_OPEN_FILE_BONUS
Else
score(LIGHT)=score(LIGHT)+ROOK_SEMI_OPEN_FILE_BONUS
EndIf
EndIf
If i\8=1 Then
score(LIGHT)=score(LIGHT)+ROOK_ON_SEVENTH_BONUS
EndIf
Case KING
If piece_mat(DARK)<=1200 Then
score(LIGHT)=score(LIGHT)+king_endgame_pcsq(i)
Else
x=eval_light_king(i)
score(LIGHT)=score(LIGHT)+x
EndIf
End Select
Else
Select Case piece(i)
Case PAWN
x=eval_dark_pawn(i)
score(DARK)=score(DARK)+x
Case KNIGHT
score(DARK)=score(DARK)+knight_pcsq(flip(i))
Case BISHOP
score(DARK)=score(DARK)+bishop_pcsq(flip(i))
Case ROOK
If pawn_rank(DARK,(i And 7)+1)=7 Then
If pawn_rank(LIGHT,(i And 7)+1)=0 Then
score(DARK)=score(DARK)+ROOK_OPEN_FILE_BONUS
Else
score(DARK)=score(DARK)+ROOK_SEMI_OPEN_FILE_BONUS
EndIf
EndIf
If i\8=6 Then
score(DARK)=score(DARK)+ROOK_ON_SEVENTH_BONUS
EndIf
Case KING
If piece_mat(LIGHT)<=1200 Then
score(DARK)=score(DARK)+king_endgame_pcsq(flip(i))
Else
x=eval_dark_king(i)
score(DARK)=score(DARK)+x
EndIf
End Select
EndIf
Next 'i

If side=LIGHT Then
eval_=score(LIGHT)-score(DARK)
Else
eval_=score(DARK)-score(LIGHT)
EndIf
End Function

Function eval_light_pawn(sq)
Local r ' the value to return
Local f ' the pawn's file

r=0
f=(sq And 7)+1
r=r+pawn_pcsq(sq)

If pawn_rank(LIGHT,f)>sq\8 Then r=r-DOUBLED_PAWN_PENALTY

If (pawn_rank(LIGHT,f-1)=0)And(pawn_rank(LIGHT,f+1)=0) Then
r=r-ISOLATED_PAWN_PENALTY
ElseIf (pawn_rank(LIGHT,f-1)<sq\8)And(pawn_rank(LIGHT,f+1)<sq\8) Then
r=r-BACKWARDS_PAWN_PENALTY
EndIf

If (pawn_rank(DARK,f-1)>=sq\8)And(pawn_rank(DARK,f)>=sq\8) Then
If pawn_rank(DARK,f+1)>=sq\8 Then
r=r+(7-(sq\8))*PASSED_PAWN_BONUS
EndIf
EndIf

eval_light_pawn=r
End Function

Function eval_dark_pawn(sq)
Local r
Local f

f=(sq And 7)+1
r=pawn_pcsq(flip(sq))

If pawn_rank(DARK,f)<sq\8 Then r=r-DOUBLED_PAWN_PENALTY

If (pawn_rank(DARK,f-1)=7)And(pawn_rank(DARK,f+1)=7) Then
r=r-ISOLATED_PAWN_PENALTY
ElseIf (pawn_rank(DARK,f-1)>sq\8)And(pawn_rank(DARK,f+1)>sq\8) Then
r=r-BACKWARDS_PAWN_PENALTY
EndIf

If (pawn_rank(LIGHT,f-1)<=sq\8)And(pawn_rank(LIGHT,f)<=sq\8) Then
If pawn_rank(LIGHT,f+1)<=sq\8 Then
r=r+(sq\8)*PASSED_PAWN_BONUS
EndIf
EndIf
eval_dark_pawn=r
End Function

Function eval_light_king(sq)
Local r
Local i

r=king_pcsq(sq)

If (sq And 7)<3 Then
Inc r,eval_lkp(1)
Inc r,eval_lkp(2)
Inc r,eval_lkp(3)\2
ElseIf (sq And 7)>4 Then
Inc r,eval_lkp(8)
Inc r,eval_lkp(7)
Inc r,eval_lkp(6)\2
Else
For i=(sq And 7) To (sq And 7)+2
If (pawn_rank(LIGHT,i)=0)And(pawn_rank(DARK,i)=7) Then
Inc r,-10
EndIf
Next 'i
EndIf

r=r*piece_mat(DARK)
r=r\3100
eval_light_king=r
End Function

Function eval_lkp(f)
Local r=0

If pawn_rank(LIGHT,f)=6 Then
ElseIf pawn_rank(light,f)=5 Then
Inc r,-10
ElseIf pawn_rank(LIGHT,f)<>0 Then
Inc r,-20
Else
Inc r,-25
EndIf

If pawn_rank(DARK,f)=7 Then
Inc r,-15
ElseIf pawn_rank(DARK,f)=5 Then
Inc r,-10
ElseIf pawn_rank(DARK,f)=4 Then
Inc r,-5
EndIf

eval_lkp=r
End Function

Function eval_dark_king(sq)
Local r,i

r=king_pcsq(flip(sq))
If (sq And 7)<3 Then
Inc r,eval_dkp(1)
Inc r,eval_dkp(2)
Inc r,eval_dkp(3)\2
ElseIf (sq And 7)>4 Then
Inc r,eval_dkp(8)
Inc r,eval_dkp(7)
Inc r,eval_dkp(6)\2
Else
For i=(sq And 7) To (sq And 7)+2
If (pawn_rank(LIGHT,i)=0)And(pawn_rank(DARK,i)=7) Then
Inc r,-10
EndIf
Next 'i
EndIf

r=r*piece_mat(LIGHT)
r=r\3100
eval_dark_king=r
End Function

Function eval_dkp(f)
Local r=0

If pawn_rank(DARK,f)=1 Then
ElseIf pawn_rank(DARK,f)=2 Then
Inc r,-10
ElseIf pawn_rank(DARK,f)<>7 Then
Inc r,-20
Else
Inc r,-25
EndIf

If pawn_rank(LIGHT,f)=0 Then
Inc r,-15
ElseIf pawn_rank(LIGHT,f)=2 Then
Inc r,-10
ElseIf pawn_rank(LIGHT,f)=3 Then
Inc r,-5
EndIf

eval_dkp=r
End Function

' GRAPHICS
Const P_Y=228
Const R_H=7
Const B_W=136
Const B_T=10
Const E_W=320

Sub load_sprites
Local i,x,y
For i=1 To 24
x=((i-1) Mod 12)*20+1
y=(i-1)\12*20+1
Sprite Loadbmp i, "small",x,y,18,18
Next 'i
End Sub

Sub oPrint s$
'text mm.hpos,P_Y,s$
Text 1, P_Y, s$
End Sub

Sub oPrintR s$
oPrint s$
'  Sprite B_W,P_Y,B_W,P_Y-R_H,E_W-B_W,R_H
Sprite 0,B_T+R_H,0,B_T,B_W,P_Y-B_T
Box 0,P_Y,E_W,R_H,0,0,0
'  Print
End Sub

Function oInput$(prompt$)
Local s$
draw_chessboard
Box 0,P_Y,E_W,R_H,0,0,0
oPrint prompt$
'-------------------------------Volhout---------- autoplay itself -----
'type "auto" to let the computer continue to play itself
If auto_play%=0 Then
Input "",s$
Else
s$="on" '<--------this is autoplay
EndIf
If s$="auto" Then auto_play%=1
'-------------------------------Volhout---------- autoplay itself end --
'  Sprite B_W,P_Y,B_W,P_Y-R_H,E_W-B_W,R_H
Sprite 0,B_T+R_H,0,B_T,B_W,P_Y-B_T
Box 0,P_Y,E_W,R_H,0,0,0
'  Print
oInput$=s$
End Function

Sub draw_chessboard
Local x,y,i,sq,s,p=0,from,too

If hply>0 Then
from=Peek(var hist_dat(hply-1,0),0)
too=Peek(var hist_dat(hply-1,0),1)
Else
from=-1:too=-1
EndIf

For i=0 To 63
sq=i:If flipped Then sq=63-i
x=i Mod 8:y=i\8
If p Then 'draw dark square
Box x*20+150,y*20+12,20,20,0,0,RGB(myrtle)
Else 'draw light square
Box x*20+150,y*20+12,20,20,0,0,RGB(white) 'was 192,192,192
EndIf
If hue(sq)<>EMPTY Then
s=1+piece(sq)*2+p
If hue(sq)=DARK Then s=s+12
Sprite write s,x*20+151,y*20+13
EndIf
If sq=from Or sq=too Then Box x*20+150,y*20+12,20,20,1,0
If x<>7 Then p=Not p
Next 'i

For i=0 To 7
p=i:If flipped Then p=7-i
Text 142,i*20+20,Str$(8-p)
Text 159+i*20,174,Chr$(97+p)
Next 'i
Print
End Sub

' MAIN
Sub main
Local computer_side,m,s$
CLS
Print "'help' displays a list of commands"

init_hash
init_board
open_book
gen
computer_side=EMPTY
max_time=6e5 '10min' 4e5 '400sec '2^24
max_depth=3

Do
If side=computer_side Then
think(1)
If pv(0,0)=0 Then
oPrintR "(no legal moves)"
computer_side=EMPTY
print_result
Else
oPrintR "Computer's move: "+move_str$(pv(0,0))
m=makemove(pv(0,0))
ply=0
gen
print_result
EndIf
Else
s$=oInput$("tscp> ")
If s$="on" Then
computer_side=side
ElseIf s$="off" Then
computer_side=EMPTY
ElseIf (Left$(s$,2)="st")And(Len(s$)>2) Then
max_time=1000*Val(Mid$(s$,3))
max_depth=5'32
ElseIf (Left$(s$,2)="sd")And(Len(s$)>2) Then
max_depth=Val(Mid$(s$,3))
If max_depth<1 Then max_depth=1
If max_Depth>MAX_PLY Then max_depth=MAX_PLY+1
max_time=4e5'2^24
ElseIf s$="undo" Then
If hply<>0 Then
computer_side=EMPTY
takeback
ply=0
gen
EndIf
ElseIf s$="new" Then
computer_side=EMPTY
init_board
gen
'      ElseIf s$="d" Then
'        print_board
ElseIf s$="v" Then
flipped=Not flipped
ElseIf s$="bench" Then
computer_side=EMPTY
bench
ElseIf s$="bye" Then
oPrintR "Share and enjoy!"
Exit
ElseIf s$="help" Then
oPrintR "on - computer plays"
oPrintR "     for the side to move"
oPrintR "off - computer stops playing"
oPrintR "st n - search for n secs per move"
oPrintR "sd n - search n (1-5) ply per move"
oPrintR "undo - takes back a move"
oPrintR "new - starts a new game"
oPrintR "v - view board from opposite side"
oPrintR "bench - run the built-in benchmark"
oPrintR "bye - exit the program"
oPrintR "Enter moves in coordinate notation"
oPrintR "               e.g., e2e4, e7e8Q"
Else
m=parse_move(s$)
If m=-1 Then
oPrintR "Illegal move."
ElseIf makemove(gen_dat(m,0))=0 Then
oPrintR "Illegal move."
Else
ply=0
gen
print_result
draw_chessboard
EndIf
EndIf
EndIf
Loop
close_book
End Sub

Function parse_move(vs$)
Local from,too,i,a(4),s$

parse_move=-1 'default to 'illegal move'
s$=LCase$(vs$)

If Len(s$)<4 Then Exit Function
For i=0 To 3:a(i)=Asc(Mid$(s$,i+1)):Next 'i
If (a(0)<Asc("a"))Or(a(0)>Asc("h"))Then Exit Function
If (a(1)<Asc("1"))Or(a(1)>Asc("8"))Then Exit Function
If (a(2)<Asc("a"))Or(a(2)>Asc("h"))Then Exit Function
If (a(3)<Asc("1"))Or(a(3)>Asc("8"))Then Exit Function
a(4)=Asc("q")
If Len(s$)>4 Then a(4)=Asc(Mid$(s$,5))

from=a(0)-Asc("a")
from=from+8*(8-(a(1)-Asc("0")))
too=a(2)-Asc("a")
too=too+8*(8-(a(3)-Asc("0")))

For i=0 To first_move(1)-1
If (Peek(var gen_dat(i,0),0)=from)And(Peek(var gen_dat(i,0),1)=too)Then
If (Peek(var gen_dat(i,0),3)And 32)<>0 Then
Select Case a(4)
Case Asc("n")
parse_move=i:Exit For
Case Asc("b")
parse_move=i+1:Exit For
Case Asc("r")
parse_move=i+2:Exit For
Case Else 'assume it's a queen
parse_move=i+3:Exit For
End Select
EndIf
parse_move=i:Exit For
EndIf
Next 'i
End Function

Function move_str$(m)
Local from=Peek(var m,0),too=Peek(var m,1)

move_str$=Chr$((from And 7)+Asc("a"))
move_str$=move_str$+Chr$(8-(from\8)+Asc("0"))
move_str$=move_str$+Chr$((too And 7)+Asc("a"))
move_str$=move_str$+Chr$(8-(too\8)+Asc("0"))

If (Peek(var m,3)And 32)<>0 Then
Select Case Peek(var m,2)
Case KNIGHT
move_str$=move_str$+"N"
Case BISHOP
move_str$=move_str$+"B"
Case ROOK
move_str$=move_str$+"R"
Case Else
move_str$=move_str$+"Q"
End Select
EndIf
End Function

'Sub print_board
'  Local i
'
'  oPrintR "" :oPrint "8 "
'  For i=0 To 63
'    Select Case hue(i)
'      Case EMPTY
'        oPrint " ."
'      Case LIGHT
'        oPrint " "+Mid$(piece_char$,piece(i)+1,1)
'      Case DARK
'        oPrint " "+Mid$(piece_char$,piece(i)+7,1)
'    End Select
'    If ((i+1)Mod 8=0)And(i<>63) Then oPrintR "" :oPrint Str$(7-(i\8))+" "
'  Next 'i
'  oPrintR "" :oPrintR "" :oPrintR "   a b c d e f g h":oPrintR ""
'End Sub

Sub print_result
Local i

For i=0 To first_move(1)-1
If makemove(gen_dat(i,0))<>0 Then takeback:Exit For
Next 'i
If i=first_move(1)) Then
If in_check(side)<>0 Then
If side=LIGHT Then
oPrintR "0-1 {Black mates}"
Else
oPrintR "1-0 {White mates}"
EndIf
Else
oPrintR "1/2-1/2 {Stalemate}"
EndIf
ElseIf reps()=2 Then
oPrintR "1/2-1/2 {Draw by repetition}"
ElseIf fifty>=100 Then
oPrintR "1/2-1/2 {Draw by fifty move rule}"
EndIf
End Sub

data_bench_color:
Data 6, 1, 1, 6, 6, 1, 1, 6
Data 1, 6, 6, 6, 6, 1, 1, 1
Data 6, 1, 6, 1, 1, 6, 1, 6
Data 6, 6, 6, 1, 6, 6, 0, 6
Data 6, 6, 1, 0, 6, 6, 6, 6
Data 6, 6, 0, 6, 6, 6, 0, 6
Data 0, 0, 0, 6, 6, 0, 0, 0
Data 0, 6, 0, 6, 0, 6, 0, 6

data_bench_piece:
Data 6, 3, 2, 6, 6, 3, 5, 6
Data 0, 6, 6, 6, 6, 0, 0, 0
Data 6, 0, 6, 4, 0, 6, 1, 6
Data 6, 6, 6, 1, 6, 6, 1, 6
Data 6, 6, 0, 0, 6, 6, 6, 6
Data 6, 6, 0, 6, 6, 6, 0, 6
Data 0, 0, 4, 6, 6, 0, 2, 0
Data 3, 6, 2, 6, 3, 6, 5, 6

Sub bench
Local i,t
Local float nps

close_book

Restore data_bench_color:For i=0 To 63:Read hue(i):Next 'i
Restore data_bench_piece:For i=0 To 63:Read piece(i):Next 'i

side=LIGHT
xside=DARK
castle=0
ep=-1
fifty=0
ply=0
hply=0
set_hash
draw_chessboard
'  print_board
max_time=6e5 '600 seconds
max_depth=3'5
think(1)
t=Timer-start_time
oPrintR "Time: "+Str$(t)+" ms"
oPrintR "" :oPrintR "Nodes: "+Str$(nodes)

If t=0 Then
oPrintR "(invalid)"
Else
nps=nodes
nps=nps*1000.0/t
' Score: 1.000 = my Athlon XP 2000+
oPrint "Nodes per second: "+Str$(Int(nps+0.5))
oPrintR " (Score: "+Str$(nps/243169.0,0,6)+")"
EndIf

init_board
max_time=4e5'400sec'2^24
max_depth=5
open_book
gen
End Sub

' SEARCH
Sub think(output)
Local i,j,x

pv(0,0)=book_move():If pv(0,0)<>-1 Then Exit Sub

stop_search=0
start_time=Timer
stop_time=start_time+max_time

ply=0
nodes=0
For i=0 To MAX_PLY
For j=0 To MAX_PLY
pv(i,j)=0
Next 'j
Next 'i
For i=0 To 63
For j=0 To 63
history(i,j)=0
Next 'j
Next 'i

If output=1 Then oPrintR "  pv   ply    nodes   score"
For i=1 To max_depth
follow_pv=1
x=search(-10000,10000,i)
If stop_search<>0 Then Exit For
If output=1 Then
oPrint "       "+Str$(i, 3)+Str$(nodes, 9)+Str$(x, 8)+" "
For j=0 To pv_length(0)-1
'        If j>0 And j Mod 3=0 Then oPrintR ""
oPrint move_str$(pv(0,j))
Next 'j
oPrintR ""
EndIf
If x>9000 Or x<-9000 Then i=max_depth
Next 'i
If stop_search<>0 Then
Do
If ply=0 Then Exit
takeback()
Loop
EndIf
End Sub

Function search(a,b,d)
Local alpha=a,beta=b,depth=d
Local i,j,x,c,f,from,too,exitF=0

search=alpha
If stop_search<>0 Then Exit Function

If depth=0 Then search=quiesce(alpha,beta):Exit Function
Inc nodes,1

If (nodes And 127)=0 Then
If Timer>stop_time Then stop_search=1
EndIf
If stop_search<>0 Then Exit Function

pv_length(ply)=ply

If (ply<>0) Then
If reps()<>0 Then search=0:Exit Function
EndIf

If (ply>=MAX_PLY)Or(hply>=HIST_STACK) Then
search=eval_():Exit Function
EndIf

c=in_check(side):If c<>0 Then Inc depth,1

gen()
If follow_pv<>0 Then sort_pv()

f=0

For i=first_move(ply) To first_move(ply+1)-1
tscpSort(i)
If makemove(gen_dat(i,0))<>0 Then
f=1
x=-search(-beta,-alpha,depth-1)
If stop_search<>0 Then Exit For
takeback()
If x>alpha Then
from=Peek(var gen_dat(i,0),0)
too=Peek(var gen_dat(i,0),1)
history(from,too)=history(from,too)+depth
If x>=beta Then search=beta:exitF=1:Exit For
alpha=x

pv(ply,ply)=gen_dat(i,0)
For j=ply+1 To pv_length(ply+1)-1
pv(ply,j)= pv(ply+1,j)
Next 'j
pv_length(ply)=pv_length(ply+1)
EndIf
EndIf
Next i
If (stop_search<>0)Or(exitF<>0) Then Exit Function

If f=0 Then
search=0
If c<>0 Then search=ply-10000
Exit Function
EndIf

If fifty>=100 Then search=0:Exit Function

search=alpha
End Function

Function quiesce(a,b)
Local alpha=a,beta=b
Local i,j,x,exitF=0

quiesce=alpha
If stop_search<>0 Then Exit Function

Inc nodes,1

If (nodes And 127)=0 Then
If Timer>stop_time Then stop_search=1:Exit Function
EndIf

pv_length(ply)=ply

If (ply>=MAX_PLY)Or(hply>=HIST_STACK) Then
quiesce=eval_():Exit Function
EndIf

x=eval_():If x>=beta Then quiesce=beta:Exit Function

If x>alpha Then alpha=x

gen_caps()
If follow_pv<>0 Then sort_pv()

For i=first_move(ply) To first_move(ply+1)-1
tscpSort(i)
If makemove(gen_dat(i,0))<>0 Then
x=-quiesce(-beta,-alpha)
If stop_search<>0 Then Exit For
takeback()
If x>alpha Then
If x>=beta Then quiesce=beta:exitF=1:Exit For
alpha=x

pv(ply,ply)=gen_dat(i,0)
For j=ply+1 To pv_length(ply+1)-1
pv(ply,j)=pv(ply+1,j)
Next 'j
pv_length(ply)=pv_length(ply+1)
EndIf
EndIf
Next i
If (stop_search<>0)Or(exitF<>0) Then Exit Function
quiesce=alpha
End Function

Function reps()
Local i

reps=0
For i=hply-fifty To hply-1
If hist_dat(i,5)=hash Then reps=reps+1
Next 'i
End Function

Sub sort_pv
Local i

follow_pv=0
For i=first_move(ply) To first_move(ply+1)-1
If gen_dat(i,0)=pv(0,ply) Then
follow_pv=1
gen_dat(i,1)=gen_dat(i,1)+1e7
i=first_move(ply+1)-1
EndIf
Next 'i
End Sub

Sub tscpSort(from)
Local g(1)
Local i,bs,bi

bs=-1
bi=from
For i=from To first_move(ply+1)-1
If gen_dat(i,1)>bs Then bs=gen_dat(i,1):bi=i
Next 'i
g(0)=gen_dat(from,0):g(1)=gen_dat(from,1)
gen_dat(from,0)=gen_dat(bi,0):gen_dat(from,1)=gen_dat(bi,1)
gen_dat(bi,0)=g(0):gen_dat(bi,1)=g(1)
End Sub

init_arrays 'initialize those arrays that are too big for a one-line statement
load_sprites
main 'start tscp's main loop
