'RMS logger V0.12

'+-------------------------------------------------------------------+
'|                                                                   |
'|                        mains voltage monitor                      |
'|                                                                   |
'|                                                                   |
'| Version 0.12            24-09-2022        Volhout@thebackshed.com |
'+-------------------------------------------------------------------+
' using background logging from ADC pingpong-ing in arrays a() and b()
' pre-processing in interrupt routine to offload main from time critical
' functions.
' main handles display functions and file handling

' Version control
' 0.01    Initial version with RMS running in main
' 0.02    Version with RMS and PEAK in interrupt
' 0.03    Trend buffers, PEAK removed, math(sd a()) for RMS, ignore offset
' 0.04    Trend graph drawn and peak indicator shown
' 0.05    Show actual RMS value in top left screen
' 0.06    Show date$/time$, plot waveform
' 0.07    Add FFT screen
' 0.08    remove many variables, hard coded values
' 0.09    make trend graph a rolling graph
' 0.10    adapted cal value 230V, remove duplicates from list,2 wave periods
' 0.11    trend graph 5 hours
' 0.12    remove fft, add low event list

' to do
' calculate distortion
' write logs to SD
' write events to SD

'---------------- definitions -------------------

'init time
  get_time                     'not needed with OPTION RTC AUTO ENABLE


'hardware parameters------------------------------------------
'
scale = 265.2'322.8           'transformer gain (tune)
'
'tune this value with your hardware---------------------------


'sampling core values
fm=50                   'intende mains frequency
n=512                   'samples multiple of 2 for fft
freq = 2000             'sampling frequency target = 40 samples per period
calcfreq=fm             'start value for frequency calculation

'adjust the sampling frequency so the sampling more or less
'lines up with the mains frequency to avoid resampling math
'this is not super accurate, but gets the accuracy within 0.5%
freq = freq*n/(n\fm*fm) 'corrected sampling freq to sync 50Hz
Print "sampling frequency set to :";freq;" Hz"

'trend buffer
'there are 2 buffers, 1 with actual data, one with display coordinates
m=Int(60*(freq/n))      'size collect samples for 60 seconds
'Print "trend buffer :";m
'm=4                     'dummy, for sampling every second
t=MM.HRes-2             'size trend plot data buffers


'display definitions

'generic and background color
bgcolor = RGB(black)
framecolor = RGB(white)

'trend graph
rmsColor=RGB(green)     'line color
rmsmin=210              'graph window limits in voltage
rmsmax=250
trendpeak=RGB(red)      'colors for peak
trendvaley=RGB(cyan)    'and valey
trp=1                   'trend display pointer pointer

'current value
curColor=RGB(white)     'text color

'event list
evColor=RGB(green)       'text color normal
evColorAlarm=RGB(red)   'text color alarm
evHeader=RGB(white)    'header text color
AlarmLevel=230*1.05     'when to change color (230+5%)
DeepLevel=230*0.95      'when to change color low voltage

'wave graph
wavColor=RGB(green)      'line color
wavHeader=wavColor       'header / valuecolor
wp=1                     'wave pointer

'fft graph
fftColor=RGB(green)      'line color
avg%=0                   'running average for mains frequency
measfreq=0               'frequency measured on GP8 from zero crossing detector


'memory
Option base 1
Dim a(n),b(n)              'sample ping pong buffers
Dim c(n),d(n)              'sample processing buffer
'Dim pk(m),rm(m)           'buffers for peak and rms values for 1 minute
Dim rmt(t),rmd(t)          'buffers for trend capture and trend display
tp=1                       'trend index pointer
ap=0                       'trend averaging pointer
Dim rmp(5)=(0,0,0,0,0)     'array with 5 peak values for list
Dim rml(5)=(230,230,230,230,230)     'array with 5 low values for list
Dim rmh$(5),rmhl$(5)       'string array with associated time/date
Dim rmdummy(5),rmindex%(5) 'help arrays for sorting

'open the ADC and start first conversion, from here on the ADC is
'restarted in the interrupt routine.
adcRange=3.3
ADC open freq,1,INT_RDY
ready=0:pingpong=1
ADC start a()

'connect zero crossing detector to GP6
SetPin gp8,fin              'use build in frequency measurment
Pause 1000                  'skip 1 measurement period
dummy=Pin(gp8)              'make sure there is a value

'main routine
CLS
Print "start"
Do
  drawCurrent
  drawTrend
  drawList
  drawLowList 'drawFFT
  drawWave
  Pause 1000
Loop
End

Sub drawCurrent
'draw the outline
Box 1,1,158,78,1,framecolor
'write current value
Text 6,6,Left$(Str$(rms),5),"L",4,3,curColor
Text 79,48,"Vrms","C",1,2,curColor
End Sub

Sub drawList
'draw the outline
Box 1,80,158,78,1,framecolor
Text 6,84," Max V     WHEN","L",1,1,evHeader

Math add rmp(),0,rmdummy()    'make a local copy
Sort rmdummy(),rmindex%()      'mak a index list highest on top

For i=1 To 5
  j=rmindex%(i)
  If rmp(j)>AlarmLevel Then
    colr=evColorAlarm
  Else
    colr=evColor
  EndIf
  If rmh$(j)<>"" Then
    Text 6,156-(12*i),Left$(Str$(rmp(j)),6),"L",1,1,colr
    Text 66,156-(12*i),rmh$(j),"L",1,1,colr
  EndIf
Next i
End Sub

Sub drawLowList
'draw the outline
Box 161,80,158,78,1,framecolor
Text 166,84," Min V     WHEN","L",1,1,evHeader

Math add rml(),0,rmdummy()    'make a local copy
Sort rmdummy(),rmindex%(),1   'mak a index list lowest on top

For i=1 To 5
j=rmindex%(i)
If rml(j)<DeepLevel Then
colr=evColorAlarm
Else
colr=evColor
EndIf
If rmhl$(j)<>"" Then
Text 166,156-(12*i),Left$(Str$(rml(j)),6),"L",1,1,colr
Text 226,156-(12*i),rmhl$(j),"L",1,1,colr
EndIf
Next i
End Sub

Sub drawWave
'convert the analog data to display data
gain=-60/adcRange   'ADC values between 0 and 3.3V plot over 60 pixels
Math scale c(),gain,d() 'use d() to double buffer c()
Math add d(),76,d()

'find first zero crossing index wp (vWSize/2) typically wp < 40
'with f=50Hz and 2kHz sampling. The graphs will display phase aligned.
wp=0:th=76/2
Do
wp=wp+1
If wp > 50 Then wp=1:Exit
Loop Until ((d(wp) > th) And (d(wp+1) < th))

'and plot the graph roughly 2 periodes
For i=1 To 156/2 '156
'erase previous pixel by eraing a whole vertical line
Line 2*i+160,12,2*i+160,76,1,bgcolor
Line 2*i+161,12,2*i+161,76,1,bgcolor
'Line i+161,2,i+161,76,1,rgb(BLACK)
'plot the new pixel/line
Line 2*i+160,d(i+wp-1),2*i+162,d(i+wp),1,wavColor
'Line i+160,d(i+wp-1),i+161,d(i+wp),1,wavColor
Next i

'alternative frequency indication through gp8
measfreq=(Pin(gp8)+avg%*measfreq)/(avg%+1)
avg%=Min(avg%+1,15) 'max 15 averages
Text 163,3,Left$(Str$(measfreq),4)+" Hz","L",1,1,wavHeader

Box 161,1,158,78,1,framecolor
End Sub

Sub drawFFT
'draw the outline
Box 161,80,158,78,1,framecolor
'  Text 3*curHSz/2,3*curVSz/2,"FFT","C",1,1,RGB(cyan)
Math add c(),-adcRange/2,c()  'remove offset before fft
Math fft magnitude c(),d()    'do fft

'scale the graph to fit the window
fftMax=n*adcRange/8       'not sure why this is /8
gain=-58/fftMax           'pure sine has all n samples in 1 peak
Math scale d(),gain,d()   'use d() to double buffer c()
Math add d(),154,d()

'now plot the first n/2 samples or as much as fit the graph size
fftRange = Min(n/2,158)-3
For i=1 To fftRange
'erase previous pixel by eraing a whole line
Line i+162,94,i+162,155,1,bgcolor
'plot the new pixel
Line i+161,d(i),i+162,d(i+1),1,fftColor
Next i

'find the highest peak (since d() contains plot values (screen origin is top
'so data is inverted) >= find min.
'dummy = Math(min d(),p%)    'find what sample represents the peak to align tex
t
'If p% < n/2 And p% > 1 Then  'not calc error or offset
'  calcfreq=(127*calcfreq+(p%-1)/n*freq)/128
'  'Print "freq ";calcfreq;" Hz"
'EndIf
'Text 163+p%,83,Left$(Str$(calcfreq),4)+" Hz","L",1,1,fftColor

'alternative frequency indication through gp8
measfreq=(Pin(gp8)+avg%*measfreq)/(avg%+1)
avg%=Min(avg%+1,15) 'max 15 averages
Text 163,83,Left$(Str$(measfreq),4)+" Hz","L",1,1,fftColor

End Sub

'interrupt routine gets data from ADC and does pre-processing
'interrups happen every n/freq seconds
Sub INT_RDY
'Timer =0

'restart adc with new buffer
If pingpong Then
'start filling b() and process a()
ADC start b()
rms = Math(SD a())
'Math add b(),0,c()  'make a copy for wave and fft
Else
'start filling a() and process b()
ADC start a()
rms = Math(SD b())
Math add b(),0,c()  'make a copy for wave and fft
EndIf
pingpong=1-pingpong

'calculate rms
rms = scale * rms

'proces values in trend sample timeframe
rms_high = Max(rms, rms_high)     'peak values are individually counted
rms_av = rms_av + rms             'average is used fro trend and low values
ap=ap+1
If ap=m Then
'fill circular buffer
rms_av = rms_av / m
rmt(tp) = rms_av      'fill the trendgraph with average voltages
'rmt(tp)=rms_high
tp=(tp Mod t)+1
ap=0
rms_high = rms          'reset to trend value

'check rms_av value against low event list, only when average is calcualted
If rms_av < Math(MIN rml()) Then
'check if it is a milivolt duplicate
Local isnew=1
For i=1 To 5
If rmhl$(i)=Left$(Time$,5)+" "+Left$(Date$,5) Then
rml(i)=rms_av             'do not add a new entry, but update value old
isnew=0
EndIf
Next i
If isnew Then
dummy=Math(mAX rml(),p%)  'remove the lowest in the list
rml(p%)=rms_av
rmhl$(p%)=Left$(Time$,5)+" "+Left$(Date$,5)
EndIf
'    Math v_print rmp()
EndIf
rms_av = 0
EndIf

'check rms value against event list to detect every single peak
If rms_high > Math(max rmp()) Then
'check if it is a milivolt duplicate
isnew=1
For i=1 To 5
If rmh$(i)=Left$(Time$,5)+" "+Left$(Date$,5) Then
rmp(i)=rms_high             'do not add a new entry, but update value old
isnew=0
EndIf
Next i
If isnew Then
dummy=Math(min rmp(),p%)      'remove the lowest in the list
rmp(p%)=rms_high
rmh$(p%)=Left$(Time$,5)+" "+Left$(Date$,5)
EndIf
'    Math v_print rmp()
EndIf

'Print Timer
'ready=1
End Sub


' Draw the trend graph at the lower half of the screen
' scale the trend buffer to the window defined
Sub drawTrend

'convert the rmt data to display data (rmd)
gain=76/(rmsmin-rmsmax)
Math add rmt(),-rmsmax,rmd()  'rmd is also a double buffer
Math scale rmd(),gain,rmd()
Math add rmd(),161,rmd()      'put the data in the window

'find the peaks in this data array
pk = Math(max rmt(),pp%)
mn = Math(min rmt(),pv%)

'and plot the graph starting from tp (the last data entered)
trp = tp
For i=2 To t
'erase previous pixel by erasing a whole vertical line
Line i,162,i,238,1,bgcolor
'plot the new pixel
Line i-1,rmd(trp),i,rmd((trp Mod t)+1),1,rmsColor
trp=(trp Mod t)+1
'map indicators to rolling trend
Next i

'map indicatorss to rolling graph
pp%=((t+pp%-tp) Mod t)+1
pv%=((t+pv%-tp) Mod t)+1

'plot the peak in the graph
Line pp%,163,pp%,238,1,trendpeak
Line pv%,163,pv%,238,1,trendvaley
'write the value in place position depending location peak
If pp% < 160 Then
Text pp%+2,163,Left$(Str$(pk),5)+" V","L",1,1,trendpeak
Else
Text pp%-2,163,Left$(Str$(pk),5)+" V","R",1,1,trendpeak
EndIf
If pv% < 160 Then
Text pv%+2,227,Left$(Str$(mn),5)+" V","L",1,1,trendvaley
Else
Text pv%-2,227,Left$(Str$(mn),5)+" V","R",1,1,trendvaley
EndIf

'draw box
Box 1,161,319,118,1,framecolor
End Sub

Sub get_time
'debug not needed with OPTION RTC AUTO ENABLE
Time$="10:10:10"
Date$="20-10-2010"
Exit Sub

'for manual entry
Local string dummy$
Input "Set time HH:MM:SS ";dummy$
Time$ = dummy$
Input "Set date DD-MM-YYYY ";dummy$
Date$ = dummy$
End Sub

