'snake

'play snake game using cursor keys. Avoid scrub and yourself
'eat all fruit to grow.

'version
' s1 = basic ASCII text snake
' s2 = using sprites for snake
' s3 = adding fruit and tone
' s4/s4_1 = 8 sprites
' s5/s5_1 = dynamic game experience, music
' s6/s6_1 = highscore + compressed music
' s7 = add sprites to bas file

'todo
' - dead tune
' - intro text
' - compress to 5k

MODE 2

'enter initials
z=255:Dim s(z,1),n$(9):VAR restore
Input "Enter name : ";n$(0)

SetTick 120,music

's(x,y)=head coord, (v,w)=head motion, tail erase unless food
'h=head poiter, t=tail pointer, l=length snake = level
'z=max length snake, p=pixel ahead, n$()=highscore list
'c=food delay, (i,j)=food coordiates, u=field color dark green
'd=tick counter music, e=music pointer, m$=music, f=tone
'a$=input, b=key
h=0:t=0:l=2:d=0:b=131:x=120:y=x:s(h,0)=x:s(h,1)=y:c=79:e=1:u=16384

'compressed sound score calculate from below
m$="QQE\STSE\Q\SOC\X\SC\\\QMA\STSA\Q\QL@\P\Q@\S\QQE\STSE\Q\SOC\X\SC\\\TMA\VXVA\T\VO@\[\XC\\\"

'create and load 8 sprites
open "8.spr" for output as #1
  print #1,"8,8,8"
  for i=1 to 64
    read a$:print #1,a$
  next
close #1
Sprite load "8.spr",1

'playfield
CLS u
For i=0 To 39                       'bushes around field
  For j=0 To 30
    Sprite write 8,8*i,8*j
Next :Next
Box 8,8,304,224,1,u,u               'dark green ground


Do
  If b>127 Then                     'calculate movement when b<>0
    v=(b=131)-(b=130)               'change only at key press
    w=(b=129)-(b=128)               'else keep moving same
  EndIf
  a$=Inkey$:b=Asc(a$)               'detect arrow keys

  x=x+8*v:y=y+8*w                   'new x,y no protection relies on fence
  p=Pixel(x+4,y+4)                  'look ahead what is coming
  Text 0,0,Str$(l)                  'show level = length

  If p=u Then                       'when background then empty
    Sprite write 1,s(h,0),s(h,1)    'write body shape over old head
    h=(h+1) And z:s(h,0)=x:s(h,1)=y 'new head pointer and store x,y
    t=(h-l) And z                   'new tail pointer
    Sprite write 2+(v=0),x,y,4+(v=1)+2*(w=1)
    Box s(t,0),s(t,1),8,8,1,u,u     'erase tail
  ElseIf p=65280 Or p=RGB(brown) Then  'if wall or body then die
    SetTick 0,0:Play stop
    Text 160,100,"HIGHSCORE",C,,,,u
    score
    Text 160,60,"You died, <CR> or 'q' to quit",C,,,,u
    Input a$:If a$="" Then Run Else End
  Else                              'is food
    Box x,y,8,8,1,u,u               'erase food eaten
    l=Min(l+4,z):c=79
  EndIf

  Inc c,1                           'new food after 80 moves
  If c=80 Then
    Do                              'find free location
      i=8*Int(1+Rnd()*38):j=8*Int(1+Rnd()*28)
    Loop Until Pixel(i+4,j+4)=u
    c=0:Sprite write 4+(l>50)+Int(Rnd()*4),i,j    'OK and plot
  EndIf

  Pause Max(180-l,80)               'dynamic speed
Loop

'music for test
Sub music
  gn
  If f<700 And l>50 Then Play sound 1,B,Q,f,l/16

  If (d And 3)=0 Then
    gn :Play sound 2,B,Q,f,l/16
  EndIf

  If d=0 Or d=8 Then
    gn :Play sound 3,B,S,f
  EndIf

  d=(d+1) And 15
  If e>Len(m$) Then e=1
End Sub

Sub gn
 f=110*2^((Asc(Mid$(m$,e,1))-59)/12)  'calc freq
 e=e+1                                'next note
End Sub

'manages the highscore list, uses n$(0) for new entry, show n$(1..9)
Sub score
  n$(0)=Right$("00"+Str$(l),3)+"  "+n$(0)  'combine level and name
  Sort n$():VAR save n$()            'sort and save
  For i=1 To 9
    Text 133,200-i*9,n$(i),,,,,u     'show list
  Next i
End Sub

DATA 00EEEE00,0EECCEE0,EEECCEEE,ECCECCCE,ECCCECCE,EEECCEEE,0EECCEE0,00EEEE00
DATA 00EEEEE0,0E77CCEE,47177CCE,4477CCCC,4477CCCC,47177CCE,0E77CCEE,00EEEEE0
DATA 00444400,0E7447E0,E717717E,E777777E,EC7CC7CE,ECCCCCCE,EECCCCEE,0EECCEE0
DATA 00009900,00229000,02AAA220,2AAA2AA2,2AAAAAA2,2AAAAAA2,02AAAA20,0028A200
DATA 000000E0,000000E0,00000666,00006666,00066E60,00666600,E66E6000,06600000
DATA 00009000,00009000,04444440,44444444,44444444,44444444,04444440,00444400
DATA 00EEEE00,0ECCCCE0,EC7CCCCC,ECCCCCCC,ECCCCCCC,ECCCCCCC,0ECCCCC0,00CCCC00
DATA A002020A,0A020A02,020A0202,00202002,202A2020,0A02A020,0022A200,000AAA00
