  'flappy bird for picomiteVGA
  
  'setup memory and screen
  Option DEFAULT integer
  MODE 2
  FRAMEBUFFER layer 9 'mageta = transparent
  
  'load sprites
  Sprite load "tt.spr",1
  Sprite load "bs.spr",2
  Sprite load "ts.spr",3
  sprite load "flap1.spr",4
  sprite load "flap2.spr",5
  sprite load "flapd2.spr",6
  sprite load "nul.spr",7
  sprite load "one.spr",8
  sprite load "two.spr",9
  sprite load "three.spr",10
  sprite load "four.spr",11
  sprite load "five.spr",12
  sprite load "six.spr",13
  sprite load "seven.spr",14
  sprite load "eight.spr",15
  sprite load "nine.spr",16
  sprite load "flap3.spr",17
    
  'load background
  FRAMEBUFFER write n
  Load image "fl_day.bmp"
  
  'game defines
  h_beat=50     'speed of the game
  gap=90        'between columns
  xb=100        'bird start position (constant)
  yb=100        'bird vertical position
  v=1           'falling speed due to gravity
  xnp=320       'new pipe position
  ynp=40        'new pipe length (default)
  pgap=80       'gap between top and bottom pites
  spr=4         'default bird sprite
  dim yy(1)     'pipe height last 2 pipes
  pn=1          'pipe number
  
  'title screen
  framebuffer write l:cls
  load image "flappy.bmp",70,50
  pause 3000
  
  'create background
  cls
  load image "getready.bmp",70,40
  load image "taptap.bmp",136,100
  do : loop while read_input$()=""
  cls 
  
  'init for main game loop
  timer=0
  play modfile "sll3.mod"
  FRAMEBUFFER write l
  
  'main game loop
  Do
    'player input through keyboard, clearing buffer, check loop time
    k$="":Text 0,0,Right$("00"+Str$(timer,3,0),3)
    Do
      tmp$=read_input$()
      If tmp$<>"" Then k$=tmp$  'keep last valid key
    Loop Until Timer>h_beat
    Timer=0
    
    
    'new bird position
    v=v+1                       'falling speed increases
    if v>-2 then spr=4          'flaps up
    if v>5 then spr=17:v=5      'to a max of 5
    if k$=" " then spr=5:v=-8   '-7 'flaps down and you rise
    if yb+v<0 or yb+v>228 then you_die
    
    'new pipes
    inc xnp,-1
    if xnp=(320-gap) then 'we need a new post
      xnp=320                           'wrap around
      inc pn,1                          'new pipe
      yy(0)=yy(1):yy(1)=ynp+8           'memory of pipe lenght
      ynp=8*int(15*rnd())               'new pipe length defined
      framebuffer write n:sprite scroll -1,0:framebuffer write l'scroll background
    end if
    
    'check collision with pipe
    xx=xnp-2*gap
    if xx>76 and xx<=116 and pn>2 then
      'if yb<yy(0)+12 or yb>yy(0)+pgap then you_die
      if yb+v<yy(0)+12 or yb+v>yy(0)+pgap then you_die
    end if
    
    'number the pipe
    if xnp=254 then
      box xnp+5,2,16,16,1,0,rgb(red)
      if pn<10 then
        sprite write pn+7,264,5
      else
        sprite write (pn\10)+7,262,5
        sprite write (pn mod 10)+7,267,5
      end if
    end if
    
    'update graphics
    framebuffer wait
    
    'move screen
    line 0,0,0,239,,rgb(magenta)  'erase old column line for line
    Sprite scroll -1,0            'scroll forground layer 1 to left
    
    'kill old bird
    box xb-1,yb,16,12,1,rgb(magenta),rgb(magenta)
    
    'new bird position
    yb=yb+v
    
    'write new bird
    sprite write spr,xb,yb,0
    
    'write new pipe
    if xnp>295 then write_pipe(xnp,ynp)
    
  Loop
  
  'keyboard or controller input
function read_input$()
  read_input$=inkey$
end function
  
  'create a pipe at xnp from top to ynp, and antagonist
sub write_pipe(x,n)
  local i,j
  for i=0 to n step 8
    sprite write 1,x,i,0
  next
  j=i
  sprite write 3,x,j,0
  sprite write 2,x,j+pgap,0
  for i=j+12+pgap to 232 step 8
    sprite write 1,x,i,0
  next
  sprite write 1,x,232,0
end sub
  
sub you_die
  'kill old bird
  box xb,yb,16,12,1,rgb(magenta),rgb(magenta)
  animate_fall
  load image "gameover.bmp",70,50
  pause 3000
  
  'cls rgb(magenta)
  'load image "scoreboard.bmp"
  'text 160,120,"YOU DIE",cm,1,4,0,rgb(magenta)
  'pause 2000
end
end sub
  
sub animate_fall
  v=1
  do
    yb=yb+v
    sprite show 6,xb,yb,l,4
    pause 50
    v=min(v+1,8)
  loop until yb>216
end sub
  
  
  
  
  
  
