  'flappy bird for picomiteVGA, experimental 2 pixel scroll
  
  'versions
  ' flappy7   first release
  ' flappy8   fixed collision bug, screen corruption in fall
  ' flappy9   fl_day2 background and pipe/animation adaptions
  ' flappy10  sfx added, end game added, fl_day6 background, store scores
  ' flappy11  uses graphics in flash slot in preparation of LCD
  ' flappy11_game_mite  version for Game*Mite
  ' flappy12  VGA version with night mode, better reward
  ' flappy13  Game*Mite version with GFX in BAS file.
 
  
  path$="B:/flappy13/"
 
  
  'setup memory and screen
  Option DEFAULT integer
  FRAMEBUFFER layer 9 'foreground layer, mageta = transparent
  FRAMEBUFFER create  'background layer for LCD blit
  
  If MM.Info(platform)="Game*Mite" Then init_gpio

  
  'load graphics element index and prepare flash data
  st_addr=Peek(cfunaddr FLAPPY)  'memory address of CSUB
  'adapt index file to start adresses
  dim indx(26):for i=0 to 25:read a$:indx(i)=val(a$)+st_addr:next
  
  
  'load background on to layer N
  FRAMEBUFFER write F
  if rnd()<0.5 then
    Load image path$+"fl_day.bmp"
  else
    Load image path$+"fl_night.bmp"
  end if
  
  
  'game variables
  h_beat=100    'speed of the game
  force=8       'force of the wing

  
  'game defines
  gap=90        'between columns
  xb=100        'bird start position (constant)
  yb=100        'bird vertical position
  v=2           'falling speed due to gravity
  xnp=320       'new pipe position
  ynp=40        'new pipe length (default)
  pgap=80       'gap between top and bottom pites
  spr=4         'default bird sprite
  Dim yy(1)     'pipe height last 2 pipes
  pn=1          'pipe number to be shifted in right side
  die=16:hit=17:swoosh=18:wing=19   'sfx samples
  Dim scores(3)=(5,10,15,16) 'default highscore list

  
  'game*mite buttons
  anykey  = &b11001111  'all player buttons except select and start
  selectkey=&b00010000  'the select key
  startkey= &b00100000  'the start key
  
  
  'get old scores from flash
  Open path$+"score.txt" For input As #1
  For i=0 To 3:Input #1,a$:scores(i)=Val(a$):Next
  Close #1
  
  
  'title screen
  FRAMEBUFFER write L:CLS RGB(magenta)
  Blit memory indx(17),70,50 'title
  FRAMEBUFFER merge 9,b
  Pause 3000
  
  
  'create start instructions
  CLS RGB(magenta)
  Blit memory indx(18),70,40 'get ready
  Blit memory indx(19),130,110 'tap tap
  FRAMEBUFFER merge 9,b
  Do : Loop While read_input$()=""
  CLS RGB(magenta)
  
  
  'init for main game loop
  Pause 500
  Play modfile path$+"sll3sfx2.mod"
  Pause 500:Timer =0
  
  
  'main game loop
  
  'to distribute the CPU load, the actions are sequenced depending the xnp number
  '320...296: draw a new pipe (pn) at right side
  '294...254: check bird collisions with pipe (pn-2)
  '254      : write number to pipe pn
  '252      : check progressive game speed
  '250...232: nothing happens here yet
  '230      : change xpn back to 320.
  
  Do
    'debug loop time
    'Text 0,0,Right$("00"+Str$(Timer,3,0),3)
    
    'player input through keyboard, clearing buffer, check loop time
    k$=""
    Do
      tmp$=read_input$()
      If tmp$<>"" Then k$=tmp$  'keep last valid key
      Pause 10
    Loop Until Timer>h_beat
    Timer =0
    
    
    'determine new bird position and sprite depending player key entry
    if v=8 then play modsample swoosh,4 'speed dive sound
    Inc v,2                       'falling speed increases
    If v>-2 Then spr=4            'flaps up
    If v>10 Then spr=17:v=10      'to a max of 10
    If k$=" " Then Play modsample wing,4:spr=5:v=-force  'flap and you rise
    If yb+v<0 Or yb+v>196 Then
      If pn<3 Then pn=2
      you_die
    EndIf
    
    
    'add a new pipe at the right side of the screen
    Inc xnp,-2
    If xnp=(320-gap) Then 'we need a new post
      xnp=320                           'wrap around
      Inc pn,1                          'new pipe
      yy(0)=yy(1):yy(1)=ynp+8           'memory of pipe lenght
      ynp=8*Int(14*Rnd())               'new pipe length defined
    EndIf
    
    
    'check collision with pipe (pn-2) that is closest to the bird
    xx=xnp-2*gap
    If xx>76 And xx<=116 And pn>2 Then
      If yb+v<yy(0)+12 Or yb+v>yy(0)+pgap-12 Then you_die
    EndIf
    
    
    'number the new pipe
    If xnp=254 Then
      Box xnp+5,2,16,16,1,0,RGB(red)
      writenumber(xnp+8,5,pn)
    EndIf
    
    
    'progressive difficulty
    if xnp=252 then
      if pn>10 then force=10                 'more vertical speed
      if pn>20 then h_beat=max(149-2*pn,60)  'faster forward
    end if
    
    
    'move screen
    Blit 2,0,0,0,319,208
    Line 318,0,318,239,2,RGB(magenta)  'erase old column line for line
    
    'update bird
    Box xb-2,yb,16,12,1,RGB(magenta),RGB(magenta) 'kill old bird
    yb=yb+v                                       'new bird position
    Blit memory indx(spr-1),xb,yb                 'write new bird
    
    'write new pipe, when 320>xpn>295
    If xnp>295 Then write_pipe(xnp,ynp)
    
    FRAMEBUFFER merge 9,b
    
  Loop
  
  
  'keyboard or controller input, can be expanded for controllers
Function read_input$()
  read_input$=""
  a$=Inkey$
  If a$=" " or a$="x" Then
    read_input$=a$
  Else
    If MM.Info(platform)="Game*Mite" Then
      If (key_in() and anykey)<> anykey Then read_input$=" ":butn_hld=0
      If (key_in() and selectkey)<> selectkey Then read_input$="x":butn_hld=0
      Inc butn_hld
    EndIf
  EndIf
End Function

  
  'write a number n to screen at position x,y
Sub writenumber(x,y,n)
  If n<10 Then
    Blit memory indx(n+6),x+2,y,0    'single digit
  Else
    Blit memory indx(n\10+6),x,y,0    'first digit
    Blit memory indx((n Mod 10)+6),x+5,y,0 'second digit
  EndIf
End Sub
  
  
  'create a pipe at xnp from top to ynp, and the antagonist
Sub write_pipe(x,n)
  Local i,j
  For i=0 To n Step 8
    Blit memory indx(0),x,i 'top pipe
  Next
  j=i
  Blit memory indx(2),x,j 'top fitting
  For i=j+12+pgap To 200 Step 8
    Blit memory indx(0),x,i 'bottom pipe
  Next
  Blit memory indx(0),x,201 'last part bottom pipe
  Blit memory indx(1),x,j+pgap 'bottom fitting
End Sub
  
  
  'end of game sequence
Sub you_die
  Box xb,yb,16,12,1,RGB(magenta),RGB(magenta) '  'kill old bird (non-smart)
  
  Play modsample hit,4
  animate_fall
  Play modsample die,4
  Pause 1000 'for freeing SD card SPI bus
  
  i=rangescores(pn-2)
  
  Blit memory indx(20),70,30 'gameover
  Blit memory indx(21),80,90 'scoreboard
  writenumber(80+129,90+27,pn-2)
  writenumber(80+129,90+60,scores(3))
  if i>=0 then blit memory indx(22+i),100,120  'the medal/cup sprite
  text 40,220,"SELECT = QUIT , other = continue"
  FRAMEBUFFER merge 9,b
  
  Pause 1000
  Do : a$=read_input$():Loop While a$=""
  if a$=" " then Run
  if a$="x" then run "A:/GameMite/menu.bas"
End Sub
  
  
  'drop the bird from collision point to the ground
Sub animate_fall
  Blit framebuffer L,F,0,0,0,0,320,240,9  'copy L to F to avoid corruption
  CLS RGB(magenta)                        'clear L
  v=1
  Do
    Box xb,yb,12,16,1,RGB(magenta),RGB(magenta)   'kill old bird
    yb=yb+v
    Blit memory indx(5),xb,yb 'dropping bird
    Pause 50
    FRAMEBUFFER merge 9,b
    v=Min(v+1,8)
  Loop Until yb>196
End Sub
  
  
  'gives medals at first 3 fixed levels in score file, highscore is adaptive (cup)
Function rangescores(n)
  rangescores=-1
  local i
  For i=0 To 3
    If scores(i)<n Then rangescores=i
  Next
  if rangescores=3 then scores(3)=n:savescore 'save new high, keep medals same.
End Function
  
  
  'write the new score list to flash
Sub savescore
  'save new scores
  local i
  Open path$+"score.txt" For output As #1
  For i=1 To 3:Print #1,Str$(scores(i)):Next
  Close #1
End Sub
  
  
  'set IO pin direction
Sub init_gpio
  SetPin gp8,din,pullup 'DOWN key
  SetPin gp9,din,pullup 'LEFT key
  SetPin gp10,din,pullup 'UP key
  SetPin gp11,din,pullup 'RIGHT key
  SetPin gp12,din,pullup 'SELECT key
  SetPin gp13,din,pullup 'START key
  SetPin gp14,din,pullup 'B key
  SetPin gp15,din,pullup 'A key
End Sub
  
  
  'read the kays to a byte
function key_in()
  key_in=port(gp8,8)
end function
  
  
  'graphics data embedded inside the game
CSUB FLAPPY
  00000000
  'Offset  0
  '1_tt is uncompressed
  00080018
  42242209 44444444 906E4646 24242209 44444444 90664664 42242209 44444444
  906E4646 24242209 44444444 906E4664 42242209 44444444 90664646 42242209
  44444444 906E4664 24242209 44444444 90664646 42242209 44444444 906E4664
  00000000
  'Offset  104
  '2_bs is compressed
  800C0018
  64220A0F 2202E1EF 21422241 61426145 61E16241 22412202 61482142 61E16241
  22412202 61482142 61E16241 22412202 61450142 62416142 220261E1 01422241
  62416148 220261E1 21422241 62416148 220261E1 21422241 62416148 220261E1
  01422241 61426145 61E16241 22412202 66482142 00000A0F
  'Offset  228
  '3_ts is compressed
  800C0018
  41220A0F 48214222 41220266 45014222 41614261 0261E162 42224122 41614821
  0261E162 42224122 41614821 0261E162 42224122 41614801 0261E162 42224122
  42614501 E1624161 41220261 48214222 E1624161 41220261 48214222 E1624161
  41220261 45214222 41614261 0261E162 E1EF6422 00000A0F
  'Offset  352
  '4_flap1 is compressed
  800C0010
  02980696 01F201E3 01E40196 049301F4 01F301E3 019101F1 01E201F4 01F101F3
  01F50191 01F401E2 01E50191 019106E3 01E301C3 C3039286 92068101 8501C601
  A5029301 96059605 00000000
  'Offset  432
  '5_flap2 is compressed
  800C0010
  02980696 01F201E3 01E40196 019401F4 01F301E5 019301F1 01F501E5 01E30592
  019101F4 07E301F5 01E201E5 C2059186 92068101 8501C601 A5029301 96059605
  00000000
  'Offset  504
  '6_flapd2 is uncompressed
  0010000C
  99009999 09999999 999990EC 00EC0099 0C099990 990CC0EC E0EC0C09 0CA090CC
  90CEE0EC EE00CCA0 CCA00CEE 0CEEEEEE 0EEE0CA0 80A00C00 00DDD0E0 FD080809
  08090DDD 0DDF0F08 FD080809 080990DD 990DDD08 00080809 00999990 99999908
  00000000
  'Offset  608
  '7_nulll is compressed
  800A0008
  F305F309 F101F105 F101F105 F101F105 F101F105 F305F305 0000000C
  'Offset  640
  '8_one is compressed
  800A0008
  F305F309 F206F206 F206F206 F206F206 0000000C
  'Offset  664
  '9_two is compressed
  800A0008
  F305F309 F305F107 F105F305 F305F307 0000000C
  'Offset  688
  'A_three is compressed
  800A0008
  F305F309 F305F107 F107F305 F305F305 0000000C
  'Offset  712
  'B_four is compressed
  800A0008
  F101F109 F101F105 F101F105 F101F105 F305F305 F107F107 0000000C
  'Offset  744
  'C_five is compressed
  800A0008
  F305F309 F307F105 F107F305 F305F305 0000000C
  'Offset  768
  'D_six is compressed
  800A0008
  F305F309 F307F105 F105F305 F305F101 000CF305
  'Offset  792
  'E_seven is compressed
  800A0008
  F305F309 F107F107 F107F107 F107F107 0000000C
  'Offset  816
  'F_eight is compressed
  800A0008
  F305F309 F101F105 F305F305 F101F105 F305F305 0000000C
  'Offset  844
  'G_nine is compressed
  800A0008
  F305F309 F101F105 F305F305 F305F107 000CF305
  'Offset  868
  'H_flap3 is compressed
  800C0010
  02980694 049403E5 01F201E5 02F30193 01F401E2 02E40192 01F301E1 019101F1
  01E201C5 01F101F2 02A30192 01F301E3 01E40393 01940382 028101C4 01940282
  028201C4 A3029582 97028202 81029203 00000091
  'Offset  956
  'I_flappy is compressed
  803000B2
  9F090F96 9F9F9F9F 9F010F93 960C9C9F 9F9F090F 939F9F9F 9F9F010F 02940C9C
  02F802FC 9F9F9F9F FE02939F 9A9F9F02 9402F802 F802FC02 9F9F9F02 02939F9F
  9F9F02FE 02F8029A 02FE0292 9F9F02F8 939F9F9F 02F1FF02 02989F9F 029202F8
  02F802FE 9F9F9F9F FF02939F 9F9F02F1 04F80298 F802F1FF 9F9F9F02 02939F9F
  9F02F3FF F802969F 02F1FF04 9F9F02F8 939F9F9F 02F3FF02 02969F9F F1FF04F8
  9F02F802 0F9D9F9F 0CF3FF07 F8029B9F 02F1FF04 9F9F02F8 070F9D9F 9F0CF3FF
  04F8029B 02F80AF8 960D0F94 F802960E F802F802 F802F802 940E9402 F804F806
  9402F80A 0E960D0F 02F80296 02F802F8 02F802F8 06940E94 F1FF04F8 9202F802
  FC02FE02 FC029204 F8029204 F802F802 F802F802 FC029202 FE029202 02F1FF04
  029202F8 04FC02FE 04FC0292 02F80292 02F802F8 02F802F8 02FC0292 04FE0292
  F802F1FF 02F1FF04 FF04F1FF 02F804F1 F3FF02F8 FE04F802 04F1FF04 F802F1FF
  02F1FF04 FF04F1FF 02F804F1 F3FF02F8 FE04F802 04F1FF04 F802F1FF 02F3FF02
  FF02F3FF 02F802F3 F3FF02F8 FF02F802 F3FF02F1 02F1FF04 F3FF02F8 02F3FF02
  F802F3FF FF02F802 02F802F3 FF02F1FF F1FF04F3 FF02F802 F3FF02F3 02F3FF02
  02F802F8 FF0CF3FF F3FF02F1 02F1FF04 F3FF02F8 02F3FF02 F802F3FF FF02F802
  F1FF0CF3 04F3FF02 F802F1FF F802F802 F802F802 F802F802 F802F802 02F3FF02
  08FA02F8 04F802F8 F802F1FF F802F802 F802F802 F802F802 F802F802 02F3FF02
  08FA02F8 04F802F8 02F80AF8 02F802F8 02F802F8 02F802F8 02F802F8 F802F3FF
  F80AF802 F804F802 F802F80A F802F802 F802F802 F802F802 FF02F802 02F802F3
  02F80AF8 0AF804F8 02F802F8 02F802F8 02F802F8 F3FF02F8 F802F802 F802F802
  F8029404 F804F802 F802F80A F802F802 F802F802 FF02F802 02F802F3 02F802F8
  029404F8 04F802F8 029602F8 02F802F8 02F802F8 02F802F8 F3FF02F8 F802F802
  F802F802 F8029602 F804F802 F8029602 F802F802 F802F802 F802F802 02F3FF02
  02F802F8 02F802F8 02F80296 02F804F8 02F80296 FF02F3FF F3FF02F3 02F1FF04
  F802F3FF 9602F802 04F3FF02 029602F8 F3FF02F8 02F3FF02 FF04F3FF F3FF02F1
  F802F802 FF029602 02F804F3 02F80296 FF02F3FF F3FF02F3 FF02FE06 02F802F3
  029602F8 F804F3FF F8029602 02F3FF02 FF02F3FF 02FE06F3 F802F3FF 9602F802
  04F3FF02 029602F8 F1FF04F8 04F1FF02 9204F1FF FF02F808 02F804F1 049602F8
  F804F1FF F8029602 02F1FF04 FF04F1FF 089204F1 F1FF02F8 F802F804 FF049602
  02F804F1 06F80296 06FE02FE 069604FE 06FE02F8 02F802F8 04FE0498 029602F8
  02FE06F8 04FE06FE 02F80696 02F806FE 049802F8 0C960EFE F8030F92 F8029208
  FC029808 0F92030F 0F0F9A07 0F920C96 9208F803 9808F802 030FFC02 9A070F92
  0C960F0F F8010F94 F8029406 FC029A06 0F94010F 0D0F9C07 0F940C96 9406F801
  9A06F802 010FFC02 9C070F94 9F9F010F F802939F F8029802 FA029E02 9F9F9F04
  9F9F9F9F 02F8029B 02F80298 04FA029E 9F9F9F9F 9B9F9F9F 9802F802 9E02F802
  9F04F802 9F9F9F9F 029D9F9F 029802F8 029E02F8 9F9F04F8 9F9F9F9F 980C9D9F
  9F0C9E0C 9F9F9F9F 0C9F9F9F 0C9E0C98 9F9F9F9F 9F9F9F9F 9E0C980C 9F9F9F0A
  9F9F9F9F 980C929F 9F0A9E0C 9E9F9F9F 00000000
  'Offset  2164
  'J_getready is compressed
  803200B8
  9F050F96 98010F93 9F9F050F 010F959F 96010F9E 939F050F 0F98010F 9F9F9F05
  9E010F95 0294010F 9F02F3FF 02FC0293 F3FF0298 9F9F9F02 02FC0293 02FC029E
  F3FF0294 02939F02 029802FC 9F02F3FF 02939F9F 029E02FC 029202FC 0EF26EF4
  68F20296 029802F2 02F46EF2 9F9F0A94 68F20292 029E02F2 02F268F2 6EF40292
  02960EF2 02F268F2 6EF20298 0A9402F4 02929F9F 02F268F2 68F2029E 6FF404F2
  FA04F261 F2029402 9802F268 616FF202 02FA04F4 F2029F9F 9E02F268 F268F202
  616FF404 02FA04F2 68F20294 029802F2 F4616FF2 9F02FA04 68F2029F 029E02F2
  04F268F2 F2636FF2 F466F402 F2029202 9802F268 636FF202 66F402F2 0F9602F4
  F2029403 030FF268 04F268F2 F2636FF2 F466F402 F2029202 9802F268 636FF202
  66F402F2 0F9602F4 F2029403 030FF268 04F268F2 F64A68F2 F204F46A 9406F268
  4268F202 F46AF668 FF029202 68F208F1 F268F7FF 4A68F204 04F46AF6 06F268F2
  68F20294 6AF66842 029202F4 F208F1FF 68F7FF68 68F204F2 68F86EFE 029402F6
  68F268F2 02F46EF4 02F26CF4 68F268F8 68F268F2 68F204F2 68F86EFE 029402F6
  68F268F2 02F46EF4 02F26CF4 68F268F8 68F268F2 68F204F2 F2636FFC 02F2616F
  68F20294 6FF268F2 F66EF663 F268F26E F268F268 FC68F204 6FF2636F 9402F261
  F268F202 636FF268 6EF66EF6 68F268F2 04F268F2 68F268F2 684268F2 F2616FF2
  F2029402 F268F268 F4684268 6FF4616F F268F261 F268F268 F268F204 4268F268
  616FF268 029402F2 68F268F2 684268F2 F4616FF4 68F2616F 68F268F2 68F204F2
  68F268F2 6FF268F2 9402F261 F268F202 F268F268 636FF268 F2636FF2 F268F268
  F204F268 F268F268 F268F268 02F2616F 68F20294 68F268F2 6FF268F2 636FF263
  68F268F2 04F268F2 68F268F2 68F268F2 446844F2 029402F2 F2636FF2 F268F268
  F2684268 F2684268 F268F268 F204F268 F268F268 F268F268 F2446844 F2029402
  68F2636F 68F268F2 68F26842 68F26842 68F268F2 68F204F2 68F268F2 68F668F2
  029402F6 F2636FF2 F268F268 F268F268 F268F268 F268F268 F204F268 F268F268
  F668F268 9402F668 636FF202 68F268F2 68F268F2 68F268F2 68F268F2 04F268F2
  68F268F2 F2636FF2 F268F202 F2029406 F242616F 68F2636F 68F268F2 68F268F2
  48F268F2 68F204F2 6FF268F2 F202F263 9406F268 616FF202 636FF242 68F268F2
  68F268F2 68F268F2 04F248F2 68F268F2 F2636FF2 F268F202 F2029406 6FF4426E
  F268F263 F268F268 636FF268 68F204FC 6FF268F2 F202F263 9406F268 426EF202
  F2636FF4 F268F268 F268F268 04FC636F 68F268F2 F2486AF2 F668F202 F2029402
  486AF66E 68F268F2 68F268F2 616F42F2 68F204FC 6AF268F2 F202F248 9402F668
  F66EF202 68F2486A 68F268F2 42F268F2 04FC616F F2636FF2 F202FA6A 9402F26C
  F66EF202 636FFA6A F4636FF2 68F26E42 6FF204F2 FA6AF263 F26CF202 F2029402
  FA6AF66E 6FF2636F 6E42F463 04F268F2 616F42F2 F26842F2 6A42F20A 029402F2
  66F268F2 F26842F4 6F42F206 6F42F261 6846F661 04F268F2 616F42F2 F26842F2
  6A42F20A 029402F2 66F268F2 F26842F4 6F42F206 6F42F261 6846F661 04F268F2
  F46E42F4 02F26642 42F40296 9402F268 F268F202 6642F468 029202F2 F46E42F4
  02F26E42 68F268F8 42F404F2 6642F46E 029602F2 F26842F4 F2029402 F468F268
  02F26642 42F40292 6E42F46E 68F802F2 02F268F2 4EF40292 02F246F6 48F40298
  029402F2 48F248F2 02F246F6 4EF40294 04F24EF6 48F268F6 029202F2 46F64EF4
  029802F2 02F248F4 48F20294 46F648F2 029402F2 4EF64EF4 68F604F2 02F248F2
  F3FF0294 9A02FA02 9402FC02 02F7FF02 029602FA FF02F3FF 6CF204F3 029402FC
  FA02F3FF FC029A02 FF029402 02FA02F7 F3FF0296 04F3FF02 02FC6CF2 020F0F96
  0F960E9C 0F98060F 6AF20C0F 960CF242 9C020F0F 0F0F960E 0F0F9806 426AF20C
  9F9F0CF2 9F9F9F9F 9F9F9F9F 68F20294 9F02F442 9F9F9F9F 9F9F9F9F F2029E9F
  02F44268 9F9F9F9F 9F9F9F9F 029E9F9F 02F448F2 9F9F9F9F 9F9F9F9F 919F9F9F
  F448F202 9F9F9F02 9F9F9F9F 9F9F9F9F 02FC0291 9F9F9F9F 9F9F9F9F 939F9F9F
  9F02FC02 9F9F9F9F 9F9F9F9F 0E939F9F 9F9F9F9F 9F9F9F9F 959F9F9F 00919F0E
  'Offset  3704
  'K_taptap is compressed
  80300030
  9F06979F F3029A9F 9F01F201 F401989F 9F01F401 F501969F F101F301 949F9F01
  F301F601 9F01F101 F701949F 9F01F401 F405949F 929F9F06 F201F501 9F01F601
  F401919F F101F201 019F9F06 01F30191 01F501F4 92019F9F 9F05F504 9601919F
  949F9F05 9F019201 93019E9F 9E9F9F01 9F049301 9F019B9F 04939F9F 9F9F0194
  F101919F 9E9F9F01 9F01F301 F5019C9F 9C9F9F01 9F01F301 F3019D9F 9D9F9F01
  9F9F9F05 9F9F9F9F 01998D9D 81F38E9C 82F381F3 01930194 82970193 81F381F3
  82F183F3 81F181F1 83F181F1 01920194 84970192 81F182F1 81F181F1 82F183F1
  84F381F3 F185919F F381F382 F182F183 F181F181 99029785 F182F184 F181F181
  F182F185 F181F181 F2019784 F1839901 F181F182 818FF181 01F20198 969F8D9A
  9F01F201 F2019E9F 9E9F9F01 9F03F201 F5029B9F 999F9F01 F601F101 989F9F01
  9F01F801 F801989F 989F9F01 9F01F801 F701999F 9A9F9F01 9F01F501 9F069C9F
  03910396 03910391 03990391 03910391 01930199 01910191 01910191 04940193
  01920194 01910191 03990191 03910391 03930191 0392019A 019B0391 01930191
  01910191 04940193 01920194 01910191 0191039B 01910193 03910391 0192019A
  01910191 0000009A
  'Offset  4164
  'L_gameover is compressed
  803200C0
  9F050F96 9F9F9F9F 9F9F0E9D 0F9A9F9F 9F9F9F05 0E9D9F9F 9F9F9F9F F3FF0298
  9F9F9F02 029B9F9F 9F9F02FE 02969F9F 9F02F3FF 9F9F9F9F 02FE029B 9F9F9F9F
  CEF40294 9F9F02F2 9F0E979F CAF40293 979F02F4 029B9F0E 02F2CEF4 979F9F9F
  02939F0E 02F4CAF4 9F0E979F CFF40299 9F02F2C1 02959F9F 029E02FE 02F4CEF4
  FE02939F 02979F02 F2C1CFF4 9F9F9F02 02FE0295 CEF4029E 939F02F4 9F02FE02
  CFF20297 0F0FF2C3 CAF4070F 029C02F4 F2C3CFF2 CAF4050F 0F9202F4 C3CFF205
  0F0F0FF2 F4CAF407 F2029C02 0FF2C3CF F4CAF405 050F9202 F2AAC8F2 FFFFFF02
  CEF204F1 029C02F2 C8A2C8F2 F2CEF9FF 04F1FF04 F2AAC8F2 FFFFFF02 CEF204F1
  029C02F2 C8A2C8F2 F2CEF9FF 04F1FF04 F1FFC8F2 CBCFF2CE 02F4CEF8 C8F2029A
  C8F2C8F2 CEF4C8F2 04F2CCF8 F1FFC8F2 CBCFF2CE 02F4CEF8 C8F2029A C8F2C8F2
  CEF4C8F2 04F2CCF8 CFFEC8F2 CDCFF2C1 F2C3CFF4 F2029A02 F2C8F2C8 F2C8F2C8
  CEF4C3CF C8F204F2 F2C1CFFE CFF4CDCF 9A02F2C3 F2C8F202 F2C8F2C8 C3CFF2C8
  04F2CEF4 C8F2C8F2 F2C1CFF4 CFF4CDCF 9A02F2C3 F2C8F202 F2C8F2C8 A2C8F2C8
  F2CEF4C8 F2C8F204 C1CFF4C8 F4CDCFF2 02F2C3CF C8F2029A C8F2C8F2 C8F2C8F2
  CEF4C8A2 C8F204F2 CFF2C8F2 CFCFF2C3 C8F2C8F2 029A02F2 C8F2C8F2 C8F2C8F2
  C8F2C8F2 F2C1CFF2 F2C8F204 C3CFF2C8 F2CFCFF2 F2C8F2C8 F2029A02 F2C8F2C8
  F2C8F2C8 F2C8F2C8 04F2C1CF C8F2C8F2 C8A2C8F2 CAA2C8F2 C8F2C8A2 02F2C8F2
  C8F2029A C8F2C8F2 C8F2C8F2 C8F2C8F2 F204F2A8 F2C8F2C8 F2C8A2C8 A2CAA2C8
  F2C8F2C8 9A02F2C8 F2C8F202 F2C8F2C8 F2C8F2C8 A8C8F2C8 C8F204F2 C8F2C8F2
  C8F2C8F2 C8F2CAF2 C8A2C8F2 029A02F2 C8F2C8F2 C8F2C8F2 C8F2C8F2 04FAC8F2
  C8F2C8F2 C8F2C8F2 CAF2C8F2 C8F2C8F2 02F2C8A2 C8F2029A C8F2C8F2 C8F2C8F2
  C8F2C8F2 C8F204FA C8F2C8F2 C8F2C8F2 C8F2CAF2 F2C3CFF2 F2029A02 F2C8F2C8
  F2C8F2C8 C8F2C3CF C8F20CF2 C8F2C8F2 C8F2C8F2 C8F2CAF2 F2C3CFF2 F2029A02
  F2C8F2C8 F2C8F2C8 C8F2C3CF C8F20CF2 C8F2C8F2 C8F2C8F2 C8F2CAF2 F2C3CFF2
  F2029A02 F2C8F2C8 F2C8F2C8 C8F2C3CF 029802F2 C8F2C8F2 C8F2C8F2 CAF2C8F2
  CFF2C8F2 9A02F2C3 F2C8F202 F2C8F2C8 C3CFF2C8 02F2C8F2 C8F20298 C8F2C8F2
  C8F2C8F2 C8F2CAF2 F2A8CAF2 F2029A02 F2C8F2C8 A2C6F2C8 F2A8CAF2 9802F2C8
  F2C8F202 F2C8F2C8 F2C8F2C8 F2C8F2CA 02F2A8CA C8F2029A C8F2C8F2 F2A2C6F2
  C8F2A8CA 029802F2 F2C3CFF2 C8F2C3CF C8F2CAF2 02FACAF2 CFF2029A A2CEF2C3
  C8FACAF4 029802F2 F2C3CFF2 C8F2C3CF C8F2CAF2 02FACAF2 CFF2029A A2CEF2C3
  C8FACAF4 029802F2 C1CFA2F2 C1CFA2F2 CAF2C8F2 A2F2C8F2 9A0AF2C8 CEA2F202
  A2CCF2A2 F2C8A2F6 F2C8F206 F2029802 F2C1CFA2 F2C1CFA2 F2CAF2C8 C8A2F2C8
  029A0AF2 A2CEA2F2 F6A2CCF2 06F2C8A2 02F2C8F2 A2F40298 CEA2F4CE CAF2C8F2
  A2F4C8F2 9F02F2C6 A2F40293 CAF4A2CA F402F4A2 02F2C6A2 C8F20292 029802F2
  F4CEA2F4 C8F2CEA2 C8F2CAF2 F2C6A2F4 02939F02 A2CAA2F4 F4A2CAF4 C6A2F402
  029202F2 02F2C8F2 AEF4029A A8F2AEF6 A8F2AAF2 02F2A6F6 F402959F F4AAF6AA
  F4029202 9202F2A6 F2A8F202 F4029A02 F2AEF6AE F2AAF2A8 F2A6F6A8 02959F02
  AAF6AAF4 029202F4 02F2A6F4 A8F20292 029C02F2 FF02F3FF 02F5FFFF 979F02FA
  FE02FE02 FA029602 FC029202 FF029C02 FFFF02F3 FA02F5FF 02979F02 02FE02FE
  02FA0296 02FC0292 0F0F0F9E 9F090F0F 9A0F0F99 010F920C 0F0F0F9E 9F090F0F
  9A0F0F99 010F920C 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F
  9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F
  9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F
  9F9F9F9F 9F9F9F9F 9F9F9F9F 009E9F9F
  'Offset  5560
  'M_score is compressed
  805D00AA
  0F0F0F0F 0F0F0F0F 060F0F0F EFEFEFEF EFEFEFEF E3EFEFEF CFCFE102 CFCFCFCF
  CFCFCFCF 02E1C1CF EFEFC1E1 EFEFEFEF EFEFEFEF 02E1C1EE FFE1C1E1 FFFFFFFF
  FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1
  FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1
  FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF
  02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF
  FCFFFFFF 02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1
  FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1 C1F3C1F1 C3F1C3F1 C1F2C2F3 FFFFFFFF
  F2C3F6FF F2C2F2C3 FFC3F2C3 E1C1E1F7 E1C1E102 F1C2F1FF F3C1F1C2 F1C1F2C1
  F1C1F2C1 FFFFFFC1 C1F5FFFF C1F4C1F4 C1F1C1F2 C1F1C1F2 C1E1F9FF C1E102E1
  C1F1FFE1 C1F1C1F1 C1F3C1F1 C1F1C1F2 C1F1C1F2 FFFFFFFF F4C1F5FF F2C1F4C1
  F2C1F1C1 FFC1F1C1 E1C1E1F9 E1C1E102 F3C1F1FF F1C3F1C1 F1C1F2C1 F1C1F2C1
  FFFFFFC1 C2F6FFFF C1F4C1F2 C3F1C1F2 F7FFC3F2 02E1C1E1 FFE1C1E1 C1F3C1F1
  C1F3C1F1 C4F1C1F2 FFFFC1F1 F8FFFFFF F4C1F1C1 F1C1F2C1 FFC1F3C2 E1C1E1F9
  E1C1E102 F3C1F1FF F3C1F1C1 F1C1F2C1 F1C1F2C1 FFFFFFC1 C1F8FFFF C1F4C1F1
  C1F1C1F2 C1F2C1F1 C1E1F9FF C1E102E1 C1F1FFE1 C3F1C1F3 C1F2C3F1 C4F1C1F2
  FFFFFFFF F3C3F2FF F2C2F2C3 F1C1F2C1 E1F7FFC3 E102E1C1 FFFFE1C1 FFFFFFFF
  FFFFFFFF E1C1E1FC E1C1E102 FFFFFFFF FFFFFFFF E1FCFFFF E102E1C1 FFFFE1C1
  FFFFFFFF FFFFFFFF E1C1E1FC E1C1E102 FFFFFFFF FFFFFFFF FF010FF2 E1C1E1F9
  E1C1E102 FFFFFFFF FFFFFFFF 018E01F2 C1E1F9FF C1E102E1 FFFFFFE1 FFFFFFFF
  8E01F2FF E1F9FF01 E102E1C1 FFFFE1C1 FFFFFFFF 01F2FFFF F9FF018E 02E1C1E1
  FFE1C1E1 FFFFFFFF F2FFFFFF FF018E01 E1C1E1F9 E1C1E102 FFFFFFFF FFFFFFFF
  018E01F2 C1E1F9FF C1E102E1 FFFFFFE1 FFFFFFFF 8E01F2FF E1F9FF01 E102E1C1
  FFFFE1C1 FFFFFFFF 01F2FFFF F9FF018E 02E1C1E1 FFE1C1E1 FFFFFFFF F2FFFFFF
  FF018E01 E1C1E1F9 E1C1E102 FFFFFFFF FFFFFFFF 018E01F2 C1E1F9FF C1E102E1
  FFFFFFE1 FFFFFFFF 8E01F2FF E1F9FF01 E102E1C1 FFFFE1C1 FFFFFFFF 01F2FFFF
  F9FF018E 02E1C1E1 FFE1C1E1 FFFFFFFF F2FFFFFF FF018E01 E1C1E1F9 E1C1E102
  FFFFFFFF FFFFFFFF 018E01F2 C1E1F9FF C1E102E1 FFFFFFE1 FFFFFFFF 8E01F2FF
  E1F9FF01 E102E1C1 FFFFE1C1 FFFFFFFF 0FF2FFFF E1F9FF01 E102E1C1 FFFFE1C1
  FFFFFFFF FFFFFFFF E1C1E1FC E1C1E102 FFFFFFFF FFFFFFFF E1FCFFFF E102E1C1
  FFFFE1C1 FFFFFFFF FFFFFFFF E1C1E1FC E1C1E102 FFFFFFFF FFFFFFFF E1FCFFFF
  E102E1C1 FFFFE1C1 FFFFFFFF FFFFFFFF E1C1E1FC E1C1E102 FFFFFFFF FFFFFFFF
  E1FCFFFF E102E1C1 FFFFE1C1 FFFFFFFF C3F2FFFF C2F2C3F2 F7FFC5F1 02E1C1E1
  FFE1C1E1 FFFFFFFF F2FFFFFF F1C1F2C1 F5C1F3C1 E1F9FFC1 E102E1C1 FFFFE1C1
  FFFFFFFF C1F2FFFF C1F1C1F2 C1F5C1F3 C1E1F9FF C1E102E1 FFFFFFE1 FFFFFFFF
  F2C3F2FF F3C2F2C3 E1F9FFC1 E102E1C1 FFFFE1C1 FFFFFFFF C1F2FFFF C1F1C1F2
  C1F2C1F6 C1E1F9FF C1E102E1 FFFFFFE1 FFFFFFFF F2C1F2FF F6C1F1C1 FFC1F2C1
  E1C1E1F9 E1C1E102 FFFFFFFF FFFFFFFF C3F2C3F2 C1F3C3F1 C1E1F9FF C1E102E1
  FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF
  C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF
  C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF 010FF2FF C1E1F9FF C1E102E1 FFFFFFE1
  FFFFFFFF 8E01F2FF E1F9FF01 E102E1C1 FFFFE1C1 FFFFFFFF 01F2FFFF F9FF018E
  02E1C1E1 FFE1C1E1 FFFFFFFF F2FFFFFF FF018E01 E1C1E1F9 E1C1E102 FFFFFFFF
  FFFFFFFF 018E01F2 C1E1F9FF C1E102E1 FFFFFFE1 FFFFFFFF 8E01F2FF E1F9FF01
  E102E1C1 FFFFE1C1 FFFFFFFF 01F2FFFF F9FF018E 02E1C1E1 FFE1C1E1 FFFFFFFF
  F2FFFFFF FF018E01 E1C1E1F9 E1C1E102 FFFFFFFF FFFFFFFF 018E01F2 C1E1F9FF
  C1E102E1 FFFFFFE1 FFFFFFFF 8E01F2FF E1F9FF01 E102E1C1 FFFFE1C1 FFFFFFFF
  01F2FFFF F9FF018E 02E1C1E1 FFE1C1E1 FFFFFFFF F2FFFFFF FF018E01 E1C1E1F9
  E1C1E102 FFFFFFFF FFFFFFFF 018E01F2 C1E1F9FF C1E102E1 FFFFFFE1 FFFFFFFF
  8E01F2FF E1F9FF01 E102E1C1 FFFFE1C1 FFFFFFFF 01F2FFFF F9FF018E 02E1C1E1
  FFE1C1E1 FFFFFFFF F2FFFFFF F9FF010F 02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF
  C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1 FFFFFFFF
  FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1
  FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1
  FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF
  02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1 FFFFFFFF
  FCFFFFFF 02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1 FFFFFFE1
  FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF C1E102E1
  FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1 FFE1C1E1 FFFFFFFF FFFFFFFF C1E1FCFF
  C1E102E1 FFFFFFE1 FFFFFFFF FCFFFFFF 02E1C1E1 EFEFC1E1 EFEFEFEF EFEFEFEF
  02E1C1EE CFCFCFE1 CFCFCFCF CFCFCFCF EF02E1C1 EFEFEFEF EFEFEFEF 0FE3EFEF
  0F0F0F0F 0F0F0F0F 00060F0F
  'Offset  7528
  'N_bmedalw is compressed
  80200020
  F6FF08FC FF03C803 01CE01F2 88C402FE 01FB02C4 82C882C4 01F901C4 82CC82C3
  01F701C3 C1CF81C3 F601C381 CF81C201 01C281C3 81C201F5 C281C5CF C201F301
  8106C981 01C281C6 81C201F2 01C302C7 C58101C2 F201C281 C781C101 01C38101
  8101C381 01C181C5 81C201F1 C48101C6 01C28101 C48101C1 C102C281 8101C681
  C28101C5 8101C101 02C181C5 01C681C1 01C401C7 C181C581 C681C102 C506C405
  C102C181 8101C581 C18101C4 01C48201 02C181C4 01C581C1 8101C381 06C101C1
  02C181C5 01C581C1 8101C281 C38201C3 C181C501 C681C102 05C58103 01C181C6
  81C101F1 81CA05C9 01F201C1 C9CF81C1 F201C181 CF81C201 01C281C7 81C101F3
  C181C7CF C101F501 81C5CF81 01F601C1 C3CF81C2 F701C281 CF81C201 01C281C1
  82C201F9 01C282CC 83C202FB 02C283C6 86C401FE F2FF01C4 FF03C803 00FC08F6
  'Offset  7852
  'O_smedalw is compressed
  80200020
  F6FF08FC FF03F803 57F401F2 02FE01F3 52F753F2 01FB02F2 52FC52F2 01F901F2
  F1FF51F2 F701F251 FF51F201 01F251F3 51F101F6 F151F5FF F101F501 51F7FF51
  01F301F1 06F951F2 F251F651 F101F201 5302F851 5101F201 01F151F6 51F101F2
  F35101F7 01F35101 F151F551 F201F101 5101F651 F25101F4 5101F101 02F251F4
  01F651F1 5101F551 01F101F2 F151F551 F651F102 5101F701 F55101F3 F102F151
  F405F651 F151F506 F551F102 01F45101 5101F151 51F401F5 51F102F1 F35101F5
  01F15101 F45106F1 F102F151 5101F551 F35101F2 01F45101 F151F451 F651F102
  05F55103 F251F451 F101F101 FA05F951 F201F151 FF51F101 01F151F9 51F201F2
  F251F7FF F101F301 51F7FF51 01F501F1 F5FF51F1 F601F151 FF51F201 01F251F3
  51F201F7 F251F1FF F201F901 F252FC52 F202FB01 F253F653 F401FE02 FF01F456
  03F803F2 FC08F6FF 00000000
  'Offset  8188
  'P_gmedalw is compressed
  80200020
  F6FF08FC FF03E803 C7E401F2 02FE01E3 C2E7C3E2 01FB02E2 C2ECC2E2 01F901E2
  E1EFC1E2 F701E2C1 EFC1E201 01E2C1E3 C1E101F6 E1C1E5EF E101F501 C1E7EFC1
  01F301E1 06E9C1E2 E2C1E6C1 E101F201 E302E8C1 C101E201 01E1C1E6 C1E101F2
  E3C101E7 01E3C101 E1C1E5C1 E201F101 C101E6C1 E2C101E4 E501E101 E102E2C1
  C101E6C1 E2C101E5 C101E101 02E1C1E5 01E6C1E1 E401E6C1 C1E5C101 C1E102E1
  06E405E6 02E1C1E5 01E5C1E1 C101E4C1 E4C201E1 E1C1E401 E5C1E102 01E3C101
  E101E1C1 E1C1E506 E5C1E102 01E2C101 C301E3C1 C1E501E2 C1E102E1 05E504E6
  01E2C1E5 C1E101F1 C1EA05E9 01F201E1 E9EFC1E1 F201E1C1 EFC1E201 01E2C1E7
  C1E101F3 E1C1E7EF E101F501 C1E5EFC1 01F601E1 E3EFC1E2 F701E2C1 EFC1E201
  01E2C1E1 C2E201F9 01E2C2EC C3E202FB 02E2C3E6 C6E401FE F2FF01E4 FF03E803
  00FC08F6
  'Offset  8516
  'Q_cup_medalw is compressed
  80200020
  0FF8FFFF 5102FB05 0251F1FF FF5101FA F80151F3 06F75103 F50351F5 01F15101
  E302F551 F401E201 51F10151 5101F301 F45101F2 E401E401 0151F301 F20151F2
  01F25101 E501F351 E101E301 0151F201 F20151F2 01F25101 E601F251 E101E301
  0151F201 F20151F2 01F25101 E701F251 F201E401 51F20151 5101F201 F25101F2
  F106E405 51F20151 5101F201 F15101F2 E201E501 5101E601 0151F201 F25101F2
  01F15101 01E201E4 51F106E1 0151F201 F25101F3 E3015101 E501E401 F2015101
  01F50151 5101F151 05E603F1 F10151F1 01F70151 5101F151 51F506F3 0151F101
  015101F9 0151FE51 03FB0151 0353F853 FA5101FF F4FF0151 53F45301 01F6FF01
  0151F651 5101F8FF FF0151F4 FBFF06FA 51F25101 01FBFF01 0151F251 FF06FBFF
  F45101FA F8FF0151 51F65101 01F6FF01 0151F851 5101F4FF FF0151FA FF010FF2
  0000FAFF
END CSUB
 
  
  'index in the csub compressed sprites
  data 0,104,228,352,432,504,608,640,664,688,712,744,768,792,816,844,868
  data 956,2164,3704,4164,5560,7528,7852,8188,8516
