  Dim integer level=3,FPS%=25 'FPS% is here the number of frames per second
  'Version 02.5  -- moved Tiles to CSUB
  Option default Integer
  ' system setup -----------------------------------------------------
  
  '*init NES-Controller on port A
  Const NES_A_DATA  = MM.Info(PinNo GP1)
  Const NES_A_LATCH = MM.Info(PinNo GP2)
  Const NES_A_CLOCK = MM.Info(PinNo GP3)
  Const NES_PULSE!  = 0.012 ' 12uS
  tmp$=ctrl_nes_a$(1)
  
  Option lcdpanel NOCONSOLE'* Debug to Terminal
  'Screen 320x240 = 20*15 Tiles
  Canvas_W=20:Canvas_H=15
  Offset_X=0:Offset_Y=0
  Map_H=0:Map_W=0
  FPS%=1000/FPS%  'important !! FPS% changes here from frames, to loop time in ms.
  Dim integer tls(128,2),spa(27),ani(3) = (0,1,2,1),Tileattr(128),col(15)
  Dim integer oxmin=-1,oxmax,oymin=0,oymax,tile_index(128)
  Dim map$(128)length 128
  'read sprite adress offset
  Restore SpOffset
  For f=0 To 26:Read spa(f):Next
  
  '-------------------------------
  'Prepare the Screen and Buffers
  '-------------------------------
  MODE 2
  spad%=Peek(cfunaddr SPRITES)
  
  'prepare the Layer (Magenta=Transparent)
  'FRAMEBUFFER Create
  FRAMEBUFFER layer 9
  'load Tilest into framebuffer (will be changed when they are stored in CSUB)
  'FRAMEBUFFER write f
  Tilead%=MM.Info(flash address 3)
  Select Case level
      
    Case 1
      Flash disk load 3,"Levels\tiles01.bin",o
      Inc Tilead%,32
      get_tadr "tile01_index.txt"
      load_map "map1.map"
      
    Case 2
      Flash disk load 3,"Levels\tiles02.bin",o
      Inc Tilead%,28
      get_tadr "tile2_index.txt"
      load_map "map2.map"
      
    Case 3
      Flash disk load 3,"Levels\tiles03.bin",o
      Inc Tilead%,28
      get_tadr "tile3_index.txt"
      load_map "map3.map"
      
  End Select
  'debug
  'For f=Tilead% To Tilead%+1024
  'a1=Peek(Byte f-2)
  'Print Hex$(a1,2) ;" ";'
  'Next
  
  'prepare the Layer
  'read color values and MAP_NAME$
  Restore colors:For f=1 To 15:Read col(f):Next
  FRAMEBUFFER write L
  CLS RGB(magenta)
  Load image "images/mt.bmp":Load image "images/mb.bmp",0,216
  Box 0,23,20,194,,0,0:Box 300,23,20,194,,0,0
  
  '-------------------------------
  'Read LevelMap to map$()
  '-------------------------------
  init_source
  Sprite memory spad%+244,148,106,9
  
  'paint Background
  FRAMEBUFFER write n
  For y=0 To 19:Paint_Col y:Next
  '-------------------------------
  'Player Movement  (to be optimised later)'Main loop?
  '-------------------------------
  
  Do
    'player movement, copy from PETSCII
    ke$="":tmp$=""':Text 290,0,Right$("00"+Str$(timer,3,0),3)
    Do
      tmp$=read_inkey$():If tmp$="" Then tmp$=ctrl_nes_a$(0)
      if tmp$<>"" then ke$=tmp$
    Loop Until Timer>fps%
    Timer=0
    
    'Player Movement  (to be optimised/compacted later)
    'ke$=read_inkey$():If ke$="" Then ke$=ctrl_nes_a$(0)
    Print @(0,0),ke$ 'debug to terminal
    'tt=Timer
    Select Case ke$
      Case "up"
        If Offset_y>oymin Then
          'For n=0 To 3
            show_sprite 0,ny:Sprite scroll 0,-4
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          ny=(ny+1) mod 4
          if ny=0 then Inc Offset_y,-1:Paint_Row 0
        EndIf
      Case "down"
        If Offset_y<oymax Then
          'For n=0 To 3
            show_sprite 4,ny:Sprite scroll 0,4
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          ny=(ny+1) mod 4
          if ny=0 then Inc Offset_y,1:Paint_Row 14
        EndIf
      Case "right"'rgt
        If Offset_X<oxmax Then
          'For n=0 To 3
            show_sprite 2,nx:Sprite scroll -4,0
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          nx=(nx+1) mod 4
          if n=0 then Inc Offset_x,1:Paint_Col 19
        EndIf
      Case "left"'lft
        If Offset_X>oxmin Then
          'For n=0 To 3
            show_sprite 6,nx:Sprite scroll 4,0
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          nx=(nx+1) mod 4
          if n=0 then Inc Offset_X,-1:Paint_Col 0
        EndIf
      Case "upleft"'uplft
        If Offset_X>oxmin And Offset_y>oymin Then
          'For n=0 To 3
            show_sprite 7,nx:Sprite scroll 4,-4
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          nx=(nx+1) mod 4:ny=(ny+1) mod 4
          if ny=0 then Inc Offset_y,-1:Paint_Row 0
          if nx=0 then Inc Offset_X,-1:Paint_Col 0
        EndIf
      Case "upright"'uprgt
        If Offset_X<oxmax And Offset_y>oymin Then
          'tt=Timer
          'For n=0 To 3
            show_sprite 1,nx:Sprite scroll -4,-4
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          nx=(nx+1) mod 4:ny=(ny+1) mod 4
          if ny=0 then Inc Offset_y,-1:Paint_Row 0
          if nx=0 then Inc Offset_X,1:Paint_Col 19
        EndIf
      Case "downleft"'dwnlft
        If Offset_X>oxmin And Offset_y<oymax Then
          'For n=0 To 3
            show_sprite 5,nx:Sprite scroll 4,4
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          nx=(nx+1) mod 4:ny=(ny+1) mod 4
          if ny=0 then Inc Offset_y,1:Paint_Row 14
          if nx=0 then Inc Offset_X,-1:Paint_Col 0
        EndIf
      Case "downright"'dwnrgt
        If Offset_X<oxmax And Offset_y<oymax Then
          'For n=0 To 3
            show_sprite 3,nx:Sprite scroll -4,4
            'tt=Int(.5+Timer-tt):Pause fps%-TT:Print fps%-tt: tt=Timer
          'Next
          nx=(nx+1) mod 4:ny=(ny+1) mod 4
          if ny=0 then Inc Offset_y,1:Paint_Row 14
          if nx=0 then Inc Offset_X,1:Paint_Col 19
        EndIf
    End Select
  Loop
  
  
  '--------------------------------------------------------------
  '              **** User input subs ****
  '--------------------------------------------------------------
  '
  'Functions partially adapted from MMBASIC Petscii Robots
  
Function read_input$()
  Static last$
  read_input$ = read_inkey$()
  If Len(read_input$) Then Exit Function
  read_input$ = Call(CTRL_DRIVER$)
  ' Suppress auto-repeat except for movement.
  If last$ = read_input$ Then
    If Not Instr("up,down,left,right", last$) Then
      read_input$ = ""
      Exit Function
    EndIf
  Else
    last$ = read_input$
  EndIf
End Function
  
Function read_inkey$()
  'Moving 8 Directions
  'Keys:
  ' W     E     R
  '  _    ^   _
  '|\     |    /|
  ' S <--    --F
  '       |
  '  |/_  v  _\|
  ' X     C     V
  
  Select Case Asc(Inkey$)
      Case 0   : Exit Function
      Case 101 : read_inkey$ = "up"
      Case 119 : read_inkey$ = "upleft"     'w
      Case 114 : read_inkey$ = "upright"
      Case 99  : read_inkey$ = "down"
      Case 120 : read_inkey$ = "downleft"
      Case 118 : read_inkey$ = "downright"
      Case 115 : read_inkey$ = "left"          ' s
      Case 102 : read_inkey$ = "right"
  End Select
End Function
  
  
Sub kill_kb
  Do While read_input$() <> "" : Loop
End Sub
  
  ' Controller driver for NES gamepad connected to PicoGAME VGA port A.
Function ctrl_nes_a$(init)
  If Not init Then
    Local bits, i, s$
    Pulse NES_A_LATCH, NES_PULSE!
    For i = 0 To 7
      If Not Pin(NES_A_DATA) Then bits=bits Or 2^i
      Pulse NES_A_CLOCK, NES_PULSE!
    Next
    
    Select Case bits
        Case 0    : Exit Function
        'Case &h01 : s$ = "move"          ' Fire A
        'Case &h02 : s$ = "search"        ' Fire B
        'Case &h03 : s$ = "map"           ' Fire A + Fire B
        'Case &h04 : s$ = "escape"        ' Select
        'Case &h08 : s$ = "use-item"      ' Start
        Case &h10 : s$ = "up"
        Case &h90 : s$ = "upright"
        Case &h50 : s$ = "upleft"
        'Case &h11 : s$ = "fire-up"       ' Up + Fire A
        'Case &h12 : s$ = "toggle-weapon" ' Up + Fire B
        Case &h20 : s$ = "down"
        Case &hA0 : s$ = "downright"
        Case &h60 : s$ = "downleft"
        'Case &h21 : s$ = "fire-down"     ' Down + Fire A
        'Case &h22 : s$ = "toggle-item"   ' Down + Fire B
        Case &h40 : s$ = "left"
        'Case &h41 : s$ = "fire-left"     ' Left + Fire A
        Case &h80 : s$ = "right"
        'Case &h81 : s$ = "fire-right"    ' Right + Fire A
    End Select
    ctrl_nes_a$ = s$
    Exit Function
  Else
    SetPin NES_A_DATA, DIn
    SetPin NES_A_LATCH, DOut
    SetPin NES_A_CLOCK, DOut
    SetPin GP14, DOut
    Pin(GP14) = 1 ' Power for the NES controller - unnecessary ?
  EndIf
End Function
  
  '--------------------------------------------------------------
  **** Display Output subs *****
  '--------------------------------------------------------------
  
  '
  'draws a column of tiles (normally hidden under the border)
  'nr% stands for the tile column to be drawn
  'can be a value from 0 to 19
  '-------------------------------
Sub Paint_Col nr%
  Local integer sy=Offset_y,sx=Offset_X+nr%,ty=0,x,y,tx=nr%<<4
  'Get address of Map Position
  x=nr
  mp=Peek(varaddr map$(sy))
  For y=0 To 14
    tn=Peek(BYTE mp+sx+1)
    Sprite memory tile_index(tn),tx,ty
    Inc mp,129:Inc ty,16
  Next
End Sub
  
  '-------------------------------
  'Draws a row of tiles (normally hidden under the border)
  'nr% stands for the row of tiles to be painted
  'can be a value between 0 and 14
  '-------------------------------
Sub Paint_Row nr%
  Local integer sx=Offset_X,sy=Offset_y+nr,ty=nr%<<4,tx=0
  'Get address of Map Position
  mp=Peek(varaddr map$(sy))
  For x=sx To sx+19
    tn=Peek(BYTE mp+x+1)
    Sprite memory tile_index(tn),tx,ty
    Inc tx,16
  Next
End Sub
  '-
  
Sub show_sprite nr,offs
  FRAMEBUFFER write l
  nr=nr*3
  sadr=spad%+spa(nr+ani(offs))
  Box 148,106,24,28,,RGB(magenta),RGB(magenta)
  Sprite memory sadr,148,106,9
  FRAMEBUFFER write n,b
End Sub
  
  '--------------------------------------------------------------
  '
  'initialisation
Sub init_source
  Local integer x=0,y=0,f
  For f=0 To 127
    tls(f,0)=x:tls(f,1)=y:Inc x,16:If x>255 Then Inc y,16:x=0
  Next
End Sub
  
Sub load_map(mp$)
  Open "map/"+mp$ For input As #1
  a$=Input$(3,#1)
  If a$<>"MAP" Then Print "Wrong MAP-File Format in File ";mp$:End
  Map_W=Asc(Input$(1,#1))
  Map_H=Asc(Input$(1,#1))
  oxmax=Map_W-19
  oymax=Map_H-14
  For f=0 To Map_H-1
    map$(f)=Input$(Map_W,#1)
  Next
  Close #1
End Sub
  
  'Write Sprite Memory addresses to index array
Sub get_tadr tn$
  'Print Tilead%:Print :Print
  Open "Levels\"+tn$ For input As #1
  For f=0 To 127
    Input #1,a1:tile_index(f)=a1+Tilead%
    'Print tile_index(f)
  Next
  Close #1
  'End
End Sub
  
  '--------------------------------------------------------------
  '                     **** data part ****
  '--------------------------------------------------------------
  
  Data 0,-1, -1,-1, -1,0, -1,1, 0,1, 1,1, 1,0, 1,-1
SpOffset:
  Data 0,244,480,708,1004,1284,1552,1808,2052,2300,2560,2796,3048,3316
  Data 3596,3864,4108,4340,4572,4812,5040,5276,5548,5788,6044,6316,6520
colors:
  '--Colorscheme accordung to Spritecolors
  Data RGB(BLUE),RGB(GREEN),RGB(CYAN),RGB(RED)
  Data RGB(MAGENTA),RGB(YELLOW),RGB(WHITE),RGB(MYRTLE)
  Data RGB(COBALT) ,RGB(MIDGREEN),RGB(CERULEAN),RGB(RUST)
  Data RGB(FUCHSIA),RGB(BROWN),RGB(LILAC)
CSub SPRITES
  00000000
  'Offset  0
  'PL0100 is compressed
  801C0018
  929F0698 9F042103 22012103 24039D03 25019B06 24029908 99072101 91042403
  22049A02 9B029105 91042302 21059A03 A2019908 97092103 01C1A101 01320413
  019502A2 1201C2A1 11311351 A1C20131 A1019402 511102C2 311252F1 01A1C201
  01930191 1102C2A1 1153F151 02A30131 01930191 531202A2 A1033211 95019101
  06311306 01910191 04320197 01910532 04180198 01910191 02530197 91053112
  53019801 91045302 97019101 11025301 91013151 91019101 12019801 03310331
  01910191 06530199 01910191 5111019A 01910131 01910191 029B0191 01910331
  01910191 0191059C 919F0191 00009E03
  'Offset  244
  'PL0101 is compressed
  801C0018
  929F0698 9F042103 22012103 24039D03 25019B06 24029908 99072101 91042403
  22049A02 9B029105 91042302 21059A03 A2019908 97092103 01C1A101 01320413
  019502A2 1201C2A1 11311351 A1C20131 A1019402 511102C2 311252F1 01A1C201
  01930191 1102C2A1 1153F151 02A30131 01930191 531202A2 A1033211 95019101
  06311306 01910191 04320197 01910532 31170198 91019104 53019701 91055302
  53019801 91045302 97019101 02311201 91013112 91019101 53019801 91025302
  99019101 31511101 31511102 91019101 31029A01 91033104 910A9B01 92039D01
  9F019103 0000919F
  'Offset  480
  'PL0102 is compressed
  801C0018
  929F0698 9F042103 22012103 24039D03 25019B06 24029908 99072101 91042403
  22049A02 9B029105 91042302 21059A03 A2019908 97092103 01C1A101 01320413
  019502A2 1201C2A1 11311351 A1C20131 A1019402 511102C2 311252F1 01A1C201
  01930191 1102C2A1 1153F151 02A30131 01930191 531202A2 A3013211 95019101
  05311306 019102A1 04320197 01910532 04180198 01910191 02530197 91053112
  11019801 53023151 91019104 31029701 91055303 12069801 01910231 039A0191
  01530191 01910191 5111019F 01910231 3102919F 9F019102 949F0692 00009903
  'Offset  708
  'PL0103 is compressed
  801C0018
  929F0598 9E042203 22012202 22019D04 9C062101 9C072302 9D082201 C1072102
  C1089D01 019101A1 02970291 01A10611 01960592 0B125111 019501C1 A3015311
  03A1C102 019601A1 0151F111 07A1C3A1 F1110197 C3A10111 019905A1 01115111
  03A1C2A1 029A01C2 C4A10211 9A01C1A2 A1C2A206 91019402 31029301 A2023103
  91019501 13019401 11523101 91019302 94019101 12511101 F1513101 91011152
  91019101 11029401 11021151 1151F152 91019102 92019101 12041104 91021153
  93019101 12029108 91021152 91049501 91019101 11521103 94019102 91019101
  91019101 12029101 91011151 91019401 91019101 91019101 13029101 94019102
  91019101 91019101 91019101 91019B06 91019101 91019E07 91019101 96019101
  00000000
  'Offset  1004
  'PL0104 is compressed
  801C0018
  929F0598 9E042203 22012202 22019D04 9C062101 9C072302 9D082201 C1072102
  C1089D01 019101A1 02970291 01A10611 01960592 0B125111 019501C1 A3015311
  03A1C102 019601A1 0151F111 07A1C3A1 F1110197 C3A10111 019905A1 01115111
  03A1C2A1 029A01C2 C4A10211 9A01C1A2 A1C2A206 91019402 32039401 9501A203
  95019101 31013101 93031251 91019101 51019601 F1110111 92021151 91019101
  11019701 F1110151 91011152 91019101 96019101 11021102 021151F1 01910191
  06960191 01115211 01910191 01960191 53110491 01910211 01960191 03910191
  02115211 01910191 01910198 01130391 01910191 01910198 07910191 01910191
  0191019A 01910791 0191019E 01910191 00980191
  'Offset  1284
  'PL0105 is compressed
  801C0018
  929F0598 9E042203 22012202 22019D04 9C062101 9C072302 9D082201 C1072102
  C1089D01 019101A1 02970291 01A10611 01960592 0B125111 019501C1 A3015311
  03A1C102 019601A1 0151F111 07A1C3A1 F1110197 C3A10111 019905A1 01115111
  03A1C2A1 029A01C2 C4A10211 9A01C1A2 A1C2A206 91019402 32039401 9501A203
  95019101 12513102 91019304 97019101 51F11101 01920411 01910191 F1110396
  32011151 91019103 94019101 11521103 91031401 94019101 11531103 11511202
  91019101 91019401 11521102 12511104 96019101 91021204 96041202 91079101
  91019807 91019105 91019101 98019101 91019101 91019101 91019101 9A019101
  9F019101 00000093
  'Offset  1552
  'PL0106 is compressed
  801C0018
  939F059A 23019F08 23019D06 08239D07 0624019C 01C1089D 029C01C1 C2A20222
  029B01A1 9BA40432 3201A201 019B0412 01A1C1A2 0511F152 C1A10199 1201A1F1
  11011151 97011201 A1C2A101 51021104 01123101 F1A10196 013307A1 94031131
  A1C1A101 0194020F A10AC2A2 A2029504 A1053203 059801C1 02125231 03970291
  51110133 011152F1 5111029A 52110231 021151F1 04110498 02115312 01940191
  02910791 02115212 01940191 01910391 03910191 02115211 01910194 01910191
  01910191 51120291 01960111 01910191 01910191 02910191 01980213 01910191
  01910191 019A0791 01910191 019E0791 01910191 01910191 00920191
  'Offset  1808
  'PL0107 is compressed
  801C0018
  939F059A 23019F08 23019D06 08239D07 0624019C 01C1089D 029C01C1 C2A20222
  029B01A1 9BA40432 3201A201 019B0412 01A1C1A2 0511F152 C1A10199 1201A1F1
  11011151 97011201 A1C2A101 51021104 01123101 F1A10196 013307A1 94031131
  A1C1A101 0194020F A10AC2A2 A2029504 A1053203 059801C1 02125231 039B0291
  11F15111 31039D02 F1511101 9C011151 11019101 52110231 01910211 01960191
  02110391 01115211 01910191 01940191 04910191 02115212 01980191 03910191
  02115211 019A0191 03910191 01910113 019A0191 07910191 01910191 0191019A
  01910791 0191019E 01910191 00960191
  'Offset  2052
  'PL0108 is compressed
  801C0018
  939F059A 23019F08 23019D06 08239D07 0624019C 01C1089D 029C01C1 C2A20222
  029B01A1 9BA40432 3201A201 019B0412 01A1C1A2 0511F152 C1A10199 1201A1F1
  11011151 97011201 A1C2A101 51021104 01123101 F1A10196 013307A1 94031131
  A1C1A101 0194020F A10AC2A2 A2029504 A1053203 059801C1 02125231 029B0291
  51F15111 019C0311 F1110291 32011151 91019A02 11521102 02133101 02980191
  02115311 02115112 03960191 04115211 02115211 03910196 03910212 01960412
  07910791 01940191 05910191 01910191 01910191 01960191 01910191 01910191
  01910191 01910191 0191019A 01910195 00940191
  'Offset  2300
  'PL0109 is compressed
  801C0018
  939F059B 9F032302 9E022304 9D032503 9C042205 0281A108 03C1089C 1181059C
  9B0211C2 C1A18106 019B01A2 023202A1 A101A181 A2019A01 5101A1C1 A1019908
  5101A1C2 01A20511 C2A10197 F15101A2 01110211 019601A3 A1C1F1A1 1252F103
  A1C1A101 A1019601 5204A1C2 C2A10111 019701A1 011104A4 A1C1A1C1 A1029901
  A10711C1 12039A01 11029B08 11041103 11029A01 12021151 91019705 12041104
  91019705 11029107 97011103 91039101 91019101 11521103 91019501 91019101
  91019101 12029101 96011151 91019101 91019101 91019101 97011302 91019101
  91019101 91019101 91019B06 91019101 91019E07 91019101 93019101 00000000
  'Offset  2560
  'PL010A is compressed
  801C0018
  939F059B 9F032302 9E022304 9D032503 9C042205 0281A108 03C1089C 1181059C
  9B0211C2 C1A18106 019B01A2 023202A1 A101A181 A2019A01 5101A1C1 A1019908
  5101A1C2 01A20511 C2A10197 F15101A2 01110211 019601A3 A1C1F1A1 1252F103
  A1C1A101 A1019601 5204A1C2 C2A10111 019701A1 011104A4 A1C1A1C1 A1029901
  A107A1C1 A2019C01 11049D08 11029E05 04511101 0191019C 51110212 91019A04
  11021103 01980452 04910191 02115212 01980191 03910191 02115211 019A0191
  03910191 01910113 019A0191 07910191 01910191 0191019A 01910791 0191019E
  01910191 00950191
  'Offset  2796
  'PL010B is compressed
  801C0018
  939F059B 9F032302 9E022304 9D032503 9C042205 0281A108 03C1089C 1181059C
  9B0211C2 C1A18106 019B01A2 023202A1 A101A181 A2019A01 5101A1C1 A1019908
  5101A1C2 01A20511 C2A10197 F15101A2 01110211 019601A3 A1C1F1A1 1252F103
  A1C1A101 A1019601 5204A1C2 C2A10111 019701A1 011104A4 A1C1A1C1 A1029901
  A107A1C1 A2019C01 12039D08 91019D05 51F11102 91019A06 11521102 96019107
  11029101 11051153 94019102 11039101 11041152 96021251 12039101 12029102
  91019405 91079101 94019107 91019101 91019105 91019101 96019101 91019101
  91019101 91019101 91019101 95019C01 91019101 00009301
  'Offset  3048
  'PL010C is compressed
  801C0018
  929F0698 23049F08 22049D03 9C032201 21012203 9B032101 22A12204 9A032101
  9A07A106 C3118104 9B038111 C3118103 99038111 01A18106 990381A1 0EA1C101
  A1C20196 11013201 01321103 019501A2 1201A2C1 01311601 019301A3 04A101C1
  52115211 C1A10111 019202A2 F11106C1 51F11151 C2A10111 019101A1 C1A10191
  11019103 11311151 C2A10251 019302A1 051106A1 02A1C2A1 05930191 C2A304C1
  019101A2 C2A10395 A2C4A201 91019101 A3049401 9102A501 95019101 9101910E
  94019101 53019102 91023303 94019101 31511105 91015303 95019101 11043106
  910231F1 92029701 53019203 91019101 11019F01 91023151 02919F01 01910231
  9103939F 00009601
  'Offset  3316
  'PL010D is compressed
  801C0018
  929F0698 23049F08 22049D03 9C032201 21012203 9B032101 22A12204 9A032101
  9A07A106 C3118104 9B038111 C3118103 99038111 01A18106 990381A1 0EA1C101
  A1C20196 11013201 01321103 019501A2 1201A2C1 01311601 019301A3 04A101C1
  52115211 C1A10111 019202A2 F11106C1 51F11151 C2A10111 019101A1 C1A10191
  11019103 11311151 C2A10251 019302A1 051106A1 02A1C2A1 05930191 C2A304C1
  019101A2 C2A10395 A2C4A201 91019101 81039401 C28201C2 01910282 04950191
  03A301A3 01910191 02940191 02520891 01910191 01910295 0331F111 0131F111
  01910191 03530595 01910253 51110596 51110331 01910131 02960191 02310291
  03310291 039B0191 01910493 9101959F 00009601
  'Offset  3596
  'PL010E is compressed
  801C0018
  929F0698 23049F08 22049D03 9C032201 21012203 9B032101 22A12204 9A032101
  9A07A106 C3118104 9B038111 C3118103 99038111 01A18106 990381A1 0EA1C101
  A1C20196 11013201 01321103 019501A2 1201A2C1 01311601 019301A3 04A101C1
  52115211 C1A10111 019202A2 F11106C1 51F11151 C2A10111 019101A1 C1A10191
  11019103 11311151 C2A10251 019302A1 051106A1 02A1C2A1 05930191 C2A304C1
  019101A2 C2A10395 A2C4A201 91019101 81039401 C28201C2 01910282 04950191
  03A301A3 01910191 02940191 02520891 01910191 01910295 31043112 91019102
  11059501 910231F1 98019103 93015305 9A019101 11019102 9F013151 02310294
  9E03959F 00000000
  'Offset  3864
  'PL010F is compressed
  801C0018
  929F0599 9F022204 01250391 0424039E 0621049D A181029D C1039C08 A1029C08
  0581A1C2 C1A2019D 9D0581A1 A101A101 02A20281 C2A1069D 059E01A1 01A1C2A1
  0111039C C2A10112 049A01A1 01115211 01A1C2A1 51110599 81C38102 91019601
  11019104 C381A101 09970181 0283C182 82C20897 93049506 33048202 94039402
  52021101 51110211 01990211 04125311 01970411 02125211 01910791 52110195
  01910311 03910191 01960191 02125111 01910191 01910191 01910191 02130195
  01910191 01910191 01910191 01910695 01910191 01910191 07960191 01910191
  019C0191 01910191 01910191 0000009B
  'Offset  4108
  'PL0110 is compressed
  801C0018
  929F0599 9F022204 01250391 0424039E 0621049D A181029D C1039C08 A1029C08
  0581A1C2 C1A2019D 9D0581A1 A101A101 02A20281 C2A1069D 059E01A1 01A1C2A1
  0111039C C2A10112 049A01A1 01115211 01A1C2A1 51110599 81C38102 91019601
  11019104 C381A101 09970181 0283C182 82C20897 93049506 3304A202 95039501
  01125103 9E011151 11521101 91021102 9A019101 11521101 91019106 11019901
  91041252 98019101 11029101 91031152 91019101 91019601 13019101 91019103
  96019101 91019101 91019107 91019A01 91019107 91019C01 91019101 99019101
  00000000
  'Offset  4340
  'PL0111 is compressed
  801C0018
  929F0599 9F022204 01250391 0424039E 0621049D A181029D C1039C08 A1029C08
  0581A1C2 C1A2019D 9D0581A1 A101A101 02A20281 C2A1069D 059E01A1 01A1C2A1
  0111039C C2A10112 049A01A1 01115211 01A1C2A1 51110599 81C38102 91019601
  11019104 C381A101 09970181 0283C182 82C20897 93049506 5202A202 03970111
  52110594 019D0211 52110134 02990311 02125111 03115311 01960191 04115112
  02115211 03970191 02910212 01910212 07950191 01910891 01910197 01910191
  01910691 01910197 01910191 01910191 02910191 01910199 01910191 01910191
  00960191
  'Offset  4572
  'PL0112 is compressed
  801C0018
  919F0598 9E0A9F09 9E0B9D0B 019C0A81 08C101C1 C2A1019C 9D0681A1 0481A201
  049E0132 31513112 81029E01 F1511102 9C021151 1102C202 011151F1 029B0131
  1103C1F1 31011151 03940111 C1F10492 11511102 C20A9205 92061202 3104C306
  C2029708 9B053203 01311304 019C0132 01115312 11511131 11019B01 1251F151
  11511102 11019902 11041253 95019104 12521101 91079102 11019501 91031152
  91019101 96019103 12511101 91019102 91019101 91019101 13019501 91019102
  91019101 91019101 91069501 91019101 91019101 96019101 91019107 9C019101
  91019101 91019101 00009C01
  'Offset  4812
  'PL0113 is compressed
  801C0018
  919F0598 9E0A9F09 9E0B9D0B 019C0A81 08C101C1 C2A1019C 9D0681A1 0481A201
  049E0132 31513112 81029E01 F1511102 9C021151 1102C202 011151F1 029B0131
  1103C1F1 31011151 03940111 C1F10492 11511102 C20A9205 92061202 3104C306
  C2029708 9B053203 01311304 029E0131 11F15111 01513101 5111019E 510112F1
  019E0111 02115211 01910211 01910191 52110198 01910611 01990191 04125211
  01910191 02910198 03115211 01910191 01960191 01910191 01910313 01910191
  01910196 01910791 019A0191 01910791 019C0191 01910191 01910191 0000009A
  'Offset  5040
  'PL0114 is compressed
  801C0018
  919F0598 9E0A9F09 9E0B9D0B 019C0A81 08C101C1 C2A1019C 9D0681A1 0481A201
  049E0132 31513112 81029E01 F1511102 9C021151 1102C202 011151F1 029B0131
  1103C1F1 31011151 03940111 C1F10492 11511102 C20A9205 92061202 3104C306
  C2029708 9B053203 01311404 0132029E 11F15111 12019E01 51110131 9C0211F1
  12511102 11521101 91019103 11029501 11021152 91031153 11039501 11041151
  91021152 91019501 91031103 91021202 95019101 91059101 95019108 91019101
  91019101 91069101 91019701 91019101 91019101 91029101 91019B01 91019101
  99019101 00000000
  'Offset  5276
  'PL0115 is compressed
  801C0018
  929F0598 22039E09 9D042101 21012204 23059D03 21059D04 C1039A05 8104990A
  01980AC1 07A103C1 980181C2 13078101 0181C201 01820398 01115312 9801A1C1
  01A1C302 1151F152 01A18101 F1C10198 01A181C1 1151F152 9801A101 C1F1C102
  53110181 01980412 1402A1C3 A1019705 A181C101 A202990A 03321101 039B0132
  01315212 01115131 0231019A 51F15111 52110131 029A0111 52F15111 51110231
  02980211 04125311 02960411 02125211 02940991 03115211 01910191 01910591
  01910192 02125111 01910191 01910191 01910191 02910192 01910213 01910191
  01910191 07940191 01910191 01910191 01910191 07910194 01910191 019A0191
  01910191 01910191 009C0191
  'Offset  5548
  'PL0116 is compressed
  801C0018
  929F0598 22039E09 9D042101 21012204 23059D03 21059D04 C1039A05 8104990A
  01980AC1 07A103C1 980181C2 13078101 0181C201 01820398 01115312 9801A1C1
  01A1C302 1151F152 01A18101 F1C10198 01A181C1 1151F152 9801A101 C1F1C102
  53110181 01980412 1402A1C3 A1019705 A181C101 A202990A 03321101 039B0132
  01315212 01115131 0191019C 11F15111 01511101 5111019E 510112F1 019E0111
  02115211 019E0211 06115211 5211019D 01910412 0291019A 03115211 01910191
  01910198 03130191 01910191 01910198 01910791 01910191 07910198 01910191
  0191019C 01910191 009A0191
  'Offset  5788
  'PL0117 is compressed
  801C0018
  929F0598 22039E09 9D042101 21012204 23059D03 21059D04 C1039A05 8104990A
  01980AC1 07A103C1 980181C2 13078101 0181C201 01820398 01115312 9801A1C1
  01A1C302 1151F152 01A18101 F1C10198 01A181C1 1151F152 9801A101 C1F1C102
  53110181 01980412 1402A1C3 A1019705 A181C101 A202990A 03321101 039B0132
  01315212 01115131 0112029C 31F15111 13019E01 F1511101 029C0211 01125111
  03115211 52110299 53110211 02980211 04115112 03115211 03910196 02910212
  01910312 07910194 01910791 01940191 01910191 01910191 01910591 01960191
  01930191 01910191 01910391 019C0191 01910191 01910191 00000095
  'Offset  6044
  'PL0118 is compressed
  801C0018
  9F9F9F9F 959F0196 9F019102 049F0495 219D0392 22012102 9C032101 91022303
  05980321 09210121 C1A12196 D1062203 019602C1 0321D1A1 21C20522 81219501
  01220A22 9301A1C1 C1A18101 91210A21 01A1D101 41810193 043301D1 D1C10332
  02930121 513201C2 01315134 21C1D2C1 A1019401 310121C1 3154D151 41D1C101
  942101A1 21C1A121 F1513101 C2013154 01210121 A2013194 32543201 01A12101
  05219622 9A042134 05320122 9C210132 15511101 91021151 11019A01 521351F1
  01910111 F111019A 11031151 91011152 11019801 1151F151 12521103 96019101
  11531101 12019103 96011251 12511102 91019202 11511201 12029502 91019403
  95021202 91019705 00009205
  'Offset  6316
  'PL0119 is compressed
  801C0018
  9F9F9F9F 989F9F9F 01969F01 969F0191 04919F03 029E0391 01220121 049A0392
  01980823 012102A1 A1C10521 22059702 02A1C106 C1A10196 A2072204 A1019501
  C1A10CC1 019501A1 A101C1A1 01110511 02A1C1A2 01A20196 53F15111 C1A10111
  019101A1 54120397 01A20111 04990191 01910414 01990191 01110512 01910191
  F111019A 11511351 9C019101 1151F111 11511103 9A019101 51F15101 51110311
  01910112 52110198 01910311 01125111 04110298 02120393 05970597 04980398
  979F9F9F 00000000
  'Offset  6520
  'PL011A is compressed
  801C0018
  9F9F9F9F 9F9F9F9F 9F9F9F9F 919F9F9F 06949F03 9C0B919F C109C101 9A0E9A01
  01C1A101 03110411 019A01C1 511101A1 011152F1 9B01A1C2 11531202 9D01A201
  91041303 11019C01 511251F1 01910111 F111019C 11021151 9D011151 11021401
  9B011251 9A069206 9B049604 9F029802 9F9F9F9F 00009C9F
  
End CSub
