  '=============================================================================|
  ' PicoRocks in Space - Teaser
  '
  ' written by Vegipete, Jan 2024
  ' Ported from CMM2 (somewhat)
  '
  ' needs:
  ' OPTION CPUSPEED 252000 (KHz)
  
  '=============================================================================
  ' Versions
  ' rocks1      adapt VegiPete version to 640x80, copy some from CMM2 version
  ' rocks2      fly the ship
  ' rocks3      fire gun, detect asteroid hit
  ' rocks4      hit asteroids, split when hit, clear keyboard buffer
  ' rocks5_MH   MartinH changes, Fleet shown, respawn
  ' rocks6      much research about shooting,, nothing new
  ' rocks7      initial scores, initial levels
  ' rocks8      adapt to official arcade rules
  ' rocks9      UFO's essential implemented, lacking finesse and aiming(small ufo)
  
  
  
  Option DEFAULT INTEGER
  Option LCDPANEL NOCONSOLE
  option angle degrees
  mode 1:cls 0:font 10
  
  'Iinit NES-Controller on port DB9 of PicoGameVGA
  Const NES_PULSE!  = 0.012   ' 12uS
  Const NES_A_CLOCK = MM.Info(PinNo GP3)
  Const NES_A_LATCH = MM.Info(PinNo GP2)
  Const NES_A_DATA  = MM.Info(PinNo GP1)
  SetPin NES_A_CLOCK, DOut
  SetPin NES_A_LATCH, DOut
  SetPin NES_A_DATA,  DIn
  NES_Ctrl=0
  
  'game initialisation, array init default with 0
  const MAXROCKS = 26         ' arcade rule, was 50
  dim float rock(MAXROCKS,7)  ' rocks: scale,angle,x,y,vx,vy,a,da
  dim trock (MAXROCKS)        ' type of rock
  dim float v(1)              ' for math
  dim float pv,px,py,pvx,pvy  ' ship parameter
  
  ' rock vector shapes
  ' Note: any resemblance to a country is purely coincidental
  dim r1x(14)=( 0, 3, 4, 3, 5, 4, 1,-2,-4,-5,-3,-5,-3,-2, 0)
  dim r1y(14)=( 5, 4, 3, 1, 0,-4,-5,-4,-4,-1,-1, 2, 3, 5, 5)
  dim r2x(14)=( 0,-2,-3,-4,-5,-4,-4,-3,-1, 4, 4, 5, 4, 2, 0)
  dim r2y(14)=(-6,-4,-3,-4,-1, 2, 3, 3, 5, 3, 1, 0,-3,-4,-6)
  dim r3x(14)=( 1,-2,-2,-4,-4,-5,-5,-3,-2, 0, 4, 3, 5, 3, 1)
  dim r3y(14)=(-4,-5,-3,-4,-2, 0, 3, 4, 3, 5, 3, 2, 1,-5,-4)
  dim r4x(14)=( 0,-2,-4,-4,-5,-3,-1, 2, 1, 3, 5, 3, 4, 3, 0)
  dim r4y(14)=(-5,-4,-4,-1, 1, 4, 5, 5, 3, 4, 1,-2,-3,-4,-5)
  
  ' ufo data
  dim ufo(4)    ' type 0/1/2,xpos, ypos, xvel, yvel, ' ufo data
  dim bufo(2,4) ' life left, xpos, ypos, xdir, ydir,  ' ufo shot info
  'UFO shape
  dim ux(11)=( 2,-2,-6,-2, 2, 6,-6, 6, 2, 2,-2,-2)
  dim uy(11)=(-4,-4, 0, 4, 4, 0, 0, 0,-4,-6,-6,-4)
  
  'Javavi artwork alternative
  'Dim r1x(14)=( 5, 5, 1,-1, 4, 5, 5,-5,-5,-1, 1,-4,-5,-5, 5)  'Z
  'Dim r1y(14)=( 5, 3, 0,-3,-3,-2,-5,-5,-3, 0, 3, 3, 2, 5, 5)
  'Dim r2x(14)=( 0, 4, 5, 4, 0, 0,-3, 0, 3, 0, 0,-4,-5,-4, 0)  'O
  'Dim r2y(14)=( 5, 4, 0,-4,-5,-4, 0, 4, 0,-4,-5,-4, 0, 4, 5)
  'Dim r3x(14)=( 1, 3, 2, 5, 5, 2, 1,-1,-2,-5,-5,-2,-3,-1, 1)  'V
  'Dim r3y(14)=(-2, 3, 5, 5, 3,-4,-5,-5,-4, 4, 5, 5, 3,-2,-2)
  'Dim r4x(14)=( 1, 2, 5, 5, 2, 2, 5, 5, 3,-3,-5,-5,-3,-3, 1)  'T
  'Dim r4y(14)=( 5, 3, 3, 2, 2, 0,-1,-3,-5,-5,-3, 0, 0, 5, 5)
  '
  
  ' player ship and exhaust flame shapes @Volhout *2
  dim shpx(4)=(0,-6,0,6,0)
  dim shpy(4)=(-10,10,6,10,-10)
  dim flmx(4)=(0,-2,0,2,0)
  dim flmy(4)=(8,10,14,10,8)
  
  FRAMEBUFFER Create   ' hidden layer to draw scene
  FRAMEBUFFER Write F : CLS
  
  ph = 0 : pv = 0
  px = MM.HRES/2-6 : pvx = 0
  py = MM.VRES/2-6 : pvy = 0
  
  smash=0             'are you hit ?
  newrun=0            '1
  fire=0              'are you firing bullets
  
  timeout=2000        'respawn time out
  
  score=0             'start with 0
  level=1             'game level (determies how many new rocks)
  
  ships=5             'to start with 5 ships
  buls=4              'arcade rule: max 4 bullets on screen
  bspd=5              'bullet speed
  dim bult(buls,4)    'n bullets (exist,x,y,velx,vely)
  
  'copied from CMM2 sound
  play modfile "RISsound.mod"
  
  newrocks(min(2*level+2,11))  'arcade rule 4,6,8,10,11,11,11...
  
  mot = timer 'motor on timer
  
  do
    tm=timer
    
    'handling for NES controller
    NES_Ctrl=Reading_NES_Ctrl()
    If NES_Ctrl And 1 Then fire=1:DrawFire:Play modsample 3,1
    If NES_Ctrl And 16 Then Inc pvx,Sin(ph)/2:Inc pvy,-Cos(ph)/2:Play modsample 9,2:mot=Timer+200
    If NES_Ctrl And 64  Then Inc ph,-5:If ph<0 Then ph=355
    If NES_Ctrl And 128 Then Inc ph,5:If ph>355 Then ph=0
    'if....then end
    
    'handling for keyboard
    do
      k=e:e=asc(inkey$)
    loop until e=0
    
    if k then
      burn = 0
      select case k
        Case 128  ' up
          inc pvx, sin(ph)/2
          inc pvy,-cos(ph)/2
          Play modsample 9,2  ' @Martin
          mot = timer + 200   ' keep flame visible for a while
        Case 130  ' left
          inc ph,-5
          if ph < 0 then ph = 355
        Case 131  ' right
          inc ph,5
          if ph > 355 then ph = 0
        case 32 'space for fire '102 'f'for fire
          fire=1:DrawFire
          Play modsample 3,1'@Martin
        case 27
          print : end
      end select
    endif
    
    'progress ship
    Inc px,pvx-(MM.HRes+10)*(px > MM.HRes)+(MM.HRes+10)*(px<5)  '@Martin
    Inc py,pvy-(MM.VRes+10)*(py > MM.VRes)+(MM.VRes+10)*(py<0)  '@Martin
    
    ' velocity decays away slowly
    pvx = pvx * .99 '@Volhout .995
    pvy = pvy * .99 '@Volhout .995
    
    'UFO creation
    if ufo(0)=0 then
      ufo(0)=(rnd < 0.01) 'once in a while creat a random ufo
      if ufo(0) then
        ufo(0)=1+int(rnd*2)
        ufo(1)=rnd*MM.HRES:ufo(2)=rnd*mm.vres
        ufo(3)=rnd*ufo(0):ufo(4)=rnd*ufo(0)
      end if
    end if
    
    ' move ufo
    if ufo(0) then
      inc ufo(1),ufo(3):ufo(1)=(ufo(1)+mm.hres) mod mm.hres
      inc ufo(2),ufo(4):ufo(2)=(ufo(2)+mm.vres) mod mm.Vres
      'ufo fire
      if (rnd < 0.01) then 'once every 2-5 seconds
        UfoFire
      end if
    end if
    
    ' move rocks
    for i = 0 to MAXROCKS
      if trock(i) then   ' rock exists
        
        'move rocks and keep in window
        inc rock(i,2),rock(i,4)
        rock(i,2)=(rock(i,2)+mm.hres) mod mm.hres 'original
        'Inc rock(i,2),-MM.HRes*(rock(i,2)>MM.HRes)+MM.HRes*(rock(i,2)<0)'@Martin
        inc rock(i,3),rock(i,5)
        rock(i,3)=(rock(i,3)+mm.vres) mod mm.Vres ' original
        'Inc rock(i,3),-MM.VRes*(rock(i,3)>MM.VRes)+MM.VRes*(rock(i,3)<0)'@Martin
        
        'move bullets and check if something is hit
        for j = 0 to buls
          ' test for player bullet hitting asteroid
          if bult(j,0) then ' does this bullet exist?
            
            'move it, when off-screen then skip bullet
            inc bult(j,1),bult(j,3)
            if bult(j,1)>MM.HRES or bult(j,1)<0 then bult(j,0)=0
            inc bult(j,2),bult(j,4)
            if bult(j,2)>MM.VRES or bult(j,2)<0 then bult(j,0)=0
            
            'check for hit
            v(1) = bult(j,1) - rock(i,2) 'x coordinate compare
            v(0) = bult(j,2) - rock(i,3) 'y coordinate compare
            if math(magnitude v()) < 5*rock(i,0) then
              AstHit(i,j)
              continue for
            endif
          endif
        next
        
        if (smash = 0) and (newrun = 0) then
          ' test for asteroid hit player ship
          v(0) = px - rock(i,2) '@Volhout
          v(1) = py - rock(i,3) '@Volhout
          if math(magnitude v()) < 10 + 5*rock(i,0) then
            print "hit" 'debug
            smash = 1
            ships=max(0,ships-1)
            'sprd = 5    ' start the debris field
            play modsample 6,4              ' player explosion
            thit=timer                      ' for respawn delay
            'new start location = centre
            px = MM.HRES/2-6 : pvx = 0
            py = MM.VRES/2-6 : pvy = 0
            AstHit(i,0) 'damage to asteroid also
            continue for
          endif
        endif
        
        'test for asteroid hit ufo
        v(0) = ufo(1) - rock(i,2) '@Volhout
        v(1) = ufo(2) - rock(i,3) '@Volhout
        if math(magnitude v()) < 6*ufo(0) + 5*rock(i,0) then
          ufo(0)=0:AstHit(i,0)
        end if
        
        'test for bullet hit ufo
        for j = 0 to buls
          if bult(j,0) then ' does this bullet exist?
            if abs(bult(j,1)-ufo(1))<6*ufo(0) then
              if abs(bult(j,2)-ufo(2))<6*ufo(0) then
                inc score,1000/ufo(0) '500 for large ufo, 1000 for small one
                ufo(0)=0
                exit for
              end if
            end if
          end if
        next
        
      endif
    next i
    
    'check win
    if math(sum trock())=0 then math set 0,bult()
    
    cls
    DrawShip
    DrawRocks
    DrawBullet
    DrawFleet
    DrawUfo
    Box 0,0,640,480,,0:text 0,0,str$(score,6,0)
    text 630,0,str$(timer-tm,3,0),R '@Volhout game loop time in ms
    FRAMEBUFFER copy F,N,B
    
  loop
  
  
sub AstHit(n,m)
  local i,x,y
  print "astroid ";n;" hit" 'debug
  
  'rock sizes 6,4,2 give 20,50,100 points arcade rules
  inc score,20*(7-rock(n,0))    'progressives scores
  Play modsample 6,3
  
  'handle bullet
  bult(m,0)=0 'bullet does not fly any further
  
  'handle rock
  if rock(n,0)<3 then
    
    trock(n)=0  'remove from game play
    if math(sum trock())=0 then
      inc level,1
      newrocks(min(2*level+2,11))
    end if
    
  else
    'split the asteroid in 2 equal pieces half the size
    
    'rock n modify
    rock(n,0) = max(rock(n,0)-2,2)    'next size down
    x=rock(n,4):y=rock(n,5)           'temp copy
    rock(n,4) = -cos(bult(m,3))+x     'new x velocity
    rock(n,5) = -sin(bult(m,3))+y     'new y velocity
    
    'find a slot for the second asteroid
    for i = 0 to MAXROCKS                     'find second free slot
      if trock(i)=0 then
        'rock i is the new ones
        trock(i) = trock(n)           'same type of asteroid
        rock(i,0) = rock(n,0)         'both same size
        rock(i,2) = rock(n,2)         'x location
        rock(i,3) = rock(n,3)         'y location
        rock(i,4) = cos(bult(m,3))+x  'new x velocity
        rock(i,5) = sin(bult(m,3))+y  'new y velocity
        rock(i,6) = rnd*360           'starting angle random
        rock(i,7) = rock(n,7)         'rotation speed
      end if
      exit for
    next
  end if
end sub
  
  
sub DrawBullet
  local i
  for i=0 to buls
    'if bult(i,0) then pixel bult(i,1),bult(i,2)
    if bult(i,0) then box bult(i,1),bult(i,2),2,2
  next
end sub
  
sub DrawUfo
  local x(11),y(11)
  if ufo(0) then
    math scale ux(),ufo(0),x()  'can be 1 or 2
    math scale uy(),ufo(0),y()
    math add x(),ufo(1),x()     'position ship
    math add y(),ufo(2),y()
    polygon 12,x(),y()
  end if
end sub
  
sub DrawShip
  local x(4),y(4)
  if smash=1 then
    if timer-thit>timeout then smash=0  'you can fly again
  else
    'off = (mot > timer) * 6624
    'this is the ship
    math scale shpx(),1,x()
    math scale shpy(),1,y()
    math v_rotate 0,0,ph,x(),y(),x(),y()
    math add x(),px,x()  ' position ship
    math add y(),py,y()
    polygon 5,x(),y()
    'this is the exhaust flame
    if mot > timer then
      math scale flmx(),1,x()
      math scale flmy(),1,y()
      math v_rotate 0,0,ph,x(),y(),x(),y()
      math add x(),px,x()  ' position rocket flame
      math add y(),py,y()
      polygon 5,x(),y()
    endif
  end if
end sub
  
sub DrawFleet
  local x(4),y(4),i,textx=30,texty=30,textw=16
  math add shpx(),textx,x()
  math add shpy(),texty,y()
  for i=1 to ships,x(),y()
    polygon 5,x(),y()
    math add x(),textw,x()
  next
end sub
  
  ' Go through the list of rocks and draw any that exist
sub DrawRocks
  local i
  local x(14),y(14)
  
  for i = 0 to MAXROCKS
    if trock(i) then   ' rock exists
      inc rock(i,6),rock(i,7) ' spin rock
      if rock(i,6) > 360 then inc rock(i,6),-360
      if rock(i,6) < 0 then inc rock(i,6),360
      
      select case trock(i) ' what shape of rock is it?
        case 1
          math scale r1x(),rock(i,0),x()
          math scale r1y(),rock(i,0),y()
        case 2
          math scale r2x(),rock(i,0),x()
          math scale r2y(),rock(i,0),y()
        case 3
          math scale r3x(),rock(i,0),x()
          math scale r3y(),rock(i,0),y()
        case 4
          math scale r4x(),rock(i,0),x()
          math scale r4y(),rock(i,0),y()
      end select
      math v_rotate 0,0,rock(i,6),x(),y(),x(),y()
      math add x(),rock(i,2),x()  ' position rock
      math add y(),rock(i,3),y()
      polygon 15,x(),y()
    endif
  next i
end sub
  
sub DrawFire
  local i
  if fire then
    for i=0 to buls
      if bult(i,0)=0 then
        bult(i,0)=1:bult(i,1)=px:bult(i,2)=py
        bult(i,3)=bspd*sin(ph):bult(i,4)=-bspd*cos(ph)
        fire=0:exit for
      end if
    next
  end if
end sub
  
sub UfoFire 'use bullet buffer to include ufo bullet
  local i,p
  for i=0 to buls
    if bult(i,0)=0 then
      p=rnd*360
      bult(i,0)=1
      bult(i,3)=bspd*sin(p):bult(i,4)=bspd*cos(p)   'random direction
      bult(i,1)=ufo(1)+(ufo(0)+1)*bult(i,3)   'prevent ufo shooting itself
      bult(i,2)=ufo(2)+(ufo(0)+1)*bult(i,4)
      exit for
    end if
  next
end sub
  
sub newrocks(n)
  ' create n large rocks as start
  local k = 1
  for i = 1 to n
    trock(i)  = 1 + (k and 3) ' rock type (0=doesn't exist)
    rock(i,0) = 6             ' arcade rule: max rock size
    do  'initial place rocks 100 pix away from ship
      rock(i,2) = rnd*MM.HRES   ' x location
      rock(i,3) = rnd*MM.VRES   ' y location
    loop while ((rock(i,2)-MM.HRES/2)^2 + (rock(i,3)-MM.VRES/2)^2)<100*100
    rock(i,4) = 1-rnd*2   ' x velocity
    rock(i,5) = 1-rnd*2   ' y velocity
    rock(i,6) = rnd*360   ' starting angle
    rock(i,7) = 3-rnd*6   ' rotation speed
    inc k
  next
end sub
  
Function Reading_NES_Ctrl()
  Local bits, i
  Pulse NES_A_LATCH, NES_PULSE!
  For i = 0 To 7
    If Not Pin(NES_A_DATA) Then bits=bits Or 2^i
    Pulse NES_A_CLOCK, NES_PULSE!
  Next
  Reading_NES_Ctrl=bits
End Function
  
  ' asteroids16
  ' Font type    : Full (64 Characters)
  ' Font size    : 16x16 pixels
  ' Memory usage : 2048
DefineFont #10
  40201010
  0000000000000000000000000000000000000000000000000000000000000000
  0002000200020002000200020002000200020002000000000002000200000000
  2008200820082008401040100000000000000000000000000000000000000000
  00000000100810081008FC3F1008100810081008FC3F10081008100800000000
  800080008008FC0780108010F007800808010801F03F00010003000300000000
  0030003030CC30CCC030C03000030003300C300CCC30CC303000300000000000
  000F000FC030C030003000300C0F0C0FCC30CC3030303030CC0FCC0F00000000
  C000C000C000C000000300030000000000000000000000000000000000000000
  C000C00000030003000C000C000C000C000C000C00030003C000C00000000000
  000C000C00030003C000C000C000C000C000C00000030003000C000C00000000
  000000000003000330333033C00FC00F30333033000300030000000000000000
  000000000003000300030003F03FF03F00030003000300030000000000000000
  00000000000000000000000000000000000000000003000300030003000C000C
  000000000000000000000000F03FF03F00000000000000000000000000000000
  0000000000000000000000000000000000000000000300030003000300000000
  0C000C0030003000C000C00000030003000C000C0030003000C000C000000000
  0420FC3F0420042004200420042004200420042004200420FC3F042000000000
  8000800080008000800080008000800080008000800080008000800000000000
  0400FC3F04000400040004000020FC3F0020002000200020FC3F002000000000
  0400FC3F04000400040004000400FC3F0400040004000400FC3F040000000000
  0420042004200420042004200400FC3F04000400040004000400040000000000
  0020FC3F00200020002000200400FC3F0400040004000400FC3F040000000000
  0020002000200020002000200420FC3F0420042004200420FC3F042000000000
  0400FC3F04000400040004000400040004000400040004000400040000000000
  0420FC3F0420042004200420FC3F04200420042004200420FC3F042000000000
  0420FC3F0420042004200420FC3F042004000400040004000400040000000000
  0000000000030003000300030000000000000000000300030003000300000000
  00000000000300030003000300000000000000000003000300030003000C000C
  00000000F000F000000F000F00300030000F000FF000F0000000000000000000
  0000000000000000FC3FFC3F00000000FC3FFC3F000000000000000000000000
  00000000000F000FF000F0000C000C00F000F000000F000F0000000000000000
  F00FF00F0C300C300C000C00F000F00000030003000000000003000300000000
  F00FF00F0C300C30CCC3CCC3CCCCCCCCF0C3F0C300300030F00FF00F00000000
  400180001004200204100808041004100410FC1F041004100410041000000000
  1020E03F04200820082004201020F03F0420082008200420E03F102000000000
  0020FC3F0020002000200020002000200020002000200020FC3F002000000000
  4020803F1020202004200820042004200820042020201020C03F402000000000
  0020FC3F00200020002000200020F03F0020002000200020FC3F002000000000
  0020FC3F00200020002000200020F03F00200020002000200020002000000000
  0420FC3F04200420002000200020002004207C2004200420FC3F042000000000
  0420042004200420042004200420FC3F04200420042004200420042000000000
  0001F83F0001000100010001000100010001000100010001F83F000100000000
  100010001000100010001000100010001000100010101020F007100800000000
  8020402000220021002800240028003000220024802000212020402000000000
  002000200020002000200020002000200020002000200020F03F002000000000
  0C30042024241428842144220420042004200420042004200420042000000000
  043004200424042804210422442084201420242004200C200420042000000000
  0420FC3F0420042004200420042004200420042004200420FC3F042000000000
  0420FC3F04200420042004200020FC3F00200020002000200020002000000000
  1020F03F102010201020102010201020102110224020A020103FA02000000000
  0420FC3F04200420042004200021FC3F40208020102020200420082000000000
  0020FC3F00200020002000200400FC3F0400040004000400FC3F040000000000
  0001F83F00010001000100010001000100010001000100010001000100000000
  102010201020102010201020102010201020102010201020F03F102000000000
  081004201008100820081008200420042004200440024002C003400200000000
  04200420042004200420042004200420442284211428242404200C3000000000
  0840048020101020800440080003000340088004102020100480084000000000
  1010082040042008000180020001000100010001000100010001000100000000
  0400FC3F1000080040002000000180000004000200100008FC3F002000000000
  C00FC00F000C000C000C000C000C000C000C000C000C000CC00FC00F00000000
  00C000C000300030000C000C00030003C000C000300030000C000C0000000000
  C00FC00FC000C000C000C000C000C000C000C000C000C000C00FC00F00000000
  00030003C00CC00CC00CC00C3030303000000000000000000000000000000000
  00000000000000000000000000000000000000000000000000000000FFFFFFFF
End DefineFont
