  'FC2 = frequency counter 2
  
  'idea from Bert elemmens to increase accuracy frequency measurement
  'at start gate, wait for first edge, then start gate', and count pulses.
  'at end gate, wait for next edge, then stop gate', and stop counting
  'measure pulse width gate'
  'frequency = count / gate' time
  'period = gate' time / count
  'this should not jitter
  
  'current assignment
  'gp0 = count input
  'gp1 = gate pulse
  'gp2 = gate'pulse
  
  '-------------------------- version history ------------------------------
  'v00              'gate pulse works
  'v01              'pulse measurement from gate' pls works
  'v02              'counter works (not calibrated)
  
  debug=1'0         'do you want debug output ?
  
  
  '-------------------------- system setup --------------------------------
  
  assemble 1        'assemble the code in PIO 1
  configPio 1       'configure PIO 1 state machines
  
  
  
  '----------------------------- main --------------------------------------
  gate_time = 0.2                     'seconds
  gate_clocks% = gate_time*f2 - 1     'for 1MHz PIO 1.2 clock as integer (n counts (n-1...0)
  puls_tick!=2/f0
  dim altgate%(4)
  dim cntr%(4)
  
  do
    'put gate time in PIO 1.2 OSR (gate_time is specified in PIO cycles: gate_clocks%)
    PIO write 1,2,1,gate_clocks%      'this starts the gate pulse generator, single pulse
    pause 300                         'wait for end of gate pulse
    
    'read what the PIO reads from gate'
    pio read 1,0,5,altgate%()

    'read what the PIO reads from counter
    pio read 1,3,5,cntr%()

    'show period and frequency
    print altgate%(4)*puls_tick!/cntr%(3);" seconds period",
    print cntr%(4)/(altgate%(3)*puls_tick!);" Hz frequency"
    
    pause 200
  loop
  
  
end
  
  
  
  '----------------------------- subs --------------------------------------
  'this configures the state machines for PIO n
Sub configPio(p)
  
  if p=1 then
    setpin gp0,pio1
    setpin gp1,pio1
    setpin gp2,pio1
  else
    setpin gp0,pio0
    setpin gp1,pio0
    setpin gp2,pio0
  end if
  
  'stop all PIO's
  PIO stop p,0: PIO stop p,1: PIO stop p,2: PIO stop p,3
  
  'PIO state machine configurations
  
  'PIO p.0 (measure pulse from GP2)
  f0=63e6                                       '63 MHz frequency
  e0=Pio(execctrl gp2,puls_target,puls_wrap)    'GP2 is jump pin
  p0=Pio(pinctrl 0,,,GP2,,,)                    'GP2 is input pin
  '
  'If func=1 Then
  ''PIO 1.1 (measure pulse width from GP0) in case pulse width is selected
  'f1=63e6                               '63 MHz frequency
  'e1=Pio(execctrl gp0,5,&h0A)             'GP0 is PIN for cond jmp. wrap target 7, wrap &h0C
  'p1=0                                  'default value
  'PIO init machine 1,1,f1,p1,e1,0,7     'start at 7
  'Else
  ''PIO 1.1 (frequency B from GP1 in case frequency ratio is selected)
  'f1=63e6                               '63 MHz frequency
  'e1=Pio(execctrl gp2,&h18,&h1F)          'GP2 is PIN for cond jmp. wrap target &h18, wrap &h1F
  'p1=Pio(pinctrl 1,,,gp1,gp4,,)         'GP1 base for inputs, GP4 out for SIDE SET
  'PIO init machine 1,1,f1,p1,e1,0,&h18  'start at &h18
  'EndIf
  
  'PIO p.2 (gate pulse)
  f2=1e6                                        '1 MHz frequency gate resolution
  e2=Pio(execctrl gp0,gate_target,gate_wrap)    'GP0 is dummy, not used
  p2=Pio(pinctrl 1,1,,,gp1,gp1,)                'GP1 set and side set GATE puls
  
  'PIO 1.3 (frequency A from GP0)
  f3=63e6                                       '63 MHz frequency
  e3=Pio(execctrl gp1,count_target,count_wrap,0,1)  'GP1 = cond jmp, side_set ena option
  p3=Pio(pinctrl 2,1,,gp0,gp2,GP2,)             'GP0 input, GP2 for SIDE SET and SET
                                                '2 = side enable + side set pins

  'Start all PIO sequencers
  PIO init machine p,0,f0,p0,e0,0,puls_start
  PIO start p,0                       'this will start pulse measurement from GP2
  
  '  PIO start p,1 'depending selection will start pulse measurement GP0 or frequency GP1
  
  PIO init machine p,2,f2,p2,e2,0,gate_start
  PIO start p,2                       'wait for datain FIFO, then generate 1 gate
  
  PIO init machine p,3,f3,p3,e3,0,count_start   
  PIO start p,3                       'start counter, count while GP1 low
  
End Sub
  
  
  
  'this sub assmebles the different PIO routines
sub assemble (n)
  
  ass$=choice(debug=1,".end program list",".end program")
  
  'measure positive pulse, used for gate' time
  'require IN and JMP pin to be set equal to the gate' pin
  pio assemble n,".program pulse"
  pio assemble n,".line 0"
  pio assemble n,".wrap target"
  pio assemble n,"mov x,!null"          'x=ffffffff
  pio assemble n,"wait 1 pin 0"         'wait for pin to go high
  pio assemble n,"cnt:"                 'label
  pio assemble n,"jmp x-- always"       'decrement x, and always go to the next instruction
  pio assemble n,"always:"              'label
  pio assemble n,"jmp pin cnt"          'while 1 jmp to cnt:
  pio assemble n,"mov isr,!x"           'copy inverted value to isr
  pio assemble n,"push noblock"         'push in fifo
  pio assemble n,".wrap"
  pio assemble n,ass$
  
  puls_start=0
  puls_target=pio(.wrap target)
  puls_wrap=pio(.wrap)
  if debug then print puls_start,puls_target,puls_wrap
  
  
  'create gate pulse for frequency measurement
  'uses side set 1 to control gate (gate' is controlled from counter)
  'set and side set must point to the same pins
  'gate is active low, gate' is active high
  pio assemble n,".program gate"
  pio assemble n,".line 6"
  pio assemble n,".side_set 1"          '1 side set bit
  pio assemble n,"set pindirs,1"        'gate pulse set output
  pio assemble n,".wrap target"         'return here
  pio assemble n,"pull block side 1"    'get new gate time from MMBasic, then set gate
  pio assemble n,"mov x,osr side 1"     'get value into counter
  pio assemble n,"count:"               'label
  pio assemble n,"jmp x-- count side 0" 'count down while not 0, gate high
  pio assemble n,".wrap"                'endless loop
  pio assemble n,ass$
  
  gate_start=6
  gate_target=pio(.wrap target)
  gate_wrap=pio(.wrap)
  if debug then print gate_start,gate_target,gate_wrap
  
  'count pulses
  'uses side set 2 to control gate' and no-signal... gate' and no_count are same signal
  'set and side set base must point to the same pins
  'todo: add no-count via SET second bit
  pio assemble n,".program count
  pio assemble n,".line 10"
  pio assemble n,".side_set 1 opt"      'side set bits + option
  pio assemble n,"set pindirs,1"        'gate' set output and low
  pio assemble n,".wrap target"         'return here
  pio assemble n,"mov x,!null side 0"   'x=ffffffff, gate' low, no_count low
  pio assemble n,"wait:"                'label
  pio assemble n,"jmp pin wait"         'wait until gate opens (active low)
  pio assemble n,"countup:"             'label
  pio assemble n,"wait 0 pin 0"         'wait until count in low
  pio assemble n,"wait 1 pin 0"         'wait until count in high
  pio assemble n,"jmp pin ready side 1" 'set gate' and check if gate ready
  pio assemble n,"jmp x-- countup"      'count down while not 0, gate high
  pio assemble n,"ready:"               'label
  pio assemble n,"mov isr,!x side 0"    'copy inverted value to isr, gate' low
  pio assemble n,"push noblock"         'push in fifo
  pio assemble n,".wrap"                'endless loop
  pio assemble n,ass$
  
  count_start=10
  count_target=pio(.wrap target)
  count_wrap=pio(.wrap)
  if debug then print count_start,count_target,count_wrap
  
end sub
