'test HW for sine wave generator using DMA and PIO
'there is a flaw: the DMA stops after 2^32 sine samples

'this is running in basic
bits% = 8
length% = 4096          'allows up to 16kHz full resolution
'Dim o%(length%-1)
level=2^(bits%-1)*0.9   'amplitude of sine signal

'calculate sinewave table
'calc_sin

'pack data in ring buffer
Dim pkd%
PIO make ring buffer pkd%,length%*8  'length in 32 bit fifo values
'PIO make ring buffer pkd%,length%*4  'length in 32 bit fifo values
'PIO make ring buffer pkd%,length%     'length in 8 bit fifo values

'pio pins
SetPin gp6,pio1
SetPin gp7,pio1
SetPin gp8,pio1
SetPin gp9,pio1
SetPin gp10,pio1
SetPin gp11,pio1
SetPin gp12,pio1
SetPin gp13,pio1

'pio program
PIO assemble 1,".program out"
PIO assemble 1,".line 0"
PIO assemble 1,"mov osr ,!null" 'fill osr with &hffffffff
PIO assemble 1,"out pindirs,8"  'set all associated pins (8) output
PIO assemble 1,".wrap target"
PIO assemble 1,"pull noblock"   'get data from fifo
PIO assemble 1,"out pins,8"     'write out to 7(8) pins
PIO assemble 1,"out pins,8 [1]" 'write out to 7(8) pins delay 1 --- 8bit transfers only
PIO assemble 1,"out pins,8 [1]" 'write out to 7(8) pins delay 1 --- 8bit transfers only
PIO assemble 1,"out pins,8 [1]" 'write out to 7(8) pins delay 1 --- 8bit transfers only
PIO assemble 1,".wrap"
PIO assemble 1,".end program"' list"

'pio config
f=133e6               'modify this value to tune to other frequencies

p=Pio(pinctrl 0,0,bits%,,,,gp6)
e=Pio(execctrl gp0,Pio(.wrap target),Pio(.wrap))
s=Pio(shiftctrl 0,0,0,0,0,1)


'here we do UI and create sine waves
Do
  'input frequency
  Input "what frequency ";x
  y%=1+x/16000            'y%=number of sine cycles in one buffer
  f=x*2*length%/y%
  Print x,y%,f
  'Timer = 0

  'stop running machine
  If MM.Info(PIO TX DMA)=1 Then PIO dma tx off

  'calculate sinewave table
  'calc_sin
  'Memory pack o%(),pkd%(),length%,32   'fill it with values from the sine wave 32 bit
  'Memory pack o%(),pkd%(),length%,8     'fill it with values from the sine wave 8 bit
  calc_sin_pkd

  'restart machine
  PIO init machine 1,0,f,p,e,s,0
  PIO dma tx 1,0,&hffffffff,pkd%(),help,,length% '32 bit transfers
  'PIO dma tx 1,0,&hffffffff,pkd%(),help,,length%/4 '8 bit transfers
Loop
End



Sub help
  'Print "stopped after ";Timer;" ms"
  PIO stop 1,0
End Sub



Sub calc_modsin
'calculate sinewave table
For i=0 To length%-1
  alpha=i*2*Pi/length%
  o%(i)=Int(level*(1.1+(Sin(y%*alpha))*Sin(alpha)*Sin(alpha)))
Next
End Sub

Sub calc_sin
'calculate sinewave table
For i=0 To length%-1
  o%(i)=Int(level*(1.1+Sin(y%*i*2*Pi/length%)))
Next
End Sub

Sub calc_sin_pkd
'calculate sinewave table directly in pkd%()
For i=0 To length%-1
  pkd%(i)=0
  For j=0 To 3
    pkd%(i)=pkd%(i)+(Int(level*(1.1+Sin(y%*(i*4+j)*2*Pi/length%))))<<(j*8)
  Next j
Next i
End Sub


End
