  'GP26 audio spectrum analyzer VGA
  
  hist=0    'plot as histogram=1, graph=0
  fillit=1  'aurorange=1
  
  'ping-pong ADC and calculate RMS value and fft
  'runs on picomite VGA in mode 1 (640x480 monochrome)
  framebuffer create
  framebuffer write f
  tile 0,0,rgb(green),0,80,40
  color rgb(yellow)
  
  'system parameters
  Option base 1
  n=512                     'samples
  Dim a(n),b(n)             'ping pong buffers
  Dim c(n),d(n)             'processing buffer
  dim e(n/2)                'just for output lower half the fft
  e_addr%=peek(varaddr e()) 'adresses for fast copy
  d_addr%=peek(varaddr d())
  
  
  'hardware parameters
  offset = -1.66          'hardware default
  freq = 10000             'ADC sampling frequency
  
  'test signal generated from PWM
  'SetPin gp0,pwm
  'PWM 0,50,50            '50Hz, 50% d.c.
  
  'test signal from audio output
  'play tone 2000,2000  'sine wave 1Vrms
  play sound 1,B,Q,600  'square wave 0.33Vrms
  PLAY SOUND 2,R,N,10   'add noise
  
  'open the ADC and start first conversion
  'SetPin gp26,ain
  ADC OPEN freq,1,INT_RDY
  ready=0:pingpong=1
  ADC START a()
  
  'main routine
  Do
    'every n/freq a new buffer is filled with samples and ready flag raised
    'we have time to process the data. Using math commands we gain time
    'rms is 4ms/512 samples, fft = 44ms/512 samples, plotting the graph consumes most time
    
    If ready Then
      
      'timing information for debuf
      text 0,0,str$(timer,3,0)
      timer=0
      
      If pingpong Then
        MATH ADD b(),offset,c()
      Else
        MATH ADD a(),offset,c()
      EndIf
      ready=0
      
      'determine vertical scale
      sc=(MM.VRES-10)/n
      wdth=Int(MM.HRES/(n/2))
      
      'calculate rms from an array
      rms = Math(SD c())               'math(sd a()) does all the math to
      text 480,0,"RMS = "+str$(rms*sc,1,4)
      
      'fft calculate magnitude
      MATH FFT MAGNITUDE c(),d()
      memory copy d_addr%,e_addr%,n*4 'copies the first 256 values from d() to e()
      
      dummy=math(max e(),p%) 'determin what cell in the array has the highest value
      inc p%,-1              'compensate for opetion base 1
      text 200,0,"Peak freq = "+str$(p%*freq/n,5,0)+" Hz"
      
      if hist then
        
        'fft spectrum show in histogram
        
        'display format
        if fillit then
          math window e(),0,460,e() 'scale to fill plot window
        else
          MATH SCALE e(),sc,e()    'scale to match samples on 470 vertical resolution
        end if
        
        'plot the histogram
        For i=2 To n/2 - 1
          'boxes
          BOX i*wdth,470-e(i),wdth,e(i)
        Next i
        
      else
      
        'plot as graph (faster)
        
        'display format
        if fillit then
          math window e(),470,10,e() 'scale to fill plot window
        else
          math scale e(),-sc,e()
          math add e(),480,e()
        end if
        
        'fft spectrum graph using line plot (in 60100rc12 line plot goes to N not F)
        line plot e(),,0,2,2,,rgb(green)
        
      end if
      
      framebuffer copy f,n
      CLS
      
    else
      
      pause 10
      
    EndIf
    
  Loop While Inkey$=""
  framebuffer write N
  Save compressed image "fft_bars.bmp"
End
  
  'interrupt routine
Sub INT_RDY
  If pingpong Then
    ADC START b()
  Else
    ADC START a()
  EndIf
  pingpong=1-pingpong
  ready=1
End Sub
