' CMM2 pin tester by TassyJim
' requires a bank of 28 same size resistors (200ohm - 2K)
' connected from each pin in pintest() array to a common point
' https://www.thebackshed.com/forum/ViewTopic.php?FID=16&TID=12159#147324
 
DIM pintest(27) = (3,5,7,11,13,15,19,21,23,27,29,31,33,35,37,8,10,12,16,18,22,24,26,28,32,36,38,40)
DIM apins(11) = (7,13,15,29,37,8,10,12,16,22,24,26)
DIM INTEGER k, bug
DIM FLOAT v
 
FOR k = 0 TO 27 ' make sure all pins are floating
  SETPIN(pintest(k)), OFF
NEXT k
 
CLS
' read analog voltage with one pin gnd, all floating then one pin at 3.3V
' header wrong way around will give a narrow range of voltages ~1.16V
PRINT
PRINT "Testing for correct orientation"
SETPIN 13, AIN
SETPIN 3, DOUT
PIN(3) = 0
PRINT "Analog range from ";STR$(PIN(13),2,2);" > ";
SETPIN 3, OFF
PRINT STR$(PIN(13),2,2);" > ";
SETPIN 3, DOUT
PIN(3) = 1
v = PIN(13)
PRINT STR$(v,2,2)
PRINT "A range from 0.2 to 2.9 is good."
PRINT
SETPIN 3, OFF
SETPIN 13, OFF

IF v < 2 THEN
  PRINT "It doesn't look right!!"
  PRINT "Giving up on the tests."
ELSE
  PRINT "Testing Digital IN"
  ' toggle one pin high/low and check that each pin follows.
  SETPIN 40, DOUT
  FOR k = 0 TO 26
    testpin = pintest(k)
    SETPIN testpin , DIN
    PIN(40) = 1
    IF PIN(testpin ) <> 1 THEN PRINT "Pin ";testpin ;" failed DIN high" : bug = bug+1
    PIN(40) = 0
    IF PIN(testpin ) <> 0 THEN PRINT "Pin ";testpin ;" failed DIN low" : bug = bug+1
    SETPIN testpin , OFF
  NEXT k
  
  SETPIN 38, DOUT
  testpin = 40
  SETPIN testpin , DIN
  PIN(38) = 1
  IF PIN(testpin ) <> 1 THEN PRINT "Pin ";testpin ;" failed DIN high" : bug = bug+1
  PIN(38) = 0
  IF PIN(testpin ) <> 0 THEN PRINT "Pin ";testpin ;" failed DIN low" : bug = bug+1
  SETPIN testpin , OFF
  SETPIN 38, OFF
  
  PRINT
  PRINT "Testing Digital OUT"
  ' toggle each pin in turn and check that output follows.
  SETPIN 40, DIN
  FOR k = 0 TO 26
    testpin = pintest(k)
    SETPIN testpin , DOUT
    PIN(testpin) = 1
    IF PIN(40 ) <> 1 THEN PRINT "Pin ";testpin ;" failed DOUT high" : bug = bug+1
    PIN(testpin) = 0
    IF PIN(40 ) <> 0 THEN PRINT "Pin ";testpin ;" failed DOUT low" : bug = bug+1
    SETPIN testpin , OFF
  NEXT k
  
  SETPIN 38, DIN
  testpin = 40
  SETPIN testpin , DOUT
  PIN(testpin) = 1
  IF PIN(38 ) <> 1 THEN PRINT "Pin ";testpin ;" failed DOUT high" : bug = bug+1
  PIN(testpin) = 0
  IF PIN(38 ) <> 0 THEN PRINT "Pin ";testpin ;" failed DOUT low" : bug = bug+1
  SETPIN testpin , OFF
  SETPIN 38, OFF
  
  PRINT
  PRINT "Testing Analog IN"
  ' testing analog in.
  ' set one pin high and one pin low to give VCC/2 at the common point.
  SETPIN 3, DOUT
  SETPIN 5, DOUT
  PIN(3) = 1
  PIN(5) = 0
  
  FOR n = 0 TO 11
    testpin = apins(n)
    SETPIN testpin, AIN
    v = PIN(testpin)
    IF V < 1.58 OR V > 1.7 THEN PRINT "Pin ";testpin ;" failed AIN - ";v : bug = bug+1
    SETPIN testpin, OFF
  NEXT n
  SETPIN 3, OFF
  SETPIN 5, OFF
  
  PRINT
  IF bug = 0 THEN
    PRINT "All tests completed with no errors"
  ELSE
    PRINT "A total of ";bug; " errors detected over all tests!!!"
  ENDIF
ENDIF
PRINT
 