' 
' K-type thermocouple conversion using MCP342x ADC and DS18B20 for coldjunction compensation 
' 
cpu 48 
option explicit 
option default integer 
Const stepsize=1
const maxgauges=1
const maxtemp=1000
const mintemp=550
dim integer x(maxgauges), y(maxgauges), radius(maxgauges), fontsize(maxgauges)
dim integer lastx1(maxgauges), lastx2(maxgauges), lastx3(maxgauges), lasty1(maxgauges), lasty2(maxgauges), lasty3(maxgauges) 
dim integer whitesec(maxgauges),greensec(maxgauges),yellowsec(maxgauges),redsec(maxgauges),blacksec(maxgauges)
dim s$

const ADCBits16=&B10001000  
const ADCbits16timeout= 15  
'max voltages gain 8 = +/- 0.256V 
const signed=1 
const unsigned=0 
const zeroOffset=90 'the thermocouple table starts at -90 degrees C so we offset the table lookup by this 
' Pin assignment 
const DS18B20pin=43 
const ADCi2c = &B1101000 ' set to match your hardware, NB base address is same as DS1307 
' 
dim i as integer,coldjunction as integer,adccount as integer, coldjunctionequiv as integer,temperature as integer 
dim ktype(1090) as integer 
dim testvoltage as float 
' 
INIT: 
  i2c open 400,1000 
  i=ktable() 'read in the therocouple lookup table 
  if i<>1 then end 'must be something wrong with the data table 
  initgauge(0,mm.hres\2,mm.vres\2,mm.hres\2-5,1,-150,-150,105,105,150,"EGT",15)

   
' 
MAIN: 
  do
  temperature=gettemp(0,DS18B20pin) 'ADC input pins shorted so should record cold junction temperature 
  s$=str$(temperature,4)
  needle(0,max((temperature-550)*2\3-150,-150),rgb(white),s$)
  pause 500
  loop

end 
' 
function max(a as integer, b as integer) AS INTEGER
  IF a> b then
    max= a
else
    max=b
endif
'
END FUNCTION
function gettemp(ADCchannel as integer, coldjunctionpin as integer) 
  coldjunction=cint(ds18b20(coldjunctionpin)) 
  coldjunctionequiv=ktype(coldjunction+zeroOffset)'get the number of ADC counts that the cold junction temperature would represent 
'  print "Coldjunction temperature is ",coldjunction," ADC equivalent is ",coldjunctionequiv 
  adccount=readadcraw16x8(ADCchannel) 'Measure thermocouple voltage with gain of 8 and 16 bits to give adequate resolution  
  adccount=adccount+coldjunctionequiv 'add in the cold junction temperature equivalent 
  temperature=findadc(adccount) 
  gettemp=temperature 
end function 
' 
function findadc(adcnum as integer) 'just does a simple binary chop of the ADC count table to find the nearest entry 
  local top as integer, bottom as integer, work as integer, test as integer 
  top=1089 
  bottom=0 'set up search limits 
  if ktype(1089)<adcnum then 
    findadc=2000 'above range 
    exit function 
  endif   
  if ktype(0)>adcnum then 
    findadc=-2000 'below range 
    exit function 
  endif   
  do while top>bottom+1 
    work=(top+bottom)\2 
    test=ktype(work) 
    if test=adcnum then 
      findadc=work-zerooffset   
      end function 
    endif     
    if test> adcnum then  
      top=work 
    else  
      bottom=work 
    endif 
  loop   
  if (ktype(top)-adcnum)>=(adcnum-ktype(bottom)) then 
    findadc=bottom-zerooffset 
  else 
    findadc=top-zerooffset 
  endif 
end function 
' 
function readadcraw16x8(channel as integer) 
' config byte for chip is: 
' bits 0 and 1 - Gain = 8 
' bits 2 and 3 - # of bits = 16; 15 samples per second respectively 
' bit 4 - 0=one-shot conversion ; we will always use 0 to allow changes to config e.g. which channel 
' bits 5 and 6 - channel number 0-3 
' bit 7 - set to start conversion, wait for clear to indicate conversion end 
' max voltage for gain 8 = +/- 0.256V 
  local channelmask as integer,gainmask as integer, scratch as integer, timeout as integer 
  local configbyte as integer 
  local ADCret$ length 4 
  if channel<0 or channel>3 then 
     readadcraw16x8=100000000 'impossible value 
     exit function 
  endif 
  gainmask=3 'Gain of 8 
  timeout=ADCbits16timeout 
  configbyte=ADCbits16 or gainmask 
  channelmask=channel << 5 
  configbyte=configbyte or channelmask 
     i2c write ADCi2c, 0,1,configbyte 
  do 
       pause 5 
       i2c read ADCi2c, 0,4,ADCret$ 
    scratch =asc(right$(ADCret$,1)) AND &B10000000 
         timeout=timeout-1 
  loop until (scratch=0) or (timeout=0) 
     if timeout <>0 then 
    readadcraw16x8=intconv(left$(ADCret$,2),signed) 
  else 
       readadcraw16x8=200000000 'impossible value 
     endif' 
end function 

' 
function ktable() 
' This table gives the ADC counts at 16 bits resolution and gain of 8 for every temperature from -90 to 1000 degrees C 
data  65121,65125,65129,65133,65137,65141,65146,65150,65154,65158, 65162,65166,65171,65175,65179,65183,65188,65192,65196,65201, 65205,65209,65214,65218,65222,65227,65231,65236,65240 
 data  65244,65249,65253,65258,65262,65267,65271,65276,65281,65285, 65290,65294,65299,65303,65308,65313,65317,65322,65326,65331, 65336,65341,65345,65350,65355,65359,65364,65369,65374 
 data  65378,65383,65388,65393,65398,65402,65407,65412,65417,65422, 65427,65432,65436,65441,65446,65451,65456,65461,65466,65471, 65476,65481,65486,65491,65496,65501,65506,65511,65516,65521, 65526,65531 
data  0,5,10,15,20,25,30,35,41,46,51,56,61,66,71,76,82,87,92,97,102,107,113,118,123,128,133,138,144,149,154,159,164,170 
 data  175,180,185,191,196,201,206,212,217,222,227,233,238,243,248, 254,259,264,270,275,280,285,291,296,301,307,312,317,322,328, 333,338,344,349,354,360 
data  365,370,376,381,386,392,397,402,408,413,418,423,429,434,439, 445,450,455,461,466,471,477,482,487,493,498,503,508,514,519, 524,530,535,540,546,551,556,561,567,572 
 data  577,582,588,593,598,604,609,614,619,625,630,635,640,646,651, 656,661,666,672,677,682,687,692,698,703,708,713,718,724,729, 734,739,744,750,755,760,765,770,775,781 
 data  786,791,796,801,806,811,817,822,827,832,837,842,847,852,858, 863,868,873,878,883,888,894,899,904,909,914,919,924,929,934, 940,945,950,955,960,965,970,975,980,985 
 data  991,996,1001,1006,1011,1016,1021,1026,1032,1037,1042,1047,1052,1057,1062,1067,1072,1078,1083,1088,1093,1098,1103,1108,1113,1119,1124,1129,1134,1139,1144,1149,1155,1160,1165,1170,1175,1180,1186 
data 1191,1196,1201,1206,1211,1217,1222,1227,1232 
data 1237,1242,1248,1253,1258,1263,1268,1274,1279,1284,1289,1294 
data  1300,1305,1310,1315,1320,1326,1331,1336,1341,1347,1352,1357, 1362,1368,1373,1378,1383,1389,1394,1399,1404,1410,1415,1420, 1425,1431,1436,1441,1446,1452,1457,1462,1468,1473,1478,1483, 1489,1494,1499,1504
data  1510,1515,1520,1526,1531,1536,1542,1547,1552,1557,1563,1568, 1573,1579,1584,1589,1594,1600,1605,1610,1616,1621,1626,1632, 1637,1642,1648,1653,1658,1664,1669,1674,1680,1685,1690,1696, 1701,1706,1712,1717
data  1722,1728,1733,1738,1744,1749,1754,1760,1765,1771,1776,1781, 1787,1792,1797,1803,1808,1813,1819,1824,1830,1835,1840,1846, 1851,1856,1862,1867,1873,1878,1883,1889,1894,1899,1905,1910, 1916,1921,1926,1932
data  1937,1942,1948,1953,1959,1964,1969,1975,1980,1985,1991,1996, 2002,2007,2012,2018,2023,2029,2034,2039,2045,2050,2056,2061, 2066,2072,2077,2083,2088,2093,2099,2104,2110,2115,2120,2126, 2131,2137,2142,2148
data  2153,2158,2164,2169,2175,2180,2185,2191,2196,2202,2207,2212, 2218,2223,2229,2234,2240,2245,2250,2256,2261,2267,2272,2278, 2283,2289,2294,2299,2305,2310,2316,2321,2327,2332,2337,2343, 2348,2354,2359,2365
data  2370,2375,2381,2386,2392,2397,2403,2408,2414,2419,2424,2430, 2435,2441,2446,2452,2457,2463,2468,2473,2479,2484,2490,2495, 2501,2506,2512,2517,2522,2528,2533,2539,2544,2550,2555,2561, 2566,2572,2577,2582
data  2588,2593,2599,2604,2610,2615,2621,2626,2632,2637,2642,2648, 2653,2659,2664,2670,2675,2681,2686,2692,2697,2702,2708,2713, 2719,2724,2730,2735,2741,2746,2752,2757,2762,2768,2774,2779, 2784,2790,2795,2801
data  2806,2812,2817,2823,2828,2834,2839,2844,2850,2855,2861,2866, 2872,2877,2883,2888,2894,2899,2904,2910,2915,2921,2926,2932, 2937,2943,2948,2954,2959,2964,2970,2975,2981,2986,2992,2997, 3003,3008,3014,3019
data  3025,3030,3035,3041,3046,3052,3057,3063,3068,3074,3079,3084, 3090,3095,3101,3106,3112,3117,3123,3128,3133,3139,3144,3150, 3155,3161,3166,3172,3177,3182,3188,3193,3199,3204,3210,3215, 3220,3226,3231,3237
data  3242,3248,3253,3259,3264,3270,3275,3280,3286,3291,3297,3302, 3308,3313,3318,3324,3329,3335,3340,3345,3351,3356,3362,3367, 3373,3378,3383,3389,3394,3400,3405,3410,3416,3421,3427,3432, 3438,3443,3448,3454
data  3459,3465,3470,3475,3481,3486,3492,3497,3502,3508,3513,3519, 3524,3529,3535,3540,3546,3551,3556,3562,3567,3573,3578,3583, 3589,3594,3599,3605,3610,3616,3621,3626,3632,3637,3643,3648, 3653,3659,3664,3670
data  3675,3680,3686,3691,3696,3702,3707,3712,3718,3723,3729,3734, 3739,3745,3750,3755,3761,3766,3771,3777,3782,3787,3793,3798, 3804,3809,3814,3820,3825,3830,3836,3841,3846,3852,3857,3862, 3868,3873,3878,3884
data  3889,3894,3900,3905,3910,3916,3921,3926,3932,3937,3942,3948, 3953,3958,3963,3969,3974,3979,3985,3990,3995,4001,4006,4011, 4017,4022,4027,4033,4038,4043,4048,4054,4059,4064,4070,4075, 4080,4085,4091,4096
data  4101,4106,4112,4117,4122,4128,4133,4138,4143,4149,4154,4159, 4165,4170,4175,4180,4186,4191,4196,4201,4207,4212,4217,4222, 4228,4233,4238,4243,4249,4254,4259,4264,4270,4275,4280,4285, 4291,4296,4301,4306
data  4312,4317,4322,4327,4333,4338,4343,4348,4354,4359,4364,4369, 4374,4380,4385,4390,4395,4401,4406,4411,4416,4421,4426,4432, 4437,4442,4447,4453,4458,4463,4468,4473,4479,4484,4489,4494, 4499,4505,4510,4515
data  4520,4525,4530,4536,4541,4546,4551,4556,4562,4567,4572,4577, 4582,4587,4593,4598,4603,4608,4613,4618,4623,4629,4634,4639, 4644,4649,4654,4660,4665,4670,4675,4680,4685,4690,4696,4701, 4706,4711,4716,4721
data  4726,4732,4737,4742,4747,4752,4757,4762,4767,4773,4778,4783, 4788,4793,4798,4803,4808,4814,4819,4824,4829,4834,4839,4844, 4849,4854,4860,4865,4870,4875,4880,4885,4890,4895,4900,4905, 4910,4915,4921,4926
data  4931,4936,4941,4946,4951,4956,4961,4966,4971,4976,4982,4987, 4992,4997,5002,5007,5012,5017,5022,5027,5032,5037,5042,5047, 5052,5057,5062,5068,5073,5078,5083,5088,5093,5098,5103,5108, 5113,5118,5123,5128
data  5133,5138,5143,5148,5153,5158,5163,5168,5173,5178,5183,5188, 5193,5198,5203,5208,5213,5218,5223,5228,5233,5238,5243,5248, 5253,5258,5263,5268,5273,5278 
 Local i,j 
j=-420 ' 5 less than lowest value in the table 
ktable=1 
for i= 0 to 1089 
  read ktype(i) 
  if ktype(i)>32767 then ktype(i)=ktype(i)-65536 
  if (ktype(i)-j) <4 or (ktype(i)-j) >7 then ktable=0 'check no errors in table 
  j=ktype(i) 
next i 
end function 
'
Sub segment(x As integer, y As integer, outsize As integer, startradial As integer, endradial As integer, col As integer, insize as integer )
  Local integer i,j,x1,x2,y1,y2,sr,er,xx0(1),yy0(1),xx1(1),yy1(1),xx2(1),yy2(1),tcol(1)
  If startradial=endradial Then
      x2=Sin(Rad(startradial))*outsize + x
      y2=-Cos(Rad(startradial))*outsize + y
      x1=Sin(Rad(startradial))*insize + x 'insize is 0 if not specified so a complete line from the centre is drawn
      y1=-Cos(Rad(startradial))*insize + y
      Line x1,y1,x2,y2,,col
  Else
    If startradial<endradial Then
      sr=startradial
      er=endradial
    Else
      er=startradial
      sr=endradial
    EndIf
    For i=sr+stepsize To er Step stepsize
      x2=Sin(Rad(i))*outsize + x
      y2=-Cos(Rad(i))*outsize + y
      x1=Sin(Rad(i-stepsize))*outsize + x
      y1=-Cos(Rad(i-stepsize))*outsize + y
      xx0(0)=x
      yy0(0)=y
      xx1(0)=x1
      yy1(0)=y1
      xx2(0)=x2
      yy2(0)=y2
      tcol(0)=col
      j=triangles(1,xx0(),yy0(),xx1(),yy1(),xx2(),yy2(),tcol())
    Next i
  EndIf
End Sub
'
sub initgauge(gaugeindex% , xpos%, ypos%, gsize%, fontmult%, whitestart%, greenstart%, yellowstart%, redstart%, blackstart%, displaystring$, tickspace%)
  local ticks%
  Circle xpos%,ypos%,gsize%+3,0,,RGB(210,210,210),RGB(210,210,210) 'background to create the bezel
  segment(xpos%,ypos%,gsize%,whitestart%,greenstart%, RGB(white),0)
  segment(xpos%,ypos%,gsize%,greenstart%,yellowstart%, RGB(green),0)
  segment(xpos%,ypos%,gsize%,yellowstart%,redstart%, RGB(yellow),0)
  segment(xpos%,ypos%,gsize%,redstart%,blackstart%, RGB(red),0)
  segment(xpos%,ypos%,gsize%,blackstart%,whitestart%+360, 0)
  segment(xpos%,ypos%,gsize%,greenstart%,greenstart%, 0)
  segment(xpos%,ypos%,gsize%,yellowstart%,yellowstart%, 0)
  segment(xpos%,ypos%,gsize%,redstart%,redstart%, 0)
  if tickspace% then
    for ticks%=whitestart% to blackstart% step tickspace%
      segment(xpos%,ypos%,gsize%,ticks%,ticks%, 0, (gsize%*19)\20)
    next ticks%
  endif
  Circle xpos%,ypos%, (gsize%*4)\5,0,,0,0
  text xpos%-len(displaystring$)*4*fontmult%,ypos%+gsize%-fontmult%*28,displaystring$ ' string centred in black segment
  x(gaugeindex%)=xpos%
  y(gaugeindex%)=ypos%
  radius(gaugeindex%)=gsize%
  fontsize(gaugeindex%)=fontmult%
  lastx1(gaugeindex%)=xpos%
  lastx2(gaugeindex%)=xpos%+2
  lastx3(gaugeindex%)=xpos%+2
  lasty1(gaugeindex%)=ypos%
  lasty2(gaugeindex%)=ypos%+2
  lasty3(gaugeindex%)=ypos%
  whitesec(gaugeindex%)=whitestart%
  greensec(gaugeindex%)=greenstart%
  yellowsec(gaugeindex%)=yellowstart%
  redsec(gaugeindex%)=redstart%
  blacksec(gaugeindex%)=blackstart%
end sub
'
' Routine to draw a pointer
' Parameters are:
' gaugeindex
' radial of pointer to be drawn (0-360 degrees)
' colour to draw pointer
'
Sub needle(gaugeindex as integer, angle As integer, col As integer, value$ as string)
Local integer x1,y1,x2,y2,x3,y3,x4,y4,j, xx1(1),yy1(1),xx2(1),yy2(1),xx3(1),yy3(1), tcol(1), size
    size= (radius(gaugeindex)*4)\5-1
    x1=Sin(Rad(angle-90))*size/10 + x(gaugeindex)
    y1=-Cos(Rad(angle-90))*size/10 + y(gaugeindex)
    x2=Sin(Rad(angle))*size + x(gaugeindex)
    y2=-Cos(Rad(angle))*size + y(gaugeindex)
    x3=Sin(Rad(angle+90))*size/10 + x(gaugeindex)
    y3=-Cos(Rad(angle+90))*size/10 + y(gaugeindex)
    xx1(0)=lastx1(gaugeindex)
    yy1(0)=lasty1(gaugeindex)
    xx2(0)=lastx2(gaugeindex)
    yy2(0)=lasty2(gaugeindex)
    xx3(0)=lastx3(gaugeindex)
    yy3(0)=lasty3(gaugeindex)
    xx1(1)=x1
    yy1(1)=y1
    xx2(1)=x2
    yy2(1)=y2
    xx3(1)=x3
    yy3(1)=y3
    tcol(0)=0
    tcol(1)=col
    j=triangles(2,xx1(),yy1(),xx2(),yy2(),xx3(),yy3(),tcol())
    Circle x(gaugeindex),y(gaugeindex),size\10,0,,col,col)
    Circle x(gaugeindex),y(gaugeindex),size\15,0,,0,0
    Circle x(gaugeindex),y(gaugeindex),size\20,0,,RGB(240,240,240),RGB(240,240,240)
    lastx1(gaugeindex)=x1
    lastx2(gaugeindex)=x2
    lastx3(gaugeindex)=x3
    lasty1(gaugeindex)=y1
    lasty2(gaugeindex)=y2
    lasty3(gaugeindex)=y3
    text x(gaugeindex)-len(value$)*4*fontsize(gaugeindex)-3*fontsize(gaugeindex),y(gaugeindex)+radius(gaugeindex)-fontsize(gaugeindex)*16,value$ ' string centred in black segment

End Sub
CFunction intconv 'convert data read from i2c to integer including extending sign bit across the 64 bit integer 
     00000000 
     27bdfff8 00001021 00001821 afa20000 afa30004 90880000 1900000b 01003821  
     2503ffff 03a31821 24020001 00823021 90c60000 a0660000 24420001 00e2302a  
     10c0fffa 2463ffff 8ca20000 1040000d 03a81021 9042ffff 30420080 10400009  
     29020008 10400007 03a81021 27a40008 2403ffff a0430000 24420001 5444fffe  
     a0430000 8fa20000 8fa30004 03e00008 27bd0008  
End CFunction 
CFunction triangles
	00000000
	8c820004 27bdffa0 afbf005c afbe0058 afb70054 afb60050 afb5004c afb40048 
	afb30044 afb20040 afb1003c afb00038 afa40060 afa50064 afa60068 184000e7 
	afa7006c afa00030 3c179d00 8fa30030 8fa50068 8fa80070 000310c0 00a22021 
	01021821 8c840000 8c630000 8fa90064 afa40018 01223821 afa3001c 8fa40074 
	8fa3006c 8fa80078 8fa9007c 00623021 00822821 01022021 01221021 8fa80018 
	8fa9001c 8cc60000 8ca50000 0128182a 8cf30000 8c9e0000 afa60028 afa5002c 
	10600006 8c540000 02601021 afa90018 00c09821 afa8001c afa20028 8fa5001c 
	03c5102a 10400008 8fa90018 8fa20028 8fa8002c afbe001c afa80028 00a0f021 
	afa2002c 8fa90018 8fa3001c 0069102a 10400008 8fa50018 8fa4001c 02601021 
	afa40018 8fb30028 afa9001c afa20028 8fa50018 10be007f 8fa3001c 107e009e 
	8fa40018 2463ffff 0064102a 1440002d 8fb00018 8fa80028 8fa9002c 8fa5001c 
	01134023 01334823 03c4a823 afbe0034 00a4b023 0280f021 afa80020 afa90024 
	00808021 00009021 00008821 0060a021 0236001a 02c001f4 8fa30024 8fa20020 
	02002821 02003821 02228821 26100001 00002012 0255001a 02a001f4 00932021 
	02439021 00003012 00d33021 00c4182a 10600003 00801021 00c02021 00403021 
	afbe0010 8ee20048 0040f809 00000000 0290102a 1040ffe6 00000000 03c0a021 
	8fbe0034 03d0102a 1440002f 8fa8001c 8fa90018 8fa4002c 8fa50028 0093a823 
	0085b023 02089023 02098823 03c91823 03c81023 72569002 72358802 afb40018 
	afb5001c afb60020 0260a821 00a0b021 00609821 0040a021 0254001a 028001f4 
	8fa3001c 8fa20020 02002821 02003821 02429021 26100001 00002012 0233001a 
	026001f4 00962021 02238821 00003012 00d53021 00c4182a 10600003 00801021 
	00c02021 00403021 8fa80018 afa80010 8ee20048 0040f809 00000000 03d0102a 
	1040ffe5 00000000 8fa90030 8fa20060 25290001 8c430004 000917c3 0043202a 
	1480ff5a afa90030 14620007 8fbf005c 8fa30060 8c620000 0122102b 5440ff54 
	8fa30030 8fbf005c 8fbe0058 8fb70054 8fb60050 8fb5004c 8fb40048 8fb30044 
	8fb20040 8fb1003c 8fb00038 03e00008 27bd0060 8fa80028 0113102a 14400023 
	02603821 0268102a 14400022 8fa70028 02603821 02602021 8fa9002c 0124102a 
	54400003 8fa4002c 00e9102a 0122380b 8fa20018 afb40010 00e23821 8fa50018 
	8ee20048 00803021 0040f809 00e43823 8fa90030 8fa20060 25290001 8c430004 
	000917c3 0043202a 1480ff28 afa90030 1000ffcd 00000000 0064102a 1040ff66 
	8fa80028 1000ff8f 8fb00018 1000ffe2 8fa40028 1000ffe0 02602021 1440ffca 
	8fbf005c 8c820000 5440ff17 afa00030 1000ffc6 8fbe0058 
End CFunction   'MIPS32 M4K

