CONST SCROLL_STEP=4
OPTION EXPLICIT
FONT 7

#INCLUDE "utils.inc" 

DIM gameClock AS INTEGER
DIM animClock AS INTEGER
DIM inputClock AS INTEGER
DIM renderClock AS INTEGER

MODE 3, 8, 0, renderTick

CONST TILE_SIZE=16

gameClock = 0
animClock = 0
inputClock = 0
renderClock = 0

CONST SCREEN_PIXELS_W = MM.HRES
CONST SCREEN_PIXELS_H = MM.VRES


DIM VIEWPORT_W AS INTEGER = 20
DIM VIEWPORT_H AS INTEGER = 12

DIM VIEWPORT_W_PX AS INTEGER = VIEWPORT_W * TILE_SIZE
DIM VIEWPORT_H_PX AS INTEGER = VIEWPORT_H * TILE_SIZE

DIM ROOM_W AS INTEGER = 40
DIM ROOM_H AS INTEGER = 22

DIM ROOM_W_PX AS INTEGER = ROOM_W * TILE_SIZE
DIM ROOM_H_PX AS INTEGER = ROOM_H * TILE_SIZE

'load into their respective memory page, thus -1 arg
LOADALLSPRITES16 -1

PAGE WRITE 1

SETTICK 50,animTick,1
SETTICK 400,gameTick,2
SETTICK 25,inputTick,3

'LOAD A TEST LEVEL
DIM room(ROOM_W,ROOM_H) AS INTEGER
BDF2BOARD ROOM_W,ROOM_H,level(),room()

DIM viewportMove AS INTEGER = 0
DIM viewportX AS INTEGER = 0
DIM viewportY AS INTEGER = 0
DIM targetViewportX AS INTEGER = viewportX
DIM targetViewportY AS INTEGER = viewportY

CLS

'''''''''''GAME LOOP'''''''''''''''

DO
  keyScan inputClock
  computeGameState gameClock
  renderScreen
LOOP

'''''''''''GAME LOGIC''''''''''''''

SUB COMPUTEGAMESTATE gc AS INTEGER
  STATIC lastGameClock = 0
  IF lastGameClock >= gc THEN EXIT SUB
  lastGameClock = gc
  'emulate processing time
  PAUSE 5
END SUB

'''''''DRAWING TO SCREEN'''''''''''

SUB RENDERSCREEN
  STATIC lastAnimClock = 0  
  TIMER = 0
  LOCAL dX = 0
  LOCAL dY = 0
  IF viewportX <> targetViewportX THEN 
    dX = SGN(targetViewportX - viewportX)*SCROLL_STEP
    BLIT dX,0,0,0,VIEWPORT_W_PX-dX,VIEWPORT_H_PX,1
    viewportX = viewportX + dX
  ENDIF
  IF viewportY <> targetViewportY THEN
    dY = SGN(targetViewportY - viewportY)*SCROLL_STEP
    BLIT 0,dY,0,0,VIEWPORT_W_PX,VIEWPORT_H_PX-dY,1
    viewportY = viewportY + dY
  ENDIF
  LOCAL elapsed1 = TIMER
  LOCAL n,m,ec,t
  LOCAL bc = 0
  LOCAL le = 1+FIX(viewportX / TILE_SIZE)
  LOCAL re = 1+FIX((viewportX + VIEWPORT_W_PX - 1)/TILE_SIZE)
  LOCAL te = 1+FIX(viewportY / TILE_SIZE)
  LOCAL be = 1+FIX((viewportY + VIEWPORT_H_PX - 1)/TILE_SIZE)
  FOR n=te TO be
    FOR m=le TO re
      ec=ec+1
      t=room(m,n)
      IF(((t AND 1030792151040)>>36)>1)OR(t AND 288230376151711744)=0 OR(m=le AND dX<0)OR(m=re AND dX>0)OR(n=te AND dY<0)OR(n=be AND dY>0) THEN
        BLIT 16*(animClock MOD((t AND 1030792151040)>>36)),16*(((t AND 64424509440)>>32)-1),-viewportX+((m-1)*16),-viewportY+((n-1)*16),16,16,(t AND 4026531840)>>28
        room(m,n)=t OR 288230376151711744
        bc=bc+1
      ENDIF
    NEXT
  NEXT
  BOX 0,MM.VRES-(TILE_SIZE/2),MM.HRES,TILE_SIZE/2,1,RGB(BLUE),RGB(BLUE)
  LOCAL elapsed2 = TIMER
  LOCAL msg AS STRING = "blits: " + STR$(bc) + " evals: " + STR$(ec) + " elapsed1: " + STR$(elapsed1) + "  elapsed2: " + STR$(elapsed2) + "   "
  TEXT 0,192, msg, "LT", 7, 1, RGB(WHITE), RGB(BLUE)
  PAGE COPY 1 TO 0
  lastAnimClock = animClock
END SUB

SUB INVALIDATECOLUMN column AS INTEGER
  FOR n = viewportTop to viewportTop + VIEWPORT_H -1
    tile = room(column,n)
    room(column,n) = CLEARCURRENT(tile)
  NEXT n
END SUB

SUB MOVEVIEWPORT direction AS INTEGER
  IF direction = RIGHT_MASK THEN
    IF targetViewportX + VIEWPORT_W_PX < ROOM_W_PX THEN
      targetViewportX = targetViewportX + (TILE_SIZE/2)
    ENDIF
  ENDIF
  IF direction = LEFT_MASK THEN
    IF targetViewportX > 0 THEN
      targetViewportX = targetViewportX - (TILE_SIZE/2)
    ENDIF
  ENDIF
  IF direction = UP_MASK THEN
    IF targetViewportY > 0 THEN
      targetViewportY = targetViewportY - (TILE_SIZE/2)
    ENDIF
  ENDIF
  IF direction = DOWN_MASK THEN
    IF targetViewportY + VIEWPORT_H_PX < ROOM_H_PX THEN
      targetViewportY = targetViewportY + (TILE_SIZE/2)
    ENDIF
  ENDIF
END SUB



'''''''HANDLING INPUTS''''''''''''

SUB keyScan ic AS INTEGER
  STATIC lastInputClock = 0
  IF lastInputClock >= ic THEN EXIT SUB
  LOCAL numKeys = KEYDOWN(0) 
  LOCAL n
  FOR n = 1 to numKeys
    PROCESSKEY KEYDOWN(n)
  NEXT    
  lastInputClock = ic
END SUB


SUB PROCESSKEY k
  IF k = 128 THEN 
    MOVEVIEWPORT UP_MASK 'UP arrow key
  ENDIF
  IF k = 129 THEN 
    MOVEVIEWPORT DOWN_MASK 'DOWN key
  ENDIF
  IF k = 130 THEN 
    MOVEVIEWPORT LEFT_MASK 'LEFT key
  ENDIF
  IF k = 131 THEN 
    MOVEVIEWPORT RIGHT_MASK 'RIGHT key
  ENDIF
END SUB

SUB renderTick
  renderClock = renderClock + 1
END SUB

SUB animTick
  animClock = animClock + 1
END SUB

SUB gameTick
  gameClock = gameClock + 1
END SUB

SUB inputTick
  inputClock = inputClock + 1
END SUB
