
OPTION BASE 1

DIM level(22) AS STRING LENGTH 40
level(1) =  "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
level(2) =  "w......D.D.D.W........r..r..r..rrrr....W"
level(3) =  "w...W  DD ..DrD.D.....r..r..r..r..r....W"
level(4) =  "w..fW..D...D.W..D.D...rrrr..r..rrrr....W"
level(5) =  "w..DW.....D..D.....r..r..r..r..r..r....W"
level(6) =  "w.D.WD.D...D.W...D.wwwwwwww............W"
level(7) =  "w...W.D.D.D....D...r........W........W.W"
level(8) =  "wD..W...D..D.W..D..wwwwwwww............W"
level(9) =  "w...W.D..D.D.......r........W........W.W"
level(10) = "w...W........W.....wwwwwwww............W"
level(11) = "w...W..............r........W........W.W"
level(12) = "w...W........W.....wwwwwwww............W"
level(13) = "w...W..............r........W........W.W"
level(14) = "w...W........W.....wwwwwwww............W"
level(15) = "w...W......................W........W..W"
level(16) = "w...W........W.....wwwwwwww............W"
level(17) = "w...W.......................W........W.W"
level(18) = "w...W........W.....wwwwwwww............W"
level(19) = "w...W............DD.........W........W.W"
level(20) = "w...........................W........W.W"
level(21) = "w...W.......................W........W.W"
level(22) = "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"


'IMPORTANT! INTERNAL TILE ENCODING:
'
'Each tile/monster/rockford/etc is encoded in a 64 bit Integer
'
'                        64      56      48      40      32      24      16       8       0
'                         /       /       /       /       /       /       /       /       /
CONST EMPTY_MASK  =     &B0000000000000000000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ASCII_MASK  =     &B0000000000000000000000000000000000000000000000000000000011111111
'                         /       /       /       /       /       /       /       /       /
CONST XCOORD_MASK =     &B0000000000000000000000000000000000000000000000111111111100000000
'                         /       /       /       /       /       /       /       /       /
CONST YCOORD_MASK =     &B0000000000000000000000000000000000001111111111000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST SPRITE_PAGE_MASK= &B0000000000000000000000000000000011110000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST SPRITE_ROW_MASK = &B0000000000000000000000000000111100000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST SPRITE_FRAME_MASK=&B0000000000000000000000001111000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ROUNDED_MASK =    &B0000000000000000000000010000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST MOVING_MASK =     &B0000000000000000000000100000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST DIR_MASK  =       &B0000000000000000001111000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST LEFT_MASK  =      &B0000000000000000001000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST RIGHT_MASK  =     &B0000000000000000000001000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST UP_MASK  =        &B0000000000000000000100000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST DOWN_MASK  =      &B0000000000000000000010000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST LEFTDOWN_MASK =   &B0000000000000000001010000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST RIGHTDOWN_MASK=   &B0000000000000000000011000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST EXPLODING_MASK=   &B0000000000000000010000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ACTIVATED_MASK=   &B0000000000000000100000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST ACTIVETIME_MASK=  &B0000000011111111000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST HEAVY_MASK  =     &B0000000100000000000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST EDIBLE_MASK  =    &B0000001000000000000000000000000000000000000000000000000000000000
'                         /       /       /       /       /       /       /       /       /
CONST CURRENT_MASK =    &B0000010000000000000000000000000000000000000000000000000000000000




FUNCTION GETBDF( tile AS INTEGER ) AS STRING
  GETBDF = CHR$(tile AND ASCII_MASK)
END FUNCTION

FUNCTION SETBDF( tile AS INTEGER, bdf AS STRING ) AS INTEGER
  SETBDF = ((tile AND INV ASCII_MASK) OR (ASC(bdf) AND ASCII_MASK))
END FUNCTION


FUNCTION GETXCOORD( tile AS INTEGER ) AS INTEGER
  GETXCOORD = ((tile AND XCOORD_MASK) >> 8)
END FUNCTION

FUNCTION SETXCOORD( tile AS INTEGER, xCoord AS INTEGER ) AS INTEGER
  SETXCOORD = (TILE AND INV XCOORD_MASK) OR (XCOORD_MASK AND (xCoord << 8))
END FUNCTION


FUNCTION GETYCOORD( tile AS INTEGER ) AS INTEGER
  GETYCOORD = ((tile AND YCOORD_MASK) >> 18)
END FUNCTION

FUNCTION SETYCOORD( tile AS INTEGER, yCoord AS INTEGER ) AS INTEGER
  SETYCOORD = (TILE AND INV YCOORD_MASK) OR (YCOORD_MASK AND (yCoord << 18))
END FUNCTION


FUNCTION GETSPRITEPAGE( tile AS INTEGER ) AS INTEGER
  GETSPRITEPAGE = ((tile AND SPRITE_PAGE_MASK) >> 28)
END FUNCTION

FUNCTION SETSPRITEPAGE( tile AS INTEGER, spage AS INTEGER ) AS INTEGER
  SETSPRITEPAGE = (TILE AND INV SPRITE_PAGE_MASK) OR (SPRITE_PAGE_MASK AND (spage << 28))
END FUNCTION


FUNCTION GETSPRITEROW( tile AS INTEGER ) AS INTEGER
  GETSPRITEROW = ((tile AND SPRITE_ROW_MASK) >> 32)
END FUNCTION

FUNCTION SETSPRITEROW( tile AS INTEGER, row AS INTEGER ) AS INTEGER
  SETSPRITEROW = (TILE AND INV SPRITE_ROW_MASK) OR (SPRITE_ROW_MASK AND (row << 32))
END FUNCTION


FUNCTION GETSPRITEFRAMES( tile AS INTEGER ) AS INTEGER
  GETSPRITEFRAMES = ((tile AND SPRITE_FRAME_MASK) >> 36)
END FUNCTION

FUNCTION SETSPRITEFRAMES( tile AS INTEGER, frames AS INTEGER ) AS INTEGER
  SETSPRITEFRAMES = (TILE AND INV SPRITE_FRAME_MASK) OR (SPRITE_FRAME_MASK AND (frames << 36))
END FUNCTION




FUNCTION GETROUNDED( tile AS INTEGER ) AS INTEGER
  GETROUNDED = (tile AND ROUNDED_MASK)
END FUNCTION

FUNCTION SETROUNDED( tile AS INTEGER ) AS INTEGER
  SETROUNDED = (tile OR ROUNDED_MASK)
END FUNCTION

FUNCTION CLEARROUNDED( tile AS INTEGER ) AS INTEGER
  CLEARROUNDED = tile AND INV ROUNDED_MASK
END FUNCTION


FUNCTION GETMOVING( tile AS INTEGER ) AS INTEGER
  GETMOVING = tile AND MOVING_MASK
END FUNCTION

FUNCTION SETMOVING( tile AS INTEGER ) AS INTEGER
  SETMOVING = (tile OR MOVING_MASK)
END FUNCTION

FUNCTION CLEARMOVING( tile AS INTEGER ) AS INTEGER
  CLEARMOVING = tile AND INV MOVING_MASK
END FUNCTION


FUNCTION GETHEAVY( tile AS INTEGER ) AS INTEGER
  GETHEAVY = tile AND HEAVY_MASK
END FUNCTION

FUNCTION SETHEAVY( tile AS INTEGER ) AS INTEGER
  SETHEAVY = (tile OR HEAVY_MASK)
END FUNCTION


FUNCTION GETEDIBLE( tile AS INTEGER ) AS INTEGER
  GETEDIBLE = tile AND EDIBLE_MASK
END FUNCTION

FUNCTION SETEDIBLE( tile AS INTEGER ) AS INTEGER
  SETEDIBLE = (tile OR EDIBLE_MASK)
END FUNCTION


FUNCTION GETDIR( tile AS INTEGER ) AS INTEGER
  GETDIR = tile AND DIR_MASK
END FUNCTION 

FUNCTION SETDIR( tile AS INTEGER, dir AS INTEGER ) AS INTEGER
  SETDIR = (tile AND INV DIR_MASK) OR dir
END FUNCTION


FUNCTION GETCURRENT( tile AS INTEGER ) AS INTEGER
  GETCURRENT = tile AND CURRENT_MASK
END FUNCTION

FUNCTION SETCURRENT( tile AS INTEGER ) AS INTEGER
  SETCURRENT = (tile OR CURRENT_MASK)
END FUNCTION

FUNCTION CLEARCURRENT( tile AS INTEGER ) AS INTEGER
  CLEARCURRENT = tile AND INV CURRENT_MASK
END FUNCTION





'Copies data from the board array to the viewport array
'viewport array mustn't extend beyond the limits of the board
'
'x - first column position of the vieport on the board
'y - first row position of the viewport on the board
'board - the 2D array to copy from
'viewport - the 2D array to copy into 
SUB COPY2VIEWPORT x, y, w, h, board() AS INTEGER, viewport() AS INTEGER
  LOCAL xExtent = x + w - 1
  LOCAL yExtent = y + h - 1
  LOCAL a
  LOCAL b = 1
  LOCAL i,j
  FOR i = y TO yExtent
    a = 1
    FOR j = x TO xExtent
      viewport(a, b) = board(j,i)
      a = a + 1
    NEXT j
    b = b + 1
  NEXT i
END SUB


'Converts data from an array that represents a room by one string per row to a 2d numeric array
'
'w - width of each string line
'h - the number of lines in bdfData$
'bdfData - array of strings where each line represents one row
'board - target 2d array that represents the board
SUB BDF2BOARD w, h, bdfData() AS STRING, board() AS INTEGER
  LOCAL textLine$, symbol$, n, m
  FOR n = 1 TO h
    FOR m = 1 TO w
      symbol$ = MID$(bdfData(n),m,1)
      board(m,n) = BDF2TILE(symbol$)
    NEXT m
  NEXT n
END SUB


'Pretty prints a 2d array starting from its top left corner
'
'w - width of the printed output
'h - height of the printed output
'array - array to print
'ascii - show content as ascii if non zero
SUB PPRINT2D w, h, array() AS INTEGER, ascii
  LOCAL encoded AS INTEGER
  FOR n = 1 TO h
    FOR m = 1 TO w
      encoded = GETBDF(array(m,n))
      IF ascii = 0 THEN PRINT encoded; " "; ELSE PRINT CHR$(encoded); " ";
    NEXT m
    PRINT
  NEXT n
END SUB

FUNCTION SETSPRITEINFO(tile AS INTEGER, spage AS INTEGER, row AS INTEGER, frameCount AS INTEGER )
  SETSPRITEINFO = SETSPRITEFRAMES(SETSPRITEROW(SETSPRITEPAGE(tile,spage),row),frameCount)
END FUNCTION

FUNCTION BDF2TILE( bdf AS STRING ) AS INTEGER
  LOCAL tile = SETBDF(0,bdf)
  IF bdf = "W" THEN 
    BDF2TILE = SETSPRITEINFO(tile,3,1,1)
  ELSEIF bdf = "w" THEN 
    BDF2TILE = SETROUNDED(SETSPRITEINFO(tile,3,2,1))
  ELSEIF bdf = "." THEN 
    BDF2TILE = SETEDIBLE(SETSPRITEINFO(tile,3,3,1))
  ELSEIF bdf = " " THEN 
    BDF2TILE = SETEDIBLE(SETSPRITEINFO(tile,3,4,1))
  ELSEIF bdf = "D" THEN 
    BDF2TILE = SETEDIBLE(SETHEAVY(SETROUNDED(SETSPRITEINFO(tile,3,5,15))))
  ELSEIF bdf = "r" THEN 
    BDF2TILE = SETHEAVY(SETROUNDED(SETSPRITEINFO(tile,3,6,1)))
  ELSEIF bdf = "f" THEN 
    BDF2TILE = SETSPRITEINFO(tile,3,7,2)
  ENDIF
END FUNCTION

SUB LOADSPRITESFOR bdf AS STRING, name AS STRING, resolution AS INTEGER, pgOverride AS INTEGER
  LOCAL layer = 1
  LOCAL tile = BDF2TILE(bdf)
  LOCAL row = GETSPRITEROW(tile)
  LOCAL spage
  IF pgOverride >= 0 THEN 
    spage = pgOverride 
  ELSE 
    spage = GETSPRITEPAGE(tile)
  ENDIF
  PAGE WRITE spage
  SPRITE LOAD name + STR$(resolution) + ".spr",1
  LOCAL n
  FOR n = 1 TO GETSPRITEFRAMES(tile)
    SPRITE SHOW n,(n-1)*resolution,(row-1)*resolution,layer
  NEXT n
  SPRITE CLOSE ALL
END SUB


SUB LOADALLSPRITES16 pgOverride AS INTEGER
  LOADSPRITESFOR "W", "steelwall",16, pgOverride
  LOADSPRITESFOR "w", "wall",16, pgOverride
  LOADSPRITESFOR ".", "dirt",16, pgOverride
  LOADSPRITESFOR " ", "emptyspace",16, pgOverride
  LOADSPRITESFOR "D", "diamond",16, pgOverride
  LOADSPRITESFOR "r", "rock",16, pgOverride
  LOADSPRITESFOR "f", "rockford",16, pgOverride
END SUB

FUNCTION FINDROCKFORDX w AS INTEGER, h AS INTEGER, board() AS INTEGER
  FOR n = 1 TO h
    FOR m = 1 to w
      IF GETBDF(board(m,n)) = "f" THEN FINDROCKFORDX = m-1
    NEXT m
  NEXT n
  FINDROCKFORDX = -1
END FUNCTION

FUNCTION FINDROCKFORDY w AS INTEGER, h AS INTEGER, board() AS INTEGER
  FOR n = 1 TO h
    FOR m = 1 to w
      IF GETBDF(board(m,n)) = "f" THEN FINDROCKFORDY = n-1
    NEXT m
  NEXT n
  FINDROCKFORDY = -1
END FUNCTION

