CONST SCROLL_STEP=5
OPTION EXPLICIT
FONT 7

#INCLUDE "utils.inc" 

DIM animClock AS INTEGER
DIM renderClock AS INTEGER
DIM gameSemaphore AS INTEGER

MODE 3, 8, 0, renderTick

CONST TILE_SIZE=16

animClock = 0
renderClock = 0
gameSemaphore = 0

CONST SCREEN_PIXELS_W = MM.HRES
CONST SCREEN_PIXELS_H = MM.VRES


DIM VIEWPORT_W AS INTEGER = 20
DIM VIEWPORT_H AS INTEGER = 12

DIM VIEWPORT_W_PX AS INTEGER = VIEWPORT_W * TILE_SIZE
DIM VIEWPORT_HALF_W_PX AS INTEGER = VIEWPORT_W_PX / 2
DIM VIEWPORT_H_PX AS INTEGER = VIEWPORT_H * TILE_SIZE
DIM VIEWPORT_HALF_H_PX AS INTEGER = VIEWPORT_H_PX / 2

DIM ROOM_W AS INTEGER = 40
DIM ROOM_H AS INTEGER = 22

DIM ROOM_W_PX AS INTEGER = ROOM_W * TILE_SIZE
DIM ROOM_H_PX AS INTEGER = ROOM_H * TILE_SIZE

'load into their respective memory page, thus -1 arg
LOADALLSPRITES16 -1

DIM rockfordDir AS INTEGER = 0

PAGE WRITE 1

SETTICK 53,animTick,1
SETTICK 120,gameTick,2

'LOAD A TEST LEVEL
DIM room(ROOM_W,ROOM_H) AS INTEGER
DIM skipList(ROOM_H) AS INTEGER
DIM renderSkipList(ROOM_H) AS INTEGER
DIM scanned(ROOM_W,ROOM_H) AS INTEGER
DIM moving(ROOM_W,ROOM_H) AS INTEGER
DIM dir(ROOM_W,ROOM_H) AS INTEGER

BDF2BOARD ROOM_W,ROOM_H,level(),room()

DIM viewportX AS INTEGER = 0
DIM viewportY AS INTEGER = 0
DIM targetViewportX AS INTEGER = viewportX
DIM targetViewportY AS INTEGER = viewportY

CLS

DIM empty AS INTEGER = BDF2TILE(" ")
DIM emptyBase AS INTEGER = empty AND 255
DIM rockford AS INTEGER = BDF2TILE("f")
DIM rockfordInstance AS INTEGER
DIM rockfordBase AS INTEGER = rockford AND 255
DIM diamond AS INTEGER = BDF2TILE("D")
DIM diamondBase AS INTEGER = diamond AND 255

'''''''''''GAME LOOP'''''''''''''''

DIM gameRow AS INTEGER
DIM rockfordCol AS INTEGER = 0
DIM rockfordRow AS INTEGER = 0
DIM gameTickTime = 0

DO
  RENDERSCREEN
  KEYSCAN
  IF gameSemaphore = 1 THEN
    gameSemaphore = 0
    TIMER = 0
    IF rockfordCol <> 0 AND rockfordRow <> 0 THEN
      rockfordInstance = room(rockfordCol,rockfordRow)
      skipList(rockfordRow)=0
      skipList(rockfordRow+1)=0
      skipList(rockfordRow-1)=0
      IF rockfordDir <> 0 THEN
        room(rockfordCol,rockfordRow)=SETDIR(rockfordInstance,rockfordDir)
        moving(rockfordCol,rockfordRow)=1
        rockfordDir = 0
      ELSE
        moving(rockfordCol,rockfordRow)=0
      ENDIF
    ENDIF
    FOR gameRow = 1 TO ROOM_H-2
      IF skipList(gameRow) = 0 THEN SCANROW gameRow
    NEXT gameRow
    gameTickTime = TIMER
  ENDIF
LOOP

'''''''''''GAME LOGIC''''''''''''''

SUB SCANROW row AS INTEGER
  LOCAL n,tile,below,rd AS INTEGER
  LOCAL skippable = 1
  FOR n = 1 TO ROOM_W-2
    tile = room(n,row)
    IF INERT_MASK AND tile THEN
       'nothing
    ELSEIF scanned(n,row) THEN
      scanned(n,row)=0
      skippable=0
    ELSEIF HEAVY_MASK AND tile THEN
      below=room(n,row+1)
      IF (ROUNDED_MASK AND below) <> 0 AND moving(n,row)=0 THEN
        IF room(n-1,row) = empty AND room(n-1,row+1) = empty THEN
          room(n-1,row)=tile
          room(n,row)=empty
          moving(n-1,row)=1
          skippable=0
        ELSEIF room(n+1,row) = empty AND room(n+1,row+1) = empty THEN
          room(n+1,row)=tile
          room(n,row)=empty
          scanned(n+1,row)=1
          moving(n+1,row)=1
          skippable=0
        ENDIF
      ELSEIF below = empty THEN
        room(n,row+1)=tile
        room(n,row)=empty
        scanned(n,row+1)=1
        moving(n,row+1)=1
        skippable=0
      ELSEIF moving(n,row) THEN
        moving(n,row)=0
        skippable=0
      ENDIF
    ELSEIF (tile AND 255) = rockfordBase THEN 'this is rockford
      rockfordCol = n
      rockfordRow = row
      rd = GETDIR(tile)
      IF rd <> 0 THEN
        skippable = 0
        IF moving(n,row) THEN
          moving(n,row)=0
          IF rd = UP_MASK AND GETEDIBLE(room(n,row-1)) <> 0 THEN 
            room(n,row-1)=tile
            room(n,row)=empty
            rockfordRow = row-1
            PLAY TONE 200,200,20
          ELSEIF rd = DOWN_MASK AND GETEDIBLE(room(n,row+1)) <> 0 THEN 
            room(n,row+1)=tile
            room(n,row)=empty
            rockfordRow = row+1
            scanned(rockfordCol,rockfordRow)=1
            PLAY TONE 200,200,20
          ELSEIF rd = LEFT_MASK AND GETEDIBLE(room(n-1,row)) <> 0 THEN 
            room(n-1,row)=tile
            room(n,row)=empty
            rockfordCol = n-1
            PLAY TONE 200,200,20
          ELSEIF rd = RIGHT_MASK AND GETEDIBLE(room(n+1,row)) <> 0 THEN 
            room(n+1,row)=tile
            room(n,row)=empty
            rockfordCol = n+1
            scanned(rockfordCol,rockfordRow)=1
            PLAY TONE 200,200,20
          ELSE
            room(n,row)=tile
          ENDIF
          IF rockfordCol*16 >= (viewportX + VIEWPORT_W_PX - 64) OR rockfordCol*16 < (viewportX + 48) THEN MOVEVIEWPORT rockfordCol,0
          IF rockfordRow*16 >= (viewportY + VIEWPORT_H_PX - 32) OR rockfordRow*16 < (viewportY + 16) THEN MOVEVIEWPORT 0,rockfordRow
        ENDIF 
      ENDIF 
    ENDIF
  NEXT
  skipList(row)=skippable
  IF skippable = 0 THEN
    skipList(row+1)=0
    skipList(row-1)=0
  ENDIF
END SUB

'''''''DRAWING TO SCREEN'''''''''''

SUB RESETRENDERSKIPLIST
  LOCAL n
  FOR n = 0 TO ROOM_H-1
    renderSkipList(n)=0
  NEXT
END SUB

SUB RENDERSCREEN
  STATIC lastAnimClock = 0
  STATIC lastRenderClock = 0
  TIMER = 0
  LOCAL dX = SGN(targetViewportX - viewportX)*MIN(SCROLL_STEP,ABS(targetViewportX-viewportX))
  LOCAL dY = SGN(targetViewportY - viewportY)*MIN(SCROLL_STEP,ABS(targetViewportY-viewportY))
  viewportX = viewportX + dX
  viewportY = viewportY + dY
  LOCAL le = FIX(viewportX / TILE_SIZE)
  LOCAL re = FIX((viewportX + VIEWPORT_W_PX - 1)/TILE_SIZE)
  LOCAL te = FIX(viewportY / TILE_SIZE)
  LOCAL be = FIX((viewportY + VIEWPORT_H_PX - 1)/TILE_SIZE)
  LOCAL lazy AS INTEGER = (dx = 0) AND (dy = 0)
  RENDERAREA te,be,le,re,lazy
  BOX 0,VIEWPORT_H_PX,VIEWPORT_W_PX+TILE_SIZE,TILE_SIZE,1,RGB(BLUE),RGB(BLUE)
  BOX VIEWPORT_W_PX,0,TILE_SIZE,VIEWPORT_H_PX+TILE_SIZE,1,RGB(BLUE),RGB(BLUE)
  LOCAL elapsed = TIMER
  LOCAL msg AS STRING = "rockfordRow: " + STR$(rockfordRow) + " tick time: " + STR$(gameTickTime) + " render time: " + STR$(elapsed) + " "
  TEXT 0,192, msg, "LT", 7, 1, RGB(WHITE), RGB(BLUE)
  PAGE COPY 1 TO 0, I
  lastAnimClock = animClock
END SUB

SUB RENDERAREA te AS INTEGER, be AS INTEGER, le AS INTEGER, re AS INTEGER, lazy AS INTEGER
  LOCAL skippable,n,m,t
  FOR n=te TO be
    IF gameSemaphore = 1 THEN EXIT SUB 'abandon rendering to compute game frame
    skippable = 1
    IF lazy = 0 OR renderSkipList(n) = 0 OR skipList(n) = 0 THEN
      FOR m=le TO re
        t=room(m,n)
        BLIT (animClock MOD(t>>36 AND 15))*16,(t>>28 AND 240)-16,m*16-viewportX,n*16-viewportY,16,16,t>>28 AND 15
        IF t AND ANIMATED_MASK THEN skippable = 0
      NEXT
      renderSkipList(n)=skippable AND lazy
    ENDIF
  NEXT
END SUB

SUB MOVEVIEWPORT centerColumn AS INTEGER, centerRow AS INTEGER
  IF centerColumn > 0 THEN
    LOCAL edgeX = centerColumn * TILE_SIZE - VIEWPORT_HALF_W_PX + (TILE_SIZE/2)
    targetViewportX = MAX(0,edgeX)
    targetViewportX = MIN(targetViewportX, ROOM_W_PX-VIEWPORT_W_PX)
  ENDIF
 
  IF centerRow > 0 THEN  
    LOCAL edgeY = centerRow * TILE_SIZE - VIEWPORT_HALF_H_PX + (TILE_SIZE/2)
    targetViewportY = MAX(0,edgeY)
    targetViewportY = MIN(targetViewportY, ROOM_H_PX-VIEWPORT_H_PX)
  ENDIF
END SUB



'''''''HANDLING INPUTS''''''''''''

SUB KEYSCAN
  LOCAL keyNum
  LOCAL numKeys = KEYDOWN(0) 
  'FOR keyNum = 0 TO numKeys
    PROCESSKEY KEYDOWN(numKeys)
  'NEXT
END SUB


SUB PROCESSKEY k
  IF k = 128 THEN 
    rockfordDir = UP_MASK 'UP arrow key
  ELSEIF k = 129 THEN 
    rockfordDir = DOWN_MASK 'DOWN key
  ELSEIF k = 130 THEN 
    rockfordDir = LEFT_MASK 'LEFT key
  ELSEIF k = 131 THEN 
    rockfordDir = RIGHT_MASK 'RIGHT key
  ELSE
    rockfordDir = 0
  ENDIF
END SUB

SUB renderTick
  renderClock = renderClock + 1
END SUB

SUB animTick
  animClock = animClock + 1
END SUB

SUB gameTick
  gameSemaphore = 1
END SUB
 
