' nikolaus.bas - Zeige alle Loesungen fuer das Haus des Nikolaus
' This versions was tested under MMBasic Version 5.07.03pa1  & 5.07.03pa2
' running under wine/debian linux
' (c) 2021/22 Andreas Mueller, Gerolsbach (AMI), version 1.2
'
' Die Eckpunke des Hauses erhalten die Nummern 1..5
'
'            3
'           / \
'          2   4
'          | X |
'          1 - 5
'
' Eine Verbindung V zwischen zwei Eckpunkten wird durch das Paar (a=Anfangspunkt,e=Endpunkt) beschrieben
' Beispiel: V = (1,2) ist die Verbindung zwischen den Eckpunkten 1 und 2
'
' Ein "Pfad" wird durch eine Folge von Verbindungen Vi beschrieben: (1,2),(2,3),(3,4),(4,2),(2,5),(5,4),(4,1),(1,5)
'
' Ein gueltiger "Nikolauspfad" ist ein Pfad, der aus genau 8 Verbindungen besteht fuer welche gilt:
'
'   a) Es gibt keine Verbindung der Form (a,a) fuer alle Eckpunkte a (keine Schleifen)
'
'   b) Wenn (ai,ei) und (aj,ej) zwei benachbarte (j=i+1) Verbindungen im Pfad sind, dann gilt ei = aj.
'
'   c) Wenn die Verbindung (a,e) im Pfad ist, dann gibt es kein weitere Verbindung (a,e) oder (e,a) im Pfad.
'
'   d) Die Verbindungen (1,3),(3,1),(5,3) und (3,5) sind nicht erlaubt.
'
'   zu a) Ein Pfad hat keine Schleifen
'   zu b) Stellt sicher, dass der Pfad zusammenhaengend "in einem Zug" gezeichnet werden kann.
'   zu c) Sichert, dass keine Verbindung unabhaengig von der Laufrichtung zweimal durchlaufen wird. 
'   zu d) Sorgt fuer die typische Struktur/Form des Nikolaushauses.
'
'   Die kleinen Zeichenfehler sind Absicht ;-)

dim gx,gy,pen,farbe,heading,caos as integer
dim flag as integer = 1 ' 1 = graphische Ausgabe, 0 = Textausgabe
dim delay as integer = 100 ' Dauer der Verzoegerung beim Zeichnen in ms
      
cls   
Mode 9 ' running under MMBasic V5.07.03pa1 for Windows or wine/linux
dim nikolaus(16) as integer ' Speicher fuer einen vollstaendigen Pfad (8 Startpunkte und 8 Endpunkte)
caos = 0

do
  houses = 0
  for i = 1 to 16
    nikolaus(i) = 0
  next i
  cls
  turtle_reset  
  for a1 = 1 to 5
    for e1 = 1 to 5
      if gueltig(a1,e1) then
        nikolaus(1) = a1
        nikolaus(2) = e1
        a2 = e1     ' Regel b)
        for e2 = 1 to 5
          if gueltig(a2,e2) then
            nikolaus(3) = a2
            nikolaus(4) = e2
            a3 = e2
            for e3 = 1 to 5
              if gueltig(a3,e3) then
                nikolaus(5) = a3
                nikolaus(6) = e3
                a4 = e3
                for e4 = 1 to 5
                  if gueltig(a4,e4) then
                    nikolaus(7) = a4
                    nikolaus(8) = e4
                    a5 = e4
                    for e5 = 1 to 5
		      if gueltig(a5,e5) then
                        nikolaus(9) = a5
			nikolaus(10) = e5
                        a6 = e5
                        for e6 = 1 to 5
                          if gueltig(a6,e6) then
                            nikolaus(11) = a6
                            nikolaus(12) = e6
                            a7 = e6
                            for e7 = 1 to 5
                              if gueltig(a7,e7) then
                                nikolaus(13) = a7
                                nikolaus(14) = e7
                                a8 = e7
                                for e8 = 1 to 5
                                  if gueltig(a8,e8) then      
                                    nikolaus(15) = a8
                                    nikolaus(16) = e8
                                    printhaus ' success!
                                  endif
                                next e8
                                nikolaus(15)=0
                                nikolaus(16)=0
                              endif
			    next e7
                            nikolaus(14)=0
                            nikolaus(13)=0
                          endif
                        next e6
                        nikolaus(11)=0
                        nikolaus(12)=0
                      endif
                    next e5
                    nikolaus(9)=0
                    nikolaus(10)=0
                  endif
                next e4
                nikolaus(7)=0
                nikolaus(8)=0
              endif
            next e3
            nikolaus(5)=0
            nikolaus(6)=0
          endif
        next e2
        nikolaus(3)=0
        nikolaus(4)=0
      endif
    next e1
    nikolaus(1)=0
    nikolaus(2)=0
  next a1
  pause delay
  inc caos                   
loop
end
      
function gueltig(a,b) as integer ' pruefe neue Verbindung auf "Nikolauseigenschaft"
     
  if a = b then gueltig = 0 : exit function            ' nicht erlaubt nach Regel a) 
  if a = 1 and b = 3 then gueltig = 0 : exit function  ' nicht erlaubt nach Regel d)  
  if a = 5 and b = 3 then gueltig = 0 : exit function  ' nicht erlaubt nach Regel d) 
  if a = 3 and b = 1 then gueltig = 0 : exit function  ' nicht erlaubt nach Regel d)
  if a = 3 and b = 5 then gueltig = 0 : exit function  ' nicht erlaubt nach Regel d)
      
  for i = 1 to 15 step 2                               
    if (nikolaus(i) = a) and (nikolaus(i+1) = b) then 
      gueltig = 0 : exit function                      ' nicht erlaubt nach Regel c)
    endif  
    if (nikolaus(i) = b) and (nikolaus(i+1) = a) then
      gueltig = 0 : exit function                      ' nicht erlaubt nach Regel c)
    endif
  next i
      
  gueltig = 1 ' (a,b) ist eine gueltige neue Verbindung
  
end function 
      
      
sub printhaus
  local x,y,i,f as integer
  const size = 29
  inc houses
  if flag = 1 then ' graphische Ausgabe
    if nikolaus(1) = 1 then 
      x = 60+60*(houses mod 10)+(60-size)/2
      y = size+60+60*(houses \ 10)
    else
      x = 60+60*(houses mod 10)+size+(60-size)/2
      y = size+60+60*(houses \ 10)
    endif
    turtle_pen_up
    turtle_move x,y
    turtle_pen_down
    for i = 1 to 15 step 2
      zeichneverbindung (nikolaus(i),nikolaus(i+1),size,rgb(255-i*17,10*i,i*17))
    next i
  else ' Textausgabe
    print houses;": ";
    open "A:/nikolaus.txt" for append as #1
    print #1,houses;": ";
    print nikolaus(1);" ->";
    print #1,nikolaus(1);" -> ";
    for i = 2 to 14 step 2
      print nikolaus(i);" ->";
      print #1,nikolaus(i);" -> ";
    next i
    print nikolaus(16)
    print #1,nikolaus(16)
    close #1
  endif  
end sub
      
sub zeichneverbindung (a,b,l,c)
  turtle_pen_colour c
  f = caos - int(rnd*2*caos) ' bringt zufaellige fehler ein
  'f=0
  turtle_pen_down
  select case 10*a+b
  case 12 
    turtle_heading f
    turtle_forward l
  case 21
    turtle_heading 180+f
    turtle_forward l
  case 54
    turtle_heading f
    turtle_forward l
  case 45
    turtle_heading 180-f
    turtle_forward l
  case 15
    turtle_heading 90+f
    turtle_forward l
  case 51
    turtle_heading 270-f
    turtle_forward l
  case 24
    turtle_heading 90-f
    turtle_forward l
  case 42
    turtle_heading 270+f
    turtle_forward l
  case 23
    turtle_heading 30+f
    turtle_forward 0.90 * sqr(l^2+(l/2)^2)
  case 32
    turtle_heading 210-f
    turtle_forward 0.90 * sqr(l^2+(l/2)^2)
  case 43
    turtle_heading 330+f
    turtle_forward 0.90 * sqr(l^2+(l/2)^2)
  case 34
    turtle_heading 150-f
    turtle_forward 0.90 * sqr(l^2+(l/2)^2)
  case 14
    turtle_heading 45+f
    turtle_forward sqr(l^2*2)
  case 41
    turtle_heading 225-f
    turtle_forward sqr(l^2*2)
  case 52
    turtle_heading 315+f
    turtle_forward sqr(l^2*2)
  case 25
    turtle_heading 135-f
    turtle_forward sqr(l^2*2)
  end select
  turtle_pen_up 
  pause 1    
end sub     
  
sub turtle_reset
  gx=0
  gy=0
  pen=0
  heading=0
  farbe=rgb(black) and &hFFFFFFFFFFFEFEFE
end sub
  
sub turtle_pen_up
  pen=0
end sub
  
sub turtle_pen_down
  pen=1
end sub
  
sub turtle_move (x,y)
  if pen=1 then
    line gx,gy,x,y,,farbe
  end if
  gx = x
  gy = y
end sub
  
sub turtle_pen_colour (c)
  farbe = c and &hFFFFFFFFFFFEFEFE
end sub
  
sub turtle_heading (h)
  heading = h
end sub
  
sub turtle_forward (f)
 phi = pi*(heading+270)/180
 if pen=1 then
   line gx,gy,gx+f*cos(phi),gy+f*sin(phi),,farbe
 end if
 gx=gx+f*cos(phi)
 gy=gy+f*sin(phi)
end sub