
1 REM PROGRAM NAME JETSET
2 REM IFR FLITE SIMULATOR, BOEING 747
3 REM CREATED 6-28-81 BY GENE SZYMANSKI
4 REM REVISED 2-28-82
5 KEY OFF : DEF SEG=&H40 : POKE &H17,PEEK(&H17) OR 96
8 REM CONVERTED TO IBM PC BASIC ON 10-30-82
9 GOTO 23
10 REM PLOTS VARIABLE ON REVERSE BACKGROUND
11 LOCATE (YP+1),(XP+1): COLOR 0,7 : PRINT "";
12 PRINT USING F$;V1;
13 PRINT "": COLOR 7,0
14 RETURN
23 REM BEGIN CRUISE MODULE HERE
24 CLS : RANDOMIZE (VAL(MID$(TIME$,7,2))*10)
25 DIM M$(20)
26 KR=57.2958: XQ=64
27 RS=1 : IF RND(1)=<.5 THEN RS=-1
28 RW=(15-5)*RND(1)+5
29 RW=RS*RW
30 REM SET UP WIND TABLE
32 DIM WA(10,1)
34 FOR I=0 TO 7 : WA(I,0)=INT(359*RND(1)+1) : NEXT I
36 FOR I=8 TO 10 : WA(I,0)=90*RND(1)+225 : NEXT I
38 A=0
40 FOR I=1 TO 10 : WA(I,1)=25*RND(1)+A : A=A+25 : NEXT I
41 RS$(0)=STRING$(31,"-")
42 RS$(1)=SPACE$(13)+".   ."+SPACE$(13)
43 RS$(2)=SPACE$(11)+".       ."
44 RS$(3)=SPACE$(9)+STRING$(13,"-")
45 REM VOR STATION FREQS TABLE
46 DIM VF(15)
47 VF(0)=115.9 : VF(1)=113.8 : VF(2)=112.7
48 VF(3)=117.7 : VF(4)=117.8 : VF(5)=112.2
49 VF(6)=117.4 : VF(7)=115.5 : VF(8)=116.4
50 VF(9)=113.6 : VF(10)=116.9 : VF(11)=117!
51 VF(12)=112.3 : VF(13)=117.9 : VF(14)=115.7
52 VF(15)=112.8
62 REM ILS CONSTANTS FOR AIRPORTS
63 DIM VG(15,1)
64 VG(0,0)=238 : VG(0,1)=28
66 VG(2,0)=240 : VG(2,1)=30
69 VG(5,0)=90 : VG(5,1)=217
71 VG(7,0)=299 : VG(7,1)=164
72 VG(8,0)=166 : VG(8,1)=42
79 VG(15,0)=341 : VG(15,1)=75
100 REM VOR STATION COORDINATES TABLE
101 DIM VP(15,1)
102 VP(0,0)=40.633 : VP(0,1)=73.773
103 VP(1,0)=40.202 : VP(1,1)=74.495
104 VP(2,0)=42.358 : VP(2,1)=70.99301
105 VP(3,0)=41.282 : VP(3,1)=70.027
106 VP(4,0)=42.74301 : VP(4,1)=73.802
107 VP(5,0)=46.41201 : VP(5,1)=84.315
108 VP(6,0)=38.35 : VP(6,1)=81.77001
109 VP(7,0)=40.917 : VP(7,1)=77.99301
110 VP(8,0)=42.928 : VP(8,1)=78.64701
111 VP(9,0)=41.358 : VP(9,1)=82.162
112 VP(10,0)=42.96701 : VP(10,1)=83.74201
113 VP(11,0)=44.555 : VP(11,1)=88.19501
114 VP(12,0)=41.547 : VP(12,1)=88.318
115 VP(13,0)=39.495 : VP(13,1)=76.97801
116 VP(14,0)=42.048 : VP(14,1)=83.458
117 VP(15,0)=39.637 : VP(15,1)=75.303
155 DATA FUEL,LBS,%,VHF,MHZ,THRUST,MAX,IDLE,REV
160 DATA PITCH," +"," -",DEG,FLAPS,UP,DWN,WHEELS,UP,MID,DOWN
165 DATA COMPASS,AIRSPEED,KTS," VERT",SPEED,FPM
170 DATA ALTITUDE,FEET,CLOCK
175 DIM P$(28)
180 FOR I=0 TO 28 : READ P$(I) : NEXT I
185 DIM S$(25)
190 FOR I=1 TO 25 : S$(I)=SPACE$(I) : NEXT I
192 FOR I=0 TO 9 : F(I)=0 : NEXT I
195 REM INIT FLITE VARIABLES TO STATE AT LIFTOFF
196 FU=195480!:FP=63:CC=75:ZZ=380:RC=6704:AL=1900
198 MZ=77:TR=4:FL=1:FA=10:BR=10:WH=10
200 RA=0:ZZ(1)=380:FA(1)=10:CC(1)=75:AL(1)=1900:RP=40
201 DP(4)=39:DP(5)=52:DP(6)=75:DP(7)=15
202 L1=39.8667:G1=75.25:LL(1)=L1:GL(1)=G1:LS(1)=L1:GS(1)=G1
203 VO(1)=0!:VO$(1)="OUT ":VO(3)=0:VO(4)=999.9
204 GX(0)=0:GY(0)=0
205 XO=36481!:YO=0
220 TV$=TIME$:GOSUB 7050 :TL=TD
221 TW(1)=TD
222 GOSUB 335
224 GOSUB 600
300 K$=INKEY$:IF K$<>"" THEN GOSUB 800
304 GOTO 1000
335 REM DISPLAY PANEL HEADERS ONLY
340 LOCATE 1,4 :PRINT P$(0);S$(4);P$(5);S$(3);P$(9);S$(3);S$(6);S$(3);P$(20)
341 LOCATE 10,55 :PRINT P$(13);S$(3);P$(16)
342 LOCATE 11,57 :PRINT P$(14);S$(6);P$(14)
343 LOCATE 13,57 :PRINT P$(15);S$(5);P$(15)
345 LOCATE 2,14 :PRINT P$(6);S$(6);P$(10);S$(6)
350 LOCATE 2,69 :PRINT P$(28)
355 LOCATE 3,2 :PRINT P$(1);S$(4);P$(2);S$(21);S$(3);S$(13);P$(23)
360 LOCATE 4,23 :PRINT P$(11);S$(13);P$(21);S$(2);P$(24);S$(2);P$(26)
365 LOCATE 5,1 :PRINT P$(3)
370 LOCATE 6,40 :PRINT P$(22);S$(6);P$(25);S$(5);P$(27)
375 LOCATE 7,1 :PRINT P$(4);S$(10);P$(7);S$(3);P$(12);S$(7)
380 LOCATE 8,14 :PRINT P$(8)
381 LOCATE 4,69 :PRINT"VLF OMEGA":LOCATE 5,66 :PRINT"LAT"
382 LOCATE 6,65 :PRINT"LONG"
383 LOCATE 7,33 :PRINT". . . . | . . . .": LOCATE 9,40 :PRINT"RUD"
384 LOCATE 10,33 :PRINT CHR$(218);STRING$(15,196);CHR$(191)
386 FOR X=33 TO 49 STEP 16
387 FOR Y=11 TO 23
388 LOCATE Y,X :PRINT CHR$(179);
389 NEXT Y
390 NEXT X
391 LOCATE 24,33 :PRINT CHR$(192);STRING$(15,196);CHR$(217);
392 LOCATE 11,40 :PRINT"VOR": LOCATE 12,45 :PRINT"MHZ"
393 LOCATE 15,39 :PRINT"RANGE"
394 LOCATE 17,36 :PRINT".....:....."
395 LOCATE 20,39 :PRINT"RADIAL"
396 LOCATE 22,40 :PRINT"DME": LOCATE 23,45 :PRINT"NM";
397 FOR Y=2 TO 8 : LOCATE Y,13 :PRINT CHR$(196): NEXT Y
398 FOR Y=2 TO 4 : LOCATE Y,22 :PRINT CHR$(196) : NEXT Y
400 LOCATE 15,1 :PRINT CHR$(218);STRING$(15,196);CHR$(191)
402 FOR X=1 TO 17 STEP 16
404 FOR Y=16 TO 22
406 LOCATE Y,X :PRINT CHR$(179);
408 NEXT Y
410 NEXT X
412 LOCATE 23,1 :PRINT CHR$(192);STRING$(15,196);CHR$(217);
414 LOCATE 14,8 :PRINT"ILS"
416 LOCATE 18,20 :PRINT"MARKER": LOCATE 19,21 :PRINT">  <"
418 GX(1)=0 : GY(1)=0
420 GOSUB 2100
422 COLOR 0,7 : LOCATE 11,7 :PRINT"     "
424 COLOR 7,0 : LOCATE 10,5 :PRINT"RADAR ALT";SPC(6);"STALL"
425 LOCATE 11,19 :PRINT">     <"
599 RETURN
600 REM DISPLAY INSTRUMENT READINGS
601 REM DISPLAY RUDDER POSIT
602 LOCATE 8,33:COLOR 0,7:PRINT S$(17)
603 LOCATE 8,(RP+1):PRINT CHR$(24): COLOR 7,0
605 YP=1:XP=0:F$="######":V1=FU:GOSUB 10
610 YP=1:XP=7:F$="###":V1=FP:GOSUB 10
615 YP=1:XP=39:V1=CC:GOSUB 10
620 YP=4:XP=39:V1=ZZ:GOSUB 10
625 YP=4:XP=46:F$="######":V1=RC:GOSUB 10
630 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 10
635 YP=5:XP=0:F$="###":V1=MZ:GOSUB 10
636 IF F(2)=1 THEN YP=10:XP=6:F$="#####":V1=AL:GOSUB 10
638 TV$=TIME$ : LOCATE 1,67 :PRINT TV$
640 REM DISPLAY THRUST
650 FOR I=2 TO 8
651 LOCATE I,12:COLOR 0,7:PRINT" "
652 NEXT I
655 LOCATE (TR+1),12 :PRINT">";
660 REM DISPLAY FLAPS
665 FOR I=2 TO 4 : LOCATE I,21:COLOR 0,7:PRINT" ": NEXT I
670 LOCATE (FL+1),21:PRINT">"
674 F$="+###"
675 YP=5:XP=20:V1=FA:GOSUB 10
676 IF F(6)=0 THEN SX=7 :SSX=0 :GOTO 679
677 IF SX=7 THEN SX=0 :SSX=7 :GOTO 679
678 SX=7 : SSX=0
679 IF F(7)=0 THEN COLOR SX,SSX:LOCATE 11,20 :PRINT"     "
680 REM DISPLAY BRAKES
690 FOR I=11 TO 13 :LOCATE I,55:COLOR 0,7:PRINT" ":NEXT I
695 LOCATE (BR+1),55:PRINT">"
700 REM WHEELS
705 FOR I=11 TO 13:LOCATE I,63:COLOR 0,7:PRINT" ":NEXT I
710 LOCATE (WH+1),63:PRINT">"
711 IF F(2)=1 GOTO 723
712 REM DISPLAY LAT/LONGIT
713 YP=4:XP=69:F$="###":V1=DP(4):GOSUB 10
714 YP=4:XP=73:F$="##.#":V1=DP(5):GOSUB 10
715 YP=5:XP=69:F$="###":V1=DP(6):GOSUB 10
716 YP=5:XP=73:F$="##.#":V1=DP(7):GOSUB 10
717 LOCATE 5,79:PRINT"N"
718 LOCATE 6,79:PRINT"W"
723 IF F(2)=1 THEN RETURN
724 REM DISPLAY VOR VALUES
725 YP=11:XP=38:F$="###.#":V1=VO(1):GOSUB 10
726 LOCATE 14,40:COLOR 0,7:PRINT VO$(1):COLOR 7,0
727 YP=18:XP=39:F$="###":V1=VO(3):GOSUB 10
728 YP=22:XP=38:F$="###.#":V1=VO(4):GOSUB 10
729 LOCATE 18,35:COLOR 0,7:PRINT S$(13)
730 IF VO$(1)="OUT " GOTO 732
731 LOCATE 18,(VO(2)+1):PRINT CHR$(24)
732 RETURN
800 REM KEY POLL SUBROUTINE
805 IF K$="F" THEN TR=TR-1:IF TR<1 THEN TR=1:  'INCREASE THRUST
807 IF K$="S" THEN TR=TR+1:IF TR>6 THEN TR=6:  'DECREASE THRUST
810 IF K$="," THEN RA=RA-1:IF RA<-4 THEN RA=-4:'GO LEFT
811 IF K$="." THEN RA=RA+1:IF RA>4 THEN RA=4:  'GO RIGHT
812 IF K$="/" THEN RA=0
815 IF (K$<>"2") AND (K$<>"8") GOTO 830
817 J=5:IF BR=12 THEN J=1:  'ADJUST ELEVATOR
819 IF K$="2" THEN FA=FA+J ELSE FA=FA-J
821 IF FA<-40 THEN FA=-40
823 IF FA>40 THEN FA=40
825 IF FA>0 THEN FL=1
827 IF FA=0 THEN FL=2
830 IF K$<>"W" GOTO 836
833 IF WH=10 THEN WH=12 ELSE WH=10:   'WHEELS
836 IF K$="V" THEN LOCATE 15,56:PRINT "";:INPUT "VOR FREQ ";VO(1):LOCATE 15,56:PRINT SPC(16);"":    'VOR FREQUENCY
839 IF K$="R" THEN LOCATE 15,56:PRINT "";:INPUT "VOR RADIAL ";VO(3):LOCATE 15,56:PRINT SPC(16);"":   'RADIAL
842 IF K$<>"L" GOTO 848
845 IF BR=10 THEN BR=12 ELSE BR=10:   'FLAPS
848 IF K$="A" THEN F(3)=1:   'DISPLAY NEAREST RADIAL
851 IF K$="Q" THEN IF F(7)=1 THEN TR=7:  'REVERSE THRUST
854 IF K$="M" THEN IF F(2)=0 THEN FA=0:  'ABORT LANDING
857 IF K$="6" THEN FA=1:FL=1:IF F(2)=0 THEN FA=0:FL=2:   'FLARE
860 RETURN
1000 REM SITUATION UPDATE ROUTINE
1002 TV$=TIME$:GOSUB 7050:TJ=TD-TL:TL=TD
1009 REM UPDATE FUEL
1010 FU=FU-(14-TR)*TJ:IF FU<0 THEN FU=0
1011 FP=FU/3120
1012 GOSUB 1130
1013 GOSUB 1145
1014 IF TR=7 THEN GOSUB 1800 ELSE GOSUB 1124
1016 GOSUB 1106
1018 GOSUB 1114
1019 IF F(2)=1 THEN GOTO 1600
1020 GOSUB 1400
1021 GOSUB 1500
1030 IF AL<=0 THEN AF=1:GOTO 3000
1031 IF F(2)=0 THEN GOTO 1099
1032 IF AL>0 GOTO 1068
1033 IF F(7)=1 GOTO 1090
1034 F(7)=1
1036 TY=YN
1038 TX=XN-750
1042 IF FA>1 THEN AF=2:GOTO 3000
1044 IF FA<0 THEN AF=3:GOTO 3000
1046 IF F(6)=0 GOTO 1062
1048 IF AX>100 THEN AF=4:GOTO 3000
1050 IF AX>80 THEN AF=5:GOTO 3000
1052 IF WH=10 THEN AF=6:GOTO 3000
1054 IF TX>0 THEN AF=7:GOTO 3000
1056 IF TX<-10500 THEN AF=7:GOTO 3000
1058 IF ABS(TY)>100 THEN AF=7:GOTO 3000
1060 GOTO 1099
1062 AF=8:GOTO 3000
1068 IF F(5)=1 GOTO 1082
1070 IF FA>0 GOTO 1076
1072 IF FA<0 THEN F(6)=0
1074 GOTO 1099
1076 IF F(6)=0 THEN AX=AL:F(6)=1
1077 IF TR=6 GOTO 1080
1078 IF FA<2 THEN RC=-1800:GOTO 1099
1079 FA=2:FL=1:RC=-1800:GOTO 1099
1080 FA=1:FL=1:RC=-300:GOTO 1099
1082 IF AL<20 THEN AF=9:GOTO 3000
1084 TR=3:FA=0:FL=2
1086 AF=10:GOTO 3000
1090 IF XN<-9750 OR ABS(YN)>100 GOTO 1094
1091 IF ZZ>0 GOTO 1099
1092 AF=0:GOTO 3000
1094 AF=9:GOTO 3000
1099 GOTO 1700
1106 IF F(7)=1 THEN RC=0:GOTO 1112
1107 IF F(6)=1 GOTO 1112
1108 RC=ZZ*SIN(ABS(FA/KR))*101.6
1110 IF FA<0 THEN RC=-1*RC
1112 RETURN
1114 REM UPDATE ALTITUDE
1115 IF F(7)=1 GOTO 1122
1116 AL=AL+TJ*RC/60
1118 IF AL<0 THEN AL=0:GOTO 1122
1120 IF AL>45000! THEN AL=45000!
1122 RETURN
1124 REM UPDATE AIRSPEED
1125 ZZ=800-100*TR
1126 ZZ=ZZ-2*FA
1127 IF BR=10 THEN RETURN
1128 ZZ=ZZ/3+20:RETURN
1130 IF F(5)=1 GOTO 1132
1131 IF F(2)=1 GOTO 1142
1132 IF RA=0 THEN RT=0:GOTO 1141
1133 IF RA<0 THEN J=-1 ELSE J=1
1134 RA=ABS(RA):IF RA=1 THEN RT=1:GOTO 1137
1135 IF RA=2 THEN RT=10:GOTO 1137
1136 IF RA=3 THEN RT=20 ELSE RT=30
1137 RT=J*RT:RA=J*RA
1138 CC=CC+RT
1139 IF CC=>360 THEN CC=CC-360:GOTO 1141
1140 IF CC<0 THEN CC=360+CC
1141 RETURN
1142 IF RA=0 THEN GOTO 1141
1143 IF RA<0 THEN CC=CC-1 ELSE CC=CC+1
1144 RA=0:GOTO 1139
1145 REM UPDATE RUDDER POSIT VARIABLE
1146 RP=40+RA+RA:RETURN
1200 REM COMPUTES DIST&BEARING TO A KNOWN POINT LOCATION
1202 VL=ABS(LB-LC):BL(5)=-1:IF LB=>LC THEN BL(5)=1
1204 VG=ABS(GB-GC):BL(4)=1:IF GB=>GC THEN BL(4)=-1
1206 LA=LC:GOSUB 2400
1208 M1=MP
1210 LA=LB:GOSUB 2400
1212 M2=MP:DM=ABS(M2-M1)
1214 IF DM=0 GOTO 1220
1216 QO=VG/(DM/60):IF QO>114.59 GOTO 1220
1218 CA=KR*ATN(QO):DR=VL*(1/COS(CA/KR)):GOTO 1222
1220 CA=90:DR=VG*COS(LC/KR)
1222 DR=DR*60:IF BL(5)=-1 GOTO 1226
1224 IF BL(4)=1 THEN CR=CA ELSE CR=360-CA
1225 GOTO 1228
1226 IF BL(4)=1 THEN CR=180-CA ELSE CR=180+CA
1228 RETURN
1250 REM GET WIND VECTOR FOR CURRENT ALTITUDE
1252 I=FIX(AL/4000):IF I=>10 THEN I=10
1254 WD=WA(I,0):WV=WA(I,1)
1256 RETURN
1260 REM SOLVES WIND TRIANGLE
1262 A=CC:L=AJ:GOSUB 1300
1264 MX=LX:MY=LY
1266 GOSUB 1250
1268 A=WD+180:IF A=>360 THEN A=A-360
1270 L=WV:GOSUB 1300
1272 MX=MX+LX:MY=MY+LY:GOSUB 1350
1274 TK=MA:GS=VZ
1276 RETURN
1300 REM RESOLVES A VECTOR INTO RECT. COORD.
1302 IF A<=90 THEN Q=1:B=90-A:GOTO 1310
1304 IF A<=180 THEN Q=2:B=A-90:GOTO 1310
1306 IF A<=270 THEN Q=3:B=270-A:GOTO 1310
1308 Q=4:B=A-270
1310 LX=L*COS(B/KR):LY=L*SIN(B/KR)
1312 IF Q=1 THEN GOTO 1320
1314 IF Q=2 THEN LY=-1*LY:GOTO 1320
1316 IF Q=3 THEN LX=-1*LX:LY=-1*LY:GOTO 1320
1318 LX=-1*LX
1320 RETURN
1350 REM COMPOSES X,Y COMPONENTS INTO A POLAR VECTOR
1352 VZ=SQR(MX^2+MY^2)
1354 IF MX<=0 GOTO 1358
1356 IF MY<=0 THEN Q=2 ELSE Q=1
1357 GOTO 1360
1358 IF MY<=0 THEN Q=3 ELSE Q=4
1360 IF MX=0 THEN MA=90:GOTO 1366
1362 MQ=ABS(MY/MX)
1364 MA=ATN(MQ)*KR
1366 IF Q=1 THEN MA=90-MA:GOTO 1374
1368 IF Q=2 THEN MA=90+MA:GOTO 1374
1370 IF Q=3 THEN MA=270-MA:GOTO 1374
1372 MA=270+MA
1374 RETURN
1400 REM GET POSIT FOR OMEGA DISPLAY
1402 ZZ(2)=ZZ:FA(2)=FA:CC(2)=CC:AL(2)=AL
1404 ZZ=ZZ(1):FA=FA(1):CC=CC(1):AL=AL(1)
1406 IF ZZ(2)<>ZZ OR FA(2)<>FA GOTO 1440
1408 IF CC(2)<>CC OR AL(2)<>AL GOTO 1440
1410 F(0)=1:IF TD<TW(1)+60 GOTO 1442
1412 AJ=ZZ*COS(ABS(FA)/KR)
1414 GOSUB 1260
1416 DN=GS*(TD-TW(1))/3600
1418 CN=TK:L1=LL(1):GL=GL(1)
1420 GOSUB 2000
1422 F(0)=0:TW(1)=TD:LL(1)=L2:GL(1)=G2
1424 LS(1)=L2:GS(1)=G2
1426 FOR J=4 TO 7: DP(J)=CP(J): NEXT J
1428 ZZ(1)=ZZ(2):FA(1)=FA(2):CC(1)=CC(2):AL(1)=AL(2)
1430 ZZ=ZZ(2):FA=FA(2):CC=CC(2):AL=AL(2)
1432 RETURN
1440 TW(1)=TD:F(0)=0
1442 AJ=ZZ*COS(ABS(FA)/KR)
1444 GOSUB 1260
1446 DN=GS*TJ/3600
1448 CN=TK:L1=LS(1):G1=GS(1)
1450 GOSUB 2000
1452 LS(1)=L2:GS(1)=G2
1454 IF F(0)=1 GOTO 1458
1456 LL(1)=L2:GL(1)=G2
1458 GOTO 1426
1500 REM VOR ROUTINE
1502 IF VO(1)=0 GOTO 1540
1504 FOR J=0 TO 15: IF VO(1)=VF(J) GOTO 1506
1505 NEXT J:GOTO 1540
1506 LC=VP(J,0):GC=VP(J,1)
1508 LB=L2:GB=G2
1509 AR=VG(J,0):LL=VG(J,1)
1510 LO=360-LL
1512 GOSUB 1200
1514 IF DR>300 GOTO 1540
1516 IF CR=>360 THEN CR=CR-360
1517 GOTO 1578
1518 VO$(1)="FROM"
1519 VO(5)=CR-VO(3):IF VO(5)<=180 GOTO 1522
1520 VO(5)=VO(5)-360:GOTO 1524
1522 IF VO(5)<-180 THEN VO(5)=VO(5)+360
1524 IF ABS(VO(5))>90 THEN I1=VO(3):GOTO 1536
1526 IF VO$(1)="FROM" THEN I=-1 ELSE I=1
1527 IF I=1 THEN VO(3)=I1
1528 VO(2)=40+I*INT(VO(5)):VO(4)=DR
1530 IF VO(2)<35 THEN VO(2)=34
1532 IF VO(2)>45 THEN VO(2)=46
1534 GOTO 1560
1536 VO$(1)=" TO ":VO(3)=VO(3)+180: IF VO(3)=>360 THEN VO(3)=VO(3)-360
1538 GOTO 1519
1540 VO$(1)="OUT ":VO(4)=999.9:F(3)=0
1541 RETURN
1546 IF DR>12 OR DR<10 THEN MK=0:GOTO 1518
1548 IF AL>4000 THEN MK=0:GOTO 1518
1550 IF F(1)=1 THEN J=9 ELSE J=2.5
1552 IF CR>AR+J OR CR<AR-J THEN MK=0:GOTO 1518
1554 F(1)=1:MK=1:GOTO 1518
1560 IF MK=0 THEN COLOR 7,0 ELSE COLOR 0,7
1562 LOCATE 19,22:PRINT"  "
1564 COLOR 7,0
1566 IF MK=0 THEN F(1)=0:GOTO 1541
1570 IF CC>LL+1 OR CC<LL-1 GOTO 1541
1572 IF RA<>0 GOTO 1541
1574 F(1)=0:F(2)=1
1576 GOTO 1540
1578 IF F(3)=1 THEN VO(3)=CR:F(3)=0
1580 GOTO 1546
1600 REM ILS ROUTINE
1602 ZN=AL:TH=2.82471:MK=1
1603 DW=1.69*RW*TJ:IF F(7)=1 THEN DW=0
1604 IF F(7)=1 THEN CC=LL:RA=0
1606 CJ=CC
1608 IF CJ>180 THEN CJ=360-CJ:CJ=-1*CJ
1610 HA=LO+CJ
1612 DC=360-HA:TS=1:IF HA<180 THEN DC=HA:TS=-1
1614 IF DC<0 THEN DC=-1*DC:TS=-1*TS
1616 TL$="W":IF TS=1 THEN TL$="E"
1618 DD=1.69*ZZ*TJ
1620 DY=DD*SIN(DC/KR):DX=DD*COS(DC/KR)
1622 XN=XO-DX:IF TL$="E" THEN DY=-1*DY
1624 YN=YO+DY+DW
1626 LM=KR*ATN(AL/XN)
1628 BE=KR*ATN(ABS(YN)/ABS(XN)):IF BE>2.5 THEN MK=0
1630 J=(LM-TH)/.25:J=FIX(J)
1632 IF J>3 THEN J=3
1633 IF J<-3 THEN J=-3
1636 BE=BE/.25:BE=FIX(BE)
1637 IF BE<-7 THEN BE=-7
1638 IF BE>7 THEN BE=7
1639 IF YN=>0 THEN BE=-1*BE
1640 IF MK=0 GOTO 1648
1642 IF XN>34960! AND XN<38000! GOTO 1648
1644 IF XN>2534 AND XN<5574 GOTO 1648
1646 MK=0
1648 GX(1)=BE:GY(1)=J
1650 GOSUB 2100
1654 IF MK=0 THEN COLOR 7,0 ELSE COLOR 0,7
1656 LOCATE 19,22:PRINT"  "
1658 COLOR 7,0
1662 XO=XN:YO=YN
1664 IF F8=1 GOTO 1676
1666 IF XN>12000 GOTO 1676
1668 F8=1
1670 FOR I=1 TO 4
1672 LOCATE (14+I),50:PRINT RS$(I)
1674 NEXT I
1676 IF F8=0 GOTO 1699
1678 LOCATE 18,(XQ+1):PRINT" "
1680 YU=FIX(YN/16.7):XC=64+YU
1682 IF XC<49 THEN XC=49
1684 IF XC>79 THEN XC=79
1686 LOCATE 18,(XC+1):PRINT CHR$(24)
1688 XQ=XC
1699 GOTO 1031
1700 GOTO 1799
1799 GOTO 224
1800 REM REVERSE THRUST APPLIED
1802 IF F(4)=1 GOTO 1806
1804 VO=ZZ*1.152*1.47:F(4)=1
1806 V=VO-(3.23636)*TJ
1808 IF V<=0 THEN V=0
1810 VO=V
1812 ZZ=V/(1.152*1.47)
1814 RETURN
2000 REM COMPUTES NEW POSITION
2004 IF CN=0 THEN CA=0:LB(5)=1:LB(6)=1:GOTO 2014
2006 IF CN>0 AND CN<=90 THEN CA=CN:LB(5)=1:LB(6)=1:GOTO 2014
2008 IF CN>90 AND CN<=180 THEN CA=180-CN:LB(5)=-1:LB(6)=1:GOTO 2014
2010 IF CN>180 AND CN<=270 THEN CA=CN-180:LB(5)=-1:LB(6)=-1:GOTO 2014
2012 CA=360-CN:LB(5)=1:LB(6)=-1
2014 IF CA>89.5 GOTO 2034
2016 DL=DN*COS(CA/KR):DL=DL/60:LB(3)=LB(5)
2018 IF LB(3)=1 THEN L2=L1+DL:GOTO 2024
2020 L2=ABS(L1-DL)
2024 LA=L1:GOSUB 2400
2026 M1=MP
2028 LA=L2:GOSUB 2400
2030 M2=MP
2032 DM=ABS(M1-M2):DG=DM*TAN(CA/KR):GOTO 2036
2034 L2=L1:DG=DN/COS(L1/KR)
2036 DG=DG/60:LB(4)=LB(6)
2038 IF LB(4)=-1 GOTO 2046
2040 G2=ABS(G1-DG)
2044 GOTO 2050
2046 G2=G1+DG
2050 CP(4)=FIX(L2):CP(5)=(L2-CP(4))*60
2052 CP(6)=FIX(G2):CP(7)=(G2-CP(6))*60
2054 RETURN
2100 REM PLOT GLIDESLOPE CROSSHAIRS
2101 IF XO<=750 THEN RETURN
2102 X0=8+GX(0):X1=8+GX(1):Y0=18+GY(0):Y1=18+GY(1)
2103 COLOR 7,0
2104 FOR Y=16 TO 22:LOCATE Y,(X0+1):PRINT" ":NEXT Y
2106 LOCATE (Y0+1),2:PRINT STRING$(15,32)
2108 FOR Y=16 TO 22:LOCATE Y,(X1+1):PRINT CHR$(197):NEXT Y
2110 LOCATE (Y1+1),2:PRINT STRING$(15,197)
2112 LOCATE (Y1+1),(X1+1):PRINT CHR$(197)
2114 LOCATE 19,9:PRINT"O"
2116 GX(0)=GX(1):GY(0)=GY(1)
2118 RETURN
2400 REM COMPUTES MERIDIONAL PARTS,MP
2404 KM(0)=7915.704468#
2406 KM(1)=23.268932#
2408 KM(2)=.0525
2410 KM(3)=.000213
2414 IF LA=0 THEN LA=0+1/60
2416 IF LA>(89+59/60) THEN LA=89+59/60
2418 S1=SIN(LA/KR)
2420 S2=S1*S1:S3=S1*S2
2422 TM(0)=TAN((45+LA/2)/KR)
2424 TM(0)=KM(0)*LOG(TM(0))/LOG(10)
2426 TM(1)=KM(1)*S1
2428 TM(2)=KM(2)*S3
2430 TM(3)=KM(3)*S2*S3
2432 MP=TM(0)-TM(1)-TM(2)-TM(3)
2436 RETURN
3000 REM ABORT ROUTINES
3002 M$(1)="---------- A CRASH HAS OCCURRED ----------"
3004 M$(2)="YOU ACCIDENTALLY STALLED THE AIRCRAFT DURING FINAL APPROACH."
3006 M$(3)="THE STALL OCCURRED AT AN ALTITUDE OF"
3008 M$(4)="THE AIRCRAFT STRUCK THE GROUND IN A NOSE-HIGH ATTITUDE"
3010 M$(5)="THE IMPACT RUPTURED THE TAILSECTION OF THE FUSELAGE"
3012 M$(6)="---- LOCATION OF CRASH ----"
3013 M$(7)="---- LANDING POSITION ----"
3016 M$(8)="    PITCH ANGLE="
3018 M$(9)="    AIRSPEED="
3020 M$(10)="YOU FLARED AT TOO HIGH AN ALTITUDE DURING FINAL APPROACH."
3022 M$(11)="THE RESULTING STALL OCCURRED AT AN ALTITUDE OF"
3024 M$(12)="THE IMPACT RUPTURED THE"
3026 M$(13)="YOU FORGOT TO LOWER THE LANDING GEAR"
3028 M$(14)="YOU FAILED TO TOUCH DOWN INSIDE THE RUNWAY"
3030 M$(15)="------------- AN IMPROPER LANDING WAS MADE ----------"
3032 M$(16)="NO DAMAGE OR INJURIES OCCURRED"
3033 RL=0:IF TX>0 THEN RL=1
3034 RW=0:IF ABS(TY)>100 THEN RW=1
3040 N$(2)="FEET INSIDE THE RUNWAY"
3041 IF TX=>0 THEN N$(2)="FEET SHORT OF RUNWAY"
3042 N$(3)="FEET TO LEFT OF RUNWAY CENTERLINE"
3043 IF TY=>0 THEN N$(3)="FEET TO RIGHT OF RUNWAY CENTERLINE"
3044 RX=FIX(TX):RX=ABS(RX)
3045 RY=FIX(TY):RY=ABS(RY)
3050 IF AF=0 GOTO 3600
3055 AX=INT(AX):FA=INT(FA):ZZ=INT(ZZ)
3060 ON AF GOTO 3100,3150,3200,3250,3300,3350,3400,3450,3500,3550
3100 GOSUB 3700
3101 YP=4:XP=55:F$="##,###":V1=AL:GOSUB 10
3102 LOCATE 16,1:PRINT M$(1)
3104 PRINT"YOU FLEW INTO THE GROUND"
3106 PRINT"THE INSTRUMENT READINGS AT TIME OF CRASH ARE AS SHOWN ABOVE."
3108 GOTO 9999
3150 CLS
3152 PRINT M$(1)
3154 PRINT M$(2)
3156 PRINT M$(3);AX;"FEET."
3158 PRINT M$(4)
3160 PRINT M$(5)
3162 N$(1)=M$(6)
3164 GOSUB 3800
3166 GOTO 9999
3200 CLS
3202 PRINT M$(1)
3204 PRINT"YOU FLEW INTO THE GROUND DURING FINAL APPROACH."
3206 PRINT"AT TIME OF CRASH, THE AIRCRAFT PROFILE WAS AS FOLLOWS :"
3208 PRINT M$(8);FA;"DEGREES"
3210 PRINT M$(9);ZZ
3212 N$(1)=M$(6)
3214 GOSUB 3800
3216 GOTO 9999
3250 CLS
3252 PRINT M$(1)
3254 PRINT M$(10)
3256 PRINT M$(11);AX;"FEET."
3258 PRINT M$(12)+"FUSELAGE."
3260 N$(1)=M$(6)
3262 GOSUB 3800
3264 GOTO 9999
3300 CLS
3302 IF WH=10 THEN PRINT M$(1)
3304 IF WH=12 THEN PRINT"---------- A MINOR CRASH HAS OCCURRED ----------"
3306 PRINT M$(10)
3308 PRINT M$(11);AX;"FEET."
3310 IF WH=10 THEN PRINT M$(13)
3312 IF WH=10 THEN PRINT M$(12)+"FUSELAGE."
3314 IF WH=12 THEN PRINT"THE IMPACT DAMAGED THE LANDING GEAR."
3316 IF WH=12 THEN PRINT"ALL PASSENGERS HAVE BEEN SAFELY EVACUATED."
3318 N$(1)=M$(6)
3320 GOSUB 3800
3322 GOTO 9999
3350 CLS
3352 PRINT M$(1)
3354 PRINT M$(13)
3356 PRINT"THE AIRCRAFT LANDED ON ITS BELLY, CAUSING MODERATE DAMAGE."
3358 PRINT"ALL PASSENGERS HAVE BEEN SAFELY EVACUATED."
3360 N$(1)=M$(6)
3362 GOSUB 3800
3364 GOTO 9999
3400 CLS
3402 PRINT M$(15)
3404 PRINT M$(14)
3406 N$(1)=M$(7)
3408 GOSUB 3800
3410 GOTO 9999
3450 CLS
3452 PRINT M$(15)
3454 PRINT"YOU FAILED TO EXECUTE A FLARE PRIOR TO TOUCHING DOWN."
3456 PRINT"THIS IS A VIOLATION OF COMPANY PROCEDURES."
3458 PRINT M$(16)
3460 N$(1)=M$(7)
3462 GOSUB 3800
3464 GOTO 9999
3500 CLS
3502 PRINT M$(15)
3504 PRINT"YOU ROLLED OFF THE RUNWAY AFTER TOUCHING DOWN."
3506 PRINT M$(16)
3508 N$(1)=M$(7)
3512 GOSUB 3800
3513 PRINT
3514 IF XN<-9750 THEN PRINT"YOU ROLLED PAST FAR END OF RUNWAY."
3516 IF ABS(YN)>100 THEN PRINT"YOU ROLLED THRU RUNWAY SIDE BORDERS."
3518 GOTO 9999
3550 CLS
3552 PRINT"----- YOUR MISSED APPROACH SIGNAL IS ACKNOWLEDGED -----"
3554 PRINT"YOU HAVE FOLLOWED PROPER PROCEDURES."
3556 GOTO 9999
3600 CLS
3602 PRINT"----- YOU HAVE SUCCESFULLY COMPLETED THE FLIGHT -----"
3604 PRINT"ALL PROCEDURES WERE PROPERLY EXECUTED."
3606 N$(1)=M$(7)
3610 PRINT"CONGRATULATIONS ON A SUCCESSFUL FLIGHT."
3612 GOSUB 3800
3613 PRINT
3614 XN=ABS(XN):JN=FIX(XN+750)
3615 YN=ABS(YN):YN=FIX(YN)
3616 PRINT"YOUR AIRCRAFT CAME TO REST AT THE FOLLOWING POSITION :"
3617 PRINT"     ";JN;"FEET INSIDE THE RUNWAY"
3618 PRINT"     ";YN;"FEET FROM RUNWAY CENTERLINE"
3620 GOTO 9999
3700 REM SUBRTN TO CLEAR LOWER PART OF DISPLAY
3702 FOR I=10 TO 24
3704 LOCATE I,1:PRINT SPC(79);
3706 NEXT I
3708 RETURN
3800 REM LANDING STATISTICS
3802 PRINT
3804 PRINT SPACE$(26);N$(1)
3806 PRINT
3808 IF RL=0 THEN PRINT RX;N$(2)
3809 IF RL=1 THEN COLOR 0,7:PRINT RX;N$(2):COLOR 7,0
3810 PRINT
3812 IF RW=0 THEN PRINT RY;N$(3)
3813 IF RW=1 THEN COLOR 0,7:PRINT RY;N$(3):COLOR 7,0
3814 PRINT
3816 PRINT"--- SIZE OF RUNWAY IS 10,500 FEET X 200 FEET ---"
3818 RETURN
5085 REM TIME DELAY PAD
5090 FOR I=1 TO TQ
5095 NEXT I
5099 RETURN
7050 REM CONVERT RTC TO TIME OF DAY IN SECONDS ABSOLUTE
7055 J=7
7060 FOR I=0 TO 2
7065 TC$(I)=MID$(TV$,J,2)
7070 J=J-3
7075 TC(I)=VAL(TC$(I))
7080 TD=(3600*TC(2))+(60*TC(1))+TC(0)
7085 NEXT I
7090 RETURN
9999 END
