'Battelship+ program: 10x10, 15x15, 20x20, or 25x25 grid, 5, 10, 15, 20, 25, or 30 ships
'                     horizontal, vertical, and diagonal ship placement
option base 1
dim string a$, a1$, a2$, e$, v$, ship_square$ length 3
dim string ship_start_square$(60) length 3, ship_end_square$(60) length 3 '5 for player + 5 for computer 
dim string ship_orientation$(60) length 4 'h, v, d1, or d2
dim integer player_ships_grid(25, 25) 'values 0 to 5, 0 = no ship, 1 = destroyer, 2 = submarine,
dim integer computer_ships_grid(25, 25) '3 = cruiser, 4 = battleship, 5 = aircraft carrier
dim integer player_ham_grid(25, 25) 'values -1, 0, and 1, Hits and Misses
dim integer computer_ham_grid(25, 25) '0 = no shot fired here, 1 = hit, 2 = miss
dim integer ship_num, ship_length(60), taken, on_grid, lc, nc, hv
dim integer player_num_hits, computer_num_hits, xh1, yh1, xv1, yv1, xh2, yh2, xv2, yv2
dim integer xh3, yh3, xv3, yv3, xh4, yh4, xv4, yv4, xh5, yh5, xv5, yv5
dim integer lsl, lsn, lshm, direction 'last shot letter, number, and hit/miss
dim integer directions_tried, lhl, lhn, ssh, offset 'last hit letter, number, shots since hit
dim integer version, num_shots, first_round, who_shoots_first '1 = player, 2 = computer
dim integer grid_size, num_ships, r
mode 9, 16
page resize 1, 1024, 768
font 4 '10x16 pixels
who_shoots_first = 1
for i = 1 to 12  
  ship_length(5 * (i - 1) + 5) = 5
  ship_length(5 * (i - 1) + 4) = 4
  ship_length(5 * (i - 1) + 3) = 3
  ship_length(5 * (i - 1) + 2) = 3
  ship_length(5 * (i - 1) + 1) = 2
next i

play_again:
for j = 1 to 25
  for i = 1 to 25
    player_ships_grid(i, j) = 0
    computer_ships_grid(i, j) = 0
    player_ham_grid(i, j) = 0
    computer_ham_grid(i, j) = 0
  next i
next j
for i = 1 to 60
  ship_start_square$(i) = ""
  ship_end_square$(i) = ""
  ship_orientation(i) = ""
next i
ssh = 99 'set to an arbitrary high value
first_round = 1
color rgb(cyan)

do
  cls
  print @(10,  16) "Battleship+"
  print @(10,  48) "1. One shot per round"
  print @(10,  64) "2. Salvos / Multiple shots per round"
  print @(10,  96) "Which version (1 or 2)"
  print @(10, 112);: input version
  if version < 1 or version > 2 then continue do
  exit do
loop

do
  print @(10, 128) "Size of grid (10, 15, 20, or 25)"
  print @(10, 144);: input grid_size
  if grid_size <> 10 and grid_size <> 15 and grid_size <> 20 and grid_size <> 25 then continue do
  exit do
loop

do
  print @(10, 160) "How many ships per side (5, 10, 15, 20, 25, or 30)"
  print @(10, 176);: input num_ships
  if num_ships <> 5 and num_ships <> 10 and num_ships <> 15 and num_ships <> 20 and num_ships <> 25 and num_ships <> 30 then continue do
  exit do
loop

pause 2500
cls
page write 1
show_grid()
page copy 1 to 0, B
page write 0

print @(784,  16) "Battleship+"
color rgb(orange)
print @(784,  48) "5 (5L) Aircraft Carrier"
print @(784,  64) "4 (4L) Battleship"
print @(784,  80) "3 (3L) Cruiser"
print @(784,  96) "2 (3L) Submarine"
print @(784, 112) "1 (2L) Destroyer"
place_player_ships()
place_computer_ships()

do
  player_num_hits = 0
  computer_num_hits = 0
  player_alive = 0
  computer_alive = 0
  for i = 1 to grid_size
    for j = 1 to grid_size
      if player_ham_grid(i, j) = 1 then inc player_num_hits
      if computer_ham_grid(i, j) = 1 then inc computer_num_hits 
    next j
  next i
  if player_num_hits > (num_ships / 5 * 17) - 1) then
    print @(784, 230) "The player won!"
    play tts "You sank sams fleet"
    pause 4000
    exit do
  elseif computer_num_hits > (num_ships / 5 * 17) - 1) then
    print @(784, 230) "The computer won!"
    play tts "sam sank your fleet"
    pause 4000
    exit do
  endif
  if version = 1 then
    if who_shoots_first = 1 then
      player_single_guess()
      computer_single_guess()
    else
      computer_single_guess()
      player_single_guess()
    endif
  elseif version = 2 then
    if who_shoots_first = 1 then
      player_multiple_guesses()
      computer_multiple_guesses()
    else
      computer_multiple_guesses()
      player_multiple_guesses()
    endif
  endif
  first_round = 0
loop
ending()

sub place_player_ships
  for ship_num = num_ships to 1 step -1
    do
      print @(784, 150) "                      "
      print @(784, 166) "                      "
      print @(784, 198) "                      "
      print @(784, 214) "                      "
      print @(784, 230) "                      "
      print @(784, 246) "                      "

      do
        if ship_num mod 5 = 0 then
          print @(784, 150) "Start square 5"
        else
          print @(784, 150) "Start square"; ship_num mod 5
        endif       
        print @(784, 166);: input a1$
        taken = 0
        for j = 1 to num_ships
          if a1$ = ship_start_square$(j) then taken = 1 
        next j
        select case grid_size
          case 10
            if taken = 0 and len(a1$) < 4 and lcase$(left$(a1$, 1)) >= "a" and lcase$(left$(a1$, 1)) < "k" and val(mid$(a1$, 2, 2)) > 0 and val(mid$(a1$, 2, 2)) < 11 then exit do       
          case 15
            if taken = 0 and len(a1$) < 4 and lcase$(left$(a1$, 1)) >= "a" and lcase$(left$(a1$, 1)) < "p" and val(mid$(a1$, 2, 2)) > 0 and val(mid$(a1$, 2, 2)) < 16 then exit do
          case 20
            if taken = 0 and len(a1$) < 4 and lcase$(left$(a1$, 1)) >= "a" and lcase$(left$(a1$, 1)) < "u" and val(mid$(a1$, 2, 2)) > 0 and val(mid$(a1$, 2, 2)) < 21 then exit do
          case 25
            if taken = 0 and len(a1$) < 4 and lcase$(left$(a1$, 1)) >= "a" and lcase$(left$(a1$, 1)) < "z" and val(mid$(a1$, 2, 2)) > 0 and val(mid$(a1$, 2, 2)) < 26 then exit do
        end select
        print @(784, 166) "                      "
        exit do
      loop

      print @(784, 198) "Place (h)orizontal"
      print @(784, 214) "or (v)ertical"
      print @(784, 230) "or (d1)iagonal NWSE"
      print @(784, 246) "or (d2)iagonal SWNE"
      print @(784, 262);: input a2$    

      if a2$ = "h" then
        if val(mid$(a1$, 2, 2)) + ship_length(ship_num) - 1 > grid_size then continue do: 'off the edge of the grid       
        for i = 1 to ship_length(ship_num)
          if player_ships_grid(letter_to_num(left$(a1$, 1)), val(mid$(a1$, 2, 2)) + i - 1) > 0 then continue do 'overlaps with an existing ship        
        next i
      elseif a2$ = "v" then
        if letter_to_num(left$(a1$, 1)) + ship_length(ship_num) - 1 > grid_size then continue do 'off the edge of the grid
        for i = 1 to ship_length(ship_num)
          if player_ships_grid(letter_to_num(left$(a1$, 1)) + i - 1, val(mid$(a1$, 2, 2))) > 0 then continue do 'overlaps with an existing ship
        next i
      elseif a2$ = "d1" then 'NWSE
        if val(mid$(a1$, 2, 2)) + ship_length(ship_num) - 1 > grid_size then continue do
        if letter_to_num(left$(a1$, 1)) + ship_length(ship_num) - 1 > grid_size then continue do
        for i = 1 to ship_length(ship_num)
          if player_ships_grid(letter_to_num(left$(a1$, 1)) + i - 1, val(mid$(a1$, 2, 2)) + i - 1) > 0 then continue do
        next i
      elseif a2$ = "d2" then 'SWNE
        if val(mid$(a1$, 2, 2)) + ship_length(ship_num) - 1 > grid_size then continue do
        if letter_to_num(left$(a1$, 1)) - ship_length(ship_num) + 1 < 1 then continue do
        for i = 1 to ship_length(ship_num)
          if player_ships_grid(letter_to_num(left$(a1$, 1)) - i + 1, val(mid$(a1$, 2, 2)) + i - 1) > 0 then continue do
        next i
      else
        continue do
      endif
      exit do
    loop

    ship_start_square$(ship_num) = a1$
    ship_orientation$(ship_num) = a2$

    if a2$ = "h" then
      ship_end_square$(ship_num) = left$(ship_start_square$(ship_num), 1) + str$(val(mid$(ship_start_square$(ship_num), 2, 2)) + ship_length(ship_num) - 1)
    elseif a2$ = "v" then 
      ship_end_square$(ship_num) = end_letter(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)
    elseif a2$ = "d1" then 'NWSE
      ship_end_square$(ship_num) = end_letter(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)   
    elseif a2$ = "d2" then 'SWNE
      ship_end_square$(ship_num) = end_letter2(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)
    endif

    for i = 1 to ship_length(ship_num)
      if i = 1 then
        player_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
      else 'i > 1
        if a2$ = "h" then
          player_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num
        elseif a2$ = "v" then
          player_ships_grid(letter_to_num(end_letter(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
        elseif a2$ = "d1" then 'NWSE
          player_ships_grid(letter_to_num(end_letter(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num 
        elseif a2$ = "d2" then 'SWNE
          player_ships_grid(letter_to_num(end_letter2(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num
        endif
      endif
    next i

    lc = letter_to_num(left$(a1$, 1)) 'letter coordinate 
    nc = val(mid$(a1$, 2, 2 )) 'number coordinate
    show_ships()
        
    print @(784, 150) "                      "
    print @(784, 166) "                      "
    print @(784, 182) "                      "
    print @(784, 198) "                      "
    print @(784, 214) "                      "
    print @(784, 230) "                      "
    print @(784, 246) "                      "    
    print @(784, 262) "                      "
  next ship_num
end sub

sub place_computer_ships
  for ship_num = 2 * num_ships to num_ships + 1 step -1
    do    
      lc = int(rnd * grid_size + 1) 'random letter coordinate       
      nc = int(rnd * grid_size + 1) 'random number coordinate
      hv = int(rnd * 4 + 1) '1 = horizontal, 2 = vertical, 3 = d1 NWSE, 4 = d2 SWNE
      if hv = 1 then 'horizontal      
        if nc + ship_length(ship_num) - 1 > grid_size then continue do 'off the edge of the grid       
        for i = 1 to ship_length(ship_num)
          if computer_ships_grid(lc, nc + i - 1) > 0 then continue do 'overlaps with an existing ship        
        next i
      elseif hv = 2 then 'vertical
        if lc + ship_length(ship_num) - 1 > grid_size then continue do
        for i = 1 to ship_length(ship_num)
          if computer_ships_grid(lc + i - 1, nc) > 0 then continue do
        next i
      elseif hv = 3 then 'd1 NWSE
        if nc + ship_length(ship_num) - 1 > grid_size then continue do
        if lc + ship_length(ship_num) - 1 > grid_size then continue do
        for i = 1 to ship_length(ship_num)
          if computer_ships_grid(lc + i - 1, nc + i - 1) > 0 then continue do
        next i
      elseif hv = 4 then 'd2 SWNE
        if nc + ship_length(ship_num) - 1 > grid_size then continue do
        if lc - ship_length(ship_num) + 1 < 1 then continue do
        for i = 1 to ship_length(ship_num)
          if computer_ships_grid(lc - i + 1, nc + i - 1) > 0 then continue do
        next i
      endif
      exit do
    loop

    ship_start_square$(ship_num) = num_to_letter(lc) + str$(nc) 
    if hv = 1 then
      ship_orientation$(ship_num) = "h"
    elseif hv = 2 then
      ship_orientation$(ship_num) = "v"
    elseif hv = 3 then
      ship_orientation$(ship_num) = "d1"
    elseif hv = 4 then
      ship_orientation$(ship_num) = "d2"
    endif

    if hv = 1 then
      ship_end_square$(ship_num) = left$(ship_start_square$(ship_num), 1) + str$(val(mid$(ship_start_square$(ship_num), 2, 2)) + ship_length(ship_num) - 1)
    elseif hv = 2 then
      ship_end_square$(ship_num) = end_letter(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)
    elseif hv = 3 then 'NWSE
      ship_end_square$(ship_num) = end_letter(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)     
    elseif hv = 4 then 'SWNE
      ship_end_square$(ship_num) = end_letter2(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)
    endif

    for i = 1 to ship_length(ship_num)
      if i = 1 then
        computer_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
      else 
        if hv = 1 then
          computer_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num
        elseif hv = 2 then
          computer_ships_grid(letter_to_num(end_letter(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
        elseif hv = 3 then
          computer_ships_grid(letter_to_num(end_letter(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num           
        elseif hv = 4 then
          computer_ships_grid(letter_to_num(end_letter2(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num          
        endif
      endif
    next i
  next ship_num    
  pause 2000
end sub

sub show_grid
  color rgb(green) 
  load bmp "/Battleship/graphics/Ocean 768x768.bmp", 0, 0
  select case grid_size
    case 10
      font 5 '24x32
      for i = 0 to 10
        line 34, 70 * i + 34, 734, 70 * i + 34, 1, rgb(black) ' horizontals
        line 70 * i + 34, 34, 70 * i + 34, 734, 1, rgb(black) ' verticals
      next i  
      for i = 1 to 10
        text 5, 70 * i - 15, chr$(64 + i),,,, rgb(black), -1
        if i = 10 then
          text 70 * i - 25, 0, str$(i),,,, rgb(black), -1
        else
          text 70 * i - 12, 0, str$(i),,,, rgb(black), -1
        endif
      next i
    case 15 
      for i = 0 to 15
        line 34, 46.67 * i + 34, 734, 46.67 * i + 34, 1, rgb(yellow)
        line 46.67 * i + 34, 34, 46.67 * i + 34, 734, 1, rgb(yellow)
      next i
      for i = 1 to 15
        font 5 '24x32
        text 4, 46.67 * i - 3, chr$(64 + i),,,, rgb(yellow), -1
        font 3 '16x24
        if i > 9 then
          text 46.67 * i - 5, 5, chr$(48 + val(left$(str$(i), 1))) + chr$(48 + val(right$(str$(i), 1))),,,, rgb(yellow), -1
        else
          text 46.67 * i + 4, 5, chr$(48 + i),,,, rgb(yellow), -1
        endif
      next i
    case 20
      for i = 0 to 20
        line 34, 35 * i + 34, 734, 35 * i + 34, 1, rgb(white)
        line 35 * i + 34, 34, 35 * i + 34, 734, 1, rgb(white)
      next i
      for i = 1 to 20
        font 3 '16x24
        text 9, 35 * i + 3, chr$(64 + i),,,, rgb(white), -1
        font 2 '12x20
        if i > 9 then
          text 35 * i + 5, 10, chr$(48 + val(left$(str$(i), 1))) + chr$(48 + val(right$(str$(i), 1))),,,, rgb(white), -1
        else
          text 35 * i + 11, 10, chr$(48 + i),,,, rgb(white), -1
        endif
      next i
    case 25      
      for i = 0 to 25
        line 34, 28 * i + 34, 734, 28 * i + 34, 1, rgb(white)
        line 28 * i + 34, 34, 28 * i + 34, 734, 1, rgb(white)
      next i
      for i = 1 to 25
        font 3 '16x24
        text 10, 28 * i + 7, chr$(64 + i),,,, rgb(white), -1
        font 4 '10x16
        if i > 9 then
          text 28 * i + 11, 14, chr$(48 + val(left$(str$(i), 1))) + chr$(48 + val(right$(str$(i), 1))),,,, rgb(white), -1
        else
          text 28 * i + 17, 14, chr$(48 + i),,,, rgb(white), -1
        endif
      next i
  end select
  font 4
end sub

sub player_single_guess
  cls
  page write 1
  show_grid()  
  page copy 1 to 0, B
  page write 0
  for i = 1 to grid_size
    for j = 1 to grid_size
      if player_ham_grid(i, j) = 1 then
        select case grid_size
          case 10 
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(red), rgb(red)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(red), rgb(red) 
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(red), rgb(red) 
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(red), rgb(red)
        end select
      elseif player_ham_grid(i, j) = 2 then 
        select case grid_size
          case 10
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(white), rgb(white)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(white), rgb(white) 
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(white), rgb(white)
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(white), rgb(white)
        end select
      endif
    next j
  next i
    
  do
    print @(784, 150) "                "
    print @(784, 166) "                "
    print @(784, 198) "                "
    print @(784, 214) "                "
    print @(784, 230) "                "  
    print @(784, 150) "Shoot square"
    print @(784, 166);: input a$
  
    select case grid_size
      case 10
        if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "j" then continue do
      case 15
        if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "o" then continue do
      case 20
        if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "t" then continue do
      case 25
        if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "y" then continue do
    end select
    if val(mid$(a$, 2, 2)) < 1 or val(mid$(a$, 2, 2)) > grid_size then continue do
    if player_ham_grid(letter_to_num(left$(a$, 1)), val(mid$(a$, 2, 2))) > 0 then continue do 'Already shot this square
    exit do
  loop
  
  lc = letter_to_num(left$(a$, 1))  
  nc = val(mid$(a$, 2, 2))
  
  if computer_ships_grid(lc, nc) > 0 then
    print @(784, 198) "A hit!"
    player_ham_grid(lc, nc) = 1
    select case grid_size
      case 10
        circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(red), rgb(red)
      case 15
        circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(red), rgb(red)
      case 20
        circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(red), rgb(red)
      case 25
        circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(red), rgb(red)
    end select
    pause 2500
  else ' = 0
    print @(784, 198) "Missed"
    player_ham_grid(lc, nc) = 2
    select case grid_size
      case 10
        circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(white), rgb(white)
      case 15
        circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(white), rgb(white)
      case 20
        circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(white), rgb(white)
      case 25
        circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(white), rgb(white)
    end select
    pause 2500
  endif
end sub

sub computer_single_guess
  cls
  page write 1
  show_grid()
  page copy 1 to 0, B
  page write 0

  'Display the player's ships
  for ship_num = 1 to num_ships
    lc = letter_to_num(left$(ship_start_square$(ship_num), 1))
    nc = val(mid$(ship_start_square$(ship_num), 2, 2))
    a2$ = ship_orientation$(ship_num)
    show_ships() 
  next ship_num

  for i = 1 to grid_size
    for j = 1 to grid_size
      if computer_ham_grid(i, j) = 1 then
        select case grid_size
          case 10
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(red), rgb(red)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(red), rgb(red) 
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(red), rgb(red)
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(red), rgb(red)
        end select
      elseif computer_ham_grid(i, j) = 2 then
        select case grid_size
          case 10
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(white), rgb(white)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(white), rgb(white)   
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(white), rgb(white)
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(white), rgb(white)
        end select
      endif
    next j
  next i

  computer_guesses_main()
  print @(784, 150) "Computer guesses "; ucase$(num_to_letter(lc)) + str$(nc)

  if player_ships_grid(lc, nc) > 0 then
    print @(784, 198) "A hit!"
    computer_ham_grid(lc, nc) = 1
    select case grid_size
      case 10
        circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(red), rgb(red)
      case 15
        circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(red), rgb(red)
      case 20
        circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(red), rgb(red)
      case 25
        circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(red), rgb(red)
    end select
    lsl = lc : lsn = nc : lshm = 1 : lhl = lc : lhn = nc 
    ssh = 0 'shots since hit
  else ' = 0
    print @(784, 198) "Missed"
    computer_ham_grid(lc, nc) = 2
    select case grid_size
      case 10
        circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(white), rgb(white)
      case 15
        circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(white), rgb(white)
      case 20
        circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(white), rgb(white)
      case 25
        circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(white), rgb(white)
    end select
    lsl = lc : lsn = nc : lshm = 2
    inc ssh
  endif  

  print @(784, 250) "                  "
  print @(784, 266) "                  "
  print @(784, 250) "Press Enter to"
  print @(784, 266) "continue...";: input "", e$
  do
    if keydown(0) = 1 then exit do
  loop
end sub

sub player_multiple_guesses
  cls
  page write 1
  show_grid()
  page copy 1 to 0, B
  page write 0
  for i = 1 to grid_size
    for j = 1 to grid_size
      if player_ham_grid(i, j) = 1 then
        select case grid_size
          case 10
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(red), rgb(red)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(red), rgb(red)
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(red), rgb(red)
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(red), rgb(red) 
        end select
      elseif player_ham_grid(i, j) = 2 then 
        select case grid_size
          case 10
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(white), rgb(white)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(white), rgb(white)
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(white), rgb(white)
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(white), rgb(white)
        end select
      endif
    next j
  next i
  
  'Calculate how many shots the player receives this round  
  if first_round = 1 then
    num_shots = num_ships
  else
    num_shots = 0
    for num_ship = 1 to num_ships
      do
        for i = 1 to grid_size
          for j = 1 to grid_size
            if player_ships_grid(i, j) = num_ship and computer_ham_grid(i, j) <> 1 then 'not a hit
              inc num_shots
              exit do
            endif
          next j
        next i 
        exit do
      loop
    next num_ship
  endif

  for i = 1 to num_shots
    do
      print @(784, 150) "                   "
      print @(784, 166) "                   "
      print @(784, 198) "                   "
      print @(784, 214) "                   "
      print @(784, 230) "                   "  
      print @(784, 150) "Square for shot";i;" of";num_shots
      print @(784, 166);: input a$

      select case grid_size
        case 10
          if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "j" then continue do
        case 15
          if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "o" then continue do
        case 20
          if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "t" then continue do
        case 25
          if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "y" then continue do
      end select
      if val(mid$(a$, 2, 2)) < 1 or val(mid$(a$, 2, 2)) > grid_size then continue do
      if player_ham_grid(letter_to_num(left$(a$, 1)), val(mid$(a$, 2, 2))) > 0 then continue do 'Already shot this square
      exit do
    loop
  
    lc = letter_to_num(left$(a$, 1))  
    nc = val(mid$(a$, 2, 2))
  
    if computer_ships_grid(lc, nc) > 0 then
      print @(784, 198) "A hit!"
      player_ham_grid(lc, nc) = 1
      select case grid_size
        case 10
          circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(red), rgb(red)
        case 15
          circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(red), rgb(red)
        case 20
          circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(red), rgb(red)
        case 25
          circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(red), rgb(red) 
      end select
      pause 2500
    else ' = 0
      print @(784, 198) "Missed"
      player_ham_grid(lc, nc) = 2
      select case grid_size
        case 10
          circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(white), rgb(white)
        case 15
          circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(white), rgb(white)   
        case 20
          circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(white), rgb(white)
        case 25
          circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(white), rgb(white) 
      end select
      pause 2500
    endif
  next i
end sub

sub computer_multiple_guesses
  cls
  page write 1
  show_grid()
  page copy 1 to 0, B
  page write 0

  'Display the player's ships on the grid
  for ship_num = 1 to num_ships
    lc = letter_to_num(left$(ship_start_square$(ship_num), 1))
    nc = val(mid$(ship_start_square$(ship_num), 2, 2))
    a2$ = ship_orientation$(ship_num)
    show_ships() 
  next ship_num

  for i = 1 to grid_size
    for j = 1 to grid_size
      if computer_ham_grid(i, j) = 1 then
        select case grid_size
          case 10
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(red), rgb(red)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(red), rgb(red)
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(red), rgb(red) 
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(red), rgb(red)  
        end select 
      elseif computer_ham_grid(i, j) = 2 then
        select case grid_size
          case 10
            circle -1 + (69.9 * j), 2 + (69.5 * i), 9, 1, 1, rgb(white), rgb(white)
          case 15
            circle 10 + (46.6 * j), 11 + (46.6 * i), 6, 1, 1, rgb(white), rgb(white) 
          case 20
            circle 17 + (34.97 * j), 17 + (34.93 * i), 4, 1, 1, rgb(white), rgb(white)
          case 25
            circle 20 + (27.99 * j), 20 + (27.99 * i), 3, 1, 1, rgb(white), rgb(white)
        end select
      endif
    next j
  next i

  'Calculate how many shots the computer receives this round  
  if first_round = 1 then
    num_shots = num_ships
  else
    num_shots = 0
    for num_ship = (num_ships + 1) to (2 * num_ships)  
      do
        for i = 1 to grid_size
          for j = 1 to grid_size
            if computer_ships_grid(i, j) = num_ship and player_ham_grid(i, j) <> 1 then 'not a hit
              inc num_shots
              exit do
            endif
          next j
        next i
        exit do 
      loop
    next num_ship
  endif

  for z = 1 to num_shots
    computer_guesses_main()
    print @(784, 150) "Shot"; z; " of"; num_shots 
    print @(784, 166) "Computer guesses  "; ucase$(num_to_letter(lc)) + str$(nc)
    if player_ships_grid(lc, nc) > 0 then
      print @(784, 198) "A hit!"
      computer_ham_grid(lc, nc) = 1
      select case grid_size
        case 10
          circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(red), rgb(red)
        case 15
          circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(red), rgb(red)
        case 20
          circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(red), rgb(red)
        case 25
          circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(red), rgb(red)
      end select
      lsl = lc : lsn = nc : lshm = 1 : lhl = lc : lhn = nc 
      ssh = 0 'shots since hit
    else ' = 0
      print @(784, 198) "Missed"
      computer_ham_grid(lc, nc) = 2
      select case grid_size
        case 10
          circle -1 + (69.9 * nc), 2 + (69.5 * lc), 9, 1, 1, rgb(white), rgb(white)
        case 15
          circle 10 + (46.6 * nc), 11 + (46.6 * lc), 6, 1, 1, rgb(white), rgb(white) 
        case 20
          circle 17 + (34.97 * nc), 17 + (34.93 * lc), 4, 1, 1, rgb(white), rgb(white)
        case 25
          circle 20 + (27.99 * nc), 20 + (27.99 * lc), 3, 1, 1, rgb(white), rgb(white)
      end select
      lsl = lc : lsn = nc : lshm = 2
      inc ssh
    endif
    pause 3000  
    print @(784, 150) "                     "
    print @(784, 166) "                     "
    print @(784, 198) "                     "
  next z

  print @(784, 250) "                    "
  print @(784, 266) "                    "
  print @(784, 250) "Press Enter to"
  print @(784, 266) "continue...";: input "", e$
  do
    if keydown(0) = 1 then exit do
  loop
end sub

sub computer_guesses_main
  not_found = 0
  stsah_cnt = 0    
  do   
    stsah = int(rnd * 100 + 1)      
    do
      if stsah < 27 and stsah_cnt < 250 then
        lc = int(rnd * grid_size + 1)
        nc = int(rnd * grid_size + 1)
        'if computer_ham_grid(lc, nc) <> 0 then continue do
        if computer_ham_grid(lc, nc) = 1 then
          if nc - 1 > 0 then
            if computer_ham_grid(lc, nc - 1) = 0 then
              exit do
            endif
          endif
          if nc + 1 < grid_size + 1 then
            if computer_ham_grid(lc, nc + 1) = 0 then
              exit do
            endif
          endif
          if lc - 1 > 0 then
            if computer_ham_grid(lc - 1, nc) = 0 then
              exit do
            endif
          endif
          if lc + 1 < grid_size + 1 then
            if computer_ham_grid(lc + 1, nc) = 0 then
              exit do
            endif
          endif
          if lc - 1 > 0 and nc - 1 > 0 then
            if computer_ham_grid(lc - 1, nc - 1) = 0 then
              exit do
            endif
          endif
          if lc - 1 > 0 and nc + 1 < grid_size + 1 then 
            if computer_ham_grid(lc - 1, nc + 1) = 0 then
              exit do
            endif
          endif
          if lc + 1 < grid_size + 1 and nc - 1 > 0 then
            if computer_ham_grid(lc + 1, nc - 1) = 0 then
              exit do
            endif
          endif
          if lc + 1 < grid_size + 1 and nc + 1 < grid_size + 1 then
            if computer_ham_grid(lc + 1, nc + 1) = 0 then
              exit do
            endif
          endif
        else
          inc stsah_cnt
          continue do
        endif    
      else
        lc = int(rnd * grid_size + 1)
        nc = int(rnd * grid_size + 1)
        if computer_ham_grid(lc, nc) <> 0 then continue do
      endif
      exit do
    loop

    if not_found < 15 then
      if lc + 1 < grid_size + 1 then
        if computer_ham_grid(lc + 1, nc) > 0 then
          inc not_found
          continue do
        endif
      endif
      if lc - 1 > 0 then
        if computer_ham_grid(lc - 1, nc) > 0 then
          inc not_found
          continue do
        endif
      endif
      if nc - 1 > 0 then
        if computer_ham_grid(lc, nc - 1) > 0 then
          inc not_found
          continue do
        endif
      endif
      if nc + 1 < grid_size + 1 then
        if computer_ham_grid(lc, nc + 1) > 0 then
          inc not_found
          continue do
        endif
      endif
      if lc - 1 > 0 and nc - 1 > 0 then 
        if computer_ham_grid(lc - 1, nc - 1) > 0 then
          inc not_found
          continue do
        endif
      endif
      if lc - 1 > 0 and nc + 1 < grid_size + 1 then
        if computer_ham_grid(lc - 1, nc + 1) > 0 then
          inc not_foun
          continue do
        endif
      endif
      if lc + 1 < grid_size + 1 and nc - 1 > 0 then
        if computer_ham_grid(lc + 1, nc - 1) > 0 then
          inc not_found
          continue do
        endif
      endif
      if lc + 1 < grid_size + 1 and nc + 1 < grid_size + 1 then
        if computer_ham_grid(lc + 1, nc + 1) > 0 then
          inc not_found
          continue do
        endif
      endif
    endif

    if ssh < 9 then
      adjacent_hit = 0
      if lhn - 1 > 0 then
        if computer_ham_grid(lhl, lhn - 1) = 1 then
          adjacent_hit = 1
        endif
      endif 
      if lhn + 1 < grid_size + 1 then 
        if computer_ham_grid(lhl, lhn + 1) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl - 1 > 0 then 
        if computer_ham_grid(lhl - 1, lhn) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl + 1 < grid_size + 1 then
        if computer_ham_grid(lhl + 1, lhn) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl - 1 > 0 and lhn - 1 > 0 then
        if computer_ham_grid(lhl - 1, lhn - 1) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl - 1 > 0 and lhn + 1 < grid_size + 1 then
        if computer_ham_grid(lhl - 1, lhn + 1) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl + 1 < grid_size + 1 and lhn - 1 > 0 then
        if computer_ham_grid(lhl + 1, lhn - 1) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl + 1 < grid_size + 1 and lhn + 1 < grid_size + 1 then
        if computer_ham_grid(lhl + 1, lhn + 1) = 1 then
          adjacent_hit = 1
        endif
      endif         

      do
        r = int(rnd * 2 + 1) 'make the computer's guesses less predictable
        if r = 1 then
          if adjacent_hit = 0 then
            if lhl - 1 > 0 then 'ON the grid?
              if computer_ham_grid(lhl - 1, lhn) = 0 then 'No shot taken to the North?
                lc = lhl - 1 : nc = lhn 'Take shot to the North
                exit do
              endif
            endif
            if lhl + 1 < grid_size + 1 then
              if computer_ham_grid(lhl + 1, lhn) = 0 then 'No shot taken to the South?
                lc = lhl + 1 : nc = lhn 'Take shot to the South
                exit do
              endif
            endif
            if lhn - 1 > 0 then
              if computer_ham_grid(lhl, lhn - 1) = 0 then 'No shot taken to the West?
                lc = lhl : nc = lhn - 1 'Take shot to the West
                exit do
              endif
            endif
            if lhn + 1 < grid_size + 1 then
              if computer_ham_grid(lhl, lhn + 1) = 0 then 'No shot taken to the East?
                lc = lhl : nc = lhn + 1 'Take shot to the East
                exit do
              endif
            endif
            if lhl - 1 > 0 and lhn - 1 > 0 then 
              if computer_ham_grid(lhl - 1, lhn - 1) = 0 then 'No shot taken to the Northwest?
                lc = lhl - 1 : nc = lhn - 1 'Take shot to the Northwest   
                exit do
              endif
            endif
            if lhl - 1 > 0 and lhn + 1 < grid_size + 1 then
              if computer_ham_grid(lhl - 1, lhn + 1) = 0 then 'No shot taken to the Northeast?
                lc = lhl - 1 : nc = lhn + 1 'Take shot to the Northeast   
                exit do
              endif
            endif
            if lhl + 1 < grid_size + 1 and lhn - 1 > 0 then
              if computer_ham_grid(lhl + 1, lhn - 1) = 0 then 'No shot taken to the Southwest?
                lc = lhl + 1 : nc = lhn - 1 'Take shot to the Southwest   
                exit do
              endif
            endif
            if lhl + 1 < grid_size + 1 and lhn + 1 < grid_size + 1 then
              if computer_ham_grid(lhl + 1, lhn + 1) = 0 then 'No shot taken to the Southeast?
                lc = lhl + 1 : nc = lhn + 1 'Take shot to the Southeast   
                exit do
              endif
            endif
          endif
        else 'r = 2
          if adjacent_hit = 0 then
            if lhl + 1 < grid_size + 1 and lhn + 1 < grid_size + 1 then
              if computer_ham_grid(lhl + 1, lhn + 1) = 0 then
                lc = lhl + 1 : nc = lhn + 1
                exit do
              endif
            endif
            if lhl + 1 < grid_size + 1 and lhn - 1 > 0 then
              if computer_ham_grid(lhl + 1, lhn - 1) = 0 then
                lc = lhl + 1 : nc = lhn - 1
                exit do
              endif
            endif
            if lhl - 1 > 0 and lhn + 1 < grid_size + 1 then
              if computer_ham_grid(lhl - 1, lhn + 1) = 0 then
                lc = lhl - 1 : nc = lhn + 1
                exit do
              endif
            endif
            if lhl - 1 > 0 and lhn - 1 > 0 then 
              if computer_ham_grid(lhl - 1, lhn - 1) = 0 then
                lc = lhl - 1 : nc = lhn - 1
                exit do
              endif
            endif
            if lhn + 1 < grid_size + 1 then
              if computer_ham_grid(lhl, lhn + 1) = 0 then
                lc = lhl : nc = lhn + 1
                exit do
              endif
            endif
            if lhn - 1 > 0 then
              if computer_ham_grid(lhl, lhn - 1) = 0 then
                lc = lhl : nc = lhn - 1
                exit do
              endif
            endif
            if lhl + 1 < grid_size + 1 then
              if computer_ham_grid(lhl + 1, lhn) = 0 then
                lc = lhl + 1 : nc = lhn
                exit do
              endif
            endif
            if lhl - 1 > 0 then
              if computer_ham_grid(lhl - 1, lhn) = 0 then
                lc = lhl - 1 : nc = lhn
                exit do
              endif
            endif
          endif
          exit do
        endif
      loop
    endif

    consecutive = 0 : orientation$ = "" : startx = 0 : starty = 0
    endx = 0 : endy = 0 : adjacent_hit = 0
    'Search the whole grid looking fro hits and adjacent hits
    for i = 1 to grid_size
      for j = 1 to grid_size
        if computer_ham_grid(i, j) = 1 then 'Has the square been HIT ?
          'EAST side
          if j + 1 < grid_size + 1 then
            if computer_ham_grid(i, j + 1) = 1 then 'Has 1 square away been HIT?
              adjacent_hit = 1
              if j + 2 < grid_size + 1 then 'ON the grid?
                if computer_ham_grid(i, j + 2) = 0 then 'Has no shot been taken 2 squares away?
                  consecutive = 2 : orientation$ = "h"
                  startx = i : starty = j : endx = i : endy = j + 1
                  if computer_ham_grid(i, j + 2) = 1 then 'Has 2 squares away been HIT?
                    if j + 3 < grid_size + 1 then 'ON the grid?
                      if computer_ham_grid(i, j + 3) = 0 then 'Has no shot been taken three squares away?
                        consecutive = 3 : orientation$ = "h"
                        startx = i : starty = j : endx = i : endy = j + 2        
                        if computer_ham_grid(i, j + 3) = 1 then 'Has 3 squares away been HIT?
                          if j + 4 < grid_size + 1 then 'ON the grid?
                            if computer_ham_grid(i, j + 4) = 0 then 'Has no shot been taken 4 squares away?
                              consecutive = 4 : orientation$ = "h"
                              startx = i : starty = j : endx = i : endy = j + 3
                            endif
                          endif
                        endif                    
                      endif
                    endif
                  elseif computer_ham_grid(i, j + 1) = 0 then 'Has no shot been taken 1 square away?
                    lc = i : nc = j + 1 : exit do 'Take shot 1 square away
                  endif               
                endif
              endif
            elseif computer_ham_grid(i, j + 1) = 0 then 'Has no shot been taken 1 square away?
              if j - 1 > 0 then 'ON the grid?
                if computer_ham_grid(i, j - 1) = 1 then 'Has 1 square away in opposite direction been HIT?
                  lc = i : nc = j + 1 : exit do 'Take shot 1 square away
                endif
              endif
            endif
          endif

          'WEST side
          if j - 1 > 0 then
            if computer_ham_grid(i, j - 1) = 1 then
              adjacent_hit = 1
              if j - 2 > 0 then
                if computer_ham_grid(i, j - 2) = 0 then
                  consecutive = 2 : orientation$ = "h" 
                  startx = i : starty = j : endx = i : endy = j - 1              
                  if computer_ham_grid(i, j - 2) = 1 then
                    if j - 3 > 0 then
                      if computer_ham_grid(i, j - 3) = 0 then
                        consecutive = 3 : orientation$ = "h"
                        startx = i : starty = j : endx = i : endy = j - 2
                        if computer_ham_grid(i, j - 3) = 1 then
                          if j - 4 > 0 then
                            if computer_ham_grid(i, j - 4) = 0 then
                              consecutive = 4 : orientation$ = "h"
                              startx = i : starty = j : endx = i : endy = j - 3
                            endif
                          endif
                        endif                       
                      endif
                    endif
                  elseif computer_ham_grid(i, j - 1) = 0 then
                    lc = i : nc = j - 1 : exit do
                  endif               
                endif
              endif
            elseif computer_ham_grid(i, j - 1) = 0 then
              if j + 1 < grid_size + 1 then
                if computer_ham_grid(i, j + 1) = 1 then
                  lc = i : nc = j - 1 : exit do
                endif
              endif
            endif
          endif

          'SOUTH side
          if i + 1 < grid_size + 1 then
            if computer_ham_grid(i + 1, j) = 1 then
              adjacent_hit = 1
              if i + 2 < grid_size + 1 then
                if computer_ham_grid(i + 2, j) = 0 then
                  consecutive = 2 : orientation$ = "v"
                  startx = i : starty = j : endx = i + 1 : endy = j 
                  if computer_ham_grid(i + 2, j) = 1 then
                    if i + 3 < grid_size + 1 then
                      if computer_ham_grid(i + 3, j) = 0 then
                        consecutive = 3 : orientation$ = "v"
                        startx = i : starty = j : endx = i + 2 : endy = j 
                        if computer_ham_grid(i + 3, j) = 1 then
                          if i + 4 < grid_size + 1 then            
                            if computer_ham_grid(i + 4, j) = 0 then
                              consecutive = 4 : orientation$ = "v"
                              startx = i : starty = j : endx = i + 3 : endy = j
                            endif
                          endif
                        endif                       
                      endif
                    endif
                  elseif computer_ham_grid(i + 1, j) = 0 then
                    lc = i + 1 : nc = j : exit do
                  endif             
                endif
              endif
            elseif computer_ham_grid(i + 1, j) = 0 then
              if i - 1 > 0 then
                if computer_ham_grid(i - 1, j) = 1 then
                  lc = i + 1 : nc = j : exit do
                endif
              endif
            endif
          endif

          'NORTH side
          if i - 1 > 0 then
            if computer_ham_grid(i - 1, j) = 1 then
              adjacent_hit = 1
              if i - 2 > 0 then
                if computer_ham_grid(i - 2, j) = 0 then
                  consecutive = 2 : orientation$ = "v"
                  startx = i : starty = j : endx = i - 1 : endy = j 
                  if computer_ham_grid(i - 2, j) = 1 then
                    if i - 3 > 0 then              
                      if computer_ham_grid(i - 3, j) = 0 then
                        consecutive = 3 : orientation$ = "v"
                        startx = i : starty = j : endx = i - 2 : endy = j                     
                        if computer_ham_grid(i - 3, j) = 1 then
                          if i - 4 > 0 then
                            if computer_ham_grid(i - 4, j) = 0 then
                              consecutive = 4 : orientation$ = "v"
                              startx = i : starty = j : endx = i - 3 : endy = j
                            endif
                          endif
                        endif                     
                      endif
                    endif
                  elseif computer_ham_grid(i - 1, j) = 0 then
                    lc = i - 1 : nc = j : exit do
                  endif
                endif
              endif
            elseif computer_ham_grid(i - 1, j) = 0 then
              if i + 1 < grid_size + 1 then
                if computer_ham_grid(i + 1, j) = 1 then
                  lc = i - 1 : nc = j : exit do
                endif
              endif 
            endif
          endif

          'NORTHWEST side
          if i - 1 > 0 and j - 1 > 0 then 'ON the grid?
            if computer_ham_grid(i - 1, j - 1) = 1 then 'Was there a hit 1 square away?
              adjacent_hit = 1
              if i - 2 > 0 and j - 2 > 0 then 'ON the grid?
                if computer_ham_grid(i - 2, j - 2) = 0 then 'No shot taken 2 squares away? 
                  consecutive = 2 : orientation$ = "d1"
                  startx = i : starty = j : endx = i - 1 : endy = j - 1 
                  if computer_ham_grid(i - 2, j - 2) = 1 then 'Was there a hit 2 squares away?
                    if i - 3 > 0 and j - 3 > 0 then 'ON the grid?             
                      if computer_ham_grid(i - 3, j - 3) = 0 then 'No shot taken 3 squares away?
                        consecutive = 3 : orientation$ = "d1"
                        startx = i : starty = j : endx = i - 2 : endy = j - 2                    
                        if computer_ham_grid(i - 3, j - 3) = 1 then 'Was there a hit 3 squares away?
                          if i - 4 > 0 and j - 4 > 0 then
                            if computer_ham_grid(i - 4, j - 4) = 0 then 'No shot taken 4 squares away?
                              consecutive = 4 : orientation$ = "d1"
                              startx = i : starty = j : endx = i - 3 : endy = j - 3
                            endif
                          endif
                        endif                     
                      endif
                    endif
                  elseif computer_ham_grid(i - 1, j - 1) = 0 then 'No shot taken one square away?
                    lc = i - 1 : nc = j - 1 : exit do 'Take shot one square away
                  endif
                endif
              endif
            elseif computer_ham_grid(i - 1, j - 1) = 0 then 'No shot taken one square away?
              if i + 1 < grid_size + 1 and j + 1 < grid_size + 1 then 'ON the grid?
                if computer_ham_grid(i + 1, j + 1) = 1 then 'Was there a hit in opposite direction 1 square away?
                  lc = i - 1 : nc = j - 1 : exit do 'Take shot one square away
                endif
              endif 
            endif
          endif

          'NORTHEAST side
          if i - 1 > 0 and j + 1 < grid_size + 1 then
            if computer_ham_grid(i - 1, j + 1) = 1 then
              adjacent_hit = 1
              if i - 2 > 0 and j + 2 < grid_size + 1 then
                if computer_ham_grid(i - 2, j + 2) = 0 then
                  consecutive = 2 : orientation$ = "d2"
                  startx = i : starty = j : endx = i - 1 : endy = j + 1 
                  if computer_ham_grid(i - 2, j + 2) = 1 then
                    if i - 3 > 0 and j + 3 < grid_size + 1 then              
                      if computer_ham_grid(i - 3, j + 3) = 0 then
                        consecutive = 3 : orientation$ = "d2"
                        startx = i : starty = j : endx = i - 2 : endy = j + 2                     
                        if computer_ham_grid(i - 3, j + 3) = 1 then
                          if i - 4 > 0 and j + 4 < grid_size + 1 then
                            if computer_ham_grid(i - 4, j + 4) = 0 then
                              consecutive = 4 : orientation$ = "d2"
                              startx = i : starty = j : endx = i - 3 : endy = j + 3
                            endif
                          endif
                        endif                     
                      endif
                    endif
                  elseif computer_ham_grid(i - 1, j + 1) = 0 then
                    lc = i - 1 : nc = j + 1 : exit do
                  endif
                endif
              endif
            elseif computer_ham_grid(i - 1, j + 1) = 0 then
              if i + 1 < grid_size + 1 and j - 1 > 0 then
                if computer_ham_grid(i + 1, j - 1) = 1 then
                  lc = i - 1 : nc = j + 1: exit do
                endif
              endif 
            endif
          endif

          'SOUTHWEST side
          if i + 1 < grid_size + 1 and j - 1 > 0 then 'ON the grid?
            if computer_ham_grid(i + 1, j - 1) = 1 then 'Was there a hit 1 square away?
              adjacent_hit = 1
              if i + 2 < grid_size + 1 and j - 2 > 0 then 'ON the grid?
                if computer_ham_grid(i + 2, j - 2) = 0 then 'Has no shot been taken 2 squares away?
                  consecutive = 2 : orientation$ = "d2"
                  startx = i : starty = j : endx = i + 1 : endy = j - 1 
                  if computer_ham_grid(i + 2, j - 2) = 1 then 'Was there a hit 2 squares away?
                    if i + 3 < grid_size + 1 and j - 3 > 0 then 'ON the grid?             
                      if computer_ham_grid(i + 3, j - 3) = 0 then 'Has no shot been taken 3 squares away?
                        consecutive = 3 : orientation$ = "d2"
                        startx = i : starty = j : endx = i + 2 : endy = j - 2                     
                        if computer_ham_grid(i + 3, j - 3) = 1 then 'Was there a hit 3 squares away?
                          if i + 4 < grid_size + 1 and j - 4 > 0 then 'ON the grid?
                            if computer_ham_grid(i + 4, j - 4) = 0 then 'Has no shot been taken 4 squares away?
                              consecutive = 4 : orientation$ = "d2"
                              startx = i : starty = j : endx = i + 3 : endy = j - 3
                            endif
                          endif
                        endif                     
                      endif
                    endif
                  elseif computer_ham_grid(i + 1, j - 1) = 0 then 'Has no shot been taken 1 square away?
                    lc = i + 1 : nc = j - 1 : exit do 'Take shot one square away
                  'added these 2 lines recently
                  elseif computer_ham_grid(i + 2, j - 2) = 0 then 
                    lc = i + 2 : nc = j - 2 : exit do
                  endif
                endif
              endif
            elseif computer_ham_grid(i + 1, j - 1) = 0 then 'Has no shot been taken 1 square away?
              if i - 1 > 0 and j + 1 < grid_size + 1 then 'ON the grid?
                if computer_ham_grid(i - 1, j + 1) = 1 then 'Was there a hit in opposite direction 1 square away?
                  lc = i + 1 : nc = j - 1 : exit do 'Take shot one square away
                endif
              endif 
            endif
          endif

          'SOUTHEAST side
          if i + 1 < grid_size + 1 and j + 1 < grid_size + 1 then
            if computer_ham_grid(i + 1, j + 1) = 1 then
              adjacent_hit = 1
              if i + 2 < grid_size + 1 and j + 2 < grid_size + 1 then
                if computer_ham_grid(i + 2, j + 2) = 0 then
                  consecutive = 2 : orientation$ = "d1"
                  startx = i : starty = j : endx = i + 1 : endy = j + 1 
                  if computer_ham_grid(i + 2, j + 2) = 1 then
                    if i + 3 < grid_size + 1 and j + 3 < grid_size + 1 then              
                      if computer_ham_grid(i + 3, j + 3) = 0 then
                        consecutive = 3 : orientation$ = "d1"
                        startx = i : starty = j : endx = i + 2 : endy = j + 2                     
                        if computer_ham_grid(i + 3, j + 3) = 1 then
                          if i + 4 < grid_size + 1 and j + 4 < grid_size + 1 then
                            if computer_ham_grid(i + 4, j + 4) = 0 then
                              consecutive = 4 : orientation$ = "d1"
                              startx = i : starty = j : endx = i + 3 : endy = j + 3
                            endif
                          endif
                        endif                     
                      endif
                    endif
                  elseif computer_ham_grid(i + 1, j + 1) = 0 then
                    lc = i + 1 : nc = j + 1: exit do
                  endif
                endif
              endif
            elseif computer_ham_grid(i + 1, j + 1) = 0 then
              if i - 1 > 0 and j - 1 > 0 then
                if computer_ham_grid(i - 1, j - 1) = 1 then
                  lc = i + 1 : nc = j + 1 : exit do
                endif
              endif 
            endif
          endif
        endif

        'Order from most consecutive to least consecutive
        if startx > 0 and orientation$ = "h" and consecutive = 4 and j + 4 < grid_size + 1 then
          if computer_ham_grid(i, j + 4) = 0 then
            lc = i : nc = j + 4 : exit do
          endif
        endif
        if startx > 0 and orientation$ = "v" and consecutive = 4 and i + 4 < grid_size + 1 then
          if computer_ham_grid(i + 4, j) = 0 then
            lc = i + 4 : nc = j : exit do
          endif
        endif
        if startx > 0 and orientation$ = "d1" and consecutive = 4 and i + 4 < grid_size + 1 and j + 4 < grid_size + 1 then 
          if computer_ham_grid(i + 4, j + 4) = 0 then
            lc = i + 4 : nc = j + 4 : exit do
          endif
        endif        
        if startx > 0 and orientation$ = "d2" and consecutive = 4 and i - 4 > 0 and j + 4 < grid_size + 1 then 
          if computer_ham_grid(i - 4, j + 4) = 0 then
            lc = i - 4 : nc = j + 4 : exit do
          endif
        endif
        if startx > 0 and orientation$ = "h" and consecutive = 3 and j + 3 < grid_size + 1 then
          if computer_ham_grid(i, j + 3) = 0 then
            lc = i : nc = j + 3 : exit do
          endif
        endif
        if startx > 0 and orientation$ = "v" and consecutive = 3 and i + 3 < grid_size + 1 then
          if computer_ham_grid(i + 3, j) = 0 then
            lc = i + 3 : nc = j : exit do
          endif
        endif
        if startx > 0 and orientation$ = "d1" and consecutive = 3 and i + 3 < grid_size + 1 and j + 3 < grid_size + 1 then 
          if computer_ham_grid(i + 3, j + 3) = 0 then
            lc = i + 3 : nc = j + 3 : exit do
          endif
        endif          
        if startx > 0 and orientation$ = "d2" and consecutive = 3 and i - 3 > 0 and j + 3 < grid_size + 1 then 
          if computer_ham_grid(i - 3, j + 3) = 0 then
            lc = i - 3 : nc = j + 3 : exit do
          endif
        endif 
        if startx > 0 and orientation$ = "h" and consecutive = 2 and j + 2 < grid_size + 1 then
          if computer_ham_grid(i, j + 2) = 0 then
            lc = i : nc = j + 2 : exit do
          endif
        endif
        if startx > 0 and orientation$ = "v" and consecutive = 2 and i + 2 < grid_size + 1 then
          if computer_ham_grid(i + 2, j) = 0 then
            lc = i + 2 : nc = j : exit do
          endif
        endif        
        if startx > 0 and orientation$ = "d1" and consecutive = 2 and i + 2 < grid_size + 1 and j + 2 < grid_size + 1 then 
          if computer_ham_grid(i + 2, j + 2) = 0 then
            lc = i + 2 : nc = j + 2 : exit do
          endif
        endif         
        if startx > 0 and orientation$ = "d2" and consecutive = 2 and i - 2 > 0 and j + 2 < grid_size + 1 then 
          if computer_ham_grid(i - 2, j + 2) = 0 then
            lc = i - 2 : nc = j + 2 : exit do
          endif
        endif
        if startx > 0 and orientation$ = "h" and j - 1 > 0 then
          if computer_ham_grid(i, j - 1) = 0 then
            lc = i : nc = j - 1 : exit do
          endif
        endif         
        if startx > 0 and orientation$ = "v" and i - 1 > 0 then
          if computer_ham_grid(i - 1, j) = 0 then
            lc = i - 1 : nc = j : exit do
          endif
        endif          
        if startx > 0 and orientation$ = "d1" and i + 1 < grid_size + 1 and j + 1 < grid_size + 1 then 
          if computer_ham_grid(i + 1, j + 1) = 0 then
            lc = i + 1 : nc = j + 1 : exit do
          endif
        endif      
        if startx > 0 and orientation$ = "d2" and i - 1 > 0 and j + 1 < grid_size + 1 then 
          if computer_ham_grid(i - 1, j + 1) = 0 then
            lc = i - 1 : nc = j + 1 : exit do
          endif
        endif
      next j
    next i     

    if computer_ham_grid(lc, nc) > 0 then continue do 'Already shot this square
    exit do
  loop
end sub

sub ending
  print @(10, 16) "Would you like to play again"
  print @(10, 32);: input a$
  if lcase$(left$(a$, 1)) = "y" then
    if who_shoots_first = 1 then 
       who_shoots_first = 2
    else
       who_shoots_first = 1
    endif
    goto play_again:
  endif
end sub

sub show_ships
  xh10_5 = 37 + (70.3 * (nc - 1))
  yh10_5 = 31 + (69.9 * (lc - 1))
  xv10_5 = 32 + (70.2 * (nc - 1))
  yv10_5 = 39 + (70.0 * (lc - 1))
  xh10_4 = 39 + (70.3 * (nc - 1))
  yh10_4 = 36 + (69.7 * (lc - 1))
  xv10_4 = 35 + (69.8 * (nc - 1))
  yv10_4 = 40 + (69.8 * (lc - 1))
  xh10_3 = 30 + (70.3 * (nc - 1))
  yh10_3 = 37 + (69.4 * (lc - 1))
  xv10_3 = 38 + (69.7 * (nc - 1))
  yv10_3 = 33 + (69.5 * (lc - 1))
  xh10_2 = 32 + (70.3 * (nc - 1))
  yh10_2 = 41 + (69.4 * (lc - 1))
  xv10_2 = 40 + (69.2 * (nc - 1))
  yv10_2 = 41 + (69.8 * (lc - 1))
  xh10_1 = 30 + (70.3 * (nc - 1))
  yh10_1 = 39 + (69.1 * (lc - 1))
  xv10_1 = 49 + (69.2 * (nc - 1))
  yv10_1 = 33 + (70.0 * (lc - 1))

  x1d10_5 = 0 + (70.3 * (nc - 1))
  y1d10_5 = -6 + (69.9 * (lc - 1))
  x2d10_5 = 5 + (70.2 * (nc - 1))
  if lc = 10 then
    y2d10_5 = -284 + (70.0 * (lc - 1))
  else
    y2d10_5 = -282 + (70.0 * (lc - 1)) 
  endif
  x1d10_4 = 0 + (70.3 * (nc - 1))
  y1d10_4 = 7 + (69.7 * (lc - 1))
  x2d10_4 = 3 + (69.8 * (nc - 1))
  y2d10_4 = -210 + (69.8 * (lc - 1))
  x1d10_3 = 8 + (70.3 * (nc - 1))
  if lc = 8 then
    y1d10_3 = 9 + (69.4 * (lc - 1))
  else
    y1d10_3 = 11 + (69.4 * (lc - 1))
  endif
  x2d10_3 = -6 + (69.7 * (nc - 1))
  if lc = 10 then
    y2d10_3 = -131 + (69.5 * (lc - 1))
  else
    y2d10_3 = -129 + (69.5 * (lc - 1))
  endif
  x1d10_2 = 7 + (70.3 * (nc - 1))
  y1d10_2 = 7 + (69.4 * (lc - 1))
  x2d10_2 = 5 + (69.2 * (nc - 1))
  if lc = 10 then 
    y2d10_2 = -133 + (69.8 * (lc - 1))
  else
    y2d10_2 = -129 + (69.8 * (lc - 1))
  endif
  if nc = 1 then
    x1d10_1 = -8 + (70.3 * (nc - 1))
  else
    x1d10_1 = -8 + (70.3 * (nc - 1))
  endif
  if lc = 9 then
    y1d10_1 = 0 + (69.1 * (lc - 1))
  else
    y1d10_1 = 7 + (69.1 * (lc - 1))
  endif 
  x2d10_1 = -2 + (69.2 * (nc - 1))
  y2d10_1 = -82 + (70.0 * (lc - 1))

  xh15_5 = 42 + (46.6 * (nc - 1))
  yh15_5 = 33 + (46.6 * (lc - 1))
  xv15_5 = 34 + (46.6 * (nc - 1))
  yv15_5 = 36 + (46.6 * (lc - 1))
  xh15_4 = 41 + (46.6 * (nc - 1))
  yh15_4 = 35 + (46.6 * (lc - 1))
  xv15_4 = 34 + (46.6 * (nc - 1))
  yv15_4 = 38 + (46.6 * (lc - 1))
  xh15_3 = 33 + (46.6 * (nc - 1))
  yh15_3 = 33 + (46.6 * (lc - 1))
  xv15_3 = 36 + (46.6 * (nc - 1))
  yv15_3 = 33 + (46.6 * (lc - 1))
  xh15_2 = 34 + (46.6 * (nc - 1))
  yh15_2 = 35 + (46.6 * (lc - 1))
  xv15_2 = 36 + (46.6 * (nc - 1))
  yv15_2 = 38 + (46.6 * (lc - 1))
  xh15_1 = 34 + (46.6 * (nc - 1))
  yh15_1 = 33 + (46.6 * (lc - 1))
  xv15_1 = 39 + (46.6 * (nc - 1))
  yv15_1 = 35 + (46.6 * (lc - 1))

  x1d15_5 = 13 + (46.6 * (nc - 1))
  y1d15_5 = 11 + (46.6 * (lc - 1))
  x2d15_5 = 16 + (46.6 * (nc - 1))
  y2d15_5 = -173 + (46.6 * (lc - 1))
  x1d15_4 = 11 + (46.6 * (nc - 1))
  y1d15_4 = 16 + (46.6 * (lc - 1))
  x2d15_4 = 16 + (46.6 * (nc - 1))
  y2d15_4 = -121 + (46.6 * (lc - 1))
  x1d15_3 = 17 + (46.6 * (nc - 1))
  y1d15_3 = 20 + (46.6 * (lc - 1))
  x2d15_3 = 7 + (46.6 * (nc - 1))
  y2d15_3 = -74 + (46.6 * (lc - 1))
  x1d15_2 = 18 + (46.6 * (nc - 1))
  y1d15_2 = 16 + (46.6 * (lc - 1))
  x2d15_2 = 15 + (46.6 * (nc - 1))
  y2d15_2 = -76 + (46.6 * (lc - 1))
  x1d15_1 = 10 + (46.6 * (nc - 1))
  y1d15_1 = 16 + (46.6 * (lc - 1))
  x2d15_1 = 10 + (46.6 * (nc - 1))
  y2d15_1 = -41 + (46.6 * (lc - 1))

  xh20_5 = 36 + (34.97 * (nc - 1))
  yh20_5 = 33 + (34.93 * (lc - 1))
  xv20_5 = 33 + (34.97 * (nc - 1))
  yv20_5 = 35 + (34.93 * (lc - 1))
  xh20_4 = 37 + (34.97 * (nc - 1))
  yh20_4 = 33 + (34.93 * (lc - 1))
  xv20_4 = 33 + (34.97 * (nc - 1))
  yv20_4 = 37 + (34.93 * (lc - 1))
  xh20_3 = 33 + (34.97 * (nc - 1))
  yh20_3 = 33 + (34.93 * (lc - 1))
  xv20_3 = 36 + (34.97 * (nc - 1))
  yv20_3 = 33 + (34.93 * (lc - 1))
  xh20_2 = 32 + (34.97 * (nc - 1))
  yh20_2 = 35 + (34.93 * (lc - 1))
  xv20_2 = 34 + (34.97 * (nc - 1))
  yv20_2 = 36 + (34.93 * (lc - 1))
  xh20_1 = 33 + (34.97 * (nc - 1))
  yh20_1 = 31 + (34.93 * (lc - 1))
  xv20_1 = 37 + (34.97 * (nc - 1))
  yv20_1 = 33 + (34.93 * (lc - 1))

  x1d20_5 = 18 + (34.97 * (nc - 1))
  y1d20_5 = 15 + (34.93 * (lc - 1))
  x2d20_5 = 21 + (34.97 * (nc - 1))
  y2d20_5 = -124 + (34.93 * (lc - 1))
  x1d20_4 = 19 + (34.97 * (nc - 1))
  y1d20_4 = 19 + (34.93 * (lc - 1))
  x2d20_4 = 19 + (34.97 * (nc - 1))
  y2d20_4 = -86 + (34.93 * (lc - 1))
  x1d20_3 = 22 + (34.97 * (nc - 1))
  y1d20_3 = 22 + (34.93 * (lc - 1))
  x2d20_3 = 12 + (34.97 * (nc - 1))
  y2d20_3 = -47 + (34.93 * (lc - 1))
  x1d20_2 = 21 + (34.97 * (nc - 1))
  y1d20_2 = 19 + (34.93 * (lc - 1))
  x2d20_2 = 18 + (34.97 * (nc - 1))
  y2d20_2 = -48 + (34.93 * (lc - 1))
  x1d20_1 = 14 + (34.97 * (nc - 1))
  y1d20_1 = 19 + (34.93 * (lc - 1))
  x2d20_1 = 14 + (34.97 * (nc - 1))
  y2d20_1 = -24 + (34.93 * (lc - 1))

  xh25_5 = 33 + (27.99 * (nc - 1))
  yh25_5 = 31 + (27.99 * (lc - 1))
  xv25_5 = 32 + (27.99 * (nc - 1))
  yv25_5 = 31 + (27.99 * (lc - 1))
  xh25_4 = 35 + (27.99 * (nc - 1))
  yh25_4 = 33 + (27.99 * (lc - 1))
  xv25_4 = 34 + (27.99 * (nc - 1))
  yv25_4 = 34 + (27.99 * (lc - 1))
  xh25_3 = 32 + (27.99 * (nc - 1))
  yh25_3 = 33 + (27.99 * (lc - 1))
  xv25_3 = 34 + (27.99 * (nc - 1))
  yv25_3 = 31 + (27.99 * (lc - 1))
  xh25_2 = 31 + (27.99 * (nc - 1))
  yh25_2 = 35 + (27.99 * (lc - 1))
  xv25_2 = 33 + (27.99 * (nc - 1))
  yv25_2 = 36 + (27.99 * (lc - 1))
  xh25_1 = 33 + (27.99 * (nc - 1))
  yh25_1 = 31 + (27.99 * (lc - 1))
  xv25_1 = 36 + (27.99 * (nc - 1))
  yv25_1 = 33 + (27.99 * (lc - 1))

  x1d25_5 = 17 + (27.99 * (nc - 1))
  y1d25_5 = 15 + (27.99 * (lc - 1))
  x2d25_5 = 20 + (27.99 * (nc - 1))
  y2d25_5 = -96 + (27.99 * (lc - 1))
  x1d25_4 = 17 + (27.99 * (nc - 1))
  y1d25_4 = 19 + (27.99 * (lc - 1))
  x2d25_4 = 19 + (27.99 * (nc - 1))
  y2d25_4 = -66 + (27.99 * (lc - 1))
  x1d25_3 = 22 + (27.99 * (nc - 1))
  y1d25_3 = 23 + (27.99 * (lc - 1))
  x2d25_3 = 16 + (27.99 * (nc - 1))
  y2d25_3 = -35 + (27.99 * (lc - 1))
  x1d25_2 = 23 + (27.99 * (nc - 1))
  y1d25_2 = 19 + (27.99 * (lc - 1))
  x2d25_2 = 19 + (27.99 * (nc - 1))
  y2d25_2 = -35 + (27.99 * (lc - 1))
  x1d25_1 = 17 + (27.99 * (nc - 1))
  y1d25_1 = 19 + (27.99 * (lc - 1))
  x2d25_1 = 15 + (27.99 * (nc - 1))
  y2d25_1 = -13 + (27.99 * (lc - 1))

  select case ship_num
    case 5, 10, 15, 20, 25, 30        
      page write 1
      if a2$ = "h" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Carrier h 94 345x79", xh10_5, yh10_5
          case 15 : load png "/Battleship/graphics/Carrier h 61 224x51", xh15_5, yh15_5
          case 20 : load png "/Battleship/graphics/Carrier h 47 173x40", xh20_5, yh20_5
          case 25 : load png "/Battleship/graphics/Carrier h 39 143x33", xh25_5, yh25_5
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Carrier v 92 77x337", xv10_5, yv10_5
          case 15 : load png "/Battleship/graphics/Carrier v 61 51x224", xv15_5, yv15_5
          case 20 : load png "/Battleship/graphics/Carrier v 46 39x169", xv20_5, yv20_5
          case 25 : load png "/Battleship/graphics/Carrier v 39 33x143", xv25_5, yv25_5
        end select
      elseif a2$ = "d1" then 'NWSE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Carrier NWSE 133 424x421", x1d10_5, y1d10_5
          case 15 : load png "/Battleship/graphics/Carrier NWSE 86 275x273", x1d15_5, y1d15_5
          case 20 : load png "/Battleship/graphics/Carrier NWSE 66 211x210", x1d20_5, y1d20_5
          case 25 : load png "/Battleship/graphics/Carrier NWSE 55 176x175", x1d25_5, y1d25_5
        end select
      elseif a2$ = "d2" then 'SWNE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Carrier SWNE 133 421x422", x2d10_5, y2d10_5
          case 15 : load png "/Battleship/graphics/Carrier SWNE 86 273x274", x2d15_5, y2d15_5
          case 20 : load png "/Battleship/graphics/Carrier SWNE 66 210x210", x2d20_5, y2d20_5
          case 25 : load png "/Battleship/graphics/Carrier SWNE 55 175x175", x2d25_5, y2d25_5
        end select
      endif
      page write 0
      if a2$ = "h" then
        select case grid_size
          case 10 : blit xh10_5, yh10_5, xh10_5, yh10_5, 345, 79, 1, &B100
          case 15 : blit xh15_5, yh15_5, xh15_5, yh15_5, 224, 51, 1, &B100
          case 20 : blit xh20_5, yh20_5, xh20_5, yh20_5, 173, 40, 1, &B100
          case 25 : blit xh25_5, yh25_5, xh25_5, yh25_5, 143, 33, 1, &B100
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : blit xv10_5, yv10_5, xv10_5, yv10_5, 77, 337, 1, &B100
          case 15 : blit xv15_5, yv15_5, xv15_5, yv15_5, 51, 224, 1, &B100
          case 20 : blit xv20_5, yv20_5, xv20_5, yv20_5, 39, 169, 1, &B100
          case 25 : blit xv25_5, yv25_5, xv25_5, yv25_5, 33, 143, 1, &B100
        end select
      elseif a2$ = "d1" then
        select case grid_size
          case 10 : blit x1d10_5, y1d10_5, x1d10_5, y1d10_5, 424, 421, 1, &B100
          case 15 : blit x1d15_5, y1d15_5, x1d15_5, y1d15_5, 275, 273, 1, &B100
          case 20 : blit x1d20_5, y1d20_5, x1d20_5, y1d20_5, 211, 210, 1, &B100
          case 25 : blit x1d25_5, y1d25_5, x1d25_5, y1d25_5, 176, 175, 1, &B100
        end select
      elseif a2$ = "d2" then
        select case grid_size
          case 10 : blit x2d10_5, y2d10_5, x2d10_5, y2d10_5, 421, 422, 1, &B100
          case 15 : blit x2d15_5, y2d15_5, x2d15_5, y2d15_5, 273, 274, 1, &B100
          case 20 : blit x2d20_5, y2d20_5, x2d20_5, y2d20_5, 210, 210, 1, &B100
          case 25 : blit x2d25_5, y2d25_5, x2d25_5, y2d25_5, 175, 175, 1, &B100
        end select
      endif
    case 4, 9, 14, 19, 24, 29      
      page write 1
      if a2$ = "h" then 
        select case grid_size
          case 10 : load png "/Battleship/graphics/Battleship h 94 271x72", xh10_4, yh10_4
          case 15 : load png "/Battleship/graphics/Battleship h 61 176x47", xh15_4, yh15_4
          case 20 : load png "/Battleship/graphics/Battleship h 47 136x36", xh20_4, yh20_4
          case 25 : load png "/Battleship/graphics/Battleship h 39 113x30", xh25_4, yh25_4
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Battleship v 94 72x271", xv10_4, yv10_4
          case 15 : load png "/Battleship/graphics/Battleship v 61 47x176", xv15_4, yv15_4
          case 20 : load png "/Battleship/graphics/Battleship v 47 36x136", xv20_4, yv20_4
          case 25 : load png "/Battleship/graphics/Battleship v 39 30x113", xv25_4, yv25_4
        end select
      elseif a2$ = "d1" then 'NWSE 
        select case grid_size
          case 10 : load png "/Battleship/graphics/Battleship NWSE 133 344x341", x1d10_4, y1d10_4
          case 15 : load png "/Battleship/graphics/Battleship NWSE 86 223x222", x1d15_4, y1d15_4
          case 20 : load png "/Battleship/graphics/Battleship NWSE 66 171x170", x1d20_4, y1d20_4
          case 25 : load png "/Battleship/graphics/Battleship NWSE 55 143x142", x1d25_4, y1d25_4
        end select
      elseif a2$ = "d2" then 'SWNE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Battleship SWNE 133 341x343", x2d10_4, y2d10_4
          case 15 : load png "/Battleship/graphics/Battleship SWNE 86 222x222", x2d15_4, y2d15_4
          case 20 : load png "/Battleship/graphics/Battleship SWNE 66 170x171", x2d20_4, y2d20_4
          case 25 : load png "/Battleship/graphics/Battleship SWNE 55 142x142", x2d25_4, y2d25_4
        end select
      endif
      page write 0
      if a2$ = "h" then
        select case grid_size
          case 10 : blit xh10_4, yh10_4, xh10_4, yh10_4, 271, 72, 1, &B100
          case 15 : blit xh15_4, yh15_4, xh15_4, yh15_4, 176, 47, 1, &B100
          case 20 : blit xh20_4, yh20_4, xh20_4, yh20_4, 136, 36, 1, &B100
          case 25 : blit xh25_4, yh25_4, xh25_4, yh25_4, 113, 30, 1, &B100
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : blit xv10_4, yv10_4, xv10_4, yv10_4, 72, 271, 1, &B100
          case 15 : blit xv15_4, yv15_4, xv15_4, yv15_4, 47, 176, 1, &B100
          case 20 : blit xv20_4, yv20_4, xv20_4, yv20_4, 36, 136, 1, &B100
          case 25 : blit xv25_4, yv25_4, xv25_4, yv25_4, 30, 113, 1, &B100
        end select
      elseif a2$ = "d1" then
        select case grid_size
          case 10 : blit x1d10_4, y1d10_4, x1d10_4, y1d10_4, 344, 341, 1, &B100
          case 15 : blit x1d15_4, y1d15_4, x1d15_4, y1d15_4, 223, 222, 1, &B100
          case 20 : blit x1d20_4, y1d20_4, x1d20_4, y1d20_4, 171, 170, 1, &B100
          case 25 : blit x1d25_4, y1d25_4, x1d25_4, y1d25_4, 143, 142, 1, &B100
        end select
      elseif a2$ = "d2" then
        select case grid_size
          case 10 : blit x2d10_4, y2d10_4, x2d10_4, y2d10_4, 341, 343, 1, &B100
          case 15 : blit x2d15_4, y2d15_4, x2d15_4, y2d15_4, 222, 222, 1, &B100
          case 20 : blit x2d20_4, y2d20_4, x2d20_4, y2d20_4, 170, 171, 1, &B100
          case 25 : blit x2d25_4, y2d25_4, x2d25_4, y2d25_4, 142, 142, 1, &B100
        end select
      endif
    case 3, 8, 13, 18, 23, 28
      page write 1
      if a2$ = "h" then
        select case grid_size    
          case 10 : load png "/Battleship/graphics/Cruiser h 94 204x70", xh10_3, yh10_3
          case 15 : load png "/Battleship/graphics/Cruiser h 61 133x46", xh15_3, yh15_3
          case 20 : load png "/Battleship/graphics/Cruiser h 47 102x35", xh20_3, yh20_3
          case 25 : load png "/Battleship/graphics/Cruiser h 39 85x29", xh25_3, yh25_3
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Cruiser v 94 70x204", xv10_3, yv10_3
          case 15 : load png "/Battleship/graphics/Cruiser v 61 46x133", xv15_3, yv15_3
          case 20 : load png "/Battleship/graphics/Cruiser v 47 35x102", xv20_3, yv20_3
          case 25 : load png "/Battleship/graphics/Cruiser v 39 29x85", xv25_3, yv25_3
        end select
      elseif a2$ = "d1" then 'NWSE
        select case grid_size    
          case 10 : load png "/Battleship/graphics/Cruiser NWSE 133 273x273", x1d10_3, y1d10_3
          case 15 : load png "/Battleship/graphics/Cruiser NWSE 86 178x178", x1d15_3, y1d15_3
          case 20 : load png "/Battleship/graphics/Cruiser NWSE 66 136x136", x1d20_3, y1d20_3
          case 25 : load png "/Battleship/graphics/Cruiser NWSE 55 114x114", x1d25_3, y1d25_3
        end select
      elseif a2$ = "d2" then 'SWNE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Cruiser SWNE 133 273x273", x2d10_3, y2d10_3
          case 15 : load png "/Battleship/graphics/Cruiser SWNE 86 178x178", x2d15_3, y2d15_3
          case 20 : load png "/Battleship/graphics/Cruiser SWNE 66 136x136", x2d20_3, y2d20_3
          case 25 : load png "/Battleship/graphics/Cruiser SWNE 55 114x114", x2d25_3, y2d25_3
        end select
      endif
      page write 0
      if a2$ = "h" then
        select case grid_size
          case 10 : blit xh10_3, yh10_3, xh10_3, yh10_3, 204, 70, 1, &B100
          case 15 : blit xh15_3, yh15_3, xh15_3, yh15_3, 133, 46, 1, &B100
          case 20 : blit xh20_3, yh20_3, xh20_3, yh20_3, 102, 35, 1, &B100
          case 25 : blit xh25_3, yh25_3, xh25_3, yh25_3,  85, 29, 1, &B100
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : blit xv10_3, yv10_3, xv10_3, yv10_3, 70, 204, 1, &B100
          case 15 : blit xv15_3, yv15_3, xv15_3, yv15_3, 46, 133, 1, &B100
          case 20 : blit xv20_3, yv20_3, xv20_3, yv20_3, 35, 102, 1, &B100
          case 25 : blit xv25_3, yv25_3, xv25_3, yv25_3, 29,  85, 1, &B100
        end select
      elseif a2$ = "d1" then
        select case grid_size
          case 10 : blit x1d10_3, y1d10_3, x1d10_3, y1d10_3, 273, 273, 1, &B100
          case 15 : blit x1d15_3, y1d15_3, x1d15_3, y1d15_3, 178, 178, 1, &B100
          case 20 : blit x1d20_3, y1d20_3, x1d20_3, y1d20_3, 136, 136, 1, &B100
          case 25 : blit x1d25_3, y1d25_3, x1d25_3, y1d25_3, 114, 114, 1, &B100
        end select
      elseif a2$ = "d2" then
        select case grid_size
          case 10 : blit x2d10_3, y2d10_3, x2d10_3, y2d10_3, 273, 273, 1, &B100
          case 15 : blit x2d15_3, y2d15_3, x2d15_3, y2d15_3, 178, 178, 1, &B100
          case 20 : blit x2d20_3, y2d20_3, x2d20_3, y2d20_3, 136, 136, 1, &B100
          case 25 : blit x2d25_3, y2d25_3, x2d25_3, y2d25_3, 114, 114, 1, &B100
        end select
      endif
    case 2, 7, 12, 17, 22, 27
      page write 1
      if a2$ = "h" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Submarine h 94 207x67", xh10_2, yh10_2
          case 15 : load png "/Battleship/graphics/Submarine h 61 135x44", xh15_2, yh15_2
          case 20 : load png "/Battleship/graphics/Submarine h 47 104x34", xh20_2, yh20_2
          case 25 : load png "/Battleship/graphics/Submarine h 39 86x28", xh25_2, yh25_2
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Submarine v 94 67x207", xv10_2, yv10_2
          case 15 : load png "/Battleship/graphics/Submarine v 61 44x135", xv15_2, yv15_2
          case 20 : load png "/Battleship/graphics/Submarine v 47 34x104", xv20_2, yv20_2
          case 25 : load png "/Battleship/graphics/Submarine v 39 28x86", xv25_2, yv25_2
        end select
      elseif a2$ = "d1" then 'NWSE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Submarine NWSE 133 273x273", x1d10_2, y1d10_2
          case 15 : load png "/Battleship/graphics/Submarine NWSE 86 178x178", x1d15_2, y1d15_2
          case 20 : load png "/Battleship/graphics/Submarine NWSE 66 136x136", x1d20_2, y1d20_2
          case 25 : load png "/Battleship/graphics/Submarine NWSE 55 114x114", x1d25_2, y1d25_2
        end select
      elseif a2$ = "d2" then 'SWNE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Submarine SWNE 133 273x273", x2d10_2, y2d10_2
          case 15 : load png "/Battleship/graphics/Submarine SWNE 86 178x178", x2d15_2, y2d15_2
          case 20 : load png "/Battleship/graphics/Submarine SWNE 66 136x136", x2d20_2, y2d20_2
          case 25 : load png "/Battleship/graphics/Submarine SWNE 55 114x114", x2d25_2, y2d25_2
        end select
      endif
      page write 0
      if a2$ = "h" then
        select case grid_size
          case 10 : blit xh10_2, yh10_2, xh10_2, yh10_2, 207, 67, 1, &B100
          case 15 : blit xh15_2, yh15_2, xh15_2, yh15_2, 135, 44, 1, &B100
          case 20 : blit xh20_2, yh20_2, xh20_2, yh20_2, 104, 34, 1, &B100
          case 25 : blit xh25_2, yh25_2, xh25_2, yh25_2,  86, 28, 1, &B100
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : blit xv10_2, yv10_2, xv10_2, yv10_2, 67, 207, 1, &B100
          case 15 : blit xv15_2, yv15_2, xv15_2, yv15_2, 44, 135, 1, &B100
          case 20 : blit xv20_2, yv20_2, xv20_2, yv20_2, 34, 104, 1, &B100
          case 25 : blit xv25_2, yv25_2, xv25_2, yv25_2, 28,  86, 1, &B100
        end select
      elseif a2$ = "d1" then
        select case grid_size
          case 10 : blit x1d10_2, y1d10_2, x1d10_2, y1d10_2, 273, 273, 1, &B100
          case 15 : blit x1d15_2, y1d15_2, x1d15_2, y1d15_2, 178, 178, 1, &B100
          case 20 : blit x1d20_2, y1d20_2, x1d20_2, y1d20_2, 136, 136, 1, &B100
          case 25 : blit x1d25_2, y1d25_2, x1d25_2, y1d25_2, 114, 114, 1, &B100
        end select
      elseif a2$ = "d2" then
        select case grid_size
          case 10 : blit x2d10_2, y2d10_2, x2d10_2, y2d10_2, 273, 273, 1, &B100
          case 15 : blit x2d15_2, y2d15_2, x2d15_2, y2d15_2, 178, 178, 1, &B100
          case 20 : blit x2d20_2, y2d20_2, x2d20_2, y2d20_2, 136, 136, 1, &B100
          case 25 : blit x2d25_2, y2d25_2, x2d25_2, y2d25_2, 114, 114, 1, &B100
        end select
      endif
    case 1, 6, 11, 16, 21, 26
      page write 1
      if a2$ = "h" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Destroyer h 94 146x68", xh10_1, yh10_1
          case 15 : load png "/Battleship/graphics/Destroyer h 61 95x44", xh15_1, yh15_1
          case 20 : load png "/Battleship/graphics/Destroyer h 47 73x34", xh20_1, yh20_1
          case 25 : load png "/Battleship/graphics/Destroyer h 39 61x29", xh25_1, yh25_1
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : load png "/Battleship/graphics/Destroyer v 92 67x143", xv10_1, yv10_1
          case 15 : load png "/Battleship/graphics/Destroyer v 61 44x95", xv15_1, yv15_1
          case 20 : load png "/Battleship/graphics/Destroyer v 46 34x72", xv20_1, yv20_1
          case 25 : load png "/Battleship/graphics/Destroyer v 39 29x61", xv25_1, yv25_1
        end select
      elseif a2$ = "d1" then 'NWSE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Destroyer NWSE 133 214x215", x1d10_1, y1d10_1
          case 15 : load png "/Battleship/graphics/Destroyer NWSE 86 139x140", x1d15_1, y1d15_1
          case 20 : load png "/Battleship/graphics/Destroyer NWSE 66 107x107", x1d20_1, y1d20_1
          case 25 : load png "/Battleship/graphics/Destroyer NWSE 55 89x90", x1d25_1, y1d25_1
        end select
      elseif a2$ = "d2" then 'SWNE
        select case grid_size
          case 10 : load png "/Battleship/graphics/Destroyer SWNE 133 214x214", x2d10_1, y2d10_1
          case 15 : load png "/Battleship/graphics/Destroyer SWNE 86 139x139", x2d15_1, y2d15_1
          case 20 : load png "/Battleship/graphics/Destroyer SWNE 66 107x107", x2d20_1, y2d20_1
          case 25 : load png "/Battleship/graphics/Destroyer SWNE 55 89x89", x2d25_1, y2d25_1
        end select
      endif
      page write 0
      if a2$ = "h" then
        select case grid_size
          case 10 : blit xh10_1, yh10_1, xh10_1, yh10_1, 146, 68, 1, &B100
          case 15 : blit xh15_1, yh15_1, xh15_1, yh15_1,  95, 44, 1, &B100
          case 20 : blit xh20_1, yh20_1, xh20_1, yh20_1,  73, 34, 1, &B100
          case 25 : blit xh25_1, yh25_1, xh25_1, yh25_1,  61, 29, 1, &B100
        end select
      elseif a2$ = "v" then
        select case grid_size
          case 10 : blit xv10_1, yv10_1, xv10_1, yv10_1, 67, 143, 1, &B100
          case 15 : blit xv15_1, yv15_1, xv15_1, yv15_1, 44,  95, 1, &B100
          case 20 : blit xv20_1, yv20_1, xv20_1, yv20_1, 34,  72, 1, &B100
          case 25 : blit xv25_1, yv25_1, xv25_1, yv25_1, 29,  61, 1, &B100
        end select
      elseif a2$ = "d1" then
        select case grid_size
          case 10 : blit x1d10_1, y1d10_1, x1d10_1, y1d10_1, 214, 215, 1, &B100
          case 15 : blit x1d15_1, y1d15_1, x1d15_1, y1d15_1, 139, 140, 1, &B100
          case 20 : blit x1d20_1, y1d20_1, x1d20_1, y1d20_1, 107, 107, 1, &B100
          case 25 : blit x1d25_1, y1d25_1, x1d25_1, y1d25_1,  89,  90, 1, &B100
        end select
      elseif a2$ = "d2" then
        select case grid_size
          case 10 : blit x2d10_1, y2d10_1, x2d10_1, y2d10_1, 214, 214, 1, &B100
          case 15 : blit x2d15_1, y2d15_1, x2d15_1, y2d15_1, 139, 139, 1, &B100
          case 20 : blit x2d20_1, y2d20_1, x2d20_1, y2d20_1, 107, 107, 1, &B100
          case 25 : blit x2d25_1, y2d25_1, x2d25_1, y2d25_1,  89,  89, 1, &B100
        end select
      endif
  end select
end sub

function num_to_letter(v) as string
  select case v
    case 1  : num_to_letter = "a"
    case 2  : num_to_letter = "b"
    case 3  : num_to_letter = "c"
    case 4  : num_to_letter = "d"
    case 5  : num_to_letter = "e"
    case 6  : num_to_letter = "f"
    case 7  : num_to_letter = "g"
    case 8  : num_to_letter = "h"
    case 9  : num_to_letter = "i"
    case 10 : num_to_letter = "j"
    case 11 : num_to_letter = "k"
    case 12 : num_to_letter = "l"
    case 13 : num_to_letter = "m"
    case 14 : num_to_letter = "n"
    case 15 : num_to_letter = "o"
    case 16 : num_to_letter = "p"
    case 17 : num_to_letter = "q"
    case 18 : num_to_letter = "r"
    case 19 : num_to_letter = "s"
    case 20 : num_to_letter = "t"
    case 21 : num_to_letter = "u"
    case 22 : num_to_letter = "v"
    case 23 : num_to_letter = "w"
    case 24 : num_to_letter = "x"
    case 25 : num_to_letter = "y"
    case 26 : num_to_letter = "z"
  end select
end function

function letter_to_num(v$) as integer
  select case v$
    case "a" : letter_to_num = 1
    case "b" : letter_to_num = 2
    case "c" : letter_to_num = 3
    case "d" : letter_to_num = 4
    case "e" : letter_to_num = 5
    case "f" : letter_to_num = 6
    case "g" : letter_to_num = 7
    case "h" : letter_to_num = 8
    case "i" : letter_to_num = 9
    case "j" : letter_to_num = 10
    case "k" : letter_to_num = 11
    case "l" : letter_to_num = 12
    case "m" : letter_to_num = 13
    case "n" : letter_to_num = 14
    case "o" : letter_to_num = 15
    case "p" : letter_to_num = 16
    case "q" : letter_to_num = 17
    case "r" : letter_to_num = 18
    case "s" : letter_to_num = 19
    case "t" : letter_to_num = 20
    case "u" : letter_to_num = 21
    case "v" : letter_to_num = 22
    case "w" : letter_to_num = 23
    case "x" : letter_to_num = 24
    case "y" : letter_to_num = 25
    case "z" : letter_to_num = 26
  end select
end function

function end_letter(v$, w) as string
  select case w
    case 1
      select case v$
        case "a" : end_letter = "b"
        case "b" : end_letter = "c"
        case "c" : end_letter = "d"
        case "d" : end_letter = "e"
        case "e" : end_letter = "f"
        case "f" : end_letter = "g"
        case "g" : end_letter = "h"
        case "h" : end_letter = "i"
        case "i" : end_letter = "j"
        case "j" : end_letter = "k"      
        case "k" : end_letter = "l"
        case "l" : end_letter = "m"
        case "m" : end_letter = "n"
        case "n" : end_letter = "o"
        case "o" : end_letter = "p"
        case "p" : end_letter = "q"
        case "q" : end_letter = "r"
        case "r" : end_letter = "s"
        case "s" : end_letter = "t"
        case "t" : end_letter = "u"
        case "u" : end_letter = "v"
        case "v" : end_letter = "w"
        case "w" : end_letter = "x"
        case "x" : end_letter = "y"
        case "y" : end_letter = "z"
      end select
    case 2
      select case v$
        case "a" : end_letter = "c"
        case "b" : end_letter = "d"
        case "c" : end_letter = "e"
        case "d" : end_letter = "f"
        case "e" : end_letter = "g"
        case "f" : end_letter = "h"
        case "g" : end_letter = "i"
        case "h" : end_letter = "j"
        case "i" : end_letter = "k"
        case "j" : end_letter = "l"      
        case "k" : end_letter = "m"
        case "l" : end_letter = "n"
        case "m" : end_letter = "o"
        case "n" : end_letter = "p"
        case "o" : end_letter = "q"
        case "p" : end_letter = "r"
        case "q" : end_letter = "s"
        case "r" : end_letter = "t"
        case "s" : end_letter = "u"
        case "t" : end_letter = "v"
        case "u" : end_letter = "w"
        case "v" : end_letter = "x"
        case "w" : end_letter = "y"
        case "x" : end_letter = "z"
        case "y" : end_letter = " "
      end select
    case 3
      select case v$
        case "a" : end_letter = "d"
        case "b" : end_letter = "e"
        case "c" : end_letter = "f"
        case "d" : end_letter = "g"
        case "e" : end_letter = "h"
        case "f" : end_letter = "i"
        case "g" : end_letter = "j"
        case "h" : end_letter = "k"
        case "i" : end_letter = "l"
        case "j" : end_letter = "m"     
        case "k" : end_letter = "n"
        case "l" : end_letter = "o"
        case "m" : end_letter = "p"
        case "n" : end_letter = "q"
        case "o" : end_letter = "r"
        case "p" : end_letter = "s"
        case "q" : end_letter = "t"
        case "r" : end_letter = "u"
        case "s" : end_letter = "v"
        case "t" : end_letter = "w"
        case "u" : end_letter = "x"
        case "v" : end_letter = "y"
        case "w" : end_letter = "z"
        case "x" : end_letter = " "
        case "y" : end_letter = " "
      end select
    case 4
      select case v$
        case "a" : end_letter = "e"
        case "b" : end_letter = "f"
        case "c" : end_letter = "g"
        case "d" : end_letter = "h"
        case "e" : end_letter = "i"
        case "f" : end_letter = "j"
        case "g" : end_letter = "k"
        case "h" : end_letter = "l"
        case "i" : end_letter = "m"
        case "j" : end_letter = "n"      
        case "k" : end_letter = "o"
        case "l" : end_letter = "p"
        case "m" : end_letter = "q"
        case "n" : end_letter = "r"
        case "o" : end_letter = "s"
        case "p" : end_letter = "t"
        case "q" : end_letter = "u"
        case "r" : end_letter = "v"
        case "s" : end_letter = "w"
        case "t" : end_letter = "x"
        case "u" : end_letter = "y"
        case "v" : end_letter = "z"
        case "w" : end_letter = " "
        case "x" : end_letter = " "
        case "y" : end_letter = " "
      end select
  end select
end function

function end_letter2(v$, w) as string
  select case w
    case 1
      select case v$
        case "b" : end_letter2 = "a"
        case "c" : end_letter2 = "b"
        case "d" : end_letter2 = "c"
        case "e" : end_letter2 = "d"
        case "f" : end_letter2 = "e"
        case "g" : end_letter2 = "f"
        case "h" : end_letter2 = "g"
        case "i" : end_letter2 = "h"
        case "j" : end_letter2 = "i"      
        case "k" : end_letter2 = "j"
        case "l" : end_letter2 = "k"
        case "m" : end_letter2 = "l"
        case "n" : end_letter2 = "m"
        case "o" : end_letter2 = "n"
        case "p" : end_letter2 = "o"
        case "q" : end_letter2 = "p"
        case "r" : end_letter2 = "q"
        case "s" : end_letter2 = "r"
        case "t" : end_letter2 = "s"
        case "u" : end_letter2 = "t"
        case "v" : end_letter2 = "u"
        case "w" : end_letter2 = "v"
        case "x" : end_letter2 = "w"
        case "y" : end_letter2 = "x"
      end select
    case 2
      select case v$      
        case "c" : end_letter2 = "a"
        case "d" : end_letter2 = "b"
        case "e" : end_letter2 = "c"
        case "f" : end_letter2 = "d"
        case "g" : end_letter2 = "e"
        case "h" : end_letter2 = "f"
        case "i" : end_letter2 = "g"
        case "j" : end_letter2 = "h"      
        case "k" : end_letter2 = "i"
        case "l" : end_letter2 = "j"
        case "m" : end_letter2 = "k"
        case "n" : end_letter2 = "l"
        case "o" : end_letter2 = "m"
        case "p" : end_letter2 = "n"
        case "q" : end_letter2 = "o"
        case "r" : end_letter2 = "p"
        case "s" : end_letter2 = "q"
        case "t" : end_letter2 = "r"
        case "u" : end_letter2 = "s"
        case "v" : end_letter2 = "t"
        case "w" : end_letter2 = "u"
        case "x" : end_letter2 = "v"
        case "y" : end_letter2 = "w"
      end select
    case 3
      select case v$     
        case "d" : end_letter2 = "a"
        case "e" : end_letter2 = "b"
        case "f" : end_letter2 = "c"
        case "g" : end_letter2 = "d"
        case "h" : end_letter2 = "e"
        case "i" : end_letter2 = "f"
        case "j" : end_letter2 = "g"     
        case "k" : end_letter2 = "h"
        case "l" : end_letter2 = "i"
        case "m" : end_letter2 = "j"
        case "n" : end_letter2 = "k"
        case "o" : end_letter2 = "l"
        case "p" : end_letter2 = "m"
        case "q" : end_letter2 = "n"
        case "r" : end_letter2 = "o"
        case "s" : end_letter2 = "p"
        case "t" : end_letter2 = "q"
        case "u" : end_letter2 = "r"
        case "v" : end_letter2 = "s"
        case "w" : end_letter2 = "t"
        case "x" : end_letter2 = "u"
        case "y" : end_letter2 = "v"
      end select
    case 4
      select case v$      
        case "e" : end_letter2 = "a"
        case "f" : end_letter2 = "b"
        case "g" : end_letter2 = "c"
        case "h" : end_letter2 = "d"
        case "i" : end_letter2 = "e"
        case "j" : end_letter2 = "f"      
        case "k" : end_letter2 = "g"
        case "l" : end_letter2 = "h"
        case "m" : end_letter2 = "i"
        case "n" : end_letter2 = "j"
        case "o" : end_letter2 = "k"
        case "p" : end_letter2 = "l"
        case "q" : end_letter2 = "m"
        case "r" : end_letter2 = "n"
        case "s" : end_letter2 = "o"
        case "t" : end_letter2 = "p"
        case "u" : end_letter2 = "q"
        case "v" : end_letter2 = "r"
        case "w" : end_letter2 = "s"
        case "x" : end_letter2 = "t"
        case "y" : end_letter2 = "u"
      end select
  end select
end function

function next_letter(v$) as string
  select case v$
    case "a" : next_letter = "b"
    case "b" : next_letter = "c"
    case "c" : next_letter = "d"
    case "d" : next_letter = "e"
    case "e" : next_letter = "f"
    case "f" : next_letter = "g"
    case "g" : next_letter = "h"
    case "h" : next_letter = "i"
    case "i" : next_letter = "j"
    case "j" : next_letter = "k"
    case "k" : next_letter = "l"
    case "l" : next_letter = "m"
    case "m" : next_letter = "n"
    case "n" : next_letter = "o"
    case "o" : next_letter = "p"
    case "p" : next_letter = "q"
    case "q" : next_letter = "r"
    case "r" : next_letter = "s"
    case "s" : next_letter = "t"
    case "t" : next_letter = "u"
    case "u" : next_letter = "v"
    case "v" : next_letter = "w"
    case "w" : next_letter = "x"
    case "x" : next_letter = "y"
    case "y" : next_letter = "z"
    case "z" : next_letter = " "
  end select  
end function


