'Battleship
option base 1
dim string a$, a1$, a2$, e$, v$, ship_square$ length 3
dim string ship_start_square$(10) length 3, ship_end_square$(10) length 3 '5 for player + 5 for computer 
dim string ship_orientation$(10) length 1 'h or v
dim integer player_ships_grid(15, 15) 'values 0 to 5, 0 = no ship, 1 = destroyer, 2 = submarine,
dim integer computer_ships_grid(15, 15) '3 = cruiser, 4 = battleship, 5 = aircraft carrier
dim integer player_ham_grid(15, 15) 'values -1, 0, and 1, Hits and Misses
dim integer computer_ham_grid(15, 15) '0 = no shot fired here, 1 = hit, 2 = miss
dim integer ship_num, ship_length(10), taken, on_grid, lc, nc, hv
dim integer player_num_hits, computer_num_hits, xh1, yh1, xv1, yv1, xh2, yh2, xv2, yv2
dim integer xh3, yh3, xv3, yv3, xh4, yh4, xv4, yv4, xh5, yh5, xv5, yv5
dim integer lsl, lsn, lshm, direction 'last shot letter, number, and hit/miss
dim integer directions_tried, lhl, lhn, ssh, offset 'last hit letter, number, shots since hit
dim integer version, num_shots, first_round, who_shoots_first '1 = player, 2 = computer
dim integer i, j, z, not_found, adjacent_hit, stsah, stsah_cnt, r
mode 9, 16
page resize 1, 1024, 768
font 4 '10x16 pixels
who_shoots_first = 1
ship_length(10) = 5
ship_length(9)  = 4
ship_length(8)  = 3
ship_length(7)  = 3
ship_length(6)  = 2
ship_length(5)  = 5
ship_length(4)  = 4
ship_length(3)  = 3
ship_length(2)  = 3
ship_length(1)  = 2

play_again:
for j = 1 to 10
  for i = 1 to 10
    player_ships_grid(i, j) = 0
    computer_ships_grid(i, j) = 0
    player_ham_grid(i, j) = 0
    computer_ham_grid(i, j) = 0
  next i
next j
for i = 1 to 10
  ship_start_square$(i) = ""
  ship_end_square$(i) = ""
next i
ssh = 99 'set to an arbitrary high value
first_round = 1
color rgb(cyan)

do
  cls
  print @(10,  16) "Battleship"
  print @(10,  48) "1. One shot per round"
  print @(10,  64) "2. Salvos / Multiple shots per round"
  print @(10,  96) "Which version (1 or 2)"
  print @(10, 112);: input version
  if version < 1 or version > 2 then continue do
  exit do
loop

pause 2500
cls
page write 1
load bmp "/Battleship/graphics/Grid 10x10 772x768.bmp", 0, 0
page copy 1 to 0, B
page write 0

print @(784,  16) "Battleship"
color rgb(orange)
print @(784,  48) "5 (5L) Aircraft Carrier"
print @(784,  64) "4 (4L) Battleship"
print @(784,  80) "3 (3L) Cruiser"
print @(784,  96) "2 (3L) Submarine"
print @(784, 112) "1 (2L) Destroyer"
place_player_ships()
place_computer_ships()

do
  player_num_hits = 0
  computer_num_hits = 0
  player_alive = 0
  computer_alive = 0
  for i = 1 to 10
    for j = 1 to 10
      if player_ham_grid(i, j) = 1 then inc player_num_hits
      if computer_ham_grid(i, j) = 1 then inc computer_num_hits 
    next j
  next i
  if player_num_hits > 16 then 'game over    
    print @(784, 230) "The player won!"
    play tts "You sank sams bat tull shipp"
    pause 4000
    exit do
  elseif computer_num_hits > 16 then 'game over
    print @(784, 230) "The computer won!"
    play tts "sam sank your bat tull shipp"
    pause 4000
    exit do
  endif
  if version = 1 then
    if who_shoots_first = 1 then
      player_single_guess()
      computer_single_guess()
    else
      computer_single_guess()
      player_single_guess()
    endif
  elseif version = 2 then
    if who_shoots_first = 1 then
      player_multiple_guesses()
      computer_multiple_guesses()
    else
      computer_multiple_guesses()
      player_multiple_guesses()
    endif
  endif
  first_round = 0
loop
ending()

'Are these subs part of the fleet?
sub place_player_ships
  for ship_num = 5 to 1 step -1    
    do
      print @(784, 150) "                "
      print @(784, 166) "                "
      print @(784, 198) "                "
      print @(784, 214) "                "
      print @(784, 230) "                "
      for i = 1 to 99
        print @(784, 150) "Start square"; ship_num
        print @(784, 166);: input a1$
        taken = 0
        for j = 1 to 5
          if a1$ = ship_start_square$(j) then taken = 1 
        next j
        if taken = 0 and lcase$(left$(a1$, 1)) >= "a" and lcase$(left$(a1$, 1)) <= "j" and val(mid$(a1$, 2, 2)) > 0 and val(mid$(a1$, 2, 2)) < 11 then exit for       
        print @(784, 166) "            "
      next i 
      print @(784, 198) "Place Horizontal"
      print @(784, 214) "or Vertical"
      print @(784, 230);: input a2$    
      if a2$ = "h" then
        if val(mid$(a1$, 2, 2)) + ship_length(ship_num) - 1 > 10 then continue do 'off the edge of the grid       
          for i = 1 to ship_length(ship_num)
            if player_ships_grid(letter_to_num(left$(a1$, 1)), val(mid$(a1$, 2, 2)) + i - 1) > 0 then continue do 'overlaps with an existing ship        
          next i
      elseif a2$ = "v" then
        if letter_to_num(left$(a1$, 1)) + ship_length(ship_num) - 1 > 10 then restart_1pps() 'off the edge of the grid
          for i = 1 to ship_length(ship_num)
            if player_ships_grid(letter_to_num(left$(a1$, 1)) + i - 1, val(mid$(a1$, 2, 2))) > 0 then continue do 'overlaps with an existing ship
          next i
      else
        continue do
      endif
      exit do
    loop

    ship_start_square$(ship_num) = a1$
    ship_orientation$(ship_num) = a2$

    if a2$ = "h" then
      ship_end_square$(ship_num) = left$(ship_start_square$(ship_num), 1) + str$(val(mid$(ship_start_square$(ship_num), 2, 2)) + ship_length(ship_num) - 1)
    else 'a2$ = "v" 
      ship_end_square$(ship_num) = end_letter(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)
    endif
    for i = 1 to ship_length(ship_num)
      if i = 1 then
        player_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
      else 'i > 1
        if a2$ = "h" then
          player_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num
        else 'a2$ = "v"
          player_ships_grid(letter_to_num(end_letter(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
        endif
      endif
    next i

    lc = letter_to_num(left$(a1$, 1)) 'letter coordinate 
    nc = val(mid$(a1$, 2, 2 )) 'number coordinate
    show_ships()
        
    print @(784, 150) "                "
    print @(784, 166) "                "
    print @(784, 182) "                "
    print @(784, 198) "                "
    print @(784, 214) "                "
    print @(784, 230) "                "    
  next ship_num
end sub

sub place_computer_ships
  for ship_num = 10 to 6 step -1    
    do
      lc = int(rnd * 10 + 1) 'random letter coordinate       
      nc = int(rnd * 10 + 1) 'random number coordinate
      hv = int(rnd *  2 + 1) '1 = horizontal, 2 = vertical
      if hv = 1 then 'horizontal      
        if nc + ship_length(ship_num) - 1 > 10 then continue do 'off the edge of the grid       
        for i = 1 to ship_length(ship_num)
          if computer_ships_grid(lc, nc + i - 1) > 0 then continue do 'overlaps with an existing ship        
        next i
      else 'hv = 2, vertical
        if lc + ship_length(ship_num) - 1 > 10 then continue do 'off the edge of the grid
        for i = 1 to ship_length(ship_num)
          if computer_ships_grid(lc + i - 1, nc) > 0 then continue do 'overlaps with an existing ship
        next i
      endif
      exit do
    loop

    ship_start_square$(ship_num) = num_to_letter(lc) + str$(nc) 
    if hv = 1 then
      ship_orientation$(ship_num) = "h"
    else 'hv = 2
      ship_orientation$(ship_num) = "v"
    endif
    if hv = 1 then 'horizontal
      ship_end_square$(ship_num) = left$(ship_start_square$(ship_num), 1) + str$(val(mid$(ship_start_square$(ship_num), 2, 2)) + ship_length(ship_num) - 1)
    else 'hv = 2, vertical
      ship_end_square$(ship_num) = end_letter(left$(ship_start_square$(ship_num), 1), ship_length(ship_num)) + mid$(ship_start_square$(ship_num), 2, 2)
    endif
    for i = 1 to ship_length(ship_num)
      if i = 1 then
        computer_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
      else 
        if hv = 1 then 'horizontal 
          computer_ships_grid(letter_to_num(left$(ship_start_square$(ship_num), 1)), val(mid$(ship_start_square$(ship_num), 2, 2)) + i - 1) = ship_num
        else 'hv = 2, vertical
          computer_ships_grid(letter_to_num(end_letter(left$(ship_start_square$(ship_num), 1), i - 1)), val(mid$(ship_start_square$(ship_num), 2, 2))) = ship_num
        endif
      endif
    next i
  next ship_num    
  pause 2000
end sub

sub player_single_guess
  cls
  page write 1
  load bmp "/Battleship/graphics/Grid 10x10 772x768.bmp", 0, 0
  page copy 1 to 0, B
  page write 0
  for i = 1 to 10
    for j = 1 to 10
      if player_ham_grid(i, j) = 1 then
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(red), rgb(red)
      elseif player_ham_grid(i, j) = 2 then 
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(white), rgb(white)
      endif
    next j
  next i

  do
    print @(784, 150) "                "
    print @(784, 166) "                "
    print @(784, 198) "                "
    print @(784, 214) "                "
    print @(784, 230) "                "  
    print @(784, 150) "Shoot square"
    print @(784, 166);: input a$
  
    if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "j" then continue do
    if val(mid$(a$, 2, 2)) < 1 or val(mid$(a$, 2, 2)) > 10 then continue do
    if player_ham_grid(letter_to_num(left$(a$, 1)), val(mid$(a$, 2, 2))) > 0 then continue do 'Already shot this square   
    exit do
  loop

  lc = letter_to_num(left$(a$, 1))  
  nc = val(mid$(a$, 2, 2))
  
  if computer_ships_grid(lc, nc) > 0 then
    print @(784, 198) "A hit!"
    player_ham_grid(lc, nc) = 1
    circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(red), rgb(red)
    pause 2500
  else ' = 0
    print @(784, 198) "Missed"
    player_ham_grid(lc, nc) = 2
    circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(white), rgb(white)
    pause 2500
  endif
end sub

sub computer_single_guess
  cls
  page write 1
  load bmp "/Battleship/graphics/Grid 10x10 772x768.bmp", 0, 0
  page copy 1 to 0, B
  page write 0

  'Display the player's ships 
  for ship_num = 1 to 5 
    lc = letter_to_num(left$(ship_start_square$(ship_num), 1))
    nc = val(mid$(ship_start_square$(ship_num), 2, 2))
    a2$ = ship_orientation$(ship_num)
    show_ships() 
  next ship_num

  'Display the hits and misses on the grid
  for i = 1 to 10
    for j = 1 to 10
      if computer_ham_grid(i, j) = 1 then 'Has square been HIT?
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(red), rgb(red)
      elseif computer_ham_grid(i, j) = 2 then 'Has square been MISSED?
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(white), rgb(white)
      endif
    next j
  next i

  computer_guesses_main()
  print @(784, 150) "Computer guesses  "; ucase$(num_to_letter(lc)) + str$(nc)

  if player_ships_grid(lc, nc) > 0 then
    print @(784, 198) "A hit!"
    computer_ham_grid(lc, nc) = 1
    circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(red), rgb(red)
    lsl = lc : lsn = nc : lshm = 1 : lhl = lc : lhn = nc 
    ssh = 0 'shots since hit
  else ' = 0
    print @(784, 198) "Missed"
    computer_ham_grid(lc, nc) = 2
    circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(white), rgb(white)
    lsl = lc : lsn = nc : lshm = 2
    inc ssh
  endif  

  print @(784, 250) "                  "
  print @(784, 266) "                  "
  print @(784, 250) "Press Enter to"
  print @(784, 266) "continue...";: input "", e$
  do
    if keydown(0) = 1 then exit do
  loop
end sub

sub player_multiple_guesses
  cls
  page write 1
  load bmp "/Battleship/graphics/Grid 10x10 772x768.bmp", 0, 0
  page copy 1 to 0, B
  page write 0
  for i = 1 to 10
    for j = 1 to 10
      if player_ham_grid(i, j) = 1 then
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(red), rgb(red)
      elseif player_ham_grid(i, j) = 2 then 
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(white), rgb(white)
      endif
    next j
  next i
  
  'Calculate how many shots the player receives this round  
  if first_round = 1 then
    num_shots = 5
  else
    num_shots = 0
    for num_ship = 1 to 5
      do
        for i = 1 to 10
          for j = 1 to 10
            if player_ships_grid(i, j) = num_ship and computer_ham_grid(i, j) <> 1 then 'not a hit
              inc num_shots
              exit do
            endif
          next j
        next i 
        exit do
      loop
    next num_ship
  endif

  for i = 1 to num_shots
    do
      print @(784, 150) "                   "
      print @(784, 166) "                   "
      print @(784, 198) "                   "
      print @(784, 214) "                   "
      print @(784, 230) "                   "  
      print @(784, 150) "Square for shot";i;" of"; num_shots
      print @(784, 166);: input a$

      if lcase$(left$(a$, 1)) < "a" or lcase$(left$(a$, 1)) > "j" then continue do
      if val(mid$(a$, 2, 2)) < 1 or val(mid$(a$, 2, 2)) > 10 then continue do
      if player_ham_grid(letter_to_num(left$(a$, 1)), val(mid$(a$, 2, 2))) > 0 then continue do 'Already shot this square
      exit do
    loop

    lc = letter_to_num(left$(a$, 1))  
    nc = val(mid$(a$, 2, 2))
  
    if computer_ships_grid(lc, nc) > 0 then
      print @(784, 198) "A hit!"
      player_ham_grid(lc, nc) = 1
      circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(red), rgb(red)
      pause 2500
    else ' = 0
      print @(784, 198) "Missed"
      player_ham_grid(lc, nc) = 2
      circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(white), rgb(white)
      pause 2500
    endif
  next i
end sub

sub computer_multiple_guesses
  inc ssh 'shots since hit
  cls
  page write 1
  load bmp "/Battleship/graphics/Grid 10x10 772x768.bmp", 0, 0
  page copy 1 to 0, B
  page write 0

  for ship_num = 1 to 5
    lc = letter_to_num(left$(ship_start_square$(ship_num), 1))
    nc = val(mid$(ship_start_square$(ship_num), 2, 2))
    a2$ = ship_orientation$(ship_num)
    show_ships() 
  next ship_num

  for i = 1 to 10
    for j = 1 to 10
      if computer_ham_grid(i, j) = 1 then
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(red), rgb(red)
      elseif computer_ham_grid(i, j) = 2 then
        circle 37 + (68 * j), 33 + (68 * i), 9, 1, 1, rgb(white), rgb(white)
      endif
    next j
  next i

  'Calculate how many shots the computer receives this round  
  if first_round = 1 then
    num_shots = 5
  else
    num_shots = 0
    for num_ship = 6 to 10
      do
        for i = 1 to 10
          for j = 1 to 10
            if computer_ships_grid(i, j) = num_ship and player_ham_grid(i, j) <> 1 then 'not a hit
              inc num_shots
              exit do
            endif
          next j
        next i
        exit do 
      loop
    next num_ship
  endif

  for z = 1 to num_shots
    computer_guesses_main()   
    print @(784, 150) "Shot"; z; " of"; num_shots
    print @(784, 166) "Computer guesses  "; ucase$(num_to_letter(lc)) + str$(nc)
    if player_ships_grid(lc, nc) > 0 then
      print @(784, 198) "A hit!"
      computer_ham_grid(lc, nc) = 1
      circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(red), rgb(red)
      lsl = lc : lsn = nc : lshm = 1 : lhl = lc : lhn = nc 
      ssh = 0 'shots since hit
    else ' = 0
      print @(784, 198) "Missed"
      computer_ham_grid(lc, nc) = 2
      circle 37 + (68 * nc), 33 + (68 * lc), 9, 1, 1, rgb(white), rgb(white)
      lsl = lc : lsn = nc : lshm = 2
    endif
    pause 3000  
    print @(784, 150) "                     "
    print @(784, 166) "                     "
    print @(784, 198) "                     "
  next z

  print @(784, 250) "                    "
  print @(784, 266) "                    "
  print @(784, 250) "Press Enter to"
  print @(784, 266) "continue...";: input "", e$
  do
    if keydown(0) = 1 then exit do
  loop
end sub

sub computer_guesses_main
  not_found = 0
  stsah_cnt = 0    
  do   
    stsah = int(rnd * 100 + 1)    
    do
      if stsah < 29 and stsah_cnt < 250 then
        lc = int(rnd * 10 + 1)
        nc = int(rnd * 10 + 1)
        if computer_ham_grid(lc, nc) <> 0 then continue do
        if computer_ham_grid(lc, nc) = 1 then 'square has been hit
          if nc - 1 > 0 then
            if computer_ham_grid(lc, nc - 1) = 0 then
              exit do
            endif
          endif
          if nc + 1 < 11 then
            if computer_ham_grid(lc, nc + 1) = 0 then
              exit do
            endif
          endif
          if lc - 1 > 0 then
            if computer_ham_grid(lc - 1, nc) = 0 then
              exit do
            endif
          endif
          if lc + 1 < 11 then
            if computer_ham_grid(lc + 1, nc) = 0 then
              exit do
            endif
          endif
        else
          inc stsah_cnt
          continue do
        endif    
      else
        lc = int(rnd * 10 + 1)
        nc = int(rnd * 10 + 1)
        if computer_ham_grid(lc, nc) <> 0 then continue do
      endif
      exit do
    loop 
     
    if not_found < 15 then
      if lc + 1 < 11 then
        if computer_ham_grid(lc + 1, nc) > 0 then
          inc not_found
          continue do
        endif
      endif
      if lc - 1 > 0 then
        if computer_ham_grid(lc - 1, nc) > 0 then
          inc not_found
          continue do
        endif
      endif
      if nc - 1 > 0 then
        if computer_ham_grid(lc, nc - 1) > 0 then
          inc not_found
          continue do
        endif
      endif
      if nc + 1 < 11 then
        if computer_ham_grid(lc, nc + 1) > 0 then
          inc not_found
          continue do
        endif
      endif
    endif

    if ssh < 5 then
      adjacent_hit = 0
      if lhn - 1 > 0 then
        if computer_ham_grid(lhl, lhn - 1) = 1 then
          adjacent_hit = 1
        endif
      endif 
      if lhn + 1 < 11 then 
        if computer_ham_grid(lhl, lhn + 1) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl - 1 > 0 then 
        if computer_ham_grid(lhl - 1, lhn) = 1 then
          adjacent_hit = 1
        endif
      endif
      if lhl + 1 < 11 then
        if computer_ham_grid(lhl + 1, lhn) = 1 then
          adjacent_hit = 1
        endif
      endif
      
      do  
        r = int(rnd * 2 + 1) 'This provides less predictability for the computer's guesses
        if r = 1 then
          if adjacent_hit = 0 then
            if lhl - 1 > 0 then
              if computer_ham_grid(lhl - 1, lhn) = 0 then
                lc = lhl - 1 : nc = lhn
                exit do
              endif
            endif
            if lhl + 1 < 11 then
              if computer_ham_grid(lhl + 1, lhn) = 0 then
                lc = lhl + 1 : nc = lhn
                exit do
              endif
            endif
            if lhn - 1 > 0 then
              if computer_ham_grid(lhl, lhn - 1) = 0 then
                lc = lhl : nc = lhn - 1
                exit do
              endif
            endif
            if lhn + 1 < 11 then
              if computer_ham_grid(lhl, lhn + 1) = 0 then
                lc = lhl : nc = lhn + 1
                exit do
              endif
            endif
          endif
        else 'r = 2 
          if lhn + 1 < 11 then
            if computer_ham_grid(lhl, lhn + 1) = 0 then
              lc = lhl : nc = lhn + 1
              exit do
            endif
          endif
          if lhn - 1 > 0 then
            if computer_ham_grid(lhl, lhn - 1) = 0 then
              lc = lhl : nc = lhn - 1
              exit do
            endif
          endif
          if lhl + 1 < 11 then
            if computer_ham_grid(lhl + 1, lhn) = 0 then
              lc = lhl + 1 : nc = lhn
              exit do
            endif
          endif
          if lhl - 1 > 0 then
            if computer_ham_grid(lhl - 1, lhn) = 0 then
              lc = lhl - 1 : nc = lhn
              exit do
            endif
          endif
        endif
        exit do
      loop
    endif

    consecutive = 0 : orientation$ = "" : startx = 0 : starty = 0
    endx = 0 : endy = 0 : adjacent_hit = 0
    do
      for i = 1 to 10
        for j = 1 to 10
          if computer_ham_grid(i, j) = 1 then
            'EAST side
            if j + 1 < 11 then
              if computer_ham_grid(i, j + 1) = 1 then
                adjacent_hit = 1
                if j + 2 < 11 then
                  if computer_ham_grid(i, j + 2) = 0 then
                    consecutive = 2 : orientation$ = "h"
                    startx = i : starty = j : endx = i : endy = j + 1
                    if computer_ham_grid(i, j + 2) = 1 then
                      if j + 3 < 11 then
                        if computer_ham_grid(i, j + 3) = 0 then
                          consecutive = 3 : orientation$ = "h"
                          startx = i : starty = j : endx = i : endy = j + 2        
                          if computer_ham_grid(i, j + 3) = 1 then
                            if j + 4 < 11 then
                              if computer_ham_grid(i, j + 4) = 0 then
                                consecutive = 4 : orientation$ = "h"
                                startx = i : starty = j : endx = i : endy = j + 3
                              endif
                            endif
                          endif                    
                        endif
                      endif
                    elseif computer_ham_grid(i, j + 1) = 0 then
                      lc = i : nc = j + 1 : exit do
                    endif               
                  endif
                endif
              elseif computer_ham_grid(i, j + 1) = 0 then
                if j - 1 > 0 then
                  if computer_ham_grid(i, j - 1) = 1 then
                    lc = i : nc = j + 1 : exit do
                  endif
                endif
              endif
            endif

            'WEST side
            if j - 1 > 0 then
              if computer_ham_grid(i, j - 1) = 1 then
                adjacent_hit = 1
                if j - 2 > 0 then
                  if computer_ham_grid(i, j - 2) = 0 then
                    consecutive = 2 : orientation$ = "h" 
                    startx = i : starty = j : endx = i : endy = j - 1              
                    if computer_ham_grid(i, j - 2) = 1 then
                      if j - 3 > 0 then
                        if computer_ham_grid(i, j - 3) = 0 then
                          consecutive = 3 : orientation$ = "h"
                          startx = i : starty = j : endx = i : endy = j - 2
                          if computer_ham_grid(i, j - 3) = 1 then
                            if j - 4 > 0 then
                              if computer_ham_grid(i, j - 4) = 0 then
                                consecutive = 4 : orientation$ = "h"
                                startx = i : starty = j : endx = i : endy = j - 3
                              endif
                            endif
                          endif                       
                        endif
                      endif
                    elseif computer_ham_grid(i, j - 1) = 0 then
                      lc = i : nc = j - 1 : exit do
                    endif               
                  endif
                endif
              elseif computer_ham_grid(i, j - 1) = 0 then
                if j + 1 < 11 then
                  if computer_ham_grid(i, j + 1) = 1 then
                    lc = i : nc = j - 1 : exit do
                  endif
                endif
              endif
            endif

            'SOUTH side
            if i + 1 < 11 then
              if computer_ham_grid(i + 1, j) = 1 then
                adjacent_hit = 1
                if i + 2 < 11 then
                  if computer_ham_grid(i + 2, j) = 0 then
                    consecutive = 2 : orientation$ = "v"
                    startx = i : starty = j : endx = i + 1 : endy = j 
                    if computer_ham_grid(i + 2, j) = 1 then
                      if i + 3 < 11 then
                        if computer_ham_grid(i + 3, j) = 0 then
                          consecutive = 3 : orientation$ = "v"
                          startx = i : starty = j : endx = i + 2 : endy = j 
                          if computer_ham_grid(i + 3, j) = 1 then
                            if i + 4 < 11 then            
                              if computer_ham_grid(i + 4, j) = 0 then
                                consecutive = 4 : orientation$ = "v"
                                startx = i : starty = j : endx = i + 3 : endy = j
                              endif
                            endif
                          endif                       
                        endif
                      endif
                    elseif computer_ham_grid(i + 1, j) = 0 then
                      lc = i + 1 : nc = j : exit do
                    endif             
                  endif
                endif
              elseif computer_ham_grid(i + 1, j) = 0 then
                if i - 1 > 0 then
                  if computer_ham_grid(i - 1, j) = 1 then
                    lc = i + 1 : nc = j : exit do
                  endif
                endif
              endif
            endif

            'NORTH side
            if i - 1 > 0 then
              if computer_ham_grid(i - 1, j) = 1 then
                adjacent_hit = 1
                if i - 2 > 0 then
                  if computer_ham_grid(i - 2, j) = 0 then
                    consecutive = 2 : orientation$ = "v"
                    startx = i : starty = j : endx = i - 1 : endy = j 
                    if computer_ham_grid(i - 2, j) = 1 then
                      if i - 3 > 0 then              
                        if computer_ham_grid(i - 3, j) = 0 then
                          consecutive = 3 : orientation$ = "v"
                          startx = i : starty = j : endx = i - 2 : endy = j                     
                          if computer_ham_grid(i - 3, j) = 1 then
                            if i - 4 > 0 then
                              if computer_ham_grid(i - 4, j) = 0 then
                                consecutive = 4 : orientation$ = "v"
                                startx = i : starty = j : endx = i - 3 : endy = j
                              endif
                            endif
                          endif                     
                        endif
                      endif
                    elseif computer_ham_grid(i - 1, j) = 0 then
                      lc = i - 1 : nc = j : exit do
                    endif
                  endif
                endif
              elseif computer_ham_grid(i - 1, j) = 0 then
                if i + 1 < 11 then
                  if computer_ham_grid(i + 1, j) = 1 then
                    lc = i - 1 : nc = j : exit do
                  endif
                endif 
              endif
            endif
          endif

          'Order from most consecutive to least consecutive
          if startx > 0 and orientation$ = "h" and consecutive = 4 and j + 4 < 11 then
            if computer_ham_grid(i, j + 4) = 0 then
              lc = i : nc = j + 4 : exit do
            endif
          endif
          if startx > 0 and orientation$ = "v" and consecutive = 4 and i + 4 < 11 then
            if computer_ham_grid(i + 4, j) = 0 then
              lc = i + 4 : nc = j : exit do
            endif
          endif
          if startx > 0 and orientation$ = "h" and consecutive = 3 and j + 3 < 11 then
            if computer_ham_grid(i, j + 3) = 0 then
              lc = i : nc = j + 3 : exit do
            endif
          endif
          if startx > 0 and orientation$ = "v" and consecutive = 3 and i + 3 < 11 then
            if computer_ham_grid(i + 3, j) = 0 then
              lc = i + 3 : nc = j : exit do
            endif
          endif
          if startx > 0 and orientation$ = "h" and consecutive = 2 and j + 2 < 11 then
            if computer_ham_grid(i, j + 2) = 0 then
              lc = i : nc = j + 2 : exit do
            endif
          endif
          if startx > 0 and orientation$ = "v" and consecutive = 2 and i + 2 < 11 then
            if computer_ham_grid(i + 2, j) = 0 then
              lc = i + 2 : nc = j : exit do
            endif
          endif
          if startx > 0 and orientation$ = "h" and j - 1 > 0 then
            if computer_ham_grid(i, j - 1) = 0 then
              lc = i : nc = j - 1 : exit do
            endif
          endif         
          if startx > 0 and orientation$ = "v" and i - 1 > 0 then
            if computer_ham_grid(i - 1, j) = 0 then
              lc = i - 1 : nc = j : exit do
            endif
          endif 
          next j
        next i
        exit do     
    loop

    if computer_ham_grid(lc, nc) > 0 then exit do 'Already shot this square
    exit do
  loop
end sub

sub ending
  print @(10, 16) "Would you like to play again"
  print @(10, 32);: input a$
  if lcase$(left$(a$, 1)) = "y" then
    if who_shoots_first = 1 then 
       who_shoots_first = 2
    else
       who_shoots_first = 1
    endif
    goto play_again:
  endif
end sub

sub show_ships
  xh5 = 75 + (68.8 * (nc - 1))
  yh5 = 66 + (67.9 * (lc - 1))
  xv5 = 71 + (68.4 * (nc - 1))
  yv5 = 72 + (67.8 * (lc - 1))
  xh4 = 77 + (68.8 * (nc - 1))
  yh4 = 67 + (67.9 * (lc - 1))
  xv4 = 72 + (68.4 * (nc - 1))
  yv4 = 73 + (67.8 * (lc - 1))
  xh3 = 68 + (68.8 * (nc - 1))
  yh3 = 67 + (67.9 * (lc - 1))
  xv3 = 71 + (68.4 * (nc - 1))
  yv3 = 65 + (67.8 * (lc - 1))
  xh2 = 72 + (68.8 * (nc - 1))
  yh2 = 72 + (67.9 * (lc - 1))
  xv2 = 73 + (68.4 * (nc - 1))
  yv2 = 74 + (67.8 * (lc - 1))
  xh1 = 68 + (68.8 * (nc - 1))
  yh1 = 65 + (67.9 * (lc - 1))
  xv1 = 75 + (68.4 * (nc - 1))
  yv1 = 66 + (67.8 * (lc - 1))

  select case ship_num
    case 5        
      page write 1
      if a2$ = "h" then
        load png "/Battleship/graphics/Carrier h 90 330x75.png", xh5, yh5
      else
        load png "/Battleship/graphics/Carrier v 90 75x330.png", xv5, yv5
      endif
      page write 0
      if a2$ = "h" then
        blit xh5, yh5, xh5, yh5, 366, 83, 1, &B100
      else
        blit xv5, yv5, xv5, yv5, 83, 366, 1, &B100
      endif
    case 4      
      page write 1
      if a2$ = "h" then 
        load png "/Battleship/graphics/Battleship h 90 260x69.png", xh4, yh4
      else
        load png "/Battleship/graphics/Battleship v 92 70x265.png", xv4, yv4
      endif
      page write 0
      if a2$ = "h" then
        blit xh4, yh4, xh4, yh4, 366, 83, 1, &B100
      else
        blit xv4, yv4, xv4, yv4, 83, 366, 1, &B100
      endif
    case 3
      page write 1
      if a2$ = "h" then
        load png "/Battleship/graphics/Cruiser h 90 196x67.png", xh3, yh3
      else
        load png "/Battleship/graphics/Cruiser v 92 69x200.png", xv3, yv3
      endif
      page write 0
      if a2$ = "h" then
        blit xh3, yh3, xh3, yh3, 366, 83, 1, &B100
      else
        blit xv3, yv3, xv3, yv3, 83, 366, 1, &B100
      endif
    case 2
      page write 1
      if a2$ = "h" then
        load png "/Battleship/graphics/Submarine h 90 198x64.png", xh2, yh2
      else
        load png "/Battleship/graphics/Submarine v 92 66x203.png", xv2, yv2
      endif
      page write 0
      if a2$ = "h" then
        blit xh2, yh2, xh2, yh2, 366, 83, 1, &B100
      else
        blit xv2, yv2, xv2, yv2, 83, 366, 1, &B100
      endif
    case 1
      page write 1
      if a2$ = "h" then
        load png "/Battleship/graphics/Destroyer h 90 140x65.png", xh1, yh1
      else
        load png "/Battleship/graphics/Destroyer v 90 65x140.png", xv1, yv1
      endif
      page write 0
      if a2$ = "h" then
        blit xh1, yh1, xh1, yh1, 366, 83, 1, &B100
      else
        blit xv1, yv1, xv1, yv1, 83, 366, 1, &B100
      endif
  end select
end sub

function num_to_letter(v) as string
  select case v
    case 1  : num_to_letter = "a"
    case 2  : num_to_letter = "b"
    case 3  : num_to_letter = "c"
    case 4  : num_to_letter = "d"
    case 5  : num_to_letter = "e"
    case 6  : num_to_letter = "f"
    case 7  : num_to_letter = "g"
    case 8  : num_to_letter = "h"
    case 9  : num_to_letter = "i"
    case 10 : num_to_letter = "j"
    case 11 : num_to_letter = "k"
    case 12 : num_to_letter = "l"
    case 13 : num_to_letter = "m"
    case 14 : num_to_letter = "n"
  end select
end function

function letter_to_num(v$) as integer
  select case v$
    case "a" : letter_to_num = 1
    case "b" : letter_to_num = 2
    case "c" : letter_to_num = 3
    case "d" : letter_to_num = 4
    case "e" : letter_to_num = 5
    case "f" : letter_to_num = 6
    case "g" : letter_to_num = 7
    case "h" : letter_to_num = 8
    case "i" : letter_to_num = 9
    case "j" : letter_to_num = 10
    case "k" : letter_to_num = 11
    case "l" : letter_to_num = 12
    case "m" : letter_to_num = 13
    case "n" : letter_to_num = 14
  end select
end function

function end_letter(v$, w) as string
  select case w
    case 1
      select case v$
        case "a" : end_letter = "b"
        case "b" : end_letter = "c"
        case "c" : end_letter = "d"
        case "d" : end_letter = "e"
        case "e" : end_letter = "f"
        case "f" : end_letter = "g"
        case "g" : end_letter = "h"
        case "h" : end_letter = "i"
        case "i" : end_letter = "j"
        case "j" : end_letter = "k"      
      end select
    case 2
      select case v$
        case "a" : end_letter = "c"
        case "b" : end_letter = "d"
        case "c" : end_letter = "e"
        case "d" : end_letter = "f"
        case "e" : end_letter = "g"
        case "f" : end_letter = "h"
        case "g" : end_letter = "i"
        case "h" : end_letter = "j"
        case "i" : end_letter = "k"
        case "j" : end_letter = "l"      
      end select
    case 3
      select case v$
        case "a" : end_letter = "d"
        case "b" : end_letter = "e"
        case "c" : end_letter = "f"
        case "d" : end_letter = "g"
        case "e" : end_letter = "h"
        case "f" : end_letter = "i"
        case "g" : end_letter = "j"
        case "h" : end_letter = "k"
        case "i" : end_letter = "l"
        case "j" : end_letter = "m"      
      end select
    case 4
      select case v$
        case "a" : end_letter = "e"
        case "b" : end_letter = "f"
        case "c" : end_letter = "g"
        case "d" : end_letter = "h"
        case "e" : end_letter = "i"
        case "f" : end_letter = "j"
        case "g" : end_letter = "k"
        case "h" : end_letter = "l"
        case "i" : end_letter = "m"
        case "j" : end_letter = "n"      
      end select
    end select
  end select
end function

function next_letter(v$) as string
  select case v$
    case "a" : next_letter = "b"
    case "b" : next_letter = "c"
    case "c" : next_letter = "d"
    case "d" : next_letter = "e"
    case "e" : next_letter = "f"
    case "f" : next_letter = "g"
    case "g" : next_letter = "h"
    case "h" : next_letter = "i"
    case "i" : next_letter = "j"
    case "j" : next_letter = "k"
    case "k" : next_letter = "l"
    case "l" : next_letter = "m"
    case "m" : next_letter = "n"
    case "n" : next_letter = "o"
  end select  
end function


