  ' program chebyshev_moon.bas      July 5, 2017
  
  ' this MMBASIC program demonstrates how
  ' to read a data file of Chebyshev coefficients
  ' and evaluate the position vector of the Moon
  
  ' MMX, RasPi and DOS version
  
  ''''''''''''''''''''''''''''
  
  option default float
  
  option base 1
  
  dim rmoon(3)
  
  ' global constants
  
  const pi2 = 2.0 * pi, pidiv2 = 0.5 * pi, dtr = pi / 180.0, rtd = 180.0 / pi
  
  '''''''''''''''''''''''''''''''''''''''''''''''
  ' open data file and read ephemeris information
  '''''''''''''''''''''''''''''''''''''''''''''''
  
  open "cheby_moon.txt" for input as #10
  
  input #10, nfit%, jdtdb1, jdtdb2
  
  dim rx_poly(nfit% + 1), ry_poly(nfit% + 1), rz_poly(nfit% + 1)
  
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' read coefficients for each position vector component
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  for i% = 1 to nfit% + 1
    
    input #10, rx_poly(i%), ry_poly(i%), rz_poly(i%)
    
  next i%
  
  ' close data file
  
  close #10
  
  ' compute beginning and end of valid time interval
  ' in Julian centuries wrt 1/1.5/2000 TDB
  
  ta = (jdtdb1 - 2451545.0) / 36525.0
  
  tb = (jdtdb2 - 2451545.0) / 36525.0
  
  ''''''''''''''''''''''''''''''''''''''''''
  ' evaluate Chebyshev ephemeris on 1/6/2017
  ''''''''''''''''''''''''''''''''''''''''''
  
  jdtdb = jdtdb1 + 5.0
  
  x = (jdtdb - 2451545.0) / 36525.0
  
  teval(ta, tb, nfit%, ry_poly(), x, rmoon(1))
  
  teval(ta, tb, nfit%, rx_poly(), x, rmoon(2))
  
  teval(ta, tb, nfit%, rz_poly(), x, rmoon(3))
  
  ' print position vector and magnitude
  
  print " "
  print "Moon position vector and magnitude"
  print "----------------------------------"
  print " "
  
  print "r_x  = ", str$(rmoon(1), 0, 8) + " kilometers"
  print " "
  print "r_y  = ", str$(rmoon(2), 0, 8) + " kilometers"
  print " "
  print "r_z  = ", str$(rmoon(3), 0, 8) + " kilometers"
  print " "
  print "rmag = ", str$(vecmag(rmoon()), 0, 8) + " kilometers"
  print " "
  
end
  
  '''''''''''''''''''''''''''''''
  '''''''''''''''''''''''''''''''
  
sub teval(fa, fb, n%, c(), x, tf)
  
  ' evaluate Chebyshev coefficients subroutine
  
  ' input
  
  '  fa  = beginning of evaluation interval
  '  fb  = end of evaluation interval
  '  n%  = order of approximation
  '  c() = array of Chebyshev coefficients
  '  x   = evaluation argument
  
  ' output
  
  '  tf = Chebyshev series evaluated at x
  
  '''''''''''''''''''''''''''''''''''''''
  
  local oldf1
  
  local f1 = 0.0, f2 = 0.0
  
  local xx = (2.0 * x - fa - fb) / (fb - fa)
  
  local xx2 = 2.0 * xx
  
  for i% = n% to 1 step -1
    
    oldf1 = f1
    
    f1 = xx2 * f1 - f2 + c(i% + 1)
    
    f2 = oldf1
    
  next i%
  
  tf = xx * f1 - f2 + 0.5 * c(1)
  
end sub
  
  ''''''''''''''''''
  ''''''''''''''''''
  
function vecmag(a())
  
  ' vector magnitude function
  
  ' input
  
  '  {a} = column vector (3 rows by 1 column)
  
  ' output
  
  '  vecmag = scalar magnitude of vector {a}
  
  ''''''''''''''''''''''''''''''''''''''''''
  
  vecmag = sqr(a(1) * a(1) + a(2) * a(2) + a(3) * a(3))
  
end function
  

