' Program "GALILEAN"                   September 23, 1989

' Copyright (C) 1986...1989 by David Eagle

' IBM-PC  << QuickBASIC compiler, version 4.5 >>

' Determines position of Jupiter's great satellites

'  x-position (positive west of Jupiter; units of Jupiter radii)
'  y-position (positive north of Jupiter; units of Jupiter radii)
'  position angle (relative to inferior junction with Jupiter; degrees)
'  Jupiter semi-diameter (units of arc seconds)
'  Julian Date

'********************************************************************

DEFDBL A-Z

' function and subroutine declarations

DECLARE FUNCTION MODULO (X)
DECLARE FUNCTION ASIN (X)
DECLARE SUB JULIAN ()

DECLARE SUB KEYCHECK ()
DECLARE SUB MAIN.DRIVER ()
DECLARE SUB SELECTION.MENU ()
DECLARE SUB GDATE (JD)
DECLARE SUB SAT.POSITIONS ()
DECLARE SUB DISPLAY.DATA ()
DECLARE SUB GRAPHICS ()
DECLARE SUB ELAPSED.DAYS ()

DIM SHARED MONTH$(12), SATELLITE$(4), R(4), X(4), Y(4), U(4)

COMMON SHARED JDATE0, JDATE, HOUR, MINUTE, MONTH, DAY, YEAR
COMMON SHARED DST%, ZONE%, EDAYS, SEMIDIAMETER
COMMON SHARED CDATE$, SELECTION%, GMODE%, LCT$, GFLAG%

' define utility constants

CONST PI = 3.141592653589793#
CONST PIDIV2 = .5# * PI
CONST PI2 = 2# * PI
CONST RTD = 180# / PI

' calendar months

MONTH$(1) = "January"
MONTH$(2) = "February"
MONTH$(3) = "March"
MONTH$(4) = "April"
MONTH$(5) = "May"
MONTH$(6) = "June"
MONTH$(7) = "July"
MONTH$(8) = "August"
MONTH$(9) = "September"
MONTH$(10) = "October"
MONTH$(11) = "November"
MONTH$(12) = "December"

' satellite names

SATELLITE$(1) = "Io"
SATELLITE$(2) = "Europa"
SATELLITE$(3) = "Ganymede"
SATELLITE$(4) = "Callisto"

GFLAG% = 0

'********************************************************************

CLS
LOCATE 5, 1
PRINT TAB(32); "Program Galilean"
LOCATE 7, 1
PRINT TAB(21); "Copyright (C) 1986...1989 by David Eagle"
LOCATE 11, 1
PRINT TAB(26); "Microsoft QuickBasic Compiler"
PRINT
PRINT TAB(20); "Copyright (C) Microsoft Corp. 1982...1988"
CALL KEYCHECK

DO
   DO
      CLS
      LOCATE 5, 1
      PRINT "Please input the calendar date"
      PRINT "( month [ 1 - 12 ], day [ 1 - 31 ], year [ YYYY ] )"
      PRINT "< For example, October 21, 1986 is input as 10,21,1986 >"
      INPUT MONTH, DAY, YEAR
   LOOP UNTIL (MONTH >= 1 AND MONTH <= 12) AND (DAY >= 1 AND DAY <= 31)

   DO
      PRINT
      PRINT
      PRINT "Please input the local civil time"
      PRINT "( hours [ 0 - 24 ], minutes [ 0 - 60 ] )"
      PRINT "< For example, 8:30 pm is input as 20,30 >"
      INPUT HOUR, MINUTE
   LOOP UNTIL (HOUR >= 0 AND HOUR <= 24) AND (MINUTE >= 0 AND MINUTE <= 60)

   DO
      PRINT
      PRINT
      PRINT "Please input the time zone ( 0 - 23 )"
      PRINT "< For example, Mountain Standard Time (MST) is time zone 7 >"
      INPUT ZONE%
   LOOP UNTIL ZONE% >= 0 AND ZONE% <= 23

   DO
      PRINT
      PRINT
      PRINT "Daylight Savings Time ( y = yes, n = no )"
      INPUT DST.FLAG$
      DST.FLAG$ = UCASE$(DST.FLAG$)
   LOOP UNTIL DST.FLAG$ = "Y" OR DST.FLAG$ = "N"

   IF DST.FLAG$ = "Y" THEN
      DST% = 1
   ELSE
      DST% = 0
   END IF

   ' compute initial Julian Date

   CALL JULIAN
  
   CALL MAIN.DRIVER

   DO
      CLS
      LOCATE 5, 1
      PRINT "Another selection ( y = yes, n = no )"
      INPUT SLCT$
      SLCT$ = UCASE$(SLCT$)
   LOOP UNTIL SLCT$ = "Y" OR SLCT$ = "N"

LOOP UNTIL SLCT$ = "N"

END

FUNCTION ASIN (X)

    ' Inverse sine function

    IF ABS(X) >= 1# THEN
       ASIN = SGN(X) * PIDIV2
    ELSE
       ASIN = ATN(X / SQR(1# - X * X))
    END IF

END FUNCTION

SUB DISPLAY.DATA STATIC

    ' Display data subroutine

    CLS
    PRINT
    PRINT TAB(32); "Program GALILEAN"
   
    PRINT
    PRINT TAB(10); "Calendar date"; TAB(65 - LEN(CDATE$)); CDATE$
   
    PRINT
    PRINT TAB(10); "Local civil time"; TAB(65 - LEN(LCT$)); LCT$
   
    PRINT
    PRINT TAB(10); "Julian Date";
    PRINT TAB(53);
    PRINT USING "########.###"; JDATE
   
    PRINT
    PRINT TAB(10); "Jupiter semidiameter ( arc seconds )";
    PRINT TAB(53);
    PRINT USING "########.###"; SEMIDIAMETER
   
    PRINT
    PRINT
    PRINT TAB(10); "Satellite       X-position       Y-position       Angle"
    PRINT TAB(10); "---------       ----------       ----------       -----"
   
    FOR I% = 1 TO 4
        A$ = STR$(INT(U(I%) * RTD))
        PRINT
        LOCATE , 10
        PRINT SATELLITE$(I%);
        LOCATE , 27
        PRINT USING "###.###"; X(I%);
        LOCATE , 44
        PRINT USING "###.###"; Y(I%);
        LOCATE , 64 - LEN(A$)
        PRINT A$
    NEXT I%

    CALL KEYCHECK

END SUB

SUB ELAPSED.DAYS STATIC

    ' Elapsed days subroutine

    GMT = HOUR + MINUTE / 60# - DST% + ZONE%
    A = (JDATE0 - 2415020#) / 36525#
   
    JD = JDATE0 + GMT / 24#
   
    JDATE = JD + (.41# + 1.2053# * A + .4992# * A ^ 2) / 1440#
   
    EDAYS = JDATE - 2415020#

END SUB

SUB GDATE (JD) STATIC

    ' Gregorian date subroutine

    IF JD < 2299161# THEN
       A = JD
    ELSE
       A = INT((JD - 1867216.25#) / 36524.25)
       A = JD + A - INT(A / 4) + 1#
    END IF
    B = A + 1524#
    C = INT((B - 122.1) / 365.25#)
    D = INT(365.25# * C)
    E = INT((B - D) / 30.6001#)
    DAY% = B - D - INT(30.6001# * E)
   
    IF E < 13.5 THEN
       MONTH% = E - 1
    ELSE
       MONTH% = E - 13
    END IF

    IF MONTH% > 2.5 THEN
       YEAR% = C - 4716#
    ELSE
       YEAR% = C - 4715#
    END IF

    CDATE$ = MONTH$(MONTH%) + STR$(DAY%) + "," + STR$(YEAR%)

END SUB

SUB GRAPHICS STATIC

    ' Graphics subroutine

    SELECT CASE GMODE%
    CASE 1
         SCREEN 2
         X0 = 315
         Y0 = 110
         DX1 = 7
         DX2 = 8
    CASE 2
         SCREEN 9
         X0 = 315
         Y0 = 170
         DX1 = 7
         DX2 = 8
    CASE 3
         SCREEN 3
         X0 = 355
         Y0 = 170
         DX1 = 8
         DX2 = 9
    END SELECT

    PRINT
    PRINT TAB(5); CDATE$;
    PRINT TAB(75 - LEN(LCT$)); LCT$
    PRINT TAB(38); "North"
   
    LOCATE 9, 1
    PRINT TAB(70); "West"
   
    A$ = "JUPITER"
    LOCATE 5, 1
    FOR J% = 1 TO 7
        PRINT TAB(40); MID$(A$, J%, 1)
    NEXT J%
   
    CIRCLE (X0, Y0), 10
    PAINT (X0, Y0)
   
    LOCATE 16, 1
   
    FOR I% = 1 TO 4
        X = X0 + 10 * X(I%)
        S$ = "^ " + SATELLITE$(I%)
        CIRCLE (X, Y0), 5
        PAINT (X, Y0)
        IF (X + LEN(S$)) > 550 THEN
           S$ = SATELLITE$(I%) + " ^"
           X = X - DX1 * LEN(S$)
        END IF
        PRINT TAB(X / DX2 + 1); S$
    NEXT I%

    CALL KEYCHECK

    SCREEN 0

END SUB

SUB JULIAN STATIC

    ' Julian Date subroutine

    ' Input

    '  MONTH = calendar month
    '  DAY   = calendar day
    '  YEAR  = calendar year

    ' Output

    '  JD  = Julian Date

    Y = YEAR
    M = MONTH
    B = 0#
    C = 0#

    IF M <= 2# THEN
       Y = Y - 1#
       M = M + 12#
    END IF

    IF Y < 0# THEN C = -.75#

    IF YEAR < 1582# THEN
       ' NULL
    ELSEIF YEAR > 1582# THEN
       A = FIX(Y / 100#)
       B = 2# - A + FIX(A / 4#)
    ELSEIF MONTH < 10# THEN
       ' NULL
    ELSEIF MONTH > 10# THEN
       A = FIX(Y / 100#)
       B = 2# - A + FIX(A / 4#)
    ELSEIF DAY <= 4# THEN
       ' NULL
    ELSEIF DAY > 14# THEN
       A = FIX(Y / 100#)
       B = 2# - A + FIX(A / 4#)
    ELSE
       CLS
       LOCATE 5, 26
       PRINT "This date does not exist!!"
       CALL KEYCHECK
    END IF

    JD = FIX(365.25# * Y + C) + FIX(30.6001# * (M + 1#))
    JDATE0 = JD + DAY + B + 1720994.5#

END SUB

SUB KEYCHECK STATIC

    ' Check user response subroutine

    LOCATE 25, 1
    PRINT TAB(25); "< press any key to continue >";

    A$ = ""

    WHILE A$ = ""
      A$ = INKEY$
    WEND

END SUB

SUB MAIN.DRIVER STATIC

    ' Main driver subroutine

    FIRSTPASS$ = "TRUE"
    SELECTION% = 0
   
    JDATE0 = JDATE0 - 1#
    LCT$ = STR$(HOUR) + " hours " + STR$(MINUTE) + " minutes"
   
    WHILE SELECTION% <> 4
      SELECTION% = 0
     
      WHILE SELECTION% <= 0 OR SELECTION% > 5
        CLS
        CALL SELECTION.MENU
      WEND
     
      IF SELECTION% = 3 OR FIRSTPASS$ = "TRUE" THEN
         JDATE0 = JDATE0 + 1#
         CALL GDATE(JDATE0 + .5#)
         CALL SAT.POSITIONS
      END IF

      IF SELECTION% = 1 THEN CALL DISPLAY.DATA
      IF SELECTION% = 2 THEN CALL GRAPHICS

      FIRSTPASS$ = "FALSE"
    WEND

END SUB

FUNCTION MODULO (X)

    ' Modulo 2 PI function

    A = X - PI2 * FIX(X / PI2)

    IF A < 0# THEN A = A + PI2

    MODULO = A

END FUNCTION

SUB SAT.POSITIONS STATIC

    ' Satellite positions subroutine

    CALL ELAPSED.DAYS
   
    V = MODULO(2.34974# + .0000194756# * EDAYS)
    M = MODULO(6.256586# + .01720197# * EDAYS)
    N = MODULO(3.93272126# + .0014501127# * EDAYS + .00576# * SIN(V))
    J = MODULO(3.8684699# + .015751909# * EDAYS - .00576# * SIN(V))
    O = MODULO(.0334405# * SIN(M) + .000349# * SIN(2# * M))
    P = MODULO(9.690070000000001D-02 * SIN(N) + .0029147# * SIN(2# * N))
    K = MODULO(J + O - P)
   
    R1 = 1.00014# - .01672# * COS(M) - .0014# * COS(2# * M)
    R2 = 5.20867# - .25192# * COS(N) - .0061# * COS(2# * N)
    D3 = SQR(R1 ^ 2 + R2 ^ 2 - 2# * R1 * R2 * COS(K))
    S4 = ASIN(.00047726615# / D3)
   
    SEMIDIAMETER = 206264.806# * S4
   
    S2 = R1 * SIN(K) / D3
    S3 = ASIN(S2)
    L1 = 4.154756# + .0014502# * EDAYS + .00576# * SIN(V) + P
    A = .05358# * SIN(L1 + .77667#)
    D4 = A - .03752# * S2 * COS(L1 + .4189#) - .02286# * ((R2 - D3) / D3) * SIN(L1 - 1.73486#)
    A = EDAYS - D3 / 173.1446#
   
    U(1) = MODULO(1.475686# + 3.550102027# * A + S3 - P)
    U(2) = MODULO(.724338# + 1.767872488# * A + S3 - P)
    U(3) = MODULO(1.9194607# + .876757718# * A + S3 - P)
    U(4) = MODULO(3.07803823# + .375036004# * A + S3 - P)
   
    G = MODULO(3.269# + .8780869100000001# * A)
    H = MODULO(5.4297# + .376454063# * A)
   
    R(1) = 5.9061# - .0244# * COS(2# * (U(1) - U(2)))
    R(2) = 9.3972# - 8.890000000000001D-02 * COS(2# * (U(2) - U(3)))
    R(3) = 14.9894# - .0227# * COS(G)
    R(4) = 26.3649# - .1944# * COS(H)
   
    U(1) = MODULO(U(1) + .0082296# * SIN(2# * (U(1) - U(2))))
    U(2) = MODULO(U(2) + .018727# * SIN(2# * (U(2) - U(3))))
    U(3) = MODULO(U(3) + .003037# * SIN(G))
    U(4) = MODULO(U(4) + .014748# * SIN(H))
   
    FOR I% = 1 TO 4
        X(I%) = R(I%) * SIN(U(I%))
        Y(I%) = -R(I%) * COS(U(I%)) * SIN(D4)
    NEXT I%

END SUB

SUB SELECTION.MENU STATIC

    ' Selection menu subroutine

    DO
       CLS
       LOCATE 5, 1
       PRINT TAB(25); "Galilean Menu"
       PRINT
       PRINT
       PRINT TAB(20); "< 1 > Display data"
       PRINT
       PRINT TAB(20); "< 2 > Display graphics"
       PRINT
       PRINT TAB(20); "< 3 > Continue to next day"
       PRINT
       PRINT TAB(20); "< 4 > End this session"
       PRINT
       PRINT
       PRINT "Selection ( 1, 2, 3 or 4 )"
       INPUT SELECTION%
    LOOP UNTIL SELECTION% >= 1 AND SELECTION% <= 4

    IF SELECTION% = 2 AND GFLAG% = 0 THEN
       DO
          CLS
          LOCATE 5, 1
          PRINT TAB(27); "Graphics Menu"
          PRINT
          PRINT
          PRINT TAB(20); "< 1 > CGA graphics mode"
          PRINT
          PRINT TAB(20); "< 2 > EGA graphics mode"
          PRINT
          PRINT TAB(20); "< 3 > Hercules graphics mode"
          PRINT
          PRINT
          PRINT "Selection ( 1, 2 or 3 )"
          INPUT GMODE%
       LOOP UNTIL GMODE% >= 1 AND GMODE% <= 3
       GFLAG% = 1
    END IF

END SUB

