' Space Invaders for the Colour Maximite v4.0
' Fabrice Muller
' 2012
' Copy audio effects modules to a:
'Modules names are :
'Laser1.mod
'Inv_Exp.mod
'
'Joystick connections are :
'Pin 2  = 10Kohm Potentiometer
'
'                Pin 2
'                  |
'                  |
'                /   \
' +3v3 ----------| o |---------- GND
'                \___/
'
'         10Kohm Potentiometer
'
'
'Pin 15 = Button connected to GND , 10Kohm pullup resistor to pin 15
'
'                                    __|__
'
'               10 Kohm              |   |
' +3v3 ---------/\/\/\/\-----|-------|   |-------- GND
'                            |
'                            |       Button
'                          Pin 15
'
Option base 1
Clear
'Set the Video Mode 4
' 240 x 216 pixels
Mode 4
Cls
'Load the Sprites/Fonts
Drive "b:"
Sprite Load "invader2.spr"
Font Load "col_inv.fnt" As #6
'Set some constants
NbLine = 5
NbCol = 8
'MaxSprite = 100
MaxSprite = 94
MinX = 0
MaxX = 110
MinY = 16
MaxY = 60
MaxType = 5
MaxShoot = 5
MaxEnnemyShoot = 5
CanonShootSpeed = -6
EnnemyShootSpeed = 2
OutsideX = -20
OutsideY = -20
'Set the Arrays
Dim SpriteLineCycle0(NbLine,NbCol)
Dim SpriteLineCycle1(NbLine,NbCol)
Dim ShowEnnemy(NbLine,NbCol)
Dim EnnemyType(MaxType)
Dim CanonShoot(MaxShoot)
Dim EnnemyShoot(MaxEnnemyShoot)
Dim MyShootCoord(MaxShoot,2)
Dim EnnemyShootCoord(MaxEnnemyShoot,2)
Dim OldMyShootCoord(MaxShoot,2)
Dim OldEnnemyShootCoord(MaxEnnemyShoot,2)
Dim MisteryCoord(2)
Dim EnnemyValue(NbLine)
'Set the Variables
EnnemyType(1) = 1
EnnemyType(2) = 17
EnnemyType(3) = 33
EnnemyType(4) = 49
EnnemyType(5) = 65
EnnemyValue(1) = 30
EnnemyValue(2) = 30
EnnemyValue(3) = 20
EnnemyValue(4) = 20
EnnemyValue(5) = 10
MisteryType = 81
MisteryValue = 100
CanonType = 83
CanonShootType = 85
EnnemyShootType = 90
ExplodeType = 95
EnnemyX = MinX
EnnemyY = MinY
LineStart = 1
LineEnd = NbLine
ColStart = 1
ColEnd = NbCol
EnnemyDirX = 2
EnnemyDirY = 2
MisteryX = 240
MisteryY = 0
EnnemyWide = 128
EnnemyHeight = 40
MisteryOn = 0
Explode = 0
NbEnnemy = NbLine * NbCol
Lives = 3
Score = 0
NewLevel = 0
Level = 1
'Joystick declaration
'Pin 2 as ADC input for a 10Kohm potentiometer
SetPin 2,1
'PIN 15 = Fire Button 1
SetPin 15,2
'
CanonPos = Pot_Read(2)
CanonY = 180
'Load the 1st bmp and wait for a key
LoadBMP "invaders.bmp",0,0
Do While (Inkey$ ="") And (Pin(15) = 1) : Loop
Pause 1000
Cls
'Load the Bunkers picture
LoadBMP "Bunker.bmp",0,150
LoadBMP "Bunker.bmp",60,150
LoadBMP "Bunker.bmp",120,150
LoadBMP "Bunker.bmp",180,150
'Set drive to "a:" for be able to
'use the Audio modules effects
Drive "a:"
'Initialise the Ennemy Lines to show
InitSpriteLine
Start_Sprites
SpriteFlip = 0
SpriteCycle = 0
Randomize Timer
'CycleTime is the game speed in mS
CycleTime = 200
CycleTimer = 0
'CycleShoot is how fast we can shoot
CycleShoot = 400
ShootTimer = 0
'Game Loop
Timer = 0
Do While 1
 If Pin(15) = 0 Then
  If (Timer - ShootTimer) >= CycleShoot Then
   ShootTimer = Timer
   New_Shoot
  EndIf
 EndIf
 If (Timer - CycleTimer) >= CycleTime Then
  CycleTimer = Timer
  'Randomize Ennemy Shoot
  If Int(Rnd * 100) > 90 Then New_Ennemy_Shoot
  'Random the Mistery ship apparition
  If (MisteryOn = 0) And (Int(Rnd * 1000) > 990) Then
   MisteryOn = 1
   MisteryCoord(1) = MisteryX
   MisteryCoord(2) = MisteryY
  EndIf
  Move_Sprites
  'Check if we have killed a Ennemy Ship
  Check_Ennemy_Dead
  'Check if we or the Ennemys Hit one of the Bunkers
  Hit_Bunker
  'Check if Ennemys kill us
  Check_Killed
  'Print the Score , Level and Lives
  Print @(0,205) "Score : ";Score;" Level : ";Level;" Lives : ";Lives;" "
  'Show the Sprites to new places
  Show_Sprites
 EndIf
 If NewLevel = 1 Then
  Make_New_Level
 EndIf
Loop

Sub Move_Sprites
 'Move all Sprites to new place
 Local a
 'Move Invaders
 EnnemyX = EnnemyX + EnnemyDirX
 If EnnemyX >= MaxX Then
  EnnemyDirX = -EnnemyDirX
  EnnemyY = EnnemyY + EnnemyDirY
  If EnnemyY > MaxY Then
   Game_Over
  EndIf
 EndIf
 If EnnemyX <= MinX Then
  EnnemyDirX = Abs(EnnemyDirX)
  EnnemyY = EnnemyY + EnnemyDirY
  If EnnemyY > MaxY Then
   Game_Over
  EndIf
 EndIf
 'Move Canon Shoots
 For a = 1 To MaxShoot
  If CanonShoot(a) = 1 Then
   OldMyShootCoord(a,2) = MyShootCoord(a,2) - 1
   MyShootCoord(a,2) = MyShootCoord(a,2) + CanonShootSpeed
   If MyShootCoord(a,2) < 1 Then CanonShoot(a) = 0
  EndIf
 Next a
 'Move Ennemy Shoots
 For a = 1 To MaxEnnemyShoot
  If EnnemyShoot(a) = 1 Then
   OldEnnemyShootCoord(a,2) = EnnemyShootCoord(a,2) - 1
   EnnemyShootCoord(a,2) = EnnemyShootCoord(a,2) + EnnemyShootSpeed
   If EnnemyShootCoord(a,2) > (CanonY + 5) Then EnnemyShoot(a) = 0
  EndIf
 Next a
 'Move my Canon
 CanonPos = Pot_Read(2)
 'Move Mistery Ship if needed
 If MisteryOn = 1 Then
  MisteryCoord(1) = MisteryCoord(1) - 4
  If MisteryCoord(1) < -16 Then MisteryOn = 0
 EndIf
End Sub

Sub Show_Sprites
 'Erase all Sprites then Show them to
 'the new places
 Local a,b
 Local x,y
 Font #6
 If SpriteFlip = 0 Then
  If SpriteCycle = 0 Then
   For a = MaxEnnemyShoot To 1 Step - 1
    If EnnemyShoot(a) = 1 Then
     Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
     Sprite Move EnnemyShootType + (a-1),EnnemyShootCoord(a,1),EnnemyShootCoord(a,2)
    Else
     Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
     Sprite Move EnnemyShootType + (a-1),OutsideX,OutsideY
     OldEnnemyShootCoord(a,1) = OutsideX
     OldEnnemyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   For a = MaxShoot To 1 Step - 1
    If CanonShoot(a) = 1 Then
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),MyShootCoord(a,1),MyShootCoord(a,2)
    Else
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),OutsideX,OutsideY
     OldMyShootCoord(a,1) = OutsideX
     OldMyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   Sprite Move (CanonType + 1),OutsideX,OutsideY
   Sprite Move CanonType,CanonPos,CanonY
   Line (CanonPos - 5,CanonY - 5)-(CanonPos - 1,CanonY + 20),0,bf
   Line (CanonPos + 16,CanonY - 5)-(CanonPos + 25,CanonY + 20),0,bf
   If MisteryOn = 1 Then
    Sprite Move MisteryType + 1,OutsideX,OutsideY
    Sprite Move MisteryType,MisteryCoord(1),MisteryCoord(2)
   Else
    Sprite Move MisteryType + 1,OutsideX,OutsideY
    Sprite Move MisteryType,OutsideX,OutsideY
   EndIf
   For a = NbLine To 1 Step - 1
    For b = NbCol To 1 Step - 1
     Sprite Move SpriteLineCycle1(a,b),OutsideX,OutsideY
     If ShowEnnemy(a,b) = 1 Then
      Sprite Move SpriteLineCycle0(a,b),EnnemyX + ((b-1) * 16),EnnemyY + ((a-1) * 16)
      x = EnnemyX + ((b - 1) * 16) + 15
      y = EnnemyY + ((a - 1) * 16)
      Line (x,y)-(x+3,y+19),0,bf
     Else
      Sprite Move SpriteLineCycle0(a,b),OutsideX,OutsideY
     EndIf
    Next b
   Next a
   Line (EnnemyX - 5,EnnemyY - 5)-(EnnemyX - 1, EnnemyY + 82),0,BF
   Line (EnnemyX + 128,EnnemyY - 5)-(EnnemyX + 135, EnnemyY + 82),0,BF
   SpriteCycle = 1
  Else
   For a = MaxEnnemyShoot To 1 Step - 1
    If EnnemyShoot(a) = 1 Then
     Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
     Sprite Move EnnemyShootType + (a-1),EnnemyShootCoord(a,1),EnnemyShootCoord(a,2)
    Else
     Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
     Sprite Move EnnemyShootType + (a-1),OutsideX,OutsideY
     OldEnnemyShootCoord(a,1) = OutsideX
     OldEnnemyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   For a = MaxShoot To 1 Step - 1
    If CanonShoot(a) = 1 Then
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),MyShootCoord(a,1),MyShootCoord(a,2)
    Else
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),OutsideX,OutsideY
     OldMyShootCoord(a,1) = OutsideX
     OldMyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   Sprite Move (CanonType + 1),OutsideX,OutsideY
   Sprite Move CanonType,CanonPos,CanonY
   Line (CanonPos - 5,CanonY - 5)-(CanonPos - 1,CanonY + 20),0,bf
   Line (CanonPos + 16,CanonY - 5)-(CanonPos + 25,CanonY + 20),0,bf
   If MisteryOn = 1 Then
    Sprite Move MisteryType + 1,MisteryCoord(1),MisteryCoord(2)
    Sprite Move MisteryType,OutsideX,OutsideY
   Else
    Sprite Move MisteryType + 1,OutsideX,OutsideY
    Sprite Move MisteryType,OutsideX,OutsideY
   EndIf
   For a = NbLine To 1 Step - 1
    For b = NbCol To 1 Step - 1
     Sprite Move SpriteLineCycle0(a,b),OutsideX,OutsideY
     If ShowEnnemy(a,b) = 1 Then
      Sprite Move SpriteLineCycle1(a,b),EnnemyX + ((b-1) * 16),EnnemyY + ((a-1) * 16)
      x = EnnemyX + ((b - 1) * 16) + 15
      y = EnnemyY + ((a - 1) * 16)
      Line (x,y)-(x+3,y+19),0,bf
     Else
      Sprite Move SpriteLineCycle1(a,b),OutsideX,OutsideY
     EndIf
    Next b
   Next a
   Line (EnnemyX - 5,EnnemyY - 5)-(EnnemyX - 1, EnnemyY + 82),0,BF
   Line (EnnemyX + 128,EnnemyY - 5)-(EnnemyX + 135, EnnemyY + 82),0,BF
   SpriteCycle = 0
  EndIf
  SpriteFlip = 1
 Else
  If SpriteCycle = 0 Then
   For a = 1 To NbLine
    For b = 1 To NbCol
     Sprite Move SpriteLineCycle1(a,b),OutsideX,OutsideY
     If ShowEnnemy(a,b) = 1 Then
      Sprite Move SpriteLineCycle0(a,b),EnnemyX + ((b-1) * 16),EnnemyY + ((a-1) * 16)
      x = EnnemyX + ((b - 1) * 16) + 15
      y = EnnemyY + ((a - 1) * 16)
      Line (x,y)-(x+3,y+19),0,bf
     Else
      Sprite Move SpriteLineCycle0(a,b),OutsideX,OutsideY
     EndIf
    Next b
   Next a
   Line (EnnemyX - 5,EnnemyY - 5)-(EnnemyX - 1, EnnemyY + 82),0,BF
   Line (EnnemyX + 128,EnnemyY - 5)-(EnnemyX + 135, EnnemyY + 82),0,BF
   If MisteryOn = 1 Then
    Sprite Move MisteryType,MisteryCoord(1),MisteryCoord(2)
    Sprite Move MisteryType + 1,OutsideX,OutsideY
   Else
    Sprite Move MisteryType,OutsideX,OutsideY
    Sprite Move MisteryType + 1,OutsideX,OutsideY
   EndIf
   Sprite Move CanonType,OutsideX,OutsideY
   Sprite Move (CanonType + 1),CanonPos,CanonY
   Line (CanonPos - 5,CanonY - 5)-(CanonPos - 1,CanonY + 20),0,bf
   Line (CanonPos + 16,CanonY - 5)-(CanonPos + 25,CanonY + 20),0,bf
   For a = 1 To MaxShoot
    If CanonShoot(a) = 1 Then
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),MyShootCoord(a,1),MyShootCoord(a,2)
    Else
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),OutsideX,OutsideY
     OldMyShootCoord(a,1) = OutsideX
     OldMyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   For a = 1 To MaxEnnemyShoot
    If EnnemyShoot(a) = 1 Then
     Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
     Sprite Move EnnemyShootType + (a-1),EnnemyShootCoord(a,1),EnnemyShootCoord(a,2)
    Else
      Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
    Sprite Move EnnemyShootType + (a-1),OutsideX,OutsideY
     OldEnnemyShootCoord(a,1) = OutsideX
     OldEnnemyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   SpriteCycle = 1
  Else
   For a = 1 To NbLine
    For b = 1 To NbCol
     Sprite Move SpriteLineCycle0(a,b),OutsideX,OutsideY
     If ShowEnnemy(a,b) = 1 Then
      Sprite Move SpriteLineCycle1(a,b),EnnemyX + ((b-1) * 16),EnnemyY + ((a-1) * 16)
      x = EnnemyX + ((b - 1) * 16) + 15
      y = EnnemyY + ((a - 1) * 16)
      Line (x,y)-(x+3,y+19),0,bf
     Else
      Sprite Move SpriteLineCycle1(a,b),OutsideX,OutsideY
     EndIf
    Next b
   Next a
   Line (EnnemyX - 5,EnnemyY - 5)-(EnnemyX - 1, EnnemyY + 82),0,BF
   Line (EnnemyX + 128,EnnemyY - 5)-(EnnemyX + 135, EnnemyY + 82),0,BF
   If MisteryOn = 1 Then
    Sprite Move MisteryType,OutsideX,OutsideY
    Sprite Move MisteryType + 1,MisteryCoord(1),MisteryCoord(2)
   Else
    Sprite Move MisteryType,OutsideX,OutsideY
    Sprite Move MisteryType + 1,OutsideX,OutsideY
   EndIf
   Sprite Move CanonType,OutsideX,OutsideY
   Line (CanonPos - 5,CanonY - 5)-(CanonPos - 1,CanonY + 20),0,bf
   Line (CanonPos + 16,CanonY - 5)-(CanonPos + 25,CanonY + 20),0,bf
   Sprite Move (CanonType + 1),CanonPos,CanonY
   For a = 1 To MaxShoot
    If CanonShoot(a) = 1 Then
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),MyShootCoord(a,1),MyShootCoord(a,2)
    Else
     Print @(OldMyShootCoord(a,1),OldMyShootCoord(a,2)) "a"
     Sprite Move CanonShootType + (a-1),OutsideX,OutsideY
     OldMyShootCoord(a,1) = OutsideX
     OldMyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   For a = 1 To MaxEnnemyShoot
    If EnnemyShoot(a) = 1 Then
     Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
     Sprite Move EnnemyShootType + (a-1),EnnemyShootCoord(a,1),EnnemyShootCoord(a,2)
    Else
     Print @(OldEnnemyShootCoord(a,1),OldEnnemyShootCoord(a,2)) "a"
     Sprite Move EnnemyShootType + (a-1),OutsideX,OutsideY
     OldEnnemyShootCoord(a,1) = OutsideX
     OldEnnemyShootCoord(a,2) = OutsideY
    EndIf
   Next a
   SpriteCycle = 0
  EndIf
  SpriteFlip = 0
 EndIf
 Font #1
End Sub

Sub Make_New_Level
 'Create a new Level
 Local a
 InitSpriteLine
 'Disable all Shoots
 For a = 1 To MaxShoot
  CanonShoot(a) = 0
  OldEnnemyShootCoord(a,1) = OutsideX
  OldEnnemyShootCoord(a,2) = OutsideY
 Next a
 For a = 1 To MaxEnnemyShoot
  EnnemyShoot(a) = 0
  OldMyShootCoord(a,1) = OutsideX
  OldMyShootCoord(a,2) = OutsideY
 Next a
 'Move all Sprites outside the screen
 For a = 1 To MaxSprite
  Sprite Move a,OutsideX,OutsideY
 Next a
 'Clear the screen
 Cls
 'Load the Bunkers picture
 Drive "b:"
 LoadBMP "Bunker.bmp",0,150
 LoadBMP "Bunker.bmp",60,150
 LoadBMP "Bunker.bmp",120,150
 LoadBMP "Bunker.bmp",180,150
 Drive "a:"
 LineStart = 1
 LineEnd = NbLine
 ColStart = 1
 ColEnd = NbCol
 MinX = 0
 MaxX = 110
 MinY = 16
 MaxY = 60
 EnnemyX = MinX
 EnnemyY = MinY
 CycleTime = CycleTime - 10
 If CycleTime < 30 Then CycleTime = 30
 MisteryX = 240
 MisteryY = 0
 MisteryOn = 0
 Explode = 0
 NbEnnemy = NbLine * NbCol
 NewLevel = 0
 Lives = Lives + 1
End Sub

Sub InitSpriteLine
 'Create Sprites Lines datas
 Local a,b
 For a = 1 To NbLine
  For b = 1 To NbCol
   SpriteLineCycle0(a,b) = EnnemyType(a) + ((b-1) * 2)
   SpriteLineCycle1(a,b) = EnnemyType(a) + ((b-1) * 2) + 1
   ShowEnnemy(a,b) = 1
  Next b
 Next a
End Sub

Sub Start_Sprites
 'Show all Sprites out of screen
 Local a
 For a = 1 To MaxSprite
  Sprite On a,OutsideX,OutsideY
 Next a
End Sub

Sub New_Shoot
 'Shoot a new bullet if possible
 Local a
 For a = 1 To MaxShoot
  If CanonShoot(a) = 0 Then
   'Create a new Shoot
   MyShootCoord(a,1) = CanonPos + 6
   MyShootCoord(a,2) = CanonY - 4
   CanonShoot(a) = 1
   OldMyShootCoord(a,1) = MyShootCoord(a,1) - 1
   PlayMOD "Laser1.mod" , 2000
   Exit Sub
  EndIf
 Next a
End Sub

Sub New_Ennemy_Shoot
 'Look if ennmy can made a new Shoot
 Local a
 For a = 1 To MaxEnnemyShoot
  If EnnemyShoot(a) = 0 Then
   'Create a new Shoot
   EnnemyShootCoord(a,1) = EnnemyX + Int(Rnd * ((ColEnd - ColStart + 1) * 16))
   EnnemyShootCoord(a,2) = EnnemyY + ((LineEnd - LineStart + 1) * 16) + 1
   EnnemyShoot(a) = 1
   OldEnnemyShootCoord(a,1) = EnnemyShootCoord(a,1) - 1
   Exit Sub
  EndIf
 Next a
End Sub

Sub Check_Ennemy_Dead
 'Check if we killed a Ennemy Ship
 Local a,b,c,cl,l
 Local x1,x2,y1,y2,xs,ys
 Local sprc,sprl
 sprc = 0
 sprl = 0
 For a = 1 To MaxShoot
  If CanonShoot(a) = 1 Then
   xs = MyShootCoord(a,1)
   ys = MyShootCoord(a,2)
   'Test if we kill the Mistery Ship if Present
   If MisteryOn = 1 Then
    x1 = MisteryCoord(1) : x2 = MisteryCoord(1) + 16
    y1 = MisteryCoord(2) : y2 = MisteryCoord(2) + 16
    If (ys >= y1) And (ys <= y2) Then
     If (xs >= x1) And (xs <= x2) Then
      'We have kill the mistery ship
      MisteryOn = 0
      Line (x1,y1)-(x2,y2),0,bf
      PlayMOD "Inv_Exp.mod" , 2000
      CanonShoot(a) = 0
      Score = Score + MisteryValue + ((Int(Rnd * 10) + 1) * 10)
     EndIf
    EndIf
   EndIf
   'Test if we kill one of the Invaders
   If (ys > EnnemyY) And (ys < (EnnemyY + 80)) Then
    For b = LineStart To LineEnd
     For c = ColStart To ColEnd
      If ShowEnnemy(b,c) = 1 Then
       x1 = EnnemyX + ((c - 1) * 16) : x2 = EnnemyX + (c * 16)
       y1 = EnnemyY + ((b - 1) * 16) : y2 = EnnemyY + (b * 16)
       If (xs >= x1) And (xs <= x2) Then
        If (ys >= y1) And (ys <= y2) Then
         ShowEnnemy(b,c) = 0
         Score = Score + EnnemyValue(b)
         CanonShoot(a) = 0
         NbEnnemy = NbEnnemy - 1
         PlayMOD "Inv_Exp.mod" , 2000
         If (NbEnnemy = 0) Then
          'We killed all Ennemy
          'We have to start a new level
          Level = Level + 1
          NewLevel = 1
         Else
          'Check if we can reduce the
          'Ennemy Line and Cols number
          'Checking 1st Line first
          l = LineStart
          For cl = ColStart To ColEnd
           If ShowEnnemy(l,cl) = 1 Then
            sprl = sprl + 1
            Exit For
           EndIf
          Next cl
          If sprl = 0 Then
           'we can cut the 1st line
           LineStart = LineStart + 1
          EndIf
          sprl = 0
          'Checking Last Line
          l = LineEnd
          For cl = ColStart To ColEnd
           If ShowEnnemy(l,cl) = 1 Then
            sprl = sprl + 1
            Exit For
           EndIf
          Next cl
          If sprl = 0 Then
           'we can cut the last line
           LineEnd = LineEnd - 1
           'we can also increment the MaxY
           MaxY = MaxY + 16
          EndIf
          'Now we check the 1st column
          cl = ColStart
          For l = LineStart To LineEnd
           If ShowEnnemy(l,cl) = 1 Then
            sprc = sprc + 1
            Exit For
           EndIf
          Next l
          If sprc = 0 Then
           'we can cut the 1st column
           ColStart = Colstart + 1
           'and decrement the MinX variable
           MinX = MinX - 16
          EndIf
          sprc = 0
          'Finaly we check the last column
          cl = ColEnd
          For l = LineStart To LineEnd
           If ShowEnnemy(l,cl) = 1 Then
            sprc = sprc + 1
            Exit For
           EndIf
          Next l
          If sprc = 0 Then
           'we can cut the last column
           ColEnd = ColEnd - 1
           'and increment the ManX variable
           MaxX = MaxX + 16
          EndIf
         EndIf
         Exit Sub
        EndIf
       EndIf
      EndIf
     Next c
    Next b
   EndIf
  EndIf
 Next a
End Sub

Sub Check_Killed
 'Check if the Ennemys kill us
 Local a,b
 Local x1,y1,x2,y2
 Local xs,ys
 x1 = CanonPos
 x2 = CanonPos + 13
 y1 = CanonY - 4
 y2 = CanonY + 10
 For a = 1 To MaxEnnemyShoot
  xs = EnnemyShootCoord(a,1)
  ys = EnnemyShootCoord(a,2)
  If (ys >= y1) And (ys <= y2) And (EnnemyShoot(a) = 1) Then
   If (xs >= x1) And (xs <= x2) Then
    'Ennemy kill one of my Canon !
    'Remove this Shoot
    EnnemyShoot(a) = 0
    'Destroy the Canon
    PlayMOD "Inv_Exp.mod" , 2000
    Sprite Move (CanonType + 1),OutsideX,OutsideY
    Sprite Move CanonType,OutsideX,OutsideY
    Line (CanonPos,CanonY) - (CanonPos + 16,CanonY + 16) , 0 , BF
    For b = ExplodeType To ExplodeType + 4
     Sprite On b,CanonPos,CanonY
     Pause 200
     Sprite Off b
    Next b
    Lives = Lives - 1
    If Lives = 0 Then
     'We loose the Game
     Game_Over
    EndIf
    Exit Sub
   EndIf
  EndIf
 Next a
End Sub

Sub Hit_Bunker
 'Check if we or the Ennemy's Hit one
 'of the Bunkers
 Local a,b,c
 Local x1,y1,x2,y2
 Local xs,ys
 Local p1,p2,p3
 y1 = 150
 y2 = 170
 For a = 1 To MaxShoot
  xs = MyShootCoord(a,1) + 1
  ys = MyShootCoord(a,2) - 1
  For b = 1 To 4
   x1 = ((b-1) * 60) + 18
   x2 = ((b-1) * 60) + 42
   If (xs >= x1) And (xs <= x2) Then
    If (ys >= y1) And (ys <= y2) Then
     'We are in a bunker region
     'Test if a pixel is present
     p1 = Pixel(xs - 1 , ys)
     p2 = Pixel(xs , ys)
     p3 = Pixel(xs + 1 , ys)
     If (p1 <> 0) Or (p2 <> 0) Or (p3 <> 0) Then
      'Remove this Shoot
      CanonShoot(a) = 0
      'Destroy a Part of the Bunker
      PlayMOD "Inv_Exp.mod" , 2000
      For c = 1 To 5
       x1 = xs + (Rnd * 3) - 2
       y1 = ys + (Rnd * 3) - 2
       Line (x1 , y1)-(x1 + 2,y1 + 2),0,BF
      Next c
      Exit For
     EndIf
    EndIf
   EndIf
  Next b
 Next a
 For a = 1 To MaxEnnemyShoot
  xs = EnnemyShootCoord(a,1) + 1
  ys = EnnemyShootCoord(a,2) + 7
  For b = 1 To 4
   x1 = ((b-1) * 60) + 18
   x2 = ((b-1) * 60) + 42
   If (xs >= x1) And (xs <= x2) Then
    If (ys >= y1) And (ys <= y2) Then
     'We are in a bunker region
     'Test if a pixel is present
     p1 = Pixel(xs - 1 , ys)
     p2 = Pixel(xs , ys)
     p3 = Pixel(xs + 1 , ys)
     If (p1 <> 0) Or (p2 <> 0) Or (p3 <> 0) Then
      'Remove this Shoot
      EnnemyShoot(a) = 0
      'Destroy a Part of the Bunker
      PlayMOD "Inv_Exp.mod" , 2000
      For c = 1 To 5
       x1 = xs + (Rnd * 3) - 2
       y1 = ys + (Rnd * 3) - 2
       Line (x1 , y1)-(x1 + 2,y1 + 2),0,BF
      Next c
      Exit For
     EndIf
    EndIf
   EndIf
  Next b
 Next a
End Sub

Sub Game_Over
 'We loose the Game
 Clear
 Cls
 'Load the 1st bmp and wait for 5sec
 'before restart the game
 Drive "b:"
 LoadBMP "Loose.bmp",0,0
 Pause 5000
 Run
End Sub

Function Pot_Read(ADC_Pin)
 'Read the potentiometer value for place
 'the X coordinate from the Ship
 'ADC_Pin is the pin number we have define for ADC input
 Local CalcPot , tmppos
 CalcPot = 3 / MM.HRes
 tmppos = Int((Pin(ADC_Pin) -0.1) / CalcPot)
 If tmppos > (MM.HRes - 17) Then tmppos = MM.HRes - 17
 Pot_Read = tmppos
End Function

