// Define to prevent recursive inclusion -------------------------------------//
#ifndef __GFX_H
#define __GFX_H

#ifdef __cplusplus
 extern "C" {
#endif 

// Includes ------------------------------------------------------------------//
#include "stm32f4xx.h"
#include "stm32f429i_discovery.h"
#include "stm32f429i_discovery_sdram.h"
#include "fmc_sram.h"
#include "fonts.h"
#include "Delay_Timer.h"
#include "stm32f429_Disco_fatfs.h"
#include <stdlib.h>
#include <stdio.h>

// GFX Defines

// Uncomment the Screen type you want use
// Only one can be selected !

// VGA Display Width , Height , Refresh rate //
//#define		USE_240x320_60
//#define		USE_320x240_60
//#define		USE_320x240_60_DOUBLE
//#define		USE_640x350_70
//#define		USE_640x400_70
#define		USE_640x480_60

#ifdef USE_240x320_60
	#define  GFX_PIXEL_WIDTH    ((uint16_t)240)
	#define  GFX_PIXEL_HEIGHT   ((uint16_t)320)
	#define  GFX_MAX_X			    ((uint16_t)239)
	#define  GFX_MAX_Y				  ((uint16_t)319)
	#define  CenterX						((uint16_t)120)
	#define  CenterY						((uint16_t)160)
#endif

#ifdef USE_320x240_60
	#define  GFX_PIXEL_WIDTH    ((uint16_t)320)
	#define  GFX_PIXEL_HEIGHT   ((uint16_t)240)
	#define  GFX_MAX_X			    ((uint16_t)319)
	#define  GFX_MAX_Y				  ((uint16_t)239)
	#define  CenterX						((uint16_t)160)
	#define  CenterY						((uint16_t)120)
#endif

#ifdef USE_320x240_60_DOUBLE
	#define  GFX_PIXEL_WIDTH    ((uint16_t)640)
	#define  GFX_PIXEL_HEIGHT   ((uint16_t)480)
	#define  GFX_MAX_X			    ((uint16_t)319)
	#define  GFX_MAX_Y				  ((uint16_t)239)
	#define  CenterX						((uint16_t)160)
	#define  CenterY						((uint16_t)120)
#endif

#ifdef USE_640x480_60
	#define  GFX_PIXEL_WIDTH    ((uint16_t)640)
	#define  GFX_PIXEL_HEIGHT   ((uint16_t)480)
	#define  GFX_MAX_X			    ((uint16_t)639)
	#define  GFX_MAX_Y				  ((uint16_t)479)
	#define  CenterX						((uint16_t)320)
	#define  CenterY						((uint16_t)240)
#endif

#ifdef USE_640x350_70
	#define  GFX_PIXEL_WIDTH    ((uint16_t)640)
	#define  GFX_PIXEL_HEIGHT   ((uint16_t)350)
	#define  GFX_MAX_X			    ((uint16_t)639)
	#define  GFX_MAX_Y				  ((uint16_t)349)
	#define  CenterX						((uint16_t)320)
	#define  CenterY						((uint16_t)175)
#endif

#ifdef USE_640x400_70
	#define  GFX_PIXEL_WIDTH    ((uint16_t)640)
	#define  GFX_PIXEL_HEIGHT   ((uint16_t)400)
	#define  GFX_MAX_X			    ((uint16_t)639)
	#define  GFX_MAX_Y				  ((uint16_t)399)
	#define  CenterX						((uint16_t)320)
	#define  CenterY						((uint16_t)200)
#endif

// VGA Parameter common to all resolution made with
// the standard 640x480 at 60Hz base.
// 25.175Mhz base (here is 25.187 Mhz)
#if defined USE_240x320_60 || defined USE_320x240_60 || defined USE_320x240_60_DOUBLE || defined USE_640x480_60
	#define GFX_H_Front_Porch					((uint16_t)8)		//pixels
	#define GFX_H_Sync								((uint16_t)96)	//pixels
	#define GFX_H_Back_Porch					((uint16_t)40)	//pixels
	#define GFX_V_Front_Porch					((uint16_t)2)		//lines
	#define GFX_V_Sync								((uint16_t)2)		//lines
	#define GFX_V_Back_Porch					((uint16_t)25)	//lines
	#define GFX_Total_line_length			((uint16_t)800)	//pixels
	#define GFX_Total_Height					((uint16_t)525)	//lines
	#define Freq_PLLSAI_VCO						((uint16_t)403)	//Mhz
	#define Freq_PLLSAI_R							((uint16_t)2)		//Div 2 (403/2 = 201.5 Mhz)
	#define Freq_PLLSAIDivR						((uint16_t)7)		//Div 8	(201.5/8 = 25.187 Mhz) do -1 from divider
	#define HSync_Level								((uint16_t)0)		//Low
	#define VSync_Level								((uint16_t)0)		//Low
#endif

#ifdef USE_240x320_60
	#define GFX_H_Left_Border					((uint16_t)208)	//pixels
	#define GFX_H_Video_Line					((uint16_t)240)	//pixels
	#define GFX_H_Right_Border				((uint16_t)208)	//pixels
	#define GFX_V_Top_Border					((uint16_t)88)	//lines
	#define GFX_V_Video_Height				((uint16_t)320)	//lines
	#define GFX_V_Bottom_Border				((uint16_t)88)	//lines
#endif

#ifdef USE_320x240_60
	#define GFX_H_Left_Border					((uint16_t)168)	//pixels
	#define GFX_H_Video_Line					((uint16_t)320)	//pixels
	#define GFX_H_Right_Border				((uint16_t)168)	//pixels
	#define GFX_V_Top_Border					((uint16_t)128)	//lines
	#define GFX_V_Video_Height				((uint16_t)240)	//lines
	#define GFX_V_Bottom_Border				((uint16_t)128)	//lines
#endif

#ifdef USE_320x240_60_DOUBLE
	#define GFX_H_Left_Border					((uint16_t)8)		//pixels
	#define GFX_H_Video_Line					((uint16_t)640)	//pixels
	#define GFX_H_Right_Border				((uint16_t)8)		//pixels
	#define GFX_V_Top_Border					((uint16_t)8)		//lines
	#define GFX_V_Video_Height				((uint16_t)480)	//lines
	#define GFX_V_Bottom_Border				((uint16_t)8)		//lines
#endif

#ifdef USE_640x480_60
	#define GFX_H_Left_Border					((uint16_t)8)		//pixels
	#define GFX_H_Video_Line					((uint16_t)640)	//pixels
	#define GFX_H_Right_Border				((uint16_t)8)		//pixels
	#define GFX_V_Top_Border					((uint16_t)8)		//lines
	#define GFX_V_Video_Height				((uint16_t)480)	//lines
	#define GFX_V_Bottom_Border				((uint16_t)8)		//lines
#endif

#ifdef USE_640x350_70 //25.175 Mhz
	#define GFX_H_Left_Border					((uint16_t)0)		//pixels
	#define GFX_H_Video_Line					((uint16_t)640)	//pixels
	#define GFX_H_Right_Border				((uint16_t)0)		//pixels
	#define GFX_V_Top_Border					((uint16_t)0)		//lines
	#define GFX_V_Video_Height				((uint16_t)350)	//lines
	#define GFX_V_Bottom_Border				((uint16_t)0)		//lines
	#define GFX_H_Front_Porch					((uint16_t)16)	//pixels
	#define GFX_H_Sync								((uint16_t)96)	//pixels
	#define GFX_H_Back_Porch					((uint16_t)48)	//pixels
	#define GFX_V_Front_Porch					((uint16_t)37)	//lines
	#define GFX_V_Sync								((uint16_t)2)		//lines
	#define GFX_V_Back_Porch					((uint16_t)60)	//lines
	#define GFX_Total_line_length			((uint16_t)800)	//pixels
	#define GFX_Total_Height					((uint16_t)449)	//lines
	#define Freq_PLLSAI_VCO						((uint16_t)403)	//Mhz
	#define Freq_PLLSAI_R							((uint16_t)2)		//Div 2 (403/2 = 201.5 Mhz)
	#define Freq_PLLSAIDivR						((uint16_t)7)		//Div 8	(201.5/8 = 25.187 Mhz) do -1 from divider
	#define HSync_Level								((uint16_t)1)		//High
	#define VSync_Level								((uint16_t)0)		//Low
#endif

#ifdef USE_640x400_70 //25.175 Mhz
	#define GFX_H_Left_Border					((uint16_t)0)		//pixels
	#define GFX_H_Video_Line					((uint16_t)640)	//pixels
	#define GFX_H_Right_Border				((uint16_t)0)		//pixels
	#define GFX_V_Top_Border					((uint16_t)0)		//lines
	#define GFX_V_Video_Height				((uint16_t)400)	//lines
	#define GFX_V_Bottom_Border				((uint16_t)0)		//lines
	#define GFX_H_Front_Porch					((uint16_t)16)	//pixels
	#define GFX_H_Sync								((uint16_t)96)	//pixels
	#define GFX_H_Back_Porch					((uint16_t)48)	//pixels
	#define GFX_V_Front_Porch					((uint16_t)12)	//lines
	#define GFX_V_Sync								((uint16_t)2)		//lines
	#define GFX_V_Back_Porch					((uint16_t)35)	//lines
	#define GFX_Total_line_length			((uint16_t)800)	//pixels
	#define GFX_Total_Height					((uint16_t)449)	//lines
	#define Freq_PLLSAI_VCO						((uint16_t)403)	//Mhz
	#define Freq_PLLSAI_R							((uint16_t)2)		//Div 2 (403/2 = 201.5 Mhz)
	#define Freq_PLLSAIDivR						((uint16_t)7)		//Div 8	(201.5/8 = 25.187 Mhz) do -1 from divider
	#define HSync_Level								((uint16_t)0)		//Low
	#define VSync_Level								((uint16_t)1)		//High
#endif

// Max number of Sprite to show
#define NbSpriteShow								499

typedef struct 
{
  int16_t X;
  int16_t Y;
} Point, * pPoint;   

// Triangle structure
typedef struct {
	float ax;						
	float ay;						
	float bx;						
	float by;						
	float cx;						
	float cy;						
} TriPoint;							

// Rectangle  /Line Clipping structure
typedef struct {
	uint16_t x1;						
	uint16_t y1;						
	uint16_t x2;						
	uint16_t y2;
	uint16_t 	w;
	uint16_t  h;
} ClipScreen;							

// Map Clipping structure
typedef struct {
	uint16_t Src_x1;						
	uint16_t Src_y1;						
	uint16_t Dest_x1;						
	uint16_t Dest_y1;						
	uint16_t Dest_x2;						
	uint16_t Dest_y2;
	uint16_t Dest_w;
	uint16_t Dest_h;
} ClipMapScreen;							

// Sprite structure
typedef struct {
	int16_t SprNum;				// Sprite number (0 to 499)
	int16_t x;						// X Coordinate on screen
	int16_t y;						// Y Coordinate on screen
	uint16_t show;				// 0 = Show the transparent color , other = Don't show the transparent color
	uint16_t transpcol;	  // Value from the transparent color
}sprinfo;							

// Globale Variables
extern uint16_t  Map_Width;
extern uint16_t  Map_Height;
extern sprinfo 	 SpriteShow[];
//extern sprinfo 	 *SpriteShow[];
// Video Buffers as pointer array
extern uint16_t *VideoBuff;
extern uint16_t *VideoBuffExt;
// Sprites and Map Buffer as pointer array
extern uint16_t *SpriteMemory;
extern uint16_t *MapMemory;
// Layer and color used (For compatibility
extern uint16_t CurrentTextColor;
extern uint16_t CurrentBackColor;
/* Default LCD configuration with LCD Layer 1 */
extern uint32_t CurrentFrameBuffer;
extern uint32_t CurrentLayer;


// GFX Exported Constants

// Start of Video Memory buffer in SDRAM
#define GFX_FRAME_BUFFER       SDRAM_BANK2_ADDR	//0xD0000000) st429 Disco SDRAM
#define GFX_EXT_FRAME_BUFFER   SDRAM_BANK1_ADDR	//0xC0000000) Expansion Board SDRAM
// Offset for 240 x 320 with 2 bytes/pixels (153.600 bytes)
// Offset for 320 x 240 with 2 bytes/pixels (153.600 bytes)
// Offset for 320 x 240 Double with 2 bytes/pixels (614.400 bytes)
// Offset for 640 x 350 with 2 bytes/pixels (448.000 bytes)
// Offset for 640 x 400 with 2 bytes/pixels (512.000 bytes)
// Offset for 640 x 480 with 2 bytes/pixels (614.400 bytes)
#define BUFFER_OFFSET						((uint32_t)(GFX_H_Video_Line * GFX_V_Video_Height * 2))
//#define BUFFER_OFFSET						((uint32_t)(GFX_H_Video_Line * (GFX_V_Video_Height * 2) * 2))

// Number of pixel for one Buffer
#define PIXEL_COUNT							((uint32_t)(GFX_H_Video_Line * GFX_V_Video_Height))
// We reserve 4 Screen buffer into internal and external SDRAM (2.457.600 bytes)
#define INT_VIDEO_MEMORY_END		(SDRAM_BANK2_ADDR + (4 * BUFFER_OFFSET))
#define EXT_VIDEO_MEMORY_END		(SDRAM_BANK1_ADDR + (4 * BUFFER_OFFSET))

// Here we define a place to put the Sprites
// For each Sprite we have the Width , Height and the pixels buffer.
// We define the start adress in External SDRAM after the Screen Buffer
// Each Sprites can have 2052 bytes [((32 x 32) x 2) + 4]
#define GFX_SPRITE_START			(EXT_VIDEO_MEMORY_END)
#define GFX_SPRITE_HEADER_LNG	4			// 2 x 16bits value for Width and Height
#define GFX_SPRITE_WIDTH_MAX	32		// Maximum Sprite Width
#define GFX_SPRITE_HEIGHT_MAX	32		// Maximum Sprite Height
#define GFX_SPRITE_MAX				500		// Maximum number of sprites
// Compute the Sprite lenght in bytes (2052 bytes)
#define GFX_SPRITE_LENGTH			(GFX_SPRITE_HEADER_LNG + ((GFX_SPRITE_WIDTH_MAX * GFX_SPRITE_HEIGHT_MAX) * 2))
// Set the end of Sprite memory buffer (3.483.600)
#define GFX_SPRITE_MEMORY_END	(EXT_VIDEO_MEMORY_END + (GFX_SPRITE_LENGTH * GFX_SPRITE_MAX))	// 1.026.000 bytes

// Here we define a place to put a Game Map or Graphics Level
// We just reserve 2000000 bytes of memory because Game Map can have different size
// Adjust the value if you need bigger maps
#define GFX_MAP_START					(GFX_SPRITE_MEMORY_END)
#define GFX_MAP_HEADER_LNG		4						// 2 x 16bits value for width and height from the Map
#define MAP_PIX_START					(GFX_MAP_START + GFX_MAP_HEADER_LNG)
#define GFX_MAP_LENGTH				2000000		// bytes reserved (1.000.000 of 16bits pixels)
// Set the end of Map memory buffer (5.483.604)
#define GFX_MAP_MEMORY_END		(GFX_MAP_HEADER_LNG + GFX_MAP_START + GFX_MAP_LENGTH)

/**
 * @brief Uncomment the line below if you want to use user defined Delay function
 *        (for precise timing), otherwise default _delay_ function defined within
 *         this driver is used (less precise timing).  
 */
/* #define USE_Delay */

#ifdef USE_Delay
#include "main.h" 
  #define _delay_     Delay  /* !< User can provide more timing precise _delay_ function
                                   (with 10ms time base), using SysTick for example */
#else
  #define _delay_     delay      /* !< Default _delay_ function with less precise timing */
#endif

// brief  GFX color  
#define GFX_COLOR_WHITE          0xFFFF
#define GFX_COLOR_BLACK          0x0000
#define GFX_COLOR_GREY           0xF7DE
#define GFX_COLOR_BLUE           0x001F
#define GFX_COLOR_BLUE2          0x051F
#define GFX_COLOR_RED            0xF800
#define GFX_COLOR_MAGENTA        0xF81F
#define GFX_COLOR_GREEN          0x07E0
#define GFX_COLOR_CYAN           0x7FFF
#define GFX_COLOR_YELLOW         0xFFE0

// GFX default font 
#define GFX_DEFAULT_FONT         Font16x24

// GFX Direction  
#define GFX_DIR_HORIZONTAL       0x0000
#define GFX_DIR_VERTICAL         0x0001

// GFX Layer  
#define GFX_BACKGROUND_LAYER     0x0000
#define GFX_FOREGROUND_LAYER     0x0001

// GFX Exported Macros
#define ASSEMBLE_RGB(R, G, B)    ((((R)& 0xF8) << 8) | (((G) & 0xFC) << 3) | (((B) & 0xF8) >> 3))  

// Defines for compatibility issue
#define LCD_BACKGROUND_LAYER			GFX_BACKGROUND_LAYER
#define LCD_FOREGROUND_LAYER			GFX_FOREGROUND_LAYER
#define LCD_FRAME_BUFFER					GFX_FRAME_BUFFER
#define LCD_PIXEL_WIDTH						((uint16_t)640)
#define LCD_PIXEL_HEIGHT					((uint16_t)480)
#define LCD_DIR_HORIZONTAL				GFX_DIR_HORIZONTAL
#define LCD_DIR_VERTICAL					GFX_DIR_VERTICAL

// GFX Exported Functions

// Old function for compatibility
void LCD_SetLayer(__IO uint32_t Layerx);
void LCD_SetColorKeying(uint32_t RGBValue);
void LCD_Clear(uint16_t Color);
void LCD_DrawLine(uint16_t Xpos, uint16_t Ypos, uint16_t Length, uint8_t Direction);

//--------------------------------------
void GFX_DeInit(void);   
void GFX_Init(void);
void GFX_LayerInit(void);
void GFX_ChipSelect(FunctionalState NewState);
void GFX_SetTransparency(uint8_t transparency, uint8_t LayerNum);
void GFX_Clear(uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_SetColorKeying(uint32_t RGBValue, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_ReSetColorKeying(uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_SetFont(sFONT *fonts);
sFONT *  GFX_GetFont(void);
void GFX_DrawChar(int16_t x, int16_t y, const uint16_t *c,uint16_t Fcolor ,uint16_t Bcolor , uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DisplayChar(int16_t x, int16_t y, uint8_t c,uint16_t Fcolor ,uint16_t Bcolor, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DisplayString(int16_t x, int16_t y, char *ptr,uint16_t Fcolor ,uint16_t Bcolor , uint8_t BuffNum, uint8_t SDRAM_Buff);
uint16_t GFX_StringLine(uint16_t LineNumber);
uint16_t GFX_StringColumn(uint16_t ColumnNumber);
void GFX_DrawLine(int16_t Xpos, int16_t Ypos, int16_t Length, uint8_t Direction, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawRect(int16_t Xpos1, int16_t Ypos1, int16_t Xpos2, int16_t Ypos2, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawCircle(int16_t x, int16_t y, uint16_t radius, uint16_t color , uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawEllipse(int16_t Xpos, int16_t Ypos, uint16_t Radius, uint16_t Radius2, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawFullEllipse(int16_t Xpos, int16_t Ypos, uint16_t Radius, uint16_t Radius2, uint16_t FillColor, uint16_t BorderColor, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawUniLine(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawFullRect(int16_t Xpos1, int16_t Ypos1, int16_t Xpos2, int16_t Ypos2, uint16_t FillColor, uint16_t BorderColor, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawRectBorder(int16_t Xpos1, int16_t Ypos1, int16_t Xpos2, int16_t Ypos2, uint16_t BorderColor, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_DrawFullCircle(int16_t Xpos, int16_t Ypos, int16_t Radius, uint16_t FillColor, uint16_t BorderColor, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_Triangle(pPoint Points, uint16_t PointCount, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_FillTriangle(int16_t x1, int16_t x2, int16_t x3, int16_t y1, int16_t y2, int16_t y3, uint16_t FillColor, uint16_t BorderColor, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_SetPixel(int16_t Xpos, int16_t Ypos, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
uint16_t GFX_GetPixel(int16_t Xpos, int16_t Ypos, uint8_t BuffNum, uint8_t SDRAM_Buff);

// Screen Clipping function
ClipScreen GFX_Rect_Clip(int16_t Xpos1, int16_t Ypos1, int16_t Xpos2, int16_t Ypos2);
ClipScreen GFX_Line_Clip(int16_t Xpos, int16_t Ypos, int16_t Length, uint8_t Direction);
ClipMapScreen GFX_Map_Clip(int16_t StartX, int16_t StartY, int16_t Xpos1, int16_t Ypos1, int16_t Xpos2, int16_t Ypos2);

void GFX_Draw_Triangle(TriPoint Triangle, uint16_t color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_Draw_Full_Triangle(TriPoint Triangle, uint16_t incolor, uint16_t outcolor, uint8_t BuffNum, uint8_t SDRAM_Buff);
void VGA_Draw_Image(int16_t x, int16_t y, uint16_t x_res, uint16_t y_res,const uint8_t *ptr_image , uint8_t BuffNum, uint8_t SDRAM_Buff);

// Some utility to copy from one video buffer to another one
void GFX_Copy_Buffer_to_Buffer(uint8_t Buff_From, uint8_t Buff_To, uint8_t SDRAM_Buff_From, uint8_t SDRAM_Buff_To);
void GFX_D2D_Copy(int16_t StartX, int16_t StartY,uint16_t Width,uint16_t Height,int16_t DestX, int16_t DestY,uint8_t Buff_From, uint8_t Buff_To, uint8_t SDRAM_Buff_From, uint8_t SDRAM_Buff_To);
  
// File Load utility
uint8_t GFX_Load_Sprite(FIL DataFile, const char* name,uint16_t SpriteStart);
uint8_t GFX_Load_Map(FIL DataFile, const char* name,uint8_t MapNum);

// Sprites and Map functions
void GFX_Show_Map(int16_t StartX, int16_t StartY,uint16_t Width,uint16_t Height,int16_t DestX, int16_t DestY, uint8_t showtrans , uint16_t transcol , uint8_t SDRAM_Buff, uint8_t GFX_Layer);
void GFX_Show_Map_DMA2D(int16_t StartX, int16_t StartY,uint16_t Width,uint16_t Height,int16_t DestX, int16_t DestY, uint8_t SDRAM_Buff, uint8_t GFX_Layer);
void GFX_Sprite_Show(uint16_t Sprite_Num , int16_t x , int16_t y , uint8_t show , uint16_t transparent , uint8_t GFX_Layer, uint8_t SDRAM_Buff);

// ********************** This functions are not tested *************************** //
// ** That is original from the ST Lib , i just added the Layer and SDRAM buffer ** //
void GFX_PolyLine(pPoint Points, uint16_t PointCount, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_PolyLineRelative(pPoint Points, uint16_t PointCount, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_ClosedPolyLine(pPoint Points, uint16_t PointCount, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_ClosedPolyLineRelative(pPoint Points, uint16_t PointCount, uint16_t Color, uint8_t BuffNum, uint8_t SDRAM_Buff);
void GFX_FillPolyLine(pPoint Points, uint16_t PointCount, uint16_t FillColor, uint16_t BorderColor, uint8_t BuffNum, uint8_t SDRAM_Buff);
// ******************************************************************************** //

#ifdef __cplusplus
}
#endif

#endif /* __GFX_H */
