#include "wii_cc.h"
#include "Delay_Timer.h"

static WII_CC_DATA initial_data;

// Formating the Wii Controller data
static void wiiCCGetData(WII_CC_DATA* data)
{
	u8 buf[6];
	
	delay_ms(2);
	buf[0] = 0;
	
	I2C_WrBuf(WII_CONTROLLER_ID, buf, 1);
	
	delay_ms(1);
		
  I2C_RdBuf(WII_CONTROLLER_ID, buf, 6);
	
	data->left_analog_x = (buf[0] & 0x3F);
	data->left_analog_y = (buf[1] & 0x3F);
	
	data->right_analog_x = ((buf[0] >> 6) & 0x03) << 3;
	data->right_analog_x |= ((buf[1] >> 6) & 0x03) << 1;
	data->right_analog_x |= ((buf[2] >> 7) & 0x01);
	data->right_analog_y = (s8)(buf[2] & 0x1F);
	
	data->left_trigger = ((buf[2] >> 5) & 0x03) << 3;
	data->left_trigger |= (buf[3] >> 5) & 0x07;
	data->right_trigger = (buf[3] & 0x1F);
	
	*((u16*) &data->buttons) = ~(buf[4] | (buf[5] << 8));
	
	data->left_analog_x <<= 2;
	data->left_analog_y <<= 2;
	data->right_analog_x <<= 3;
	data->right_analog_y <<= 3;
}

/* WII Classic Controller Init */
void wiiCCInit(void)
{
	u8 data[2] = {0};
	u8 i = 0;
	
	I2C_LowLevel_Init();
	
	// We have to do it more than 1 time at
	// CPU Start for be sure we initialise 
	// correctly the Wii Controller
	while(i<2)
	{
		data[0] = 0xF0;
		data[1] = 0x55;
		I2C_WrBuf(WII_CONTROLLER_ID, data, 2);
		delay_ms(1);
			
		data[0] = 0xFB;
		data[1] = 0x00;
		I2C_WrBuf(WII_CONTROLLER_ID, data, 2);
		i++;
		delay_ms(500);
	}
	
	for (i = 0; i < 10; i++)
	{
		wiiCCGetData(&initial_data);
	}
}

/* WII Classic Controller Read */
void wiiCCRead(WII_CC_DATA* data)
{
	wiiCCGetData(data);	

	data->left_analog_x -= initial_data.left_analog_x;
	data->left_analog_y -= initial_data.left_analog_y;
	data->right_analog_x -= initial_data.right_analog_x;
	data->right_analog_y -= initial_data.right_analog_y;
	data->left_trigger -= initial_data.left_trigger;
	data->right_trigger -= initial_data.right_trigger;
}

