#ifndef __WII_CC_H
#define __WII_CC_H

#include "stm32f4xx.h"
#include "I2CLib.h"

#define WII_CONTROLLER_ID	0x52

typedef struct wiiCCButtonsTag
{
	u8 dummy:1;
	u8 rtrigger_push:1;
	u8 plus:1;
	u8 home:1;
	u8 minus:1;
	u8 ltrigger_push:1;
	u8 down:1;
	u8 right:1;
	
	u8 up:1;
	u8 left:1;
	u8 zr:1;
	u8 x:1;
	u8 a:1;
	u8 y:1;
	u8 b:1;
	u8 zl:1;	
	
} WII_CC_BUTTONS;

/* WII Classic Controller Data */
typedef struct wiiCCDataTag
{
	s8 left_analog_x;
	s8 left_analog_y;
	
	s8 right_analog_x;
	s8 right_analog_y;
	
	s8 left_trigger;
	s8 right_trigger;
	
	WII_CC_BUTTONS buttons;	
	
} WII_CC_DATA;

void wiiCCInit(void);
void wiiCCRead(WII_CC_DATA* data);

//--------------------------------------------------------------
#endif // __WII_CC_H
