/*
*--------------------------------------
* Program Name: TIDiams
* Author     : Darth Vader (Fabrice)
* License    : Useless thing !
* Description: My 1st TI84PCE Game ;)
* Rules      : Just get all Diamonds for
*               start the next level ...
* Date       : 2017-11-11
* Version    : 1.1
*--------------------------------------
*/

#include "main.h"

void main(void)
{
	uint8_t 		cnt = 0;						//just a counter ....	
	uint8_t 		filestuff;
	uint8_t cx,cy;

	intcnt				= 0;						//cycle counter

	filestuff			= init_game();

	//check if it was error in file
	if (filestuff != 0)
		file_error(filestuff);

	while (!endgame)
		{

		intcnt++;

		ActKey				= os_GetCSC();

		//If hero die we made the explosion 10 and reset the 
		//hero origin in game
		if (Hero.die == true)
			{
			Lives--;
			ExplodeCoords[10].x = Hero.x;
			ExplodeCoords[10].y = Hero.y;
			ExplodeCoords[10].spr = ExploPic[0];
			Map_Level[ExplodeCoords[10].y][ExplodeCoords[10].x] = ExplodeCoords[10].spr;

			// if hero have more than 0 live he respawn
			if (Lives > 0)
				{
				Hero.die			= false;
				Hero.x				= HeroStart.x;
				Hero.y				= HeroStart.y;
				Hero.spr			= Hero_dont_move;
				Map_Level[Hero.y][Hero.x] = Hero.spr;
				rescan_hero();
				init_diamonds();
				init_rocks();
				redraw_map();
				}
			else 
				{
				//No more lives , we end the game
				endgame 			= true;
				}
			}

		get_map_code();
		rescan_hero();

		if ((ActKey == sk_Del) || (ActKey == sk_Clear) || (ActKey == sk_Mode) || (ActKey == sk_Enter))
			endgame = true;

		if (ActKey == sk_Up)
			{
			hero_move(1);
			}

		if (ActKey == sk_Right)
			{
			hero_move(2);
			}

		if (ActKey == sk_Down)
			{
			hero_move(3);
			}

		if (ActKey == sk_Left)
			{
			hero_move(4);
			}

		// pose a dynamite
		if (((ActKey == sk_2nd) || (ActKey == sk_0) || (ActKey == sk_Alpha)) && (Pose_Dynamite == false) && (Hero.dyn > 0) && (DynCoord.spr == 0))
			{
			Pose_Dynamite		= true;
			Hero.dyn--;
			DynCoord.x			= Hero.x;
			DynCoord.y			= Hero.y;
			DynCoord.spr		= DynamPic[0];
			Map_Level[DynCoord.y][DynCoord.x] = DynCoord.spr;
			}

		rescan_rocks();
		rescan_diamonds();
		rescan_monsters();

		//look for dynamite and explosion ...
		if ((Pose_Dynamite == true) && (DynCoord.spr != 0) && (ExplodeCoords[0].spr == 0))
			dynamite();

		for (cnt = 0; cnt < MaxExplosion; cnt++)
			if (ExplodeCoords[cnt].spr != 0)
				explosion(cnt);

		if ((intcnt % 2) == 0)
			{
			check_rocks();
			check_diamonds();
			monster_move();
			}

		redraw_map();

		// Show lives / Dynamites / Score
		for(cy = Level_H ; cy < (Level_H + 3) ; cy++)
			for(cx = 0 ; cx < Level_W ; cx++)
				gfx_Sprite(((gfx_sprite_t *) var_gfx[BlankCase]), cx * Sprite_W, cy * Sprite_H);

		// heart and lives
		gfx_Sprite(((gfx_sprite_t *) var_gfx[CoeurPic]), 10, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[Lives]]), 30, 196);

		// Dynamites
		gfx_Sprite(((gfx_sprite_t *) var_gfx[DynamPic[0]]), 80, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[Hero.dyn]]), 100, 196);

		// this decode and show Score with sprites.
		decode_score();

		//Swap the buffer with the screen
		gfx_BlitBuffer();

		//		debug_sprite();
		}

	//End the graphics
	gfx_End();
}


void file_error(uint8_t errnum)
{
	// Fill the screen red
	gfx_FillScreen(gfx_red);
	gfx_SetTextBGColor(gfx_red);
	gfx_SetTextFGColor(gfx_yellow);

	// write down the error for 3 seconds and end the game ...
	if (errnum == 1)
		gfx_PrintStringXY("Cannot open file...", 0, 10);

	if (errnum == 2)
		gfx_PrintStringXY("Cannot read Lastlevel", 0, 10);

	if (errnum == 3)
		gfx_PrintStringXY("Cannot seek in file", 0, 10);

	if (errnum == 4)
		gfx_PrintStringXY("Cannot reading level", 0, 10);

	//Swap the buffer with the screen
	gfx_BlitBuffer();
	endgame 			= true;
	delay(3000);
}


//Have to be started only one time at start
uint8_t init_game(void)
{
	uint8_t 		filestuff = 0;

	Pose_Dynamite		= false;					// true if we have drop a dynamite and explosion is not finish
	NbMonsters			= 0;						// Number of monsters in the level
	NbDiam				= 0;						// Number of Diamonds in the level
	NbRocks 			= 0;						// Number of Rocks in the level
	Score				= 0;						// Player Score
	Lives				= 3;						// Number of player Lives
	Level_Number		= 0;						// Actual Level number
	endgame 			= false;					// true if game ends
	foundrock			= -1;
	foundwall			= -1;
	foundmonster		= -1;
	Seconds 			= 0;						//Time counts for finish the level
	DynCoord.x			= 0;
	DynCoord.y			= 0;
	DynCoord.spr		= 0;

	//Start the graphics routines
	gfx_Begin();

	//Init all Sprites / Tiles
	var_gfx_init();

	// Set up the palette for the sprite
	gfx_SetPalette(all_gfx_pal, sizeof_all_gfx_pal, 0);

	gfx_SetColor(gfx_black);
	gfx_FillRectangle(0, 0, 320, 240);

	// Draw to buffer to avoid tearing
	gfx_SetDrawBuffer();
	gfx_SetColor(gfx_black);
	gfx_FillRectangle(0, 0, 320, 240);

	// Draw the first map
	filestuff			= setmap(Level_Number);

	if (filestuff != 0)
		return filestuff;

	get_map_elements();

	init_rocks();
	init_diamonds();
	init_hero();
	init_monster();

	//Seed the random numbers
	srand(rtc_Time());

	return 0; // everything was ok
}


// Get the map and draw it to screen
uint8_t setmap(uint16_t numlevel)
{
	//Get the map from appvars
	int 			leveloffset = 0;
	uint8_t 		cnt, cntx, cnty;
	const char *	appvarName = "DIAMLVL";
	uint8_t 		nlevH, nlevL;
	ti_var_t		LevelAppVar;
	char			strnum[10];

	// Close any files that may be open already
	ti_CloseAll();

	// Open the variable in read mode
	LevelAppVar 		= ti_Open(appvarName, "r");

	// Make sure we opened okay
	if (!LevelAppVar)
		return 1; // Error occured ...

	///Let's read the last level number first
	if (ti_Read(&nlevH, 1, 1, LevelAppVar) != 1)
		{
		ti_CloseAll();
		return 2; // Error reading Lastlevel
		}

	if (ti_Read(&nlevL, 1, 1, LevelAppVar) != 1)
		{
		ti_CloseAll();
		return 2; // Error reading Lastlevel
		}

	LastLevel			= (nlevH << 8) +nlevL;

	// Copy the Map numlevel to tilemap
	if (numlevel <= LastLevel)
		{
		//Now we have to set the Offset in file to read the selected level
		leveloffset 		= (numlevel * (Level_H * Level_W)) + 2; // +2 because we read LastLevel data at 1st position (2 bytes)

		if (ti_Seek(leveloffset, 0, LevelAppVar) == EOF)
			{
			ti_CloseAll();
			return 3; // Error seek in file
			}

		//We finally read the Level Data
		if (ti_Read(&LevelGet, sizeof(LevelGet), 1, LevelAppVar) != 1)
			{
			ti_CloseAll();
			return 4; // Error reading level
			}

		//Close the file
		ti_CloseAll();

		/*
				// ****************** just for debug ******************
				// Fill the screen red
				gfx_FillScreen(gfx_red);
				gfx_SetTextBGColor(gfx_red);
				gfx_SetTextFGColor(gfx_yellow);
				gfx_PrintStringXY("LastLevel = ", 0, 10);
				sprintf(strnum,"%d",LastLevel);
				gfx_PrintStringXY(strnum, 110, 10);
				//Swap the buffer with the screen
				gfx_BlitBuffer();
				delay(3000);
				// ****************** just for debug ******************
		*/
		cnt 				= 0;

		for (cnty = 0; cnty < Level_H; cnty++)
			for (cntx = 0; cntx < Level_W; cntx++)
				{
				Map_Level[cnty][cntx] = LevelGet[cnt];
				cnt++;
				}

		//Put sprites on screen
		for (cnty = 0; cnty < Level_H; cnty++)
			for (cntx = 0; cntx < Level_W; cntx++)
				{
				gfx_Sprite(((gfx_sprite_t *) var_gfx[Map_Level[cnty][cntx]]), cntx * Sprite_W, cnty * Sprite_H);

				if ((Map_Level[cnty][cntx] >= Hero_go_left[0]) && (Map_Level[cnty][cntx] <= Hero_dont_move))
					{
					Map_Level[cnty][cntx] = HeroCase;
					Hero.spr			= Hero_dont_move;
					gfx_Sprite(((gfx_sprite_t *) var_gfx[Map_Level[cnty][cntx]]), cntx * Sprite_W, cnty * Sprite_H);
					}
				}

		//set number of hero lives
		//		Lives = 3;
		//get elements code for this map
		get_map_code();

		//Swap the buffer with the screen
		gfx_BlitBuffer();
		}

	//Close the file
	ti_CloseAll();
	return 0; // everything was ok
}


// Redraw the game map after a move
void redraw_map(void)
{
	uint8_t 		cnt, cntx, cnty;

	for (cnty = 0; cnty < Level_H; cnty++)
		for (cntx = 0; cntx < Level_W; cntx++)
			gfx_Sprite(((gfx_sprite_t *) var_gfx[Map_Level[cnty][cntx]]), cntx * Sprite_W, cnty * Sprite_H);

	//Swap the buffer with the screen
	gfx_BlitBuffer();
}


// Get all elements we have on the map
void get_map_elements(void)
{
	uint8_t 		cntx, cnty;

	NbMonsters			= 0;						// Number of monsters in the level
	NbDiam				= 0;						// Number of Diamonds in the level
	NbRocks 			= 0;						// Number of Rocks in the level

	// Look for the Hero first
	for (cnty = 0; cnty < Level_H; cnty++)
		for (cntx = 0; cntx < Level_W; cntx++)
			{
			if (Map_Code[cnty][cntx] == c_hero)
				{
				Map_Level[cnty][cntx] = Hero_dont_move;
				HeroStart.x 		= cntx; 		// save the Hero start point to come back
				HeroStart.y 		= cnty; 		// when Hero die ....
				Hero.x				= cntx;
				Hero.y				= cnty;
				Hero.dyn			= 3;
				Hero.spr			= Hero_dont_move;
				cnty				= Level_H;
				cntx				= Level_W;

				//scan arround the hero
				rescan_hero();
				Pose_Dynamite		= false;
				}
			}

	// Look for Rocks
	for (cnty = 0; cnty < Level_H; cnty++)
		for (cntx = 0; cntx < Level_W; cntx++)
			{
			if (Map_Code[cnty][cntx] == c_rock)
				{
				NbRocks++;
				Rocks[NbRocks - 1].x = cntx;
				Rocks[NbRocks - 1].y = cnty;
				Rocks[NbRocks - 1].spr = Map_Level[cnty][cntx];
				Rocks[NbRocks - 1].type = 0;		// We only have 1 type of rocks
				}
			}

	// Look for Diamonds
	for (cnty = 0; cnty < Level_H; cnty++)
		for (cntx = 0; cntx < Level_W; cntx++)
			{
			// Diamonds type 1
			if ((Map_Level[cnty][cntx] >= Diam1Pic[0]) && (Map_Level[cnty][cntx] <= Diam1Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = cntx;
				Diams[NbDiam - 1].y = cnty;
				Diams[NbDiam - 1].spr = Map_Level[cnty][cntx];
				Diams[NbDiam - 1].type = 1;
				}

			// Diamonds type 2
			if ((Map_Level[cnty][cntx] >= Diam2Pic[0]) && (Map_Level[cnty][cntx] <= Diam1Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = cntx;
				Diams[NbDiam - 1].y = cnty;
				Diams[NbDiam - 1].spr = Map_Level[cnty][cntx];
				Diams[NbDiam - 1].type = 2;
				}

			// Diamonds type 3
			if ((Map_Level[cnty][cntx] >= Diam3Pic[0]) && (Map_Level[cnty][cntx] <= Diam3Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = cntx;
				Diams[NbDiam - 1].y = cnty;
				Diams[NbDiam - 1].spr = Map_Level[cnty][cntx];
				Diams[NbDiam - 1].type = 3;
				}

			// Diamonds type 4
			if ((Map_Level[cnty][cntx] >= Diam4Pic[0]) && (Map_Level[cnty][cntx] <= Diam1Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = cntx;
				Diams[NbDiam - 1].y = cnty;
				Diams[NbDiam - 1].spr = Map_Level[cnty][cntx];
				Diams[NbDiam - 1].type = 4;
				}

			// Diamonds type 5
			if ((Map_Level[cnty][cntx] >= Diam5Pic[0]) && (Map_Level[cnty][cntx] <= Diam1Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = cntx;
				Diams[NbDiam - 1].y = cnty;
				Diams[NbDiam - 1].spr = Map_Level[cnty][cntx];
				Diams[NbDiam - 1].type = 5;
				}
			}

	// Look for Monsters
	for (cnty = 0; cnty < Level_H; cnty++)
		for (cntx = 0; cntx < Level_W; cntx++)
			{
			// Monter type 1
			if ((Map_Level[cnty][cntx] >= Monster1Pic[0]) && (Map_Level[cnty][cntx] <= Monster1Pic[LastMonsterPic]))
				{
				NbMonsters++;
				Monsters[NbMonsters - 1].x = cntx;
				Monsters[NbMonsters - 1].y = cnty;
				Monsters[NbMonsters - 1].dir = 5;
				Monsters[NbMonsters - 1].die = false;
				Monsters[NbMonsters - 1].spr = Map_Level[cnty][cntx];
				Monsters[NbMonsters - 1].type = 1;
				}

			// Monter type 2
			if ((Map_Level[cnty][cntx] >= Monster2Pic[0]) && (Map_Level[cnty][cntx] <= Monster2Pic[LastMonsterPic]))
				{
				NbMonsters++;
				Monsters[NbMonsters - 1].x = cntx;
				Monsters[NbMonsters - 1].y = cnty;
				Monsters[NbMonsters - 1].dir = 5;
				Monsters[NbMonsters - 1].die = false;
				Monsters[NbMonsters - 1].spr = Map_Level[cnty][cntx];
				Monsters[NbMonsters - 1].type = 2;
				}

			// Monter type 3
			if ((Map_Level[cnty][cntx] >= Monster3Pic[0]) && (Map_Level[cnty][cntx] <= Monster3Pic[LastMonsterPic]))
				{
				NbMonsters++;
				Monsters[NbMonsters - 1].x = cntx;
				Monsters[NbMonsters - 1].y = cnty;
				Monsters[NbMonsters - 1].dir = 5;
				Monsters[NbMonsters - 1].die = false;
				Monsters[NbMonsters - 1].spr = Map_Level[cnty][cntx];
				Monsters[NbMonsters - 1].type = 3;
				}
			}
}


// get codes from map elements
void get_map_code(void)
{
	uint8_t 		cntx, cnty;

	for (cnty = 0; cnty < Level_H; cnty++)
		for (cntx = 0; cntx < Level_W; cntx++)
			{
			// empty case
			if (Map_Level[cnty][cntx] == BlankCase)
				Map_Code[cnty][cntx] = c_blank;

			// sand
			if ((Map_Level[cnty][cntx] >= SandPic[0]) && (Map_Level[cnty][cntx] <= SandPic[LastSandPic]))
				Map_Code[cnty][cntx] = c_sand;

			// diamonds part 1
			if ((Map_Level[cnty][cntx] >= Diam1Pic[0]) && (Map_Level[cnty][cntx] <= Diam2Pic[LastDiamPic]))
				Map_Code[cnty][cntx] = c_diam;

			// diamonds part 2
			if ((Map_Level[cnty][cntx] >= Diam3Pic[0]) && (Map_Level[cnty][cntx] <= Diam5Pic[LastDiamPic]))
				Map_Code[cnty][cntx] = c_diam;

			// wall
			if ((Map_Level[cnty][cntx] >= WallPic[0]) && (Map_Level[cnty][cntx] <= WallPic[LastWallPic]))
				Map_Code[cnty][cntx] = c_wall;

			// rocks
			if ((Map_Level[cnty][cntx] >= RocksPic[0]) && (Map_Level[cnty][cntx] <= RocksPic[LastRocksPic]))
				Map_Code[cnty][cntx] = c_rock;

			// hero
			if ((Map_Level[cnty][cntx] >= Hero_go_left[0]) && (Map_Level[cnty][cntx] <= Hero_dont_move))
				Map_Code[cnty][cntx] = c_hero;

			// monster
			if ((Map_Level[cnty][cntx] >= Monster1Pic[0]) && (Map_Level[cnty][cntx] <= Monster3Pic[LastMonsterPic]))
				Map_Code[cnty][cntx] = c_monster;

			// door
			if ((Map_Level[cnty][cntx] >= DoorPic[0]) && (Map_Level[cnty][cntx] <= DoorPic[LastDoorPic]))
				Map_Code[cnty][cntx] = c_door;

			// dynamite
			if ((Map_Level[cnty][cntx] >= DynamPic[0]) && (Map_Level[cnty][cntx] <= DynamPic[LastDynamPic]))
				Map_Code[cnty][cntx] = c_dyn;

			// explosion
			if ((Map_Level[cnty][cntx] >= ExploPic[0]) && (Map_Level[cnty][cntx] <= SandPic[LastExploPic]))
				Map_Code[cnty][cntx] = c_exp;
			}
}


// Get the sprites arround the rocks
void rescan_rocks(void)
{
	// Check arround each Rocks after a Rock moving
	uint8_t 		i;

	if (NbRocks > 0)
		for (i = 0; i < NbRocks; i++)
			{
			if ((Rocks[i].x + 1) <= MaxLX)
				Rocks[i].r = Map_Code[Rocks[i].y][Rocks[i].x + 1];
			else 
				Rocks[i].r = 0;

			if (((Rocks[i].x + 1) <= MaxLX) && ((Rocks[i].y + 1) <= MaxLY))
				Rocks[i].dr = Map_Code[Rocks[i].y + 1][Rocks[i].x + 1];
			else 
				Rocks[i].dr = 0;

			if ((Rocks[i].y + 1) <= MaxLY)
				Rocks[i].d = Map_Code[Rocks[i].y + 1][Rocks[i].x];
			else 
				Rocks[i].d = 0;

			if (((Rocks[i].y + 1) <= MaxLY) && ((Rocks[i].x - 1) > -1))
				Rocks[i].dl = Map_Code[Rocks[i].y + 1][Rocks[i].x - 1];
			else 
				Rocks[i].dl = 0;

			if ((Rocks[i].x - 1) > -1)
				Rocks[i].l = Map_Code[Rocks[i].y][Rocks[i].x - 1];
			else 
				Rocks[i].l = 0;
			}
}


// Test when rocks can fall down
void check_rocks(void)
{
	// Check if a Rock can fall down or if he kill the Hero
	uint8_t 		i;

	//Rescan the rocks before any move
	//	get_map_code();				// get map elements
	//	rescan_rocks();
	if (NbRocks > 0)
		for (i = 0; i < NbRocks; i++)
			{
			//Reset Rock direction
			Rocks[i].dir		= 0;

			//Test for fall down
			if (Rocks[i].d == c_blank)
				Rocks[i].dir = 1;

			//Test for rocks fall left down
			if ((Rocks[i].dir != 1) && (Rocks[i].l == c_blank) && (Rocks[i].dl == c_blank) &&
				 (Rocks[i].d != c_sand) && (Rocks[i].d != c_wall) && (Rocks[i].d != c_hero) &&
				 (Rocks[i].d != c_door) && (Rocks[i].d != 0))
				Rocks[i].dir = 2;

			//Test for rocks fall right down
			if ((Rocks[i].dir != 1) && (Rocks[i].r == c_blank) && (Rocks[i].dr == c_blank) &&
				 (Rocks[i].d != c_sand) && (Rocks[i].d != c_wall) && (Rocks[i].d != c_hero) &&
				 (Rocks[i].d != c_door) && (Rocks[i].d != 0))
				Rocks[i].dir = 3;

			//Set the rock new position in map level and erase it from actual position
			if (Rocks[i].dir != 0)
				{
				Map_Level[Rocks[i].y][Rocks[i].x] = BlankCase;

				if (Rocks[i].dir == 1) // fall down
					Rocks[i].y++;

				if (Rocks[i].dir == 2)
					{ // fall left down
					Rocks[i].x--;
					Rocks[i].y++;
					}

				if (Rocks[i].dir == 3)
					{ // fall right down
					Rocks[i].x++;
					Rocks[i].y++;
					}

				// Increment the rock sprite number for animation
				if ((Rocks[i].spr + 1) <= RocksPic[LastRocksPic])
					Rocks[i].spr++;
				else 
					Rocks[i].spr = RocksPic[0];

				//Put the new rock sprite to map level
				Map_Level[Rocks[i].y][Rocks[i].x] = Rocks[i].spr;
				get_map_code(); 					// get map elements
				rescan_rocks(); 					// rescan after a rock have move

				//check if hero die under a rock
				if (Rocks[i].d == c_hero)
					Hero.die = true;
				}
			}
}


// Get the sprites arround the diamonds
void rescan_diamonds(void)
{
	// Check arround each Diamonds after a Diamond moving
	uint8_t 		i;

	if (NbDiam > 0)
		for (i = 0; i < NbDiam; i++)
			{
			if ((Diams[i].x + 1) <= MaxLX)
				Diams[i].r = Map_Code[Diams[i].y][Diams[i].x + 1];
			else 
				Diams[i].r = 0;

			if (((Diams[i].x + 1) <= MaxLX) && ((Diams[i].y + 1) <= MaxLY))
				Diams[i].dr = Map_Code[Diams[i].y + 1][Diams[i].x + 1];
			else 
				Diams[i].dr = 0;

			if ((Diams[i].y + 1) <= MaxLY)
				Diams[i].d = Map_Code[Diams[i].y + 1][Diams[i].x];
			else 
				Diams[i].d = 0;

			if (((Diams[i].y + 1) <= MaxLY) && ((Diams[i].x - 1) > -1))
				Diams[i].dl = Map_Code[Diams[i].y + 1][Diams[i].x - 1];
			else 
				Diams[i].dl = 0;

			if ((Diams[i].x - 1) > -1)
				Diams[i].l = Map_Code[Diams[i].y][Diams[i].x - 1];
			else 
				Diams[i].l = 0;
			}
}


// Test when diamonds can fall down
void check_diamonds(void)
{
	// Check if a Diamond can fall down or if he kill the Hero
	uint8_t 		i;
	uint8_t 		cnt;

	//Rescan the diamonds before any move
	//	get_map_code();				// get map elements
	//	rescan_diamonds();
	if (NbDiam > 0)
		for (i = 0; i < NbDiam; i++)
			{
			//Reset Diamond direction
			Diams[i].dir		= 0;

			//Test for fall down
			if (Diams[i].d == c_blank)
				Diams[i].dir = 1;

			//Test for Diamond fall left down
			if ((Diams[i].dir != 1) && (Diams[i].l == c_blank) && (Diams[i].dl == c_blank) &&
				 (Diams[i].d != c_sand) && (Diams[i].d != c_wall) && (Diams[i].d != c_hero) &&
				 (Diams[i].d != c_door) && (Diams[i].d != 0))
				Diams[i].dir = 2;

			//Test for Diamond fall right down
			if ((Diams[i].dir != 1) && (Diams[i].r == c_blank) && (Diams[i].dr == c_blank) &&
				 (Diams[i].d != c_sand) && (Diams[i].d != c_wall) && (Diams[i].d != c_hero) &&
				 (Diams[i].d != c_door) && (Diams[i].d != 0))
				Diams[i].dir = 3;

			//Set the Diamond new position in map level and erase it from actual position
			if (Diams[i].dir != 0)
				{
				Map_Level[Diams[i].y][Diams[i].x] = BlankCase;

				if (Diams[i].dir == 1)
					{ // fall down
					Diams[i].y++;
					}

				if (Diams[i].dir == 2)
					{ // fall left down
					Diams[i].x--;
					Diams[i].y++;
					}

				if (Diams[i].dir == 3)
					{ // fall right down
					Diams[i].x++;
					Diams[i].y++;
					}

				// Increment the Diamond sprite number for animation
				// Here we have to test the diamond type first
				if (Diams[i].type == 1)
					{
					if ((Diams[i].spr + 1) <= Diam1Pic[LastDiamPic])
						Diams[i].spr++;
					else 
						Diams[i].spr = Diam1Pic[0];
					}

				if (Diams[i].type == 2)
					{
					if ((Diams[i].spr + 1) <= Diam2Pic[LastDiamPic])
						Diams[i].spr++;
					else 
						Diams[i].spr = Diam2Pic[0];
					}

				if (Diams[i].type == 3)
					{
					if ((Diams[i].spr + 1) <= Diam3Pic[LastDiamPic])
						Diams[i].spr++;
					else 
						Diams[i].spr = Diam3Pic[0];
					}

				if (Diams[i].type == 4)
					{
					if ((Diams[i].spr + 1) <= Diam4Pic[LastDiamPic])
						Diams[i].spr++;
					else 
						Diams[i].spr = Diam4Pic[0];
					}

				if (Diams[i].type == 5)
					{
					if ((Diams[i].spr + 1) <= Diam5Pic[LastDiamPic])
						Diams[i].spr++;
					else 
						Diams[i].spr = Diam5Pic[0];
					}

				//Put the new Diamond sprite to map level
				Map_Level[Diams[i].y][Diams[i].x] = Diams[i].spr;

				get_map_code(); 					// get map elements
				rescan_diamonds();					// rescan after a Diamond have move

				//check if hero die under a Diamond
				if (Diams[i].d == c_hero)
					Hero.die = true;
				}
			}
}


void init_rocks(void)
{
	// Initialise the Rocks status at start from level
	// or after a dynamite explosion
	uint8_t 		i, j;

	NbRocks 			= 0;

	for (i = 0; i < Level_W; i++)
		for (j = 0; j < Level_H; j++) //we test if we have a rock here
			if ((Map_Level[j][i] >= RocksPic[0]) && (Map_Level[j][i] <= RocksPic[LastRocksPic]))
				{
				NbRocks++;
				Rocks[NbRocks - 1].x = i;
				Rocks[NbRocks - 1].y = j;
				Rocks[NbRocks - 1].spr = Map_Level[j][i];
				Rocks[NbRocks - 1].dir = 0;
				Rocks[NbRocks - 1].type = 0;
				}

	// Scan arround the rocks
	get_map_code();
	rescan_rocks();
}


void init_diamonds(void)
{
	// Initialise the Diamonds status at start from level
	// or after a dynamite explosion of after the Hero het it
	uint8_t 		i, j;

	NbDiam				= 0;

	for (i = 0; i < Level_W; i++)
		for (j = 0; j < Level_H; j++)
			{
			//we test if we have a type 1 Diamond here
			if ((Map_Level[j][i] >= Diam1Pic[0]) && (Map_Level[j][i] <= Diam1Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = i;
				Diams[NbDiam - 1].y = j;
				Diams[NbDiam - 1].spr = Map_Level[j][i];
				Diams[NbDiam - 1].dir = 0;
				Diams[NbDiam - 1].type = 1;
				}

			//we test if we have a type 2 Diamond here
			if ((Map_Level[j][i] >= Diam2Pic[0]) && (Map_Level[j][i] <= Diam2Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = i;
				Diams[NbDiam - 1].y = j;
				Diams[NbDiam - 1].spr = Map_Level[j][i];
				Diams[NbDiam - 1].dir = 0;
				Diams[NbDiam - 1].type = 2;
				}

			//we test if we have a type 3 Diamond here
			if ((Map_Level[j][i] >= Diam3Pic[0]) && (Map_Level[j][i] <= Diam3Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = i;
				Diams[NbDiam - 1].y = j;
				Diams[NbDiam - 1].spr = Map_Level[j][i];
				Diams[NbDiam - 1].dir = 0;
				Diams[NbDiam - 1].type = 3;
				}

			//we test if we have a type 4 Diamond here
			if ((Map_Level[j][i] >= Diam4Pic[0]) && (Map_Level[j][i] <= Diam4Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = i;
				Diams[NbDiam - 1].y = j;
				Diams[NbDiam - 1].spr = Map_Level[j][i];
				Diams[NbDiam - 1].dir = 0;
				Diams[NbDiam - 1].type = 4;
				}

			//we test if we have a type 5 Diamond here
			if ((Map_Level[j][i] >= Diam5Pic[0]) && (Map_Level[j][i] <= Diam5Pic[LastDiamPic]))
				{
				NbDiam++;
				Diams[NbDiam - 1].x = i;
				Diams[NbDiam - 1].y = j;
				Diams[NbDiam - 1].spr = Map_Level[j][i];
				Diams[NbDiam - 1].dir = 0;
				Diams[NbDiam - 1].type = 5;
				}
			}

	// Scan arround the diamonds
	get_map_code();
	rescan_diamonds();
}


void init_hero(void)
{
	//Initialise the Hero status at start from level
	uint8_t 		i, j;

	for (i = 0; i < Level_W; i++)
		for (j = 0; j < Level_H; j++) //we test if we found the Hero here
			if ((Map_Level[j][i] >= Hero_go_left[0]) && (Map_Level[j][i] <= Hero_dont_move))
				{
				//We got the Hero
				Hero.x				= i;
				Hero.y				= j;
				Hero.spr			= Map_Level[j][i];
				Hero.dir			= 5;
				Hero.u				= Map_Level[j - 1][i];
				Hero.r				= Map_Level[j][i + 1];
				Hero.d				= Map_Level[j + 1][i];
				Hero.l				= Map_Level[j][i - 1];
				}

	get_map_code();
}


void init_monster(void)
{
	//Initialise the Monsters status at start from level
	uint8_t 		i, j;

	NbMonsters			= 0;

	for (i = 0; i < Level_W; i++)
		for (j = 0; j < Level_H; j++) //we test if we found a Monster here
			if (Map_Code[j][i] == c_monster)
				{
				//We got a Monster
				NbMonsters++;
				Monsters[NbMonsters - 1].x = i;
				Monsters[NbMonsters - 1].y = j;

				//Get the type of monster
				if ((Map_Level[j][i] >= Monster1Pic[0]) && (Map_Level[j][i] <= Monster1Pic[LastMonsterPic]))
					{
					Monsters[NbMonsters - 1].spr = Monster1Pic[0];
					Monsters[NbMonsters - 1].type = 1;
					}

				if ((Map_Level[j][i] >= Monster2Pic[0]) && (Map_Level[j][i] <= Monster2Pic[LastMonsterPic]))
					{
					Monsters[NbMonsters - 1].spr = Monster2Pic[0];
					Monsters[NbMonsters - 1].type = 2;
					}

				if ((Map_Level[j][i] >= Monster3Pic[0]) && (Map_Level[j][i] <= Monster3Pic[LastMonsterPic]))
					{
					Monsters[NbMonsters - 1].spr = Monster3Pic[0];
					Monsters[NbMonsters - 1].type = 3;
					}

				Monsters[NbMonsters - 1].die = false;
				}

	get_map_code();
	rescan_monsters();
}


void rescan_hero(void)
{
	if (Hero.y == 0)
		Hero.u = 0;
	else 
		Hero.u = Map_Code[Hero.y - 1][Hero.x];

	if ((Hero.x + 1) > MaxLX)
		Hero.r = 0;
	else 
		Hero.r = Map_Code[Hero.y][Hero.x + 1];

	if ((Hero.y + 1) > MaxLY)
		Hero.d = 0;
	else 
		Hero.d = Map_Code[Hero.y + 1][Hero.x];

	if (Hero.x == 0)
		Hero.l = 0;
	else 
		Hero.l = Map_Code[Hero.y][Hero.x - 1];
}


// Check arround the Monster and record the elements
void rescan_monsters(void)
{
	// Check arround the Monster and record the elements
	uint8_t 		i;

	if (NbMonsters > 0)
		{
		for (i = 0; i < NbMonsters; i++)
			{
			if (Monsters[i].y == 0)
				Monsters[i].u = 0;
			else 
				Monsters[i].u = Map_Code[Monsters[i].y - 1][Monsters[i].x];

			if ((Monsters[i].x + 1) > MaxLX)
				Monsters[i].r = 0;
			else 
				Monsters[i].r = Map_Code[Monsters[i].y][Monsters[i].x + 1];

			if ((Monsters[i].y + 1) > MaxLY)
				Monsters[i].d = 0;
			else 
				Monsters[i].d = Map_Code[Monsters[i].y + 1][Monsters[i].x];

			if (Monsters[i].x == 0)
				Monsters[i].l = 0;
			else 
				Monsters[i].l = Map_Code[Monsters[i].y][Monsters[i].x - 1];
			}
		}
}


bool hero_move(uint8_t newd)
{
	// Move the Hero and look for collision with
	// wall , Rocks , etc ....
	// 1:up 2:right 3:down 4:left 5:stay
	uint8_t 		i;
	uint8_t 		oldx, oldy, oldd;
	bool			rock_moved = false;
	uint8_t 		newx = 0;
	uint8_t 		newy = 0;

	oldx				= Hero.x;
	oldy				= Hero.y;
	oldd				= Hero.dir;
	foundrock			= -1;
	foundwall			= -1;
	foundmonster		= -1;
	rescan_hero();

	//up
	if (newd == 1)
		{
		if (Hero.u == 0)
			return 0;

		newx				= Hero.x;
		newy				= Hero.y - 1;
		}

	//down
	if (newd == 3)
		{
		if (Hero.d == 0)
			return 0;

		newx				= Hero.x;
		newy				= Hero.y + 1;
		}

	//right
	if (newd == 2)
		{
		if (Hero.r == 0)
			return 0;

		newx				= Hero.x + 1;
		newy				= Hero.y;
		}

	//left
	if (newd == 4)
		{
		if (Hero.l == 0)
			return 0;

		newx				= Hero.x - 1;
		newy				= Hero.y;
		}

	// check for Rocks
	if (NbRocks > 0)
		{
		for (i = 0; i < NbRocks; i++)
			if ((Rocks[i].x == newx) && (Rocks[i].y == newy))
				foundrock = i;
		}

	//check for walls
	if (Map_Code[newy][newx] == c_wall)
		foundwall = 1;

	//check for monster
	if (Map_Code[newy][newx] == c_monster)
		foundmonster = 1;

	//If a rock is found and we go left or right , check if we can push it away
	if ((foundrock > -1) && ((newd == 2) || (newd == 4)))
		{
		if ((newd == 2) && (Rocks[foundrock].r == c_blank))
			{
			Map_Level[Rocks[foundrock].y][Rocks[foundrock].x] = BlankCase;
			Rocks[foundrock].x++;					// push right

			// We can now move the hero in that direction
			Hero.x				= newx;
			Hero.y				= newy;
			Hero.dir			= newd;
			rock_moved			= true;
			}

		if ((newd == 4) && (Rocks[foundrock].l == c_blank))
			{
			Map_Level[Rocks[foundrock].y][Rocks[foundrock].x] = BlankCase;
			Rocks[foundrock].x--;					// push left

			// We can now move the hero in that direction
			Hero.x				= newx;
			Hero.y				= newy;
			Hero.dir			= newd;
			rock_moved			= true;
			}

		if (rock_moved == true)
			{
			// Increment rock sprite number and record it to the
			// new position in game map
			if ((Rocks[foundrock].spr + 1) <= RocksPic[LastRocksPic])
				Rocks[foundrock].spr++;
			else 
				Rocks[foundrock].spr = RocksPic[0];

			Map_Level[Rocks[foundrock].y][Rocks[foundrock].x] = Rocks[foundrock].spr;
			}

		// change the hero sprite
		if (oldd != newd)
			{ // direction have change

			if (newd == 2)
				Hero.spr = Hero_push_right[0];
			else 
				Hero.spr = Hero_push_left[0];
			}
		else 
			{ // direction doesnt change

			if (newd == 2)
				{
				// increment sprite number for push rocks right
				if ((Hero.spr + 1) <= Hero_push_right[LastDirectionPic])
					Hero.spr++;
				else 
					Hero.spr = Hero_push_right[0];
				}

			if (newd == 4)
				{
				// increment sprite number for push rocks left
				if ((Hero.spr + 1) <= Hero_push_left[LastDirectionPic])
					Hero.spr++;
				else 
					Hero.spr = Hero_push_left[0];
				}
			}
		}

	//there was no rocks check if we can move
	if ((foundrock == -1) && (foundwall == -1) && (foundmonster == -1))
		{
		Hero.x				= newx;
		Hero.y				= newy;
		Hero.dir			= newd;

		//We have to choose the right Hero Sprite
		if (Hero.dir == oldd)
			{
			if (newd == 1)
				if ((Hero.spr + 1) > Hero_go_up[LastDirectionPic])
					Hero.spr = Hero_go_up[0];
			else 
				Hero.spr = Hero.spr++;

			if (newd == 2)
				if ((Hero.spr + 1) > Hero_go_right[LastDirectionPic])
					Hero.spr = Hero_go_right[0];
			else 
				Hero.spr = Hero.spr++;

			if (newd == 3)
				if ((Hero.spr + 1) > Hero_go_down[LastDirectionPic])
					Hero.spr = Hero_go_down[0];
			else 
				Hero.spr = Hero.spr++;

			if (newd == 4)
				if ((Hero.spr + 1) > Hero_go_left[LastDirectionPic])
					Hero.spr = Hero_go_left[0];
			else 
				Hero.spr = Hero.spr++;
			}
		else 
			{
			if (newd == 1)
				Hero.spr = Hero_go_up[0];

			if (newd == 2)
				Hero.spr = Hero_go_right[0];

			if (newd == 3)
				Hero.spr = Hero_go_down[0];

			if (newd == 4)
				Hero.spr = Hero_go_left[0];
			}
		}

	// If Level map change with new hero position
	if ((oldx != newx) || (oldy != newy))
		{
		Map_Level[oldy][oldx] = BlankCase;
		Map_Level[Hero.y][Hero.x] = Hero.spr;

		// If we have get a Diamond we have to add it to score
		// and scan all diamonds again
		if (Map_Code[newy][newx] == c_diam)
			Score++;

		init_diamonds();
		}


	// If we have get all the diamonds we can go to next level
	if (NbDiam == 0)
		{
		Level_Number++;

		if (Level_Number <= LastLevel)
			{
			i					= setmap(Level_Number);

			if (i != 0)
				{
				file_error(i);
				return 0;
				}

			get_map_elements();
			init_rocks();
			init_diamonds();
			init_hero();
			init_monster();
			if((Lives + 1) < 10) Lives++;
			if((Hero.dyn + 1) < 10) Hero.dyn++;
			}
		else 
			{
			Level_Number		= 0;
			i					= setmap(Level_Number);

			if (i != 0)
				{
				file_error(i);
				return 0;
				}

			get_map_elements();
			init_rocks();
			init_diamonds();
			init_hero();
			init_monster();
			Lives = 3;
			Hero.dyn = 3;
			}
		}

	return 0;
}


bool monster_move(void)
{
	uint8_t 		cnt, nbloop;
	uint8_t 		oldx, oldy, oldd;
	uint8_t 		mu, ml, md, mr, mdir;
	bool			mdie;
	bool			possible[4];
	uint8_t 		newx = 0;
	uint8_t 		newy = 0;

	if (NbMonsters > 0)
		{
		for (cnt = 0; cnt < NbMonsters; cnt++)
			{
			if (Monsters[cnt].die == false)
				{
				get_map_code();
				rescan_monsters();

				// if a rocks or diamond fall on monster he have to die
				if ((Monsters[cnt].u == c_diam) || (Monsters[cnt].u == c_rock))
					{
					// the monster have to die in explosion
					Monsters[cnt].die	= true;
					ExplodeCoords[cnt].x = Monsters[cnt].x;
					ExplodeCoords[cnt].y = Monsters[cnt].y;
					ExplodeCoords[cnt].spr = ExploPic[0];
					Map_Level[ExplodeCoords[cnt].y][ExplodeCoords[cnt].x] = ExplodeCoords[cnt].spr;
					return 0;
					}

				possible[0] 		= possible[1] = possible[2] = possible[3] = false;
				oldx				= Monsters[cnt].x;
				oldy				= Monsters[cnt].y;

				// check if monster codes go out of screen and check code arround monster
				if(oldy == 0) mu = 0; else mu = Map_Code[Monsters[cnt].y - 1][Monsters[cnt].x]; // code up
				if((oldx + 1) > MaxLX) mr = 0; else mr = Map_Code[Monsters[cnt].y][Monsters[cnt].x + 1]; // code right
				if((oldy + 1) > MaxLY) md = 0; else md = Map_Code[Monsters[cnt].y + 1][Monsters[cnt].x]; // code down
				if(oldx == 0) ml = 0; else ml = Map_Code[Monsters[cnt].y][Monsters[cnt].x - 1]; // code left 
				mdie = Monsters[cnt].die;
				mdir = Monsters[cnt].dir;

				// if the monster stay we check for a workable direction
				if (mdir == 5)
					{
					//up
					if ((mu == c_blank) || (mu == c_hero)){
						possible[0] 		= true;}

					//right
					if ((mr == c_blank) || (mr == c_hero)){
						possible[1] 		= true;}

					//down
					if ((md == c_blank) || (md == c_hero)){
						possible[2] 		= true;}

					//left
					if ((ml == c_blank) || (ml == c_hero)){
						possible[3] 		= true;}
					}

				//we check if we can move and then choose a position
				if ((mdir == 5) && ((possible[0] == true) || (possible[1] == true) || (possible[2] == true) ||
					 (possible[3] == true)))
					{
					// at least one direction is possible , random the direction ...
					// after a short loop if no direction was given , the monster continue to stay
					nbloop				= 50;

					while (nbloop > 1)
						{
						if (((rand() % 100) < 25) && (possible[0] == true))
							mdir = 1; // up is choosen

						if (((rand() % 100) >= 25) && ((rand() % 100) < 50) && (possible[1] == true))
							mdir = 2; // right is choosen

						if (((rand() % 100) >= 50) && ((rand() % 100) < 75) && (possible[2] == true))
							mdir = 3; // down is choosen

						if (((rand() % 100) >= 25) && (possible[3] == true))
							mdir = 4; // left is choosen

						nbloop--;

						if (mdir != 5)
							nbloop = 0; //we have a direction , go out of this loop ...
						}
					}

				// 1:up 2:right 3:down 4:left 5:stay
				// if the monster still stay we can't move , else we go to the
				// found direction and check if this direction is still ok
				if (mdir != 5)
					{

					if ((mdir == 1) && (mu == c_blank))
						{
						// we can go up
						Monsters[cnt].y 	= Monsters[cnt].y - 1;
						Monsters[cnt].dir	= mdir;
						}
					else if ((mdir == 2) && (mr == c_blank))
						{
						// we can go right
						Monsters[cnt].x 	= Monsters[cnt].x + 1;
						Monsters[cnt].dir	= mdir;
						}
					else if ((mdir == 3) && (md == c_blank))
						{
						// we can go down
						Monsters[cnt].y 	= Monsters[cnt].y + 1;
						Monsters[cnt].dir	= mdir;
						}
					else if ((mdir == 4) && (ml == c_blank))
						{
						// we can go left
						Monsters[cnt].x 	= Monsters[cnt].x - 1;
						Monsters[cnt].dir	= mdir;
						}
					else 
						{
						// all direction blocked
						mdir				= 5;
						Monsters[cnt].dir	= mdir;
						}
					}

				newx				= Monsters[cnt].x;
				newy				= Monsters[cnt].y;

				if ((newx != oldx) || (newy != oldy))
					{
					//the monster have move
					Map_Level[oldy][oldx] = BlankCase;
					}

				// increment the monster sprite and set it into the map
				// type 1
				if (Monsters[cnt].type == 1)
					{
					if ((Monsters[cnt].spr + 1) <= Monster1Pic[LastMonsterPic])
						Monsters[cnt].spr++;
					else 
						Monsters[cnt].spr = Monster1Pic[0];
					}

				// type 2
				if (Monsters[cnt].type == 2)
					{
					if ((Monsters[cnt].spr + 1) <= Monster2Pic[LastMonsterPic])
						Monsters[cnt].spr++;
					else 
						Monsters[cnt].spr = Monster2Pic[0];
					}

				// type 3
				if (Monsters[cnt].type == 3)
					{
					if ((Monsters[cnt].spr + 1) <= Monster3Pic[LastMonsterPic])
						Monsters[cnt].spr++;
					else 
						Monsters[cnt].spr = Monster3Pic[0];
					}

				//put the monster sprite in map
				Map_Level[Monsters[cnt].y][Monsters[cnt].x] = Monsters[cnt].spr;

				// check if monster codes go out of screen and check code arround monster
				if(newy == 0) mu = 0; else mu = Map_Code[Monsters[cnt].y - 1][Monsters[cnt].x]; // code up
				if((newx + 1) > MaxLX) mr = 0; else mr = Map_Code[Monsters[cnt].y][Monsters[cnt].x + 1]; // code right
				if((newy + 1) > MaxLY) md = 0; else md = Map_Code[Monsters[cnt].y + 1][Monsters[cnt].x]; // code down
				if(newx == 0) ml = 0; else ml = Map_Code[Monsters[cnt].y][Monsters[cnt].x - 1]; // code left 

				//check if the monster get the hero
				if (Monsters[cnt].u == c_hero)
					Hero.die = true;

				if (Monsters[cnt].r == c_hero)
					Hero.die = true;

				if (Monsters[cnt].d == c_hero)
					Hero.die = true;

				if (Monsters[cnt].l == c_hero)
					Hero.die = true;
				}
			}
		}

	return 0;
}


void dynamite(void)
{
	//if a dynamite was dropped , we animate the sprite
	// up it have to explode
	// check if a dynamite have to explode else we increment it's sprite number
	if ((DynCoord.spr + 1) > DynamPic[LastDynamPic])
		{
		// explosion can go and dynamite can be erased
		DynCoord.spr		= 0;
		ExplodeCoords[0].x	= DynCoord.x;
		ExplodeCoords[0].y	= DynCoord.y;
		ExplodeCoords[0].spr = ExploPic[0];
		explosion(0);								// dynamite explosion everytime start at 0
		}
	else 
		{
		DynCoord.spr++;
		Map_Level[DynCoord.y][DynCoord.x] = DynCoord.spr;

		//		get_map_code();
		}
}


void rescan_explosion(uint8_t explonum)
{
	//up
	if ((ExplodeCoords[explonum].y - 1) > -1)
		ExplodeCoords[explonum].u = Map_Code[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x];
	else 
		ExplodeCoords[explonum].u = 0;

	//up left
	if (((ExplodeCoords[explonum].y - 1) > -1) && ((ExplodeCoords[explonum].x - 1) > -1))
		ExplodeCoords[explonum].ul = Map_Code[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x - 1];
	else 
		ExplodeCoords[explonum].ul = 0;

	//up right
	if (((ExplodeCoords[explonum].y - 1) > -1) && ((ExplodeCoords[explonum].x + 1) <= MaxLX))
		ExplodeCoords[explonum].ur = Map_Code[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x + 1];
	else 
		ExplodeCoords[explonum].ur = 0;

	//right
	if ((ExplodeCoords[explonum].x + 1) <= MaxLX)
		ExplodeCoords[explonum].r = Map_Code[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x + 1];
	else 
		ExplodeCoords[explonum].r = 0;

	//left
	if ((ExplodeCoords[explonum].x - 1) > -1)
		ExplodeCoords[explonum].l = Map_Code[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x - 1];
	else 
		ExplodeCoords[explonum].l = 0;

	//down
	if ((ExplodeCoords[explonum].y + 1) <= MaxLY)
		ExplodeCoords[explonum].d = Map_Code[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x];
	else 
		ExplodeCoords[explonum].d = 0;

	//down left
	if (((ExplodeCoords[explonum].y + 1) <= MaxLY) && ((ExplodeCoords[explonum].x - 1) > -1))
		ExplodeCoords[explonum].dl = Map_Code[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x - 1];
	else 
		ExplodeCoords[explonum].dl = 0;

	//down right
	if (((ExplodeCoords[explonum].y + 1) <= MaxLY) && ((ExplodeCoords[explonum].x + 1) <= MaxLX))
		ExplodeCoords[explonum].dr = Map_Code[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x + 1];
	else 
		ExplodeCoords[explonum].dr = 0;
}


void explosion(uint8_t explonum)
{
	//show explosion and at end fill it with diamonds
	//we have to take care on screen border !
	rescan_explosion(explonum);

	//explosion sprites
	if (ExplodeCoords[explonum].ul != 0)
		Map_Level[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x - 1] = ExplodeCoords[explonum].spr;

	if (ExplodeCoords[explonum].u != 0)
		Map_Level[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x] = ExplodeCoords[explonum].spr;

	if (ExplodeCoords[explonum].ur != 0)
		Map_Level[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x + 1] = ExplodeCoords[explonum].spr;

	if (ExplodeCoords[explonum].l != 0)
		Map_Level[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x - 1] = ExplodeCoords[explonum].spr;

	Map_Level[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x] = ExplodeCoords[explonum].spr;

	if (ExplodeCoords[explonum].r != 0)
		Map_Level[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x + 1] = ExplodeCoords[explonum].spr;

	if (ExplodeCoords[explonum].dl != 0)
		Map_Level[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x - 1] = ExplodeCoords[explonum].spr;

	if (ExplodeCoords[explonum].d != 0)
		Map_Level[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x] = ExplodeCoords[explonum].spr;

	if (ExplodeCoords[explonum].dr != 0)
		Map_Level[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x + 1] = ExplodeCoords[explonum].spr;

	//increment explosion sprite number.
	//if the explosion finish we put diamonds in place and cancel this explosion
	if ((ExplodeCoords[explonum].spr + 1) > ExploPic[LastExploPic])
		{
		//explosion finish , we fill the explosion place with diamonds
		ExplodeCoords[explonum].spr = 0;

		//diamonds sprites
		if (ExplodeCoords[explonum].ul != 0)
			Map_Level[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x - 1] = Diam1Pic[0];

		if (ExplodeCoords[explonum].u != 0)
			Map_Level[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x] = Diam1Pic[0];

		if (ExplodeCoords[explonum].ur != 0)
			Map_Level[ExplodeCoords[explonum].y - 1][ExplodeCoords[explonum].x + 1] = Diam1Pic[0];

		if (ExplodeCoords[explonum].l != 0)
			Map_Level[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x - 1] = Diam3Pic[0];

		Map_Level[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x] = Diam3Pic[0];

		if (ExplodeCoords[explonum].r != 0)
			Map_Level[ExplodeCoords[explonum].y][ExplodeCoords[explonum].x + 1] = Diam3Pic[0];

		if (ExplodeCoords[explonum].dl != 0)
			Map_Level[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x - 1] = Diam5Pic[0];

		if (ExplodeCoords[explonum].d != 0)
			Map_Level[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x] = Diam5Pic[0];

		if (ExplodeCoords[explonum].dr != 0)
			Map_Level[ExplodeCoords[explonum].y + 1][ExplodeCoords[explonum].x + 1] = Diam5Pic[0];

		init_rocks();
		init_diamonds();

		//it's time to recran the whole level
		get_map_code();

		// if it was the explosion number 0 , we can pose another dynamite
		Pose_Dynamite		= false;

		}
	else 
		{
		//increment explosion sprite number
		ExplodeCoords[explonum].spr++;
		}
}


void debug_sprite(void)
{
	char			numstr[20];
	uint8_t 		mu, ml, md, mr, mdir;

	gfx_SetColor(gfx_white);
	gfx_FillRectangle(0, 193, 320, 48);
	gfx_SetTextFGColor(gfx_black);
	gfx_SetTextBGColor(gfx_white);

	// monster 0
	mu					= Monsters[0].u;
	ml					= Monsters[0].l;
	md					= Monsters[0].d;
	mr					= Monsters[0].r;
	sprintf(numstr, "%d", mu);
	gfx_PrintStringXY(numstr, 50, 200);
	sprintf(numstr, "%d", ml);
	gfx_PrintStringXY(numstr, 10, 210);
	sprintf(numstr, "%d", mr);
	gfx_PrintStringXY(numstr, 80, 210);
	sprintf(numstr, "%d", md);
	gfx_PrintStringXY(numstr, 50, 220);

	// monster 1
	mu					= Monsters[1].u;
	ml					= Monsters[1].l;
	md					= Monsters[1].d;
	mr					= Monsters[1].r;
	sprintf(numstr, "%d", mu);
	gfx_PrintStringXY(numstr, 150, 200);
	sprintf(numstr, "%d", ml);
	gfx_PrintStringXY(numstr, 110, 210);
	sprintf(numstr, "%d", mr);
	gfx_PrintStringXY(numstr, 180, 210);
	sprintf(numstr, "%d", md);
	gfx_PrintStringXY(numstr, 150, 220);

	// hero		
	//scan arround the hero
	Hero.u				= Map_Code[Hero.y - 1][Hero.x];
	Hero.l				= Map_Code[Hero.y][Hero.x - 1];
	Hero.r				= Map_Code[Hero.y][Hero.x + 1];
	Hero.d				= Map_Code[Hero.y + 1][Hero.x];

	//up
	sprintf(numstr, "%d", Hero.u);
	gfx_PrintStringXY(numstr, 250, 200);

	//left
	sprintf(numstr, "%d", Hero.l);
	gfx_PrintStringXY(numstr, 210, 210);

	//right
	sprintf(numstr, "%d", Hero.r);
	gfx_PrintStringXY(numstr, 280, 210);

	//down
	sprintf(numstr, "%d", Hero.d);
	gfx_PrintStringXY(numstr, 250, 220);

	sprintf(numstr, "%d", Hero.dyn);
	gfx_PrintStringXY(numstr, 210, 220);

	if (Pose_Dynamite == true)
		{
		sprintf(numstr, "d%d", 1);
		gfx_PrintStringXY(numstr, 280, 220);
		}
	else 
		{
		sprintf(numstr, "d%d", 0);
		gfx_PrintStringXY(numstr, 280, 220);
		}
}


void decode_score(void)
{
	gfx_Sprite(((gfx_sprite_t *) var_gfx[Diam1Pic[0]]), 300 - (6 * Sprite_W), 196);

	if (Score < 10)
		{
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[Score]]), 300, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - Sprite_W, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (2 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (3 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (4 * Sprite_W), 196);
		}

	if ((Score >= 10) && (Score < 100))
		{
		decscore[0] 		= Score % 10;
		decscore[1] 		= Score / 10;
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]]), 300, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]]), 300 - Sprite_W, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (2 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (3 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (4 * Sprite_W), 196);
		}

	if ((Score >= 100) && (Score < 1000))
		{
		decscore[0] 		= Score % 10;
		decscore[1] 		= (Score % 100) / 10;
		decscore[2] 		= (Score / 100);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]]), 300, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]]), 300 - Sprite_W, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[2]]]), 300 - (2 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (3 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (4 * Sprite_W), 196);
		}

	if ((Score >= 1000) && (Score < 10000))
		{
		decscore[0] 		= Score % 10;
		decscore[1] 		= (Score % 100) / 10;
		decscore[2] 		= (Score % 1000) / 100;
		decscore[3] 		= (Score / 1000);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]]), 300, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]]), 300 - Sprite_W, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[2]]]), 300 - (2 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[3]]]), 300 - (3 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[0]]), 300 - (4 * Sprite_W), 196);
		}

	if ((Score >= 10000) && (Score <= 99999))
		{
		decscore[0] 		= Score % 10;
		decscore[1] 		= (Score % 100) / 10;
		decscore[2] 		= (Score % 1000) / 100;
		decscore[3] 		= (Score % 10000) / 1000;
		decscore[4] 		= (Score / 10000);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]]), 300, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]]), 300 - Sprite_W, 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[2]]]), 300 - (2 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[3]]]), 300 - (3 * Sprite_W), 196);
		gfx_Sprite(((gfx_sprite_t *) var_gfx[NumbersPic[decscore[4]]]), 300 - (4 * Sprite_W), 196);
		}
}


