

#ifndef __MAIN_H
#define __MAIN_H
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdbool.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tice.h>

#include <graphx.h>
#include <fileioc.h>
#include <keypadc.h>


// Include the graphics
#include "gfx/all_gfx.h"
#include "gfx/var_gfx.h"

// Data Types
// Rocks & Diamonds & Dynamite Structure
typedef struct 
{
	int16_t 		x;
	int16_t 		y;
	uint8_t 		spr;
	uint8_t 		dir;							// 1:down 2:left down 3:right down
	uint8_t 		type;							// rocks or diamonds type 1 to nn
	uint8_t 		r;
	uint8_t 		dr;
	uint8_t 		d;
	uint8_t 		dl;
	uint8_t 		l;
} rockdynst;


// Hero Structure
typedef struct 
{
	int16_t 		x;
	int16_t 		y;
	uint8_t 		dir;							// 1:up 2:right 3:down 4:left 5:stay
	uint8_t 		spr;
	uint8_t 		dyn;							// number of dynamites for Hero
	uint8_t 		type;							// monster type 1 to nn
	bool			die;							// true if monter died
	uint8_t 		u;
	uint8_t 		ur;
	uint8_t 		r;
	uint8_t 		dr;
	uint8_t 		d;
	uint8_t 		dl;
	uint8_t 		l;
	uint8_t 		ul;
} herost;


// 2D Coordinates utilities structure
typedef struct 
{
	uint8_t 		x;								//Coord X
	uint8_t 		y;								//Coord Y
	uint8_t 		spr;							//if sprite needed here
	uint8_t 		u;
	uint8_t 		ur;
	uint8_t 		r;
	uint8_t 		dr;
	uint8_t 		d;
	uint8_t 		dl;
	uint8_t 		l;
	uint8_t 		ul;
} coord2D;

// Because some stranges things happens with #define i use const uint... in place ;)

const uint8_t	MaxRocks = 180;
const uint8_t	MaxDiamonds = 180;
const uint8_t	MaxMonster = 10;
const uint8_t	MaxExplosion = 11;
const uint8_t	Level_W = 20;
const uint8_t	Level_H = 12;
const uint8_t	MaxLX = Level_W - 1;
const uint8_t	MaxLY = Level_H - 1;
const uint8_t	Sprite_W = 16;
const uint8_t	Sprite_H = 16;

const uint8_t	MaxDiamPic = 2;
const uint8_t	MaxRocksPic = 4;
const uint8_t	MaxDynamPic = 8;
const uint8_t	MaxExploPic = 8;
const uint8_t	MaxWallPic = 4;
const uint8_t	MaxSandPic = 4;
const uint8_t	MaxDoorPic = 4;
const uint8_t	MaxDirectionPic = 4;
const uint8_t	MaxMonsterPic = 4;

const uint8_t	LastDiamPic = 1;
const uint8_t	LastRocksPic = 3;
const uint8_t	LastDynamPic = 7;
const uint8_t	LastExploPic = 7;
const uint8_t	LastWallPic = 3;
const uint8_t	LastSandPic = 3;
const uint8_t	LastDoorPic = 3;
const uint8_t	LastDirectionPic = 3;
const uint8_t	LastMonsterPic = 3;

const uint8_t	Monster_Type_1 = 1;
const uint8_t	Monster_Type_2 = 2;
const uint8_t	Monster_Type_3 = 3;
const uint8_t	Diam_Type_1 = 1;
const uint8_t	Diam_Type_2 = 2;
const uint8_t	Diam_Type_3 = 3;
const uint8_t	Diam_Type_4 = 4;
const uint8_t	Diam_Type_5 = 5;

const uint8_t	BlankCase = 65;
const uint8_t	HeroCase = 64;
const uint8_t	Hero_dont_move = 64;

// defines the map elements codes
const uint8_t	c_blank = 1;
const uint8_t	c_sand = 2;
const uint8_t	c_diam = 3;
const uint8_t	c_wall = 4;
const uint8_t	c_rock = 5;
const uint8_t	c_hero = 6;
const uint8_t	c_monster = 7;
const uint8_t	c_door = 8;
const uint8_t	c_dyn = 9;
const uint8_t	c_exp = 10;

rockdynst		Rocks[MaxRocks];
rockdynst		Diams[MaxDiamonds];
herost			Hero;
herost			Monsters[MaxMonster];

// Define 5 Diamonds Pictures Number
const uint8_t	Diam1Pic[MaxDiamPic] =
{
	8, 9
};


const uint8_t	Diam2Pic[MaxDiamPic] =
{
	10, 11
};


const uint8_t	Diam3Pic[MaxDiamPic] =
{
	66, 67
};


const uint8_t	Diam4Pic[MaxDiamPic] =
{
	68, 69
};


const uint8_t	Diam5Pic[MaxDiamPic] =
{
	70, 71
};


// Rocks Pictures Number
const uint8_t	RocksPic[MaxRocksPic] =
{
	12, 13, 14, 15
};


// Dynamite Pictures number
const uint8_t	DynamPic[MaxDynamPic] =
{
	16, 17, 18, 19, 20, 21, 22, 23
};


// Explosion Pictures number
const uint8_t	ExploPic[MaxExploPic] =
{
	24, 25, 26, 27, 28, 29, 30, 31
};


// Sand Picture number
const uint8_t	SandPic[MaxSandPic] =
{
	0, 1, 2, 3
};


// Wall Picture number
const uint8_t	WallPic[MaxWallPic] =
{
	4, 5, 6, 7
};


// Door Pictures number
const uint8_t	DoorPic[MaxDoorPic] =
{
	44, 45, 46, 47
};


// Hero Pictures number
const uint8_t	Hero_go_down[MaxDirectionPic] =
{
	64, 64, 64, 64
};


const uint8_t	Hero_go_up[MaxDirectionPic] =
{
	64, 64, 64, 64
};


const uint8_t	Hero_go_left[MaxDirectionPic] =
{
	48, 49, 50, 51
};


const uint8_t	Hero_push_left[MaxDirectionPic] =
{
	52, 53, 54, 55
};


const uint8_t	Hero_go_right[MaxDirectionPic] =
{
	56, 57, 58, 59
};


const uint8_t	Hero_push_right[MaxDirectionPic] =
{
	60, 61, 62, 63
};


// Define the 3 monster type pictures number
const uint8_t	Monster1Pic[MaxMonsterPic] =
{
	32, 33, 34, 35
};


const uint8_t	Monster2Pic[MaxMonsterPic] =
{
	36, 37, 38, 39
};


const uint8_t	Monster3Pic[MaxMonsterPic] =
{
	40, 41, 42, 43
};


// Other sprites
const uint8_t	CoeurPic = 72;
const uint8_t	ch_SpacePic = 73;
const uint8_t	NumbersPic[10] =
{
	74, 75, 76, 77, 78, 79, 80, 81, 82, 83
};


// Other variables
coord2D 		HeroStart; //Starting Position from the Hero in a Level
coord2D 		DynCoord; //Dynamite Coordinate
coord2D 		DoorCase; //Case position from the outgoing door
coord2D 		ExplodeCoords[MaxExplosion]; //Coordinates for explosion
uint8_t 		LevelGet[Level_H * Level_W];
uint8_t 		Map_Level[Level_H][Level_W]; // 0..11 Lines , 0..19 Columns used to put the sprites on screen
uint8_t 		Map_Code[Level_H][Level_W]; // codes to know if the hero / monster / rocks & diamonds can move arround

// Codes used in Map_Code array
// 1 : empty
// 2 : sand
// 3 : diamonds
// 4 : wall
// 5 : rocks
// 6 : hero
// 7 : monster
// 8 : door
// 9 : dynamite
// 10: explosion

bool			Pose_Dynamite; // true if we have drop a dynamite and explosion is not finish
int16_t 		NbMonsters; // Number of monsters in the level
int16_t 		NbDiam; // Number of Diamonds in the level
int16_t 		NbRocks; // Number of Rocks in the level
uint24_t		Score; // Player Score
uint8_t 		decscore[5]; // Score decoder for show numbers with sprites
uint8_t 		Lives; // Number of player Lives
uint8_t 		Level_Number; // Actual Level number
bool			endgame; // true if game ends
int16_t 		foundrock;
int16_t 		foundwall;
int8_t			foundmonster;
uint8_t 		Seconds; //Time counts for finish the level
uint24_t		intcnt; //cycle counter
sk_key_t		ActKey; //Key actually pressed

// Declare variables for Level Map files
uint16_t		LastLevel;




// Functions declaration
uint8_t init_game(void);
uint8_t setmap(uint16_t numlevel);
void redraw_map(void);
void get_map_elements(void);
void get_map_code(void);
void rescan_rocks(void);
void check_rocks(void);
void rescan_diamonds(void);
void check_diamonds(void);
void init_rocks(void);
void init_diamonds(void);
void init_hero(void);
void init_monster(void);
void rescan_monsters(void);
void rescan_hero(void);
bool hero_move(uint8_t newd);
bool monster_move(void);
void debug_sprite(void);
void dynamite(void);
void rescan_explosion(uint8_t explonum);
void explosion(uint8_t explonum);
void decode_score(void);
void file_error(uint8_t errnum);

#endif // __MAIN_H //

