/*
 *---------------------------------------------------------------------------------------------------------------------
 * Program Name                 : Runner , (Lode Runner clone)
 * Author                               : Fabrice Muller
 * TI-Planet nickname          : DarthVader
 * License                              : Freeware
 * Game Description           : Really ?? !
 * Version                              : 1.7
 * Date                                  : 2018-01-05
 * 
 * How to play
 * 
 * At start you have to choose the level type you want to play
 * They are 4 type of levels :
 * 1 : Classic
 * 2 : Championship
 * 3 : Professional
 * 4 : Personal  , this levels are the one you can make yourself with the level editor
 *      For make your personal levels , start the level editor and load the 'lvlpro.bin' file
 *      Set the scroll bar at 150 , from here you can use your own levels.
 * 5 : Return here , if you choose a level type and change your mind , press '5' or 
 * 'Clear' and you will come back to the main menu to choose another levels type.
 * 
 * When you have choose the levels type to play then 
 * Use left , right key for choose the level , press Enter key to start at this level or
 * press '5' or 'Clear' to come back in main menu.
 * 
 * In game , use the directional key for move , 
 * the keys '2nd' or '1' dig a hole at left
 * the keys 'mode' or '3' dig a hole at right
 * 
 * You can exit the game with the Del or Clear keys
 * 
 * The game rules are simple , get all gold chest !! , the bad guy's can take them
 * too , for get them back you have to block the bad guy's with a red point over
 * the head in a hole , they will then loose the gold chest at they actual position.
 *---------------------------------------------------------------------------------------------------------------------
 */

#include "main.h"

void main( void ) {
    uint8_t cnt = 0; //just a counter ....
    uint8_t cntfire = 0; // fire hole counter
    uint8_t filestuff;
    uint8_t playerdir = 0; // player or bad guy direction
    uint8_t playercnt = 1; // player animation counter
    uint8_t badguycnt = 1; // bad guy animation counter
    uint8_t cntx = 0;
    uint8_t cnty = 0;
    uint16_t startmenu = 500;

    init_game( );

    // Select the Starting Level
    while (startmenu == 500)
        startmenu = menu( );

    // Load and draw the selected map
    filestuff = setmap( Level_Number );

    //check if it was error in file
    if (filestuff != 0)
        file_error( filestuff );

    //Seed the random numbers
    srand( rtc_Time( ) );

    // Game loop
    while (!endgame) {
        playercnt++;
        badguycnt++;
        if (playercnt > PlayerSpeed) playercnt = 1;
        if (badguycnt > GardSpeed) badguycnt = 1;

        // Bad guy sprites animations
        if (badguycnt == 1) {
            for (cnt = 10; cnt < MaxPlayer; cnt++)
                animate_player( cnt );
        }

        // Player sprites animations
        if (playercnt == 1) {
            animate_player( 0 );

            // Check if we shooted one or more hole
            for (cnt = 0; cnt < HeroMaxShoot; cnt++)
                if (HeroShoot[cnt].holeaction == true) {
                    // We have a Hole Trap in process here
                    animate_hole( cnt );
                }
        }

        // move the player
        if (playercnt == 3) {

            ActKey = os_GetCSC( );

            playerdir = 0;
            shootleft = false;
            shootright = false;
            rescan_player( 0 ); // scan arround the player

            if (( ActKey == sk_Del ) || ( ActKey == sk_Clear ))
                endgame = true;
            if (ActKey == sk_Up)
                playerdir = 1;
            if (ActKey == sk_Right)
                playerdir = 2;
            if (ActKey == sk_Down)
                playerdir = 3;
            if (ActKey == sk_Left)
                playerdir = 4;
            if (( ActKey == sk_2nd ) || ( ActKey == sk_1 ))
                shootleft = true;
            if (( ActKey == sk_Mode ) || ( ActKey == sk_3 ))
                shootright = true;

            // test all direction
            go_left = walk_ok( 0, dLeft );
            go_right = walk_ok( 0, dRight );
            go_up = climb_ok( 0, dUp );
            go_down = climb_ok( 0, dDown );
            go_rope = rope_ok( 0, 0 );
            go_ropeleft = rope_ok( 0, dLeft );
            go_roperight = rope_ok( 0, dRight );
            go_fall = fall_ok( 0 );

            // Move the player
            switch (playerdir) {
                case 1: // up
                    if (Players[0].dir != dFall) {
                        if (go_up) {
                            Players[0].dir = dUp;
                        } else {
                            if (( Players[0].cy == 0 ) && ( showoutput == true ))
                                nextlevel = true;
                            else
                                Players[0].dir = dStay;
                        }
                    }
                    break;
                case 2: // right
                    if (!go_fall) {
                        if (go_right) {
                            if (go_roperight) {
                                Players[0].dir = dRopeR;
                            } else {
                                Players[0].dir = dRight;
                            }
                        } else {
                            Players[0].dir = dStay;
                        }
                    }
                    if (go_fall) {
                        if (go_rope) {
                            Players[0].dir = dRopeR;
                        } else {
                            Players[0].dir = dFall;
                        }
                    }
                    break;
                case 3: // down
                    if (!go_fall) {
                        if (( go_down ) && ( Players[0].b_d == false ))
                            Players[0].dir = dDown;
                        else
                            Players[0].dir = dStay;
                    }
                    if (( go_fall ) && ( go_rope )) {
                        Players[0].dir = dFall;
                    }
                    if (( go_fall ) && ( !go_rope )) {
                        Players[0].dir = dFall;
                    }
                    break;
                case 4: // left
                    if (!go_fall) {
                        if (go_left) {
                            if (go_ropeleft) {
                                Players[0].dir = dRopeL;
                            } else {
                                Players[0].dir = dLeft;
                            }
                        } else {
                            Players[0].dir = dStay;
                        }
                    }
                    if (go_fall) {
                        if (go_rope) {
                            Players[0].dir = dRopeL;
                        } else {
                            Players[0].dir = dFall;
                        }
                    }
                    break;
            }

            if (( playerdir == 0 ) && ( Players[0].dir != dFall )) Players[0].dir = dStay;

            // here we check if we have to fall down
            if (( Players[0].dir == dFall ) && ( go_fall )) {
                if (( go_rope ) && ( playerdir != dDown )) // check if we get a rope on the way down
                    Players[0].dir = dRopeR;
                else
                    Players[0].dir = dFall;
            } else if (( Players[0].dir == dFall ) && ( !go_fall )) { // we check for floor or something that stop falling
                Players[0].dir = dStay;
            }

            if (shootleft == true)
                fire( dLeft );

            if (shootright == true)
                fire( dRight );

            // Check if we got a gold chest on actual position
            if (Players[0].base == c_gold) {
                //we get a gold chest , update the  code array
                Level[Players[0].cy][Players[0].cx].code = c_empty;
                Level[Players[0].cy][Players[0].cx].spr = Empty;
                Level[Players[0].cy][Players[0].cx].blocking = false;
                show_after_gold( 0 );
                Score++;
                get_map_gold( );
                if (NbGold == 0) {
                    // no more gold on this level we can show the output ladder
                    showoutput = true;
                    show_output( );
                }
            }

            // this decode and show Score with sprites.
            decode_score( );

            // heart and lives
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), 10, CharWriteY );
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), 30, CharWriteY );
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[CoeurPic] ), 10, CharWriteY );
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[Lives]] ), 30, CharWriteY );

#if defined PLAYER_DEBUG
            debug_player( 0 );
#endif

            Players[0].olddir = Players[0].dir;
        }

        // move the bad guy
        if (badguycnt == 3) {
            for (cnt = 10; cnt < MaxPlayer; cnt++) {
                if (Players[cnt].die == false) {
                    playerdir = 0;
                    rescan_player( cnt ); // scan arround this bad guy

                    playerdir = artificial_stupidity( cnt );

                    // test all direction
                    go_left = walk_ok( cnt, dLeft );
                    go_right = walk_ok( cnt, dRight );
                    go_up = climb_ok( cnt, dUp );
                    go_down = climb_ok( cnt, dDown );
                    go_rope = rope_ok( cnt, 0 );
                    go_ropeleft = rope_ok( cnt, dLeft );
                    go_roperight = rope_ok( cnt, dRight );
                    go_fall = fall_ok( cnt );

                    // Move the bad guy
                    switch (playerdir) {
                        case 1: // up
                            if (Players[cnt].dir != dFall) {
                                if (go_up) {
                                    Players[cnt].dir = dUp;
                                } else {
                                    if (( Players[cnt].cy == 0 ) && ( showoutput == true ))
                                        nextlevel = true;
                                    else
                                        Players[cnt].dir = dStay;
                                }
                            }
                            break;
                        case 2: // right
                            if (!go_fall) {
                                if (go_right) {
                                    if (go_roperight) {
                                        Players[cnt].dir = dRopeR;
                                    } else {
                                        Players[cnt].dir = dRight;
                                    }
                                } else {
                                    Players[cnt].dir = dStay;
                                }
                            }
                            if (go_fall) {
                                if (go_rope) {
                                    Players[cnt].dir = dRopeR;
                                } else {
                                    Players[cnt].dir = dFall;
                                }
                            }
                            break;
                        case 3: // down
                            if (!go_fall) {
                                if (( go_down ) && ( Players[cnt].b_d == false ))
                                    Players[cnt].dir = dDown;
                                else
                                    Players[cnt].dir = dStay;
                            }
                            if (( go_fall ) && ( go_rope )) {
                                Players[cnt].dir = dFall;
                            }
                            if (( go_fall ) && ( !go_rope )) {
                                Players[cnt].dir = dFall;
                            }
                            break;
                        case 4: // left
                            if (!go_fall) {
                                if (go_left) {
                                    if (go_ropeleft) {
                                        Players[cnt].dir = dRopeL;
                                    } else {
                                        Players[cnt].dir = dLeft;
                                    }
                                } else {
                                    Players[cnt].dir = dStay;
                                }
                            }
                            if (go_fall) {
                                if (go_rope) {
                                    Players[cnt].dir = dRopeL;
                                } else {
                                    Players[cnt].dir = dFall;
                                }
                            }
                            break;
                    }

                    if (( playerdir == 0 ) && ( Players[cnt].dir != dFall )) Players[cnt].dir = dStay;

                    // here we check if we have to fall down
                    if (( Players[cnt].dir == dFall ) && ( go_fall )) {
                        if (( go_rope ) && ( playerdir != dDown )) // check if we get a rope on the way down
                            Players[cnt].dir = dRopeR;
                        else
                            Players[cnt].dir = dFall;
                    } else if (( Players[cnt].dir == dFall ) && ( !go_fall )) { // we check for floor or something that stop falling
                        // if we fall down we check if we landed
                        Players[cnt].dir = dStay;
                    }
                    Players[cnt].olddir = Players[cnt].dir;
                }

                // Check if the bad guy get a gold chest on actual position
                if (( Players[cnt].base == c_gold ) && ( Players[cnt].gold == false )) {
                    //we get a gold chest , update the  code array
                    Level[Players[cnt].cy][Players[cnt].cx].code = c_empty;
                    Level[Players[cnt].cy][Players[cnt].cx].spr = Empty;
                    Level[Players[cnt].cy][Players[cnt].cx].blocking = false;
                    Players[cnt].gold = true;
                    show_after_gold( cnt );
                }
            }
        }

        // we check if a bad guy is in a holetrap
        if (badguycnt == 4) {
            for (cnt = 10; cnt < MaxPlayer; cnt++) {
                if (Players[cnt].die == false) {
                    rescan_player( cnt );
                    for (cntfire = 0; cntfire < HeroMaxShoot; cntfire++) {
                        if (HeroShoot[cntfire].holeaction == true) {
                            if (( Players[cnt].cx == HeroShoot[cntfire].x ) && ( Players[cnt].cy == HeroShoot[cntfire].y )) {
                                // bad guy is in a trap hole
                                Level[HeroShoot[cntfire].y][HeroShoot[cntfire].x].blocking = true;
                                Level[HeroShoot[cntfire].y][HeroShoot[cntfire].x].code = c_holetrapb;
                                // if the bad guy have a gold chest we give it back
                                if (Players[cnt].gold == true) {
                                    Players[cnt].gold = false;
                                    Level[Players[cnt].cy - 1][Players[cnt].cx].code = c_gold;
                                    Level[Players[cnt].cy - 1][Players[cnt].cx].spr = GoldSpr;
                                }
                            }
                        }
                    }
                }
            }
        }

        // check if bad guy's kill the player
        for (cnt = 10; cnt < MaxPlayer; cnt++) {
            if (Players[cnt].die == false) {
                if (( Players[cnt].cx == Players[0].cx ) && ( Players[cnt].cy == Players[0].cy )) {
                    Lives--;
                    if (Lives == 0) {
                        endgame = true;
                    }
                    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[0].cy][Players[0].cx].spr] ), Players[0].cx * Sprite_W, Players[0].cy * Sprite_H );
                    Players[0].cx = Players[0].startx;
                    Players[0].cy = Players[0].starty;
                }
            }
        }

        // replace gold in level if needed after a bad guy loose it
        for (cnt = 10; cnt < MaxPlayer; cnt++) {
            if (Players[cnt].die == false) {
                if (Level[Players[cnt].cy - 1][Players[cnt].cx].code == c_gold)
                    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[cnt].cy - 1][Players[cnt].cx].spr] ), Players[cnt].cx * Sprite_W, ( Players[cnt].cy - 1 ) * Sprite_H );
            }
        }

#if defined PLAYER_DEBUG
        // for debug cycles numbers
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[playercnt]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 7 ) );
#endif

        //Swap the buffer with the screen
        gfx_BlitBuffer( );

        if (nextlevel) {
            get_next_level( );
        }
    }

    //End the graphics
    gfx_End( );
}

void file_error( uint8_t errnum ) {
    // Fill the screen red
    gfx_FillScreen( gfx_red );
    gfx_SetTextBGColor( gfx_red );
    gfx_SetTextFGColor( gfx_yellow );

    // write down the error for 3 seconds and end the game ...
    if (errnum == 1)
        gfx_PrintStringXY( "Cannot open file...", 0, 10 );

    if (errnum == 2)
        gfx_PrintStringXY( "Cannot read Lastlevel", 0, 10 );

    if (errnum == 3)
        gfx_PrintStringXY( "Cannot seek in file", 0, 10 );

    if (errnum == 4)
        gfx_PrintStringXY( "Cannot reading level", 0, 10 );

    if (errnum == 5)
        gfx_PrintStringXY( "Level number to high", 0, 10 );

    //Swap the buffer with the screen
    gfx_BlitBuffer( );
    endgame = true;
    delay( 3000 );
}

uint8_t init_game( void ) {
    uint8_t filestuff = 0;
    uint8_t cnt;

    Score = 0; // Player Score
    Lives = 5; // Number of player Lives
    Level_Number = 0; // Actual Level number
    endgame = false; // true if game ends
    shootleft = false;
    shootright = false;

    //Start the graphics routines
    gfx_Begin( );

    //Init all Sprites / Tiles / characters sprites
    var_gfx_init( );

    // Set up the palette for the sprite and characters sprites
    gfx_SetPalette( all_gfx_pal, sizeof_all_gfx_pal, 0 );

    // Draw to buffer to avoid tearing
    gfx_SetDrawBuffer( );
    gfx_SetColor( gfx_black );
    gfx_FillScreen( gfx_black );

    // reset all Hero shoot at start
    for (cnt = 0; cnt < HeroMaxShoot; cnt++)
        HeroShoot[cnt].holeaction = false;

    return 0; // everything was ok
}

uint8_t setmap( uint16_t numlevel ) {
    //Get the map from appvars
    int leveloffset = 0;
    uint16_t cnt, cntx, cnty;
    uint8_t nlevH, nlevL;
    ti_var_t LevelAppVar;
    uint16_t levelread = 0;

#if defined DEBUG_FILE
    char strnum[30]; // ****************** just for debug ******************
#endif

    char * appvarName = " ";

    NbBadGuy = 0;
    NbGold = 0;
    showoutput = false;

    go_left = false;
    go_right = false;
    go_up = false;
    go_down = false;
    go_rope = false;
    go_ropeleft = false;
    go_roperight = false;
    go_fall = false;

    // set all bad guy as dead first
    for (cnt = 10; cnt < MaxPlayer; cnt++)
        Players[cnt].die = true;

    // create the real levelread number depending on the file we
    // have to open.
    if (numlevel <= 199) {
        appvarName = " ";
        appvarName = "CLSCHAMP";
        levelread = numlevel;
    }

    if (numlevel > 489) return 5; // check this before we check >199

    if (numlevel > 199) {
        appvarName = " ";
        appvarName = "LVLPRO";
        levelread = numlevel - 200;
    }

    // Close any files that may be open already
    ti_CloseAll( );

    // Open the variable in read mode
    LevelAppVar = ti_Open( appvarName, "r" );

    // Make sure we opened okay
    if (!LevelAppVar)
        return 1; // Error occured ...

    ///Let's read the last level number first
    // Read MSB
    if (ti_Read( &nlevH, 1, 1, LevelAppVar ) != 1) {
        ti_CloseAll( );
        return 2; // Error reading Lastlevel
    }

    // Read LSB
    if (ti_Read( &nlevL, 1, 1, LevelAppVar ) != 1) {
        ti_CloseAll( );
        return 2; // Error reading Lastlevel
    }

    // Combine MSB and LSB
    LastLevel = ( nlevH << 8 ) + nlevL;

    // Copy the Map numlevel to tilemap
    if (levelread <= LastLevel) {
        //Now we have to set the Offset in file to read the selected level
        //        leveloffset = ( levelread * ( Level_H * Level_W ) ) + 2; // +2 because we read LastLevel data at 1st position (2 bytes)
        leveloffset = ( levelread * ( ( Level_H * Level_W ) / 2 ) ) + 2; // +2 because we read LastLevel data at 1st position (2 bytes)

        // Set the offset in file
        if (ti_Seek( leveloffset, 0, LevelAppVar ) == EOF) {
            ti_CloseAll( );
            return 3; // Error seek in file
        }

        //We finally read the Level Data
        if (ti_Read( &LevelRead, sizeof (LevelRead ), 1, LevelAppVar ) != 1) {
            ti_CloseAll( );
            return 4; // Error reading level
        }

        //Close the file
        ti_CloseAll( );

#if defined DEBUG_FILE
        // ****************** just for debug ******************
        // Fill the screen red
        gfx_FillScreen( gfx_red );
        gfx_SetTextBGColor( gfx_red );
        gfx_SetTextFGColor( gfx_yellow );
        gfx_PrintStringXY( "LastLevel = ", 0, 10 );
        sprintf( strnum, "%d", LastLevel );
        gfx_PrintStringXY( strnum, 110, 10 );
        //Swap the buffer with the screen
        gfx_BlitBuffer( );
        delay( 3000 );
        // ****************** just for debug ******************
#endif

        // convert the 4 bits readed level to 8bits
        for (cnt = 0; cnt < ( ( Level_H * Level_W ) / 2 ); cnt++) {
            LevelGet[cnt * 2] = LevelRead[cnt] >> 4;
            LevelGet[( cnt * 2 ) + 1] = LevelRead[cnt] & 15;
        }

        cnt = 0;
        // transfer the datas to the map array
        for (cnty = 0; cnty < Level_H; cnty++)
            for (cntx = 0; cntx < Level_W; cntx++) {
                switch (LevelGet[cnt]) {
                    case 0: // empty
                        Level[cnty][cntx].spr = Empty;
                        Level[cnty][cntx].code = c_empty;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 1: // Normal Brick
                        Level[cnty][cntx].spr = nBrick;
                        Level[cnty][cntx].code = c_nbrick;
                        Level[cnty][cntx].blocking = true;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 2: // Solid Brick
                        Level[cnty][cntx].spr = sBrick;
                        Level[cnty][cntx].code = c_sbrick;
                        Level[cnty][cntx].blocking = true;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 3: // Ladder
                        Level[cnty][cntx].spr = Ladder;
                        Level[cnty][cntx].code = c_ladder;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 4: // Line of rope
                        Level[cnty][cntx].spr = Rope;
                        Level[cnty][cntx].code = c_rope;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 5: // False brick // fall tough
                        Level[cnty][cntx].spr = nBrick;
                        Level[cnty][cntx].code = c_trap;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 6: // Ladder appears at end of level , 'behavior same as empty before end of level'
                        Level[cnty][cntx].spr = Empty;
                        Level[cnty][cntx].code = c_sladder;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 7: // Gold chest
                        NbGold++;
                        Level[cnty][cntx].spr = GoldSpr;
                        Level[cnty][cntx].code = c_gold;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        break;

                    case 8: // Guard
                        if (NbBadGuy < 5) {
                            Level[cnty][cntx].spr = Empty;
                            Level[cnty][cntx].code = c_empty;
                            Level[cnty][cntx].blocking = false;
                            Level[cnty][cntx].hole = false;
                            Players[NbBadGuy + 10].cx = cntx;
                            Players[NbBadGuy + 10].cy = cnty;
                            Players[NbBadGuy + 10].oldx = Players[NbBadGuy + 10].cx;
                            Players[NbBadGuy + 10].oldy = Players[NbBadGuy + 10].cy;
                            Players[NbBadGuy + 10].spr = BadGuy_left[0];
                            Players[NbBadGuy + 10].die = false;
                            Players[NbBadGuy + 10].gold = false;
                            Players[NbBadGuy + 10].dir = dStay;
                            NbBadGuy++;
                        }
                        break;

                    case 9: // Player
                        Level[cnty][cntx].spr = Empty;
                        Level[cnty][cntx].code = c_empty;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        Players[0].cx = cntx;
                        Players[0].cy = cnty;
                        Players[0].oldx = Players[0].cx;
                        Players[0].oldy = Players[0].cy;
                        Players[0].startx = Players[0].cx; // save the Hero start point to come back
                        Players[0].starty = Players[0].cy; // when Hero die ....
                        Players[0].dir = dStay;
                        Players[0].spr = Hero_right[0];
                        break;

                    default:
                        Level[cnty][cntx].spr = Empty;
                        Level[cnty][cntx].code = c_empty;
                        Level[cnty][cntx].blocking = false;
                        Level[cnty][cntx].hole = false;
                        break;
                }
                cnt++;
            }

        // Init hunting variable
        i_see_you.cx = 0;
        i_see_you.cy = 0;
        i_see_you.status = false;

        //Put level sprites on screen
        for (cnty = 0; cnty < Level_H; cnty++)
            for (cntx = 0; cntx < Level_W; cntx++) {
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[cnty][cntx].spr] ), cntx * Sprite_W, cnty * Sprite_H );
            }

        //Put Hero sprite on screen
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Players[0].spr] ), Players[0].cx * Sprite_W, Players[0].cy * Sprite_H );

        //Put BadGuy's sprites on screen
        for (cnt = 10; cnt < MaxPlayer; cnt++)
            if (Players[cnt].die == false)
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Players[cnt].spr] ), Players[cnt].cx * Sprite_W, Players[cnt].cy * Sprite_H );

        //Swap the buffer with the screen
        gfx_BlitBuffer( );
    }

    //Close the file
    ti_CloseAll( );

    return 0; // everything was ok
}

void get_map_gold( void ) {
    uint8_t cnt, cntx, cnty;
    NbGold = 0;

    // Get number of gold chest in the map
    for (cnty = 0; cnty < Level_H; cnty++)
        for (cntx = 0; cntx < Level_W; cntx++) {
            // gold chest
            if (Level[cnty][cntx].code == c_gold) {
                NbGold++;
            }
        }

    // Get number of gold chest taken from the bad guy
    if (NbBadGuy > 0)
        for (cnt = 10; cnt < ( NbBadGuy + 10 ); cnt++)
            if (Players[cnt].gold == true) NbGold++;
}

bool rescan_player( uint8_t id ) {
    // Scan elements arround the player

    // Base
    Players[id].base = Level[Players[id].cy][Players[id].cx].code;
    Players[id].b_base = Level[Players[id].cy][Players[id].cx].blocking;

    // Up
    if (( Players[id].cy - 1 ) < 0) {
        Players[id].u = -1;
        Players[id].b_u = true;
    } else {
        Players[id].u = Level[Players[id].cy - 1][Players[id].cx].code;
        Players[id].b_u = Level[Players[id].cy - 1][Players[id].cx].blocking;
    }

    // Right
    if (( Players[id].cx + 1 ) > MaxLX) {
        Players[id].r = -1;
        Players[id].b_r = true;
    } else {
        Players[id].r = Level[Players[id].cy][Players[id].cx + 1].code;
        Players[id].b_r = Level[Players[id].cy][Players[id].cx + 1].blocking;
    }

    // Down
    if (( Players[id].cy + 1 ) > MaxLY) {
        Players[id].d = -1;
        Players[id].b_d = true;
    } else {
        Players[id].d = Level[Players[id].cy + 1][Players[id].cx].code;
        Players[id].b_d = Level[Players[id].cy + 1][Players[id].cx].blocking;
    }

    // Left
    if (( Players[id].cx - 1 ) < 0) {
        Players[id].l = -1;
        Players[id].b_l = true;
    } else {
        Players[id].l = Level[Players[id].cy][Players[id].cx - 1].code;
        Players[id].b_l = Level[Players[id].cy][Players[id].cx - 1].blocking;
    }

    // Down - Right
    if (( ( Players[id].cy + 1 ) > MaxLY ) || ( ( Players[id].cx + 1 ) > MaxLX )) {
        Players[id].dr = -1;
        Players[id].b_dr = true;
    } else {
        Players[id].dr = Level[Players[id].cy + 1][Players[id].cx + 1].code;
        Players[id].b_dr = Level[Players[id].cy + 1][Players[id].cx + 1].blocking;
    }

    // Down - Left
    if (( ( Players[id].cy + 1 ) > MaxLY ) || ( ( Players[id].cx - 1 ) < 0 )) {
        Players[id].dl = -1;
        Players[id].b_dl = true;
    } else {
        Players[id].dl = Level[Players[id].cy + 1][Players[id].cx - 1].code;
        Players[id].b_dl = Level[Players[id].cy + 1][Players[id].cx - 1].blocking;
    }

    // Up - Right
    if (( ( Players[id].cy - 1 ) < 0 ) || ( ( Players[id].cx + 1 ) > MaxLX )) {
        Players[id].ur = -1;
        Players[id].b_ur = true;
    } else {
        Players[id].ur = Level[Players[id].cy - 1][Players[id].cx + 1].code;
        Players[id].b_ur = Level[Players[id].cy - 1][Players[id].cx + 1].blocking;
    }

    // Up - Left
    if (( ( Players[id].cy - 1 ) < 0 ) || ( ( Players[id].cx - 1 ) < 0 )) {
        Players[id].ul = -1;
        Players[id].b_ul = true;
    } else {
        Players[id].ul = Level[Players[id].cy - 1][Players[id].cx - 1].code;
        Players[id].b_ul = Level[Players[id].cy - 1][Players[id].cx - 1].blocking;
    }

    if (id == 0) {
        // check if everything is blocking the player and make it die
        if (( Players[id].b_u == true ) && ( Players[id].b_r == true ) && ( Players[id].b_d == true ) && ( Players[id].b_l == true )) {
            // Player is blocked and have to die
            Lives--;
            if (Lives == 0) {
                endgame = true;
                return true;
            }
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy][Players[id].cx].spr] ), Players[id].cx * Sprite_W, Players[id].cy * Sprite_H );
            Players[id].cx = Players[id].startx;
            Players[id].cy = Players[id].starty;
        }
    }
    return true;
}

bool walk_ok( uint8_t id, uint8_t dir ) {
    // test right
    if (dir == dRight) {
        if (( Players[id].b_r == false ))
            return true; // we can go right
        else
            return false; // blocked at right
    }
    // test left
    if (dir == dLeft) {
        if (( Players[id].b_l == false ))
            return true; // we can go left
        else
            return false; // blocked at left
    }
    return false;
}

bool climb_ok( uint8_t id, uint8_t dir ) {
    // test up
    if (id == 0) {
        if (dir == dUp) {
            if (( ( Players[id].b_u == false ) && ( ( Players[id].base == c_ladder ) || ( ( Players[id].base == c_sladder ) && ( showoutput == true ) ) ) ) || ( Players[id].u == c_gold ))
                return true; // we can go up
            else
                return false; // we cant go up
        }
    } else {
        if (dir == dUp) {
            if (( ( Players[id].b_u == false ) && ( ( Players[id].base == c_ladder ) || ( ( Players[id].base == c_sladder ) && ( showoutput == true ) ) || ( Players[id].u == c_ladder ) ) ))
                return true; // we can go up
            else
                return false; // we cant go up
        }
    }
    // test down
    if (dir == dDown) {
        if (Players[id].b_d == false)
            return true; // we can go down
        else
            return false; // we cant go down
    }
    return false;
}

bool fall_ok( uint8_t id ) {
    if (( ( ( Players[id].d == c_empty ) && ( Players[id].base != c_ladder ) ) || ( Players[id].d == c_trap ) || ( Players[id].d == c_gard ) || ( Players[id].d == c_gold )
            || ( Players[id].d == c_player ) || ( Players[id].d == c_holetrap ) || ( Players[id].d == c_rope ) ) && ( Players[id].d != c_holetrapb ))
        return true;
    else
        return false;
}

bool rope_ok( uint8_t id, uint8_t dir ) {
    // test right
    if (dir == dRight) {
        if (( Players[id].b_r == false ) && ( Players[id].r == c_rope ))
            return true; // we can go right on a rope
        else
            return false; // blocked at right or no more rope
    }
    // test left
    if (dir == dLeft) {
        if (( Players[id].b_l == false ) && ( Players[id].l == c_rope ))
            return true; // we can go left on a rope
        else
            return false; // blocked at left or no more rope
    }

    // test rope at player position
    if (dir == 0) {
        if (Players[id].base == c_rope)
            return true; // we are on rope
        else
            return false; // we dont have rope
    }
    return false;
}

bool fire( uint8_t dir ) {
    uint8_t cnt;
    // Fire a hole left/right
    // We check first if we can shoot a holetrap at right
    if (( dir == dRight ) && ( ( Players[0].b_r == false ) || ( Players[0].r == c_holetrap ) ) && ( Players[0].dr == c_nbrick )) {
        // Now check if we have a hole slot free
        for (cnt = 0; cnt < HeroMaxShoot; cnt++) {
            if (HeroShoot[cnt].holeaction == false) {
                // Here we can generate a hole
                HeroShoot[cnt].x = Players[0].cx + 1;
                HeroShoot[cnt].y = Players[0].cy + 1;
                HeroShoot[cnt].holeaction = true;
                HeroShoot[cnt].spr_hole_up = HoleTrapUp[0];
                HeroShoot[cnt].spr_hole_down = HoleTrapDown[0];
                HeroShoot[cnt].traptimer = TrapTimer;
                HeroShoot[cnt].holeopened = false;
                HeroShoot[cnt].closehole = false;
                Level[HeroShoot[cnt].y][HeroShoot[cnt].x].code = c_holetrap;
                Level[HeroShoot[cnt].y][HeroShoot[cnt].x].spr = Empty;
                Players[0].spr = Hero_shootright;
                Players[0].dir = 8;
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), Players[0].cx * Sprite_W, Players[0].cy * Sprite_H );
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Players[0].spr] ), Players[0].cx * Sprite_W, Players[0].cy * Sprite_H );
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[cnt].spr_hole_up] ), HeroShoot[cnt].x * Sprite_W, ( HeroShoot[cnt].y - 1 ) * Sprite_H );
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[cnt].spr_hole_down] ), HeroShoot[cnt].x * Sprite_W, HeroShoot[cnt].y * Sprite_H );
                return true;
            }
        }
    }
    // We check first if we can shoot a holetrap at left
    if (( dir == dLeft ) && ( ( Players[0].b_l == false ) || ( Players[0].l == c_holetrap ) ) && ( Players[0].dl == c_nbrick )) {
        // Now check if we have a hole slot free
        for (cnt = 0; cnt < HeroMaxShoot; cnt++) {
            if (HeroShoot[cnt].holeaction == false) {
                // Here we can generate a hole
                HeroShoot[cnt].x = Players[0].cx - 1;
                HeroShoot[cnt].y = Players[0].cy + 1;
                HeroShoot[cnt].holeaction = true;
                HeroShoot[cnt].spr_hole_up = HoleTrapUp[0];
                HeroShoot[cnt].spr_hole_down = HoleTrapDown[0];
                HeroShoot[cnt].traptimer = TrapTimer;
                HeroShoot[cnt].holeopened = false;
                HeroShoot[cnt].closehole = false;
                Level[HeroShoot[cnt].y][HeroShoot[cnt].x].code = c_holetrap;
                Level[HeroShoot[cnt].y][HeroShoot[cnt].x].spr = Empty;
                Players[0].spr = Hero_shootleft;
                Players[0].dir = 8;
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), Players[0].cx * Sprite_W, Players[0].cy * Sprite_H );
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Players[0].spr] ), Players[0].cx * Sprite_W, Players[0].cy * Sprite_H );
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[cnt].spr_hole_up] ), HeroShoot[cnt].x * Sprite_W, ( HeroShoot[cnt].y - 1 ) * Sprite_H );
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[cnt].spr_hole_down] ), HeroShoot[cnt].x * Sprite_W, HeroShoot[cnt].y * Sprite_H );
                return true;
            }
        }
    }
    return true;
}

bool show_after_gold( uint8_t id ) {
    // put the empty background on screen
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), Players[id].cx* Sprite_W, Players[id].cy * Sprite_H );
    return true;
}

void decode_score( void ) {
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[GoldSpr] ), 300 - ( 6 * Sprite_W ), CharWriteY );

    if (Score < 10) {
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[Score]] ), 300, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - Sprite_W, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 2 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 3 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 4 * Sprite_W ), CharWriteY );
    }

    if (( Score >= 10 ) && ( Score < 100 )) {
        decscore[0] = Score % 10;
        decscore[1] = Score / 10;
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]] ), 300, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]] ), 300 - Sprite_W, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 2 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 3 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 4 * Sprite_W ), CharWriteY );
    }

    if (( Score >= 100 ) && ( Score < 1000 )) {
        decscore[0] = Score % 10;
        decscore[1] = ( Score % 100 ) / 10;
        decscore[2] = ( Score / 100 );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]] ), 300, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]] ), 300 - Sprite_W, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[2]]] ), 300 - ( 2 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 3 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 4 * Sprite_W ), CharWriteY );
    }

    if (( Score >= 1000 ) && ( Score < 10000 )) {
        decscore[0] = Score % 10;
        decscore[1] = ( Score % 100 ) / 10;
        decscore[2] = ( Score % 1000 ) / 100;
        decscore[3] = ( Score / 1000 );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]] ), 300, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]] ), 300 - Sprite_W, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[2]]] ), 300 - ( 2 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[3]]] ), 300 - ( 3 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), 300 - ( 4 * Sprite_W ), CharWriteY );
    }

    if (( Score >= 10000 ) && ( Score <= 99999 )) {
        decscore[0] = Score % 10;
        decscore[1] = ( Score % 100 ) / 10;
        decscore[2] = ( Score % 1000 ) / 100;
        decscore[3] = ( Score % 10000 ) / 1000;
        decscore[4] = ( Score / 10000 );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[0]]] ), 300, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[1]]] ), 300 - Sprite_W, CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[2]]] ), 300 - ( 2 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[3]]] ), 300 - ( 3 * Sprite_W ), CharWriteY );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[decscore[4]]] ), 300 - ( 4 * Sprite_W ), CharWriteY );
    }
}

void show_output( void ) {
    //Show the output ladder
    uint8_t cntx, cnty;
    for (cnty = 0; cnty < Level_H; cnty++)
        for (cntx = 0; cntx < Level_W; cntx++) {
            //search the output ladder code to show
            if (Level[cnty][cntx].code == c_sladder) {
                Level[cnty][cntx].spr = Ladder;
                Level[cnty][cntx].code = c_ladder;
                // show the ladder
                gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[cnty][cntx].spr ] ), cntx * Sprite_W, cnty * Sprite_H );
            }
        }
}

void get_next_level( void ) {
    uint8_t cnt;

    // Load the next level
    Level_Number++;
    if (( Lives + 1 ) < 10) Lives++;

    for (cnt = 0; cnt < HeroMaxShoot; cnt++)
        HeroShoot[cnt].holeaction = false;
    setmap( Level_Number );
    nextlevel = false;
}

bool debug_player( uint8_t id ) {
    uint8_t cnt = 0;
    // show the sprites arround the selected player
    rescan_player( id );

    // clean the place we use for show sprites
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 1 ) * Sprite_W, 0 );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 2 ) * Sprite_W, 0 );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 3 ) * Sprite_W, 0 );

    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 1 ) * Sprite_W, Sprite_H );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 2 ) * Sprite_W, Sprite_H );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 3 ) * Sprite_W, Sprite_H );

    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 2 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 2 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Empty] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 2 ) );

    // show the sprites
    if (Players[id].cy > 0) {
        if (Players[id].cx > 0)
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy - 1 ][Players[id].cx - 1 ].spr] ), ( Level_W + 1 ) * Sprite_W, 0 );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy - 1 ][Players[id].cx ].spr] ), ( Level_W + 2 ) * Sprite_W, 0 );
        if (Players[id].cx < MaxLX)
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy - 1 ][Players[id].cx + 1 ].spr] ), ( Level_W + 3 ) * Sprite_W, 0 );
    }

    if (Players[id].cx > 0)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy ][Players[id].cx - 1 ].spr] ), ( Level_W + 1 ) * Sprite_W, Sprite_H );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy ][Players[id].cx ].spr] ), ( Level_W + 2 ) * Sprite_W, Sprite_H );
    if (Players[id].cx < MaxLX)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy ][Players[id].cx + 1 ].spr] ), ( Level_W + 3 ) * Sprite_W, Sprite_H );

    if (Players[id].cy < MaxLY) {
        if (Players[id].cx > 0)
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy + 1 ][Players[id].cx - 1 ].spr] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 2 ) );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy + 1 ][Players[id].cx ].spr] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 2 ) );
        if (Players[id].cx < MaxLX)
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].cy + 1 ][Players[id].cx + 1 ].spr] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 2 ) );
    }


    // clean the place we use for show blocking zone
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 4 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 4 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 4 ) );

    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 5 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 5 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 5 ) );

    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 6 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 6 ) );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 6 ) );

    // show blocking values
    if (Players[0].b_ul)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 4 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 4 ) );

    if (Players[0].b_u)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 4 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 4 ) );

    if (Players[0].b_ur)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 4 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 4 ) );

    if (Players[0].b_l)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 5 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 5 ) );

    if (Players[0].b_r)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 5 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 5 ) );


    if (Players[0].b_dl)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 6 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 6 ) );

    if (Players[0].b_d)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 6 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 2 ) * Sprite_W, ( Sprite_H * 6 ) );

    if (Players[0].b_dr)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 6 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 6 ) );

    // show the possible directions status
    for (cnt = 8; cnt < 16; cnt++)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * cnt ) );

    if (go_left)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 8 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 8 ) );

    if (go_right)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 9 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 9 ) );

    if (go_up)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 10 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 10 ) );

    if (go_down)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 11 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 11 ) );

    if (go_rope)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 12 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 12 ) );

    if (go_ropeleft)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 13 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 13 ) );

    if (go_roperight)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 14 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 14 ) );

    if (go_fall)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 15 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 1 ) * Sprite_W, ( Sprite_H * 15 ) );

    // show the actual directions
    for (cnt = 8; cnt < 16; cnt++)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[ch_SpacePic] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * cnt ) );

    if (Players[0].dir == dLeft)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 8 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 8 ) );

    if (Players[0].dir == dRight)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 9 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 9 ) );

    if (Players[0].dir == dUp)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 10 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 10 ) );

    if (Players[0].dir == dDown)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 11 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 11 ) );

    if (Players[0].dir == dRopeL)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 13 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 13 ) );

    if (Players[0].dir == dRopeR)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 14 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 14 ) );

    if (Players[0].dir == dFall)
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 15 ) );
    else
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[0]] ), ( Level_W + 3 ) * Sprite_W, ( Sprite_H * 15 ) );


    return true;
}

bool animate_player( uint8_t id ) {
    // 1:up 2:right 3:down 4:left 5:rope right 6:rope left 7:Fall down 8: stay
    Players[id].oldx = Players[id].cx;
    Players[id].oldy = Players[id].cy;

    if (Players[id].dir == dUp) { // up
        Players[id].cy -= 1;
        if (id == 0) // check if we change level
            if (( Players[id].cy < 0 ) && ( showoutput == true )) nextlevel = true;
        if (Players[id].cy < 0) Players[id].cy = 0;
        if (id == 0) {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = Hero_ladder[0];
            else {
                if (( Players[id].spr + 1 ) > Hero_ladder[LastHeroUpDown])
                    Players[id].spr = Hero_ladder[0];
                else
                    Players[id].spr++;
            }
        } else {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = BadGuy_ladder[0];
            else {
                if (( Players[id].spr + 1 ) > BadGuy_ladder[LastBadGuyUpDown])
                    Players[id].spr = BadGuy_ladder[0];
                else
                    Players[id].spr++;
            }
        }
    }

    if (Players[id].dir == dRight) { // right
        Players[id].cx += 1;
        if (Players[id].cx > MaxLX) Players[id].cx = MaxLX;
        if (id == 0) {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = Hero_right[0];
            else {
                if (( Players[id].spr + 1 ) > Hero_right[LastHeroMove])
                    Players[id].spr = Hero_right[0];
                else
                    Players[id].spr++;
            }
        } else {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = BadGuy_right[0];
            else {
                if (( Players[id].spr + 1 ) > BadGuy_right[LastBadGuyMove])
                    Players[id].spr = BadGuy_right[0];
                else
                    Players[id].spr++;
            }
        }
    }

    if (Players[id].dir == dDown) { // down
        Players[id].cy += 1;
        if (Players[id].cy > MaxLY) Players[id].cy = MaxLY;
        if (id == 0) {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = Hero_ladder[0];
            else {
                if (( Players[id].spr + 1 ) > Hero_ladder[LastHeroUpDown])
                    Players[id].spr = Hero_ladder[0];
                else
                    Players[id].spr++;
            }
        } else {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = BadGuy_ladder[0];
            else {
                if (( Players[id].spr + 1 ) > BadGuy_ladder[LastBadGuyUpDown])
                    Players[id].spr = BadGuy_ladder[0];
                else
                    Players[id].spr++;
            }
        }
    }

    if (Players[id].dir == dLeft) { // left
        Players[id].cx -= 1;
        if (Players[id].cx < 0) Players[id].cx = 0;
        if (id == 0) {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = Hero_left[0];
            else {
                if (( Players[id].spr + 1 ) > Hero_left[LastHeroMove])
                    Players[id].spr = Hero_left[0];
                else
                    Players[id].spr++;
            }
        } else {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = BadGuy_left[0];
            else {
                if (( Players[id].spr + 1 ) > BadGuy_left[LastBadGuyMove])
                    Players[id].spr = BadGuy_left[0];
                else
                    Players[id].spr++;
            }
        }
    }

    if (Players[id].dir == dRopeR) { // rope right
        Players[id].cx += 1;
        if (Players[id].cx > MaxLX) Players[id].cx = MaxLX;
        if (id == 0) {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = Hero_roperight[0];
            else {
                if (( Players[id].spr + 1 ) > Hero_roperight[LastHeroRope])
                    Players[id].spr = Hero_roperight[0];
                else
                    Players[id].spr++;
            }
        } else {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = BadGuy_roperight[0];
            else {
                if (( Players[id].spr + 1 ) > BadGuy_roperight[LastBadGuyRope])
                    Players[id].spr = BadGuy_roperight[0];
                else
                    Players[id].spr++;
            }
        }
    }

    if (Players[id].dir == dRopeL) { // rope left
        Players[id].cx -= 1;
        if (Players[id].cx < 0) Players[id].cx = 0;
        if (id == 0) {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = Hero_ropeleft[0];
            else {
                if (( Players[id].spr + 1 ) > Hero_ropeleft[LastHeroRope])
                    Players[id].spr = Hero_ropeleft[0];
                else
                    Players[id].spr++;
            }
        } else {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = BadGuy_ropeleft[0];
            else {
                if (( Players[id].spr + 1 ) > BadGuy_ropeleft[LastBadGuyRope])
                    Players[id].spr = BadGuy_ropeleft[0];
                else
                    Players[id].spr++;
            }
        }
    }

    if (Players[id].dir == dFall) { // fall down
        Players[id].cy += 1;
        if (Players[id].cy > MaxLY) Players[id].cy = MaxLY;
        if (id == 0) {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = Hero_fall_down[0];
            else {
                if (( Players[id].spr + 1 ) > Hero_fall_down[LastHeroFall])
                    Players[id].spr = Hero_fall_down[0];
                else
                    Players[id].spr++;
            }
        } else {
            if (Players[id].dir != Players[id].olddir)
                Players[id].spr = BadGuy_fall_down[0];
            else {
                if (( Players[id].spr + 1 ) > BadGuy_fall_down[LastBadGuyFall])
                    Players[id].spr = BadGuy_fall_down[0];
                else
                    Players[id].spr++;
            }
        }
    }

    // put the player/bad guy sprite on screen
    // replace the background
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[Level[Players[id].oldy][Players[id].oldx].spr] ), Players[id].oldx* Sprite_W, Players[id].oldy * Sprite_H );
    // now place the player / bad guy sprite
    gfx_TransparentSprite( ( (gfx_sprite_t *) var_gfx[Players[id].spr] ), Players[id].cx * Sprite_W, Players[id].cy * Sprite_H );
    // if a bad guy get a gold chest we add a red point to know that we have to trap this one to get the gold back
    if (id > 0) {
        if (Players[id].gold == true) {
            gfx_SetColor( gfx_red );
            gfx_FillRectangle( Players[id].cx * Sprite_W, Players[id].cy * Sprite_H, 2, 2 );
        }
    }

    // Check if we are on the i_see_you coordinate
    if (id > 0) {
        if (( Players[id].cx == i_see_you.cx ) && ( Players[id].cy == i_see_you.cy ))
            i_see_you.status = false;
        i_see_you.movecnt++;
        if (i_see_you.movecnt > 40)
            i_see_you.status = false;
    }

    return true;
}

bool animate_hole( uint8_t holenum ) {
    uint8_t cnt = 0;
    // Animate Hole generation
    rescan_player( 0 );
    if (( HeroShoot[holenum].holeopened == false ) && ( HeroShoot[holenum].closehole == false )) {
        // Hole is not fully open ...
        if (( HeroShoot[holenum].spr_hole_up + 1 ) > HoleTrapUp[LastHoleTrap]) {
            // Hole is now fully open , put the empty sprites
            HeroShoot[holenum].spr_hole_up = Empty;
            HeroShoot[holenum].spr_hole_down = Empty;
            HeroShoot[holenum].holeopened = true;
            Level[HeroShoot[holenum].y][HeroShoot[holenum].x].blocking = false;
            Level[HeroShoot[holenum].y][HeroShoot[holenum].x].code = c_holetrap;
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[holenum].spr_hole_up] ), HeroShoot[holenum].x * Sprite_W, ( HeroShoot[holenum].y - 1 ) * Sprite_H );
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[holenum].spr_hole_down] ), HeroShoot[holenum].x * Sprite_W, HeroShoot[holenum].y * Sprite_H );
        } else {
            // Increment sprite for open the Hole
            HeroShoot[holenum].spr_hole_up++;
            HeroShoot[holenum].spr_hole_down++;
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[holenum].spr_hole_up] ), HeroShoot[holenum].x * Sprite_W, ( HeroShoot[holenum].y - 1 ) * Sprite_H );
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[holenum].spr_hole_down] ), HeroShoot[holenum].x * Sprite_W, HeroShoot[holenum].y * Sprite_H );
        }
        return true;
    }

    if (( HeroShoot[holenum].holeopened == true ) && ( HeroShoot[holenum].closehole == false )) {
        // Hole is fully open , we check if we have to close it ..
        HeroShoot[holenum].traptimer--;
        if (HeroShoot[holenum].traptimer == 0) {
            // Time out , we can close the hole
            HeroShoot[holenum].closehole = true;
            HeroShoot[holenum].spr_hole_down = HoleTrapDown[LastHoleTrap];
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[holenum].spr_hole_down] ), HeroShoot[holenum].x * Sprite_W, HeroShoot[holenum].y * Sprite_H );
        }
        return true;
    }

    if (( HeroShoot[holenum].holeopened == true ) && ( HeroShoot[holenum].closehole == true )) {
        // Hole is in closing process
        if (( HeroShoot[holenum].spr_hole_down - 1 ) < HoleTrapDown[0]) {
            // Hole is now closed , we can reset this hole variables and show the brick
            HeroShoot[holenum].holeaction = false;
            HeroShoot[holenum].holeopened = false;
            HeroShoot[holenum].closehole = false;
            Level[HeroShoot[holenum].y][HeroShoot[holenum].x].blocking = true;
            Level[HeroShoot[holenum].y][HeroShoot[holenum].x].spr = nBrick;
            Level[HeroShoot[holenum].y][HeroShoot[holenum].x].code = c_nbrick;
            HeroShoot[holenum].spr_hole_down = nBrick;
            // check if player was trap in a hole
            rescan_player( 0 );
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[holenum].spr_hole_down] ), HeroShoot[holenum].x * Sprite_W, HeroShoot[holenum].y * Sprite_H );
            if (( Players[0].cx == HeroShoot[holenum].x ) && ( Players[0].cy == HeroShoot[holenum].y ) && ( Players[0].b_u == false )) {
                Players[0].cy -= 1;
            }
            // check if bad guy was trap in a hole
            for (cnt = 10; cnt < MaxPlayer; cnt++) {
                rescan_player( cnt );
                if (( Players[cnt].cx == HeroShoot[holenum].x ) && ( Players[cnt].cy == HeroShoot[holenum].y ) && ( Players[cnt].b_u == false )) {
                    Players[cnt].cy -= 1;
                }
            }
        } else {
            // We continue to close the hole
            HeroShoot[holenum].spr_hole_down--;
            gfx_Sprite( ( (gfx_sprite_t *) var_gfx[HeroShoot[holenum].spr_hole_down] ), HeroShoot[holenum].x * Sprite_W, HeroShoot[holenum].y * Sprite_H );
        }
        return true;
    }
    return true;
}

uint8_t artificial_stupidity( uint8_t id ) {
    bool higher = false;
    bool lower = false;
    bool atright = false;
    bool atleft = false;
    bool dirblocked = false;

    int8_t cnt = 0;
    uint8_t choosedir = dStay;
    uint8_t randcnt = 0;

    Players[15] = Players[id];
    // test all direction
    go_left = walk_ok( 15, dLeft );
    go_right = walk_ok( 15, dRight );
    go_up = climb_ok( 15, dUp );
    go_down = climb_ok( 15, dDown );
    go_rope = rope_ok( 15, 0 );
    go_ropeleft = rope_ok( 15, dLeft );
    go_roperight = rope_ok( 15, dRight );
    go_fall = fall_ok( 15 );

    // check if we can see the Player
    if (Players[0].cy == Players[id].cy) { // we are on same line , check left or right
        if (Players[0].cx > Players[id].cx) {
            atright = true;
            atleft = false;
        } else {
            atright = false;
            atleft = true;
        }
        if (atright) {
            for (cnt = Players[id].cx + 1; cnt < Level_W; cnt++) {
                if (Level[Players[id].cy][cnt].blocking == true)
                    cnt = Level_W;
                else {
                    if (Players[0].cx == cnt) {
                        i_see_you.movecnt = 0;
                        i_see_you.status = true;
                        i_see_you.cx = cnt;
                        i_see_you.cy = Players[id].cy;
                        cnt = Players[0].cx;
                    }
                }
            }
        }
        if (atleft) {
            for (cnt = Players[id].cx - 1; cnt == 0; cnt--) {
                if (Level[Players[id].cy][cnt].blocking == true)
                    cnt = 0;
                else {
                    if (Players[0].cx == cnt) {
                        i_see_you.movecnt = 0;
                        i_see_you.status = true;
                        i_see_you.cx = cnt;
                        i_see_you.cy = Players[id].cy;
                        cnt = Players[0].cx;
                    }
                }
            }
        }
    }

    if (Players[0].cx == Players[id].cx) { // we are on same column , check up or down
        if (Players[0].cy < Players[id].cy) {
            higher = true;
            lower = false;
        } else {
            higher = false;
            lower = true;
        }
        if (lower) {
            for (cnt = Players[id].cy + 1; cnt < Level_H; cnt++) {
                if (Level[cnt][Players[id].cx].blocking == true)
                    cnt = Level_H;
                else {
                    if (Players[0].cy == cnt) {
                        i_see_you.movecnt = 0;
                        i_see_you.status = true;
                        i_see_you.cx = Players[id].cx;
                        i_see_you.cy = cnt;
                        cnt = Players[0].cy;
                    }
                }
            }
        }
        if (higher) {
            for (cnt = Players[id].cy - 1; cnt == 0; cnt--) {
                if (Level[cnt][Players[id].cx].blocking == true)
                    cnt = 0;
                else {
                    if (Players[0].cy == cnt) {
                        i_see_you.movecnt = 0;
                        i_see_you.status = true;
                        i_see_you.cx = Players[id].cx;
                        i_see_you.cy = cnt;
                        cnt = Players[0].cy;
                    }
                }
            }
        }
    }

    // We have see the Player , we can converge to the coordinate
    if (i_see_you.status == true) {
        // check if the player is higher or lower
        if (i_see_you.cy < Players[id].cy) {
            higher = true;
            lower = false;
        } else {
            higher = false;
            lower = true;
        }

        // check if the player is at right or left
        if (i_see_you.cx > Players[id].cx) {
            atright = true;
            atleft = false;
        } else {
            atright = false;
            atleft = true;
        }

        // if player is higher we look how to go up
        if (higher) {
            if (go_up)
                return dUp;
            else {
                // we cant directly go up , found a path at left or right for climp up
                // check right
                Players[15] = Players[id];
                cnt = Players[15].cx;
                while (cnt < MaxLX) {
                    if (walk_ok( 15, dRight )) {
                        Players[15].cx++;
                        cnt = Players[15].cx;
                        //check if we can now go up
                        if (climb_ok( 15, dUp )) {
                            return dRight;
                        }
                    } else {
                        cnt = MaxLX;
                    }
                }
                // check left
                Players[15] = Players[id];
                cnt = Players[15].cx;
                while (cnt >-1) {
                    if (walk_ok( 15, dLeft )) {
                        Players[15].cx--;
                        cnt = Players[15].cx;
                        //check if we can now go up
                        if (climb_ok( 15, dUp )) {
                            return dLeft;
                        }
                    } else {
                        cnt = -1;
                    }
                }
            }
        }

        // if player is lower we look how to go down
        if (lower) {
            if (go_down)
                return dDown;
            else {
                // we cant directly go down , found a path at left or right for climp or fall down
                // check right
                Players[15] = Players[id];
                cnt = Players[15].cx;
                while (cnt < MaxLX) {
                    if (walk_ok( 15, dRight )) {
                        Players[15].cx++;
                        cnt = Players[15].cx;
                        //check if we can now go down
                        if (( climb_ok( 15, dDown ) ) || ( fall_ok( 15 ) )) {
                            return dRight;
                        }
                    } else {
                        cnt = MaxLX;
                    }
                }
                // check left
                Players[15] = Players[id];
                cnt = Players[15].cx;
                while (cnt >-1) {
                    if (walk_ok( 15, dLeft )) {
                        Players[15].cx--;
                        cnt = Players[15].cx;
                        //check if we can now go down
                        if (( climb_ok( 15, dDown ) ) || ( fall_ok( 15 ) )) {
                            return dLeft;
                        }
                    } else {
                        cnt = -1;
                    }
                }
            }
        }

        // if player is at right
        if (atright)
            return dRight;

        // if player is at left
        if (atleft)
            return dLeft;
    } else {
        // we don't have see the player , set a random
        // direction if we are not moving , else continu
        // to move in actual direction
        if (( Players[id].dir != dFall )) {
            if (( Players[id].dir == dRight ) && ( ( go_right ) || ( go_roperight ) ))
                // we can check if we are front of a ladder for go up or down randomly
                if (Players[id].base == c_ladder) {
                    if (( ( rand( ) % 10 ) > 7 ) && ( go_up )) return dUp;
                    if (( ( rand( ) % 10 ) < 3 ) && ( go_down )) return dDown;
                    return dRight;
                } else
                    return dRight;
            else {
                // right direction blocked
                dirblocked = true;
            }
            if (( Players[id].dir == dLeft ) && ( ( go_left ) || ( go_ropeleft ) ))
                // we can check if we are front of a ladder for go up or down randomly
                if (Players[id].base == c_ladder) {
                    if (( ( rand( ) % 10 ) > 7 ) && ( go_up )) return dUp;
                    if (( ( rand( ) % 10 ) < 3 ) && ( go_down )) return dDown;
                    return dLeft;
                } else
                    return dLeft;
            else {
                // left direction blocked
                dirblocked = true;
            }
            if (( Players[id].dir == dUp ) && ( go_up ))
                return dUp;
            else {
                // up direction blocked
                dirblocked = true;
            }
            if (( Players[id].dir == dDown ) && ( go_down ))
                return dDown;
            else {
                // down direction blocked
                dirblocked = true;
            }
        }

        if (dirblocked == true) {
            // Actual direction is blocked , choose randomly
            // another one ...
            while (choosedir == dStay) {
                cnt = ( ( rand( ) % 5 ) );
                if (( cnt == dRight ) && ( ( go_right ) || ( go_roperight ) ))
                    choosedir = dRight;
                if (( cnt == dLeft ) && ( ( go_left ) || ( go_ropeleft ) ))
                    choosedir = dLeft;
                if (( cnt == dUp ) && ( go_up ))
                    choosedir = dUp;
                if (( cnt == dDown ) && ( go_down ))
                    choosedir = dDown;
                randcnt++;
                if (randcnt > 10) choosedir = 0;
            }
            if (choosedir == 0)
                return dStay; // no direction choice was made ...
            else
                return choosedir; // we set the new random direction to go ...
        }
    }

    return dStay;
}

/*
uint16_t menu( void ) {
    // Choose on wish level to start
    char strnum[40];
    uint8_t cntx = 0;
    uint8_t cnty = 0;
    int16_t oldlevel = 0;
    Level_Number = 0;

    gfx_SetTextFGColor( gfx_yellow );
    sprintf( strnum, "Start at Level : %d", Level_Number + 1 );
    gfx_PrintStringXY( strnum, 10, CharWriteY + 2 );
    setmap( Level_Number );

    while (ActKey != sk_Enter) {
        ActKey = os_GetCSC( );
        oldlevel = Level_Number;
        if (ActKey == sk_Right)
            Level_Number++;
        if (ActKey == sk_Left)
            Level_Number--;
        if (Level_Number < 0)
            Level_Number = 0;
        if (Level_Number > 349)
            Level_Number = 349;
        if (Level_Number != oldlevel) {
            // show the level on screen
            sprintf( strnum, "Start at Level : %d", Level_Number + 1 );

            gfx_SetColor( 0 );
            gfx_FillRectangle( 0, CharWriteY, 319, CharWriteY + 16 );

            gfx_SetTextFGColor( gfx_yellow );
            gfx_PrintStringXY( strnum, 10, CharWriteY + 2 );
            setmap( Level_Number );
        }
        //Swap the buffer with the screen
        gfx_BlitBuffer( );
        delay( 200 );
    }
    gfx_SetColor( 0 );
    gfx_FillRectangle( 0, CharWriteY, 319, CharWriteY + 16 );
    delay( 100 );

    // Empty everything before we start the game
    for (cnty = 0; cnty < Level_H; cnty++)
        for (cntx = 0; cntx < Level_W; cntx++) {
            Level[cnty][cntx].code = c_empty;
            Level[cnty][cntx].blocking = true;
            Level[cnty][cntx].spr = Empty;
        }

    return Level_Number;
}
 */

uint16_t menu( void ) {
    // Choose on wish level to start
    char strnum[40];
    uint8_t cntx = 0;
    uint8_t cnty = 0;
    int16_t oldlevel = 0;
    Level_Number = 0;

    // Clear screen
    gfx_SetColor( 0 );
    gfx_FillRectangle( 0, 0, 319, 239 );

    // Draw bricks arround the screen
    for (cntx = 0; cntx < Level_W; cntx++) {
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[nBrick] ), cntx * Sprite_W, 0 );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[nBrick] ), cntx * Sprite_W, ( Level_H - 1 ) * Sprite_H );
    }
    for (cnty = 0; cnty < Level_H; cnty++) {
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[nBrick] ), 0, cnty * Sprite_H );
        gfx_Sprite( ( (gfx_sprite_t *) var_gfx[nBrick] ), ( Level_W - 1 ) * Sprite_W, cnty * Sprite_H );
    }

    // Show text
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[1]] ), 60, 76 );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[2]] ), 60, 96 );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[3]] ), 60, 116 );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[4]] ), 60, 136 );
    gfx_Sprite( ( (gfx_sprite_t *) var_gfx[NumbersPic[5]] ), 60, 156 );
    gfx_SetTextFGColor( gfx_yellow );
    gfx_PrintStringXY( "Choose the levels type to play", 40, 60 );
    gfx_PrintStringXY( "  Classic", 80, 80 );
    gfx_PrintStringXY( "  Championship", 80, 100 );
    gfx_PrintStringXY( "  Professional ", 80, 120 );
    gfx_PrintStringXY( "  Personal", 80, 140 );
    gfx_PrintStringXY( "  Come back here", 80, 160 );

    gfx_BlitBuffer( );
    delay( 200 );

    while (( ActKey != sk_1 ) && ( ActKey != sk_2 ) && ( ActKey != sk_3 ) && ( ActKey != sk_4 )) {
        ActKey = os_GetCSC( );
        if (ActKey == sk_1)
            Level_Number = 0;
        if (ActKey == sk_2)
            Level_Number = 150;
        if (ActKey == sk_3)
            Level_Number = 200;
        if (ActKey == sk_4)
            Level_Number = 350;
        delay( 200 );
    }

    // Clear screen
    gfx_SetColor( 0 );
    gfx_FillRectangle( 0, 0, 319, 239 );

    gfx_SetTextFGColor( gfx_yellow );
    sprintf( strnum, "Start at Level : %d  press Enter for Play", Level_Number + 1 );
    gfx_PrintStringXY( strnum, 10, CharWriteY + 2 );
    setmap( Level_Number );

    while (( ActKey != sk_Enter ) && ( ActKey != sk_5 ) && ( ActKey != sk_Clear )) {
        ActKey = os_GetCSC( );
        oldlevel = Level_Number;
        if (ActKey == sk_Right)
            Level_Number++;
        if (ActKey == sk_Left)
            Level_Number--;
        if (Level_Number < 0)
            Level_Number = 0;
        if (Level_Number > 489)
            Level_Number = 489;
        if (Level_Number != oldlevel) {
            // show the level on screen
            sprintf( strnum, "Start at Level : %d  press Enter for Play", Level_Number + 1 );

            gfx_SetColor( 0 );
            gfx_FillRectangle( 0, CharWriteY, 319, CharWriteY + 16 );

            gfx_SetTextFGColor( gfx_yellow );
            gfx_PrintStringXY( strnum, 10, CharWriteY + 2 );
            setmap( Level_Number );
        }
        //Swap the buffer with the screen
        gfx_BlitBuffer( );
        delay( 200 );
    }

    if (( ActKey == sk_5 ) || ( ActKey == sk_Clear )) return 500; // We go back to menu start for choose another level type

    gfx_SetColor( 0 );
    gfx_FillRectangle( 0, CharWriteY, 319, CharWriteY + 16 );
    delay( 100 );

    // Empty everything before we start the game
    for (cnty = 0; cnty < Level_H; cnty++)
        for (cntx = 0; cntx < Level_W; cntx++) {
            Level[cnty][cntx].code = c_empty;
            Level[cnty][cntx].blocking = true;
            Level[cnty][cntx].spr = Empty;
        }

    return Level_Number;
}

