//Prevent code reentry
#ifndef __MAIN_H
#define __MAIN_H

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdbool.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tice.h>

#include <graphx.h>
#include <fileioc.h>
#include <keypadc.h>

// Include the game sprites graphics
#include "gfx/all_gfx.h"
#include "gfx/var_gfx.h"

// Data Types

// Hero / Bad guy Structure

typedef struct {
	int8_t cx; // actual coordinates (in level cases)
	int8_t cy;
	int8_t oldx; //  previous coordinates (in level cases)
	int8_t oldy;
	int8_t startx; // start coordinates (in level cases)
	int8_t starty;
	uint8_t dir; // 1:up 2:right 3:down 4:left 5:rope right 6:rope left 7:Fall down 8: stay
	uint8_t olddir; // 1:up 2:right 3:down 4:left 5:rope right 6:rope left 7:Fall down 8: stay
	uint8_t spr; // actual sprite to show
	bool die; // true if Bad guy died
	bool gold; // true if Bad guy get a gold chest
	int8_t r; // Level codes arround
	int8_t l;
	int8_t u;
	int8_t d;
	int8_t dr;
	int8_t dl;
	int8_t ur;
	int8_t ul;
	int8_t base;
	bool b_r; // Level blocker codes arround
	bool b_l;
	bool b_u;
	bool b_d;
	bool b_dr;
	bool b_dl;
	bool b_ur;
	bool b_ul;
	bool b_base;
} herost;

// Map level coding structure

typedef struct {
	uint8_t spr; // sprite number
	uint8_t code; // code for this case
	bool blocking; // true if this case is a blocker
	bool hole; // true if it's a player generated hole
} MapCode;

// Hole trap structure

typedef struct {
	uint8_t x; //Coord X
	uint8_t y; //Coord Y
	uint8_t spr_hole_up; // sprite number if needed
	uint8_t spr_hole_down; // sprite number if needed
	bool holeaction; // true if shooted here
	uint16_t traptimer; // trap timer before it close again (then retimer it for close the hole again)
	bool holeopened; // true when the hole is fully open (stay true up the hole is fully closed again)
	bool closehole; // true when we close the trap (in relation with trap timer)
} Trap_Def;

typedef struct {
	uint8_t cx; //Coordinates in level cases
	uint8_t cy;
	uint8_t movecnt;
	bool status;
} Coord2D;


// ************** uncoment for debug **************
//#define DEBUG_FILE  // show information at file load
//#define PLAYER_DEBUG  // show information on player during game run
// ********************************************************

// defines Levels and Sprites general informations
#define Level_W   28  // Level Wide
#define Level_H   16 // Level Height
#define MaxLX   (Level_W - 1)  // Max X coordinate for a Sprite in Level case
#define MaxLY   (Level_H - 1)  // Max Y coordinate for a Sprite in Level case
#define Sprite_W  10 // Sprites Wide
#define Sprite_H  14 // Sprites Height
#define MaxX ((Level_W * Sprite_W) - Sprite_W- 1) // Max X coordinate on screen level
#define MaxY ((Level_H * Sprite_H) - Sprite_H- 1) // Max Y coordinate on screen level
#define PixOffsX  Sprite_W // Offset X in pixels that we move each cycle
#define PixOffsY  Sprite_H // Offset Y in pixels that we move each cycle
#define CharWriteY 223 // Y coordinate for write the score / lives
#define TrapTimer 200 // Timer for close a Trap shooter from player
#define dUp 1 // direction Up
#define dRight 2  // direction Right
#define dDown 3  // direction Down
#define dLeft 4  // direction Left
#define dRopeR 5 // direction rope right
#define dRopeL 6 // direction rope left
#define dFall 7 // direction fall down
#define dStay 8 // direction dont move

// defines the map elements codes
#define c_empty   1   // empty sprite
#define c_nbrick  2  // normal brick
#define c_sbrick  3   // hard brick
#define c_ladder  4   // Ladder
#define c_rope   5   // Rope
#define c_trap   6   // False brick / Trap , fall tough
#define c_sladder  7   // output ladder , empty before end of level
#define c_gold   8   // gold chest
#define c_gard   9   // bad guy
#define c_player  10  // hero
#define c_holetrap  11 // hole made from hero (empty)
#define c_holetrapb  12 // hole made from hero with badguy inside

#define MaxPlayer  15  // Maximum number of Ennemy's
#define AllPlayer     16  // hero , bad guy and actual bad guy informations
#define HeroMaxShoot  20  // Maximum number of Holes the Player can do to trap the Bad Guy's
#define PlayerSpeed 4  // higher = slower , 4 = minimum
#define GardSpeed 15  // higher = slower , 4 = minimum

// Help variables for sprites
#define MaxBadGuyMove  4
#define MaxBadGuyUpDown  2
#define MaxBadGuyRope  4
#define MaxBadGuyFall  2
#define LastBadGuyMove  3
#define LastBadGuyUpDown  1
#define LastBadGuyRope  3
#define LastBadGuyFall  1

#define MaxHeroMove  4
#define MaxHeroUpDown  2
#define MaxHeroRope  4
#define MaxHeroFall  2
#define LastHeroMove  3
#define LastHeroUpDown  1
#define LastHeroRope  3
#define LastHeroFall  1

#define MaxHoleTrap  6
#define LastHoleTrap  5


// define the global variables
herost Players[AllPlayer]; // 0 = Hero informations : 10-14 bad guy information : 15 actual bad guy information
Trap_Def HeroShoot[HeroMaxShoot]; // Coord for Hero shoot on floor
uint8_t LevelGet[Level_H * Level_W]; //converted 4 bits to 8 bits level from file
uint8_t LevelRead[Level_H * Level_W / 2]; // for read the level from file
MapCode Level[Level_H][Level_W]; // 0..15 Lines , 0..27 Columns used to put the Level informations
Coord2D i_see_you;
int8_t NbBadGuy; // Number of badguy in the level
int8_t NbGold; // Number of gold chest in the level
uint24_t Score; // Player Score
uint8_t decscore[5]; // Score decoder for show numbers with sprites
uint8_t Lives; // Number of player Lives
int16_t Level_Number; // Actual Level number
bool endgame; // true if game ends
bool showoutput; // show the output ladder when ge have all gold chest
uint8_t Seconds; // Time counts for finish the level
sk_key_t ActKey; // Key actually pressed
bool shootleft;
bool shootright;
bool nextlevel;

// Variable for directions acceptance
bool go_left;
bool go_right;
bool go_up;
bool go_down;
bool go_rope;
bool go_ropeleft;
bool go_roperight;
bool go_fall;

// Declare variables for Level Map files
uint16_t LastLevel;

// Hero Pictures sprites number
const uint8_t Hero_right[MaxHeroMove] = {1, 2, 3, 4};
const uint8_t Hero_left[MaxHeroMove] = {19, 20, 21, 22};
const uint8_t Hero_ladder[MaxHeroUpDown] = {5, 6};
const uint8_t Hero_fall_down[MaxHeroFall] = {17, 18};
const uint8_t Hero_ropeleft[MaxHeroRope] = {13, 14, 15, 16};
const uint8_t Hero_roperight[MaxHeroRope] = {7, 8, 9, 10};
const uint8_t Hero_shootright = 11;
const uint8_t Hero_shootleft = 12;

// Bad Guys Pictures sprites number
const uint8_t BadGuy_right[MaxBadGuyMove] = {23, 24, 25, 26};
const uint8_t BadGuy_left[MaxBadGuyMove] = {41, 42, 43, 44};
const uint8_t BadGuy_ladder[MaxBadGuyUpDown] = {27, 28};
const uint8_t BadGuy_fall_down[MaxBadGuyFall] = {39, 40};
const uint8_t BadGuy_ropeleft[MaxBadGuyRope] = {35, 36, 37, 38};
const uint8_t BadGuy_roperight[MaxBadGuyRope] = {29, 30, 31, 32};
const uint8_t BadGuy_trapped_right = 33;
const uint8_t BadGuy_trapped_left = 34;

// Other sprites animation pictures
const uint8_t HoleTrapUp[MaxHoleTrap] = {54, 55, 56, 57, 58, 59};
const uint8_t HoleTrapDown[MaxHoleTrap] = {60, 61, 62, 63, 64, 65};

// Level sprites
const uint8_t Empty = 0;
const uint8_t sBrick = 45; // hard brick
const uint8_t nBrick = 46; // normal brick
const uint8_t Ladder = 47;
const uint8_t Rope = 48;
const uint8_t tBrick = 49; // trap brick / fall tough
const uint8_t sLadder = 50; // level out ladder
const uint8_t GoldSpr = 51;

// Other sprites
const uint8_t CoeurPic = 77;
const uint8_t ch_SpacePic = 76;
const uint8_t NumbersPic[10] = {66, 67, 68, 69, 70, 71, 72, 73, 74, 75}; // Number 0 to 9

// Functions declaration
void file_error(uint8_t errnum);
uint8_t init_game(void);
uint8_t setmap(uint16_t numlevel);
void get_map_gold(void);
bool rescan_player(uint8_t id);
bool walk_ok(uint8_t id, uint8_t dir);
bool climb_ok(uint8_t id, uint8_t dir);
bool fall_ok(uint8_t id);
bool rope_ok(uint8_t id, uint8_t dir);
bool fire(uint8_t dir);
bool show_after_gold(uint8_t id);
void decode_score(void);
void show_output(void);
void get_next_level(void);
bool animate_hole(uint8_t holenum);
uint8_t artificial_stupidity(uint8_t id);
bool debug_player(uint8_t id);
bool animate_player(uint8_t id);
uint16_t menu(void);

#endif // __MAIN_H //

