' rocket.bas v2.0 - example program using sprites and sound
' Written by Rich Martin/datawiz August 2020
'
const moveh = -4
const movev = -4
const sp_rocket = 1
const sp_comet = 2
dim RUNFLAG% = 0				' used with wifi upload/testing to cmm2, https://www.thebackshed.com/forum/ViewTopic.php?FID=16&TID=12607
dim vsync% = 0

mode 3,12,0,getvsync
sprite loadpng sp_rocket,"rocket.png"
sprite loadpng sp_comet,"comet.png"

cls
draw_stars
pause 1000

' scroll starfield for a bit
for x% = 1 to 100
	vsync% = 0: do while vsync% = 0: loop
	page scroll 0,moveh,movev 
	if x% mod 10 = 0 then play sound 1,B,N,30,x%/10 ' raise the volume up, ending at level 10
	if x% = 90 then play sound 1,B,N,30,10					' play the rocket engine sound (whitenoise) before the rocket comes on screen
	pause 40
next x%

' scroll the rocket in from the lower left
x% = -39
for y% = 199 to 70 step - 1
	page write 1
	vsync% = 0: do while vsync% = 0: loop
  sprite show sp_rocket,x%,y%,0
	page scroll 0,moveh,movev
  x% = x% + 1
  pause 40
next y%

for x% = 1 to 200
	vsync% = 0: do while vsync% = 0: loop
	page scroll 0,moveh,movev 
	if x% >= 140 then play sound 2,B,W,rnd()*20000			' play the random sensor sound
	pause 40
next x%

' turn off sensor sound
play sound 2,B,O

' comet animation
play sound 2,B,N,100,15
x% = 210
for y% = -60 to 199
	page write 1
	vsync% = 0: do while vsync% = 0: loop
  sprite show sp_comet,x%,y%,0
	vsync% = 0: do while vsync% = 0: loop
	page scroll 0,moveh,movev
	if y% = 15 then play sound 2,B,N,100,25			' increase volume when next to rocket
	if y% = 75 then play sound 2,B,N,100,15			' reduce volume as it passes the rocket
	if y% = 95 then play sound 2,B,N,100,10
	if y% = 130 then play sound 2,B,N,100,5
	x% = x% - 1
  pause 40
next y%

play sound 2,B,O
sprite hide sp_comet

for x% = 1 to 100
	vsync% = 0: do while vsync% = 0: loop
	page scroll 0,moveh,movev 
	if x% = 50 then play sound 2,B,N,60,25
	if x% = 70 then play sound 3,B,N,90,25
	if x% = 90 then play sound 4,B,N,120,25
	pause 40
next x%

' rocket take off
page write 1
x% = 90
for y% = 70 to -64 step -2
  vsync% = 0: do while vsync% = 0: loop
  sprite show sp_rocket,x%,y%,0
  vsync% = 0: do while vsync% = 0: loop
	page scroll 0,moveh*2,movev*2
  x% = x% + 1
  pause 40
next y%

' turn off all sound channels
play sound 1,B,O
play sound 2,B,O
play sound 3,B,O
play sound 4,B,O

' scroll the star field and slow it down
for x% = 1 to 50
	page scroll 0,moveh,movev 
	pause 50 + x%
next x%

page write 1
print @(110,100)"hit a key to exit"
getkey
cls
if RUNFLAG% = 1 then run "server.bas"
end

sub getvsync
  vsync% = 1
end sub

sub draw_stars
' randomly plot randomly colored stars on the screen for the background
local x%, y%
cls
page write 0
for x% = 0 to 319 step 4
	for y% = 0 to 200 step 2
		if int(rnd()*40) = 1 then pixel x%,y%,rgb(rnd()*255,rnd()*255,rnd()*255)
	next y%
next x%
end sub

sub getkey
if int(rnd()*2) = 1 then			' a coin flip for the end...
	pause 500
	x% = 224
	for y% = -64 to 199 step 2
		vsync% = 0:	do while vsync% = 0: loop
		sprite show sp_rocket,x%,y%,0
		pause 10
	next y%
	sprite hide sp_rocket
	for x% = 5 to 100 step 5
		play sound 1,b,n,x%
		if x% mod 10 = 0 then
			page scroll 0,5,0
		else
			page scroll 0,-5,0
		end if
		pause 20
	next x%
	play stop
else
	for y% = 0 to 199
		page scroll 0,0,-1,rgb(black)
		pause 7
	next y%
end if

do while inkey$ = "" : loop
end sub