Sub VGAclocks(object, clock_x_pos, clock_y_pos, draw_scale, base_time$, c_debug)
  Option angle degrees
  Local integer hand_width, hand_fc, hand_bc
  Local integer hr, min, sec, count, hand_angle, hand_corners, hand_source
  Local integer gauge_flag, helper2

  If object > 100 Then
    Inc object, -100
    gauge_flag = 1
  End If

  clock_radius(object) = ring_radius(object) - ring_lw(object) - ring_lw1(object)

  If draw_scale <> 0 Then
    Local float draw_scaled = draw_scale / 100
  Else
    Local float draw_scaled = scale(object) / 100
  End If

  If gauge_flag <> 1 Then
    helper2 = Val(Field$(base_time$,1,":")) : Inc helper2, UTC_offset(object)
    If helper2 < 1 Then Inc helper2, 12
    If helper2 > 12 Then Inc helper2, -12
    base_time$ = Str$(helper2) + ":" + Field$(base_time$,2,":") + ":" + Field$(base_time$,3,":")
  End If

  draw_object_analog_clock(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, base_time$, c_debug)

End Sub

Sub draw_grid()
  Local integer lwh,ll
  helper = 0 : If menu = 4 Then helper = MM.FONTHEIGHT / 2
  If grid_x <> 0 Then
    For counter = 0 To clock_radius(cc) Step grid_x
      If counter > clock_radius(cc) -1 Then Exit For
      lwh = counter * sc / 100
      ll = Sqr((clock_radius(cc) * sc / 100) ^ 2 - lwh ^ 2)
      Line m_clock_pos + lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT + ll - helper, m_clock_pos + lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT - ll - helper, 1, 0
      Line m_clock_pos - lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT + ll - helper, m_clock_pos - lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT - ll - helper, 1, 0
    Next counter
  End If
  If grid_y <> 0 Then
      For counter = 0 To clock_radius(cc) Step grid_y
      If counter > clock_radius(cc) -1 Then Exit For
      lwh = counter * sc / 100
      ll = Sqr((clock_radius(cc) * sc / 100) ^ 2 - lwh ^ 2)
      Line m_clock_pos + ll, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT + lwh - helper, m_clock_pos - ll, (MM.VRES - MM.FONTHEIGHT) / 2 + lwh + MM.FONTHEIGHT - helper, 1, 0
      Line m_clock_pos + ll, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT - lwh - helper, m_clock_pos - ll, (MM.VRES - MM.FONTHEIGHT) / 2 - lwh + MM.FONTHEIGHT - helper, 1, 0
    Next counter
  End If
End Sub

Sub draw_object_analog_clock(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, base_time$, c_debug)
  Local integer hand_num, hand_roff, hand_corners, hand_bc, hand_fc, hand_bc1, hand_fc1
  Local integer scale_start, scale_end
  Local float hr, min, sec, hand_angle, hand_scale

  hr = Val(Field$(base_time$,1,":"))
  min = Val(Field$(base_time$,2,":"))
  sec = Val(Field$(base_time$,3,":"))

  If gauge_flag = 1 Then
    scale_start = hr
    scale_end = min
  Else
    scale_start = 0
    scale_end = 360
    If hr > 11 Then
      hr = (hr - 12) * 5
    Else
      hr = hr * 5
    End If
  End If

  draw_face(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, scale_start, scale_end, c_debug)

  If gauge_flag <> 1 Then 'hr
    hand_num = 1
    hand_angle = (hr - 30 +  min / 60 * 5) * -6'
    hand_bc = hand_bc_hr(object)
    hand_fc = hand_fc_hr(object)
    hand_bc1 = hand_bc_hr1(object)
    hand_fc1 = hand_fc_hr1(object)
    hand_roff = hand_hr_roff(object)
    hand_scale = hand_scale_hr1(object)
    hand_corners = hand_corners_h(object)
    draw_hand(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, hand_num, hand_angle, hand_scale, hand_corners, hand_roff, hand_bc, hand_fc, hand_bc1, hand_fc1, c_debug)
    'min
    hand_num = 2
    hand_angle = (min - 30) * -6
    hand_bc = hand_bc_min(object)
    hand_fc = hand_fc_min(object)
    hand_bc1 = hand_bc_min1(object)
    hand_fc1 = hand_fc_min1(object)
    hand_roff = hand_min_roff(object)
    hand_scale = hand_scale_min1(object)
    hand_corners = hand_corners_m(object)
    draw_hand(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, hand_num, hand_angle, hand_scale,hand_corners, hand_roff, hand_bc, hand_fc, hand_bc1, hand_fc1, c_debug)
  End If

  hand_num = 3 'sec
  If gauge_flag <> 1 Then
    hand_angle = (sec - 30 ) * -6
  Else
    hand_angle = -sec
  End If
  hand_bc = hand_bc_sec(object)
  hand_fc = hand_fc_sec(object)
  hand_bc1 = hand_bc_sec1(object)
  hand_fc1 = hand_fc_sec1(object)
  hand_roff = hand_sec_roff(object)
  hand_scale = hand_scale_sec1(object)
  hand_corners = hand_corners_s(object)
  draw_hand(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, hand_num, hand_angle, hand_scale,hand_corners, hand_roff, hand_bc, hand_fc, hand_bc1, hand_fc1, c_debug)
End Sub

Sub draw_hand(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, hand_num, hand_angle, hand_scale, hand_corners, hand_roff, hand_bc, hand_fc, hand_bc1, hand_fc1, c_debug)
  Local float hand_base_x(hand_corners+1), hand_base_y(hand_corners+1), hand_base_x1(hand_corners+1), hand_base_y1(hand_corners+1)
  Local float min_x, min_y, max_x, max_y, ratio, count
  If gauge_flag <> 1 Then
    If hand_num = 1 Then
      For count = 0  To hand_corners
        hand_base_x(count) = hand_corners_xh(object,count+1)
        hand_base_y(count) = hand_corners_yh(object,count+1)
      Next count
    Else If hand_num = 2 Then
      For count = 0 To hand_corners
        hand_base_x(count) = hand_corners_xm(object,count+1)
        hand_base_y(count) = hand_corners_ym(object,count+1)
      Next count
    End If
  End If
  If hand_num = 3 Then
    For count = 0 To hand_corners
      hand_base_x(count) = hand_corners_xs(object,count+1)
      hand_base_y(count) = hand_corners_ys(object,count+1)
    Next count
  End If
  For count = 0 To hand_corners + 1
    If hand_base_x(count) < min_x Then min_x = hand_base_x(count)
    If hand_base_x(count) > max_x Then max_x = hand_base_x(count)
    If hand_base_y(count) < min_y Then min_y = hand_base_y(count)
    If hand_base_y(count) > max_y Then max_y = hand_base_y(count)
  Next count
  ratio = (max_y - min_y) / (max_x - min_x)
  Math scale hand_base_x(),hand_scale/100, hand_base_x1()
  Math scale hand_base_y(),1-(1-hand_scale/100)/ratio, hand_base_y1()
  Math add hand_base_y(),hand_roff, hand_base_y()
  Math add hand_base_y1(),hand_roff, hand_base_y1()
  Math v_rotate 0, 0, hand_angle, hand_base_x(), hand_base_y(), hand_base_x() , hand_base_y()
  Math v_rotate 0, 0, hand_angle, hand_base_x1(), hand_base_y1(), hand_base_x1() , hand_base_y1()
  Math scale hand_base_x(), -draw_scaled, hand_base_x()
  Math scale hand_base_y(), draw_scaled, hand_base_y()
  Math scale hand_base_x1(), -draw_scaled, hand_base_x1()
  Math scale hand_base_y1(), draw_scaled, hand_base_y1()
  Math add hand_base_x(), clock_x_pos, hand_base_x()
  Math add hand_base_y(), clock_y_pos, hand_base_y()
  Math add hand_base_x1(), clock_x_pos, hand_base_x1()
  Math add hand_base_y1(), clock_y_pos, hand_base_y1()

  If hand_fc + hand_bc <> 32 Then
    If hand_fc <> 16 Then
      Polygon hand_corners, hand_base_x(), hand_base_y(), hand_bc, hand_fc
    Else
   Polygon hand_corners, hand_base_x(), hand_base_y(), hand_bc
    End If
    If hand_bc1 + hand_fc1 <> 32 Then
   If hand_fc1 <> 16 Then
        Polygon hand_corners, hand_base_x1(), hand_base_y1(), hand_bc1, hand_fc1
      Else
    Polygon hand_corners, hand_base_x1(), hand_base_y1(), hand_bc1
      End If
    End If
  End If
  If hand_cover_bc(object) + hand_cover_fc(object) <> 32 Then
    If hand_cover_fc(object) <> 16 Then
      Circle clock_x_pos, clock_y_pos,hand_cover_radius(object) * draw_scaled, hand_cover_lw(object) * draw_scaled,, hand_cover_bc(object), hand_cover_fc(object)
    Else
      Circle clock_x_pos, clock_y_pos,hand_cover_radius(object) * draw_scaled, hand_cover_lw(object) * draw_scaled,, hand_cover_bc(object)
    End If
    If hand_cover_bc1(object) + hand_cover_fc1(object) <> 32 Then
   If hand_cover_fc1(object) <> 16 Then
    Circle clock_x_pos, clock_y_pos,hand_cover_radius1(object) * draw_scaled, hand_cover_lw1(object) * draw_scaled,, hand_cover_bc1(object), hand_cover_fc1(object)
   Else
    Circle clock_x_pos, clock_y_pos,hand_cover_radius1(object) * draw_scaled, hand_cover_lw1(object) * draw_scaled,, hand_cover_bc1(object)
      End If
    End If
  End If
End Sub

Sub draw_face(object, clock_x_pos, clock_y_pos, draw_scaled, gauge_flag, scale_start, scale_end, c_debug)

  Local float pmin_xoff(1), phour_xoff(1), numbers_xoff(1), hour_poly_x1(5), hour_poly_y1(5), min_poly_x1(5), min_poly_y1(5)

  Local float min_poly_x(5) = (face_min_lw(object)/2, -face_min_lw(object)/2,-face_min_lw1(object)/2, -face_min_lw2(object)/2, face_min_lw2(object)/2,face_min_lw1(object)/2)
  Local float min_poly_y(5) = (face_min_length(object), face_min_length(object), 0, -face_min_length1(object), -face_min_length1(object), 0)

  Local float hour_poly_x(5) = (face_hour_lw(object)/2,-face_hour_lw(object)/2, -face_hour_lw1(object)/2, -face_hour_lw2(object)/2, face_hour_lw2(object)/2, face_hour_lw1(object)/2)
  Local float hour_poly_y(5) = (face_hour_length(object),face_hour_length(object),0,-face_hour_length1(object),-face_hour_length1(object),0)
  Local float min_poly_xt(5), min_poly_yt(5), hour_poly_xt(5), hour_poly_yt(5)
  Local float min_poly_xt1(5), min_poly_yt1(5), hour_poly_xt1(5), hour_poly_yt1(5)

  Local float min_roff = face_min_roff(object) + clock_radius(object) - face_lw(object)
  Local float hour_roff = face_hour_roff(object) + clock_radius(object) - face_lw(object)

  Local float pmin_roff(1) = (face_pmin_roff(object) + clock_radius(object) - face_lw(object), 0)
  Local float phour_roff(1) = (face_phour_roff(object) + clock_radius(object) - face_lw(object), 0)
  Local float phour_xofft(1), phour_rofft(1), pmin_xofft(1), pmin_rofft(1)

  Local integer txt_scale, numbers_scale, txt_font, numbers_font, minute
  Local float txt_x, txt_y, count, angle, wh2, ht2, ratio, min_x, max_x, min_y, max_y
  Local integer fonts_wh(1,10) = (8,12,12,20,16,16,10,16,24,32,32,50,6,8,4,6,8,8,8,8,16,24) 'font sizes 1-8

  If ring_bc(object) + ring_fc(object) <> 32 Then
    If ring_fc(object) <> 16 Then
      Circle clock_x_pos, clock_y_pos, ring_radius(object) * draw_scaled, ring_lw(object) * draw_scaled,, ring_bc(object),ring_fc(object) 'outer ring
    Else
      Circle clock_x_pos, clock_y_pos, ring_radius(object) * draw_scaled, ring_lw(object) * draw_scaled,,, ring_bc(object) 'transparent
    End If
  End If

  If face_bc(object) + face_fc(object) <> 32 Then
    If face_fc(object) <> 16 Then
      Circle clock_x_pos, clock_y_pos, clock_radius(object) * draw_scaled, face_lw(object) * draw_scaled,, face_bc(object), face_fc(object) 'clock face
    Else
      Circle clock_x_pos, clock_y_pos, clock_radius(object) * draw_scaled, face_lw(object) * draw_scaled,,, face_bc(object)
    End If
  End If
  On error skip 1
  If grid_flag Then draw_grid()

  If face_text_bc(object) + face_text_fc(object) + face_numbers_bc(object) + face_numbers_fc(object) <> 64 Then
    If draw_scaled > 0.07 Then
      If draw_scaled < 0.4 Then
        If face_text_bc(object) + face_text_fc(object) <> 32 Then
          If face_text_font(object) <> 0 Then
            txt_x = clock_x_pos + face_text_xoff(object) * draw_scaled
            txt_font = face_text_font(object)
            txt_scale = face_text_scale(object)
          Else
            txt_x = clock_x_pos
            txt_scale = (1 + draw_scaled)^2
            txt_font = 8
          End If
        Else
          txt_font = 16
        End If
        If face_numbers_bc(object) + face_numbers_fc(object) <> 32 Then
          If face_numbers_font(object) <> 0 Then
            numbers_font = face_numbers_font(object)
            numbers_scale = face_numbers_scale(object)
          Else
            numbers_scale = (1 + draw_scaled)^2
            numbers_font = 7
          End If
        Else
          numbers_font = 16
        End If
      Else
        If face_text_bc(object) + face_text_fc(object) <> 32 Then
          If face_text_font(object) <> 0 Then
            txt_x = clock_x_pos + face_text_xoff(object) * draw_scaled
            txt_font = face_text_font(object)
            txt_scale = face_text_scale(object)
          Else
            txt_x = clock_x_pos
            txt_scale = (1 + draw_scaled)^2
            txt_font =7
          End If
        Else
          txt_font = 16
        End If
        If face_numbers_bc(object) + face_numbers_fc(object) <> 32 Then
          If face_numbers_font(object) <> 0 Then
            numbers_font = face_numbers_font(object)
            numbers_scale = face_numbers_scale(object)
          Else
            numbers_scale = (1 + draw_scaled)^2
            numbers_font = 7
          End If
        Else
          numbers_font = 16
        End If
      End If
    Else
      txt_font = 16
      numbers_font = 16
    End If
  Else
    txt_font = 16
    numbers_font = 16
  End If

 txt_y = clock_y_pos - face_text_roff(object) * draw_scaled

  If face_hour_bc(object) + face_hour_fc(object) <> 32 Then
    If face_hour_bc1(object) + face_hour_fc1(object) <> 32 Then
      For count = 0 To 5
        If hour_poly_x(count) < min_x Then min_x = hour_poly_x(count)
        If hour_poly_x(count) > max_x Then max_x = hour_poly_x(count)
        If hour_poly_y(count) < min_y Then min_y = hour_poly_y(count)
        If hour_poly_y(count) > max_y Then max_y = hour_poly_y(count)
      Next count
      ratio = (max_y - min_y) / (max_x - min_x)
      Math scale hour_poly_x(), face_hour_scale1(object)/100, hour_poly_x1()
      Math scale hour_poly_y(), 1 - (1 - face_hour_scale1(object)/100) / ratio, hour_poly_y1()
      Math add hour_poly_y1(), hour_roff, hour_poly_y1()
      Math scale hour_poly_x1(), draw_scaled, hour_poly_x1()
      Math scale hour_poly_y1(), draw_scaled, hour_poly_y1()
      Math add hour_poly_x1(), clock_x_pos, hour_poly_x1()
      Math add hour_poly_y1(), clock_y_pos, hour_poly_y1()
    End If
    Math add hour_poly_y(), hour_roff, hour_poly_y()
    Math scale hour_poly_x(), draw_scaled, hour_poly_x()
    Math scale hour_poly_y(), draw_scaled, hour_poly_y()
    Math add hour_poly_x(), clock_x_pos, hour_poly_x()
    Math add hour_poly_y(), clock_y_pos, hour_poly_y()
  End If

  If face_min_bc(object) + face_min_fc(object) <> 32 Then
    If face_min_bc1(object) + face_min_fc1(object) <> 32 Then
      min_x = 0: max_x = 0: min_y = 0: max_y = 0
      For count = 0 To 5
        If min_poly_x(count) < min_x Then min_x = min_poly_x(count)
        If min_poly_x(count) > max_x Then max_x = min_poly_x(count)
        If min_poly_y(count) < min_y Then min_y = min_poly_y(count)
        If min_poly_y(count) > max_y Then max_y = min_poly_y(count)
      Next count
      ratio = (max_y - min_y) / (max_x - min_x)
      Math scale min_poly_x(), face_min_scale1(object)/100, min_poly_x1()
      Math scale min_poly_y(), 1 - (1 - face_min_scale1(object)/100) / ratio, min_poly_y1()
      Math add min_poly_y1(), min_roff, min_poly_y1()
      Math scale min_poly_x1(), draw_scaled, min_poly_x1()
      Math scale min_poly_y1(), draw_scaled, min_poly_y1()
      Math add min_poly_x1(), clock_x_pos, min_poly_x1()
      Math add min_poly_y1(), clock_y_pos, min_poly_y1()
    End If
    Math add min_poly_y(), min_roff, min_poly_y()
    Math scale min_poly_x(), draw_scaled, min_poly_x()
    Math scale min_poly_y(), draw_scaled, min_poly_y()
    Math add min_poly_x(), clock_x_pos, min_poly_x()
    Math add min_poly_y(), clock_y_pos, min_poly_y()
  End If

  If face_pmin_bc(object) + face_pmin_fc(object) <> 32 Then
    Math scale pmin_roff(), draw_scaled, pmin_roff()
    Math add pmin_xoff(), clock_x_pos, pmin_xoff()
    Math add pmin_roff(), clock_y_pos, pmin_roff()
  End If

  If face_phour_bc(object) + face_phour_fc(object) <> 32 Then
    Math scale phour_roff(), draw_scaled, phour_roff()
    Math add phour_xoff(), clock_x_pos, phour_xoff()
    Math add phour_roff(), clock_y_pos, phour_roff()
  End If

  If face_numbers_bc(object) + face_numbers_fc(object) <> 32 And numbers_font <> 16 Then
    Local float numbers_rx0(1), numbers_ry0(1), s = face_numbers_style(object)

    wh2 = (fonts_wh(0, numbers_font -1)/2) * numbers_scale
    ht2 = (fonts_wh(1, numbers_font -1)/2) * numbers_scale
    numbers_rx0(0) = wh2
    numbers_ry0(0) = Sqr(((clock_radius(object) - ht2 - numbers_scale -5 - face_hour_length1(object) - face_lw(object) + face_numbers_roff(object))^2) - wh2^2)

    If numbers_ry0(0) < ring_radius(object) Then
      Local integer aoff = 0
      Local integer boff = numbers_scale
      Local integer coff = 0
      Local string al$ = "LT"
      Local string al1$ = "RT"
    Else
      Local integer aoff = -2*wh2
      Local integer boff = 0
      Local integer coff = numbers_scale
      Local string al$ = "RT"
      Local string al1$ = "LT"
    End If
    Math scale numbers_rx0(), draw_scaled, numbers_rx0()
    Math scale numbers_ry0(), draw_scaled, numbers_ry0()
    Text clock_x_pos + numbers_ry0(0) + aoff+boff, clock_y_pos - ht2+boff+coff, face_numbers_1to12$(3,s), al1$, numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
    Text clock_x_pos+numbers_scale, clock_y_pos + numbers_ry0(0) -2*ht2+2*boff+2*coff, face_numbers_1to12$(6,s), "CT", numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
    Text clock_x_pos - numbers_ry0(0)-aoff-boff-coff, clock_y_pos -ht2+boff+coff, face_numbers_1to12$(9,s), al$, numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
    Text clock_x_pos, clock_y_pos - numbers_ry0(0) , face_numbers_1to12$(12,s), "CT", numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
    For count = 1 To 2 '7,8
      Math v_rotate 0, 0, -30, numbers_rx0(), numbers_ry0(), numbers_rx0(), numbers_ry0()
      Text clock_x_pos+numbers_rx0(0) +aoff,clock_y_pos -numbers_ry0(0)-ht2+boff+coff , face_numbers_1to12$(count,s), al1$, numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
      Text clock_x_pos+numbers_rx0(0) +aoff,clock_y_pos+numbers_ry0(0)-ht2, face_numbers_1to12$(6-count,s), al1$, numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
      Text clock_x_pos-numbers_rx0(0)-aoff+2*boff+2*coff,clock_y_pos+numbers_ry0(0)-ht2, face_numbers_1to12$(6+count,s), al$, numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
      Text clock_x_pos-numbers_rx0(0)-aoff-boff,clock_y_pos-numbers_ry0(0)-ht2+boff+coff, face_numbers_1to12$(9+ count,s), al$, numbers_font, numbers_scale, face_numbers_bc(object),face_numbers_fc(object)
    Next count
  End If

  For angle = scale_start To scale_end Step 30
    If face_hour_bc(object) + face_hour_fc(object) <> 32 Then 'draw hour label
      Math v_rotate clock_x_pos, clock_y_pos, angle, hour_poly_x(), hour_poly_y(), hour_poly_xt(), hour_poly_yt()
      If face_hour_fc(object) <> 16 Then
         Polygon 6, hour_poly_xt(), hour_poly_yt(), face_hour_bc(object), face_hour_fc(object)
      Else
        Polygon 6, hour_poly_xt(), hour_poly_yt() face_hour_bc(object)
      End If
      If face_hour_bc1(object) + face_hour_fc1(object) <> 32 Then
        Math v_rotate clock_x_pos, clock_y_pos, angle, hour_poly_x1(), hour_poly_y1(), hour_poly_xt1(), hour_poly_yt1()
        If face_hour_fc1(object) <> 16 Then
          Polygon 6, hour_poly_xt1(), hour_poly_yt1(), face_hour_bc1(object), face_hour_fc1(object)
        Else
          Polygon 6, hour_poly_xt1(), hour_poly_yt1() face_hour_bc1(object)
        End If
      End If
    End If
    If face_phour_bc(object) + face_phour_fc(object) <> 32 Then 'draw hour circle
      Math v_rotate clock_x_pos, clock_y_pos, angle, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft()
      If face_phour_fc(object) <> 16 Then
        Circle phour_xofft(0), phour_rofft(0), face_phour_radius(object) * draw_scaled, face_phour_lw(object) * draw_scaled,, face_phour_bc(object), face_phour_fc(object)
      Else
        Circle phour_xofft(0), phour_rofft(0) , face_phour_radius(object) * draw_scaled, face_phour_lw(object) * draw_scaled,, face_phour_bc(object)
      End If
      If  face_phour_bc1(object) + face_phour_fc1(object) <> 32 Then
        If face_phour_fc1(object) <> 16 Then
          Circle phour_xofft(0), phour_rofft(0), face_phour_radius1(object) * draw_scaled, face_phour_lw1(object) * draw_scaled,, face_phour_bc1(object), face_phour_fc1(object)
        Else
          Circle phour_xofft(0), phour_rofft(0) , face_phour_radius1(object) * draw_scaled, face_phour_lw1(object) * draw_scaled,, face_phour_bc1(object)
        End If
      End If
    End If
    If angle < scale_end Then
    For minute = 24 To 6 Step -6
      If face_min_bc(object) + face_min_fc(object) <> 32 Then 'draw minute label
        Math v_rotate clock_x_pos, clock_y_pos, angle + minute, min_poly_x(), min_poly_y(), min_poly_xt(), min_poly_yt()
        If face_min_fc(object) <> 16 Then
          Polygon 6, min_poly_xt(), min_poly_yt(), face_min_bc(object), face_min_fc(object)
        Else
          Polygon 6, min_poly_xt(), min_poly_yt(), face_min_bc(object)
        End If
        If face_min_bc1(object) + face_min_fc1(object) <> 32 Then 'draw minute label
          Math v_rotate clock_x_pos, clock_y_pos, angle + minute, min_poly_x1(), min_poly_y1(), min_poly_xt1(), min_poly_yt1()
          If face_min_fc1(object) <> 16 Then
            Polygon 6, min_poly_xt1(), min_poly_yt1(), face_min_bc1(object), face_min_fc1(object)
          Else
            Polygon 6, min_poly_xt1(), min_poly_yt1(), face_min_bc1(object)
          End If
        End If
      End If
      If face_pmin_bc(object) + face_pmin_fc(object) <> 32 Then 'draw minute circle
        Math v_rotate clock_x_pos, clock_y_pos, angle + minute, pmin_xoff(), pmin_roff(), pmin_xofft(), pmin_rofft()
        If face_pmin_fc(object) <> 16 Then
          Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius(object) * draw_scaled, face_pmin_lw(object) * draw_scaled,, face_pmin_bc(object), face_pmin_fc(object)
        Else
          Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius(object) * draw_scaled, face_pmin_lw(object) * draw_scaled,, face_pmin_bc(object)
        End If
        If  face_pmin_bc1(object) + face_pmin_fc1(object) <> 32 Then
          If face_pmin_fc1(object) <> 16 Then
            Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius1(object) * draw_scaled, face_pmin_lw1(object) * draw_scaled,, face_pmin_bc1(object), face_pmin_fc1(object)
          Else
            Circle pmin_xofft(0), pmin_rofft(0),face_pmin_radius1(object) * draw_scaled, face_pmin_lw1(object) * draw_scaled,, face_pmin_bc1(object)
          End If
        End If
      End If
    Next minute
    End If
  Next angle

  If face_text_bc(object) + face_text_fc(object) <> 32 And txt_font <> 16 Then
    Text txt_x, txt_y, timezone$(object), "C", txt_font, txt_scale, face_text_bc(object), face_text_fc(object)
  End If

End Sub
