  Print #1,"Option explicit"
  Print #1,"dim_myclock()"
  Print #1,"dim integer fn_counter"
  Print #1,"dim value$ LENGTH 20"
  Print #1,""
  Print #1,""
  Print #1,"dim integer gflag = 0 'set to 1 to use gauge mode"
  Print #1,""
  Print #1, "MODE " + Str$(vid_mode)
  Print #1, "Font 1"
  If vid_mode <> 1 Then vid$ = "' "
  Print #1, vid$ + "TILE height MM.FONTHEIGHT"
  Print #1, vid$ + "TILE 0, 0, face_fc(1), face_bc(1), mm.hres / MM.FONTWIDTH, MM.VRES/MM.FONTHEIGHT"
  Print #1,""
  Print #1, "FRAMEBUFFER create"
  Print #1, "FRAMEBUFFER write f"
  Print #1, "if gflag then"
  Print #1, "  for fn_counter = 1 to 12:face_numbers_1to12(fn_counter, face_numbers_style(1)) = " + Chr$(34) + Chr$(34) + ":next fn_counter"
  Print #1, "  face_numbers_1to12(10,face_numbers_style(1)) = " + Chr$(34) + "1" + Chr$(34)
  Print #1, "  face_numbers_1to12(11,face_numbers_style(1)) = " + Chr$(34) + "0" + Chr$(34)
  Print #1, "  face_numbers_1to12(12,face_numbers_style(1)) = " + Chr$(34) + "2" + Chr$(34)
  Print #1, "  face_numbers_1to12(1,face_numbers_style(1)) = " + Chr$(34) + "3" + Chr$(34)
  Print #1, "  face_numbers_1to12(2,face_numbers_style(1)) = " + Chr$(34) + "4" + Chr$(34)
  Print #1, "  face_text_font(1) = 0"
  Print #1, "  face_numbers_font(1) = 0"
  Print #1, "  face_text1$(1) = " + Chr$(34) + "myValue" + Chr$(34)
  Print #1, "end if"
  Print #1, "Do"
  Print #1, "  if gflag then"
  Print #1, " 'VGAclocks(101,MM.HRES/2,MM.VRES/2,MM.VRES/6," + Chr$(34) + "120:240:150" + Chr$(34) + ") 'use this to display as gauge: start:end:value"
  Print #1, "    value$ = " + Chr$(34) + "120:240:" + Chr$(34) " + Str$(120 + 120 * Rnd)"
  Print #1, "    VGAclocks(" + Str$(my_clock+100) + ",MM.HRES/2,MM.VRES/2,mm.vres/6,value$)"
  Print #1, "  else"
  Print #1, "    VGAclocks(" + Str$(my_clock) + ",MM.HRES/2,MM.VRES/2,mm.vres/6,Time$)"
  Print #1, "  end if"
  Print #1, "  FRAMEBUFFER copy f,n"
  Print #1, "Box 0, 0, MM.HRES, MM.HRES -1,, face_fc(1),face_fc(1)"
  Print #1, "Loop"
  Print #1,""
  Print #1,""
  Print #1,""
  Print #1,"*************************************************************************************************************************************************"
  Print #1,"sub dim_myclock()"
  Print #1,"Dim integer clock_amount = " + Str$(my_clock)
  Print #1,"Dim integer counter"
  Print #1,"Dim integer clock_colours(16) = (RGB(black),RGB(blue),RGB(myrtle),RGB(cobalt),RGB(midgreen),RGB(cerulean),RGB(green),RGB(cyan),RGB(red),RGB(magenta),RGB(rust),RGB(fuchsia),RGB(orange),RGB(lilac),RGB(yellow),RGB(white),16)"
'  Print #1,"Dim integer clock_radius" + "(" + Str$(my_clock) + ")"
'  Print #1,"Dim integer scale" + "(" + Str$(my_clock) + ") = (0," + Str$(100) + ")"
  Print #1,"Dim string face_text1$" + "(" + Str$(my_clock) + ") = (" + Chr$(34) + Chr$(34) + "," + Chr$(34) + face_text1$(cc) + Chr$(34) + ")"
  Print #1,"Dim string face_numbers_1to12$(12,5) LENGTH 10"
  Print #1,"Dim float hpx(13), hpy(13), mpx(13), mpy(13), hpx1(13), hpy1(13), mpx1(13),mpy1(13),dr_sc"
  Print #1,"Dim integer indi_done, hour_done, indi_set, indi_mode, set_indi, col_bc, col_fc, col_bc1, col_fc1, build_mode"
'  Print #1,"Dim integer hand_corners_h" + "(" + Str$(my_clock) + ") = (0," + Str$(hand_corners_h(cc)) + ")"
'  Print #1,"Dim integer hand_corners_m" + "(" + Str$(my_clock) + ") = (0," + Str$(hand_corners_m(cc)) + ")"
'  Print #1,"Dim integer hand_corners_s" + "(" + Str$(my_clock) + ") = (0," + Str$(hand_corners_s(cc)) + ")"
  Print #1,"Dim integer hand_corners_xh"+ "(" + Str$(my_clock) + "," + Str$(hand_corners_h(cc)+1) + ")"
  Print #1,"Dim integer hand_corners_yh"+ "(" + Str$(my_clock) + "," + Str$(hand_corners_h(cc)+1) + ")"
  Print #1,"Dim integer hand_corners_xm"+ "(" + Str$(my_clock) + "," + Str$(hand_corners_m(cc)+1) + ")"
  Print #1,"Dim integer hand_corners_ym"+ "(" + Str$(my_clock) + "," + Str$(hand_corners_m(cc)+1) + ")"
  Print #1,"Dim integer hand_corners_xs"+ "(" + Str$(my_clock) + "," + Str$(hand_corners_s(cc)+1) + ")"
  Print #1,"Dim integer hand_corners_ys"+ "(" + Str$(my_clock) + "," + Str$(hand_corners_s(cc)+1) + ")"
HEADER_END:

VGAcD_lib_START:
'*** VGAcD_lib V1.1***
Sub VGAclocks(obj, clock_x_pos, clock_y_pos, draw_scale, base_time$)
  Option angle degrees
  Local integer hr, min, sec, gauge_flag, helper2

  If obj > 100 Then
    Inc obj, -100
    gauge_flag = 1
  End If

  clock_radius(obj) = ring_radius(obj) - ring_lw(obj) - ring_lw1(obj)

  If draw_scale <> 0 Then
    dr_sc = draw_scale / 100
  Else
    dr_sc = scale(obj) / 100
  End If

  If gauge_flag <> 1 Then
    helper2 = Val(Field$(base_time$,1,":")) : Inc helper2, UTC_offset(obj)
    If helper2 < 1 Then Inc helper2, 12
    If helper2 > 12 Then Inc helper2, -12
    base_time$ = Str$(helper2) + ":" + Field$(base_time$,2,":") + ":" + Field$(base_time$,3,":")
  End If

  draw_obj_analog_clock(obj, clock_x_pos, clock_y_pos, gauge_flag, base_time$)
End Sub

Sub draw_grid()
  Local float lwh,ll
  helper = 0 : If menu = 4 Then helper = MM.FONTHEIGHT / 2
  If grid_x <> 0 Then
    For counter = 0 To clock_radius(cc) Step grid_x
      If counter > clock_radius(cc) -1 Then Exit For
      lwh = counter * sc / 100
      ll = Sqr((clock_radius(cc) * sc / 100) ^ 2 - lwh ^ 2)
      Line m_clock_pos + lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT + ll - helper, m_clock_pos + lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT - ll - helper, 1, 0
      Line m_clock_pos - lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT + ll - helper, m_clock_pos - lwh, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT - ll - helper, 1, 0
    Next counter
  End If
  If grid_y <> 0 Then
      For counter = 0 To clock_radius(cc) Step grid_y
      If counter > clock_radius(cc) -1 Then Exit For
      lwh = counter * sc / 100
      ll = Sqr((clock_radius(cc) * sc / 100) ^ 2 - lwh ^ 2)
      Line m_clock_pos + ll, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT + lwh - helper, m_clock_pos - ll, (MM.VRES - MM.FONTHEIGHT) / 2 + lwh + MM.FONTHEIGHT - helper, 1, 0
      Line m_clock_pos + ll, (MM.VRES - MM.FONTHEIGHT) / 2 + MM.FONTHEIGHT - lwh - helper, m_clock_pos - ll, (MM.VRES - MM.FONTHEIGHT) / 2 - lwh + MM.FONTHEIGHT - helper, 1, 0
    Next counter
  End If
End Sub

Sub draw_obj_analog_clock(obj, clock_x_pos, clock_y_pos, gauge_flag, base_time$)
  Local integer hand_num, hand_roff, hand_corners
  Local integer scale_start, scale_end
  Local float hr, min, sec, hand_angle, hand_scale

  hr = Val(Field$(base_time$,1,":"))
  min = Val(Field$(base_time$,2,":"))
  sec = Val(Field$(base_time$,3,":"))

  If gauge_flag = 1 Then
    scale_start = hr
    scale_end = min
  Else
    scale_start = 0
    scale_end = 360
    If hr > 11 Then
      hr = (hr - 12) * 5
    Else
      hr = hr * 5
    End If
  End If

  draw_face(obj, clock_x_pos, clock_y_pos, gauge_flag, scale_start, scale_end)

  If gauge_flag <> 1 Then 'hr
    hand_angle = (hr - 30 +  min / 60 * 5) * -6
    draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, 1, hand_angle, hand_scale_hr1(obj), hand_corners_h(obj), hand_hr_roff(obj), hand_bc_hr(obj), hand_fc_hr(obj), hand_bc_hr1(obj), hand_fc_hr1(obj))

    hand_angle = (min - 30) * -6 'min
    draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, 2, hand_angle, hand_scale_min1(obj), hand_corners_m(obj), hand_min_roff(obj), hand_bc_min(obj), hand_fc_min(obj), hand_bc_min1(obj), hand_fc_min1(obj))
  End If

  hand_num = 3 'sec
  If gauge_flag <> 1 Then
    hand_angle = (sec - 30 ) * -6
  Else
    hand_angle = -sec
  End If
  draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, 3, hand_angle, hand_scale_sec1(obj), hand_corners_s(obj), hand_sec_roff(obj), hand_bc_sec(obj), hand_fc_sec(obj), hand_bc_sec1(obj), hand_fc_sec1(obj))
End Sub

Sub draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, hand_num, hand_angle, hand_scale, hand_corners, hand_roff, hand_bc, hand_fc, hand_bc1, hand_fc1)
  Local float hand_base_x(hand_corners+1), hand_base_y(hand_corners+1), hand_base_x1(hand_corners+1), hand_base_y1(hand_corners+1)
  Local float   ratio_x, ratio_y, max_x, max_y, min_x = 999, min_y = 999
  If gauge_flag <> 1 Then
    If hand_num = 1 Then
      For counter = 0  To hand_corners
        hand_base_x(counter) = hand_corners_xh(obj,counter+1)
        hand_base_y(counter) = hand_corners_yh(obj,counter+1)
      Next counter
    Else If hand_num = 2 Then
      For counter = 0 To hand_corners
        hand_base_x(counter) = hand_corners_xm(obj,counter+1)
        hand_base_y(counter) = hand_corners_ym(obj,counter+1)
      Next counter
    End If
  End If
  If hand_num = 3 Then
    For counter = 0 To hand_corners
      hand_base_x(counter) = hand_corners_xs(obj,counter+1)
      hand_base_y(counter) = hand_corners_ys(obj,counter+1)
    Next counter
  End If

  For counter = 0 To hand_corners + 1
    If hand_base_x(counter) < min_x Then min_x = hand_base_x(counter)
    If hand_base_x(counter) > max_x Then max_x = hand_base_x(counter)
    If hand_base_y(counter) < min_y Then min_y = hand_base_y(counter)
    If hand_base_y(counter) > max_y Then max_y = hand_base_y(counter)
  Next counter
  Local float tx = max_x- min_x
  Local float ty = max_y - min_y
  If tx = 0 Then tx = 1
  If ty = 0 Then ty = 1
  If tx > ty Then
    ratio_x = tx / ty
    ratio_y = 1
  Else
    ratio_x = 1
    ratio_y = ty / tx
  End If

  Math scale hand_base_x(),1-(1-hand_scale/100)/ratio_x, hand_base_x1()
  Math scale hand_base_y(),1-(1-hand_scale/100)/ratio_y, hand_base_y1()
  Math add hand_base_y(),hand_roff, hand_base_y()
  Math add hand_base_y1(),hand_roff, hand_base_y1()
  Math v_rotate 0, 0, hand_angle, hand_base_x(), hand_base_y(), hand_base_x() , hand_base_y()
  Math v_rotate 0, 0, hand_angle, hand_base_x1(), hand_base_y1(), hand_base_x1() , hand_base_y1()
  Math scale hand_base_x(), -dr_sc, hand_base_x()
  Math scale hand_base_y(), dr_sc, hand_base_y()
  Math scale hand_base_x1(), -dr_sc, hand_base_x1()
  Math scale hand_base_y1(), dr_sc, hand_base_y1()
  Math add hand_base_x(), clock_x_pos, hand_base_x()
  Math add hand_base_y(), clock_y_pos, hand_base_y()
  Math add hand_base_x1(), clock_x_pos, hand_base_x1()
  Math add hand_base_y1(), clock_y_pos, hand_base_y1()

  If hand_fc + hand_bc <> 32 Then
    If hand_fc <> 16 Then
      Polygon hand_corners, hand_base_x(), hand_base_y(), hand_bc, hand_fc
    Else
   Polygon hand_corners, hand_base_x(), hand_base_y(), hand_bc
    End If
    If hand_bc1 + hand_fc1 <> 32 Then
   If hand_fc1 <> 16 Then
        Polygon hand_corners, hand_base_x1(), hand_base_y1(), hand_bc1, hand_fc1
      Else
    Polygon hand_corners, hand_base_x1(), hand_base_y1(), hand_bc1
      End If
    End If
  End If
  If hand_cover_bc(obj) + hand_cover_fc(obj) <> 32 Then
    If hand_cover_fc(obj) <> 16 Then
      Circle clock_x_pos, clock_y_pos,hand_cover_radius(obj) * dr_sc, hand_cover_lw(obj) * dr_sc,, hand_cover_bc(obj), hand_cover_fc(obj)
    Else
      Circle clock_x_pos, clock_y_pos,hand_cover_radius(obj) * dr_sc, hand_cover_lw(obj) * dr_sc,, hand_cover_bc(obj)
    End If
    If hand_cover_bc1(obj) + hand_cover_fc1(obj) <> 32 Then
      If hand_cover_fc1(obj) <> 16 Then
        Circle clock_x_pos, clock_y_pos,hand_cover_radius1(obj) * dr_sc, hand_cover_lw1(obj) * dr_sc,, hand_cover_bc1(obj), hand_cover_fc1(obj)
      Else
        Circle clock_x_pos, clock_y_pos,hand_cover_radius1(obj) * dr_sc, hand_cover_lw1(obj) * dr_sc,, hand_cover_bc1(obj)
      End If
    End If
  End If
End Sub

Sub build_label(obj, hand_nbr, flag, clock_x_pos, clock_y_pos)
Local float ratio_x, ratio_y, tx, ty, roff, tester, buildx(13), buildy(13), conv(3,1)
  Local float  max_x = 0, max_y = 0, min_x = 999, min_y = 999
  Local integer pcorners

  Select Case hand_nbr
  Case 0
  build_mode = face_hour_build_mode(obj)
  roff = face_hour_roff(obj)
  conv(0,0) = face_hour_w(obj)
  conv(0,1) = face_hour_h(obj)
  conv(1,0) = face_hour_w1(obj)
  conv(1,1) = face_hour_h1(obj)
  conv(2,0) = face_hour_w2(obj)
  conv(2,1) = face_hour_h2(obj)
  conv(3,0) = face_hour_w3(obj)
  conv(3,1) = face_hour_h3(obj)
  Case 1
  build_mode = face_min_build_mode(obj)
  roff = face_min_roff(obj)
  conv(0,0) = face_min_w(obj)
  conv(0,1) = face_min_h(obj)
  conv(1,0) = face_min_w1(obj)
  conv(1,1) = face_min_h1(obj)
  conv(2,0) = face_min_w2(obj)
  conv(2,1) = face_min_h2(obj)
  conv(3,0) = face_min_w3(obj)
  conv(3,1) = face_min_h3(obj)
  Case 3
  build_mode= face_indi3_build_mode(obj)
  roff = face_indi3_roff(obj)
  conv(0,0) = face_indi3_w(obj)
  conv(0,1) = face_indi3_h(obj)
  conv(1,0) = face_indi3_w1(obj)
  conv(1,1) = face_indi3_h1(obj)
  conv(2,0) = face_indi3_w2(obj)
  conv(2,1) = face_indi3_h2(obj)
  conv(3,0) = face_indi3_w3(obj)
  conv(3,1) = face_indi3_h3(obj)
  Case 6
  build_mode = face_indi6_build_mode(obj)
  roff = face_indi6_roff(obj)
  conv(0,0) = face_indi6_w(obj)
  conv(0,1) = face_indi6_h(obj)
  conv(1,0) = face_indi6_w1(obj)
  conv(1,1) = face_indi6_h1(obj)
  conv(2,0) = face_indi6_w2(obj)
  conv(2,1) = face_indi6_h2(obj)
  conv(3,0) = face_indi6_w3(obj)
  conv(3,1) = face_indi6_h3(obj)
  Case 9
  build_mode = face_indi9_build_mode(obj)
  roff = face_indi9_roff(obj)
  conv(0,0) = face_indi9_w(obj)
  conv(0,1) = face_indi9_h(obj)
  conv(1,0) = face_indi9_w1(obj)
  conv(1,1) = face_indi9_h1(obj)
  conv(2,0) = face_indi9_w2(obj)
  conv(2,1) = face_indi9_h2(obj)
  conv(3,0) = face_indi9_w3(obj)
  conv(3,1) = face_indi9_h3(obj)
  Case 12
  build_mode = face_indi12_build_mode(obj)
  roff = face_indi12_roff(obj)
  conv(0,0) = face_indi12_w(obj)
  conv(0,1) = face_indi12_h(obj)
  conv(1,0) = face_indi12_w1(obj)
  conv(1,1) = face_indi12_h1(obj)
  conv(2,0) = face_indi12_w2(obj)
  conv(2,1) = face_indi12_h2(obj)
  conv(3,0) = face_indi12_w3(obj)
  conv(3,1) = face_indi12_h3(obj)
  End Select

  roff = roff + clock_radius(obj) + face_lw(obj)

  Select Case build_mode
  Case 0 'Triangle
    pcorners = 3
    buildx(0) = -conv(0,0)
    buildy(0) = conv(0,1)
    buildx(1) = 0
    buildy(1) = -conv(0,1) * 2
    buildx(2) = conv(0,0)
    buildy(2) = conv(0,1)
  Case 1 'box
    pcorners = 4
    buildx(0) = -conv(0,0)
    buildy(0) = -conv(0,1)
    buildx(1) = -conv(0,0)
    buildy(1) = conv(0,1)
    buildx(2) = conv(0,0)
    buildy(2) = conv(0,1)
    buildx(3) = conv(0,0)
    buildy(3) = -conv(0,1)
  Case 2 'symetrical x
    pcorners = 8
    buildx(0) = -conv(0,0)
    buildy(0) = conv(0,1) * 2
    buildx(1) = -conv(1,0)
    buildy(1) = -conv(1,1)
    buildx(2) = -conv(2,0)
    buildy(2) = -conv(2,1)
    buildx(3) = -conv(3,0)
    buildy(3) = -conv(3,1)
    For counter = 0 To 3
      buildx(7 - counter) = -buildx(counter)
      buildy(7 - counter) = buildy(counter)
    Next counter
  Case 3 'mirror symmetrical
    pcorners = 14
    For counter= 1 To 3
      buildx(counter) = -conv(counter,0)
      buildy(counter) = -conv(counter,1)
      buildx(14 - counter) = -conv(counter,0)
      buildy(14 - counter) = conv(counter,1)
      buildx(7 - counter) = conv(counter,0)
      buildy(7 - counter) = -conv(counter,1)
      buildx(7 + counter) = conv(counter,0)
      buildy(7 + counter) = conv(counter,1)
    Next counter
    buildx(0) = -conv(0,0)
    buildy(0) = -conv(0,1)
    buildx(7) = conv(0,0)
    buildy(7) = -conv(0,1)
  End Select

  Select Case hand_nbr
  Case 0, 3, 6, 9, 12
    Math scale buildx(), dr_sc, hpx()
    Math scale buildy(), dr_sc, hpy()
    Math add hpy(), roff * dr_sc, hpy()
    Math add hpx(), clock_x_pos,  hpx()
    Math add hpy(), clock_y_pos, hpy()
  Case 1
    Math scale buildx(), dr_sc, mpx()
    Math scale buildy(), dr_sc, mpy()
    Math add mpy(), roff * dr_sc, mpy()
    Math add mpx(), clock_x_pos,  mpx()
    Math add mpy(), clock_y_pos, mpy()
  End Select

  If flag Then
    For counter = 0 To pcorners -1
      If  buildx(counter) < min_x Then min_x = buildx(counter)
      If  buildx(counter)  > max_x Then max_x = buildx(counter)
      If  buildy(counter) < min_y Then min_y = buildy(counter)
      If  buildy(counter) > max_y Then max_y = buildy(counter)
    Next counter
     tx = max_x - min_x
     ty = max_y - min_y
    If tx = 0 Then tx = 1
    If ty = 0 Then ty = 1
    If tx > ty Then
      ratio_x = ty / tx
      ratio_y = 1
    Else
      ratio_x = 1
      ratio_y = tx / ty
    End If

    Select Case hand_nbr
    Case 0
      Math scale buildx(), 1 - (1-  face_hour_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  face_hour_scale1(obj)/100) * ratio_y), hpy1()
    Case 1
      Math scale buildx(), 1 - (1-  face_min_scale1(obj)/100) * ratio_x), mpx1()
      Math scale buildy(), 1 - (1-  face_min_scale1(obj)/100) * ratio_y), mpy1()
    Case 3
      Math scale buildx(), 1 - (1-  face_indi3_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  face_indi3_scale1(obj)/100) * ratio_y), hpy1()
    Case 6
      Math scale buildx(), 1 - (1-  face_indi6_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  face_indi6_scale1(obj)/100) * ratio_y), hpy1()
    Case 9
      Math scale buildx(), 1 - (1-  face_indi9_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  face_indi9_scale1(obj)/100) * ratio_y), hpy1()
    Case 12
      Math scale buildx(), 1 - (1-  face_indi12_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  face_indi12_scale1(obj)/100) * ratio_y), hpy1()
    End Select

    Select Case hand_nbr
    Case 0, 3, 6, 9, 12
      Math scale hpx1(), dr_sc, hpx1()
      Math scale hpy1(), dr_sc, hpy1()
      Math add hpy1(), roff * dr_sc, hpy1()
      Math add hpx1(), clock_x_pos, hpx1()
      Math add hpy1(), clock_y_pos, hpy1()
    Case 1
      Math scale mpx1(), 1 - (1-  face_min_scale1(obj)/100) * ratio_x), mpx1()
      Math scale mpy1(), 1 - (1-  face_min_scale1(obj)/100) * ratio_y), mpy1()
      Math scale mpx1(), dr_sc, mpx1()
      Math scale mpy1(), dr_sc, mpy1()
      Math add mpy1(), roff * dr_sc, mpy1()
      Math add mpx1(), clock_x_pos, mpx1()
      Math add mpy1(), clock_y_pos, mpy1()
    End Select
  End If
End Sub

Sub draw_face(obj, clock_x_pos, clock_y_pos, gauge_flag, scale_start, scale_end)

  Local float pmin_xoff(1), phour_xoff(1), numbers_xoff(1)
  Local float print_px(13), print_py(13)

  Local float min_roff = face_min_roff(obj) + clock_radius(obj) - face_lw(obj)
  Local float hour_roff = face_hour_roff(obj) + clock_radius(obj) - face_lw(obj)

  Local float pmin_roff(1) = (face_pmin_roff(obj) + clock_radius(obj) - face_lw(obj), 0)
  Local float phour_roff(1) = (face_phour_roff(obj) + clock_radius(obj) - face_lw(obj), 0)
  Local float phour_xofft(1), phour_rofft(1), pmin_xofft(1), pmin_rofft(1)

  Local integer fonts_wh(1,15) = (8,12,12,20,16,16,10,16,24,32,32,50,6,8,4,6,8,8,8,8,16,24,16,16,16,16,16,16,16,32,16,22) 'font sizes 1-8

  Local integer txt_scale, numbers_scale, txt_font, numbers_font, min_angle, counter1
  Local float txt_x, txt_y, count, angle, wh2, ht2, helper2
  Local string helper1$,h1$,h2$

  build_mode = 0 : set_indi = 0 : indi_mode = 0 : indi_done = 0 : hour_done = 0

  If face_pmin_bc(obj) + face_pmin_fc(obj) <> 32 Then 'circle min
    Math scale pmin_roff(), dr_sc, pmin_roff()
    Math add pmin_xoff(), clock_x_pos, pmin_xoff()
    Math add pmin_roff(), clock_y_pos, pmin_roff()
  End If

  If face_phour_bc(obj) + face_phour_fc(obj) <> 32 Then 'circle hour
    Math scale phour_roff(), dr_sc, phour_roff()
    Math add phour_xoff(), clock_x_pos, phour_xoff()
    Math add phour_roff(), clock_y_pos, phour_roff()
  End If

  If ring_bc(obj) + ring_fc(obj) <> 32 Then 'draw face
    If ring_fc(obj) <> 16 Then
      Circle clock_x_pos, clock_y_pos, ring_radius(obj) * dr_sc, ring_lw(obj) * dr_sc,, ring_bc(obj),ring_fc(obj) 'outer ring
    Else
      Circle clock_x_pos, clock_y_pos, ring_radius(obj) * dr_sc, ring_lw(obj) * dr_sc,,, ring_bc(obj) 'transparent
    End If
  End If
  If face_bc(obj) + face_fc(obj) <> 32 Then
    If face_fc(obj) <> 16 Then
      Circle clock_x_pos, clock_y_pos, clock_radius(obj) * dr_sc, face_lw(obj) * dr_sc,, face_bc(obj), face_fc(obj) 'clock face
    Else
      Circle clock_x_pos, clock_y_pos, clock_radius(obj) * dr_sc, face_lw(obj) * dr_sc,,, face_bc(obj)
    End If
  End If

  On error skip 1 'draw grid
  If grid_flag Then draw_grid()

  If face_text_bc(obj) + face_text_fc(obj) + face_numbers_bc(obj) + face_numbers_fc(obj) <> 64 Then 'calc position/scale/font numbers and text
    If dr_sc > 0.07 Then
      If dr_sc < 0.4 Then
        If face_text_bc(obj) + face_text_fc(obj) <> 32 Then
          If face_text_font(obj) <> 0 Then
            txt_x = clock_x_pos + face_text_xoff(obj) * dr_sc
            txt_font = face_text_font(obj)
            txt_scale = face_text_scale(obj)
          Else
            txt_x = clock_x_pos
            txt_scale = (1 + dr_sc)^2
            txt_font = 8
          End If
        Else
          txt_font = 16
        End If
        If face_numbers_bc(obj) + face_numbers_fc(obj) <> 32 Then
          If face_numbers_font(obj) <> 0 Then
            numbers_font = face_numbers_font(obj)
            numbers_scale = face_numbers_scale(obj)
          Else
            numbers_scale = (1 + dr_sc)^2
            numbers_font = 7
          End If
        Else
          numbers_font = 16
        End If
      Else
        If face_text_bc(obj) + face_text_fc(obj) <> 32 Then
          If face_text_font(obj) <> 0 Then
            txt_x = clock_x_pos + face_text_xoff(obj) * dr_sc
            txt_font = face_text_font(obj)
            txt_scale = face_text_scale(obj)
          Else
            txt_x = clock_x_pos
            txt_scale = (1 + dr_sc)^2
            txt_font =7
          End If
        Else
          txt_font = 16
        End If
        If face_numbers_bc(obj) + face_numbers_fc(obj) <> 32 Then
          If face_numbers_font(obj) <> 0 Then
            numbers_font = face_numbers_font(obj)
            numbers_scale = face_numbers_scale(obj)
          Else
            numbers_scale = (1 + dr_sc)^2
            numbers_font = 7
          End If
        Else
          numbers_font = 16
        End If
      End If
    Else
      txt_font = 16
      numbers_font = 16
    End If
  Else
    txt_font = 16
    numbers_font = 16
  End If

  If txt_scale > 15 Then txt_scale = 15
  If numbers_scale > 15 Then numbers_scale = 15
  txt_y = clock_y_pos - face_text_roff(obj) * dr_sc

  If face_numbers_bc(obj) + face_numbers_fc(obj) <> 32 And numbers_font <> 16 Then 'calc offset, allignment, position
    Local float numbers_rx0(1), numbers_ry0(1), s = face_numbers_style(obj)
    wh2 = (fonts_wh(0, numbers_font -1)/2) * numbers_scale
    ht2 = (fonts_wh(1, numbers_font -1)/2) * numbers_scale
    numbers_rx0(0) = wh2
    numbers_ry0(0) = Sqr(((clock_radius(obj)+face_numbers_roff(obj)+face_hour_roff(obj) - face_hour_h3(obj))^2) - wh2^2)

    If numbers_ry0(0) < ring_radius(obj) Then
      Local integer aoff = 0
      Local integer boff = numbers_scale
      Local integer coff = 0
      Local string al$ = "LT"
      Local string al1$ = "RT"
    Else
      Local integer aoff = -2 * wh2
      Local integer boff = 0
      Local integer coff = numbers_scale
      Local string al$ = "RT"
      Local string al1$ = "LT"
    End If

    Math scale numbers_rx0(), dr_sc, numbers_rx0() 'print numbers
    Math scale numbers_ry0(), dr_sc, numbers_ry0()
    Text clock_x_pos + numbers_ry0(0) + aoff+boff, clock_y_pos - ht2+boff+coff, face_numbers_1to12$(3,s), al1$, numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
    Text clock_x_pos+numbers_scale, clock_y_pos + numbers_ry0(0) -2*ht2+2*boff+2*coff, face_numbers_1to12$(6,s), "CT", numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
    Text clock_x_pos - numbers_ry0(0)-aoff-boff-coff, clock_y_pos -ht2+boff+coff, face_numbers_1to12$(9,s), al$, numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
    Text clock_x_pos, clock_y_pos - numbers_ry0(0) , face_numbers_1to12$(12,s), "CT", numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
    For count = 1 To 2 '7,8
      Math v_rotate 0, 0, -30, numbers_rx0(), numbers_ry0(), numbers_rx0(), numbers_ry0()
      Text clock_x_pos+numbers_rx0(0) +aoff,clock_y_pos -numbers_ry0(0)-ht2+boff+coff , face_numbers_1to12$(count,s), al1$, numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
      Text clock_x_pos+numbers_rx0(0) +aoff,clock_y_pos+numbers_ry0(0)-ht2, face_numbers_1to12$(6-count,s), al1$, numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
      Text clock_x_pos-numbers_rx0(0)-aoff+2*boff+2*coff,clock_y_pos+numbers_ry0(0)-ht2, face_numbers_1to12$(6+count,s), al$, numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
      Text clock_x_pos-numbers_rx0(0)-aoff-boff,clock_y_pos-numbers_ry0(0)-ht2+boff+coff, face_numbers_1to12$(9+ count,s), al$, numbers_font, numbers_scale, face_numbers_bc(obj),face_numbers_fc(obj)
    Next count
  End If

  If face_min_bc(obj) + face_min_fc(obj) <> 32 Then
    If face_min_bc1(obj) + face_min_fc1(obj) <> 32 Then
      build_label(obj, 1, 1, clock_x_pos, clock_y_pos)
    Else
      build_label(obj, 1, 0, clock_x_pos, clock_y_pos)
  End If
  End If

  If face_indi6_style(obj) <> 2 Then build_hour(obj, clock_x_pos, clock_y_pos)

  For angle = scale_start To scale_end -30 Step 30 'prepare labels and rotate/print to hour positions

    Select Case angle
    Case 0
      indi_mode = face_indi6_style(obj)
      set_indi = 6
    Case 90
      indi_mode = face_indi9_style(obj)
      set_indi = 9
    Case 180
      indi_mode = face_indi12_style(obj)
      set_indi = 12
    Case 270
      indi_mode = face_indi3_style(obj)
      set_indi = 3
    Case Else
      indi_mode = 1
      indi_set = 0
    End Select

    Select Case indi_mode
    Case 0
      indi_done = 1
      hour_done = 1
      indi_set = 0
    Case 1
      If face_hour_bc(obj) + face_hour_fc(obj) <> 32 Then
        hour_done = 1
      Else
        hour_done = 0
      End If
      indi_done = 0
      indi_set = 0
    Case 2,3,4,5,6
      hour_done = 0
      build_indi(obj, set_indi, clock_x_pos, clock_y_pos)
      indi_set = 1 : If Not indi_done Then indi_set = 0
      If indi_mode = 4 Then draw_indi_circle(obj, angle, set_indi, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
      If indi_mode = 6 Then draw_hour_circle(obj, angle, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
      End If
    End Select

    If hour_done + indi_done = 1 Then 'draw hour label
      If hour_done Then
        draw_label(obj,angle, 0, 0, clock_x_pos, clock_y_pos)
      Else
        draw_label(obj,angle, set_indi, 0, clock_x_pos, clock_y_pos)
      End If
    End If

    If indi_mode = 1 Or indi_mode = 3 Then draw_hour_circle(obj, angle, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())

    If indi_mode = 5 Then draw_indi_circle(obj, angle, set_indi, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())

    If indi_set Then build_hour(obj, clock_x_pos, clock_y_pos) : indi_set = 0 : indi_mode = 0

    If angle < scale_end Then ' draw minutes
      For min_angle = 24 To 6 Step -6
        draw_label(obj,angle + min_angle, 1, 1, clock_x_pos, clock_y_pos) 'draw minute label
        If face_pmin_bc(obj) + face_pmin_fc(obj) <> 32 Then 'draw minute circle
          Math v_rotate clock_x_pos, clock_y_pos, angle + min_angle, pmin_xoff(), pmin_roff(), pmin_xofft(), pmin_rofft()
          If face_pmin_fc(obj) <> 16 Then
            Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius(obj) * dr_sc, face_pmin_lw(obj) * dr_sc,, face_pmin_bc(obj), face_pmin_fc(obj)
          Else
            Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius(obj) * dr_sc, face_pmin_lw(obj) * dr_sc,, face_pmin_bc(obj)
          End If
          If  face_pmin_bc1(obj) + face_pmin_fc1(obj) <> 32 Then 'draw minute1 circle
            If face_pmin_fc1(obj) <> 16 Then
              Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius1(obj) * dr_sc, face_pmin_lw1(obj) * dr_sc,, face_pmin_bc1(obj), face_pmin_fc1(obj)
            Else
              Circle pmin_xofft(0), pmin_rofft(0),face_pmin_radius1(obj) * dr_sc, face_pmin_lw1(obj) * dr_sc,, face_pmin_bc1(obj)
            End If
          End If
        End If
      Next min_angle
    End If
  Next angle

  If face_text_bc(obj) + face_text_fc(obj) <> 32 And txt_font <> 16 Then
    Text txt_x, txt_y, face_text1$(obj), "C", txt_font, txt_scale, face_text_bc(obj), face_text_fc(obj)
  End If
End Sub

Sub draw_hour_circle(obj, angle, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
    If face_phour_bc(obj) + face_phour_fc(obj) <> 32 Then 'draw hour circle
      Math v_rotate clock_x_pos, clock_y_pos, angle, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft()
      If face_phour_fc(obj) <> 16 Then
        Circle phour_xofft(0), phour_rofft(0), face_phour_radius(obj) * dr_sc, face_phour_lw(obj) * dr_sc,, face_phour_bc(obj), face_phour_fc(obj)
      Else
        Circle phour_xofft(0), phour_rofft(0) , face_phour_radius(obj) * dr_sc, face_phour_lw(obj) * dr_sc,, face_phour_bc(obj)
      End If
      If  face_phour_bc1(obj) + face_phour_fc1(obj) <> 32 Then
        If face_phour_fc1(obj) <> 16 Then
           Circle phour_xofft(0), phour_rofft(0), face_phour_radius1(obj) * dr_sc, face_phour_lw1(obj) * dr_sc,, face_phour_bc1(obj), face_phour_fc1(obj)
        Else
          Circle phour_xofft(0), phour_rofft(0) , face_phour_radius1(obj) * dr_sc, face_phour_lw1(obj) * dr_sc,, face_phour_bc1(obj)
        End If
      End If
    End If
  End Sub

Sub build_hour(obj, clock_x_pos, clock_y_pos)
  If face_hour_bc(obj) + face_hour_fc(obj) <> 32 Then
    hour_done = 1
    If face_hour_bc1(obj) + face_hour_fc1(obj) <> 32 Then
      build_label(obj, 0, 1, clock_x_pos, clock_y_pos)
    Else
      build_label(obj, 0, 0, clock_x_pos, clock_y_pos)
    End If
  Else
    hour_done = 0
  End If
End Sub

Sub build_indi(obj, set_indi, clock_x_pos, clock_y_pos)
  set_label_colour(obj, set_indi)
  If col_bc + col_fc <> 32 Then
    indi_done = 1
    If col_bc1 + col_fc1 <> 32 Then
      build_label(obj, set_indi, 1, clock_x_pos, clock_y_pos)
    Else
      build_label(obj, set_indi, 0, clock_x_pos, clock_y_pos)
    End If
  Else
    indi_done = 0
  End If
End Sub

Sub draw_label(obj,d_angle, lnbr, label, clock_x_pos, clock_y_pos)
  Local integer print_px(13), print_py(13)
  Local integer pcorners

  set_label_colour(obj, lnbr)

  Select Case build_mode
  Case 0
    pcorners = 3
  Case 1
    pcorners = 4
  Case 2
    pcorners = 8
  Case 3
    pcorners = 14
  End Select

  If col_fc + col_bc <> 32 Then
    If Not label Then
      Math v_rotate clock_x_pos, clock_y_pos, d_angle, hpx(), hpy(), print_px(), print_py()
    Else
      Math v_rotate clock_x_pos, clock_y_pos, d_angle, mpx(), mpy(), print_px(), print_py()
    End If
    If col_fc <> 16 Then
      Polygon pcorners, print_px(), print_py(), col_bc, col_fc
    Else
      Polygon pcorners, print_px(), print_py(), col_bc
    End If
    If col_bc1 + col_fc1 <> 32 Then 'draw hour1 label
      If label Then
        Math v_rotate clock_x_pos, clock_y_pos, d_angle, mpx1(), mpy1(), print_px(), print_py()
      Else
        Math v_rotate clock_x_pos, clock_y_pos, d_angle, hpx1(), hpy1(), print_px(), print_py()
      End If
      If col_fc1 <> 16 Then
        Polygon pcorners, print_px(), print_py(), col_bc1, col_fc1
      Else
        Polygon pcorners, print_px(), print_py(), col_bc1
      End If
    End If
  End If
End Sub

Sub set_label_colour(obj, hand_nbr)
  Select Case hand_nbr
  Case 0
    build_mode = face_hour_build_mode(obj)
    col_bc = face_hour_bc(obj)
    col_fc = face_hour_fc(obj)
    col_bc1 = face_hour_bc1(obj)
    col_fc1 = face_hour_fc1(obj)
  Case 1
    build_mode = face_min_build_mode(obj)
    col_bc = face_min_bc(obj)
    col_fc = face_min_fc(obj)
    col_bc1 = face_min_bc1(obj)
    col_fc1 = face_min_fc1(obj)
  Case 3
    build_mode = face_indi3_build_mode(obj)
    col_bc = face_indi3_bc(obj)
    col_fc = face_indi3_fc(obj)
    col_bc1 = face_indi3_bc1(obj)
    col_fc1 = face_indi3_fc1(obj)
  Case 6
    build_mode = face_indi6_build_mode(obj)
    col_bc = face_indi6_bc(obj)
    col_fc = face_indi6_fc(obj)
    col_bc1 = face_indi6_bc1(obj)
    col_fc1 = face_indi6_fc1(obj)
  Case 9
    build_mode = face_indi9_build_mode(obj)
    col_bc = face_indi9_bc(obj)
    col_fc = face_indi9_fc(obj)
    col_bc1 = face_indi9_bc1(obj)
    col_fc1 = face_indi9_fc1(obj)
  Case 12
    build_mode = face_indi12_build_mode(obj)
    col_bc = face_indi12_bc(obj)
    col_fc = face_indi12_fc(obj)
    col_bc1 = face_indi12_bc1(obj)
    col_fc1 = face_indi12_fc1(obj)
  End Select
End Sub

Sub draw_indi_circle(obj, angle, hand_nbr, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
  Local float  w, h, w1, h1, lw, lw1, roff, al, bc, fc, bc1, fc1
  Select Case hand_nbr
  Case 3
    w = face_cir3_w(obj)
    h = face_cir3_h(obj)
    w1 = face_cir3_w1(obj)
    h1 = face_cir3_h1(obj)
    lw = face_cir3_lw(obj)
    lw1 = face_cir3_lw1(obj)
    roff = face_cir3_roff(obj)
    bc = face_cir3_bc(obj)
    fc = face_cir3_fc(obj)
    bc1 = face_cir3_bc1(obj)
    fc1 = face_cir3_fc1(obj)
  Case 6
    w = face_cir6_w(obj)
    h = face_cir6_h(obj)
    w1 = face_cir6_w1(obj)
    h1 = face_cir6_h1(obj)
    lw = face_cir6_lw(obj)
    lw1 = face_cir6_lw1(obj)
    roff = face_cir6_roff(obj)
    bc = face_cir6_bc(obj)
    fc = face_cir6_fc(obj)
    bc1 = face_cir6_bc1(obj)
    fc1 = face_cir6_fc1(obj)
  Case 9
    w = face_cir9_w(obj)
    h = face_cir9_h(obj)
    w1 = face_cir9_w1(obj)
    h1 = face_cir9_h1(obj)
    lw = face_cir9_lw(obj)
    lw1 = face_cir9_lw1(obj)
    roff = face_cir9_roff(obj)
    bc = face_cir9_bc(obj)
    fc = face_cir9_fc(obj)
    bc1 = face_cir9_bc1(obj)
    fc1 = face_cir9_fc1(obj)
  Case 12
    w = face_cir12_radius(obj)
    h = face_cir12_allignment(obj)
    w1 = face_cir12_radius1(obj)
    h1 = face_cir12_allignment1(obj)
    lw = face_cir12_lw(obj)
    lw1 = face_cir12_lw1(obj)
    roff = face_cir12_roff(obj)
    bc = face_cir12_bc(obj)
    fc = face_cir12_fc(obj)
    bc1 = face_cir12_bc1(obj)
    fc1 = face_cir12_fc1(obj)
End Select

  If w = 0 Then w = 0.1
  al = h / w
  phour_xoff(1) = clock_x_pos
  phour_roff(1) = clock_y_pos + (clock_radius(obj) - face_lw(obj) + roff) * dr_sc
  If fc + bc <> 32 Then
    Math v_rotate clock_x_pos, clock_y_pos, angle, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft()
    If fc <> 16 Then
      Circle phour_xofft(1), phour_rofft(1), w * dr_sc, lw * dr_sc, al, bc, fc
    Else
      Circle phour_xofft(1), phour_rofft(1), w * dr_sc, lw * dr_sc, al, bc
    End If
    If w1 = 0 Then w1 = 0.1 : al = h1 / w1
    If bc1 + fc1<> 32 Then
      If fc1 <> 16 Then
        Circle phour_xofft(1), phour_rofft(1), w1 * dr_sc, lw1 * dr_sc, al, bc1, fc1
      Else
        Circle phour_xofft(1), phour_rofft(1), w1 * dr_sc, lw1 * dr_sc, al, bc1
      End If
    End If
  End If
End Sub
VGAcD_lib_END:
